/*
 * Decompiled with CFR 0.152.
 */
package mdemangler;

import java.util.ArrayList;
import java.util.List;
import mdemangler.MDException;
import mdemangler.datatype.MDDataType;

public class MDContext {
    private List<String> backrefNames = new ArrayList<String>();
    private List<MDDataType> backrefParametersMDDataType = new ArrayList<MDDataType>();
    private List<MDDataType> backrefTemplateParametersMDDataType = new ArrayList<MDDataType>();

    public MDContext(MDContext copyFrom, MDContextType context) {
        switch (context.ordinal()) {
            case 0: {
                this.backrefNames = copyFrom.backrefNames;
                this.backrefParametersMDDataType = copyFrom.backrefParametersMDDataType;
                this.backrefTemplateParametersMDDataType = copyFrom.backrefTemplateParametersMDDataType;
                break;
            }
            case 1: {
                this.backrefNames = copyFrom.backrefNames;
                this.backrefParametersMDDataType = copyFrom.backrefParametersMDDataType;
                this.backrefTemplateParametersMDDataType = copyFrom.backrefTemplateParametersMDDataType;
                break;
            }
            case 2: {
                this.backrefNames = new ArrayList<String>();
                this.backrefParametersMDDataType = new ArrayList<MDDataType>();
                this.backrefTemplateParametersMDDataType = copyFrom.backrefTemplateParametersMDDataType;
            }
        }
    }

    public MDContext() {
    }

    public void addBackrefName(String name) {
        this.backrefNames.add(name);
    }

    public String getBackrefName(int index) throws MDException {
        if (index >= this.backrefNames.size() || index < 0) {
            throw new MDException("Backref Names stack violation");
        }
        return this.backrefNames.get(index);
    }

    public void addBackrefFunctionParameterMDDataType(MDDataType dt) {
        this.backrefParametersMDDataType.add(dt);
    }

    public void addBackrefTemplateParameterMDDataType(MDDataType dt) {
        this.backrefTemplateParametersMDDataType.add(dt);
    }

    public MDDataType getBackrefFunctionParameterMDDataType(int index) throws MDException {
        if (index >= this.backrefParametersMDDataType.size() || index < 0) {
            throw new MDException("Parameter stack violation");
        }
        return this.backrefParametersMDDataType.get(index);
    }

    public MDDataType getBackrefTemplateParameterMDDataType(int index) throws MDException {
        if (index >= this.backrefTemplateParametersMDDataType.size() || index < 0) {
            throw new MDException("Template parameter stack violation");
        }
        return this.backrefTemplateParametersMDDataType.get(index);
    }

    public static enum MDContextType {
        MODIFIER,
        FUNCTION,
        TEMPLATE;

    }
}

