/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.util;

import ghidra.program.model.listing.Function;
import ghidra.program.util.ProgramChangeRecord;
import ghidra.program.util.ProgramEvent;

public class FunctionChangeRecord
extends ProgramChangeRecord {
    private FunctionChangeType changeType;

    public FunctionChangeRecord(Function function, FunctionChangeType changeType) {
        super(ProgramEvent.FUNCTION_CHANGED, function.getEntryPoint(), function.getEntryPoint(), function, null, null);
        this.changeType = changeType == null ? FunctionChangeType.UNSPECIFIED : changeType;
    }

    public FunctionChangeType getSpecificChangeType() {
        return this.changeType;
    }

    public Function getFunction() {
        return (Function)this.getObject();
    }

    public boolean isFunctionSignatureChange() {
        return this.changeType == FunctionChangeType.PARAMETERS_CHANGED || this.changeType == FunctionChangeType.RETURN_TYPE_CHANGED;
    }

    public boolean isFunctionModifierChange() {
        return this.changeType == FunctionChangeType.THUNK_CHANGED || this.changeType == FunctionChangeType.INLINE_CHANGED || this.changeType == FunctionChangeType.NO_RETURN_CHANGED || this.changeType == FunctionChangeType.CALL_FIXUP_CHANGED || this.changeType == FunctionChangeType.PURGE_CHANGED;
    }

    public static enum FunctionChangeType {
        PURGE_CHANGED,
        INLINE_CHANGED,
        NO_RETURN_CHANGED,
        CALL_FIXUP_CHANGED,
        RETURN_TYPE_CHANGED,
        PARAMETERS_CHANGED,
        THUNK_CHANGED,
        UNSPECIFIED;

    }
}

