/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.symbol;

import ghidra.program.model.symbol.DataRefType;
import ghidra.program.model.symbol.FlowType;

public abstract class RefType {
    static final byte __INVALID = -2;
    static final byte __UNKNOWNFLOW = -1;
    static final byte __FALL_THROUGH = 0;
    static final byte __UNCONDITIONAL_JUMP = 1;
    static final byte __CONDITIONAL_JUMP = 2;
    static final byte __UNCONDITIONAL_CALL = 3;
    static final byte __CONDITIONAL_CALL = 4;
    static final byte __TERMINATOR = 5;
    static final byte __COMPUTED_JUMP = 6;
    static final byte __CONDITIONAL_TERMINATOR = 7;
    static final byte __COMPUTED_CALL = 8;
    static final byte __INDIRECTION = 9;
    static final byte __CALL_TERMINATOR = 10;
    static final byte __JUMP_TERMINATOR = 11;
    static final byte __CONDITIONAL_COMPUTED_JUMP = 12;
    static final byte __CONDITIONAL_COMPUTED_CALL = 13;
    static final byte __CONDITIONAL_CALL_TERMINATOR = 14;
    static final byte __COMPUTED_CALL_TERMINATOR = 15;
    static final byte __CALL_OVERRIDE_UNCONDITIONAL = 16;
    static final byte __JUMP_OVERRIDE_UNCONDITIONAL = 17;
    static final byte __CALLOTHER_OVERRIDE_CALL = 18;
    static final byte __CALLOTHER_OVERRIDE_JUMP = 19;
    static final byte __UNKNOWNDATA = 100;
    static final byte __READ = 101;
    static final byte __WRITE = 102;
    static final byte __READ_WRITE = 103;
    static final byte __READ_IND = 104;
    static final byte __WRITE_IND = 105;
    static final byte __READ_WRITE_IND = 106;
    static final byte __UNKNOWNPARAM = 107;
    @Deprecated
    static final byte __STACK_READ = 110;
    @Deprecated
    static final byte __STACK_WRITE = 111;
    static final byte __EXTERNAL_REF = 113;
    static final byte __UNKNOWNDATA_IND = 114;
    static final byte __DYNAMICDATA = 127;
    public static final FlowType INVALID = new FlowType.Builder(-2, "INVALID").setHasFall().build();
    public static final FlowType FLOW = new FlowType.Builder(-1, "FLOW").setHasFall().build();
    public static final FlowType FALL_THROUGH = new FlowType.Builder(0, "FALL_THROUGH").setHasFall().build();
    public static final FlowType UNCONDITIONAL_JUMP = new FlowType.Builder(1, "UNCONDITIONAL_JUMP").setIsJump().build();
    public static final FlowType CONDITIONAL_JUMP = new FlowType.Builder(2, "CONDITIONAL_JUMP").setHasFall().setIsJump().setIsConditional().build();
    public static final FlowType UNCONDITIONAL_CALL = new FlowType.Builder(3, "UNCONDITIONAL_CALL").setHasFall().setIsCall().build();
    public static final FlowType CONDITIONAL_CALL = new FlowType.Builder(4, "CONDITIONAL_CALL").setHasFall().setIsCall().setIsConditional().build();
    public static final FlowType TERMINATOR = new FlowType.Builder(5, "TERMINATOR").setIsTerminal().build();
    public static final FlowType COMPUTED_JUMP = new FlowType.Builder(6, "COMPUTED_JUMP").setIsJump().setIsComputed().build();
    public static final FlowType CONDITIONAL_TERMINATOR = new FlowType.Builder(7, "CONDITIONAL_TERMINATOR").setHasFall().setIsTerminal().setIsConditional().build();
    public static final FlowType COMPUTED_CALL = new FlowType.Builder(8, "COMPUTED_CALL").setHasFall().setIsCall().setIsComputed().build();
    public static final FlowType CALL_TERMINATOR = new FlowType.Builder(10, "CALL_TERMINATOR").setIsCall().setIsTerminal().build();
    public static final FlowType COMPUTED_CALL_TERMINATOR = new FlowType.Builder(15, "COMPUTED_CALL_TERMINATOR").setIsCall().setIsTerminal().setIsComputed().build();
    public static final FlowType CONDITIONAL_CALL_TERMINATOR = new FlowType.Builder(14, "CONDITIONAL_CALL_TERMINATOR").setIsCall().setIsTerminal().setIsConditional().build();
    public static final FlowType CONDITIONAL_COMPUTED_CALL = new FlowType.Builder(13, "CONDITIONAL_COMPUTED_CALL").setHasFall().setIsCall().setIsComputed().setIsConditional().build();
    public static final FlowType CONDITIONAL_COMPUTED_JUMP = new FlowType.Builder(12, "CONDITIONAL_COMPUTED_JUMP").setHasFall().setIsJump().setIsComputed().setIsConditional().build();
    public static final FlowType JUMP_TERMINATOR = new FlowType.Builder(11, "JUMP_TERMINATOR").setIsJump().setIsTerminal().build();
    public static final FlowType INDIRECTION = new FlowType.Builder(9, "INDIRECTION").build();
    public static final FlowType CALL_OVERRIDE_UNCONDITIONAL = new FlowType.Builder(16, "CALL_OVERRIDE_UNCONDITIONAL").setHasFall().setIsCall().setIsOverride().build();
    public static final FlowType JUMP_OVERRIDE_UNCONDITIONAL = new FlowType.Builder(17, "JUMP_OVERRIDE_UNCONDITIONAL").setIsJump().setIsOverride().build();
    public static final FlowType CALLOTHER_OVERRIDE_CALL = new FlowType.Builder(18, "CALLOTHER_OVERRIDE_CALL").setHasFall().setIsCall().setIsOverride().build();
    public static final FlowType CALLOTHER_OVERRIDE_JUMP = new FlowType.Builder(19, "CALLOTHER_OVERRIDE_JUMP").setIsJump().setIsOverride().build();
    public static final RefType THUNK = new DataRefType(127, "THUNK", 0);
    public static final RefType DATA = new DataRefType(100, "DATA", 0);
    public static final RefType PARAM = new DataRefType(107, "PARAM", 0);
    public static final RefType DATA_IND = new DataRefType(114, "DATA_IND", 4);
    public static final RefType READ = new DataRefType(101, "READ", 1);
    public static final RefType WRITE = new DataRefType(102, "WRITE", 2);
    public static final RefType READ_WRITE = new DataRefType(103, "READ_WRITE", 3);
    public static final RefType READ_IND = new DataRefType(104, "READ_IND", 5);
    public static final RefType WRITE_IND = new DataRefType(105, "WRITE_IND", 6);
    public static final RefType READ_WRITE_IND = new DataRefType(106, "READ_WRITE_IND", 7);
    public static final RefType EXTERNAL_REF = new DataRefType(113, "EXTERNAL", 0);
    private byte type;
    private String name;

    public String getDisplayString() {
        if (this == THUNK) {
            return "Thunk";
        }
        if (this == FALL_THROUGH) {
            return "FallThrough";
        }
        if (this.isRead() && this.isWrite()) {
            return "RW";
        }
        if (this.isRead()) {
            return "Read";
        }
        if (this.isWrite()) {
            return "Write";
        }
        if (this.isData()) {
            return "Data";
        }
        if (this.isCall()) {
            return "Call";
        }
        if (this.isJump()) {
            return this.isConditional() ? "Branch" : "Jump";
        }
        return "Unknown";
    }

    protected RefType(byte type, String name) {
        this.type = type;
        this.name = name;
    }

    public byte getValue() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public boolean equals(Object obj) {
        if (obj == null || !this.getClass().equals(obj.getClass())) {
            return false;
        }
        RefType other = (RefType)obj;
        return this.type == other.type;
    }

    public int hashCode() {
        return this.type;
    }

    public String toString() {
        return this.name;
    }

    public boolean isData() {
        return false;
    }

    public boolean isRead() {
        return false;
    }

    public boolean isWrite() {
        return false;
    }

    public boolean isFlow() {
        return false;
    }

    public boolean isIndirect() {
        return this == INDIRECTION;
    }

    public final boolean isFallthrough() {
        return this == FALL_THROUGH;
    }

    public boolean hasFallthrough() {
        return false;
    }

    public boolean isCall() {
        return false;
    }

    public boolean isJump() {
        return false;
    }

    public boolean isUnConditional() {
        return !this.isConditional();
    }

    public boolean isConditional() {
        return false;
    }

    public boolean isComputed() {
        return false;
    }

    public boolean isTerminal() {
        return false;
    }

    public boolean isOverride() {
        return false;
    }
}

