/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.mem;

import ghidra.framework.store.LockException;
import ghidra.program.database.mem.AddressSourceInfo;
import ghidra.program.database.mem.ByteMappingScheme;
import ghidra.program.database.mem.FileBytes;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressOverflowException;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.program.model.mem.MemoryBlockException;
import ghidra.program.model.mem.MemoryBlockSourceInfo;
import ghidra.program.model.mem.MemoryConflictException;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public interface Memory
extends AddressSetView {
    public static final int GBYTE_SHIFT_FACTOR = 30;
    public static final long GBYTE = 0x40000000L;
    public static final int MAX_BINARY_SIZE_GB = 16;
    public static final long MAX_BINARY_SIZE = 0x400000000L;
    public static final int MAX_BLOCK_SIZE_GB = 16;
    public static final long MAX_BLOCK_SIZE = 0x400000000L;

    public Program getProgram();

    public AddressSetView getLoadedAndInitializedAddressSet();

    public AddressSetView getAllInitializedAddressSet();

    @Deprecated
    public AddressSetView getInitializedAddressSet();

    public AddressSetView getExecuteSet();

    public boolean isBigEndian();

    default public boolean isExternalBlockAddress(Address addr) {
        MemoryBlock block = this.getBlock(addr);
        return block != null && block.isExternalBlock();
    }

    public MemoryBlock createInitializedBlock(String var1, Address var2, InputStream var3, long var4, TaskMonitor var6, boolean var7) throws LockException, MemoryConflictException, AddressOverflowException, CancelledException, IllegalArgumentException;

    public MemoryBlock createInitializedBlock(String var1, Address var2, long var3, byte var5, TaskMonitor var6, boolean var7) throws LockException, IllegalArgumentException, MemoryConflictException, AddressOverflowException, CancelledException;

    public MemoryBlock createInitializedBlock(String var1, Address var2, FileBytes var3, long var4, long var6, boolean var8) throws LockException, IllegalArgumentException, MemoryConflictException, AddressOverflowException;

    public MemoryBlock createUninitializedBlock(String var1, Address var2, long var3, boolean var5) throws LockException, IllegalArgumentException, MemoryConflictException, AddressOverflowException;

    public MemoryBlock createBitMappedBlock(String var1, Address var2, Address var3, long var4, boolean var6) throws LockException, MemoryConflictException, AddressOverflowException, IllegalArgumentException;

    public MemoryBlock createByteMappedBlock(String var1, Address var2, Address var3, long var4, ByteMappingScheme var6, boolean var7) throws LockException, MemoryConflictException, AddressOverflowException, IllegalArgumentException;

    default public MemoryBlock createByteMappedBlock(String name, Address start, Address mappedAddress, long length, boolean overlay) throws LockException, MemoryConflictException, AddressOverflowException, IllegalArgumentException {
        return this.createByteMappedBlock(name, start, mappedAddress, length, null, overlay);
    }

    public MemoryBlock createBlock(MemoryBlock var1, String var2, Address var3, long var4) throws LockException, IllegalArgumentException, MemoryConflictException, AddressOverflowException;

    public void removeBlock(MemoryBlock var1, TaskMonitor var2) throws LockException;

    public long getSize();

    public MemoryBlock getBlock(Address var1);

    public MemoryBlock getBlock(String var1);

    public MemoryBlock[] getBlocks();

    public void moveBlock(MemoryBlock var1, Address var2, TaskMonitor var3) throws LockException, MemoryBlockException, MemoryConflictException, AddressOverflowException;

    public void split(MemoryBlock var1, Address var2) throws MemoryBlockException, LockException;

    public MemoryBlock join(MemoryBlock var1, MemoryBlock var2) throws LockException, MemoryBlockException;

    public MemoryBlock convertToInitialized(MemoryBlock var1, byte var2) throws LockException, MemoryBlockException;

    public MemoryBlock convertToUninitialized(MemoryBlock var1) throws MemoryBlockException, LockException;

    public Address findBytes(Address var1, byte[] var2, byte[] var3, boolean var4, TaskMonitor var5);

    public Address findBytes(Address var1, Address var2, byte[] var3, byte[] var4, boolean var5, TaskMonitor var6);

    public byte getByte(Address var1) throws MemoryAccessException;

    public int getBytes(Address var1, byte[] var2) throws MemoryAccessException;

    public int getBytes(Address var1, byte[] var2, int var3, int var4) throws MemoryAccessException;

    public short getShort(Address var1) throws MemoryAccessException;

    public short getShort(Address var1, boolean var2) throws MemoryAccessException;

    public int getShorts(Address var1, short[] var2) throws MemoryAccessException;

    public int getShorts(Address var1, short[] var2, int var3, int var4) throws MemoryAccessException;

    public int getShorts(Address var1, short[] var2, int var3, int var4, boolean var5) throws MemoryAccessException;

    public int getInt(Address var1) throws MemoryAccessException;

    public int getInt(Address var1, boolean var2) throws MemoryAccessException;

    public int getInts(Address var1, int[] var2) throws MemoryAccessException;

    public int getInts(Address var1, int[] var2, int var3, int var4) throws MemoryAccessException;

    public int getInts(Address var1, int[] var2, int var3, int var4, boolean var5) throws MemoryAccessException;

    public long getLong(Address var1) throws MemoryAccessException;

    public long getLong(Address var1, boolean var2) throws MemoryAccessException;

    public int getLongs(Address var1, long[] var2) throws MemoryAccessException;

    public int getLongs(Address var1, long[] var2, int var3, int var4) throws MemoryAccessException;

    public int getLongs(Address var1, long[] var2, int var3, int var4, boolean var5) throws MemoryAccessException;

    public void setByte(Address var1, byte var2) throws MemoryAccessException;

    public void setBytes(Address var1, byte[] var2) throws MemoryAccessException;

    public void setBytes(Address var1, byte[] var2, int var3, int var4) throws MemoryAccessException;

    public void setShort(Address var1, short var2) throws MemoryAccessException;

    public void setShort(Address var1, short var2, boolean var3) throws MemoryAccessException;

    public void setInt(Address var1, int var2) throws MemoryAccessException;

    public void setInt(Address var1, int var2, boolean var3) throws MemoryAccessException;

    public void setLong(Address var1, long var2) throws MemoryAccessException;

    public void setLong(Address var1, long var2, boolean var4) throws MemoryAccessException;

    public FileBytes createFileBytes(String var1, long var2, long var4, InputStream var6, TaskMonitor var7) throws IOException, CancelledException;

    public List<FileBytes> getAllFileBytes();

    public boolean deleteFileBytes(FileBytes var1) throws IOException;

    public AddressSourceInfo getAddressSourceInfo(Address var1);

    public static boolean isValidMemoryBlockName(String name) {
        if (name == null || name.length() == 0) {
            return false;
        }
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (c >= ' ') continue;
            return false;
        }
        return true;
    }

    default public List<Address> locateAddressesForFileOffset(long fileOffset) {
        ArrayList<Address> list = new ArrayList<Address>();
        for (MemoryBlock memBlock : this.getBlocks()) {
            for (MemoryBlockSourceInfo info : memBlock.getSourceInfos()) {
                Address addr = info.locateAddressForFileOffset(fileOffset);
                if (addr == null) continue;
                list.add(addr);
            }
        }
        return list;
    }

    default public List<Address> locateAddressesForFileBytesOffset(FileBytes fileBytes, long offset) {
        ArrayList<Address> list = new ArrayList<Address>();
        for (MemoryBlock memBlock : this.getBlocks()) {
            for (MemoryBlockSourceInfo info : memBlock.getSourceInfos()) {
                Address addr;
                Optional<FileBytes> blockFileBytes = info.getFileBytes();
                if (!blockFileBytes.isPresent() || !blockFileBytes.get().equals(fileBytes) || (addr = info.locateAddressForFileOffset(offset)) == null) continue;
                list.add(addr);
            }
        }
        return list;
    }
}

