/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.oldfunction;

import db.DBHandle;
import db.DBRecord;
import db.RecordIterator;
import db.util.ErrorHandler;
import ghidra.program.database.ProgramDB;
import ghidra.program.database.data.DataTypeManagerDB;
import ghidra.program.database.function.FunctionDB;
import ghidra.program.database.function.OverlappingFunctionException;
import ghidra.program.database.map.AddressMap;
import ghidra.program.database.oldfunction.OldFunctionDBAdapter;
import ghidra.program.database.oldfunction.OldFunctionDataDB;
import ghidra.program.database.oldfunction.OldFunctionMapDB;
import ghidra.program.database.oldfunction.OldRegisterVariableDBAdapter;
import ghidra.program.database.oldfunction.OldStackVariableDBAdapter;
import ghidra.program.database.symbol.SymbolManager;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.Pointer;
import ghidra.program.model.listing.Parameter;
import ghidra.program.model.listing.StackFrame;
import ghidra.program.model.listing.Variable;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolUtilities;
import ghidra.util.Msg;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.InvalidInputException;
import ghidra.util.exception.VersionException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.Iterator;

public class OldFunctionManager
implements ErrorHandler {
    private DBHandle dbHandle;
    private ErrorHandler errHandler;
    private OldFunctionMapDB functionMap;
    private OldFunctionDBAdapter functionAdapter;
    private OldStackVariableDBAdapter stackVarAdapter;
    private OldRegisterVariableDBAdapter registerAdapter;
    private ProgramDB program;
    private DataTypeManagerDB dataManager;
    private AddressMap addrMap;

    public OldFunctionManager(DBHandle dbHandle, ErrorHandler errHandler, AddressMap addrMap) throws VersionException {
        this.dbHandle = dbHandle;
        this.errHandler = errHandler;
        this.addrMap = addrMap.getOldAddressMap();
        this.initializeAdapters();
    }

    public void upgrade(ProgramDB upgradeProgram, TaskMonitor monitor) throws CancelledException, IOException {
        if (this.program != null) {
            throw new AssertException("Function manager already upgraded");
        }
        this.program = upgradeProgram;
        this.dataManager = upgradeProgram.getDataTypeManager();
        monitor.setMessage("Upgrading Functions...");
        monitor.initialize((long)this.getFunctionCount());
        int cnt = 0;
        OldFunctionIteratorDB iter = this.getFunctions();
        while (iter.hasNext()) {
            monitor.checkCancelled();
            this.upgradeFunction(iter.next());
            monitor.setProgress((long)(++cnt));
        }
        this.dispose();
    }

    private void upgradeFunction(OldFunctionDataDB oldFunc) {
        Address entryPt = oldFunc.getEntryPoint();
        SymbolManager symTable = this.program.getSymbolTable();
        Symbol s = symTable.getPrimarySymbol(entryPt);
        String baseName = null;
        if (s != null && s.getSource() != SourceType.DEFAULT) {
            baseName = s.getName();
            s.delete();
        } else {
            baseName = SymbolUtilities.getDefaultFunctionName(entryPt);
        }
        String name = baseName;
        FunctionDB func = null;
        try {
            Variable[] oldLocalVars;
            Parameter[] oldParms;
            func = (FunctionDB)this.program.getFunctionManager().createFunction(name, entryPt, oldFunc.getBody(), SourceType.USER_DEFINED);
            func.setCustomVariableStorage(true);
            func.setComment(oldFunc.getComment());
            func.setRepeatableComment(oldFunc.getRepeatableComment());
            func.setReturnType(oldFunc.getReturnType(), SourceType.ANALYSIS);
            func.setValidationEnabled(false);
            func.setStackPurgeSize(oldFunc.getStackDepthChange());
            StackFrame oldFrame = oldFunc.getStackFrame();
            StackFrame frame = func.getStackFrame();
            frame.setLocalSize(oldFrame.getLocalSize());
            frame.setReturnAddressOffset(oldFrame.getReturnAddressOffset());
            for (Parameter var : oldParms = oldFunc.getParameters()) {
                if (var.getVariableStorage().isBadStorage()) {
                    Msg.error((Object)this, (Object)("Discarded invalid parameter (" + func.getName() + " at " + String.valueOf(func.getEntryPoint()) + ")"));
                    continue;
                }
                boolean done = false;
                while (!done) {
                    try {
                        func.addParameter(var, SourceType.USER_DEFINED);
                        done = true;
                    }
                    catch (DuplicateNameException e) {
                        try {
                            var.setName(var.getName() + ".dup", SourceType.USER_DEFINED);
                        }
                        catch (DuplicateNameException duplicateNameException) {}
                    }
                }
            }
            for (Variable var : oldLocalVars = oldFrame.getLocals()) {
                boolean done = false;
                while (!done) {
                    try {
                        func.addLocalVariable(var, SourceType.USER_DEFINED);
                        done = true;
                    }
                    catch (DuplicateNameException e) {
                        try {
                            var.setName(var.getName() + ".dup", SourceType.USER_DEFINED);
                        }
                        catch (DuplicateNameException duplicateNameException) {}
                    }
                }
            }
        }
        catch (OverlappingFunctionException e) {
            throw new AssertException((Throwable)e);
        }
        catch (InvalidInputException e) {
            throw new AssertException((Throwable)e);
        }
        finally {
            if (func != null) {
                func.setValidationEnabled(true);
            }
        }
    }

    private void initializeAdapters() throws VersionException {
        VersionException versionExc = null;
        try {
            this.functionAdapter = OldFunctionDBAdapter.getAdapter(this.dbHandle, this.addrMap);
        }
        catch (VersionException e) {
            versionExc = e.combine(versionExc);
        }
        try {
            this.stackVarAdapter = OldStackVariableDBAdapter.getAdapter(this.dbHandle, this.addrMap);
        }
        catch (VersionException e) {
            versionExc = e.combine(versionExc);
        }
        try {
            this.registerAdapter = OldRegisterVariableDBAdapter.getAdapter(this.dbHandle, this.addrMap);
        }
        catch (VersionException e) {
            versionExc = e.combine(versionExc);
        }
        this.functionMap = new OldFunctionMapDB(this.dbHandle, this, this.addrMap);
        if (versionExc != null) {
            throw versionExc;
        }
    }

    ProgramDB getProgram() {
        return this.program;
    }

    OldFunctionDBAdapter getFunctionAdapter() {
        return this.functionAdapter;
    }

    OldRegisterVariableDBAdapter getRegisterVariableAdapter() {
        return this.registerAdapter;
    }

    OldStackVariableDBAdapter getStackVariableAdapter() {
        return this.stackVarAdapter;
    }

    DataType getDataType(long dataTypeId) {
        DataType dataType = this.dataManager.getDataType(dataTypeId);
        if (dataType == null || dataType.isDeleted()) {
            return DataType.DEFAULT;
        }
        if (dataType.getLength() > 0) {
            return dataType;
        }
        if (dataType instanceof Pointer) {
            return this.program.getDataTypeManager().getPointer(((Pointer)dataType).getDataType());
        }
        return this.program.getDataTypeManager().getPointer(dataType);
    }

    long getDataTypeId(DataType dataType) {
        return this.dataManager.getResolvedID(dataType);
    }

    int getFunctionCount() {
        return this.functionAdapter.getRecordCount();
    }

    AddressSetView getFunctionBody(long functionKey) {
        return this.functionMap.getBody(functionKey);
    }

    synchronized OldFunctionDataDB getFunction(DBRecord rec) {
        return new OldFunctionDataDB(this, this.addrMap, rec, null);
    }

    synchronized OldFunctionIteratorDB getFunctions() {
        try {
            return new OldFunctionIteratorDB();
        }
        catch (IOException e) {
            this.errHandler.dbError(e);
            return null;
        }
    }

    public void dbError(IOException e) {
        this.errHandler.dbError(e);
    }

    public synchronized void dispose() throws IOException {
        this.functionMap.dispose();
        this.functionAdapter.deleteTable(this.dbHandle);
        this.stackVarAdapter.deleteTable(this.dbHandle);
        this.registerAdapter.deleteTable(this.dbHandle);
        this.dbHandle.deleteTable("Function Variables");
        this.dbHandle.deleteTable("Function Var Ranges");
    }

    private class OldFunctionIteratorDB
    implements Iterator<OldFunctionDataDB> {
        private RecordIterator recordIter;
        private OldFunctionDataDB func;
        private boolean hasNext = false;

        OldFunctionIteratorDB() throws IOException {
            this.recordIter = OldFunctionManager.this.functionAdapter.iterateFunctionRecords();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean hasNext() {
            if (this.hasNext) {
                return true;
            }
            OldFunctionManager oldFunctionManager = OldFunctionManager.this;
            synchronized (oldFunctionManager) {
                try {
                    DBRecord rec = this.recordIter.next();
                    if (rec != null) {
                        this.func = OldFunctionManager.this.getFunction(rec);
                        this.hasNext = true;
                    }
                }
                catch (IOException e) {
                    OldFunctionManager.this.errHandler.dbError(e);
                }
                return this.hasNext;
            }
        }

        @Override
        public OldFunctionDataDB next() {
            if (this.hasNext || this.hasNext()) {
                this.hasNext = false;
                return this.func;
            }
            return null;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

