/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcodeCPort.slghsymbol;

import generic.stl.VectorSTL;
import ghidra.pcode.utils.SlaFormat;
import ghidra.pcodeCPort.slghpatexpress.PatternValue;
import ghidra.pcodeCPort.slghsymbol.ValueSymbol;
import ghidra.pcodeCPort.slghsymbol.symbol_type;
import ghidra.program.model.pcode.Encoder;
import ghidra.sleigh.grammar.Location;
import java.io.IOException;

public class NameSymbol
extends ValueSymbol {
    private VectorSTL<String> nametable = new VectorSTL();
    private boolean tableisfilled;

    public NameSymbol(Location location) {
        super(location);
    }

    public NameSymbol(Location location, String nm, PatternValue pv, VectorSTL<String> nt) {
        super(location, nm, pv);
        this.nametable = nt;
        this.checkTableFill();
    }

    private void checkTableFill() {
        long min = this.patval.minValue();
        long max = this.patval.maxValue();
        this.tableisfilled = min >= 0L && max < (long)this.nametable.size();
        for (int i = 0; i < this.nametable.size(); ++i) {
            if (this.nametable.get(i) != null) continue;
            this.tableisfilled = false;
        }
    }

    @Override
    public symbol_type getType() {
        return symbol_type.name_symbol;
    }

    @Override
    public void encode(Encoder encoder) throws IOException {
        encoder.openElement(SlaFormat.ELEM_NAME_SYM);
        encoder.writeUnsignedInteger(SlaFormat.ATTRIB_ID, this.id);
        this.patval.encode(encoder);
        for (int i = 0; i < this.nametable.size(); ++i) {
            String name = (String)this.nametable.get(i);
            encoder.openElement(SlaFormat.ELEM_NAMETAB);
            if (name != null) {
                encoder.writeString(SlaFormat.ATTRIB_NAME, name);
            }
            encoder.closeElement(SlaFormat.ELEM_NAMETAB);
        }
        encoder.closeElement(SlaFormat.ELEM_NAME_SYM);
    }

    @Override
    public void encodeHeader(Encoder encoder) throws IOException {
        encoder.openElement(SlaFormat.ELEM_NAME_SYM_HEAD);
        this.encodeSleighSymbolHeader(encoder);
        encoder.closeElement(SlaFormat.ELEM_NAME_SYM_HEAD);
    }
}

