/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcodeCPort.slghsymbol;

import ghidra.pcode.utils.SlaFormat;
import ghidra.pcodeCPort.semantics.ConstTpl;
import ghidra.pcodeCPort.semantics.VarnodeTpl;
import ghidra.pcodeCPort.slghsymbol.PatternlessSymbol;
import ghidra.pcodeCPort.slghsymbol.symbol_type;
import ghidra.pcodeCPort.space.AddrSpace;
import ghidra.program.model.pcode.Encoder;
import ghidra.sleigh.grammar.Location;
import java.io.IOException;

public class EpsilonSymbol
extends PatternlessSymbol {
    private AddrSpace const_space;

    public EpsilonSymbol(Location location) {
        super(location);
    }

    public EpsilonSymbol(Location location, String nm, AddrSpace spc) {
        super(location, nm);
        this.const_space = spc;
    }

    @Override
    public symbol_type getType() {
        return symbol_type.epsilon_symbol;
    }

    @Override
    public VarnodeTpl getVarnode() {
        return new VarnodeTpl(this.location, new ConstTpl(this.const_space), new ConstTpl(ConstTpl.const_type.real, 0L), new ConstTpl(ConstTpl.const_type.real, 0L));
    }

    @Override
    public void encode(Encoder encoder) throws IOException {
        encoder.openElement(SlaFormat.ELEM_EPSILON_SYM);
        encoder.writeUnsignedInteger(SlaFormat.ATTRIB_ID, this.id);
        encoder.closeElement(SlaFormat.ELEM_EPSILON_SYM);
    }

    @Override
    public void encodeHeader(Encoder encoder) throws IOException {
        encoder.openElement(SlaFormat.ELEM_EPSILON_SYM_HEAD);
        this.encodeSleighSymbolHeader(encoder);
        encoder.closeElement(SlaFormat.ELEM_EPSILON_SYM_HEAD);
    }
}

