/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.decompiler.component;

import ghidra.app.decompiler.component.DecompilerController;
import ghidra.framework.model.DomainObjectChangeRecord;
import ghidra.framework.model.DomainObjectChangedEvent;
import ghidra.framework.model.DomainObjectEvent;
import ghidra.framework.model.DomainObjectListener;
import ghidra.framework.model.EventType;
import ghidra.program.util.ProgramEvent;
import ghidra.util.task.SwingUpdateManager;

public class DecompilerProgramListener
implements DomainObjectListener {
    private DecompilerController controller;
    private SwingUpdateManager updater;

    public DecompilerProgramListener(DecompilerController controller, Runnable callback) {
        this(controller, new SwingUpdateManager(500, 5000, callback));
    }

    public DecompilerProgramListener(DecompilerController controller, SwingUpdateManager updater) {
        this.controller = controller;
        this.updater = updater;
    }

    public void domainObjectChanged(DomainObjectChangedEvent ev) {
        if (ev.contains(new EventType[]{ProgramEvent.MEMORY_BLOCK_ADDED, ProgramEvent.MEMORY_BLOCK_REMOVED, DomainObjectEvent.RESTORED})) {
            this.controller.resetDecompiler();
        } else if (ev.contains((EventType)DomainObjectEvent.PROPERTY_CHANGED)) {
            for (DomainObjectChangeRecord record : ev) {
                String value;
                if (record.getEventType() != DomainObjectEvent.PROPERTY_CHANGED || !(record.getOldValue() instanceof String) || !(value = (String)record.getOldValue()).startsWith("Specification Extensions")) continue;
                this.controller.resetDecompiler();
                break;
            }
        }
        this.updater.update();
    }

    public void dispose() {
        this.updater.dispose();
    }
}

