/*
 * Decompiled with CFR 0.152.
 */
package utility.module;

import generic.jar.ResourceFile;
import ghidra.framework.GModule;
import ghidra.util.Msg;
import ghidra.util.exception.AssertException;
import java.io.File;
import java.io.IOException;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Predicate;
import utilities.util.FileUtilities;
import utility.application.ApplicationLayout;

public class ModuleUtilities {
    private static final String BINARY_PATH = System.getProperty("binaryPath", "bin/main");
    public static final String MANIFEST_FILE_NAME = "Module.manifest";
    public static final String MANIFEST_FILE_NAME_UNINSTALLED = "Module.manifest.uninstalled";
    public static final String MODULE_LIST = "MODULE_LIST";
    private static final int MAX_MODULE_DEPTH = 3;

    public static boolean isModuleDirectory(ResourceFile dir) {
        return new ResourceFile(dir, MANIFEST_FILE_NAME).exists();
    }

    public static boolean isModuleDirectory(Path path) {
        File file = path.toFile();
        if ("bin".equals(file.getName())) {
            return false;
        }
        return new File(file, MANIFEST_FILE_NAME).exists();
    }

    public static Collection<ResourceFile> findModuleRootDirectories(ResourceFile rootDir, Collection<ResourceFile> moduleRootDirs) {
        ModuleUtilities.findModuleRootDirectoriesHelper(new ResourceFile(rootDir, "../GPL"), moduleRootDirs, 3);
        return ModuleUtilities.findModuleRootDirectoriesHelper(rootDir, moduleRootDirs, 3);
    }

    private static Collection<ResourceFile> findModuleRootDirectoriesHelper(ResourceFile rootDir, Collection<ResourceFile> moduleRootDirs, int remainingDepth) {
        if (!rootDir.exists() || remainingDepth <= 0) {
            return moduleRootDirs;
        }
        ResourceFile[] subDirs = rootDir.listFiles(ResourceFile::isDirectory);
        if (subDirs == null) {
            throw new RuntimeException("Failed to read directory: " + String.valueOf(rootDir));
        }
        for (ResourceFile subDir : subDirs) {
            if ("build".equals(subDir.getName())) continue;
            if (ModuleUtilities.isModuleDirectory(subDir)) {
                moduleRootDirs.add(subDir);
                continue;
            }
            ModuleUtilities.findModuleRootDirectoriesHelper(subDir, moduleRootDirs, remainingDepth - 1);
        }
        return moduleRootDirs;
    }

    public static Collection<ResourceFile> findModuleRootDirectories(Collection<ResourceFile> rootDirs) {
        return ModuleUtilities.findModuleRootDirectories(rootDirs, new ArrayList<ResourceFile>());
    }

    public static Collection<ResourceFile> findModuleRootDirectories(Collection<ResourceFile> rootDirs, Collection<ResourceFile> moduleRootDirs) {
        for (ResourceFile rootDir : rootDirs) {
            ModuleUtilities.findModuleRootDirectories(rootDir, moduleRootDirs);
        }
        return moduleRootDirs;
    }

    public static Collection<ResourceFile> findJarModuleRootDirectories(ResourceFile rootDir, Collection<ResourceFile> moduleRootDirs) throws IOException {
        ResourceFile moduleListFile = new ResourceFile(rootDir, MODULE_LIST);
        for (String relativeModulePath : FileUtilities.getLines(moduleListFile)) {
            moduleRootDirs.add(new ResourceFile(rootDir, relativeModulePath));
        }
        return moduleRootDirs;
    }

    public static Map<String, GModule> findModules(Collection<ResourceFile> appRootDirs, Collection<ResourceFile> moduleRootDirs) {
        Predicate<GModule> allModules = module -> true;
        return ModuleUtilities.findModules(appRootDirs, moduleRootDirs, allModules);
    }

    public static Map<String, GModule> findModules(Collection<ResourceFile> appRootDirs, Collection<ResourceFile> moduleRootDirs, Predicate<GModule> moduleFilter) {
        TreeMap<String, GModule> map = new TreeMap<String, GModule>();
        for (ResourceFile moduleRoot : moduleRootDirs) {
            GModule gModule = new GModule(appRootDirs, moduleRoot);
            if (!moduleFilter.test(gModule) || map.put(moduleRoot.getName(), gModule) == null) continue;
            StringBuilder collided = new StringBuilder();
            for (ResourceFile collideRoot : moduleRootDirs) {
                if (!moduleRoot.getName().equals(collideRoot.getName())) continue;
                collided.append("\n");
                collided.append(collideRoot.getAbsolutePath());
            }
            throw new AssertException("Multiple modules collided with same name: " + moduleRoot.getName() + String.valueOf(collided));
        }
        return Collections.unmodifiableMap(map);
    }

    public static Collection<ResourceFile> getModuleLibDirectories(Collection<GModule> modules) {
        ArrayList<ResourceFile> libraryDirectories = new ArrayList<ResourceFile>();
        for (GModule module : modules) {
            module.collectExistingModuleDirs(libraryDirectories, "lib");
            module.collectExistingModuleDirs(libraryDirectories, "libs");
        }
        return libraryDirectories;
    }

    public static Collection<ResourceFile> getModuleBinDirectories(Collection<GModule> modules) {
        String[] binaryPathTokens = BINARY_PATH.split(":");
        ArrayList<ResourceFile> binDirectories = new ArrayList<ResourceFile>();
        for (GModule module : modules) {
            Arrays.stream(binaryPathTokens).forEach(token -> module.collectExistingModuleDirs((List<ResourceFile>)binDirectories, (String)token));
        }
        return binDirectories;
    }

    public static boolean isInModule(String pathName) {
        return ModuleUtilities.getModule(pathName) != null;
    }

    public static Path getModule(String pathName) {
        for (Path path = ModuleUtilities.toPath(pathName); path != null; path = path.getParent()) {
            if (!ModuleUtilities.isModuleDirectory(path)) continue;
            return path;
        }
        return null;
    }

    private static Path toPath(String pathname) {
        try {
            return Paths.get(pathname, new String[0]);
        }
        catch (InvalidPathException e) {
            Msg.trace(ModuleUtilities.class, "Invalid path: " + pathname);
            return null;
        }
    }

    public static File findRepoRoot(File f) {
        if (f == null) {
            return null;
        }
        File repoDir = ModuleUtilities.findRepo(f);
        if (repoDir != null) {
            return repoDir.getParentFile();
        }
        File[] children = f.listFiles(file -> file.isDirectory());
        if (children != null) {
            for (File child : children) {
                File childRepo = ModuleUtilities.findRepo(child);
                if (childRepo == null) continue;
                return childRepo.getParentFile();
            }
        }
        return null;
    }

    public static File findRepo(File f) {
        if (f == null) {
            return null;
        }
        File testGit = new File(f, ".git");
        if (testGit.exists()) {
            return f;
        }
        return ModuleUtilities.findRepo(f.getParentFile());
    }

    public static boolean isExternalModule(GModule module, ApplicationLayout layout) {
        File moduleRootDir = module.getModuleRoot().getFile(false);
        return !layout.getApplicationRootDirs().stream().map(dir -> dir.getParentFile().getFile(false)).anyMatch(dir -> FileUtilities.isPathContainedWithin(dir, moduleRootDir));
    }

    public static boolean isUninstalled(String path) {
        return ModuleUtilities.isUninstalled(new File(path));
    }

    public static boolean isUninstalled(File dir) {
        return new File(dir, MANIFEST_FILE_NAME_UNINSTALLED).exists();
    }

    public static boolean isUninstalled(ResourceFile dir) {
        return new ResourceFile(dir, MANIFEST_FILE_NAME_UNINSTALLED).exists();
    }
}

