/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pyghidra;

import ghidra.app.plugin.ProgramPlugin;
import ghidra.app.plugin.core.interpreter.InterpreterPanelService;
import ghidra.app.script.GhidraState;
import ghidra.app.script.ScriptControls;
import ghidra.framework.plugintool.PluginInfo;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.util.PluginStatus;
import ghidra.program.model.listing.Program;
import ghidra.program.util.ProgramLocation;
import ghidra.program.util.ProgramSelection;
import ghidra.pyghidra.interpreter.InterpreterGhidraScript;
import ghidra.pyghidra.interpreter.PyGhidraInterpreter;
import ghidra.util.exception.AssertException;
import java.util.function.Consumer;

@PluginInfo(status=PluginStatus.RELEASED, packageName="Ghidra Core", category="Common", shortDescription="PyGhidra Interpreter", description="Provides an interactive Python Interpreter that is tightly integrated with a loaded Ghidra program.", servicesRequired={InterpreterPanelService.class})
public class PyGhidraPlugin
extends ProgramPlugin {
    public static final String TITLE = "PyGhidra";
    private static Consumer<PyGhidraPlugin> initializer = null;
    public final InterpreterGhidraScript script = new InterpreterGhidraScript();
    public PyGhidraInterpreter interpreter;

    public PyGhidraPlugin(PluginTool tool) {
        super(tool);
        GhidraState state = new GhidraState(tool, tool.getProject(), null, null, null, null);
        this.script.set(new GhidraState(state), ScriptControls.NONE);
    }

    public static void setInitializer(Consumer<PyGhidraPlugin> initializer) {
        if (PyGhidraPlugin.initializer != null) {
            throw new AssertException("PyGhidraPlugin initializer has already been set");
        }
        PyGhidraPlugin.initializer = initializer;
    }

    public void init() {
        this.interpreter = new PyGhidraInterpreter(this, initializer != null);
        if (initializer != null) {
            initializer.accept(this);
        }
    }

    public void dispose() {
        this.interpreter.dispose();
        super.dispose();
    }

    protected void programActivated(Program program) {
        this.script.setCurrentProgram(program);
    }

    protected void programDeactivated(Program program) {
        if (this.script.getCurrentProgram() == program) {
            this.script.setCurrentProgram(null);
        }
    }

    protected void locationChanged(ProgramLocation location) {
        this.script.setCurrentLocation(location);
    }

    protected void selectionChanged(ProgramSelection selection) {
        this.script.setCurrentSelection(selection);
    }

    protected void highlightChanged(ProgramSelection highlight) {
        this.script.setCurrentHighlight(highlight);
    }
}

