/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.dialogs.driver;

import java.util.Collection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.IExportWizard;
import org.eclipse.ui.IWorkbench;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.connection.DBPDriver;
import org.jkiss.dbeaver.model.connection.DBPDriverDependencies;
import org.jkiss.dbeaver.ui.dialogs.driver.DriverDownloadAutoPage;
import org.jkiss.dbeaver.ui.dialogs.driver.DriverDownloadDialog;
import org.jkiss.dbeaver.ui.dialogs.driver.DriverDownloadManualPage;
import org.jkiss.dbeaver.ui.dialogs.driver.DriverDownloadPage;
import org.jkiss.dbeaver.ui.internal.UIConnectionMessages;
import org.jkiss.utils.CommonUtils;

public class DriverDownloadWizard
extends Wizard
implements IExportWizard {
    private final DBPDriver driver;
    private final DBPDriverDependencies dependencies;
    private final boolean updateVersion;
    private boolean forceDownload;
    private DriverDownloadPage downloadPage;

    public DriverDownloadWizard(@NotNull DBPDriver driver, @NotNull DBPDriverDependencies dependencies, boolean updateVersion, boolean forceDownload) {
        this.driver = driver;
        this.dependencies = dependencies;
        this.updateVersion = updateVersion;
        this.forceDownload = forceDownload;
        this.setWindowTitle(updateVersion ? UIConnectionMessages.dialog_driver_download_wizard_title_upload_files : UIConnectionMessages.dialog_driver_download_wizard_title_setup_files);
        this.setNeedsProgressMonitor(this.isAutoDownloadWizard());
    }

    DBPDriver getDriver() {
        return this.driver;
    }

    public DBPDriverDependencies getDependencies() {
        return this.dependencies;
    }

    public boolean isForceDownload() {
        return this.forceDownload;
    }

    public void setForceDownload(boolean forceDownload) {
        this.forceDownload = forceDownload;
    }

    public boolean isUpdateVersion() {
        return this.updateVersion;
    }

    public DriverDownloadDialog getContainer() {
        return (DriverDownloadDialog)super.getContainer();
    }

    public void addPages() {
        super.addPages();
        this.downloadPage = this.isAutoDownloadWizard() ? new DriverDownloadAutoPage() : new DriverDownloadManualPage();
        this.addPage((IWizardPage)this.downloadPage);
    }

    void pageActivated(Object selectedPage) {
        this.downloadPage.resolveLibraries();
    }

    public void init(IWorkbench workbench, IStructuredSelection currentSelection) {
        this.setWindowTitle(UIConnectionMessages.dialog_driver_download_wizard_title_setting);
        this.setNeedsProgressMonitor(this.isAutoDownloadWizard());
        this.setHelpAvailable(false);
    }

    public boolean canFinish() {
        return true;
    }

    public boolean performFinish() {
        return this.downloadPage.performFinish();
    }

    public String getFinishText() {
        if (this.isAutoDownloadWizard()) {
            return UIConnectionMessages.dialog_driver_download_wizard_download;
        }
        return UIConnectionMessages.dialog_driver_download_wizard_open_download;
    }

    public boolean isAutoDownloadWizard() {
        return CommonUtils.isEmpty((Collection)this.getDriver().getDriverFileSources());
    }
}

