/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.sql.semantics.context;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPDataSourceInfo;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBPImageProvider;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryConnectionContext;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryResultPseudoColumn;
import org.jkiss.dbeaver.model.sql.semantics.model.select.SQLQueryRowsSourceModel;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityAssociation;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.dbeaver.model.struct.DBSEntityType;
import org.jkiss.dbeaver.model.struct.DBSInstance;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.rdb.DBSCatalog;
import org.jkiss.dbeaver.model.struct.rdb.DBSSchema;
import org.jkiss.dbeaver.model.struct.rdb.DBSTable;
import org.jkiss.dbeaver.model.struct.rdb.DBSTableConstraint;
import org.jkiss.dbeaver.model.struct.rdb.DBSTableIndex;
import org.jkiss.dbeaver.model.struct.rdb.DBSTrigger;

public class SQLQueryConnectionDummyContext
extends SQLQueryConnectionContext {
    private final DummyDbObject dummyDataSource;
    private final Set<String> knownColumnNames;
    private final Set<String> knownTableNames;
    private final Set<String> knownSchemaNames;
    private final Set<String> knownCatalogNames;

    public static boolean isDummyObject(@Nullable Object obj) {
        return obj instanceof DummyDbObject;
    }

    public SQLQueryConnectionDummyContext(@NotNull SQLDialect dialect, @NotNull Set<String> knownColumnNames, @NotNull Set<List<String>> knownTableNames) {
        super(dialect);
        this.knownColumnNames = knownColumnNames;
        this.knownTableNames = new HashSet<String>();
        this.knownSchemaNames = new HashSet<String>();
        this.knownCatalogNames = new HashSet<String>();
        this.dummyDataSource = this.prepareDataSource();
        for (List<String> tableName : knownTableNames) {
            this.getOrPrepareDummyTable(tableName);
        }
    }

    private DummyDbObject prepareDataSource() {
        return new DummyDbObject(null, (DBPImage)DBIcon.TREE_FOLDER_DATABASE, "DummyDataSource", "Dummy data source for purposes of static query semantic analysis", 0, this.knownCatalogNames, this::prepareCatalog);
    }

    private DummyDbObject prepareCatalog(DummyDbObject parent, String name, int index) {
        return new DummyDbObject(parent, (DBPImage)DBIcon.TREE_DATABASE, name, "Dummy catalog for purposes of static query semantic analysis", index, this.knownSchemaNames, this::prepareSchema);
    }

    private DummyDbObject prepareSchema(DummyDbObject parent, String name, int index) {
        return new DummyDbObject(parent, (DBPImage)DBIcon.TREE_SCHEMA, name, "Dummy schema for purposes of static query semantic analysis", index, this.knownTableNames, this::prepareTable);
    }

    private DummyDbObject prepareTable(DummyDbObject parent, String name, int index) {
        return new DummyDbObject(parent, (DBPImage)DBIcon.TREE_TABLE, name, "Dummy table for purposes of static query semantic analysis", index, this.knownColumnNames, this::prepareColumn);
    }

    private DummyDbObject prepareColumn(DummyDbObject parent, String name, int index) {
        return new DummyDbObject(parent, (DBPImage)DBIcon.TYPE_STRING, name, "Dummy column for purposes of static query semantic analysis", index, Collections.emptySet(), null);
    }

    @Override
    @NotNull
    public List<SQLQueryResultPseudoColumn> obtainRowsetPseudoColumns(@Nullable SQLQueryRowsSourceModel rowsSource) {
        return Collections.emptyList();
    }

    @Override
    public boolean isDummy() {
        return true;
    }

    @Override
    @NotNull
    public List<DBSEntity> findRealTables(@NotNull DBRProgressMonitor monitor, @NotNull List<String> tableName) {
        DBSEntity table = this.getOrPrepareDummyTable(tableName);
        return table != null ? List.of(table) : Collections.emptyList();
    }

    @Nullable
    private DBSEntity getOrPrepareDummyTable(@NotNull List<String> tableName) {
        String namePart;
        Map<String, DummyDbObject> children;
        List<String> rawTableName = tableName.stream().map(s -> s == null ? null : this.dialect.getUnquotedIdentifier(s)).toList();
        DummyDbObject container = this.dummyDataSource;
        int i = 0;
        while (i < rawTableName.size() - 2) {
            DummyDbObject catalog = container;
            Map<String, DummyDbObject> children2 = catalog.getChildrenMapImpl();
            String namePart2 = rawTableName.get(i);
            if (namePart2 == null) {
                return null;
            }
            container = children2.computeIfAbsent(namePart2, k -> this.prepareCatalog(catalog, (String)k, children2.size()));
            ++i;
        }
        if (rawTableName.size() > 1) {
            DummyDbObject catalog = container;
            children = catalog.getChildrenMapImpl();
            namePart = rawTableName.get(rawTableName.size() - 2);
            if (namePart == null) {
                return null;
            }
            container = children.computeIfAbsent(namePart, k -> this.prepareSchema(catalog, (String)k, children.size()));
        }
        DummyDbObject schema = container;
        children = schema.getChildrenMapImpl();
        namePart = rawTableName.get(rawTableName.size() - 1);
        if (namePart == null) {
            return null;
        }
        return (DBSEntity)children.computeIfAbsent(namePart, k -> this.prepareTable(schema, (String)k, children.size()));
    }

    @Override
    @NotNull
    protected List<? extends DBSObject> findRealObjectsImpl(@NotNull DBRProgressMonitor monitor, @NotNull List<String> objectName) {
        return this.findRealTables(monitor, objectName);
    }

    @Override
    @Nullable
    public SQLQueryResultPseudoColumn resolveGlobalPseudoColumn(@NotNull String name) {
        return null;
    }

    private class DummyDbObject
    implements DBSEntityAttribute,
    DBSTable,
    DBSSchema,
    DBSCatalog,
    DBPDataSource,
    DBPImageProvider {
        private final DummyDbObject container;
        private final DBPImage image;
        private final String name;
        private final String description;
        private final int position;
        private final Set<String> childrenNames;
        private final DummyObjectCtor childCtor;
        private Map<String, DummyDbObject> childrenByName = null;
        private List<DummyDbObject> children = null;

        public DummyDbObject(@NotNull DummyDbObject container, @NotNull DBPImage image, @NotNull String name, String description, @NotNull int position, @Nullable Set<String> childrenNames, DummyObjectCtor childCtor) {
            this.container = container;
            this.image = image;
            this.name = name;
            this.description = description;
            this.position = position;
            this.childrenNames = childrenNames;
            this.childCtor = childCtor;
        }

        private Map<String, DummyDbObject> getChildrenMapImpl() {
            if (this.childrenByName == null) {
                if (this.childCtor == null) {
                    this.childrenByName = Collections.emptyMap();
                } else {
                    this.childrenByName = new HashMap<String, DummyDbObject>();
                    int i = 0;
                    for (String name : this.childrenNames) {
                        this.childrenByName.put(name, this.childCtor.apply(this, name, i++));
                    }
                }
            }
            return this.childrenByName;
        }

        @NotNull
        private List<DummyDbObject> getChildrenListImpl() {
            return this.children != null ? this.children : (this.children = new ArrayList<DummyDbObject>(this.getChildrenMapImpl().values()));
        }

        @NotNull
        public DBSEntity getParentObject() {
            return this.container;
        }

        public DBPDataSource getDataSource() {
            return SQLQueryConnectionDummyContext.this.dummyDataSource;
        }

        public DBPImage getObjectImage() {
            return this.image;
        }

        @NotNull
        public String getName() {
            return this.name;
        }

        public String getDescription() {
            return this.description;
        }

        public boolean isPersisted() {
            return true;
        }

        public int getOrdinalPosition() {
            return this.position;
        }

        public boolean isRequired() {
            return true;
        }

        public boolean isAutoGenerated() {
            return false;
        }

        @NotNull
        public String getTypeName() {
            return null;
        }

        @NotNull
        public String getFullTypeName() {
            return null;
        }

        public int getTypeID() {
            return 0;
        }

        @NotNull
        public DBPDataKind getDataKind() {
            return DBPDataKind.STRING;
        }

        public Integer getScale() {
            return null;
        }

        @Nullable
        public Integer getPrecision() {
            return null;
        }

        public long getMaxLength() {
            return 0L;
        }

        public long getTypeModifiers() {
            return 0L;
        }

        public String getDefaultValue() {
            return null;
        }

        @NotNull
        public DBSEntityType getEntityType() {
            return DBSEntityType.TABLE;
        }

        public List<? extends DBSEntityAttribute> getAttributes(@NotNull DBRProgressMonitor monitor) throws DBException {
            return this.getChildrenListImpl();
        }

        public DBSEntityAttribute getAttribute(@NotNull DBRProgressMonitor monitor, @NotNull String attributeName) throws DBException {
            return this.getChildrenMapImpl().get(attributeName);
        }

        public Collection<? extends DBSEntityAssociation> getAssociations(@NotNull DBRProgressMonitor monitor) throws DBException {
            return Collections.emptyList();
        }

        public Collection<? extends DBSEntityAssociation> getReferences(@NotNull DBRProgressMonitor monitor) throws DBException {
            return null;
        }

        @NotNull
        public String getFullyQualifiedName(@NotNull DBPEvaluationContext context) {
            if (this.container == SQLQueryConnectionDummyContext.this.dummyDataSource) {
                return this.name;
            }
            return DBUtils.getFullQualifiedName((DBPDataSource)this.getDataSource(), (DBPNamedObject[])new DBPNamedObject[]{this.container, this});
        }

        public Collection<? extends DBSObject> getChildren(@NotNull DBRProgressMonitor monitor) throws DBException {
            return this.getChildrenListImpl();
        }

        public DBSObject getChild(@NotNull DBRProgressMonitor monitor, @NotNull String childName) throws DBException {
            return (DBSObject)this.getChildrenMapImpl().get(childName);
        }

        @NotNull
        public Class<? extends DBSObject> getPrimaryChildType(@Nullable DBRProgressMonitor monitor) throws DBException {
            return DummyDbObject.class;
        }

        public void cacheStructure(@NotNull DBRProgressMonitor monitor, int scope) throws DBException {
        }

        @NotNull
        public DBSInstance getDefaultInstance() {
            return null;
        }

        @NotNull
        public Collection<? extends DBSInstance> getAvailableInstances() {
            return Collections.emptyList();
        }

        public void shutdown(@NotNull DBRProgressMonitor monitor) {
        }

        @NotNull
        public Map<String, ?> getContextAttributes() {
            return Collections.emptyMap();
        }

        public <T> T getContextAttribute(@NotNull String attributeName) {
            return null;
        }

        public <T> void setContextAttribute(@NotNull String attributeName, @Nullable T attributeValue) {
        }

        public void removeContextAttribute(@NotNull String attributeName) {
        }

        @NotNull
        public DBPDataSourceContainer getContainer() {
            return null;
        }

        @NotNull
        public DBPDataSourceInfo getInfo() {
            return null;
        }

        public Object getDataSourceFeature(String featureId) {
            return null;
        }

        @NotNull
        public SQLDialect getSQLDialect() {
            return SQLQueryConnectionDummyContext.this.dialect;
        }

        public void initialize(@NotNull DBRProgressMonitor monitor) throws DBException {
        }

        public boolean isView() {
            return false;
        }

        public Collection<? extends DBSTableIndex> getIndexes(@NotNull DBRProgressMonitor monitor) throws DBException {
            return Collections.emptyList();
        }

        public Collection<? extends DBSTableConstraint> getConstraints(@NotNull DBRProgressMonitor monitor) throws DBException {
            return Collections.emptyList();
        }

        public List<? extends DBSTrigger> getTriggers(@NotNull DBRProgressMonitor monitor) throws DBException {
            return Collections.emptyList();
        }
    }

    @FunctionalInterface
    private static interface DummyObjectCtor {
        public DummyDbObject apply(DummyDbObject var1, String var2, int var3);
    }
}

