from typing import Optional

from pydantic import BaseModel
from sqlalchemy import Column, Integer, ForeignKey, Double, BigInteger
from sqlalchemy.orm import relationship

from ..base import Base


class FrameTimes(Base):
    __tablename__ = 'frame_times'
    id = Column(Integer, primary_key=True, index=True)
    frame_index = Column(Integer)
    start_ns = Column(BigInteger)
    duration_cpu_ms = Column(Double)
    duration_gpu_ms = Column(Double, nullable=True)

    hotspot_analysis_id = Column(Integer, ForeignKey('hotspot_analysis.id'))
    hotspot_analysis = relationship('HotspotAnalysis', back_populates='frame_times')


class FrameTimesInDB(BaseModel):
    frame_index: int
    start_ns: int
    duration_cpu_ms: float
    duration_gpu_ms: Optional[float]

    class Config:
        from_attributes = True


class FrameTimesCreate(BaseModel):
    frame_index: int
    start_ns: int
    duration_cpu_ms: float
    duration_gpu_ms: Optional[float]

    class Config:
        from_attributes = True
