﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/directconnect/DirectConnect_EXPORTS.h>
#include <aws/directconnect/model/DirectConnectGateway.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace DirectConnect {
namespace Model {
class CreateDirectConnectGatewayResult {
 public:
  AWS_DIRECTCONNECT_API CreateDirectConnectGatewayResult() = default;
  AWS_DIRECTCONNECT_API CreateDirectConnectGatewayResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_DIRECTCONNECT_API CreateDirectConnectGatewayResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>The Direct Connect gateway.</p>
   */
  inline const DirectConnectGateway& GetDirectConnectGateway() const { return m_directConnectGateway; }
  template <typename DirectConnectGatewayT = DirectConnectGateway>
  void SetDirectConnectGateway(DirectConnectGatewayT&& value) {
    m_directConnectGatewayHasBeenSet = true;
    m_directConnectGateway = std::forward<DirectConnectGatewayT>(value);
  }
  template <typename DirectConnectGatewayT = DirectConnectGateway>
  CreateDirectConnectGatewayResult& WithDirectConnectGateway(DirectConnectGatewayT&& value) {
    SetDirectConnectGateway(std::forward<DirectConnectGatewayT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  CreateDirectConnectGatewayResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  DirectConnectGateway m_directConnectGateway;

  Aws::String m_requestId;
  bool m_directConnectGatewayHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace DirectConnect
}  // namespace Aws
