/*
 * Decompiled with CFR 0.152.
 */
package com.pty4j.windows.conpty;

import com.pty4j.windows.conpty.LastErrorExceptionEx;
import com.sun.jna.Native;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.IntByReference;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class WinHandleInputStream
extends InputStream {
    private static final Logger LOG = LoggerFactory.getLogger(WinHandleInputStream.class);
    private final WinNT.HANDLE myReadPipe;
    private volatile boolean myClosed;
    private volatile boolean myClosedExplicitly;
    private final ReentrantLock myLock = new ReentrantLock();
    private int myReadCount = 0;
    private final Condition myReadCountChanged = this.myLock.newCondition();

    public WinHandleInputStream(@NotNull WinNT.HANDLE readPipe) {
        this.myReadPipe = readPipe;
    }

    @Override
    public int read() throws IOException {
        byte[] buf = new byte[1];
        int readBytes = this.read(buf, 0, 1);
        return readBytes == 1 ? buf[0] : -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(byte @NotNull [] b, int off, int len) throws IOException {
        Objects.checkFromIndexSize(off, len, b.length);
        this.myLock.lock();
        try {
            ++this.myReadCount;
            this.myReadCountChanged.signalAll();
        }
        finally {
            this.myLock.unlock();
        }
        if (len == 0) {
            return 0;
        }
        if (this.myClosed) {
            if (this.myClosedExplicitly) {
                throw new IOException("Closed stdin");
            }
            return -1;
        }
        byte[] buffer = new byte[len];
        IntByReference lpNumberOfBytesRead = new IntByReference(0);
        boolean result = Kernel32.INSTANCE.ReadFile(this.myReadPipe, buffer, buffer.length, lpNumberOfBytesRead, null);
        if (!result) {
            int lastError = Native.getLastError();
            if (lastError == 109) {
                return -1;
            }
            throw new LastErrorExceptionEx("ReadFile stdin", lastError);
        }
        int bytesRead = lpNumberOfBytesRead.getValue();
        if (bytesRead == 0) {
            return -1;
        }
        System.arraycopy(buffer, 0, b, off, len);
        return bytesRead;
    }

    @Override
    public void close() throws IOException {
        this.close(true);
    }

    void close(boolean explicit) throws IOException {
        if (explicit) {
            this.myClosedExplicitly = true;
        }
        if (!this.myClosed) {
            this.myClosed = true;
            if (!Kernel32.INSTANCE.CloseHandle(this.myReadPipe)) {
                throw new LastErrorExceptionEx("CloseHandle stdin");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void awaitAvailableOutputIsRead() {
        this.myLock.lock();
        try {
            int oldReadCount;
            if (this.myReadCount == 0 && !this.myReadCountChanged.await(2000L, TimeUnit.MILLISECONDS)) {
                LOG.warn("Nobody called " + WinHandleInputStream.class.getName() + ".read after the process creation!");
                return;
            }
            long start = System.currentTimeMillis();
            do {
                oldReadCount = this.myReadCount;
            } while (this.myReadCountChanged.await(100L, TimeUnit.MILLISECONDS) && oldReadCount < this.myReadCount && System.currentTimeMillis() - start < 2000L);
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            this.myLock.unlock();
        }
    }
}

