/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.declarativedsl.dom.mutation;

import java.util.Iterator;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.internal.declarativedsl.dom.mutation.Digraph;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0018\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\n\u001a\u00020\u000bJ\u0016\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0003J\u0006\u0010\u0010\u001a\u00020\u0011J\u0011\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u000f\u001a\u00020\u0003H\u0086\u0002J\b\u0010\u0013\u001a\u00020\u0014H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/gradle/internal/declarativedsl/dom/mutation/MarkedStates;", "", "size", "", "<init>", "(I)V", "getSize", "()I", "marked", "", "clear", "", "mark", "graph", "Lorg/gradle/internal/declarativedsl/dom/mutation/Digraph;", "vertex", "last", "", "get", "toString", "", "declarative-dsl-core"})
final class MarkedStates {
    private final int size;
    @NotNull
    private final boolean[] marked;

    public MarkedStates(int size) {
        this.size = size;
        int n = 0;
        int n2 = this.size;
        boolean[] blArray = new boolean[n2];
        MarkedStates markedStates = this;
        while (n < n2) {
            int n3 = n++;
            blArray[n3] = false;
        }
        markedStates.marked = blArray;
    }

    public final int getSize() {
        return this.size;
    }

    public final void clear() {
        int n = this.size;
        for (int i = 0; i < n; ++i) {
            this.marked[i] = false;
        }
    }

    public final void mark(@NotNull Digraph graph, int vertex) {
        Intrinsics.checkNotNullParameter((Object)graph, (String)"graph");
        this.marked[vertex] = true;
        Iterator<Integer> iterator = graph.adjacentVertices(vertex).iterator();
        while (iterator.hasNext()) {
            int w = ((Number)iterator.next()).intValue();
            if (this.marked[w]) continue;
            this.mark(graph, w);
        }
    }

    public final boolean last() {
        return ArraysKt.last((boolean[])this.marked);
    }

    public final boolean get(int vertex) {
        return this.marked[vertex];
    }

    @NotNull
    public String toString() {
        StringBuilder stringBuilder;
        StringBuilder $this$toString_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$toString_u24lambda_u240.append("Reachable states out of " + this.size + ':').append('\n');
        int n = this.size;
        for (int i = 0; i < n; ++i) {
            $this$toString_u24lambda_u240.append("" + '\t' + i + " -> " + this.marked[i]).append('\n');
        }
        return stringBuilder.toString();
    }
}

