/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by lister-gen. DO NOT EDIT.

package v1alpha1

import (
	labels "k8s.io/apimachinery/pkg/labels"
	listers "k8s.io/client-go/listers"
	cache "k8s.io/client-go/tools/cache"
	apisxv1alpha1 "sigs.k8s.io/gateway-api/apisx/v1alpha1"
)

// XBackendTrafficPolicyLister helps list XBackendTrafficPolicies.
// All objects returned here must be treated as read-only.
type XBackendTrafficPolicyLister interface {
	// List lists all XBackendTrafficPolicies in the indexer.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*apisxv1alpha1.XBackendTrafficPolicy, err error)
	// XBackendTrafficPolicies returns an object that can list and get XBackendTrafficPolicies.
	XBackendTrafficPolicies(namespace string) XBackendTrafficPolicyNamespaceLister
	XBackendTrafficPolicyListerExpansion
}

// xBackendTrafficPolicyLister implements the XBackendTrafficPolicyLister interface.
type xBackendTrafficPolicyLister struct {
	listers.ResourceIndexer[*apisxv1alpha1.XBackendTrafficPolicy]
}

// NewXBackendTrafficPolicyLister returns a new XBackendTrafficPolicyLister.
func NewXBackendTrafficPolicyLister(indexer cache.Indexer) XBackendTrafficPolicyLister {
	return &xBackendTrafficPolicyLister{listers.New[*apisxv1alpha1.XBackendTrafficPolicy](indexer, apisxv1alpha1.Resource("xbackendtrafficpolicy"))}
}

// XBackendTrafficPolicies returns an object that can list and get XBackendTrafficPolicies.
func (s *xBackendTrafficPolicyLister) XBackendTrafficPolicies(namespace string) XBackendTrafficPolicyNamespaceLister {
	return xBackendTrafficPolicyNamespaceLister{listers.NewNamespaced[*apisxv1alpha1.XBackendTrafficPolicy](s.ResourceIndexer, namespace)}
}

// XBackendTrafficPolicyNamespaceLister helps list and get XBackendTrafficPolicies.
// All objects returned here must be treated as read-only.
type XBackendTrafficPolicyNamespaceLister interface {
	// List lists all XBackendTrafficPolicies in the indexer for a given namespace.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*apisxv1alpha1.XBackendTrafficPolicy, err error)
	// Get retrieves the XBackendTrafficPolicy from the indexer for a given namespace and name.
	// Objects returned here must be treated as read-only.
	Get(name string) (*apisxv1alpha1.XBackendTrafficPolicy, error)
	XBackendTrafficPolicyNamespaceListerExpansion
}

// xBackendTrafficPolicyNamespaceLister implements the XBackendTrafficPolicyNamespaceLister
// interface.
type xBackendTrafficPolicyNamespaceLister struct {
	listers.ResourceIndexer[*apisxv1alpha1.XBackendTrafficPolicy]
}
