/*
The MIT License (MIT)

Copyright (c) 2016-2020 Containous SAS; 2020-2026 Traefik Labs

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.
*/

// Code generated by applyconfiguration-gen. DO NOT EDIT.

package v1alpha1

import (
	dynamic "github.com/traefik/traefik/v3/pkg/config/dynamic"
	intstr "k8s.io/apimachinery/pkg/util/intstr"
)

// LoadBalancerSpecApplyConfiguration represents a declarative configuration of the LoadBalancerSpec type for use
// with apply.
type LoadBalancerSpecApplyConfiguration struct {
	Name               *string                                     `json:"name,omitempty"`
	Kind               *string                                     `json:"kind,omitempty"`
	Namespace          *string                                     `json:"namespace,omitempty"`
	Sticky             *dynamic.Sticky                             `json:"sticky,omitempty"`
	Port               *intstr.IntOrString                         `json:"port,omitempty"`
	Scheme             *string                                     `json:"scheme,omitempty"`
	Strategy           *dynamic.BalancerStrategy                   `json:"strategy,omitempty"`
	PassHostHeader     *bool                                       `json:"passHostHeader,omitempty"`
	ResponseForwarding *ResponseForwardingApplyConfiguration       `json:"responseForwarding,omitempty"`
	ServersTransport   *string                                     `json:"serversTransport,omitempty"`
	Weight             *int                                        `json:"weight,omitempty"`
	NativeLB           *bool                                       `json:"nativeLB,omitempty"`
	NodePortLB         *bool                                       `json:"nodePortLB,omitempty"`
	HealthCheck        *ServerHealthCheckApplyConfiguration        `json:"healthCheck,omitempty"`
	PassiveHealthCheck *PassiveServerHealthCheckApplyConfiguration `json:"passiveHealthCheck,omitempty"`
}

// LoadBalancerSpecApplyConfiguration constructs a declarative configuration of the LoadBalancerSpec type for use with
// apply.
func LoadBalancerSpec() *LoadBalancerSpecApplyConfiguration {
	return &LoadBalancerSpecApplyConfiguration{}
}

// WithName sets the Name field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Name field is set to the value of the last call.
func (b *LoadBalancerSpecApplyConfiguration) WithName(value string) *LoadBalancerSpecApplyConfiguration {
	b.Name = &value
	return b
}

// WithKind sets the Kind field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Kind field is set to the value of the last call.
func (b *LoadBalancerSpecApplyConfiguration) WithKind(value string) *LoadBalancerSpecApplyConfiguration {
	b.Kind = &value
	return b
}

// WithNamespace sets the Namespace field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Namespace field is set to the value of the last call.
func (b *LoadBalancerSpecApplyConfiguration) WithNamespace(value string) *LoadBalancerSpecApplyConfiguration {
	b.Namespace = &value
	return b
}

// WithSticky sets the Sticky field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Sticky field is set to the value of the last call.
func (b *LoadBalancerSpecApplyConfiguration) WithSticky(value dynamic.Sticky) *LoadBalancerSpecApplyConfiguration {
	b.Sticky = &value
	return b
}

// WithPort sets the Port field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Port field is set to the value of the last call.
func (b *LoadBalancerSpecApplyConfiguration) WithPort(value intstr.IntOrString) *LoadBalancerSpecApplyConfiguration {
	b.Port = &value
	return b
}

// WithScheme sets the Scheme field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Scheme field is set to the value of the last call.
func (b *LoadBalancerSpecApplyConfiguration) WithScheme(value string) *LoadBalancerSpecApplyConfiguration {
	b.Scheme = &value
	return b
}

// WithStrategy sets the Strategy field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Strategy field is set to the value of the last call.
func (b *LoadBalancerSpecApplyConfiguration) WithStrategy(value dynamic.BalancerStrategy) *LoadBalancerSpecApplyConfiguration {
	b.Strategy = &value
	return b
}

// WithPassHostHeader sets the PassHostHeader field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the PassHostHeader field is set to the value of the last call.
func (b *LoadBalancerSpecApplyConfiguration) WithPassHostHeader(value bool) *LoadBalancerSpecApplyConfiguration {
	b.PassHostHeader = &value
	return b
}

// WithResponseForwarding sets the ResponseForwarding field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the ResponseForwarding field is set to the value of the last call.
func (b *LoadBalancerSpecApplyConfiguration) WithResponseForwarding(value *ResponseForwardingApplyConfiguration) *LoadBalancerSpecApplyConfiguration {
	b.ResponseForwarding = value
	return b
}

// WithServersTransport sets the ServersTransport field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the ServersTransport field is set to the value of the last call.
func (b *LoadBalancerSpecApplyConfiguration) WithServersTransport(value string) *LoadBalancerSpecApplyConfiguration {
	b.ServersTransport = &value
	return b
}

// WithWeight sets the Weight field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Weight field is set to the value of the last call.
func (b *LoadBalancerSpecApplyConfiguration) WithWeight(value int) *LoadBalancerSpecApplyConfiguration {
	b.Weight = &value
	return b
}

// WithNativeLB sets the NativeLB field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the NativeLB field is set to the value of the last call.
func (b *LoadBalancerSpecApplyConfiguration) WithNativeLB(value bool) *LoadBalancerSpecApplyConfiguration {
	b.NativeLB = &value
	return b
}

// WithNodePortLB sets the NodePortLB field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the NodePortLB field is set to the value of the last call.
func (b *LoadBalancerSpecApplyConfiguration) WithNodePortLB(value bool) *LoadBalancerSpecApplyConfiguration {
	b.NodePortLB = &value
	return b
}

// WithHealthCheck sets the HealthCheck field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the HealthCheck field is set to the value of the last call.
func (b *LoadBalancerSpecApplyConfiguration) WithHealthCheck(value *ServerHealthCheckApplyConfiguration) *LoadBalancerSpecApplyConfiguration {
	b.HealthCheck = value
	return b
}

// WithPassiveHealthCheck sets the PassiveHealthCheck field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the PassiveHealthCheck field is set to the value of the last call.
func (b *LoadBalancerSpecApplyConfiguration) WithPassiveHealthCheck(value *PassiveServerHealthCheckApplyConfiguration) *LoadBalancerSpecApplyConfiguration {
	b.PassiveHealthCheck = value
	return b
}
