/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.interop;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.InvalidArrayIndexException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.DynamicDispatchLibrary;
import com.oracle.truffle.api.library.LibraryExport;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.UnadoptableNode;
import com.oracle.truffle.js.runtime.interop.TopScopeObject;
import java.lang.invoke.VarHandle;

@GeneratedBy(value=TopScopeObject.MergedPropertyNames.class)
final class MergedPropertyNamesGen {
    private static final LibraryFactory<DynamicDispatchLibrary> DYNAMIC_DISPATCH_LIBRARY_ = LibraryFactory.resolve(DynamicDispatchLibrary.class);
    private static final LibraryFactory<InteropLibrary> INTEROP_LIBRARY_ = LibraryFactory.resolve(InteropLibrary.class);

    private MergedPropertyNamesGen() {
    }

    static {
        LibraryExport.register(TopScopeObject.MergedPropertyNames.class, (LibraryExport[])new LibraryExport[]{new InteropLibraryExports()});
    }

    @GeneratedBy(value=TopScopeObject.MergedPropertyNames.class)
    private static final class InteropLibraryExports
    extends LibraryExport<InteropLibrary> {
        private InteropLibraryExports() {
            super(InteropLibrary.class, TopScopeObject.MergedPropertyNames.class, false, false, 0);
        }

        protected InteropLibrary createUncached(Object receiver) {
            assert (receiver instanceof TopScopeObject.MergedPropertyNames);
            Uncached uncached = new Uncached();
            return uncached;
        }

        protected InteropLibrary createCached(Object receiver) {
            assert (receiver instanceof TopScopeObject.MergedPropertyNames);
            return new Cached();
        }

        @GeneratedBy(value=TopScopeObject.MergedPropertyNames.class)
        @DenyReplace
        private static final class Uncached
        extends InteropLibrary
        implements UnadoptableNode {
            protected Uncached() {
            }

            @CompilerDirectives.TruffleBoundary
            public boolean accepts(Object receiver) {
                assert (!(receiver instanceof TopScopeObject.MergedPropertyNames) || ((DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached()).dispatch(receiver) == null) : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                return receiver instanceof TopScopeObject.MergedPropertyNames;
            }

            @CompilerDirectives.TruffleBoundary
            public boolean hasArrayElements(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((TopScopeObject.MergedPropertyNames)receiver).hasArrayElements();
            }

            @CompilerDirectives.TruffleBoundary
            public long getArraySize(Object receiver) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((TopScopeObject.MergedPropertyNames)receiver).getArraySize();
            }

            @CompilerDirectives.TruffleBoundary
            public boolean isArrayElementReadable(Object arg0Value_, long arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                TopScopeObject.MergedPropertyNames arg0Value = (TopScopeObject.MergedPropertyNames)arg0Value_;
                return arg0Value.isArrayElementReadable(arg1Value, (InteropLibrary)INTEROP_LIBRARY_.getUncached());
            }

            @CompilerDirectives.TruffleBoundary
            public Object readArrayElement(Object arg0Value_, long arg1Value) throws InvalidArrayIndexException, UnsupportedMessageException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                TopScopeObject.MergedPropertyNames arg0Value = (TopScopeObject.MergedPropertyNames)arg0Value_;
                return arg0Value.readArrayElement(arg1Value, (InteropLibrary)INTEROP_LIBRARY_.getUncached());
            }
        }

        @GeneratedBy(value=TopScopeObject.MergedPropertyNames.class)
        private static final class Cached
        extends InteropLibrary {
            @CompilerDirectives.CompilationFinal
            private int state_0_;
            @Node.Child
            private InteropLibrary interop;

            protected Cached() {
            }

            public boolean accepts(Object receiver) {
                assert (!(receiver instanceof TopScopeObject.MergedPropertyNames) || ((DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached()).dispatch(receiver) == null) : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                return receiver instanceof TopScopeObject.MergedPropertyNames;
            }

            public boolean hasArrayElements(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return ((TopScopeObject.MergedPropertyNames)receiver).hasArrayElements();
            }

            public long getArraySize(Object receiver) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return ((TopScopeObject.MergedPropertyNames)receiver).getArraySize();
            }

            public boolean isArrayElementReadable(Object arg0Value_, long arg1Value) {
                InteropLibrary interop_;
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                TopScopeObject.MergedPropertyNames arg0Value = (TopScopeObject.MergedPropertyNames)arg0Value_;
                int state_0 = this.state_0_;
                if ((state_0 & 1) != 0 && (interop_ = this.interop) != null) {
                    return arg0Value.isArrayElementReadable(arg1Value, interop_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.isArrayElementReadableNode_AndSpecialize(arg0Value, arg1Value);
            }

            private boolean isArrayElementReadableNode_AndSpecialize(TopScopeObject.MergedPropertyNames arg0Value, long arg1Value) {
                InteropLibrary interop_;
                int state_0 = this.state_0_;
                InteropLibrary interop__shared = this.interop;
                if (interop__shared != null) {
                    interop_ = interop__shared;
                } else {
                    interop_ = (InteropLibrary)this.insert((Node)((InteropLibrary)INTEROP_LIBRARY_.createDispatched(5)));
                    if (interop_ == null) {
                        throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.interop == null) {
                    VarHandle.storeStoreFence();
                    this.interop = interop_;
                }
                this.state_0_ = state_0 |= 1;
                return arg0Value.isArrayElementReadable(arg1Value, interop_);
            }

            public Object readArrayElement(Object arg0Value_, long arg1Value) throws UnsupportedMessageException, InvalidArrayIndexException {
                InteropLibrary interop_;
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                TopScopeObject.MergedPropertyNames arg0Value = (TopScopeObject.MergedPropertyNames)arg0Value_;
                int state_0 = this.state_0_;
                if ((state_0 & 2) != 0 && (interop_ = this.interop) != null) {
                    return arg0Value.readArrayElement(arg1Value, interop_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.readArrayElementNode_AndSpecialize(arg0Value, arg1Value);
            }

            private Object readArrayElementNode_AndSpecialize(TopScopeObject.MergedPropertyNames arg0Value, long arg1Value) throws InvalidArrayIndexException, UnsupportedMessageException {
                InteropLibrary interop_;
                int state_0 = this.state_0_;
                InteropLibrary interop__shared = this.interop;
                if (interop__shared != null) {
                    interop_ = interop__shared;
                } else {
                    interop_ = (InteropLibrary)this.insert((Node)((InteropLibrary)INTEROP_LIBRARY_.createDispatched(5)));
                    if (interop_ == null) {
                        throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.interop == null) {
                    VarHandle.storeStoreFence();
                    this.interop = interop_;
                }
                this.state_0_ = state_0 |= 2;
                return arg0Value.readArrayElement(arg1Value, interop_);
            }
        }
    }
}

