/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.grpc.opentelemetry;

import java.util.logging.Level;
import java.util.logging.Logger;
import net.snowflake.client.jdbc.internal.google.common.io.BaseEncoding;
import net.snowflake.client.jdbc.internal.grpc.Metadata;
import net.snowflake.client.jdbc.internal.javax.annotation.Nullable;
import net.snowflake.client.jdbc.internal.opentelemetry.context.propagation.TextMapSetter;

final class MetadataSetter
implements TextMapSetter<Metadata> {
    private static final Logger logger = Logger.getLogger(MetadataSetter.class.getName());
    private static final MetadataSetter INSTANCE = new MetadataSetter();

    MetadataSetter() {
    }

    public static MetadataSetter getInstance() {
        return INSTANCE;
    }

    @Override
    public void set(@Nullable Metadata carrier, String key, String value) {
        if (carrier == null) {
            logger.log(Level.FINE, "Carrier is null, setting no data");
            return;
        }
        try {
            if (key.equals("net.snowflake.client.jdbc.internal.grpc-trace-bin")) {
                carrier.put(Metadata.Key.of(key, Metadata.BINARY_BYTE_MARSHALLER), BaseEncoding.base64().decode(value));
            } else {
                carrier.put(Metadata.Key.of(key, Metadata.ASCII_STRING_MARSHALLER), value);
            }
        }
        catch (Exception e) {
            logger.log(Level.INFO, String.format("Failed to set metadata, key=%s", key), e);
        }
    }

    void set(@Nullable Metadata carrier, String key, byte[] value) {
        if (carrier == null) {
            logger.log(Level.FINE, "Carrier is null, setting no data");
            return;
        }
        if (!key.equals("net.snowflake.client.jdbc.internal.grpc-trace-bin")) {
            logger.log(Level.INFO, "Only support 'grpc-trace-bin' binary header. Set no data");
            return;
        }
        try {
            carrier.put(Metadata.Key.of(key, Metadata.BINARY_BYTE_MARSHALLER), value);
        }
        catch (Exception e) {
            logger.log(Level.INFO, String.format("Failed to set metadata key=%s", key), e);
        }
    }
}

