/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api;

import com.oracle.truffle.api.CompilerDirectives;

public final class ExactMath {
    private ExactMath() {
    }

    public static int multiplyHigh(int x, int y) {
        long r = (long)x * (long)y;
        return (int)(r >> 32);
    }

    public static int multiplyHighUnsigned(int x, int y) {
        long xl = (long)x & 0xFFFFFFFFL;
        long yl = (long)y & 0xFFFFFFFFL;
        long r = xl * yl;
        return (int)(r >> 32);
    }

    public static long multiplyHigh(long x, long y) {
        long x0 = x & 0xFFFFFFFFL;
        long x1 = x >> 32;
        long y0 = y & 0xFFFFFFFFL;
        long y1 = y >> 32;
        long z0 = x0 * y0;
        long t = x1 * y0 + (z0 >>> 32);
        long z1 = t & 0xFFFFFFFFL;
        long z2 = t >> 32;
        return x1 * y1 + z2 + ((z1 += x0 * y1) >> 32);
    }

    public static long multiplyHighUnsigned(long x, long y) {
        long x0 = x & 0xFFFFFFFFL;
        long x1 = x >>> 32;
        long y0 = y & 0xFFFFFFFFL;
        long y1 = y >>> 32;
        long z0 = x0 * y0;
        long t = x1 * y0 + (z0 >>> 32);
        long z1 = t & 0xFFFFFFFFL;
        long z2 = t >>> 32;
        return x1 * y1 + z2 + ((z1 += x0 * y1) >>> 32);
    }

    public static float truncate(float x) {
        return (float)ExactMath.truncate((double)x);
    }

    public static double truncate(double x) {
        return x < 0.0 ? Math.ceil(x) : Math.floor(x);
    }

    public static long truncateToUnsignedLong(double x) {
        if (CompilerDirectives.injectBranchProbability(0.25, x >= 9.223372036854776E18)) {
            long signedResult = (long)(x - 9.223372036854776E18);
            return signedResult | Long.MIN_VALUE;
        }
        long signedResult = (long)x;
        return signedResult & (signedResult >> 63 ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public static long truncateToUnsignedLong(float x) {
        if (CompilerDirectives.injectBranchProbability(0.25, x >= 9.223372E18f)) {
            long signedResult = (long)(x - 9.223372E18f);
            return signedResult | Long.MIN_VALUE;
        }
        long signedResult = (long)x;
        return signedResult & (signedResult >> 63 ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public static int truncateToUnsignedInt(double x) {
        if (CompilerDirectives.injectBranchProbability(0.25, x >= 2.147483648E9)) {
            int signedResult = (int)(x - 2.147483648E9);
            return signedResult | Integer.MIN_VALUE;
        }
        int signedResult = (int)x;
        return signedResult & ~(signedResult >> 31);
    }

    public static int truncateToUnsignedInt(float x) {
        if (CompilerDirectives.injectBranchProbability(0.25, x >= 2.1474836E9f)) {
            int signedResult = (int)(x - 2.1474836E9f);
            return signedResult | Integer.MIN_VALUE;
        }
        int signedResult = (int)x;
        return signedResult & ~(signedResult >> 31);
    }

    public static double unsignedToDouble(long x) {
        if (CompilerDirectives.injectBranchProbability(0.75, x >= 0L)) {
            return x;
        }
        double halfRoundUp = x >>> 1 | x & 1L;
        return halfRoundUp + halfRoundUp;
    }

    public static float unsignedToFloat(long x) {
        if (CompilerDirectives.injectBranchProbability(0.75, x >= 0L)) {
            return x;
        }
        float halfRoundUp = x >>> 1 | x & 1L;
        return halfRoundUp + halfRoundUp;
    }
}

