/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.grpc.xds;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.snowflake.client.jdbc.internal.google.common.base.Preconditions;
import net.snowflake.client.jdbc.internal.google.common.collect.ImmutableMap;
import net.snowflake.client.jdbc.internal.grpc.Attributes;
import net.snowflake.client.jdbc.internal.grpc.ConnectivityState;
import net.snowflake.client.jdbc.internal.grpc.InternalLogId;
import net.snowflake.client.jdbc.internal.grpc.LoadBalancer;
import net.snowflake.client.jdbc.internal.grpc.Status;
import net.snowflake.client.jdbc.internal.grpc.util.ForwardingLoadBalancerHelper;
import net.snowflake.client.jdbc.internal.grpc.util.GracefulSwitchLoadBalancer;
import net.snowflake.client.jdbc.internal.grpc.xds.AddressFilter;
import net.snowflake.client.jdbc.internal.grpc.xds.WeightedRandomPicker;
import net.snowflake.client.jdbc.internal.grpc.xds.WeightedTargetLoadBalancerProvider;
import net.snowflake.client.jdbc.internal.grpc.xds.client.XdsLogger;
import net.snowflake.client.jdbc.internal.javax.annotation.Nullable;

final class WeightedTargetLoadBalancer
extends LoadBalancer {
    public static final Attributes.Key<String> CHILD_NAME = Attributes.Key.create("net.snowflake.client.jdbc.internal.grpc.xds.WeightedTargetLoadBalancer.CHILD_NAME");
    private final XdsLogger logger;
    private final Map<String, GracefulSwitchLoadBalancer> childBalancers = new HashMap<String, GracefulSwitchLoadBalancer>();
    private final Map<String, ChildHelper> childHelpers = new HashMap<String, ChildHelper>();
    private final LoadBalancer.Helper helper;
    private Map<String, WeightedTargetLoadBalancerProvider.WeightedPolicySelection> targets = ImmutableMap.of();
    private boolean resolvingAddresses;

    WeightedTargetLoadBalancer(LoadBalancer.Helper helper) {
        this.helper = Preconditions.checkNotNull(helper, "helper");
        this.logger = XdsLogger.withLogId(InternalLogId.allocate("weighted-target-lb", helper.getAuthority()));
        this.logger.log(XdsLogger.XdsLogLevel.INFO, "Created", new Object[0]);
    }

    @Override
    public Status acceptResolvedAddresses(LoadBalancer.ResolvedAddresses resolvedAddresses) {
        try {
            this.resolvingAddresses = true;
            Status status = this.acceptResolvedAddressesInternal(resolvedAddresses);
            return status;
        }
        finally {
            this.resolvingAddresses = false;
        }
    }

    public Status acceptResolvedAddressesInternal(LoadBalancer.ResolvedAddresses resolvedAddresses) {
        this.logger.log(XdsLogger.XdsLogLevel.DEBUG, "Received resolution result: {0}", resolvedAddresses);
        Object lbConfig = resolvedAddresses.getLoadBalancingPolicyConfig();
        Preconditions.checkNotNull(lbConfig, "missing weighted_target lb config");
        WeightedTargetLoadBalancerProvider.WeightedTargetConfig weightedTargetConfig = (WeightedTargetLoadBalancerProvider.WeightedTargetConfig)lbConfig;
        Map<String, WeightedTargetLoadBalancerProvider.WeightedPolicySelection> newTargets = weightedTargetConfig.targets;
        for (String targetName : newTargets.keySet()) {
            if (this.targets.containsKey(targetName)) continue;
            ChildHelper childHelper = new ChildHelper(targetName);
            GracefulSwitchLoadBalancer childBalancer = new GracefulSwitchLoadBalancer(childHelper);
            this.childHelpers.put(targetName, childHelper);
            this.childBalancers.put(targetName, childBalancer);
        }
        this.targets = newTargets;
        Status status = Status.OK;
        for (String targetName : this.targets.keySet()) {
            Status newStatus = this.childBalancers.get(targetName).acceptResolvedAddresses(resolvedAddresses.toBuilder().setAddresses(AddressFilter.filter(resolvedAddresses.getAddresses(), targetName)).setLoadBalancingPolicyConfig(this.targets.get((Object)targetName).childConfig).setAttributes(resolvedAddresses.getAttributes().toBuilder().set(CHILD_NAME, targetName).build()).build());
            if (newStatus.isOk()) continue;
            status = newStatus;
        }
        for (String targetName : this.childBalancers.keySet()) {
            if (this.targets.containsKey(targetName)) continue;
            this.childBalancers.get(targetName).shutdown();
        }
        this.childBalancers.keySet().retainAll(this.targets.keySet());
        this.childHelpers.keySet().retainAll(this.targets.keySet());
        this.updateOverallBalancingState();
        return status;
    }

    @Override
    public void handleNameResolutionError(Status error) {
        this.logger.log(XdsLogger.XdsLogLevel.WARNING, "Received name resolution error: {0}", error);
        if (this.childBalancers.isEmpty()) {
            this.helper.updateBalancingState(ConnectivityState.TRANSIENT_FAILURE, new LoadBalancer.FixedResultPicker(LoadBalancer.PickResult.withError(error)));
        }
        for (LoadBalancer loadBalancer : this.childBalancers.values()) {
            loadBalancer.handleNameResolutionError(error);
        }
    }

    @Override
    public boolean canHandleEmptyAddressListFromNameResolution() {
        return true;
    }

    @Override
    public void shutdown() {
        this.logger.log(XdsLogger.XdsLogLevel.INFO, "Shutdown", new Object[0]);
        for (LoadBalancer loadBalancer : this.childBalancers.values()) {
            loadBalancer.shutdown();
        }
        this.childBalancers.clear();
    }

    private void updateOverallBalancingState() {
        ArrayList<WeightedRandomPicker.WeightedChildPicker> childPickers = new ArrayList<WeightedRandomPicker.WeightedChildPicker>();
        ConnectivityState overallState = null;
        ArrayList<WeightedRandomPicker.WeightedChildPicker> errorPickers = new ArrayList<WeightedRandomPicker.WeightedChildPicker>();
        for (String name : this.targets.keySet()) {
            ChildHelper childHelper = this.childHelpers.get(name);
            ConnectivityState childState = childHelper.currentState;
            overallState = WeightedTargetLoadBalancer.aggregateState(overallState, childState);
            int weight = this.targets.get((Object)name).weight;
            if (ConnectivityState.READY == childState) {
                childPickers.add(new WeightedRandomPicker.WeightedChildPicker(weight, childHelper.currentPicker));
                continue;
            }
            if (ConnectivityState.TRANSIENT_FAILURE != childState) continue;
            errorPickers.add(new WeightedRandomPicker.WeightedChildPicker(weight, childHelper.currentPicker));
        }
        LoadBalancer.SubchannelPicker picker = childPickers.isEmpty() ? (overallState == ConnectivityState.TRANSIENT_FAILURE ? new WeightedRandomPicker(errorPickers) : new LoadBalancer.FixedResultPicker(LoadBalancer.PickResult.withNoResult())) : new WeightedRandomPicker(childPickers);
        if (overallState != null) {
            this.helper.updateBalancingState(overallState, picker);
        }
    }

    @Nullable
    private static ConnectivityState aggregateState(@Nullable ConnectivityState overallState, ConnectivityState childState) {
        if (overallState == null) {
            return childState;
        }
        if (overallState == ConnectivityState.READY || childState == ConnectivityState.READY) {
            return ConnectivityState.READY;
        }
        if (overallState == ConnectivityState.CONNECTING || childState == ConnectivityState.CONNECTING) {
            return ConnectivityState.CONNECTING;
        }
        if (overallState == ConnectivityState.IDLE || childState == ConnectivityState.IDLE) {
            return ConnectivityState.IDLE;
        }
        return overallState;
    }

    private final class ChildHelper
    extends ForwardingLoadBalancerHelper {
        String name;
        ConnectivityState currentState = ConnectivityState.CONNECTING;
        LoadBalancer.SubchannelPicker currentPicker = new LoadBalancer.FixedResultPicker(LoadBalancer.PickResult.withNoResult());

        private ChildHelper(String name) {
            this.name = name;
        }

        @Override
        public void updateBalancingState(ConnectivityState newState, LoadBalancer.SubchannelPicker newPicker) {
            this.currentState = newState;
            this.currentPicker = newPicker;
            if (!WeightedTargetLoadBalancer.this.resolvingAddresses && WeightedTargetLoadBalancer.this.childBalancers.containsKey(this.name)) {
                WeightedTargetLoadBalancer.this.updateOverallBalancingState();
            }
        }

        @Override
        protected LoadBalancer.Helper delegate() {
            return WeightedTargetLoadBalancer.this.helper;
        }
    }
}

