/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.grpc;

import net.snowflake.client.jdbc.internal.google.common.base.MoreObjects;
import net.snowflake.client.jdbc.internal.google.common.base.Objects;
import net.snowflake.client.jdbc.internal.google.common.base.Preconditions;
import net.snowflake.client.jdbc.internal.grpc.ExperimentalApi;
import net.snowflake.client.jdbc.internal.grpc.Status;
import net.snowflake.client.jdbc.internal.javax.annotation.Nullable;

@ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/11563")
public class StatusOr<T> {
    @Nullable
    private final Status status;
    private final T value;

    private StatusOr(Status status, T value) {
        this.status = status;
        this.value = value;
    }

    public static <T> StatusOr<T> fromValue(T value) {
        StatusOr<T> result = new StatusOr<T>(null, value);
        return result;
    }

    public static <T> StatusOr<T> fromStatus(Status status) {
        StatusOr<Object> result = new StatusOr<Object>(Preconditions.checkNotNull(status, "status"), null);
        Preconditions.checkArgument(!status.isOk(), "cannot use OK status: %s", (Object)status);
        return result;
    }

    public boolean hasValue() {
        return this.status == null;
    }

    public T getValue() {
        if (this.status != null) {
            throw new IllegalStateException("No value present.");
        }
        return this.value;
    }

    public Status getStatus() {
        return this.status == null ? Status.OK : this.status;
    }

    public boolean equals(Object other) {
        if (!(other instanceof StatusOr)) {
            return false;
        }
        StatusOr otherStatus = (StatusOr)other;
        if (this.hasValue() != otherStatus.hasValue()) {
            return false;
        }
        if (this.hasValue()) {
            return Objects.equal(this.value, otherStatus.value);
        }
        return Objects.equal(this.status, otherStatus.status);
    }

    public int hashCode() {
        return Objects.hashCode(this.status, this.value);
    }

    public String toString() {
        MoreObjects.ToStringHelper stringHelper = MoreObjects.toStringHelper(this);
        if (this.status == null) {
            stringHelper.add("value", this.value);
        } else {
            stringHelper.add("error", this.status);
        }
        return stringHelper.toString();
    }
}

