/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.amazonaws.auth;

import net.snowflake.client.jdbc.internal.amazonaws.auth.AWSCredentials;
import net.snowflake.client.jdbc.internal.amazonaws.auth.AccountIdAware;
import net.snowflake.client.jdbc.internal.amazonaws.auth.ProviderNameAware;

public class BasicAWSCredentials
implements AWSCredentials,
AccountIdAware,
ProviderNameAware {
    private final String accessKey;
    private final String secretKey;
    private final String accountId;
    private final String providerName;

    public BasicAWSCredentials(String accessKey, String secretKey) {
        this(accessKey, secretKey, null, null);
    }

    public BasicAWSCredentials(String accessKey, String secretKey, String accountId) {
        this(accessKey, secretKey, accountId, null);
    }

    public BasicAWSCredentials(String accessKey, String secretKey, String accountId, String providerName) {
        if (accessKey == null) {
            throw new IllegalArgumentException("Access key cannot be null.");
        }
        if (secretKey == null) {
            throw new IllegalArgumentException("Secret key cannot be null.");
        }
        this.accessKey = accessKey;
        this.secretKey = secretKey;
        this.accountId = accountId;
        this.providerName = providerName;
    }

    @Override
    public String getAWSAccessKeyId() {
        return this.accessKey;
    }

    @Override
    public String getAWSSecretKey() {
        return this.secretKey;
    }

    @Override
    public String getAccountId() {
        return this.accountId;
    }

    @Override
    public String getProviderName() {
        return this.providerName;
    }
}

