/*
 * Decompiled with CFR 0.152.
 */
package git4idea.rebase;

import com.intellij.CommonBundle;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import git4idea.commands.GitImplBase;
import git4idea.i18n.GitBundle;
import git4idea.rebase.GitRebaseEditingResult;
import git4idea.rebase.GitRebaseEditorHandler;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitSimpleEditorHandler
implements GitRebaseEditorHandler {
    private static final Logger LOG = Logger.getInstance(GitSimpleEditorHandler.class);
    @NotNull
    private final Project myProject;
    private GitRebaseEditingResult myResult;

    public GitSimpleEditorHandler(@NotNull Project project) {
        if (project == null) {
            GitSimpleEditorHandler.$$$reportNull$$$0(0);
        }
        this.myResult = null;
        this.myProject = project;
    }

    @Override
    public int editCommits(@NotNull File file) {
        GitRebaseEditingResult result2;
        if (file == null) {
            GitSimpleEditorHandler.$$$reportNull$$$0(1);
        }
        try {
            boolean cancelled = !GitImplBase.loadFileAndShowInSimpleEditor(this.myProject, null, file, GitBundle.message("rebase.simple.editor.dialog.title", new Object[0]), CommonBundle.getOkButtonText());
            result2 = cancelled ? GitRebaseEditingResult.UnstructuredEditorCancelled.INSTANCE : GitRebaseEditingResult.WasEdited.INSTANCE;
        }
        catch (Exception e) {
            LOG.error("Failed to edit git rebase file: " + String.valueOf(file), (Throwable)e);
            result2 = new GitRebaseEditingResult.Failed(e);
        }
        this.myResult = result2;
        return result2.getExitCode();
    }

    @Override
    @Nullable
    public GitRebaseEditingResult getEditingResult() {
        return this.myResult;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        objectArray2[1] = "git4idea/rebase/GitSimpleEditorHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "editCommits";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

