/*=========================================================================
*
*  Copyright NumFOCUS
*
*  Licensed under the Apache License, Version 2.0 (the "License");
*  you may not use this file except in compliance with the License.
*  You may obtain a copy of the License at
*
*         http://www.apache.org/licenses/LICENSE-2.0.txt
*
*  Unless required by applicable law or agreed to in writing, software
*  distributed under the License is distributed on an "AS IS" BASIS,
*  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
*  See the License for the specific language governing permissions and
*  limitations under the License.
*
*=========================================================================*/
/*
 * WARNING: DO NOT EDIT THIS FILE!
 * THIS FILE IS AUTOMATICALLY GENERATED BY THE SIMPLEITK BUILD PROCESS.
 * Please look at sitkImageFilterTemplate.cxx.in to make changes.
 */

#include "itkImage.h"
#include "itkVectorImage.h"
#include "itkLabelMap.h"
#include "itkLabelObject.h"
#include "itkNumericTraits.h"
#include "itkNumericTraitsVariableLengthVectorPixel.h"
#include "itkVectorIndexSelectionCastImageFilter.h"
#include "itkComposeImageFilter.h"

#include "sitkSLICImageFilter.h"
#include "itkSLICImageFilter.h"



namespace itk::simple {

//-----------------------------------------------------------------------------

//
// Default constructor that initializes parameters
//
SLICImageFilter::SLICImageFilter ()
{
  this->m_MemberFactory =  std::make_unique<detail::MemberFunctionFactory<MemberFunctionType>>( this );

  this->m_MemberFactory->RegisterMemberFunctions< PixelIDTypeList, 2, 3 > ();



}

//
// Destructor
//
SLICImageFilter::~SLICImageFilter(){
  if (this->m_Filter != nullptr)
    {
      m_Filter->UnRegister();
    }
}




//
// ToString
//
std::string SLICImageFilter::ToString() const
{
  std::ostringstream out;
  out << "itk::simple::SLICImageFilter\n";
  out << "  SuperGridSize: ";
  this->ToStringHelper(out, this->m_SuperGridSize);
  out << std::endl;
  out << "  SpatialProximityWeight: ";
  this->ToStringHelper(out, this->m_SpatialProximityWeight);
  out << std::endl;
  out << "  MaximumNumberOfIterations: ";
  this->ToStringHelper(out, this->m_MaximumNumberOfIterations);
  out << std::endl;
  out << "  EnforceConnectivity: ";
  this->ToStringHelper(out, this->m_EnforceConnectivity);
  out << std::endl;
  out << "  InitializationPerturbation: ";
  this->ToStringHelper(out, this->m_InitializationPerturbation);
  out << std::endl;
  out << "  AverageResidual: ";
  if (bool(this->m_pfGetAverageResidual))
  {
    this->ToStringHelper(out, this->m_pfGetAverageResidual());
  }
  else
  {
    out << "(null)";
  }
  out << std::endl;
  out << ProcessObject::ToString();
  return out.str();
}

//
// Execute
//
Image SLICImageFilter::Execute ( const Image& image1 )
{
  const PixelIDValueEnum type = image1.GetPixelID();
  const unsigned int dimension = image1.GetDimension();

  return this->m_MemberFactory->GetMemberFunction( type, dimension )( image1 );
}



//-----------------------------------------------------------------------------

sitkClangDiagnosticPush();
sitkClangWarningIgnore("-Wunused-local-typedef");

//
// ExecuteInternal
//
template <class TImageType>
Image SLICImageFilter::ExecuteInternal ( const Image& inImage1 )
{
  // Define the input and output image types
  using InputImageType = TImageType;


  // Define output image type
  using OutputImageType = itk::Image< uint32_t, InputImageType::ImageDimension >;

  // Get the pointer to the ITK image contained in image1
  typename InputImageType::ConstPointer image1 = this->CastImageToITK<InputImageType>( inImage1 );


  using FilterType =  itk::SLICImageFilter<InputImageType,  OutputImageType>;
  // Set up the ITK filter
  typename FilterType::Pointer filter = FilterType::New();

  filter->SetInput( 0, image1 );



  typename FilterType::SuperGridSizeType itkVecSuperGridSize = sitkSTLVectorToITK<typename FilterType::SuperGridSizeType>( this->GetSuperGridSize() );
  filter->SetSuperGridSize( itkVecSuperGridSize );
  filter->SetSpatialProximityWeight ( this->m_SpatialProximityWeight );
  filter->SetMaximumNumberOfIterations ( this->m_MaximumNumberOfIterations );
  filter->SetEnforceConnectivity ( this->m_EnforceConnectivity );
  filter->SetInitializationPerturbation ( this->m_InitializationPerturbation );



  // release the old filter ( and output data )
  if ( this->m_Filter != nullptr)
    {
      this->m_pfGetAverageResidual = nullptr;
      this->m_Filter->UnRegister();
      this->m_Filter = nullptr;
    }

  this->m_Filter = filter;
  this->m_Filter->Register();


  this->PreUpdate( filter.GetPointer() );

  this->m_pfGetAverageResidual = [ f = filter.GetPointer() ] {
    const auto & value = f->GetAverageResidual();
    return value;
  };


  // Run the ITK filter and return the output as a SimpleITK image
  filter->Update();



  typename FilterType::OutputImageType::Pointer itkOutImage{ filter->GetOutput()};
  filter = nullptr;
  this->FixNonZeroIndex( itkOutImage.GetPointer() );
  return Image{ this->CastITKToImage( itkOutImage.GetPointer() ) };

}

sitkClangDiagnosticPop();

//-----------------------------------------------------------------------------


//
// Function to run the Execute method of this filter
//
Image SLIC ( const Image& image1, std::vector<unsigned int> superGridSize, double spatialProximityWeight, uint32_t maximumNumberOfIterations, bool enforceConnectivity, bool initializationPerturbation )
{
  SLICImageFilter filter;
  filter.SetSuperGridSize( superGridSize );  filter.SetSpatialProximityWeight( spatialProximityWeight );  filter.SetMaximumNumberOfIterations( maximumNumberOfIterations );  filter.SetEnforceConnectivity( enforceConnectivity );  filter.SetInitializationPerturbation( initializationPerturbation );
  return filter.Execute ( image1 );
}


}
