/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEBGL)

#include "JSEXTShaderTextureLOD.h"

#include "ActiveDOMObject.h"
#include "ContextDestructionObserverInlines.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSDOMBinding.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include "WebCoreOpaqueRootInlines.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/text/MakeString.h>

namespace WebCore {
using namespace JSC;

class JSEXTShaderTextureLODPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSEXTShaderTextureLODPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSEXTShaderTextureLODPrototype* ptr = new (NotNull, JSC::allocateCell<JSEXTShaderTextureLODPrototype>(vm)) JSEXTShaderTextureLODPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSEXTShaderTextureLODPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSEXTShaderTextureLODPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSEXTShaderTextureLODPrototype, JSEXTShaderTextureLODPrototype::Base);

/* Hash table for prototype */
const ClassInfo JSEXTShaderTextureLODPrototype::s_info = { "EXTShaderTextureLOD"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSEXTShaderTextureLODPrototype) };

void JSEXTShaderTextureLODPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSEXTShaderTextureLOD::s_info = { "EXTShaderTextureLOD"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSEXTShaderTextureLOD) };

JSEXTShaderTextureLOD::JSEXTShaderTextureLOD(Structure* structure, JSDOMGlobalObject& globalObject, Ref<EXTShaderTextureLOD>&& impl)
    : JSDOMWrapper<EXTShaderTextureLOD>(structure, globalObject, WTFMove(impl))
{
}

static_assert(!std::is_base_of<ActiveDOMObject, EXTShaderTextureLOD>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSEXTShaderTextureLOD::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSEXTShaderTextureLODPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype());
    structure->setMayBePrototype(true);
    return JSEXTShaderTextureLODPrototype::create(vm, &globalObject, structure);
}

JSObject* JSEXTShaderTextureLOD::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSEXTShaderTextureLOD>(vm, globalObject);
}

void JSEXTShaderTextureLOD::destroy(JSC::JSCell* cell)
{
    JSEXTShaderTextureLOD* thisObject = static_cast<JSEXTShaderTextureLOD*>(cell);
    thisObject->JSEXTShaderTextureLOD::~JSEXTShaderTextureLOD();
}

JSC::GCClient::IsoSubspace* JSEXTShaderTextureLOD::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSEXTShaderTextureLOD, UseCustomHeapCellType::No>(vm, "JSEXTShaderTextureLOD"_s,
        [] (auto& spaces) { return spaces.m_clientSubspaceForEXTShaderTextureLOD.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForEXTShaderTextureLOD = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForEXTShaderTextureLOD.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForEXTShaderTextureLOD = std::forward<decltype(space)>(space); }
    );
}

void JSEXTShaderTextureLOD::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSEXTShaderTextureLOD*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (RefPtr context = thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, makeString("url "_s, context->url().string()));
    Base::analyzeHeap(cell, analyzer);
}

bool JSEXTShaderTextureLODOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, ASCIILiteral* reason)
{
    auto* jsEXTShaderTextureLOD = jsCast<JSEXTShaderTextureLOD*>(handle.slot()->asCell());
    auto& owner = jsEXTShaderTextureLOD->wrapped();
    if (reason) [[unlikely]]
        *reason = "Reachable from jsEXTShaderTextureLOD"_s;
    return containsWebCoreOpaqueRoot(visitor, owner);
}

void JSEXTShaderTextureLODOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsEXTShaderTextureLOD = static_cast<JSEXTShaderTextureLOD*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsEXTShaderTextureLOD->protectedWrapped().ptr(), jsEXTShaderTextureLOD);
}

WTF_ALLOW_UNSAFE_BUFFER_USAGE_BEGIN
#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7EXTShaderTextureLOD@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore19EXTShaderTextureLODE[]; }
#endif
template<std::same_as<EXTShaderTextureLOD> T>
static inline void verifyVTable(EXTShaderTextureLOD* ptr) 
{
    if constexpr (std::is_polymorphic_v<T>) {
        const void* actualVTablePointer = getVTablePointer<T>(ptr);
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7EXTShaderTextureLOD@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore19EXTShaderTextureLODE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // EXTShaderTextureLOD has subclasses. If EXTShaderTextureLOD has subclasses that get passed
        // to toJS() we currently require EXTShaderTextureLOD you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
    }
}
#endif
WTF_ALLOW_UNSAFE_BUFFER_USAGE_END

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<EXTShaderTextureLOD>&& impl)
{
#if ENABLE(BINDING_INTEGRITY)
    verifyVTable<EXTShaderTextureLOD>(impl.ptr());
#endif
    return createWrapper<EXTShaderTextureLOD>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, EXTShaderTextureLOD& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

EXTShaderTextureLOD* JSEXTShaderTextureLOD::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSEXTShaderTextureLOD*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(WEBGL)
