/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSSVGGeometryElement.h"

#include "ActiveDOMObject.h"
#include "ContextDestructionObserverInlines.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertDictionary.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMOperation.h"
#include "JSDOMPointInit.h"
#include "JSDOMWrapperCache.h"
#include "JSSVGAnimatedNumber.h"
#include "JSSVGPoint.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/text/MakeString.h>

namespace WebCore {
using namespace JSC;

// Functions

static JSC_DECLARE_HOST_FUNCTION(jsSVGGeometryElementPrototypeFunction_isPointInFill);
static JSC_DECLARE_HOST_FUNCTION(jsSVGGeometryElementPrototypeFunction_isPointInStroke);
static JSC_DECLARE_HOST_FUNCTION(jsSVGGeometryElementPrototypeFunction_getTotalLength);
static JSC_DECLARE_HOST_FUNCTION(jsSVGGeometryElementPrototypeFunction_getPointAtLength);

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsSVGGeometryElementConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsSVGGeometryElement_pathLength);

class JSSVGGeometryElementPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSSVGGeometryElementPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSSVGGeometryElementPrototype* ptr = new (NotNull, JSC::allocateCell<JSSVGGeometryElementPrototype>(vm)) JSSVGGeometryElementPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSSVGGeometryElementPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSSVGGeometryElementPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSSVGGeometryElementPrototype, JSSVGGeometryElementPrototype::Base);

using JSSVGGeometryElementDOMConstructor = JSDOMConstructorNotConstructable<JSSVGGeometryElement>;

template<> const ClassInfo JSSVGGeometryElementDOMConstructor::s_info = { "SVGGeometryElement"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSSVGGeometryElementDOMConstructor) };

template<> JSValue JSSVGGeometryElementDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSSVGGraphicsElement::getConstructor(vm, &globalObject);
}

template<> void JSSVGGeometryElementDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "SVGGeometryElement"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSSVGGeometryElement::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const std::array<HashTableValue, 6> JSSVGGeometryElementPrototypeTableValues {
    HashTableValue { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsSVGGeometryElementConstructor, 0 } },
    HashTableValue { "pathLength"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSVGGeometryElement_pathLength, 0 } },
    HashTableValue { "isPointInFill"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsSVGGeometryElementPrototypeFunction_isPointInFill, 0 } },
    HashTableValue { "isPointInStroke"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsSVGGeometryElementPrototypeFunction_isPointInStroke, 0 } },
    HashTableValue { "getTotalLength"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsSVGGeometryElementPrototypeFunction_getTotalLength, 0 } },
    HashTableValue { "getPointAtLength"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsSVGGeometryElementPrototypeFunction_getPointAtLength, 1 } },
};

const ClassInfo JSSVGGeometryElementPrototype::s_info = { "SVGGeometryElement"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSSVGGeometryElementPrototype) };

void JSSVGGeometryElementPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSSVGGeometryElement::info(), JSSVGGeometryElementPrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSSVGGeometryElement::s_info = { "SVGGeometryElement"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSSVGGeometryElement) };

JSSVGGeometryElement::JSSVGGeometryElement(Structure* structure, JSDOMGlobalObject& globalObject, Ref<SVGGeometryElement>&& impl)
    : JSSVGGraphicsElement(structure, globalObject, WTFMove(impl))
{
}

Ref<SVGGeometryElement> JSSVGGeometryElement::protectedWrapped() const
{
    return wrapped();
}

JSObject* JSSVGGeometryElement::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSSVGGeometryElementPrototype::createStructure(vm, &globalObject, JSSVGGraphicsElement::prototype(vm, globalObject));
    structure->setMayBePrototype(true);
    return JSSVGGeometryElementPrototype::create(vm, &globalObject, structure);
}

JSObject* JSSVGGeometryElement::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSSVGGeometryElement>(vm, globalObject);
}

JSValue JSSVGGeometryElement::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSSVGGeometryElementDOMConstructor, DOMConstructorID::SVGGeometryElement>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsSVGGeometryElementConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSSVGGeometryElementPrototype*>(JSValue::decode(thisValue));
    if (!prototype) [[unlikely]]
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSSVGGeometryElement::getConstructor(vm, prototype->globalObject()));
}

static inline JSValue jsSVGGeometryElement_pathLengthGetter(JSGlobalObject& lexicalGlobalObject, JSSVGGeometryElement& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLInterface<SVGAnimatedNumber>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.pathLengthAnimated())));
}

JSC_DEFINE_CUSTOM_GETTER(jsSVGGeometryElement_pathLength, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGGeometryElement>::get<jsSVGGeometryElement_pathLengthGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSC::EncodedJSValue jsSVGGeometryElementPrototypeFunction_isPointInFillBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSSVGGeometryElement>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    EnsureStillAliveScope argument0 = callFrame->argument(0);
    auto pointConversionResult = convert<IDLDictionary<DOMPointInit>>(*lexicalGlobalObject, argument0.value());
    if (pointConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLBoolean>(*lexicalGlobalObject, throwScope, impl.isPointInFill(pointConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsSVGGeometryElementPrototypeFunction_isPointInFill, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSSVGGeometryElement>::call<jsSVGGeometryElementPrototypeFunction_isPointInFillBody>(*lexicalGlobalObject, *callFrame, "isPointInFill");
}

static inline JSC::EncodedJSValue jsSVGGeometryElementPrototypeFunction_isPointInStrokeBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSSVGGeometryElement>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    EnsureStillAliveScope argument0 = callFrame->argument(0);
    auto pointConversionResult = convert<IDLDictionary<DOMPointInit>>(*lexicalGlobalObject, argument0.value());
    if (pointConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLBoolean>(*lexicalGlobalObject, throwScope, impl.isPointInStroke(pointConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsSVGGeometryElementPrototypeFunction_isPointInStroke, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSSVGGeometryElement>::call<jsSVGGeometryElementPrototypeFunction_isPointInStrokeBody>(*lexicalGlobalObject, *callFrame, "isPointInStroke");
}

static inline JSC::EncodedJSValue jsSVGGeometryElementPrototypeFunction_getTotalLengthBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSSVGGeometryElement>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUnrestrictedFloat>(*lexicalGlobalObject, throwScope, impl.getTotalLength())));
}

JSC_DEFINE_HOST_FUNCTION(jsSVGGeometryElementPrototypeFunction_getTotalLength, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSSVGGeometryElement>::call<jsSVGGeometryElementPrototypeFunction_getTotalLengthBody>(*lexicalGlobalObject, *callFrame, "getTotalLength");
}

static inline JSC::EncodedJSValue jsSVGGeometryElementPrototypeFunction_getPointAtLengthBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSSVGGeometryElement>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    if (callFrame->argumentCount() < 1) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto distanceConversionResult = convert<IDLFloat>(*lexicalGlobalObject, argument0.value());
    if (distanceConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJSNewlyCreated<IDLInterface<SVGPoint>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.getPointAtLength(distanceConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsSVGGeometryElementPrototypeFunction_getPointAtLength, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSSVGGeometryElement>::call<jsSVGGeometryElementPrototypeFunction_getPointAtLengthBody>(*lexicalGlobalObject, *callFrame, "getPointAtLength");
}

JSC::GCClient::IsoSubspace* JSSVGGeometryElement::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSSVGGeometryElement, UseCustomHeapCellType::No>(vm, "JSSVGGeometryElement"_s,
        [] (auto& spaces) { return spaces.m_clientSubspaceForSVGGeometryElement.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForSVGGeometryElement = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForSVGGeometryElement.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForSVGGeometryElement = std::forward<decltype(space)>(space); }
    );
}

void JSSVGGeometryElement::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSSVGGeometryElement*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (RefPtr context = thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, makeString("url "_s, context->url().string()));
    Base::analyzeHeap(cell, analyzer);
}


}
