/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSHTMLQuoteElement.h"

#include "ActiveDOMObject.h"
#include "ContextDestructionObserverInlines.h"
#include "CustomElementReactionQueue.h"
#include "ElementInlines.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "HTMLNames.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/text/MakeString.h>

namespace WebCore {
using namespace JSC;

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsHTMLQuoteElementConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLQuoteElement_cite);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLQuoteElement_cite);

class JSHTMLQuoteElementPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSHTMLQuoteElementPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSHTMLQuoteElementPrototype* ptr = new (NotNull, JSC::allocateCell<JSHTMLQuoteElementPrototype>(vm)) JSHTMLQuoteElementPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSHTMLQuoteElementPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSHTMLQuoteElementPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSHTMLQuoteElementPrototype, JSHTMLQuoteElementPrototype::Base);

using JSHTMLQuoteElementDOMConstructor = JSDOMConstructorNotConstructable<JSHTMLQuoteElement>;

template<> const ClassInfo JSHTMLQuoteElementDOMConstructor::s_info = { "HTMLQuoteElement"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSHTMLQuoteElementDOMConstructor) };

template<> JSValue JSHTMLQuoteElementDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSHTMLElement::getConstructor(vm, &globalObject);
}

template<> void JSHTMLQuoteElementDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "HTMLQuoteElement"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSHTMLQuoteElement::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const std::array<HashTableValue, 2> JSHTMLQuoteElementPrototypeTableValues {
    HashTableValue { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLQuoteElementConstructor, 0 } },
    HashTableValue { "cite"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLQuoteElement_cite, setJSHTMLQuoteElement_cite } },
};

const ClassInfo JSHTMLQuoteElementPrototype::s_info = { "HTMLQuoteElement"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSHTMLQuoteElementPrototype) };

void JSHTMLQuoteElementPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSHTMLQuoteElement::info(), JSHTMLQuoteElementPrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSHTMLQuoteElement::s_info = { "HTMLQuoteElement"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSHTMLQuoteElement) };

JSHTMLQuoteElement::JSHTMLQuoteElement(Structure* structure, JSDOMGlobalObject& globalObject, Ref<HTMLQuoteElement>&& impl)
    : JSHTMLElement(structure, globalObject, WTFMove(impl))
{
}

Ref<HTMLQuoteElement> JSHTMLQuoteElement::protectedWrapped() const
{
    return wrapped();
}

JSObject* JSHTMLQuoteElement::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSHTMLQuoteElementPrototype::createStructure(vm, &globalObject, JSHTMLElement::prototype(vm, globalObject));
    structure->setMayBePrototype(true);
    return JSHTMLQuoteElementPrototype::create(vm, &globalObject, structure);
}

JSObject* JSHTMLQuoteElement::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSHTMLQuoteElement>(vm, globalObject);
}

JSValue JSHTMLQuoteElement::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSHTMLQuoteElementDOMConstructor, DOMConstructorID::HTMLQuoteElement>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLQuoteElementConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSHTMLQuoteElementPrototype*>(JSValue::decode(thisValue));
    if (!prototype) [[unlikely]]
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSHTMLQuoteElement::getConstructor(vm, prototype->globalObject()));
}

static inline JSValue jsHTMLQuoteElement_citeGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLQuoteElement& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLAtomStringAdaptor<IDLUSVString>>(lexicalGlobalObject, throwScope, impl.getURLAttributeForBindings(WebCore::HTMLNames::citeAttr))));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLQuoteElement_cite, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLQuoteElement>::get<jsHTMLQuoteElement_citeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSHTMLQuoteElement_citeSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLQuoteElement& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    CustomElementReactionDisallowedScope customElementReactionDisallowedScope;
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLAtomStringAdaptor<IDLUSVString>>(lexicalGlobalObject, value);
    if (nativeValueConversionResult.hasException(throwScope)) [[unlikely]]
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setAttributeWithoutSynchronization(WebCore::HTMLNames::citeAttr, nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLQuoteElement_cite, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLQuoteElement>::set<setJSHTMLQuoteElement_citeSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

JSC::GCClient::IsoSubspace* JSHTMLQuoteElement::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSHTMLQuoteElement, UseCustomHeapCellType::No>(vm, "JSHTMLQuoteElement"_s,
        [] (auto& spaces) { return spaces.m_clientSubspaceForHTMLQuoteElement.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForHTMLQuoteElement = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForHTMLQuoteElement.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForHTMLQuoteElement = std::forward<decltype(space)>(space); }
    );
}

void JSHTMLQuoteElement::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSHTMLQuoteElement*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (RefPtr context = thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, makeString("url "_s, context->url().string()));
    Base::analyzeHeap(cell, analyzer);
}


}
