/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSCSSFontFaceRule.h"

#include "ActiveDOMObject.h"
#include "ContextDestructionObserverInlines.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSCSSFontFaceDescriptors.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/text/MakeString.h>

namespace WebCore {
using namespace JSC;

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsCSSFontFaceRuleConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsCSSFontFaceRule_style);

class JSCSSFontFaceRulePrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSCSSFontFaceRulePrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSCSSFontFaceRulePrototype* ptr = new (NotNull, JSC::allocateCell<JSCSSFontFaceRulePrototype>(vm)) JSCSSFontFaceRulePrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSCSSFontFaceRulePrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSCSSFontFaceRulePrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSCSSFontFaceRulePrototype, JSCSSFontFaceRulePrototype::Base);

using JSCSSFontFaceRuleDOMConstructor = JSDOMConstructorNotConstructable<JSCSSFontFaceRule>;

template<> const ClassInfo JSCSSFontFaceRuleDOMConstructor::s_info = { "CSSFontFaceRule"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSCSSFontFaceRuleDOMConstructor) };

template<> JSValue JSCSSFontFaceRuleDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSCSSRule::getConstructor(vm, &globalObject);
}

template<> void JSCSSFontFaceRuleDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "CSSFontFaceRule"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSCSSFontFaceRule::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const std::array<HashTableValue, 2> JSCSSFontFaceRulePrototypeTableValues {
    HashTableValue { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSFontFaceRuleConstructor, 0 } },
    HashTableValue { "style"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSFontFaceRule_style, 0 } },
};

const ClassInfo JSCSSFontFaceRulePrototype::s_info = { "CSSFontFaceRule"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSCSSFontFaceRulePrototype) };

void JSCSSFontFaceRulePrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSCSSFontFaceRule::info(), JSCSSFontFaceRulePrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSCSSFontFaceRule::s_info = { "CSSFontFaceRule"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSCSSFontFaceRule) };

JSCSSFontFaceRule::JSCSSFontFaceRule(Structure* structure, JSDOMGlobalObject& globalObject, Ref<CSSFontFaceRule>&& impl)
    : JSCSSRule(structure, globalObject, WTFMove(impl))
{
}

Ref<CSSFontFaceRule> JSCSSFontFaceRule::protectedWrapped() const
{
    return wrapped();
}

static_assert(!std::is_base_of<ActiveDOMObject, CSSFontFaceRule>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSCSSFontFaceRule::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSCSSFontFaceRulePrototype::createStructure(vm, &globalObject, JSCSSRule::prototype(vm, globalObject));
    structure->setMayBePrototype(true);
    return JSCSSFontFaceRulePrototype::create(vm, &globalObject, structure);
}

JSObject* JSCSSFontFaceRule::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSCSSFontFaceRule>(vm, globalObject);
}

JSValue JSCSSFontFaceRule::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSCSSFontFaceRuleDOMConstructor, DOMConstructorID::CSSFontFaceRule>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsCSSFontFaceRuleConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSCSSFontFaceRulePrototype*>(JSValue::decode(thisValue));
    if (!prototype) [[unlikely]]
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSCSSFontFaceRule::getConstructor(vm, prototype->globalObject()));
}

static inline JSValue jsCSSFontFaceRule_styleGetter(JSGlobalObject& lexicalGlobalObject, JSCSSFontFaceRule& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLInterface<CSSFontFaceDescriptors>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.style())));
}

JSC_DEFINE_CUSTOM_GETTER(jsCSSFontFaceRule_style, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSFontFaceRule>::get<jsCSSFontFaceRule_styleGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

JSC::GCClient::IsoSubspace* JSCSSFontFaceRule::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSCSSFontFaceRule, UseCustomHeapCellType::No>(vm, "JSCSSFontFaceRule"_s,
        [] (auto& spaces) { return spaces.m_clientSubspaceForCSSFontFaceRule.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForCSSFontFaceRule = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForCSSFontFaceRule.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForCSSFontFaceRule = std::forward<decltype(space)>(space); }
    );
}

void JSCSSFontFaceRule::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSCSSFontFaceRule*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (RefPtr context = thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, makeString("url "_s, context->url().string()));
    Base::analyzeHeap(cell, analyzer);
}

WTF_ALLOW_UNSAFE_BUFFER_USAGE_BEGIN
#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7CSSFontFaceRule@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore15CSSFontFaceRuleE[]; }
#endif
template<std::same_as<CSSFontFaceRule> T>
static inline void verifyVTable(CSSFontFaceRule* ptr) 
{
    if constexpr (std::is_polymorphic_v<T>) {
        const void* actualVTablePointer = getVTablePointer<T>(ptr);
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7CSSFontFaceRule@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore15CSSFontFaceRuleE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // CSSFontFaceRule has subclasses. If CSSFontFaceRule has subclasses that get passed
        // to toJS() we currently require CSSFontFaceRule you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
    }
}
#endif
WTF_ALLOW_UNSAFE_BUFFER_USAGE_END

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<CSSFontFaceRule>&& impl)
{
#if ENABLE(BINDING_INTEGRITY)
    verifyVTable<CSSFontFaceRule>(impl.ptr());
#endif
    return createWrapper<CSSFontFaceRule>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, CSSFontFaceRule& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

CSSFontFaceRule* JSCSSFontFaceRule::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSCSSFontFaceRule*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
