/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEB_AUDIO)

#include "JSBiquadFilterType.h"

#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSString.h>
#include <wtf/NeverDestroyed.h>
#include <wtf/SortedArrayMap.h>



namespace WebCore {
using namespace JSC;

String convertEnumerationToString(BiquadFilterType enumerationValue)
{
    static const std::array<NeverDestroyed<String>, 8> values {
        MAKE_STATIC_STRING_IMPL("lowpass"),
        MAKE_STATIC_STRING_IMPL("highpass"),
        MAKE_STATIC_STRING_IMPL("bandpass"),
        MAKE_STATIC_STRING_IMPL("lowshelf"),
        MAKE_STATIC_STRING_IMPL("highshelf"),
        MAKE_STATIC_STRING_IMPL("peaking"),
        MAKE_STATIC_STRING_IMPL("notch"),
        MAKE_STATIC_STRING_IMPL("allpass"),
    };
    static_assert(static_cast<size_t>(BiquadFilterType::Lowpass) == 0, "BiquadFilterType::Lowpass is not 0 as expected");
    static_assert(static_cast<size_t>(BiquadFilterType::Highpass) == 1, "BiquadFilterType::Highpass is not 1 as expected");
    static_assert(static_cast<size_t>(BiquadFilterType::Bandpass) == 2, "BiquadFilterType::Bandpass is not 2 as expected");
    static_assert(static_cast<size_t>(BiquadFilterType::Lowshelf) == 3, "BiquadFilterType::Lowshelf is not 3 as expected");
    static_assert(static_cast<size_t>(BiquadFilterType::Highshelf) == 4, "BiquadFilterType::Highshelf is not 4 as expected");
    static_assert(static_cast<size_t>(BiquadFilterType::Peaking) == 5, "BiquadFilterType::Peaking is not 5 as expected");
    static_assert(static_cast<size_t>(BiquadFilterType::Notch) == 6, "BiquadFilterType::Notch is not 6 as expected");
    static_assert(static_cast<size_t>(BiquadFilterType::Allpass) == 7, "BiquadFilterType::Allpass is not 7 as expected");
    ASSERT(static_cast<size_t>(enumerationValue) < std::size(values));
    return values[static_cast<size_t>(enumerationValue)];
}

template<> JSString* convertEnumerationToJS(VM& vm, BiquadFilterType enumerationValue)
{
    return jsStringWithCache(vm, convertEnumerationToString(enumerationValue));
}

template<> std::optional<BiquadFilterType> parseEnumerationFromString<BiquadFilterType>(const String& stringValue)
{
    static constexpr std::array<std::pair<ComparableASCIILiteral, BiquadFilterType>, 8> mappings {
        std::pair<ComparableASCIILiteral, BiquadFilterType> { "allpass"_s, BiquadFilterType::Allpass },
        std::pair<ComparableASCIILiteral, BiquadFilterType> { "bandpass"_s, BiquadFilterType::Bandpass },
        std::pair<ComparableASCIILiteral, BiquadFilterType> { "highpass"_s, BiquadFilterType::Highpass },
        std::pair<ComparableASCIILiteral, BiquadFilterType> { "highshelf"_s, BiquadFilterType::Highshelf },
        std::pair<ComparableASCIILiteral, BiquadFilterType> { "lowpass"_s, BiquadFilterType::Lowpass },
        std::pair<ComparableASCIILiteral, BiquadFilterType> { "lowshelf"_s, BiquadFilterType::Lowshelf },
        std::pair<ComparableASCIILiteral, BiquadFilterType> { "notch"_s, BiquadFilterType::Notch },
        std::pair<ComparableASCIILiteral, BiquadFilterType> { "peaking"_s, BiquadFilterType::Peaking },
    };
    static constexpr SortedArrayMap enumerationMapping { mappings };
    if (auto* enumerationValue = enumerationMapping.tryGet(stringValue); enumerationValue) [[likely]]
        return *enumerationValue;
    return std::nullopt;
}

template<> std::optional<BiquadFilterType> parseEnumeration<BiquadFilterType>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    return parseEnumerationFromString<BiquadFilterType>(value.toWTFString(&lexicalGlobalObject));
}

template<> ASCIILiteral expectedEnumerationValues<BiquadFilterType>()
{
    return "\"lowpass\", \"highpass\", \"bandpass\", \"lowshelf\", \"highshelf\", \"peaking\", \"notch\", \"allpass\""_s;
}

} // namespace WebCore


#endif // ENABLE(WEB_AUDIO)
