/*
 * Copyright (C) 2010-2014 Google, Inc. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY APPLE INC. ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL APPLE INC. OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
 * OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE. 
 */

// THIS FILE IS GENERATED BY WebCore/html/parser/create-html-entity-table
// DO NOT EDIT!

#include "config.h"
#include "HTMLEntityTable.h"

#include <array>
#include <wtf/text/ASCIILiteral.h>

namespace WebCore {

static constexpr auto staticEntityStringStorage = 
"AElig"
"AMP"
"Aacute"
"Abreve"
"Acirc"
"Acy"
"Afr"
"Agrave"
"Alpha"
"Amacr"
"And"
"Aogon"
"Aopf"
"ApplyFunction"
"Aring"
"Ascr"
"Assign"
"Atilde"
"Auml"
"Backslash"
"Barv"
"Barwed"
"Bcy"
"Because"
"Bernoullis"
"Beta"
"Bfr"
"Bopf"
"Breve"
"Bscr"
"Bumpeq"
"CHcy"
"COPY"
"Cacute"
"Cap"
"italDifferentialD"
"Cayleys"
"Ccaron"
"Ccedil"
"Ccirc"
"Cconint"
"Cdot"
"Cedilla"
"CenterDot"
"Cfr"
"Chi"
"CircleDot"
"CircleMinus"
"CirclePlus"
"CircleTimes"
"ClockwiseContourIntegral"
"CloseCurlyDoubleQuote"
"CloseCurlyQuote"
"Colon"
"e"
"Congruent"
"Conint"
"Copf"
"Coproduct"
"CounterClockwiseContourIntegral"
"Cross"
"Cscr"
"Cup"
"Cap"
"DD"
"otrahd"
"DJcy"
"DScy"
"DZcy"
"Dagger"
"Darr"
"Dashv"
"Dcaron"
"Dcy"
"Del"
"ta"
"Dfr"
"DiacriticalAcute"
"DiacriticalDot"
"DiacriticalDoubleAcute"
"DiacriticalGrave"
"DiacriticalTilde"
"Diamond"
"Dopf"
"DotDot"
"Equal"
"DoubleContourIntegral"
"DoubleDot"
"DoubleDownArrow"
"DoubleLeftArrow"
"DoubleLeftRightArrow"
"DoubleLeftTee"
"DoubleLongLeftArrow"
"DoubleLongLeftRightArrow"
"DoubleLongRightArrow"
"DoubleRightArrow"
"DoubleRightTee"
"DoubleUpArrow"
"DoubleUpDownArrow"
"DoubleVerticalBar"
"DownArrowBar"
"DownArrowUpArrow"
"DownBreve"
"DownLeftRightVector"
"DownLeftTeeVector"
"DownLeftVector"
"Bar"
"DownRightTeeVector"
"DownRightVector"
"Bar"
"DownTee"
"Arrow"
"Downarrow"
"Dscr"
"Dstrok"
"ENG"
"ETH"
"Eacute"
"Ecaron"
"Ecirc"
"Ecy"
"Edot"
"Efr"
"Egrave"
"Element"
"Emacr"
"EmptySmallSquare"
"EmptyVerySmallSquare"
"Eogon"
"Eopf"
"Epsilon"
"EqualTilde"
"Equilibrium"
"Escr"
"Esim"
"Eta"
"Euml"
"Exists"
"ExponentialE"
"Fcy"
"Ffr"
"FilledSmallSquare"
"FilledVerySmallSquare"
"Fopf"
"ForAll"
"Fouriertrf"
"Fscr"
"GJcy"
"GT"
"Gamma"
"d"
"Gbreve"
"Gcedil"
"Gcirc"
"Gcy"
"Gdot"
"Gfr"
"Gg"
"Gopf"
"GreaterEqual"
"Less"
"GreaterFullEqual"
"GreaterGreater"
"Less"
"GreaterSlantEqual"
"GreaterTilde"
"Gscr"
"Gt"
"HARDcy"
"Hacek"
"Hat"
"Hcirc"
"Hfr"
"HilbertSpace"
"Hopf"
"HorizontalLine"
"Hscr"
"Hstrok"
"HumpDownHump"
"Equal"
"IEcy"
"IJlig"
"IOcy"
"Iacute"
"Icirc"
"Icy"
"Idot"
"Ifr"
"Igrave"
"Im"
"acr"
"ImaginaryI"
"mplies"
"Intersection"
"InvisibleComma"
"InvisibleTimes"
"Iogon"
"Iopf"
"Iota"
"Iscr"
"Itilde"
"Iukcy"
"Iuml"
"Jcirc"
"Jfr"
"Jopf"
"Jscr"
"Jsercy"
"Jukcy"
"KHcy"
"KJcy"
"Kappa"
"Kcedil"
"Kcy"
"Kfr"
"Kopf"
"Kscr"
"LJcy"
"LT"
"Lacute"
"Lambda"
"Lang"
"Laplacetrf"
"Larr"
"Lcaron"
"Lcedil"
"Lcy"
"LeftAngleBracket"
"LeftArrowBar"
"LeftArrowRightArrow"
"LeftCeiling"
"LeftDoubleBracket"
"LeftDownTeeVector"
"LeftDownVector"
"Bar"
"LeftFloor"
"LeftTeeArrow"
"LeftTriangle"
"Bar"
"LeftTriangleEqual"
"LeftUpDownVector"
"LeftUpTeeVector"
"LeftUpVector"
"Bar"
"Leftarrow"
"Leftrightarrow"
"LessEqualGreater"
"LessFullEqual"
"LessLess"
"SlantEqual"
"LessTilde"
"Lfr"
"Ll"
"eftarrow"
"Lmidot"
"Longleftarrow"
"Longleftrightarrow"
"Longrightarrow"
"Lopf"
"LowerLeftArrow"
"LowerRightArrow"
"Lscr"
"Lsh"
"Lstrok"
"Lt"
"Map"
"Mcy"
"MediumSpace"
"Mellintrf"
"Mfr"
"MinusPlus"
"Mopf"
"Mscr"
"Mu"
"NJcy"
"Nacute"
"Ncaron"
"Ncedil"
"Ncy"
"NegativeMediumSpace"
"NegativeThickSpace"
"NegativeThinSpace"
"NegativeVeryThinSpace"
"NestedGreaterGreater"
"NestedLessLess"
"NewLine"
"Nfr"
"NoBreak"
"NonBreakingSpace"
"Nopf"
"Not"
"Congruent"
"NotCupCap"
"NotDoubleVerticalBar"
"NotElement"
"NotEqual"
"Tilde"
"NotExists"
"NotGreater"
"Equal"
"NotGreaterFullEqual"
"NotGreaterGreater"
"NotGreaterLess"
"NotGreaterSlantEqual"
"NotGreaterTilde"
"NotHumpDownHump"
"NotHumpEqual"
"NotLeftTriangle"
"Bar"
"NotLeftTriangleEqual"
"NotLess"
"Equal"
"NotLessGreater"
"NotLessLess"
"NotLessSlantEqual"
"NotLessTilde"
"NotNestedGreaterGreater"
"NotNestedLessLess"
"NotPrecedes"
"Equal"
"NotPrecedesSlantEqual"
"NotReverseElement"
"NotRightTriangle"
"Bar"
"NotRightTriangleEqual"
"NotSquareSubset"
"Equal"
"NotSquareSuperset"
"Equal"
"NotSubset"
"Equal"
"NotSucceeds"
"Equal"
"NotSucceedsSlantEqual"
"NotSucceedsTilde"
"NotSuperset"
"Equal"
"NotTilde"
"Equal"
"NotTildeFullEqual"
"NotTildeTilde"
"NotVerticalBar"
"Nscr"
"Ntilde"
"Nu"
"OElig"
"Oacute"
"Ocirc"
"Odblac"
"Ofr"
"Ograve"
"Omacr"
"Omega"
"Omicron"
"Oopf"
"OpenCurlyDoubleQuote"
"OpenCurlyQuote"
"Or"
"Oscr"
"Oslash"
"Otilde"
"Otimes"
"Ouml"
"OverBar"
"OverBrace"
"OverBracket"
"OverParenthesis"
"PartialD"
"Pcy"
"Pfr"
"Phi"
"Pi"
"PlusMinus"
"Poincareplane"
"Popf"
"PrecedesTilde"
"Prime"
"Product"
"Proportion"
"al"
"Pscr"
"Psi"
"QUOT"
"Qfr"
"Qopf"
"Qscr"
"RBarr"
"REG"
"Racute"
"Rang"
"Rarr"
"tl"
"Rcaron"
"Rcedil"
"Rcy"
"ReverseEquilibrium"
"ReverseUpEquilibrium"
"Rfr"
"Rho"
"RightAngleBracket"
"RightArrowBar"
"RightArrowLeftArrow"
"RightCeiling"
"RightDoubleBracket"
"RightDownTeeVector"
"RightDownVector"
"Bar"
"RightFloor"
"RightTeeArrow"
"RightUpDownVector"
"RightUpTeeVector"
"RightUpVector"
"Bar"
"Rightarrow"
"Ropf"
"RoundImplies"
"Rrightarrow"
"Rscr"
"Rsh"
"RuleDelayed"
"SHCHcy"
"SHcy"
"SOFTcy"
"Sacute"
"Scaron"
"Scedil"
"Scirc"
"Sfr"
"ShortDownArrow"
"ShortLeftArrow"
"ShortRightArrow"
"ShortUpArrow"
"Sigma"
"SmallCircle"
"Sopf"
"Sqrt"
"SquareIntersection"
"SquareUnion"
"Sscr"
"Star"
"SuchThat"
"Sum"
"Supset"
"THORN"
"TRADE"
"TSHcy"
"TScy"
"Tab"
"Tau"
"Tcaron"
"Tcedil"
"Tfr"
"Therefore"
"Theta"
"Topf"
"TripleDot"
"Tscr"
"Tstrok"
"Uacute"
"Uarr"
"ocir"
"Ubrcy"
"Ubreve"
"Ucirc"
"Ucy"
"Udblac"
"Ufr"
"Ugrave"
"Umacr"
"UnderBar"
"UnderBrace"
"UnderBracket"
"UnderParenthesis"
"UnionPlus"
"Uogon"
"Uopf"
"UpArrowBar"
"UpArrowDownArrow"
"UpTeeArrow"
"Uparrow"
"Updownarrow"
"UpperLeftArrow"
"UpperRightArrow"
"Upsi"
"lon"
"Uring"
"Uscr"
"Utilde"
"Uuml"
"VDash"
"Vbar"
"Vcy"
"Vdash"
"l"
"Vee"
"Verbar"
"VerticalLine"
"VerticalSeparator"
"VerticalTilde"
"Vfr"
"Vopf"
"Vscr"
"Vvdash"
"Wcirc"
"Wedge"
"Wfr"
"Wopf"
"Wscr"
"Xfr"
"Xi"
"Xopf"
"Xscr"
"YAcy"
"YIcy"
"YUcy"
"Yacute"
"Ycirc"
"Ycy"
"Yfr"
"Yopf"
"Yscr"
"Yuml"
"ZHcy"
"Zacute"
"Zcaron"
"Zdot"
"ZeroWidthSpace"
"Zeta"
"Zfr"
"Zopf"
"Zscr"
"aacute"
"abreve"
"acE"
"acd"
"acirc"
"acy"
"aelig"
"af"
"r"
"agrave"
"alefsym"
"aleph"
"alpha"
"macr"
"amalg"
"amp"
"and"
"and"
"d"
"andslope"
"andv"
"ange"
"angmsd"
"aa"
"ngmsdab"
"angmsdac"
"angmsdad"
"angmsdae"
"angmsdaf"
"angmsdag"
"angmsdah"
"angrt"
"vb"
"d"
"angsph"
"angst"
"angzarr"
"aogon"
"aopf"
"apE"
"apacir"
"ape"
"apid"
"apos"
"approx"
"eq"
"aring"
"ascr"
"ast"
"asymp"
"eq"
"atilde"
"auml"
"awconint"
"awint"
"bNot"
"backcong"
"backepsilon"
"backprime"
"backsim"
"eq"
"barvee"
"barwed"
"ge"
"bbrk"
"tbrk"
"bcong"
"bcy"
"bdquo"
"becaus"
"e"
"bemptyv"
"bepsi"
"bernou"
"beta"
"beth"
"between"
"bfr"
"bigcap"
"bigcirc"
"bigcup"
"bigodot"
"bigoplus"
"bigotimes"
"bigsqcup"
"bigstar"
"bigtriangledown"
"bigtriangleup"
"biguplus"
"bigvee"
"bigwedge"
"bkarow"
"blacklozenge"
"blacksquare"
"blacktriangle"
"down"
"blacktriangleleft"
"blacktriangleright"
"blank"
"blk12"
"blk14"
"blk34"
"block"
"bne"
"quiv"
"bnot"
"bopf"
"bot"
"tom"
"bowtie"
"boxDL"
"boxDR"
"boxDl"
"boxDr"
"boxH"
"D"
"boxHU"
"boxHd"
"boxHu"
"boxUL"
"boxUR"
"boxUl"
"boxUr"
"boxV"
"H"
"boxVL"
"boxVR"
"boxVh"
"boxVl"
"boxVr"
"boxbox"
"dL"
"boxdR"
"boxdl"
"boxdr"
"boxh"
"D"
"boxhU"
"boxhd"
"boxhu"
"boxminus"
"boxplus"
"boxtimes"
"boxuL"
"boxuR"
"boxul"
"boxur"
"boxv"
"H"
"boxvL"
"boxvR"
"boxvh"
"boxvl"
"boxvr"
"bprime"
"brvbar"
"bscr"
"bsemi"
"bsim"
"e"
"bsol"
"b"
"solhsub"
"ull"
"et"
"bump"
"E"
"bumpe"
"q"
"cacute"
"capand"
"capbrcup"
"capcap"
"cup"
"capdot"
"caps"
"caret"
"ccaps"
"ccaron"
"ccedil"
"ccirc"
"cups"
"sm"
"cdot"
"cemptyv"
"cent"
"erdot"
"cfr"
"chcy"
"check"
"mark"
"chi"
"cirE"
"circeq"
"circlearrowleft"
"circlearrowright"
"circledR"
"circledS"
"circledast"
"circledcirc"
"leddash"
"cire"
"cirfnint"
"cirmid"
"cirscir"
"clubs"
"uit"
"colon"
"e"
"q"
"comma"
"t"
"comp"
"fn"
"complement"
"complexes"
"congdot"
"copf"
"coprod"
"copy"
"sr"
"crarr"
"cross"
"cscr"
"csub"
"e"
"csup"
"e"
"ctdot"
"cudarrl"
"cudarrr"
"cuepr"
"cuesc"
"ularr"
"p"
"cupbrcap"
"cupcup"
"dot"
"cupor"
"curarr"
"m"
"curlyeqprec"
"urlyeqsucc"
"urlyvee"
"curlywedge"
"curren"
"curvearrowleft"
"curvearrowright"
"cuvee"
"cuwed"
"cwconint"
"cwint"
"cylcty"
"dArr"
"dHar"
"dagger"
"daleth"
"dashv"
"dbkarow"
"dcaron"
"dcy"
"ddagger"
"ddarr"
"ddotseq"
"deg"
"delta"
"demptyv"
"dfisht"
"dfr"
"dharl"
"dharr"
"diam"
"ond"
"suit"
"diams"
"die"
"digamma"
"disin"
"div"
"ide"
"ontimes"
"divonx"
"djcy"
"dlcorn"
"dlcrop"
"dollar"
"dopf"
"doteq"
"dot"
"minus"
"dotplus"
"dotsquare"
"doublebarwedge"
"downdownarrows"
"downharpoonleft"
"downharpoonright"
"drbkarow"
"drcorn"
"drcrop"
"dscr"
"dscy"
"dsol"
"dstrok"
"dtdot"
"dtri"
"f"
"duarr"
"duhar"
"dwangle"
"dzcy"
"dzigrarr"
"eDDot"
"eacute"
"aster"
"ecaron"
"ecirc"
"ecolon"
"ecy"
"edot"
"efDot"
"efr"
"egrave"
"gs"
"dot"
"elinters"
"els"
"dot"
"emacr"
"emptyset"
"emsp13"
"emsp14"
"ensp"
"eogon"
"eopf"
"eparsl"
"eplus"
"epsiv"
"eqcolon"
"eqsim"
"eqslantgtr"
"eqslantless"
"equals"
"equest"
"equivDD"
"eqvparsl"
"erarr"
"escr"
"esdot"
"esim"
"euml"
"euro"
"excl"
"exist"
"expectation"
"exponentiale"
"fallingdotseq"
"fcy"
"female"
"ffilig"
"fflig"
"ffllig"
"ffr"
"fjlig"
"flat"
"fltns"
"fnof"
"opf"
"orall"
"fork"
"v"
"fpartint"
"frac12"
"frac13"
"frac14"
"frac15"
"frac16"
"frac18"
"frac23"
"frac25"
"frac34"
"frac35"
"frac38"
"frac45"
"frac56"
"frac58"
"frac78"
"frasl"
"frown"
"fscr"
"gE"
"l"
"gacute"
"gap"
"gbreve"
"gcy"
"gel"
"geq"
"q"
"geqslant"
"ges"
"cc"
"gesdot"
"o"
"l"
"gesl"
"es"
"gfr"
"ggg"
"imel"
"gjcy"
"glE"
"gla"
"glj"
"gnE"
"gnap"
"prox"
"gne"
"q"
"q"
"gnsim"
"gopf"
"gscr"
"gsim"
"e"
"gsiml"
"gtcc"
"gtcir"
"gtdot"
"gtlPar"
"gtquest"
"gtrapprox"
"gtrarr"
"gtrdot"
"gtreqless"
"gtreqqless"
"gtrless"
"gtrsim"
"gvertneqq"
"gvnE"
"hArr"
"hairsp"
"half"
"hamilt"
"hardcy"
"harrcir"
"harrw"
"hbar"
"hcirc"
"hearts"
"uit"
"hellip"
"hercon"
"hfr"
"hksearow"
"hkswarow"
"hoarr"
"homtht"
"hookleftarrow"
"hookrightarrow"
"hopf"
"horbar"
"hscr"
"hslash"
"strok"
"hybull"
"hyphen"
"iacute"
"icirc"
"icy"
"iecy"
"iexcl"
"ifr"
"igrave"
"ii"
"iint"
"iinfin"
"iiota"
"ijlig"
"imacr"
"image"
"imagline"
"imagpart"
"imath"
"imof"
"imped"
"infintie"
"inodot"
"intcal"
"integers"
"intercal"
"intlarhk"
"intprod"
"iocy"
"iogon"
"iopf"
"iprod"
"iquest"
"iscr"
"isinE"
"isindot"
"isins"
"v"
"isinv"
"itilde"
"iukcy"
"iuml"
"jcirc"
"jfr"
"jmath"
"jopf"
"jscr"
"jsercy"
"jukcy"
"kappa"
"v"
"kcedil"
"kfr"
"kgreen"
"khcy"
"kjcy"
"kopf"
"kscr"
"lAarr"
"lArr"
"lAtail"
"Barr"
"lHar"
"lacute"
"laemptyv"
"lagran"
"lambda"
"lang"
"d"
"langle"
"lap"
"laquo"
"larrb"
"fs"
"larrfs"
"larrhk"
"larrlp"
"larrpl"
"arrsim"
"larrtl"
"atail"
"ate"
"s"
"lbarr"
"lbbrk"
"lbrace"
"lbrack"
"lbrke"
"lbrksld"
"lbrkslu"
"lcaron"
"lcedil"
"ceil"
"cub"
"lcy"
"ldca"
"ldquo"
"r"
"ldrdhar"
"ldrushar"
"ldsh"
"leftarrowtail"
"eftharpoondown"
"leftharpoonup"
"leftleftarrows"
"leftrightarrows"
"leftrightharpoons"
"leftrightsquigarrow"
"leftthreetimes"
"leg"
"leq"
"q"
"leqslant"
"lescc"
"lesdot"
"o"
"r"
"lesges"
"lessapprox"
"lessdot"
"lesseqgtr"
"lesseqqgtr"
"lesssim"
"lfisht"
"lfloor"
"lgE"
"lhard"
"lharu"
"l"
"hblk"
"ljcy"
"llarr"
"llcorner"
"llhard"
"lltri"
"lmidot"
"lmoust"
"ache"
"lnE"
"lnap"
"prox"
"lne"
"q"
"q"
"lnsim"
"loang"
"loarr"
"lobrk"
"longleftarrow"
"longleftrightarrow"
"longmapsto"
"longrightarrow"
"looparrowleft"
"looparrowright"
"lopar"
"lopf"
"loplus"
"lotimes"
"lowast"
"lowbar"
"lozf"
"lpar"
"lt"
"lrarr"
"lrcorner"
"lrhar"
"d"
"lrm"
"lrtri"
"lsaquo"
"lscr"
"lsh"
"lsim"
"e"
"lsimg"
"lsqb"
"lsquo"
"r"
"lstrok"
"ltcc"
"ltcir"
"ltdot"
"lthree"
"ltimes"
"ltlarr"
"ltquest"
"ltrPar"
"ltrie"
"ltrif"
"lurdshar"
"luruhar"
"lvertneqq"
"lvnE"
"mDDot"
"malt"
"ese"
"mapstodown"
"mapstoleft"
"mapstoup"
"marker"
"mcomma"
"mcy"
"mdash"
"measuredangle"
"mfr"
"mho"
"midast"
"middot"
"minusdu"
"mlcp"
"mldr"
"mnplus"
"models"
"mopf"
"mscr"
"mstpos"
"mu"
"ltimap"
"mumap"
"nGg"
"nGt"
"v"
"nLeftarrow"
"nLeftrightarrow"
"nLl"
"nLt"
"v"
"nRightarrow"
"nVDash"
"nVdash"
"nabla"
"nacute"
"nang"
"napE"
"napid"
"napos"
"natur"
"al"
"s"
"nbsp"
"nbump"
"e"
"ncap"
"ncaron"
"cedil"
"ncong"
"dot"
"ncup"
"ncy"
"ndash"
"neArr"
"nearhk"
"nearr"
"ow"
"nedot"
"nesear"
"nesim"
"nexist"
"s"
"nfr"
"ngE"
"ngeq"
"q"
"ngeqslant"
"nges"
"ngsim"
"ngt"
"r"
"nhArr"
"nharr"
"nhpar"
"nis"
"d"
"niv"
"njcy"
"nlArr"
"nlE"
"nlarr"
"nldr"
"nleftarrow"
"nleftrightarrow"
"nleq"
"q"
"nleqslant"
"nles"
"s"
"nlsim"
"nlt"
"ri"
"e"
"nmid"
"nopf"
"notin"
"E"
"notindot"
"notinva"
"notinvb"
"notinvc"
"notni"
"va"
"notnivb"
"notnivc"
"npar"
"allel"
"nparsl"
"npart"
"npolint"
"npr"
"cue"
"npre"
"c"
"eq"
"nrArr"
"nrarr"
"c"
"nrarrw"
"nrightarrow"
"nrtri"
"e"
"nsc"
"cue"
"nsce"
"nscr"
"nshortmid"
"nshortparallel"
"nsime"
"q"
"nsmid"
"nspar"
"nsqsube"
"nsqsupe"
"nsub"
"E"
"nsube"
"nsubset"
"eq"
"q"
"nsucc"
"eq"
"nsup"
"E"
"nsupe"
"nsupset"
"eq"
"q"
"ntgl"
"ntilde"
"ntlg"
"ntriangleleft"
"eq"
"ntriangleright"
"eq"
"num"
"ero"
"numsp"
"nvDash"
"nvHarr"
"nvap"
"nvdash"
"nvge"
"nvgt"
"nvinfin"
"vlArr"
"nvle"
"nvlt"
"rie"
"nvrArr"
"nvrtrie"
"nvsim"
"nwArr"
"nwarhk"
"nwarr"
"ow"
"nwnear"
"oS"
"oacute"
"oast"
"ocirc"
"odash"
"odblac"
"odiv"
"odsold"
"oelig"
"ofcir"
"ofr"
"ograve"
"ogt"
"ohbar"
"ohm"
"oint"
"olcir"
"olcross"
"oline"
"olt"
"omacr"
"omega"
"omicron"
"ominus"
"oopf"
"operp"
"orarr"
"ord"
"er"
"of"
"ordf"
"ordm"
"origof"
"oror"
"slope"
"orv"
"oscr"
"oslash"
"osol"
"otilde"
"otimesas"
"ouml"
"ovbar"
"parsim"
"pcy"
"percnt"
"period"
"permil"
"pertenk"
"pfr"
"phi"
"v"
"phmmat"
"phone"
"pitchfork"
"piv"
"planck"
"h"
"plankv"
"plusacir"
"pluscir"
"plusdu"
"plusmn"
"plussim"
"plustwo"
"pointint"
"popf"
"pound"
"prE"
"prap"
"recapprox"
"preccurlyeq"
"precnapprox"
"precneqq"
"precnsim"
"precsim"
"primes"
"prnE"
"prnap"
"rnsim"
"profalar"
"profline"
"profsurf"
"prop"
"to"
"prsim"
"prurel"
"pscr"
"puncsp"
"qfr"
"qint"
"qopf"
"qprime"
"qscr"
"quaternions"
"quatint"
"quot"
"rAarr"
"Atail"
"rBarr"
"Har"
"acute"
"radic"
"raemptyv"
"rang"
"d"
"range"
"rangle"
"raquo"
"rarrap"
"rarrb"
"fs"
"rarrfs"
"rarrhk"
"rarrlp"
"rarrpl"
"rarrsim"
"rarrtl"
"ratail"
"ratio"
"nals"
"rbarr"
"bbrk"
"rbrace"
"rbrack"
"rbrke"
"rbrksld"
"rbrkslu"
"rcaron"
"rcedil"
"rceil"
"rcub"
"rdca"
"rdldhar"
"dquo"
"r"
"eal"
"ine"
"realpart"
"reals"
"rect"
"rfisht"
"rfloor"
"fr"
"haru"
"l"
"rhov"
"rightarrowtail"
"rightharpoondown"
"rightharpoonup"
"rightleftarrows"
"rightleftharpoons"
"rightrightarrows"
"rightthreetimes"
"risingdotseq"
"rlarr"
"lhar"
"lm"
"rmoust"
"ache"
"rnmid"
"roang"
"roarr"
"obrk"
"ropar"
"opf"
"roplus"
"rotimes"
"rpargt"
"rppolint"
"rrarr"
"saquo"
"rscr"
"sh"
"rsqb"
"rsquo"
"r"
"three"
"rtimes"
"rtrif"
"rtriltri"
"ruluhar"
"x"
"sacute"
"sbquo"
"scE"
"scap"
"scaron"
"scedil"
"scnE"
"scnap"
"scnsim"
"scpolint"
"scsim"
"sdotb"
"seArr"
"searhk"
"searr"
"ow"
"seswar"
"setminus"
"etmn"
"sext"
"sfr"
"own"
"sharp"
"shchcy"
"shcy"
"shy"
"sigma"
"f"
"sigmav"
"simdot"
"simgE"
"simlE"
"smallsetminus"
"mashp"
"smeparsl"
"smile"
"smt"
"e"
"s"
"oftcy"
"solbar"
"sopf"
"spades"
"uit"
"sqcap"
"s"
"qcups"
"qsubset"
"eq"
"sqsupset"
"eq"
"squarf"
"squf"
"sscr"
"ssetmn"
"ssmile"
"sstarf"
"straightepsilon"
"straightphi"
"strns"
"ubdot"
"subedot"
"submult"
"subnE"
"subne"
"subplus"
"ubrarr"
"subsetneq"
"q"
"subsim"
"subsub"
"sup"
"succapprox"
"succcurlyeq"
"succnapprox"
"succneqq"
"succnsim"
"succsim"
"sum"
"sung"
"sup1"
"sup2"
"sup3"
"supdot"
"supdsub"
"supedot"
"suphsol"
"suphsub"
"suplarr"
"supmult"
"supnE"
"supne"
"supplus"
"upsetneq"
"q"
"supsim"
"supsub"
"supsup"
"swArr"
"swarhk"
"swarr"
"ow"
"swnwar"
"szlig"
"target"
"au"
"tcaron"
"tcedil"
"telrec"
"there4"
"therefore"
"theta"
"sym"
"thetav"
"thickapprox"
"thicksim"
"thinsp"
"thkap"
"thksim"
"thorn"
"timesbar"
"toea"
"topbot"
"opcir"
"topf"
"ork"
"tosa"
"tprime"
"trade"
"triangleq"
"tridot"
"riminus"
"triplus"
"trisb"
"tritime"
"trpezium"
"tscr"
"tscy"
"tshcy"
"tstrok"
"twixt"
"woheadleftarrow"
"twoheadrightarrow"
"uArr"
"uHar"
"uacute"
"ubrcy"
"ubreve"
"ucirc"
"ucy"
"udblac"
"udhar"
"ufisht"
"ufr"
"ugrave"
"uharr"
"uhblk"
"ulcorn"
"er"
"ulcrop"
"ultri"
"umacr"
"uogon"
"uopf"
"uparrow"
"updownarrow"
"upharpoonleft"
"upharpoonright"
"upsih"
"upsilon"
"upuparrows"
"urcorn"
"er"
"urcrop"
"uring"
"urtri"
"uscr"
"utdot"
"utilde"
"utri"
"f"
"uuarr"
"uuml"
"uwangle"
"vArr"
"vBarv"
"angrt"
"varepsilon"
"varkappa"
"varnothing"
"varphi"
"varpi"
"varpropto"
"varr"
"ho"
"varsigma"
"varsubsetneq"
"q"
"varsupsetneq"
"q"
"vartheta"
"vartriangleleft"
"vartriangleright"
"vcy"
"veeeq"
"vellip"
"verbar"
"vfr"
"vnsub"
"vnsup"
"vopf"
"vprop"
"vscr"
"vsubnE"
"vsubne"
"vsupnE"
"vsupne"
"vzigzag"
"wcirc"
"wedbar"
"wedgeq"
"weierp"
"wfr"
"wopf"
"wp"
"wreath"
"wscr"
"xcap"
"xcirc"
"xcup"
"xdtri"
"xfr"
"xhArr"
"xharr"
"xlArr"
"xlarr"
"xmap"
"xnis"
"xodot"
"xopf"
"xoplus"
"xotime"
"xrArr"
"xrarr"
"xscr"
"xsqcup"
"xuplus"
"xutri"
"xvee"
"xwedge"
"yacute"
"yacy"
"circ"
"ycy"
"en"
"yfr"
"yicy"
"opf"
"yscr"
"yucy"
"uml"
"zacute"
"zcaron"
"zdot"
"zeetrf"
"zeta"
"zfr"
"zhcy"
"zopf"
"zscr"
"zwj"
"zwnj"_s;

static constexpr std::array<HTMLEntityTableEntry, 2231> staticEntityTable {
    HTMLEntityTableEntry { 198, 0, 0, 5, 0 }, // &AElig
    HTMLEntityTableEntry { 198, 0, 0, 5, 1 }, // &AElig;
    HTMLEntityTableEntry { 38, 0, 5, 3, 0 }, // &AMP
    HTMLEntityTableEntry { 38, 0, 5, 3, 1 }, // &AMP;
    HTMLEntityTableEntry { 193, 0, 8, 6, 0 }, // &Aacute
    HTMLEntityTableEntry { 193, 0, 8, 6, 1 }, // &Aacute;
    HTMLEntityTableEntry { 258, 0, 14, 6, 1 }, // &Abreve;
    HTMLEntityTableEntry { 194, 0, 20, 5, 0 }, // &Acirc
    HTMLEntityTableEntry { 194, 0, 20, 5, 1 }, // &Acirc;
    HTMLEntityTableEntry { 1040, 0, 25, 3, 1 }, // &Acy;
    HTMLEntityTableEntry { 120068, 0, 28, 3, 1 }, // &Afr;
    HTMLEntityTableEntry { 192, 0, 31, 6, 0 }, // &Agrave
    HTMLEntityTableEntry { 192, 0, 31, 6, 1 }, // &Agrave;
    HTMLEntityTableEntry { 913, 0, 37, 5, 1 }, // &Alpha;
    HTMLEntityTableEntry { 256, 0, 42, 5, 1 }, // &Amacr;
    HTMLEntityTableEntry { 10835, 0, 47, 3, 1 }, // &And;
    HTMLEntityTableEntry { 260, 0, 50, 5, 1 }, // &Aogon;
    HTMLEntityTableEntry { 120120, 0, 55, 4, 1 }, // &Aopf;
    HTMLEntityTableEntry { 8289, 0, 59, 13, 1 }, // &ApplyFunction;
    HTMLEntityTableEntry { 197, 0, 72, 5, 0 }, // &Aring
    HTMLEntityTableEntry { 197, 0, 72, 5, 1 }, // &Aring;
    HTMLEntityTableEntry { 119964, 0, 77, 4, 1 }, // &Ascr;
    HTMLEntityTableEntry { 8788, 0, 81, 6, 1 }, // &Assign;
    HTMLEntityTableEntry { 195, 0, 87, 6, 0 }, // &Atilde
    HTMLEntityTableEntry { 195, 0, 87, 6, 1 }, // &Atilde;
    HTMLEntityTableEntry { 196, 0, 93, 4, 0 }, // &Auml
    HTMLEntityTableEntry { 196, 0, 93, 4, 1 }, // &Auml;
    HTMLEntityTableEntry { 8726, 0, 97, 9, 1 }, // &Backslash;
    HTMLEntityTableEntry { 10983, 0, 106, 4, 1 }, // &Barv;
    HTMLEntityTableEntry { 8966, 0, 110, 6, 1 }, // &Barwed;
    HTMLEntityTableEntry { 1041, 0, 116, 3, 1 }, // &Bcy;
    HTMLEntityTableEntry { 8757, 0, 119, 7, 1 }, // &Because;
    HTMLEntityTableEntry { 8492, 0, 126, 10, 1 }, // &Bernoullis;
    HTMLEntityTableEntry { 914, 0, 136, 4, 1 }, // &Beta;
    HTMLEntityTableEntry { 120069, 0, 140, 3, 1 }, // &Bfr;
    HTMLEntityTableEntry { 120121, 0, 143, 4, 1 }, // &Bopf;
    HTMLEntityTableEntry { 728, 0, 147, 5, 1 }, // &Breve;
    HTMLEntityTableEntry { 8492, 0, 152, 4, 1 }, // &Bscr;
    HTMLEntityTableEntry { 8782, 0, 156, 6, 1 }, // &Bumpeq;
    HTMLEntityTableEntry { 1063, 0, 162, 4, 1 }, // &CHcy;
    HTMLEntityTableEntry { 169, 0, 166, 4, 0 }, // &COPY
    HTMLEntityTableEntry { 169, 0, 166, 4, 1 }, // &COPY;
    HTMLEntityTableEntry { 262, 0, 170, 6, 1 }, // &Cacute;
    HTMLEntityTableEntry { 8914, 0, 176, 3, 1 }, // &Cap;
    HTMLEntityTableEntry { 8517, 0, 176, 20, 1 }, // &CapitalDifferentialD;
    HTMLEntityTableEntry { 8493, 0, 196, 7, 1 }, // &Cayleys;
    HTMLEntityTableEntry { 268, 0, 203, 6, 1 }, // &Ccaron;
    HTMLEntityTableEntry { 199, 0, 209, 6, 0 }, // &Ccedil
    HTMLEntityTableEntry { 199, 0, 209, 6, 1 }, // &Ccedil;
    HTMLEntityTableEntry { 264, 0, 215, 5, 1 }, // &Ccirc;
    HTMLEntityTableEntry { 8752, 0, 220, 7, 1 }, // &Cconint;
    HTMLEntityTableEntry { 266, 0, 227, 4, 1 }, // &Cdot;
    HTMLEntityTableEntry { 184, 0, 231, 7, 1 }, // &Cedilla;
    HTMLEntityTableEntry { 183, 0, 238, 9, 1 }, // &CenterDot;
    HTMLEntityTableEntry { 8493, 0, 247, 3, 1 }, // &Cfr;
    HTMLEntityTableEntry { 935, 0, 250, 3, 1 }, // &Chi;
    HTMLEntityTableEntry { 8857, 0, 253, 9, 1 }, // &CircleDot;
    HTMLEntityTableEntry { 8854, 0, 262, 11, 1 }, // &CircleMinus;
    HTMLEntityTableEntry { 8853, 0, 273, 10, 1 }, // &CirclePlus;
    HTMLEntityTableEntry { 8855, 0, 283, 11, 1 }, // &CircleTimes;
    HTMLEntityTableEntry { 8754, 0, 294, 24, 1 }, // &ClockwiseContourIntegral;
    HTMLEntityTableEntry { 8221, 0, 318, 21, 1 }, // &CloseCurlyDoubleQuote;
    HTMLEntityTableEntry { 8217, 0, 339, 15, 1 }, // &CloseCurlyQuote;
    HTMLEntityTableEntry { 8759, 0, 354, 5, 1 }, // &Colon;
    HTMLEntityTableEntry { 10868, 0, 354, 6, 1 }, // &Colone;
    HTMLEntityTableEntry { 8801, 0, 360, 9, 1 }, // &Congruent;
    HTMLEntityTableEntry { 8751, 0, 369, 6, 1 }, // &Conint;
    HTMLEntityTableEntry { 8750, 0, 303, 15, 1 }, // &ContourIntegral;
    HTMLEntityTableEntry { 8450, 0, 375, 4, 1 }, // &Copf;
    HTMLEntityTableEntry { 8720, 0, 379, 9, 1 }, // &Coproduct;
    HTMLEntityTableEntry { 8755, 0, 388, 31, 1 }, // &CounterClockwiseContourIntegral;
    HTMLEntityTableEntry { 10799, 0, 419, 5, 1 }, // &Cross;
    HTMLEntityTableEntry { 119966, 0, 424, 4, 1 }, // &Cscr;
    HTMLEntityTableEntry { 8915, 0, 428, 3, 1 }, // &Cup;
    HTMLEntityTableEntry { 8781, 0, 428, 6, 1 }, // &CupCap;
    HTMLEntityTableEntry { 8517, 0, 434, 2, 1 }, // &DD;
    HTMLEntityTableEntry { 10513, 0, 434, 8, 1 }, // &DDotrahd;
    HTMLEntityTableEntry { 1026, 0, 442, 4, 1 }, // &DJcy;
    HTMLEntityTableEntry { 1029, 0, 446, 4, 1 }, // &DScy;
    HTMLEntityTableEntry { 1039, 0, 450, 4, 1 }, // &DZcy;
    HTMLEntityTableEntry { 8225, 0, 454, 6, 1 }, // &Dagger;
    HTMLEntityTableEntry { 8609, 0, 460, 4, 1 }, // &Darr;
    HTMLEntityTableEntry { 10980, 0, 464, 5, 1 }, // &Dashv;
    HTMLEntityTableEntry { 270, 0, 469, 6, 1 }, // &Dcaron;
    HTMLEntityTableEntry { 1044, 0, 475, 3, 1 }, // &Dcy;
    HTMLEntityTableEntry { 8711, 0, 478, 3, 1 }, // &Del;
    HTMLEntityTableEntry { 916, 0, 478, 5, 1 }, // &Delta;
    HTMLEntityTableEntry { 120071, 0, 483, 3, 1 }, // &Dfr;
    HTMLEntityTableEntry { 180, 0, 486, 16, 1 }, // &DiacriticalAcute;
    HTMLEntityTableEntry { 729, 0, 502, 14, 1 }, // &DiacriticalDot;
    HTMLEntityTableEntry { 733, 0, 516, 22, 1 }, // &DiacriticalDoubleAcute;
    HTMLEntityTableEntry { 96, 0, 538, 16, 1 }, // &DiacriticalGrave;
    HTMLEntityTableEntry { 732, 0, 554, 16, 1 }, // &DiacriticalTilde;
    HTMLEntityTableEntry { 8900, 0, 570, 7, 1 }, // &Diamond;
    HTMLEntityTableEntry { 8518, 0, 183, 13, 1 }, // &DifferentialD;
    HTMLEntityTableEntry { 120123, 0, 577, 4, 1 }, // &Dopf;
    HTMLEntityTableEntry { 168, 0, 244, 3, 1 }, // &Dot;
    HTMLEntityTableEntry { 8412, 0, 581, 6, 1 }, // &DotDot;
    HTMLEntityTableEntry { 8784, 0, 584, 8, 1 }, // &DotEqual;
    HTMLEntityTableEntry { 8751, 0, 592, 21, 1 }, // &DoubleContourIntegral;
    HTMLEntityTableEntry { 168, 0, 613, 9, 1 }, // &DoubleDot;
    HTMLEntityTableEntry { 8659, 0, 622, 15, 1 }, // &DoubleDownArrow;
    HTMLEntityTableEntry { 8656, 0, 637, 15, 1 }, // &DoubleLeftArrow;
    HTMLEntityTableEntry { 8660, 0, 652, 20, 1 }, // &DoubleLeftRightArrow;
    HTMLEntityTableEntry { 10980, 0, 672, 13, 1 }, // &DoubleLeftTee;
    HTMLEntityTableEntry { 10232, 0, 685, 19, 1 }, // &DoubleLongLeftArrow;
    HTMLEntityTableEntry { 10234, 0, 704, 24, 1 }, // &DoubleLongLeftRightArrow;
    HTMLEntityTableEntry { 10233, 0, 728, 20, 1 }, // &DoubleLongRightArrow;
    HTMLEntityTableEntry { 8658, 0, 748, 16, 1 }, // &DoubleRightArrow;
    HTMLEntityTableEntry { 8872, 0, 764, 14, 1 }, // &DoubleRightTee;
    HTMLEntityTableEntry { 8657, 0, 778, 13, 1 }, // &DoubleUpArrow;
    HTMLEntityTableEntry { 8661, 0, 791, 17, 1 }, // &DoubleUpDownArrow;
    HTMLEntityTableEntry { 8741, 0, 808, 17, 1 }, // &DoubleVerticalBar;
    HTMLEntityTableEntry { 8595, 0, 628, 9, 1 }, // &DownArrow;
    HTMLEntityTableEntry { 10515, 0, 825, 12, 1 }, // &DownArrowBar;
    HTMLEntityTableEntry { 8693, 0, 837, 16, 1 }, // &DownArrowUpArrow;
    HTMLEntityTableEntry { 785, 0, 853, 9, 1 }, // &DownBreve;
    HTMLEntityTableEntry { 10576, 0, 862, 19, 1 }, // &DownLeftRightVector;
    HTMLEntityTableEntry { 10590, 0, 881, 17, 1 }, // &DownLeftTeeVector;
    HTMLEntityTableEntry { 8637, 0, 898, 14, 1 }, // &DownLeftVector;
    HTMLEntityTableEntry { 10582, 0, 898, 17, 1 }, // &DownLeftVectorBar;
    HTMLEntityTableEntry { 10591, 0, 915, 18, 1 }, // &DownRightTeeVector;
    HTMLEntityTableEntry { 8641, 0, 933, 15, 1 }, // &DownRightVector;
    HTMLEntityTableEntry { 10583, 0, 933, 18, 1 }, // &DownRightVectorBar;
    HTMLEntityTableEntry { 8868, 0, 951, 7, 1 }, // &DownTee;
    HTMLEntityTableEntry { 8615, 0, 951, 12, 1 }, // &DownTeeArrow;
    HTMLEntityTableEntry { 8659, 0, 963, 9, 1 }, // &Downarrow;
    HTMLEntityTableEntry { 119967, 0, 972, 4, 1 }, // &Dscr;
    HTMLEntityTableEntry { 272, 0, 976, 6, 1 }, // &Dstrok;
    HTMLEntityTableEntry { 330, 0, 982, 3, 1 }, // &ENG;
    HTMLEntityTableEntry { 208, 0, 985, 3, 0 }, // &ETH
    HTMLEntityTableEntry { 208, 0, 985, 3, 1 }, // &ETH;
    HTMLEntityTableEntry { 201, 0, 988, 6, 0 }, // &Eacute
    HTMLEntityTableEntry { 201, 0, 988, 6, 1 }, // &Eacute;
    HTMLEntityTableEntry { 282, 0, 994, 6, 1 }, // &Ecaron;
    HTMLEntityTableEntry { 202, 0, 1000, 5, 0 }, // &Ecirc
    HTMLEntityTableEntry { 202, 0, 1000, 5, 1 }, // &Ecirc;
    HTMLEntityTableEntry { 1069, 0, 1005, 3, 1 }, // &Ecy;
    HTMLEntityTableEntry { 278, 0, 1008, 4, 1 }, // &Edot;
    HTMLEntityTableEntry { 120072, 0, 1012, 3, 1 }, // &Efr;
    HTMLEntityTableEntry { 200, 0, 1015, 6, 0 }, // &Egrave
    HTMLEntityTableEntry { 200, 0, 1015, 6, 1 }, // &Egrave;
    HTMLEntityTableEntry { 8712, 0, 1021, 7, 1 }, // &Element;
    HTMLEntityTableEntry { 274, 0, 1028, 5, 1 }, // &Emacr;
    HTMLEntityTableEntry { 9723, 0, 1033, 16, 1 }, // &EmptySmallSquare;
    HTMLEntityTableEntry { 9643, 0, 1049, 20, 1 }, // &EmptyVerySmallSquare;
    HTMLEntityTableEntry { 280, 0, 1069, 5, 1 }, // &Eogon;
    HTMLEntityTableEntry { 120124, 0, 1074, 4, 1 }, // &Eopf;
    HTMLEntityTableEntry { 917, 0, 1078, 7, 1 }, // &Epsilon;
    HTMLEntityTableEntry { 10869, 0, 587, 5, 1 }, // &Equal;
    HTMLEntityTableEntry { 8770, 0, 1085, 10, 1 }, // &EqualTilde;
    HTMLEntityTableEntry { 8652, 0, 1095, 11, 1 }, // &Equilibrium;
    HTMLEntityTableEntry { 8496, 0, 1106, 4, 1 }, // &Escr;
    HTMLEntityTableEntry { 10867, 0, 1110, 4, 1 }, // &Esim;
    HTMLEntityTableEntry { 919, 0, 1114, 3, 1 }, // &Eta;
    HTMLEntityTableEntry { 203, 0, 1117, 4, 0 }, // &Euml
    HTMLEntityTableEntry { 203, 0, 1117, 4, 1 }, // &Euml;
    HTMLEntityTableEntry { 8707, 0, 1121, 6, 1 }, // &Exists;
    HTMLEntityTableEntry { 8519, 0, 1127, 12, 1 }, // &ExponentialE;
    HTMLEntityTableEntry { 1060, 0, 1139, 3, 1 }, // &Fcy;
    HTMLEntityTableEntry { 120073, 0, 1142, 3, 1 }, // &Ffr;
    HTMLEntityTableEntry { 9724, 0, 1145, 17, 1 }, // &FilledSmallSquare;
    HTMLEntityTableEntry { 9642, 0, 1162, 21, 1 }, // &FilledVerySmallSquare;
    HTMLEntityTableEntry { 120125, 0, 1183, 4, 1 }, // &Fopf;
    HTMLEntityTableEntry { 8704, 0, 1187, 6, 1 }, // &ForAll;
    HTMLEntityTableEntry { 8497, 0, 1193, 10, 1 }, // &Fouriertrf;
    HTMLEntityTableEntry { 8497, 0, 1203, 4, 1 }, // &Fscr;
    HTMLEntityTableEntry { 1027, 0, 1207, 4, 1 }, // &GJcy;
    HTMLEntityTableEntry { 62, 0, 1211, 2, 0 }, // &GT
    HTMLEntityTableEntry { 62, 0, 1211, 2, 1 }, // &GT;
    HTMLEntityTableEntry { 915, 0, 1213, 5, 1 }, // &Gamma;
    HTMLEntityTableEntry { 988, 0, 1213, 6, 1 }, // &Gammad;
    HTMLEntityTableEntry { 286, 0, 1219, 6, 1 }, // &Gbreve;
    HTMLEntityTableEntry { 290, 0, 1225, 6, 1 }, // &Gcedil;
    HTMLEntityTableEntry { 284, 0, 1231, 5, 1 }, // &Gcirc;
    HTMLEntityTableEntry { 1043, 0, 1236, 3, 1 }, // &Gcy;
    HTMLEntityTableEntry { 288, 0, 1239, 4, 1 }, // &Gdot;
    HTMLEntityTableEntry { 120074, 0, 1243, 3, 1 }, // &Gfr;
    HTMLEntityTableEntry { 8921, 0, 1246, 2, 1 }, // &Gg;
    HTMLEntityTableEntry { 120126, 0, 1248, 4, 1 }, // &Gopf;
    HTMLEntityTableEntry { 8805, 0, 1252, 12, 1 }, // &GreaterEqual;
    HTMLEntityTableEntry { 8923, 0, 1252, 16, 1 }, // &GreaterEqualLess;
    HTMLEntityTableEntry { 8807, 0, 1268, 16, 1 }, // &GreaterFullEqual;
    HTMLEntityTableEntry { 10914, 0, 1284, 14, 1 }, // &GreaterGreater;
    HTMLEntityTableEntry { 8823, 0, 1291, 11, 1 }, // &GreaterLess;
    HTMLEntityTableEntry { 10878, 0, 1302, 17, 1 }, // &GreaterSlantEqual;
    HTMLEntityTableEntry { 8819, 0, 1319, 12, 1 }, // &GreaterTilde;
    HTMLEntityTableEntry { 119970, 0, 1331, 4, 1 }, // &Gscr;
    HTMLEntityTableEntry { 8811, 0, 1335, 2, 1 }, // &Gt;
    HTMLEntityTableEntry { 1066, 0, 1337, 6, 1 }, // &HARDcy;
    HTMLEntityTableEntry { 711, 0, 1343, 5, 1 }, // &Hacek;
    HTMLEntityTableEntry { 94, 0, 1348, 3, 1 }, // &Hat;
    HTMLEntityTableEntry { 292, 0, 1351, 5, 1 }, // &Hcirc;
    HTMLEntityTableEntry { 8460, 0, 1356, 3, 1 }, // &Hfr;
    HTMLEntityTableEntry { 8459, 0, 1359, 12, 1 }, // &HilbertSpace;
    HTMLEntityTableEntry { 8461, 0, 1371, 4, 1 }, // &Hopf;
    HTMLEntityTableEntry { 9472, 0, 1375, 14, 1 }, // &HorizontalLine;
    HTMLEntityTableEntry { 8459, 0, 1389, 4, 1 }, // &Hscr;
    HTMLEntityTableEntry { 294, 0, 1393, 6, 1 }, // &Hstrok;
    HTMLEntityTableEntry { 8782, 0, 1399, 12, 1 }, // &HumpDownHump;
    HTMLEntityTableEntry { 8783, 0, 1407, 9, 1 }, // &HumpEqual;
    HTMLEntityTableEntry { 1045, 0, 1416, 4, 1 }, // &IEcy;
    HTMLEntityTableEntry { 306, 0, 1420, 5, 1 }, // &IJlig;
    HTMLEntityTableEntry { 1025, 0, 1425, 4, 1 }, // &IOcy;
    HTMLEntityTableEntry { 205, 0, 1429, 6, 0 }, // &Iacute
    HTMLEntityTableEntry { 205, 0, 1429, 6, 1 }, // &Iacute;
    HTMLEntityTableEntry { 206, 0, 1435, 5, 0 }, // &Icirc
    HTMLEntityTableEntry { 206, 0, 1435, 5, 1 }, // &Icirc;
    HTMLEntityTableEntry { 1048, 0, 1440, 3, 1 }, // &Icy;
    HTMLEntityTableEntry { 304, 0, 1443, 4, 1 }, // &Idot;
    HTMLEntityTableEntry { 8465, 0, 1447, 3, 1 }, // &Ifr;
    HTMLEntityTableEntry { 204, 0, 1450, 6, 0 }, // &Igrave
    HTMLEntityTableEntry { 204, 0, 1450, 6, 1 }, // &Igrave;
    HTMLEntityTableEntry { 8465, 0, 1456, 2, 1 }, // &Im;
    HTMLEntityTableEntry { 298, 0, 1456, 5, 1 }, // &Imacr;
    HTMLEntityTableEntry { 8520, 0, 1461, 10, 1 }, // &ImaginaryI;
    HTMLEntityTableEntry { 8658, 0, 1470, 7, 1 }, // &Implies;
    HTMLEntityTableEntry { 8748, 0, 310, 3, 1 }, // &Int;
    HTMLEntityTableEntry { 8747, 0, 310, 8, 1 }, // &Integral;
    HTMLEntityTableEntry { 8898, 0, 1477, 12, 1 }, // &Intersection;
    HTMLEntityTableEntry { 8291, 0, 1489, 14, 1 }, // &InvisibleComma;
    HTMLEntityTableEntry { 8290, 0, 1503, 14, 1 }, // &InvisibleTimes;
    HTMLEntityTableEntry { 302, 0, 1517, 5, 1 }, // &Iogon;
    HTMLEntityTableEntry { 120128, 0, 1522, 4, 1 }, // &Iopf;
    HTMLEntityTableEntry { 921, 0, 1526, 4, 1 }, // &Iota;
    HTMLEntityTableEntry { 8464, 0, 1530, 4, 1 }, // &Iscr;
    HTMLEntityTableEntry { 296, 0, 1534, 6, 1 }, // &Itilde;
    HTMLEntityTableEntry { 1030, 0, 1540, 5, 1 }, // &Iukcy;
    HTMLEntityTableEntry { 207, 0, 1545, 4, 0 }, // &Iuml
    HTMLEntityTableEntry { 207, 0, 1545, 4, 1 }, // &Iuml;
    HTMLEntityTableEntry { 308, 0, 1549, 5, 1 }, // &Jcirc;
    HTMLEntityTableEntry { 1049, 0, 443, 3, 1 }, // &Jcy;
    HTMLEntityTableEntry { 120077, 0, 1554, 3, 1 }, // &Jfr;
    HTMLEntityTableEntry { 120129, 0, 1557, 4, 1 }, // &Jopf;
    HTMLEntityTableEntry { 119973, 0, 1561, 4, 1 }, // &Jscr;
    HTMLEntityTableEntry { 1032, 0, 1565, 6, 1 }, // &Jsercy;
    HTMLEntityTableEntry { 1028, 0, 1571, 5, 1 }, // &Jukcy;
    HTMLEntityTableEntry { 1061, 0, 1576, 4, 1 }, // &KHcy;
    HTMLEntityTableEntry { 1036, 0, 1580, 4, 1 }, // &KJcy;
    HTMLEntityTableEntry { 922, 0, 1584, 5, 1 }, // &Kappa;
    HTMLEntityTableEntry { 310, 0, 1589, 6, 1 }, // &Kcedil;
    HTMLEntityTableEntry { 1050, 0, 1595, 3, 1 }, // &Kcy;
    HTMLEntityTableEntry { 120078, 0, 1598, 3, 1 }, // &Kfr;
    HTMLEntityTableEntry { 120130, 0, 1601, 4, 1 }, // &Kopf;
    HTMLEntityTableEntry { 119974, 0, 1605, 4, 1 }, // &Kscr;
    HTMLEntityTableEntry { 1033, 0, 1609, 4, 1 }, // &LJcy;
    HTMLEntityTableEntry { 60, 0, 1613, 2, 0 }, // &LT
    HTMLEntityTableEntry { 60, 0, 1613, 2, 1 }, // &LT;
    HTMLEntityTableEntry { 313, 0, 1615, 6, 1 }, // &Lacute;
    HTMLEntityTableEntry { 923, 0, 1621, 6, 1 }, // &Lambda;
    HTMLEntityTableEntry { 10218, 0, 1627, 4, 1 }, // &Lang;
    HTMLEntityTableEntry { 8466, 0, 1631, 10, 1 }, // &Laplacetrf;
    HTMLEntityTableEntry { 8606, 0, 1641, 4, 1 }, // &Larr;
    HTMLEntityTableEntry { 317, 0, 1645, 6, 1 }, // &Lcaron;
    HTMLEntityTableEntry { 315, 0, 1651, 6, 1 }, // &Lcedil;
    HTMLEntityTableEntry { 1051, 0, 1657, 3, 1 }, // &Lcy;
    HTMLEntityTableEntry { 10216, 0, 1660, 16, 1 }, // &LeftAngleBracket;
    HTMLEntityTableEntry { 8592, 0, 643, 9, 1 }, // &LeftArrow;
    HTMLEntityTableEntry { 8676, 0, 1676, 12, 1 }, // &LeftArrowBar;
    HTMLEntityTableEntry { 8646, 0, 1688, 19, 1 }, // &LeftArrowRightArrow;
    HTMLEntityTableEntry { 8968, 0, 1707, 11, 1 }, // &LeftCeiling;
    HTMLEntityTableEntry { 10214, 0, 1718, 17, 1 }, // &LeftDoubleBracket;
    HTMLEntityTableEntry { 10593, 0, 1735, 17, 1 }, // &LeftDownTeeVector;
    HTMLEntityTableEntry { 8643, 0, 1752, 14, 1 }, // &LeftDownVector;
    HTMLEntityTableEntry { 10585, 0, 1752, 17, 1 }, // &LeftDownVectorBar;
    HTMLEntityTableEntry { 8970, 0, 1769, 9, 1 }, // &LeftFloor;
    HTMLEntityTableEntry { 8596, 0, 658, 14, 1 }, // &LeftRightArrow;
    HTMLEntityTableEntry { 10574, 0, 866, 15, 1 }, // &LeftRightVector;
    HTMLEntityTableEntry { 8867, 0, 678, 7, 1 }, // &LeftTee;
    HTMLEntityTableEntry { 8612, 0, 1778, 12, 1 }, // &LeftTeeArrow;
    HTMLEntityTableEntry { 10586, 0, 885, 13, 1 }, // &LeftTeeVector;
    HTMLEntityTableEntry { 8882, 0, 1790, 12, 1 }, // &LeftTriangle;
    HTMLEntityTableEntry { 10703, 0, 1790, 15, 1 }, // &LeftTriangleBar;
    HTMLEntityTableEntry { 8884, 0, 1805, 17, 1 }, // &LeftTriangleEqual;
    HTMLEntityTableEntry { 10577, 0, 1822, 16, 1 }, // &LeftUpDownVector;
    HTMLEntityTableEntry { 10592, 0, 1838, 15, 1 }, // &LeftUpTeeVector;
    HTMLEntityTableEntry { 8639, 0, 1853, 12, 1 }, // &LeftUpVector;
    HTMLEntityTableEntry { 10584, 0, 1853, 15, 1 }, // &LeftUpVectorBar;
    HTMLEntityTableEntry { 8636, 0, 902, 10, 1 }, // &LeftVector;
    HTMLEntityTableEntry { 10578, 0, 902, 13, 1 }, // &LeftVectorBar;
    HTMLEntityTableEntry { 8656, 0, 1868, 9, 1 }, // &Leftarrow;
    HTMLEntityTableEntry { 8660, 0, 1877, 14, 1 }, // &Leftrightarrow;
    HTMLEntityTableEntry { 8922, 0, 1891, 16, 1 }, // &LessEqualGreater;
    HTMLEntityTableEntry { 8806, 0, 1907, 13, 1 }, // &LessFullEqual;
    HTMLEntityTableEntry { 8822, 0, 1264, 11, 1 }, // &LessGreater;
    HTMLEntityTableEntry { 10913, 0, 1920, 8, 1 }, // &LessLess;
    HTMLEntityTableEntry { 10877, 0, 1924, 14, 1 }, // &LessSlantEqual;
    HTMLEntityTableEntry { 8818, 0, 1938, 9, 1 }, // &LessTilde;
    HTMLEntityTableEntry { 120079, 0, 1947, 3, 1 }, // &Lfr;
    HTMLEntityTableEntry { 8920, 0, 1950, 2, 1 }, // &Ll;
    HTMLEntityTableEntry { 8666, 0, 1950, 10, 1 }, // &Lleftarrow;
    HTMLEntityTableEntry { 319, 0, 1960, 6, 1 }, // &Lmidot;
    HTMLEntityTableEntry { 10229, 0, 691, 13, 1 }, // &LongLeftArrow;
    HTMLEntityTableEntry { 10231, 0, 710, 18, 1 }, // &LongLeftRightArrow;
    HTMLEntityTableEntry { 10230, 0, 734, 14, 1 }, // &LongRightArrow;
    HTMLEntityTableEntry { 10232, 0, 1966, 13, 1 }, // &Longleftarrow;
    HTMLEntityTableEntry { 10234, 0, 1979, 18, 1 }, // &Longleftrightarrow;
    HTMLEntityTableEntry { 10233, 0, 1997, 14, 1 }, // &Longrightarrow;
    HTMLEntityTableEntry { 120131, 0, 2011, 4, 1 }, // &Lopf;
    HTMLEntityTableEntry { 8601, 0, 2015, 14, 1 }, // &LowerLeftArrow;
    HTMLEntityTableEntry { 8600, 0, 2029, 15, 1 }, // &LowerRightArrow;
    HTMLEntityTableEntry { 8466, 0, 2044, 4, 1 }, // &Lscr;
    HTMLEntityTableEntry { 8624, 0, 2048, 3, 1 }, // &Lsh;
    HTMLEntityTableEntry { 321, 0, 2051, 6, 1 }, // &Lstrok;
    HTMLEntityTableEntry { 8810, 0, 2057, 2, 1 }, // &Lt;
    HTMLEntityTableEntry { 10501, 0, 2059, 3, 1 }, // &Map;
    HTMLEntityTableEntry { 1052, 0, 2062, 3, 1 }, // &Mcy;
    HTMLEntityTableEntry { 8287, 0, 2065, 11, 1 }, // &MediumSpace;
    HTMLEntityTableEntry { 8499, 0, 2076, 9, 1 }, // &Mellintrf;
    HTMLEntityTableEntry { 120080, 0, 2085, 3, 1 }, // &Mfr;
    HTMLEntityTableEntry { 8723, 0, 2088, 9, 1 }, // &MinusPlus;
    HTMLEntityTableEntry { 120132, 0, 2097, 4, 1 }, // &Mopf;
    HTMLEntityTableEntry { 8499, 0, 2101, 4, 1 }, // &Mscr;
    HTMLEntityTableEntry { 924, 0, 2105, 2, 1 }, // &Mu;
    HTMLEntityTableEntry { 1034, 0, 2107, 4, 1 }, // &NJcy;
    HTMLEntityTableEntry { 323, 0, 2111, 6, 1 }, // &Nacute;
    HTMLEntityTableEntry { 327, 0, 2117, 6, 1 }, // &Ncaron;
    HTMLEntityTableEntry { 325, 0, 2123, 6, 1 }, // &Ncedil;
    HTMLEntityTableEntry { 1053, 0, 2129, 3, 1 }, // &Ncy;
    HTMLEntityTableEntry { 8203, 0, 2132, 19, 1 }, // &NegativeMediumSpace;
    HTMLEntityTableEntry { 8203, 0, 2151, 18, 1 }, // &NegativeThickSpace;
    HTMLEntityTableEntry { 8203, 0, 2169, 17, 1 }, // &NegativeThinSpace;
    HTMLEntityTableEntry { 8203, 0, 2186, 21, 1 }, // &NegativeVeryThinSpace;
    HTMLEntityTableEntry { 8811, 0, 2207, 20, 1 }, // &NestedGreaterGreater;
    HTMLEntityTableEntry { 8810, 0, 2227, 14, 1 }, // &NestedLessLess;
    HTMLEntityTableEntry { 10, 0, 2241, 7, 1 }, // &NewLine;
    HTMLEntityTableEntry { 120081, 0, 2248, 3, 1 }, // &Nfr;
    HTMLEntityTableEntry { 8288, 0, 2251, 7, 1 }, // &NoBreak;
    HTMLEntityTableEntry { 160, 0, 2258, 16, 1 }, // &NonBreakingSpace;
    HTMLEntityTableEntry { 8469, 0, 2274, 4, 1 }, // &Nopf;
    HTMLEntityTableEntry { 10988, 0, 2278, 3, 1 }, // &Not;
    HTMLEntityTableEntry { 8802, 0, 2278, 12, 1 }, // &NotCongruent;
    HTMLEntityTableEntry { 8813, 0, 2290, 9, 1 }, // &NotCupCap;
    HTMLEntityTableEntry { 8742, 0, 2299, 20, 1 }, // &NotDoubleVerticalBar;
    HTMLEntityTableEntry { 8713, 0, 2319, 10, 1 }, // &NotElement;
    HTMLEntityTableEntry { 8800, 0, 2329, 8, 1 }, // &NotEqual;
    HTMLEntityTableEntry { 8770, 824, 2329, 13, 1 }, // &NotEqualTilde;
    HTMLEntityTableEntry { 8708, 0, 2342, 9, 1 }, // &NotExists;
    HTMLEntityTableEntry { 8815, 0, 2351, 10, 1 }, // &NotGreater;
    HTMLEntityTableEntry { 8817, 0, 2351, 15, 1 }, // &NotGreaterEqual;
    HTMLEntityTableEntry { 8807, 824, 2366, 19, 1 }, // &NotGreaterFullEqual;
    HTMLEntityTableEntry { 8811, 824, 2385, 17, 1 }, // &NotGreaterGreater;
    HTMLEntityTableEntry { 8825, 0, 2402, 14, 1 }, // &NotGreaterLess;
    HTMLEntityTableEntry { 10878, 824, 2416, 20, 1 }, // &NotGreaterSlantEqual;
    HTMLEntityTableEntry { 8821, 0, 2436, 15, 1 }, // &NotGreaterTilde;
    HTMLEntityTableEntry { 8782, 824, 2451, 15, 1 }, // &NotHumpDownHump;
    HTMLEntityTableEntry { 8783, 824, 2466, 12, 1 }, // &NotHumpEqual;
    HTMLEntityTableEntry { 8938, 0, 2478, 15, 1 }, // &NotLeftTriangle;
    HTMLEntityTableEntry { 10703, 824, 2478, 18, 1 }, // &NotLeftTriangleBar;
    HTMLEntityTableEntry { 8940, 0, 2496, 20, 1 }, // &NotLeftTriangleEqual;
    HTMLEntityTableEntry { 8814, 0, 2516, 7, 1 }, // &NotLess;
    HTMLEntityTableEntry { 8816, 0, 2516, 12, 1 }, // &NotLessEqual;
    HTMLEntityTableEntry { 8824, 0, 2528, 14, 1 }, // &NotLessGreater;
    HTMLEntityTableEntry { 8810, 824, 2542, 11, 1 }, // &NotLessLess;
    HTMLEntityTableEntry { 10877, 824, 2553, 17, 1 }, // &NotLessSlantEqual;
    HTMLEntityTableEntry { 8820, 0, 2570, 12, 1 }, // &NotLessTilde;
    HTMLEntityTableEntry { 10914, 824, 2582, 23, 1 }, // &NotNestedGreaterGreater;
    HTMLEntityTableEntry { 10913, 824, 2605, 17, 1 }, // &NotNestedLessLess;
    HTMLEntityTableEntry { 8832, 0, 2622, 11, 1 }, // &NotPrecedes;
    HTMLEntityTableEntry { 10927, 824, 2622, 16, 1 }, // &NotPrecedesEqual;
    HTMLEntityTableEntry { 8928, 0, 2638, 21, 1 }, // &NotPrecedesSlantEqual;
    HTMLEntityTableEntry { 8716, 0, 2659, 17, 1 }, // &NotReverseElement;
    HTMLEntityTableEntry { 8939, 0, 2676, 16, 1 }, // &NotRightTriangle;
    HTMLEntityTableEntry { 10704, 824, 2676, 19, 1 }, // &NotRightTriangleBar;
    HTMLEntityTableEntry { 8941, 0, 2695, 21, 1 }, // &NotRightTriangleEqual;
    HTMLEntityTableEntry { 8847, 824, 2716, 15, 1 }, // &NotSquareSubset;
    HTMLEntityTableEntry { 8930, 0, 2716, 20, 1 }, // &NotSquareSubsetEqual;
    HTMLEntityTableEntry { 8848, 824, 2736, 17, 1 }, // &NotSquareSuperset;
    HTMLEntityTableEntry { 8931, 0, 2736, 22, 1 }, // &NotSquareSupersetEqual;
    HTMLEntityTableEntry { 8834, 8402, 2758, 9, 1 }, // &NotSubset;
    HTMLEntityTableEntry { 8840, 0, 2758, 14, 1 }, // &NotSubsetEqual;
    HTMLEntityTableEntry { 8833, 0, 2772, 11, 1 }, // &NotSucceeds;
    HTMLEntityTableEntry { 10928, 824, 2772, 16, 1 }, // &NotSucceedsEqual;
    HTMLEntityTableEntry { 8929, 0, 2788, 21, 1 }, // &NotSucceedsSlantEqual;
    HTMLEntityTableEntry { 8831, 824, 2809, 16, 1 }, // &NotSucceedsTilde;
    HTMLEntityTableEntry { 8835, 8402, 2825, 11, 1 }, // &NotSuperset;
    HTMLEntityTableEntry { 8841, 0, 2825, 16, 1 }, // &NotSupersetEqual;
    HTMLEntityTableEntry { 8769, 0, 2841, 8, 1 }, // &NotTilde;
    HTMLEntityTableEntry { 8772, 0, 2841, 13, 1 }, // &NotTildeEqual;
    HTMLEntityTableEntry { 8775, 0, 2854, 17, 1 }, // &NotTildeFullEqual;
    HTMLEntityTableEntry { 8777, 0, 2871, 13, 1 }, // &NotTildeTilde;
    HTMLEntityTableEntry { 8740, 0, 2884, 14, 1 }, // &NotVerticalBar;
    HTMLEntityTableEntry { 119977, 0, 2898, 4, 1 }, // &Nscr;
    HTMLEntityTableEntry { 209, 0, 2902, 6, 0 }, // &Ntilde
    HTMLEntityTableEntry { 209, 0, 2902, 6, 1 }, // &Ntilde;
    HTMLEntityTableEntry { 925, 0, 2908, 2, 1 }, // &Nu;
    HTMLEntityTableEntry { 338, 0, 2910, 5, 1 }, // &OElig;
    HTMLEntityTableEntry { 211, 0, 2915, 6, 0 }, // &Oacute
    HTMLEntityTableEntry { 211, 0, 2915, 6, 1 }, // &Oacute;
    HTMLEntityTableEntry { 212, 0, 2921, 5, 0 }, // &Ocirc
    HTMLEntityTableEntry { 212, 0, 2921, 5, 1 }, // &Ocirc;
    HTMLEntityTableEntry { 1054, 0, 1426, 3, 1 }, // &Ocy;
    HTMLEntityTableEntry { 336, 0, 2926, 6, 1 }, // &Odblac;
    HTMLEntityTableEntry { 120082, 0, 2932, 3, 1 }, // &Ofr;
    HTMLEntityTableEntry { 210, 0, 2935, 6, 0 }, // &Ograve
    HTMLEntityTableEntry { 210, 0, 2935, 6, 1 }, // &Ograve;
    HTMLEntityTableEntry { 332, 0, 2941, 5, 1 }, // &Omacr;
    HTMLEntityTableEntry { 937, 0, 2946, 5, 1 }, // &Omega;
    HTMLEntityTableEntry { 927, 0, 2951, 7, 1 }, // &Omicron;
    HTMLEntityTableEntry { 120134, 0, 2958, 4, 1 }, // &Oopf;
    HTMLEntityTableEntry { 8220, 0, 2962, 20, 1 }, // &OpenCurlyDoubleQuote;
    HTMLEntityTableEntry { 8216, 0, 2982, 14, 1 }, // &OpenCurlyQuote;
    HTMLEntityTableEntry { 10836, 0, 2996, 2, 1 }, // &Or;
    HTMLEntityTableEntry { 119978, 0, 2998, 4, 1 }, // &Oscr;
    HTMLEntityTableEntry { 216, 0, 3002, 6, 0 }, // &Oslash
    HTMLEntityTableEntry { 216, 0, 3002, 6, 1 }, // &Oslash;
    HTMLEntityTableEntry { 213, 0, 3008, 6, 0 }, // &Otilde
    HTMLEntityTableEntry { 213, 0, 3008, 6, 1 }, // &Otilde;
    HTMLEntityTableEntry { 10807, 0, 3014, 6, 1 }, // &Otimes;
    HTMLEntityTableEntry { 214, 0, 3020, 4, 0 }, // &Ouml
    HTMLEntityTableEntry { 214, 0, 3020, 4, 1 }, // &Ouml;
    HTMLEntityTableEntry { 8254, 0, 3024, 7, 1 }, // &OverBar;
    HTMLEntityTableEntry { 9182, 0, 3031, 9, 1 }, // &OverBrace;
    HTMLEntityTableEntry { 9140, 0, 3040, 11, 1 }, // &OverBracket;
    HTMLEntityTableEntry { 9180, 0, 3051, 15, 1 }, // &OverParenthesis;
    HTMLEntityTableEntry { 8706, 0, 3066, 8, 1 }, // &PartialD;
    HTMLEntityTableEntry { 1055, 0, 3074, 3, 1 }, // &Pcy;
    HTMLEntityTableEntry { 120083, 0, 3077, 3, 1 }, // &Pfr;
    HTMLEntityTableEntry { 934, 0, 3080, 3, 1 }, // &Phi;
    HTMLEntityTableEntry { 928, 0, 3083, 2, 1 }, // &Pi;
    HTMLEntityTableEntry { 177, 0, 3085, 9, 1 }, // &PlusMinus;
    HTMLEntityTableEntry { 8460, 0, 3094, 13, 1 }, // &Poincareplane;
    HTMLEntityTableEntry { 8473, 0, 3107, 4, 1 }, // &Popf;
    HTMLEntityTableEntry { 10939, 0, 2625, 2, 1 }, // &Pr;
    HTMLEntityTableEntry { 8826, 0, 2625, 8, 1 }, // &Precedes;
    HTMLEntityTableEntry { 10927, 0, 2625, 13, 1 }, // &PrecedesEqual;
    HTMLEntityTableEntry { 8828, 0, 2641, 18, 1 }, // &PrecedesSlantEqual;
    HTMLEntityTableEntry { 8830, 0, 3111, 13, 1 }, // &PrecedesTilde;
    HTMLEntityTableEntry { 8243, 0, 3124, 5, 1 }, // &Prime;
    HTMLEntityTableEntry { 8719, 0, 3129, 7, 1 }, // &Product;
    HTMLEntityTableEntry { 8759, 0, 3136, 10, 1 }, // &Proportion;
    HTMLEntityTableEntry { 8733, 0, 3136, 12, 1 }, // &Proportional;
    HTMLEntityTableEntry { 119979, 0, 3148, 4, 1 }, // &Pscr;
    HTMLEntityTableEntry { 936, 0, 3152, 3, 1 }, // &Psi;
    HTMLEntityTableEntry { 34, 0, 3155, 4, 0 }, // &QUOT
    HTMLEntityTableEntry { 34, 0, 3155, 4, 1 }, // &QUOT;
    HTMLEntityTableEntry { 120084, 0, 3159, 3, 1 }, // &Qfr;
    HTMLEntityTableEntry { 8474, 0, 3162, 4, 1 }, // &Qopf;
    HTMLEntityTableEntry { 119980, 0, 3166, 4, 1 }, // &Qscr;
    HTMLEntityTableEntry { 10512, 0, 3170, 5, 1 }, // &RBarr;
    HTMLEntityTableEntry { 174, 0, 3175, 3, 0 }, // &REG
    HTMLEntityTableEntry { 174, 0, 3175, 3, 1 }, // &REG;
    HTMLEntityTableEntry { 340, 0, 3178, 6, 1 }, // &Racute;
    HTMLEntityTableEntry { 10219, 0, 3184, 4, 1 }, // &Rang;
    HTMLEntityTableEntry { 8608, 0, 3188, 4, 1 }, // &Rarr;
    HTMLEntityTableEntry { 10518, 0, 3188, 6, 1 }, // &Rarrtl;
    HTMLEntityTableEntry { 344, 0, 3194, 6, 1 }, // &Rcaron;
    HTMLEntityTableEntry { 342, 0, 3200, 6, 1 }, // &Rcedil;
    HTMLEntityTableEntry { 1056, 0, 3206, 3, 1 }, // &Rcy;
    HTMLEntityTableEntry { 8476, 0, 2662, 2, 1 }, // &Re;
    HTMLEntityTableEntry { 8715, 0, 2662, 14, 1 }, // &ReverseElement;
    HTMLEntityTableEntry { 8651, 0, 3209, 18, 1 }, // &ReverseEquilibrium;
    HTMLEntityTableEntry { 10607, 0, 3227, 20, 1 }, // &ReverseUpEquilibrium;
    HTMLEntityTableEntry { 8476, 0, 3247, 3, 1 }, // &Rfr;
    HTMLEntityTableEntry { 929, 0, 3250, 3, 1 }, // &Rho;
    HTMLEntityTableEntry { 10217, 0, 3253, 17, 1 }, // &RightAngleBracket;
    HTMLEntityTableEntry { 8594, 0, 662, 10, 1 }, // &RightArrow;
    HTMLEntityTableEntry { 8677, 0, 3270, 13, 1 }, // &RightArrowBar;
    HTMLEntityTableEntry { 8644, 0, 3283, 19, 1 }, // &RightArrowLeftArrow;
    HTMLEntityTableEntry { 8969, 0, 3302, 12, 1 }, // &RightCeiling;
    HTMLEntityTableEntry { 10215, 0, 3314, 18, 1 }, // &RightDoubleBracket;
    HTMLEntityTableEntry { 10589, 0, 3332, 18, 1 }, // &RightDownTeeVector;
    HTMLEntityTableEntry { 8642, 0, 3350, 15, 1 }, // &RightDownVector;
    HTMLEntityTableEntry { 10581, 0, 3350, 18, 1 }, // &RightDownVectorBar;
    HTMLEntityTableEntry { 8971, 0, 3368, 10, 1 }, // &RightFloor;
    HTMLEntityTableEntry { 8866, 0, 770, 8, 1 }, // &RightTee;
    HTMLEntityTableEntry { 8614, 0, 3378, 13, 1 }, // &RightTeeArrow;
    HTMLEntityTableEntry { 10587, 0, 919, 14, 1 }, // &RightTeeVector;
    HTMLEntityTableEntry { 8883, 0, 2679, 13, 1 }, // &RightTriangle;
    HTMLEntityTableEntry { 10704, 0, 2679, 16, 1 }, // &RightTriangleBar;
    HTMLEntityTableEntry { 8885, 0, 2698, 18, 1 }, // &RightTriangleEqual;
    HTMLEntityTableEntry { 10575, 0, 3391, 17, 1 }, // &RightUpDownVector;
    HTMLEntityTableEntry { 10588, 0, 3408, 16, 1 }, // &RightUpTeeVector;
    HTMLEntityTableEntry { 8638, 0, 3424, 13, 1 }, // &RightUpVector;
    HTMLEntityTableEntry { 10580, 0, 3424, 16, 1 }, // &RightUpVectorBar;
    HTMLEntityTableEntry { 8640, 0, 870, 11, 1 }, // &RightVector;
    HTMLEntityTableEntry { 10579, 0, 937, 14, 1 }, // &RightVectorBar;
    HTMLEntityTableEntry { 8658, 0, 3440, 10, 1 }, // &Rightarrow;
    HTMLEntityTableEntry { 8477, 0, 3450, 4, 1 }, // &Ropf;
    HTMLEntityTableEntry { 10608, 0, 3454, 12, 1 }, // &RoundImplies;
    HTMLEntityTableEntry { 8667, 0, 3466, 11, 1 }, // &Rrightarrow;
    HTMLEntityTableEntry { 8475, 0, 3477, 4, 1 }, // &Rscr;
    HTMLEntityTableEntry { 8625, 0, 3481, 3, 1 }, // &Rsh;
    HTMLEntityTableEntry { 10740, 0, 3484, 11, 1 }, // &RuleDelayed;
    HTMLEntityTableEntry { 1065, 0, 3495, 6, 1 }, // &SHCHcy;
    HTMLEntityTableEntry { 1064, 0, 3501, 4, 1 }, // &SHcy;
    HTMLEntityTableEntry { 1068, 0, 3505, 6, 1 }, // &SOFTcy;
    HTMLEntityTableEntry { 346, 0, 3511, 6, 1 }, // &Sacute;
    HTMLEntityTableEntry { 10940, 0, 447, 2, 1 }, // &Sc;
    HTMLEntityTableEntry { 352, 0, 3517, 6, 1 }, // &Scaron;
    HTMLEntityTableEntry { 350, 0, 3523, 6, 1 }, // &Scedil;
    HTMLEntityTableEntry { 348, 0, 3529, 5, 1 }, // &Scirc;
    HTMLEntityTableEntry { 1057, 0, 447, 3, 1 }, // &Scy;
    HTMLEntityTableEntry { 120086, 0, 3534, 3, 1 }, // &Sfr;
    HTMLEntityTableEntry { 8595, 0, 3537, 14, 1 }, // &ShortDownArrow;
    HTMLEntityTableEntry { 8592, 0, 3551, 14, 1 }, // &ShortLeftArrow;
    HTMLEntityTableEntry { 8594, 0, 3565, 15, 1 }, // &ShortRightArrow;
    HTMLEntityTableEntry { 8593, 0, 3580, 12, 1 }, // &ShortUpArrow;
    HTMLEntityTableEntry { 931, 0, 3592, 5, 1 }, // &Sigma;
    HTMLEntityTableEntry { 8728, 0, 3597, 11, 1 }, // &SmallCircle;
    HTMLEntityTableEntry { 120138, 0, 3608, 4, 1 }, // &Sopf;
    HTMLEntityTableEntry { 8730, 0, 3612, 4, 1 }, // &Sqrt;
    HTMLEntityTableEntry { 9633, 0, 1043, 6, 1 }, // &Square;
    HTMLEntityTableEntry { 8851, 0, 3616, 18, 1 }, // &SquareIntersection;
    HTMLEntityTableEntry { 8847, 0, 2719, 12, 1 }, // &SquareSubset;
    HTMLEntityTableEntry { 8849, 0, 2719, 17, 1 }, // &SquareSubsetEqual;
    HTMLEntityTableEntry { 8848, 0, 2739, 14, 1 }, // &SquareSuperset;
    HTMLEntityTableEntry { 8850, 0, 2739, 19, 1 }, // &SquareSupersetEqual;
    HTMLEntityTableEntry { 8852, 0, 3634, 11, 1 }, // &SquareUnion;
    HTMLEntityTableEntry { 119982, 0, 3645, 4, 1 }, // &Sscr;
    HTMLEntityTableEntry { 8902, 0, 3649, 4, 1 }, // &Star;
    HTMLEntityTableEntry { 8912, 0, 2725, 3, 1 }, // &Sub;
    HTMLEntityTableEntry { 8912, 0, 2725, 6, 1 }, // &Subset;
    HTMLEntityTableEntry { 8838, 0, 2725, 11, 1 }, // &SubsetEqual;
    HTMLEntityTableEntry { 8827, 0, 2775, 8, 1 }, // &Succeeds;
    HTMLEntityTableEntry { 10928, 0, 2775, 13, 1 }, // &SucceedsEqual;
    HTMLEntityTableEntry { 8829, 0, 2791, 18, 1 }, // &SucceedsSlantEqual;
    HTMLEntityTableEntry { 8831, 0, 2812, 13, 1 }, // &SucceedsTilde;
    HTMLEntityTableEntry { 8715, 0, 3653, 8, 1 }, // &SuchThat;
    HTMLEntityTableEntry { 8721, 0, 3661, 3, 1 }, // &Sum;
    HTMLEntityTableEntry { 8913, 0, 2745, 3, 1 }, // &Sup;
    HTMLEntityTableEntry { 8835, 0, 2745, 8, 1 }, // &Superset;
    HTMLEntityTableEntry { 8839, 0, 2745, 13, 1 }, // &SupersetEqual;
    HTMLEntityTableEntry { 8913, 0, 3664, 6, 1 }, // &Supset;
    HTMLEntityTableEntry { 222, 0, 3670, 5, 0 }, // &THORN
    HTMLEntityTableEntry { 222, 0, 3670, 5, 1 }, // &THORN;
    HTMLEntityTableEntry { 8482, 0, 3675, 5, 1 }, // &TRADE;
    HTMLEntityTableEntry { 1035, 0, 3680, 5, 1 }, // &TSHcy;
    HTMLEntityTableEntry { 1062, 0, 3685, 4, 1 }, // &TScy;
    HTMLEntityTableEntry { 9, 0, 3689, 3, 1 }, // &Tab;
    HTMLEntityTableEntry { 932, 0, 3692, 3, 1 }, // &Tau;
    HTMLEntityTableEntry { 356, 0, 3695, 6, 1 }, // &Tcaron;
    HTMLEntityTableEntry { 354, 0, 3701, 6, 1 }, // &Tcedil;
    HTMLEntityTableEntry { 1058, 0, 3508, 3, 1 }, // &Tcy;
    HTMLEntityTableEntry { 120087, 0, 3707, 3, 1 }, // &Tfr;
    HTMLEntityTableEntry { 8756, 0, 3710, 9, 1 }, // &Therefore;
    HTMLEntityTableEntry { 920, 0, 3719, 5, 1 }, // &Theta;
    HTMLEntityTableEntry { 8287, 8202, 2159, 10, 1 }, // &ThickSpace;
    HTMLEntityTableEntry { 8201, 0, 2177, 9, 1 }, // &ThinSpace;
    HTMLEntityTableEntry { 8764, 0, 565, 5, 1 }, // &Tilde;
    HTMLEntityTableEntry { 8771, 0, 2844, 10, 1 }, // &TildeEqual;
    HTMLEntityTableEntry { 8773, 0, 2857, 14, 1 }, // &TildeFullEqual;
    HTMLEntityTableEntry { 8776, 0, 2874, 10, 1 }, // &TildeTilde;
    HTMLEntityTableEntry { 120139, 0, 3724, 4, 1 }, // &Topf;
    HTMLEntityTableEntry { 8411, 0, 3728, 9, 1 }, // &TripleDot;
    HTMLEntityTableEntry { 119983, 0, 3737, 4, 1 }, // &Tscr;
    HTMLEntityTableEntry { 358, 0, 3741, 6, 1 }, // &Tstrok;
    HTMLEntityTableEntry { 218, 0, 3747, 6, 0 }, // &Uacute
    HTMLEntityTableEntry { 218, 0, 3747, 6, 1 }, // &Uacute;
    HTMLEntityTableEntry { 8607, 0, 3753, 4, 1 }, // &Uarr;
    HTMLEntityTableEntry { 10569, 0, 3753, 8, 1 }, // &Uarrocir;
    HTMLEntityTableEntry { 1038, 0, 3761, 5, 1 }, // &Ubrcy;
    HTMLEntityTableEntry { 364, 0, 3766, 6, 1 }, // &Ubreve;
    HTMLEntityTableEntry { 219, 0, 3772, 5, 0 }, // &Ucirc
    HTMLEntityTableEntry { 219, 0, 3772, 5, 1 }, // &Ucirc;
    HTMLEntityTableEntry { 1059, 0, 3777, 3, 1 }, // &Ucy;
    HTMLEntityTableEntry { 368, 0, 3780, 6, 1 }, // &Udblac;
    HTMLEntityTableEntry { 120088, 0, 3786, 3, 1 }, // &Ufr;
    HTMLEntityTableEntry { 217, 0, 3789, 6, 0 }, // &Ugrave
    HTMLEntityTableEntry { 217, 0, 3789, 6, 1 }, // &Ugrave;
    HTMLEntityTableEntry { 362, 0, 3795, 5, 1 }, // &Umacr;
    HTMLEntityTableEntry { 95, 0, 3800, 8, 1 }, // &UnderBar;
    HTMLEntityTableEntry { 9183, 0, 3808, 10, 1 }, // &UnderBrace;
    HTMLEntityTableEntry { 9141, 0, 3818, 12, 1 }, // &UnderBracket;
    HTMLEntityTableEntry { 9181, 0, 3830, 16, 1 }, // &UnderParenthesis;
    HTMLEntityTableEntry { 8899, 0, 3640, 5, 1 }, // &Union;
    HTMLEntityTableEntry { 8846, 0, 3846, 9, 1 }, // &UnionPlus;
    HTMLEntityTableEntry { 370, 0, 3855, 5, 1 }, // &Uogon;
    HTMLEntityTableEntry { 120140, 0, 3860, 4, 1 }, // &Uopf;
    HTMLEntityTableEntry { 8593, 0, 784, 7, 1 }, // &UpArrow;
    HTMLEntityTableEntry { 10514, 0, 3864, 10, 1 }, // &UpArrowBar;
    HTMLEntityTableEntry { 8645, 0, 3874, 16, 1 }, // &UpArrowDownArrow;
    HTMLEntityTableEntry { 8597, 0, 797, 11, 1 }, // &UpDownArrow;
    HTMLEntityTableEntry { 10606, 0, 3234, 13, 1 }, // &UpEquilibrium;
    HTMLEntityTableEntry { 8869, 0, 1842, 5, 1 }, // &UpTee;
    HTMLEntityTableEntry { 8613, 0, 3890, 10, 1 }, // &UpTeeArrow;
    HTMLEntityTableEntry { 8657, 0, 3900, 7, 1 }, // &Uparrow;
    HTMLEntityTableEntry { 8661, 0, 3907, 11, 1 }, // &Updownarrow;
    HTMLEntityTableEntry { 8598, 0, 3918, 14, 1 }, // &UpperLeftArrow;
    HTMLEntityTableEntry { 8599, 0, 3932, 15, 1 }, // &UpperRightArrow;
    HTMLEntityTableEntry { 978, 0, 3947, 4, 1 }, // &Upsi;
    HTMLEntityTableEntry { 933, 0, 3947, 7, 1 }, // &Upsilon;
    HTMLEntityTableEntry { 366, 0, 3954, 5, 1 }, // &Uring;
    HTMLEntityTableEntry { 119984, 0, 3959, 4, 1 }, // &Uscr;
    HTMLEntityTableEntry { 360, 0, 3963, 6, 1 }, // &Utilde;
    HTMLEntityTableEntry { 220, 0, 3969, 4, 0 }, // &Uuml
    HTMLEntityTableEntry { 220, 0, 3969, 4, 1 }, // &Uuml;
    HTMLEntityTableEntry { 8875, 0, 3973, 5, 1 }, // &VDash;
    HTMLEntityTableEntry { 10987, 0, 3978, 4, 1 }, // &Vbar;
    HTMLEntityTableEntry { 1042, 0, 3982, 3, 1 }, // &Vcy;
    HTMLEntityTableEntry { 8873, 0, 3985, 5, 1 }, // &Vdash;
    HTMLEntityTableEntry { 10982, 0, 3985, 6, 1 }, // &Vdashl;
    HTMLEntityTableEntry { 8897, 0, 3991, 3, 1 }, // &Vee;
    HTMLEntityTableEntry { 8214, 0, 3994, 6, 1 }, // &Verbar;
    HTMLEntityTableEntry { 8214, 0, 814, 4, 1 }, // &Vert;
    HTMLEntityTableEntry { 8739, 0, 814, 11, 1 }, // &VerticalBar;
    HTMLEntityTableEntry { 124, 0, 4000, 12, 1 }, // &VerticalLine;
    HTMLEntityTableEntry { 10072, 0, 4012, 17, 1 }, // &VerticalSeparator;
    HTMLEntityTableEntry { 8768, 0, 4029, 13, 1 }, // &VerticalTilde;
    HTMLEntityTableEntry { 8202, 0, 2194, 13, 1 }, // &VeryThinSpace;
    HTMLEntityTableEntry { 120089, 0, 4042, 3, 1 }, // &Vfr;
    HTMLEntityTableEntry { 120141, 0, 4045, 4, 1 }, // &Vopf;
    HTMLEntityTableEntry { 119985, 0, 4049, 4, 1 }, // &Vscr;
    HTMLEntityTableEntry { 8874, 0, 4053, 6, 1 }, // &Vvdash;
    HTMLEntityTableEntry { 372, 0, 4059, 5, 1 }, // &Wcirc;
    HTMLEntityTableEntry { 8896, 0, 4064, 5, 1 }, // &Wedge;
    HTMLEntityTableEntry { 120090, 0, 4069, 3, 1 }, // &Wfr;
    HTMLEntityTableEntry { 120142, 0, 4072, 4, 1 }, // &Wopf;
    HTMLEntityTableEntry { 119986, 0, 4076, 4, 1 }, // &Wscr;
    HTMLEntityTableEntry { 120091, 0, 4080, 3, 1 }, // &Xfr;
    HTMLEntityTableEntry { 926, 0, 4083, 2, 1 }, // &Xi;
    HTMLEntityTableEntry { 120143, 0, 4085, 4, 1 }, // &Xopf;
    HTMLEntityTableEntry { 119987, 0, 4089, 4, 1 }, // &Xscr;
    HTMLEntityTableEntry { 1071, 0, 4093, 4, 1 }, // &YAcy;
    HTMLEntityTableEntry { 1031, 0, 4097, 4, 1 }, // &YIcy;
    HTMLEntityTableEntry { 1070, 0, 4101, 4, 1 }, // &YUcy;
    HTMLEntityTableEntry { 221, 0, 4105, 6, 0 }, // &Yacute
    HTMLEntityTableEntry { 221, 0, 4105, 6, 1 }, // &Yacute;
    HTMLEntityTableEntry { 374, 0, 4111, 5, 1 }, // &Ycirc;
    HTMLEntityTableEntry { 1067, 0, 4116, 3, 1 }, // &Ycy;
    HTMLEntityTableEntry { 120092, 0, 4119, 3, 1 }, // &Yfr;
    HTMLEntityTableEntry { 120144, 0, 4122, 4, 1 }, // &Yopf;
    HTMLEntityTableEntry { 119988, 0, 4126, 4, 1 }, // &Yscr;
    HTMLEntityTableEntry { 376, 0, 4130, 4, 1 }, // &Yuml;
    HTMLEntityTableEntry { 1046, 0, 4134, 4, 1 }, // &ZHcy;
    HTMLEntityTableEntry { 377, 0, 4138, 6, 1 }, // &Zacute;
    HTMLEntityTableEntry { 381, 0, 4144, 6, 1 }, // &Zcaron;
    HTMLEntityTableEntry { 1047, 0, 451, 3, 1 }, // &Zcy;
    HTMLEntityTableEntry { 379, 0, 4150, 4, 1 }, // &Zdot;
    HTMLEntityTableEntry { 8203, 0, 4154, 14, 1 }, // &ZeroWidthSpace;
    HTMLEntityTableEntry { 918, 0, 4168, 4, 1 }, // &Zeta;
    HTMLEntityTableEntry { 8488, 0, 4172, 3, 1 }, // &Zfr;
    HTMLEntityTableEntry { 8484, 0, 4175, 4, 1 }, // &Zopf;
    HTMLEntityTableEntry { 119989, 0, 4179, 4, 1 }, // &Zscr;
    HTMLEntityTableEntry { 225, 0, 4183, 6, 0 }, // &aacute
    HTMLEntityTableEntry { 225, 0, 4183, 6, 1 }, // &aacute;
    HTMLEntityTableEntry { 259, 0, 4189, 6, 1 }, // &abreve;
    HTMLEntityTableEntry { 8766, 0, 9, 2, 1 }, // &ac;
    HTMLEntityTableEntry { 8766, 819, 4195, 3, 1 }, // &acE;
    HTMLEntityTableEntry { 8767, 0, 4198, 3, 1 }, // &acd;
    HTMLEntityTableEntry { 226, 0, 4201, 5, 0 }, // &acirc
    HTMLEntityTableEntry { 226, 0, 4201, 5, 1 }, // &acirc;
    HTMLEntityTableEntry { 180, 0, 9, 5, 0 }, // &acute
    HTMLEntityTableEntry { 180, 0, 9, 5, 1 }, // &acute;
    HTMLEntityTableEntry { 1072, 0, 4206, 3, 1 }, // &acy;
    HTMLEntityTableEntry { 230, 0, 4209, 5, 0 }, // &aelig
    HTMLEntityTableEntry { 230, 0, 4209, 5, 1 }, // &aelig;
    HTMLEntityTableEntry { 8289, 0, 4214, 2, 1 }, // &af;
    HTMLEntityTableEntry { 120094, 0, 4214, 3, 1 }, // &afr;
    HTMLEntityTableEntry { 224, 0, 4217, 6, 0 }, // &agrave
    HTMLEntityTableEntry { 224, 0, 4217, 6, 1 }, // &agrave;
    HTMLEntityTableEntry { 8501, 0, 4223, 7, 1 }, // &alefsym;
    HTMLEntityTableEntry { 8501, 0, 4230, 5, 1 }, // &aleph;
    HTMLEntityTableEntry { 945, 0, 4235, 5, 1 }, // &alpha;
    HTMLEntityTableEntry { 257, 0, 4239, 5, 1 }, // &amacr;
    HTMLEntityTableEntry { 10815, 0, 4244, 5, 1 }, // &amalg;
    HTMLEntityTableEntry { 38, 0, 4249, 3, 0 }, // &amp
    HTMLEntityTableEntry { 38, 0, 4249, 3, 1 }, // &amp;
    HTMLEntityTableEntry { 8743, 0, 4252, 3, 1 }, // &and;
    HTMLEntityTableEntry { 10837, 0, 4252, 6, 1 }, // &andand;
    HTMLEntityTableEntry { 10844, 0, 4255, 4, 1 }, // &andd;
    HTMLEntityTableEntry { 10840, 0, 4259, 8, 1 }, // &andslope;
    HTMLEntityTableEntry { 10842, 0, 4267, 4, 1 }, // &andv;
    HTMLEntityTableEntry { 8736, 0, 1628, 3, 1 }, // &ang;
    HTMLEntityTableEntry { 10660, 0, 4271, 4, 1 }, // &ange;
    HTMLEntityTableEntry { 8736, 0, 1797, 5, 1 }, // &angle;
    HTMLEntityTableEntry { 8737, 0, 4275, 6, 1 }, // &angmsd;
    HTMLEntityTableEntry { 10664, 0, 4275, 8, 1 }, // &angmsdaa;
    HTMLEntityTableEntry { 10665, 0, 4282, 8, 1 }, // &angmsdab;
    HTMLEntityTableEntry { 10666, 0, 4290, 8, 1 }, // &angmsdac;
    HTMLEntityTableEntry { 10667, 0, 4298, 8, 1 }, // &angmsdad;
    HTMLEntityTableEntry { 10668, 0, 4306, 8, 1 }, // &angmsdae;
    HTMLEntityTableEntry { 10669, 0, 4314, 8, 1 }, // &angmsdaf;
    HTMLEntityTableEntry { 10670, 0, 4322, 8, 1 }, // &angmsdag;
    HTMLEntityTableEntry { 10671, 0, 4330, 8, 1 }, // &angmsdah;
    HTMLEntityTableEntry { 8735, 0, 4338, 5, 1 }, // &angrt;
    HTMLEntityTableEntry { 8894, 0, 4338, 7, 1 }, // &angrtvb;
    HTMLEntityTableEntry { 10653, 0, 4338, 8, 1 }, // &angrtvbd;
    HTMLEntityTableEntry { 8738, 0, 4346, 6, 1 }, // &angsph;
    HTMLEntityTableEntry { 197, 0, 4352, 5, 1 }, // &angst;
    HTMLEntityTableEntry { 9084, 0, 4357, 7, 1 }, // &angzarr;
    HTMLEntityTableEntry { 261, 0, 4364, 5, 1 }, // &aogon;
    HTMLEntityTableEntry { 120146, 0, 4369, 4, 1 }, // &aopf;
    HTMLEntityTableEntry { 8776, 0, 177, 2, 1 }, // &ap;
    HTMLEntityTableEntry { 10864, 0, 4373, 3, 1 }, // &apE;
    HTMLEntityTableEntry { 10863, 0, 4376, 6, 1 }, // &apacir;
    HTMLEntityTableEntry { 8778, 0, 4382, 3, 1 }, // &ape;
    HTMLEntityTableEntry { 8779, 0, 4385, 4, 1 }, // &apid;
    HTMLEntityTableEntry { 39, 0, 4389, 4, 1 }, // &apos;
    HTMLEntityTableEntry { 8776, 0, 4393, 6, 1 }, // &approx;
    HTMLEntityTableEntry { 8778, 0, 4393, 8, 1 }, // &approxeq;
    HTMLEntityTableEntry { 229, 0, 4401, 5, 0 }, // &aring
    HTMLEntityTableEntry { 229, 0, 4401, 5, 1 }, // &aring;
    HTMLEntityTableEntry { 119990, 0, 4406, 4, 1 }, // &ascr;
    HTMLEntityTableEntry { 42, 0, 4410, 3, 1 }, // &ast;
    HTMLEntityTableEntry { 8776, 0, 4413, 5, 1 }, // &asymp;
    HTMLEntityTableEntry { 8781, 0, 4413, 7, 1 }, // &asympeq;
    HTMLEntityTableEntry { 227, 0, 4420, 6, 0 }, // &atilde
    HTMLEntityTableEntry { 227, 0, 4420, 6, 1 }, // &atilde;
    HTMLEntityTableEntry { 228, 0, 4426, 4, 0 }, // &auml
    HTMLEntityTableEntry { 228, 0, 4426, 4, 1 }, // &auml;
    HTMLEntityTableEntry { 8755, 0, 4430, 8, 1 }, // &awconint;
    HTMLEntityTableEntry { 10769, 0, 4438, 5, 1 }, // &awint;
    HTMLEntityTableEntry { 10989, 0, 4443, 4, 1 }, // &bNot;
    HTMLEntityTableEntry { 8780, 0, 4447, 8, 1 }, // &backcong;
    HTMLEntityTableEntry { 1014, 0, 4455, 11, 1 }, // &backepsilon;
    HTMLEntityTableEntry { 8245, 0, 4466, 9, 1 }, // &backprime;
    HTMLEntityTableEntry { 8765, 0, 4475, 7, 1 }, // &backsim;
    HTMLEntityTableEntry { 8909, 0, 4475, 9, 1 }, // &backsimeq;
    HTMLEntityTableEntry { 8893, 0, 4484, 6, 1 }, // &barvee;
    HTMLEntityTableEntry { 8965, 0, 4490, 6, 1 }, // &barwed;
    HTMLEntityTableEntry { 8965, 0, 4490, 8, 1 }, // &barwedge;
    HTMLEntityTableEntry { 9141, 0, 4498, 4, 1 }, // &bbrk;
    HTMLEntityTableEntry { 9142, 0, 4498, 8, 1 }, // &bbrktbrk;
    HTMLEntityTableEntry { 8780, 0, 4506, 5, 1 }, // &bcong;
    HTMLEntityTableEntry { 1073, 0, 4511, 3, 1 }, // &bcy;
    HTMLEntityTableEntry { 8222, 0, 4514, 5, 1 }, // &bdquo;
    HTMLEntityTableEntry { 8757, 0, 4519, 6, 1 }, // &becaus;
    HTMLEntityTableEntry { 8757, 0, 4519, 7, 1 }, // &because;
    HTMLEntityTableEntry { 10672, 0, 4526, 7, 1 }, // &bemptyv;
    HTMLEntityTableEntry { 1014, 0, 4533, 5, 1 }, // &bepsi;
    HTMLEntityTableEntry { 8492, 0, 4538, 6, 1 }, // &bernou;
    HTMLEntityTableEntry { 946, 0, 4544, 4, 1 }, // &beta;
    HTMLEntityTableEntry { 8502, 0, 4548, 4, 1 }, // &beth;
    HTMLEntityTableEntry { 8812, 0, 4552, 7, 1 }, // &between;
    HTMLEntityTableEntry { 120095, 0, 4559, 3, 1 }, // &bfr;
    HTMLEntityTableEntry { 8898, 0, 4562, 6, 1 }, // &bigcap;
    HTMLEntityTableEntry { 9711, 0, 4568, 7, 1 }, // &bigcirc;
    HTMLEntityTableEntry { 8899, 0, 4575, 6, 1 }, // &bigcup;
    HTMLEntityTableEntry { 10752, 0, 4581, 7, 1 }, // &bigodot;
    HTMLEntityTableEntry { 10753, 0, 4588, 8, 1 }, // &bigoplus;
    HTMLEntityTableEntry { 10754, 0, 4596, 9, 1 }, // &bigotimes;
    HTMLEntityTableEntry { 10758, 0, 4605, 8, 1 }, // &bigsqcup;
    HTMLEntityTableEntry { 9733, 0, 4613, 7, 1 }, // &bigstar;
    HTMLEntityTableEntry { 9661, 0, 4620, 15, 1 }, // &bigtriangledown;
    HTMLEntityTableEntry { 9651, 0, 4635, 13, 1 }, // &bigtriangleup;
    HTMLEntityTableEntry { 10756, 0, 4648, 8, 1 }, // &biguplus;
    HTMLEntityTableEntry { 8897, 0, 4656, 6, 1 }, // &bigvee;
    HTMLEntityTableEntry { 8896, 0, 4662, 8, 1 }, // &bigwedge;
    HTMLEntityTableEntry { 10509, 0, 4670, 6, 1 }, // &bkarow;
    HTMLEntityTableEntry { 10731, 0, 4676, 12, 1 }, // &blacklozenge;
    HTMLEntityTableEntry { 9642, 0, 4688, 11, 1 }, // &blacksquare;
    HTMLEntityTableEntry { 9652, 0, 4699, 13, 1 }, // &blacktriangle;
    HTMLEntityTableEntry { 9662, 0, 4699, 17, 1 }, // &blacktriangledown;
    HTMLEntityTableEntry { 9666, 0, 4716, 17, 1 }, // &blacktriangleleft;
    HTMLEntityTableEntry { 9656, 0, 4733, 18, 1 }, // &blacktriangleright;
    HTMLEntityTableEntry { 9251, 0, 4751, 5, 1 }, // &blank;
    HTMLEntityTableEntry { 9618, 0, 4756, 5, 1 }, // &blk12;
    HTMLEntityTableEntry { 9617, 0, 4761, 5, 1 }, // &blk14;
    HTMLEntityTableEntry { 9619, 0, 4766, 5, 1 }, // &blk34;
    HTMLEntityTableEntry { 9608, 0, 4771, 5, 1 }, // &block;
    HTMLEntityTableEntry { 61, 8421, 4776, 3, 1 }, // &bne;
    HTMLEntityTableEntry { 8801, 8421, 4776, 7, 1 }, // &bnequiv;
    HTMLEntityTableEntry { 8976, 0, 4783, 4, 1 }, // &bnot;
    HTMLEntityTableEntry { 120147, 0, 4787, 4, 1 }, // &bopf;
    HTMLEntityTableEntry { 8869, 0, 4791, 3, 1 }, // &bot;
    HTMLEntityTableEntry { 8869, 0, 4791, 6, 1 }, // &bottom;
    HTMLEntityTableEntry { 8904, 0, 4797, 6, 1 }, // &bowtie;
    HTMLEntityTableEntry { 9559, 0, 4803, 5, 1 }, // &boxDL;
    HTMLEntityTableEntry { 9556, 0, 4808, 5, 1 }, // &boxDR;
    HTMLEntityTableEntry { 9558, 0, 4813, 5, 1 }, // &boxDl;
    HTMLEntityTableEntry { 9555, 0, 4818, 5, 1 }, // &boxDr;
    HTMLEntityTableEntry { 9552, 0, 4823, 4, 1 }, // &boxH;
    HTMLEntityTableEntry { 9574, 0, 4823, 5, 1 }, // &boxHD;
    HTMLEntityTableEntry { 9577, 0, 4828, 5, 1 }, // &boxHU;
    HTMLEntityTableEntry { 9572, 0, 4833, 5, 1 }, // &boxHd;
    HTMLEntityTableEntry { 9575, 0, 4838, 5, 1 }, // &boxHu;
    HTMLEntityTableEntry { 9565, 0, 4843, 5, 1 }, // &boxUL;
    HTMLEntityTableEntry { 9562, 0, 4848, 5, 1 }, // &boxUR;
    HTMLEntityTableEntry { 9564, 0, 4853, 5, 1 }, // &boxUl;
    HTMLEntityTableEntry { 9561, 0, 4858, 5, 1 }, // &boxUr;
    HTMLEntityTableEntry { 9553, 0, 4863, 4, 1 }, // &boxV;
    HTMLEntityTableEntry { 9580, 0, 4863, 5, 1 }, // &boxVH;
    HTMLEntityTableEntry { 9571, 0, 4868, 5, 1 }, // &boxVL;
    HTMLEntityTableEntry { 9568, 0, 4873, 5, 1 }, // &boxVR;
    HTMLEntityTableEntry { 9579, 0, 4878, 5, 1 }, // &boxVh;
    HTMLEntityTableEntry { 9570, 0, 4883, 5, 1 }, // &boxVl;
    HTMLEntityTableEntry { 9567, 0, 4888, 5, 1 }, // &boxVr;
    HTMLEntityTableEntry { 10697, 0, 4893, 6, 1 }, // &boxbox;
    HTMLEntityTableEntry { 9557, 0, 4896, 5, 1 }, // &boxdL;
    HTMLEntityTableEntry { 9554, 0, 4901, 5, 1 }, // &boxdR;
    HTMLEntityTableEntry { 9488, 0, 4906, 5, 1 }, // &boxdl;
    HTMLEntityTableEntry { 9484, 0, 4911, 5, 1 }, // &boxdr;
    HTMLEntityTableEntry { 9472, 0, 4916, 4, 1 }, // &boxh;
    HTMLEntityTableEntry { 9573, 0, 4916, 5, 1 }, // &boxhD;
    HTMLEntityTableEntry { 9576, 0, 4921, 5, 1 }, // &boxhU;
    HTMLEntityTableEntry { 9516, 0, 4926, 5, 1 }, // &boxhd;
    HTMLEntityTableEntry { 9524, 0, 4931, 5, 1 }, // &boxhu;
    HTMLEntityTableEntry { 8863, 0, 4936, 8, 1 }, // &boxminus;
    HTMLEntityTableEntry { 8862, 0, 4944, 7, 1 }, // &boxplus;
    HTMLEntityTableEntry { 8864, 0, 4951, 8, 1 }, // &boxtimes;
    HTMLEntityTableEntry { 9563, 0, 4959, 5, 1 }, // &boxuL;
    HTMLEntityTableEntry { 9560, 0, 4964, 5, 1 }, // &boxuR;
    HTMLEntityTableEntry { 9496, 0, 4969, 5, 1 }, // &boxul;
    HTMLEntityTableEntry { 9492, 0, 4974, 5, 1 }, // &boxur;
    HTMLEntityTableEntry { 9474, 0, 4979, 4, 1 }, // &boxv;
    HTMLEntityTableEntry { 9578, 0, 4979, 5, 1 }, // &boxvH;
    HTMLEntityTableEntry { 9569, 0, 4984, 5, 1 }, // &boxvL;
    HTMLEntityTableEntry { 9566, 0, 4989, 5, 1 }, // &boxvR;
    HTMLEntityTableEntry { 9532, 0, 4994, 5, 1 }, // &boxvh;
    HTMLEntityTableEntry { 9508, 0, 4999, 5, 1 }, // &boxvl;
    HTMLEntityTableEntry { 9500, 0, 5004, 5, 1 }, // &boxvr;
    HTMLEntityTableEntry { 8245, 0, 5009, 6, 1 }, // &bprime;
    HTMLEntityTableEntry { 728, 0, 15, 5, 1 }, // &breve;
    HTMLEntityTableEntry { 166, 0, 5015, 6, 0 }, // &brvbar
    HTMLEntityTableEntry { 166, 0, 5015, 6, 1 }, // &brvbar;
    HTMLEntityTableEntry { 119991, 0, 5021, 4, 1 }, // &bscr;
    HTMLEntityTableEntry { 8271, 0, 5025, 5, 1 }, // &bsemi;
    HTMLEntityTableEntry { 8765, 0, 5030, 4, 1 }, // &bsim;
    HTMLEntityTableEntry { 8909, 0, 5030, 5, 1 }, // &bsime;
    HTMLEntityTableEntry { 92, 0, 5035, 4, 1 }, // &bsol;
    HTMLEntityTableEntry { 10693, 0, 5035, 5, 1 }, // &bsolb;
    HTMLEntityTableEntry { 10184, 0, 5039, 8, 1 }, // &bsolhsub;
    HTMLEntityTableEntry { 8226, 0, 5046, 4, 1 }, // &bull;
    HTMLEntityTableEntry { 8226, 0, 5046, 6, 1 }, // &bullet;
    HTMLEntityTableEntry { 8782, 0, 5052, 4, 1 }, // &bump;
    HTMLEntityTableEntry { 10926, 0, 5052, 5, 1 }, // &bumpE;
    HTMLEntityTableEntry { 8783, 0, 5057, 5, 1 }, // &bumpe;
    HTMLEntityTableEntry { 8783, 0, 5057, 6, 1 }, // &bumpeq;
    HTMLEntityTableEntry { 263, 0, 5063, 6, 1 }, // &cacute;
    HTMLEntityTableEntry { 8745, 0, 4565, 3, 1 }, // &cap;
    HTMLEntityTableEntry { 10820, 0, 5069, 6, 1 }, // &capand;
    HTMLEntityTableEntry { 10825, 0, 5075, 8, 1 }, // &capbrcup;
    HTMLEntityTableEntry { 10827, 0, 5083, 6, 1 }, // &capcap;
    HTMLEntityTableEntry { 10823, 0, 5086, 6, 1 }, // &capcup;
    HTMLEntityTableEntry { 10816, 0, 5092, 6, 1 }, // &capdot;
    HTMLEntityTableEntry { 8745, 65024, 5098, 4, 1 }, // &caps;
    HTMLEntityTableEntry { 8257, 0, 5102, 5, 1 }, // &caret;
    HTMLEntityTableEntry { 711, 0, 204, 5, 1 }, // &caron;
    HTMLEntityTableEntry { 10829, 0, 5107, 5, 1 }, // &ccaps;
    HTMLEntityTableEntry { 269, 0, 5112, 6, 1 }, // &ccaron;
    HTMLEntityTableEntry { 231, 0, 5118, 6, 0 }, // &ccedil
    HTMLEntityTableEntry { 231, 0, 5118, 6, 1 }, // &ccedil;
    HTMLEntityTableEntry { 265, 0, 5124, 5, 1 }, // &ccirc;
    HTMLEntityTableEntry { 10828, 0, 5128, 5, 1 }, // &ccups;
    HTMLEntityTableEntry { 10832, 0, 5128, 7, 1 }, // &ccupssm;
    HTMLEntityTableEntry { 267, 0, 5135, 4, 1 }, // &cdot;
    HTMLEntityTableEntry { 184, 0, 210, 5, 0 }, // &cedil
    HTMLEntityTableEntry { 184, 0, 210, 5, 1 }, // &cedil;
    HTMLEntityTableEntry { 10674, 0, 5139, 7, 1 }, // &cemptyv;
    HTMLEntityTableEntry { 162, 0, 5146, 4, 0 }, // &cent
    HTMLEntityTableEntry { 162, 0, 5146, 4, 1 }, // &cent;
    HTMLEntityTableEntry { 183, 0, 5146, 9, 1 }, // &centerdot;
    HTMLEntityTableEntry { 120096, 0, 5155, 3, 1 }, // &cfr;
    HTMLEntityTableEntry { 1095, 0, 5158, 4, 1 }, // &chcy;
    HTMLEntityTableEntry { 10003, 0, 5162, 5, 1 }, // &check;
    HTMLEntityTableEntry { 10003, 0, 5162, 9, 1 }, // &checkmark;
    HTMLEntityTableEntry { 967, 0, 5171, 3, 1 }, // &chi;
    HTMLEntityTableEntry { 9675, 0, 21, 3, 1 }, // &cir;
    HTMLEntityTableEntry { 10691, 0, 5174, 4, 1 }, // &cirE;
    HTMLEntityTableEntry { 710, 0, 21, 4, 1 }, // &circ;
    HTMLEntityTableEntry { 8791, 0, 5178, 6, 1 }, // &circeq;
    HTMLEntityTableEntry { 8634, 0, 5184, 15, 1 }, // &circlearrowleft;
    HTMLEntityTableEntry { 8635, 0, 5199, 16, 1 }, // &circlearrowright;
    HTMLEntityTableEntry { 174, 0, 5215, 8, 1 }, // &circledR;
    HTMLEntityTableEntry { 9416, 0, 5223, 8, 1 }, // &circledS;
    HTMLEntityTableEntry { 8859, 0, 5231, 10, 1 }, // &circledast;
    HTMLEntityTableEntry { 8858, 0, 5241, 11, 1 }, // &circledcirc;
    HTMLEntityTableEntry { 8861, 0, 5248, 11, 1 }, // &circleddash;
    HTMLEntityTableEntry { 8791, 0, 5259, 4, 1 }, // &cire;
    HTMLEntityTableEntry { 10768, 0, 5263, 8, 1 }, // &cirfnint;
    HTMLEntityTableEntry { 10991, 0, 5271, 6, 1 }, // &cirmid;
    HTMLEntityTableEntry { 10690, 0, 5277, 7, 1 }, // &cirscir;
    HTMLEntityTableEntry { 9827, 0, 5284, 5, 1 }, // &clubs;
    HTMLEntityTableEntry { 9827, 0, 5284, 8, 1 }, // &clubsuit;
    HTMLEntityTableEntry { 58, 0, 5292, 5, 1 }, // &colon;
    HTMLEntityTableEntry { 8788, 0, 5292, 6, 1 }, // &colone;
    HTMLEntityTableEntry { 8788, 0, 5292, 7, 1 }, // &coloneq;
    HTMLEntityTableEntry { 44, 0, 5299, 5, 1 }, // &comma;
    HTMLEntityTableEntry { 64, 0, 5299, 6, 1 }, // &commat;
    HTMLEntityTableEntry { 8705, 0, 5305, 4, 1 }, // &comp;
    HTMLEntityTableEntry { 8728, 0, 5305, 6, 1 }, // &compfn;
    HTMLEntityTableEntry { 8705, 0, 5311, 10, 1 }, // &complement;
    HTMLEntityTableEntry { 8450, 0, 5321, 9, 1 }, // &complexes;
    HTMLEntityTableEntry { 8773, 0, 4451, 4, 1 }, // &cong;
    HTMLEntityTableEntry { 10861, 0, 5330, 7, 1 }, // &congdot;
    HTMLEntityTableEntry { 8750, 0, 221, 6, 1 }, // &conint;
    HTMLEntityTableEntry { 120148, 0, 5337, 4, 1 }, // &copf;
    HTMLEntityTableEntry { 8720, 0, 5341, 6, 1 }, // &coprod;
    HTMLEntityTableEntry { 169, 0, 5347, 4, 0 }, // &copy
    HTMLEntityTableEntry { 169, 0, 5347, 4, 1 }, // &copy;
    HTMLEntityTableEntry { 8471, 0, 5347, 6, 1 }, // &copysr;
    HTMLEntityTableEntry { 8629, 0, 5353, 5, 1 }, // &crarr;
    HTMLEntityTableEntry { 10007, 0, 5358, 5, 1 }, // &cross;
    HTMLEntityTableEntry { 119992, 0, 5363, 4, 1 }, // &cscr;
    HTMLEntityTableEntry { 10959, 0, 5367, 4, 1 }, // &csub;
    HTMLEntityTableEntry { 10961, 0, 5367, 5, 1 }, // &csube;
    HTMLEntityTableEntry { 10960, 0, 5372, 4, 1 }, // &csup;
    HTMLEntityTableEntry { 10962, 0, 5372, 5, 1 }, // &csupe;
    HTMLEntityTableEntry { 8943, 0, 5377, 5, 1 }, // &ctdot;
    HTMLEntityTableEntry { 10552, 0, 5382, 7, 1 }, // &cudarrl;
    HTMLEntityTableEntry { 10549, 0, 5389, 7, 1 }, // &cudarrr;
    HTMLEntityTableEntry { 8926, 0, 5396, 5, 1 }, // &cuepr;
    HTMLEntityTableEntry { 8927, 0, 5401, 5, 1 }, // &cuesc;
    HTMLEntityTableEntry { 8630, 0, 5405, 6, 1 }, // &cularr;
    HTMLEntityTableEntry { 10557, 0, 5405, 7, 1 }, // &cularrp;
    HTMLEntityTableEntry { 8746, 0, 4578, 3, 1 }, // &cup;
    HTMLEntityTableEntry { 10824, 0, 5412, 8, 1 }, // &cupbrcap;
    HTMLEntityTableEntry { 10822, 0, 5080, 6, 1 }, // &cupcap;
    HTMLEntityTableEntry { 10826, 0, 5420, 6, 1 }, // &cupcup;
    HTMLEntityTableEntry { 8845, 0, 5423, 6, 1 }, // &cupdot;
    HTMLEntityTableEntry { 10821, 0, 5429, 5, 1 }, // &cupor;
    HTMLEntityTableEntry { 8746, 65024, 5129, 4, 1 }, // &cups;
    HTMLEntityTableEntry { 8631, 0, 5434, 6, 1 }, // &curarr;
    HTMLEntityTableEntry { 10556, 0, 5434, 7, 1 }, // &curarrm;
    HTMLEntityTableEntry { 8926, 0, 5441, 11, 1 }, // &curlyeqprec;
    HTMLEntityTableEntry { 8927, 0, 5451, 11, 1 }, // &curlyeqsucc;
    HTMLEntityTableEntry { 8910, 0, 5461, 8, 1 }, // &curlyvee;
    HTMLEntityTableEntry { 8911, 0, 5469, 10, 1 }, // &curlywedge;
    HTMLEntityTableEntry { 164, 0, 5479, 6, 0 }, // &curren
    HTMLEntityTableEntry { 164, 0, 5479, 6, 1 }, // &curren;
    HTMLEntityTableEntry { 8630, 0, 5485, 14, 1 }, // &curvearrowleft;
    HTMLEntityTableEntry { 8631, 0, 5499, 15, 1 }, // &curvearrowright;
    HTMLEntityTableEntry { 8910, 0, 5514, 5, 1 }, // &cuvee;
    HTMLEntityTableEntry { 8911, 0, 5519, 5, 1 }, // &cuwed;
    HTMLEntityTableEntry { 8754, 0, 5524, 8, 1 }, // &cwconint;
    HTMLEntityTableEntry { 8753, 0, 5532, 5, 1 }, // &cwint;
    HTMLEntityTableEntry { 9005, 0, 5537, 6, 1 }, // &cylcty;
    HTMLEntityTableEntry { 8659, 0, 5543, 4, 1 }, // &dArr;
    HTMLEntityTableEntry { 10597, 0, 5547, 4, 1 }, // &dHar;
    HTMLEntityTableEntry { 8224, 0, 5551, 6, 1 }, // &dagger;
    HTMLEntityTableEntry { 8504, 0, 5557, 6, 1 }, // &daleth;
    HTMLEntityTableEntry { 8595, 0, 5384, 4, 1 }, // &darr;
    HTMLEntityTableEntry { 8208, 0, 3986, 4, 1 }, // &dash;
    HTMLEntityTableEntry { 8867, 0, 5563, 5, 1 }, // &dashv;
    HTMLEntityTableEntry { 10511, 0, 5568, 7, 1 }, // &dbkarow;
    HTMLEntityTableEntry { 733, 0, 2927, 5, 1 }, // &dblac;
    HTMLEntityTableEntry { 271, 0, 5575, 6, 1 }, // &dcaron;
    HTMLEntityTableEntry { 1076, 0, 5581, 3, 1 }, // &dcy;
    HTMLEntityTableEntry { 8518, 0, 4257, 2, 1 }, // &dd;
    HTMLEntityTableEntry { 8225, 0, 5584, 7, 1 }, // &ddagger;
    HTMLEntityTableEntry { 8650, 0, 5591, 5, 1 }, // &ddarr;
    HTMLEntityTableEntry { 10871, 0, 5596, 7, 1 }, // &ddotseq;
    HTMLEntityTableEntry { 176, 0, 5603, 3, 0 }, // &deg
    HTMLEntityTableEntry { 176, 0, 5603, 3, 1 }, // &deg;
    HTMLEntityTableEntry { 948, 0, 5606, 5, 1 }, // &delta;
    HTMLEntityTableEntry { 10673, 0, 5611, 7, 1 }, // &demptyv;
    HTMLEntityTableEntry { 10623, 0, 5618, 6, 1 }, // &dfisht;
    HTMLEntityTableEntry { 120097, 0, 5624, 3, 1 }, // &dfr;
    HTMLEntityTableEntry { 8643, 0, 5627, 5, 1 }, // &dharl;
    HTMLEntityTableEntry { 8642, 0, 5632, 5, 1 }, // &dharr;
    HTMLEntityTableEntry { 8900, 0, 5637, 4, 1 }, // &diam;
    HTMLEntityTableEntry { 8900, 0, 5637, 7, 1 }, // &diamond;
    HTMLEntityTableEntry { 9830, 0, 5637, 11, 1 }, // &diamondsuit;
    HTMLEntityTableEntry { 9830, 0, 5648, 5, 1 }, // &diams;
    HTMLEntityTableEntry { 168, 0, 5653, 3, 1 }, // &die;
    HTMLEntityTableEntry { 989, 0, 5656, 7, 1 }, // &digamma;
    HTMLEntityTableEntry { 8946, 0, 5663, 5, 1 }, // &disin;
    HTMLEntityTableEntry { 247, 0, 5668, 3, 1 }, // &div;
    HTMLEntityTableEntry { 247, 0, 5668, 6, 0 }, // &divide
    HTMLEntityTableEntry { 247, 0, 5668, 6, 1 }, // &divide;
    HTMLEntityTableEntry { 8903, 0, 5668, 13, 1 }, // &divideontimes;
    HTMLEntityTableEntry { 8903, 0, 5681, 6, 1 }, // &divonx;
    HTMLEntityTableEntry { 1106, 0, 5687, 4, 1 }, // &djcy;
    HTMLEntityTableEntry { 8990, 0, 5691, 6, 1 }, // &dlcorn;
    HTMLEntityTableEntry { 8973, 0, 5697, 6, 1 }, // &dlcrop;
    HTMLEntityTableEntry { 36, 0, 5703, 6, 1 }, // &dollar;
    HTMLEntityTableEntry { 120149, 0, 5709, 4, 1 }, // &dopf;
    HTMLEntityTableEntry { 729, 0, 228, 3, 1 }, // &dot;
    HTMLEntityTableEntry { 8784, 0, 5713, 5, 1 }, // &doteq;
    HTMLEntityTableEntry { 8785, 0, 5713, 8, 1 }, // &doteqdot;
    HTMLEntityTableEntry { 8760, 0, 5718, 8, 1 }, // &dotminus;
    HTMLEntityTableEntry { 8724, 0, 5726, 7, 1 }, // &dotplus;
    HTMLEntityTableEntry { 8865, 0, 5733, 9, 1 }, // &dotsquare;
    HTMLEntityTableEntry { 8966, 0, 5742, 14, 1 }, // &doublebarwedge;
    HTMLEntityTableEntry { 8595, 0, 3909, 9, 1 }, // &downarrow;
    HTMLEntityTableEntry { 8650, 0, 5756, 14, 1 }, // &downdownarrows;
    HTMLEntityTableEntry { 8643, 0, 5770, 15, 1 }, // &downharpoonleft;
    HTMLEntityTableEntry { 8642, 0, 5785, 16, 1 }, // &downharpoonright;
    HTMLEntityTableEntry { 10512, 0, 5801, 8, 1 }, // &drbkarow;
    HTMLEntityTableEntry { 8991, 0, 5809, 6, 1 }, // &drcorn;
    HTMLEntityTableEntry { 8972, 0, 5815, 6, 1 }, // &drcrop;
    HTMLEntityTableEntry { 119993, 0, 5821, 4, 1 }, // &dscr;
    HTMLEntityTableEntry { 1109, 0, 5825, 4, 1 }, // &dscy;
    HTMLEntityTableEntry { 10742, 0, 5829, 4, 1 }, // &dsol;
    HTMLEntityTableEntry { 273, 0, 5833, 6, 1 }, // &dstrok;
    HTMLEntityTableEntry { 8945, 0, 5839, 5, 1 }, // &dtdot;
    HTMLEntityTableEntry { 9663, 0, 5844, 4, 1 }, // &dtri;
    HTMLEntityTableEntry { 9662, 0, 5844, 5, 1 }, // &dtrif;
    HTMLEntityTableEntry { 8693, 0, 5849, 5, 1 }, // &duarr;
    HTMLEntityTableEntry { 10607, 0, 5854, 5, 1 }, // &duhar;
    HTMLEntityTableEntry { 10662, 0, 5859, 7, 1 }, // &dwangle;
    HTMLEntityTableEntry { 1119, 0, 5866, 4, 1 }, // &dzcy;
    HTMLEntityTableEntry { 10239, 0, 5870, 8, 1 }, // &dzigrarr;
    HTMLEntityTableEntry { 10871, 0, 5878, 5, 1 }, // &eDDot;
    HTMLEntityTableEntry { 8785, 0, 258, 4, 1 }, // &eDot;
    HTMLEntityTableEntry { 233, 0, 5883, 6, 0 }, // &eacute
    HTMLEntityTableEntry { 233, 0, 5883, 6, 1 }, // &eacute;
    HTMLEntityTableEntry { 10862, 0, 5888, 6, 1 }, // &easter;
    HTMLEntityTableEntry { 283, 0, 5894, 6, 1 }, // &ecaron;
    HTMLEntityTableEntry { 8790, 0, 5262, 4, 1 }, // &ecir;
    HTMLEntityTableEntry { 234, 0, 5900, 5, 0 }, // &ecirc
    HTMLEntityTableEntry { 234, 0, 5900, 5, 1 }, // &ecirc;
    HTMLEntityTableEntry { 8789, 0, 5905, 6, 1 }, // &ecolon;
    HTMLEntityTableEntry { 1101, 0, 5911, 3, 1 }, // &ecy;
    HTMLEntityTableEntry { 279, 0, 5914, 4, 1 }, // &edot;
    HTMLEntityTableEntry { 8519, 0, 683, 2, 1 }, // &ee;
    HTMLEntityTableEntry { 8786, 0, 5918, 5, 1 }, // &efDot;
    HTMLEntityTableEntry { 120098, 0, 5923, 3, 1 }, // &efr;
    HTMLEntityTableEntry { 10906, 0, 313, 2, 1 }, // &eg;
    HTMLEntityTableEntry { 232, 0, 5926, 6, 0 }, // &egrave
    HTMLEntityTableEntry { 232, 0, 5926, 6, 1 }, // &egrave;
    HTMLEntityTableEntry { 10902, 0, 5931, 3, 1 }, // &egs;
    HTMLEntityTableEntry { 10904, 0, 5931, 6, 1 }, // &egsdot;
    HTMLEntityTableEntry { 10905, 0, 479, 2, 1 }, // &el;
    HTMLEntityTableEntry { 9191, 0, 5937, 8, 1 }, // &elinters;
    HTMLEntityTableEntry { 8467, 0, 2077, 3, 1 }, // &ell;
    HTMLEntityTableEntry { 10901, 0, 5945, 3, 1 }, // &els;
    HTMLEntityTableEntry { 10903, 0, 5945, 6, 1 }, // &elsdot;
    HTMLEntityTableEntry { 275, 0, 5951, 5, 1 }, // &emacr;
    HTMLEntityTableEntry { 8709, 0, 4527, 5, 1 }, // &empty;
    HTMLEntityTableEntry { 8709, 0, 5956, 8, 1 }, // &emptyset;
    HTMLEntityTableEntry { 8709, 0, 4527, 6, 1 }, // &emptyv;
    HTMLEntityTableEntry { 8196, 0, 5964, 6, 1 }, // &emsp13;
    HTMLEntityTableEntry { 8197, 0, 5970, 6, 1 }, // &emsp14;
    HTMLEntityTableEntry { 8195, 0, 5964, 4, 1 }, // &emsp;
    HTMLEntityTableEntry { 331, 0, 4684, 3, 1 }, // &eng;
    HTMLEntityTableEntry { 8194, 0, 5976, 4, 1 }, // &ensp;
    HTMLEntityTableEntry { 281, 0, 5980, 5, 1 }, // &eogon;
    HTMLEntityTableEntry { 120150, 0, 5985, 4, 1 }, // &eopf;
    HTMLEntityTableEntry { 8917, 0, 4021, 4, 1 }, // &epar;
    HTMLEntityTableEntry { 10723, 0, 5989, 6, 1 }, // &eparsl;
    HTMLEntityTableEntry { 10865, 0, 5995, 5, 1 }, // &eplus;
    HTMLEntityTableEntry { 949, 0, 4459, 4, 1 }, // &epsi;
    HTMLEntityTableEntry { 949, 0, 4459, 7, 1 }, // &epsilon;
    HTMLEntityTableEntry { 1013, 0, 6000, 5, 1 }, // &epsiv;
    HTMLEntityTableEntry { 8790, 0, 5182, 6, 1 }, // &eqcirc;
    HTMLEntityTableEntry { 8789, 0, 6005, 7, 1 }, // &eqcolon;
    HTMLEntityTableEntry { 8770, 0, 6012, 5, 1 }, // &eqsim;
    HTMLEntityTableEntry { 10902, 0, 6017, 10, 1 }, // &eqslantgtr;
    HTMLEntityTableEntry { 10901, 0, 6027, 11, 1 }, // &eqslantless;
    HTMLEntityTableEntry { 61, 0, 6038, 6, 1 }, // &equals;
    HTMLEntityTableEntry { 8799, 0, 6044, 6, 1 }, // &equest;
    HTMLEntityTableEntry { 8801, 0, 4778, 5, 1 }, // &equiv;
    HTMLEntityTableEntry { 10872, 0, 6050, 7, 1 }, // &equivDD;
    HTMLEntityTableEntry { 10725, 0, 6057, 8, 1 }, // &eqvparsl;
    HTMLEntityTableEntry { 8787, 0, 242, 5, 1 }, // &erDot;
    HTMLEntityTableEntry { 10609, 0, 6065, 5, 1 }, // &erarr;
    HTMLEntityTableEntry { 8495, 0, 6070, 4, 1 }, // &escr;
    HTMLEntityTableEntry { 8784, 0, 6074, 5, 1 }, // &esdot;
    HTMLEntityTableEntry { 8770, 0, 6079, 4, 1 }, // &esim;
    HTMLEntityTableEntry { 951, 0, 137, 3, 1 }, // &eta;
    HTMLEntityTableEntry { 240, 0, 4549, 3, 0 }, // &eth
    HTMLEntityTableEntry { 240, 0, 4549, 3, 1 }, // &eth;
    HTMLEntityTableEntry { 235, 0, 6083, 4, 0 }, // &euml
    HTMLEntityTableEntry { 235, 0, 6083, 4, 1 }, // &euml;
    HTMLEntityTableEntry { 8364, 0, 6087, 4, 1 }, // &euro;
    HTMLEntityTableEntry { 33, 0, 6091, 4, 1 }, // &excl;
    HTMLEntityTableEntry { 8707, 0, 6095, 5, 1 }, // &exist;
    HTMLEntityTableEntry { 8496, 0, 6100, 11, 1 }, // &expectation;
    HTMLEntityTableEntry { 8519, 0, 6111, 12, 1 }, // &exponentiale;
    HTMLEntityTableEntry { 8786, 0, 6123, 13, 1 }, // &fallingdotseq;
    HTMLEntityTableEntry { 1092, 0, 6136, 3, 1 }, // &fcy;
    HTMLEntityTableEntry { 9792, 0, 6139, 6, 1 }, // &female;
    HTMLEntityTableEntry { 64259, 0, 6145, 6, 1 }, // &ffilig;
    HTMLEntityTableEntry { 64256, 0, 6151, 5, 1 }, // &fflig;
    HTMLEntityTableEntry { 64260, 0, 6156, 6, 1 }, // &ffllig;
    HTMLEntityTableEntry { 120099, 0, 6162, 3, 1 }, // &ffr;
    HTMLEntityTableEntry { 64257, 0, 6146, 5, 1 }, // &filig;
    HTMLEntityTableEntry { 102, 106, 6165, 5, 1 }, // &fjlig;
    HTMLEntityTableEntry { 9837, 0, 6170, 4, 1 }, // &flat;
    HTMLEntityTableEntry { 64258, 0, 6157, 5, 1 }, // &fllig;
    HTMLEntityTableEntry { 9649, 0, 6174, 5, 1 }, // &fltns;
    HTMLEntityTableEntry { 402, 0, 6179, 4, 1 }, // &fnof;
    HTMLEntityTableEntry { 120151, 0, 6182, 4, 1 }, // &fopf;
    HTMLEntityTableEntry { 8704, 0, 6185, 6, 1 }, // &forall;
    HTMLEntityTableEntry { 8916, 0, 6191, 4, 1 }, // &fork;
    HTMLEntityTableEntry { 10969, 0, 6191, 5, 1 }, // &forkv;
    HTMLEntityTableEntry { 10765, 0, 6196, 8, 1 }, // &fpartint;
    HTMLEntityTableEntry { 189, 0, 6204, 6, 0 }, // &frac12
    HTMLEntityTableEntry { 189, 0, 6204, 6, 1 }, // &frac12;
    HTMLEntityTableEntry { 8531, 0, 6210, 6, 1 }, // &frac13;
    HTMLEntityTableEntry { 188, 0, 6216, 6, 0 }, // &frac14
    HTMLEntityTableEntry { 188, 0, 6216, 6, 1 }, // &frac14;
    HTMLEntityTableEntry { 8533, 0, 6222, 6, 1 }, // &frac15;
    HTMLEntityTableEntry { 8537, 0, 6228, 6, 1 }, // &frac16;
    HTMLEntityTableEntry { 8539, 0, 6234, 6, 1 }, // &frac18;
    HTMLEntityTableEntry { 8532, 0, 6240, 6, 1 }, // &frac23;
    HTMLEntityTableEntry { 8534, 0, 6246, 6, 1 }, // &frac25;
    HTMLEntityTableEntry { 190, 0, 6252, 6, 0 }, // &frac34
    HTMLEntityTableEntry { 190, 0, 6252, 6, 1 }, // &frac34;
    HTMLEntityTableEntry { 8535, 0, 6258, 6, 1 }, // &frac35;
    HTMLEntityTableEntry { 8540, 0, 6264, 6, 1 }, // &frac38;
    HTMLEntityTableEntry { 8536, 0, 6270, 6, 1 }, // &frac45;
    HTMLEntityTableEntry { 8538, 0, 6276, 6, 1 }, // &frac56;
    HTMLEntityTableEntry { 8541, 0, 6282, 6, 1 }, // &frac58;
    HTMLEntityTableEntry { 8542, 0, 6288, 6, 1 }, // &frac78;
    HTMLEntityTableEntry { 8260, 0, 6294, 5, 1 }, // &frasl;
    HTMLEntityTableEntry { 8994, 0, 6299, 5, 1 }, // &frown;
    HTMLEntityTableEntry { 119995, 0, 6304, 4, 1 }, // &fscr;
    HTMLEntityTableEntry { 8807, 0, 6308, 2, 1 }, // &gE;
    HTMLEntityTableEntry { 10892, 0, 6308, 3, 1 }, // &gEl;
    HTMLEntityTableEntry { 501, 0, 6311, 6, 1 }, // &gacute;
    HTMLEntityTableEntry { 947, 0, 5658, 5, 1 }, // &gamma;
    HTMLEntityTableEntry { 989, 0, 5658, 6, 1 }, // &gammad;
    HTMLEntityTableEntry { 10886, 0, 6317, 3, 1 }, // &gap;
    HTMLEntityTableEntry { 287, 0, 6320, 6, 1 }, // &gbreve;
    HTMLEntityTableEntry { 285, 0, 4570, 5, 1 }, // &gcirc;
    HTMLEntityTableEntry { 1075, 0, 6326, 3, 1 }, // &gcy;
    HTMLEntityTableEntry { 289, 0, 5333, 4, 1 }, // &gdot;
    HTMLEntityTableEntry { 8805, 0, 457, 2, 1 }, // &ge;
    HTMLEntityTableEntry { 8923, 0, 6329, 3, 1 }, // &gel;
    HTMLEntityTableEntry { 8805, 0, 6332, 3, 1 }, // &geq;
    HTMLEntityTableEntry { 8807, 0, 6332, 4, 1 }, // &geqq;
    HTMLEntityTableEntry { 10878, 0, 6336, 8, 1 }, // &geqslant;
    HTMLEntityTableEntry { 10878, 0, 6344, 3, 1 }, // &ges;
    HTMLEntityTableEntry { 10921, 0, 6344, 5, 1 }, // &gescc;
    HTMLEntityTableEntry { 10880, 0, 6349, 6, 1 }, // &gesdot;
    HTMLEntityTableEntry { 10882, 0, 6349, 7, 1 }, // &gesdoto;
    HTMLEntityTableEntry { 10884, 0, 6349, 8, 1 }, // &gesdotol;
    HTMLEntityTableEntry { 8923, 65024, 6357, 4, 1 }, // &gesl;
    HTMLEntityTableEntry { 10900, 0, 6357, 6, 1 }, // &gesles;
    HTMLEntityTableEntry { 120100, 0, 6363, 3, 1 }, // &gfr;
    HTMLEntityTableEntry { 8811, 0, 456, 2, 1 }, // &gg;
    HTMLEntityTableEntry { 8921, 0, 6366, 3, 1 }, // &ggg;
    HTMLEntityTableEntry { 8503, 0, 6368, 5, 1 }, // &gimel;
    HTMLEntityTableEntry { 1107, 0, 6373, 4, 1 }, // &gjcy;
    HTMLEntityTableEntry { 8823, 0, 1666, 2, 1 }, // &gl;
    HTMLEntityTableEntry { 10898, 0, 6377, 3, 1 }, // &glE;
    HTMLEntityTableEntry { 10917, 0, 6380, 3, 1 }, // &gla;
    HTMLEntityTableEntry { 10916, 0, 6383, 3, 1 }, // &glj;
    HTMLEntityTableEntry { 8809, 0, 6386, 3, 1 }, // &gnE;
    HTMLEntityTableEntry { 10890, 0, 6389, 4, 1 }, // &gnap;
    HTMLEntityTableEntry { 10890, 0, 6389, 8, 1 }, // &gnapprox;
    HTMLEntityTableEntry { 10888, 0, 6397, 3, 1 }, // &gne;
    HTMLEntityTableEntry { 10888, 0, 6397, 4, 1 }, // &gneq;
    HTMLEntityTableEntry { 8809, 0, 6397, 5, 1 }, // &gneqq;
    HTMLEntityTableEntry { 8935, 0, 6402, 5, 1 }, // &gnsim;
    HTMLEntityTableEntry { 120152, 0, 6407, 4, 1 }, // &gopf;
    HTMLEntityTableEntry { 96, 0, 32, 5, 1 }, // &grave;
    HTMLEntityTableEntry { 8458, 0, 6411, 4, 1 }, // &gscr;
    HTMLEntityTableEntry { 8819, 0, 6415, 4, 1 }, // &gsim;
    HTMLEntityTableEntry { 10894, 0, 6415, 5, 1 }, // &gsime;
    HTMLEntityTableEntry { 10896, 0, 6420, 5, 1 }, // &gsiml;
    HTMLEntityTableEntry { 62, 0, 4622, 2, 0 }, // &gt
    HTMLEntityTableEntry { 62, 0, 4622, 2, 1 }, // &gt;
    HTMLEntityTableEntry { 10919, 0, 6425, 4, 1 }, // &gtcc;
    HTMLEntityTableEntry { 10874, 0, 6429, 5, 1 }, // &gtcir;
    HTMLEntityTableEntry { 8919, 0, 6434, 5, 1 }, // &gtdot;
    HTMLEntityTableEntry { 10645, 0, 6439, 6, 1 }, // &gtlPar;
    HTMLEntityTableEntry { 10876, 0, 6445, 7, 1 }, // &gtquest;
    HTMLEntityTableEntry { 10886, 0, 6452, 9, 1 }, // &gtrapprox;
    HTMLEntityTableEntry { 10616, 0, 6461, 6, 1 }, // &gtrarr;
    HTMLEntityTableEntry { 8919, 0, 6467, 6, 1 }, // &gtrdot;
    HTMLEntityTableEntry { 8923, 0, 6473, 9, 1 }, // &gtreqless;
    HTMLEntityTableEntry { 10892, 0, 6482, 10, 1 }, // &gtreqqless;
    HTMLEntityTableEntry { 8823, 0, 6492, 7, 1 }, // &gtrless;
    HTMLEntityTableEntry { 8819, 0, 6499, 6, 1 }, // &gtrsim;
    HTMLEntityTableEntry { 8809, 65024, 6505, 9, 1 }, // &gvertneqq;
    HTMLEntityTableEntry { 8809, 65024, 6514, 4, 1 }, // &gvnE;
    HTMLEntityTableEntry { 8660, 0, 6518, 4, 1 }, // &hArr;
    HTMLEntityTableEntry { 8202, 0, 6522, 6, 1 }, // &hairsp;
    HTMLEntityTableEntry { 189, 0, 6528, 4, 1 }, // &half;
    HTMLEntityTableEntry { 8459, 0, 6532, 6, 1 }, // &hamilt;
    HTMLEntityTableEntry { 1098, 0, 6538, 6, 1 }, // &hardcy;
    HTMLEntityTableEntry { 8596, 0, 5633, 4, 1 }, // &harr;
    HTMLEntityTableEntry { 10568, 0, 6544, 7, 1 }, // &harrcir;
    HTMLEntityTableEntry { 8621, 0, 6551, 5, 1 }, // &harrw;
    HTMLEntityTableEntry { 8463, 0, 6556, 4, 1 }, // &hbar;
    HTMLEntityTableEntry { 293, 0, 6560, 5, 1 }, // &hcirc;
    HTMLEntityTableEntry { 9829, 0, 6565, 6, 1 }, // &hearts;
    HTMLEntityTableEntry { 9829, 0, 6565, 9, 1 }, // &heartsuit;
    HTMLEntityTableEntry { 8230, 0, 6574, 6, 1 }, // &hellip;
    HTMLEntityTableEntry { 8889, 0, 6580, 6, 1 }, // &hercon;
    HTMLEntityTableEntry { 120101, 0, 6586, 3, 1 }, // &hfr;
    HTMLEntityTableEntry { 10533, 0, 6589, 8, 1 }, // &hksearow;
    HTMLEntityTableEntry { 10534, 0, 6597, 8, 1 }, // &hkswarow;
    HTMLEntityTableEntry { 8703, 0, 6605, 5, 1 }, // &hoarr;
    HTMLEntityTableEntry { 8763, 0, 6610, 6, 1 }, // &homtht;
    HTMLEntityTableEntry { 8617, 0, 6616, 13, 1 }, // &hookleftarrow;
    HTMLEntityTableEntry { 8618, 0, 6629, 14, 1 }, // &hookrightarrow;
    HTMLEntityTableEntry { 120153, 0, 6643, 4, 1 }, // &hopf;
    HTMLEntityTableEntry { 8213, 0, 6647, 6, 1 }, // &horbar;
    HTMLEntityTableEntry { 119997, 0, 6653, 4, 1 }, // &hscr;
    HTMLEntityTableEntry { 8463, 0, 6657, 6, 1 }, // &hslash;
    HTMLEntityTableEntry { 295, 0, 6662, 6, 1 }, // &hstrok;
    HTMLEntityTableEntry { 8259, 0, 6668, 6, 1 }, // &hybull;
    HTMLEntityTableEntry { 8208, 0, 6674, 6, 1 }, // &hyphen;
    HTMLEntityTableEntry { 237, 0, 6680, 6, 0 }, // &iacute
    HTMLEntityTableEntry { 237, 0, 6680, 6, 1 }, // &iacute;
    HTMLEntityTableEntry { 8291, 0, 493, 2, 1 }, // &ic;
    HTMLEntityTableEntry { 238, 0, 6686, 5, 0 }, // &icirc
    HTMLEntityTableEntry { 238, 0, 6686, 5, 1 }, // &icirc;
    HTMLEntityTableEntry { 1080, 0, 6691, 3, 1 }, // &icy;
    HTMLEntityTableEntry { 1077, 0, 6694, 4, 1 }, // &iecy;
    HTMLEntityTableEntry { 161, 0, 6698, 5, 0 }, // &iexcl
    HTMLEntityTableEntry { 161, 0, 6698, 5, 1 }, // &iexcl;
    HTMLEntityTableEntry { 8660, 0, 184, 3, 1 }, // &iff;
    HTMLEntityTableEntry { 120102, 0, 6703, 3, 1 }, // &ifr;
    HTMLEntityTableEntry { 236, 0, 6706, 6, 0 }, // &igrave
    HTMLEntityTableEntry { 236, 0, 6706, 6, 1 }, // &igrave;
    HTMLEntityTableEntry { 8520, 0, 6712, 2, 1 }, // &ii;
    HTMLEntityTableEntry { 10764, 0, 6712, 6, 1 }, // &iiiint;
    HTMLEntityTableEntry { 8749, 0, 6713, 5, 1 }, // &iiint;
    HTMLEntityTableEntry { 10716, 0, 6718, 6, 1 }, // &iinfin;
    HTMLEntityTableEntry { 8489, 0, 6724, 5, 1 }, // &iiota;
    HTMLEntityTableEntry { 307, 0, 6729, 5, 1 }, // &ijlig;
    HTMLEntityTableEntry { 299, 0, 6734, 5, 1 }, // &imacr;
    HTMLEntityTableEntry { 8465, 0, 6739, 5, 1 }, // &image;
    HTMLEntityTableEntry { 8464, 0, 6744, 8, 1 }, // &imagline;
    HTMLEntityTableEntry { 8465, 0, 6752, 8, 1 }, // &imagpart;
    HTMLEntityTableEntry { 305, 0, 6760, 5, 1 }, // &imath;
    HTMLEntityTableEntry { 8887, 0, 6765, 4, 1 }, // &imof;
    HTMLEntityTableEntry { 437, 0, 6769, 5, 1 }, // &imped;
    HTMLEntityTableEntry { 8712, 0, 74, 2, 1 }, // &in;
    HTMLEntityTableEntry { 8453, 0, 3096, 6, 1 }, // &incare;
    HTMLEntityTableEntry { 8734, 0, 6719, 5, 1 }, // &infin;
    HTMLEntityTableEntry { 10717, 0, 6774, 8, 1 }, // &infintie;
    HTMLEntityTableEntry { 305, 0, 6782, 6, 1 }, // &inodot;
    HTMLEntityTableEntry { 8747, 0, 224, 3, 1 }, // &int;
    HTMLEntityTableEntry { 8890, 0, 6788, 6, 1 }, // &intcal;
    HTMLEntityTableEntry { 8484, 0, 6794, 8, 1 }, // &integers;
    HTMLEntityTableEntry { 8890, 0, 6802, 8, 1 }, // &intercal;
    HTMLEntityTableEntry { 10775, 0, 6810, 8, 1 }, // &intlarhk;
    HTMLEntityTableEntry { 10812, 0, 6818, 7, 1 }, // &intprod;
    HTMLEntityTableEntry { 1105, 0, 6825, 4, 1 }, // &iocy;
    HTMLEntityTableEntry { 303, 0, 6829, 5, 1 }, // &iogon;
    HTMLEntityTableEntry { 120154, 0, 6834, 4, 1 }, // &iopf;
    HTMLEntityTableEntry { 953, 0, 6725, 4, 1 }, // &iota;
    HTMLEntityTableEntry { 10812, 0, 6838, 5, 1 }, // &iprod;
    HTMLEntityTableEntry { 191, 0, 6843, 6, 0 }, // &iquest
    HTMLEntityTableEntry { 191, 0, 6843, 6, 1 }, // &iquest;
    HTMLEntityTableEntry { 119998, 0, 6849, 4, 1 }, // &iscr;
    HTMLEntityTableEntry { 8712, 0, 5664, 4, 1 }, // &isin;
    HTMLEntityTableEntry { 8953, 0, 6853, 5, 1 }, // &isinE;
    HTMLEntityTableEntry { 8949, 0, 6858, 7, 1 }, // &isindot;
    HTMLEntityTableEntry { 8948, 0, 6865, 5, 1 }, // &isins;
    HTMLEntityTableEntry { 8947, 0, 6865, 6, 1 }, // &isinsv;
    HTMLEntityTableEntry { 8712, 0, 6871, 5, 1 }, // &isinv;
    HTMLEntityTableEntry { 8290, 0, 179, 2, 1 }, // &it;
    HTMLEntityTableEntry { 297, 0, 6876, 6, 1 }, // &itilde;
    HTMLEntityTableEntry { 1110, 0, 6882, 5, 1 }, // &iukcy;
    HTMLEntityTableEntry { 239, 0, 6887, 4, 0 }, // &iuml
    HTMLEntityTableEntry { 239, 0, 6887, 4, 1 }, // &iuml;
    HTMLEntityTableEntry { 309, 0, 6891, 5, 1 }, // &jcirc;
    HTMLEntityTableEntry { 1081, 0, 5688, 3, 1 }, // &jcy;
    HTMLEntityTableEntry { 120103, 0, 6896, 3, 1 }, // &jfr;
    HTMLEntityTableEntry { 567, 0, 6899, 5, 1 }, // &jmath;
    HTMLEntityTableEntry { 120155, 0, 6904, 4, 1 }, // &jopf;
    HTMLEntityTableEntry { 119999, 0, 6908, 4, 1 }, // &jscr;
    HTMLEntityTableEntry { 1112, 0, 6912, 6, 1 }, // &jsercy;
    HTMLEntityTableEntry { 1108, 0, 6918, 5, 1 }, // &jukcy;
    HTMLEntityTableEntry { 954, 0, 6923, 5, 1 }, // &kappa;
    HTMLEntityTableEntry { 1008, 0, 6923, 6, 1 }, // &kappav;
    HTMLEntityTableEntry { 311, 0, 6929, 6, 1 }, // &kcedil;
    HTMLEntityTableEntry { 1082, 0, 1542, 3, 1 }, // &kcy;
    HTMLEntityTableEntry { 120104, 0, 6935, 3, 1 }, // &kfr;
    HTMLEntityTableEntry { 312, 0, 6938, 6, 1 }, // &kgreen;
    HTMLEntityTableEntry { 1093, 0, 6944, 4, 1 }, // &khcy;
    HTMLEntityTableEntry { 1116, 0, 6948, 4, 1 }, // &kjcy;
    HTMLEntityTableEntry { 120156, 0, 6952, 4, 1 }, // &kopf;
    HTMLEntityTableEntry { 120000, 0, 6956, 4, 1 }, // &kscr;
    HTMLEntityTableEntry { 8666, 0, 6960, 5, 1 }, // &lAarr;
    HTMLEntityTableEntry { 8656, 0, 6965, 4, 1 }, // &lArr;
    HTMLEntityTableEntry { 10523, 0, 6969, 6, 1 }, // &lAtail;
    HTMLEntityTableEntry { 10510, 0, 6974, 5, 1 }, // &lBarr;
    HTMLEntityTableEntry { 8806, 0, 1120, 2, 1 }, // &lE;
    HTMLEntityTableEntry { 10891, 0, 6378, 3, 1 }, // &lEg;
    HTMLEntityTableEntry { 10594, 0, 6979, 4, 1 }, // &lHar;
    HTMLEntityTableEntry { 314, 0, 6983, 6, 1 }, // &lacute;
    HTMLEntityTableEntry { 10676, 0, 6989, 8, 1 }, // &laemptyv;
    HTMLEntityTableEntry { 8466, 0, 6997, 6, 1 }, // &lagran;
    HTMLEntityTableEntry { 955, 0, 7003, 6, 1 }, // &lambda;
    HTMLEntityTableEntry { 10216, 0, 7009, 4, 1 }, // &lang;
    HTMLEntityTableEntry { 10641, 0, 7009, 5, 1 }, // &langd;
    HTMLEntityTableEntry { 10216, 0, 7014, 6, 1 }, // &langle;
    HTMLEntityTableEntry { 10885, 0, 7020, 3, 1 }, // &lap;
    HTMLEntityTableEntry { 171, 0, 7023, 5, 0 }, // &laquo
    HTMLEntityTableEntry { 171, 0, 7023, 5, 1 }, // &laquo;
    HTMLEntityTableEntry { 8592, 0, 5407, 4, 1 }, // &larr;
    HTMLEntityTableEntry { 8676, 0, 7028, 5, 1 }, // &larrb;
    HTMLEntityTableEntry { 10527, 0, 7028, 7, 1 }, // &larrbfs;
    HTMLEntityTableEntry { 10525, 0, 7035, 6, 1 }, // &larrfs;
    HTMLEntityTableEntry { 8617, 0, 7041, 6, 1 }, // &larrhk;
    HTMLEntityTableEntry { 8619, 0, 7047, 6, 1 }, // &larrlp;
    HTMLEntityTableEntry { 10553, 0, 7053, 6, 1 }, // &larrpl;
    HTMLEntityTableEntry { 10611, 0, 7058, 7, 1 }, // &larrsim;
    HTMLEntityTableEntry { 8610, 0, 7065, 6, 1 }, // &larrtl;
    HTMLEntityTableEntry { 10923, 0, 6171, 3, 1 }, // &lat;
    HTMLEntityTableEntry { 10521, 0, 7070, 6, 1 }, // &latail;
    HTMLEntityTableEntry { 10925, 0, 7075, 4, 1 }, // &late;
    HTMLEntityTableEntry { 10925, 65024, 7075, 5, 1 }, // &lates;
    HTMLEntityTableEntry { 10508, 0, 7080, 5, 1 }, // &lbarr;
    HTMLEntityTableEntry { 10098, 0, 7085, 5, 1 }, // &lbbrk;
    HTMLEntityTableEntry { 123, 0, 7090, 6, 1 }, // &lbrace;
    HTMLEntityTableEntry { 91, 0, 7096, 6, 1 }, // &lbrack;
    HTMLEntityTableEntry { 10635, 0, 7102, 5, 1 }, // &lbrke;
    HTMLEntityTableEntry { 10639, 0, 7107, 7, 1 }, // &lbrksld;
    HTMLEntityTableEntry { 10637, 0, 7114, 7, 1 }, // &lbrkslu;
    HTMLEntityTableEntry { 318, 0, 7121, 6, 1 }, // &lcaron;
    HTMLEntityTableEntry { 316, 0, 7127, 6, 1 }, // &lcedil;
    HTMLEntityTableEntry { 8968, 0, 7132, 5, 1 }, // &lceil;
    HTMLEntityTableEntry { 123, 0, 7136, 4, 1 }, // &lcub;
    HTMLEntityTableEntry { 1083, 0, 7140, 3, 1 }, // &lcy;
    HTMLEntityTableEntry { 10550, 0, 7143, 4, 1 }, // &ldca;
    HTMLEntityTableEntry { 8220, 0, 7147, 5, 1 }, // &ldquo;
    HTMLEntityTableEntry { 8222, 0, 7147, 6, 1 }, // &ldquor;
    HTMLEntityTableEntry { 10599, 0, 7153, 7, 1 }, // &ldrdhar;
    HTMLEntityTableEntry { 10571, 0, 7160, 8, 1 }, // &ldrushar;
    HTMLEntityTableEntry { 8626, 0, 7168, 4, 1 }, // &ldsh;
    HTMLEntityTableEntry { 8804, 0, 199, 2, 1 }, // &le;
    HTMLEntityTableEntry { 8592, 0, 1951, 9, 1 }, // &leftarrow;
    HTMLEntityTableEntry { 8610, 0, 7172, 13, 1 }, // &leftarrowtail;
    HTMLEntityTableEntry { 8637, 0, 7184, 15, 1 }, // &leftharpoondown;
    HTMLEntityTableEntry { 8636, 0, 7199, 13, 1 }, // &leftharpoonup;
    HTMLEntityTableEntry { 8647, 0, 7212, 14, 1 }, // &leftleftarrows;
    HTMLEntityTableEntry { 8596, 0, 1983, 14, 1 }, // &leftrightarrow;
    HTMLEntityTableEntry { 8646, 0, 7226, 15, 1 }, // &leftrightarrows;
    HTMLEntityTableEntry { 8651, 0, 7241, 17, 1 }, // &leftrightharpoons;
    HTMLEntityTableEntry { 8621, 0, 7258, 19, 1 }, // &leftrightsquigarrow;
    HTMLEntityTableEntry { 8907, 0, 7277, 14, 1 }, // &leftthreetimes;
    HTMLEntityTableEntry { 8922, 0, 7291, 3, 1 }, // &leg;
    HTMLEntityTableEntry { 8804, 0, 7294, 3, 1 }, // &leq;
    HTMLEntityTableEntry { 8806, 0, 7294, 4, 1 }, // &leqq;
    HTMLEntityTableEntry { 10877, 0, 7298, 8, 1 }, // &leqslant;
    HTMLEntityTableEntry { 10877, 0, 6034, 3, 1 }, // &les;
    HTMLEntityTableEntry { 10920, 0, 7306, 5, 1 }, // &lescc;
    HTMLEntityTableEntry { 10879, 0, 7311, 6, 1 }, // &lesdot;
    HTMLEntityTableEntry { 10881, 0, 7311, 7, 1 }, // &lesdoto;
    HTMLEntityTableEntry { 10883, 0, 7311, 8, 1 }, // &lesdotor;
    HTMLEntityTableEntry { 8922, 65024, 6360, 4, 1 }, // &lesg;
    HTMLEntityTableEntry { 10899, 0, 7319, 6, 1 }, // &lesges;
    HTMLEntityTableEntry { 10885, 0, 7325, 10, 1 }, // &lessapprox;
    HTMLEntityTableEntry { 8918, 0, 7335, 7, 1 }, // &lessdot;
    HTMLEntityTableEntry { 8922, 0, 7342, 9, 1 }, // &lesseqgtr;
    HTMLEntityTableEntry { 10891, 0, 7351, 10, 1 }, // &lesseqqgtr;
    HTMLEntityTableEntry { 8822, 0, 6478, 7, 1 }, // &lessgtr;
    HTMLEntityTableEntry { 8818, 0, 7361, 7, 1 }, // &lesssim;
    HTMLEntityTableEntry { 10620, 0, 7368, 6, 1 }, // &lfisht;
    HTMLEntityTableEntry { 8970, 0, 7374, 6, 1 }, // &lfloor;
    HTMLEntityTableEntry { 120105, 0, 6298, 3, 1 }, // &lfr;
    HTMLEntityTableEntry { 8822, 0, 4247, 2, 1 }, // &lg;
    HTMLEntityTableEntry { 10897, 0, 7380, 3, 1 }, // &lgE;
    HTMLEntityTableEntry { 8637, 0, 7383, 5, 1 }, // &lhard;
    HTMLEntityTableEntry { 8636, 0, 7388, 5, 1 }, // &lharu;
    HTMLEntityTableEntry { 10602, 0, 7388, 6, 1 }, // &lharul;
    HTMLEntityTableEntry { 9604, 0, 7393, 5, 1 }, // &lhblk;
    HTMLEntityTableEntry { 1113, 0, 7398, 4, 1 }, // &ljcy;
    HTMLEntityTableEntry { 8810, 0, 132, 2, 1 }, // &ll;
    HTMLEntityTableEntry { 8647, 0, 7402, 5, 1 }, // &llarr;
    HTMLEntityTableEntry { 8990, 0, 7407, 8, 1 }, // &llcorner;
    HTMLEntityTableEntry { 10603, 0, 7415, 6, 1 }, // &llhard;
    HTMLEntityTableEntry { 9722, 0, 7421, 5, 1 }, // &lltri;
    HTMLEntityTableEntry { 320, 0, 7426, 6, 1 }, // &lmidot;
    HTMLEntityTableEntry { 9136, 0, 7432, 6, 1 }, // &lmoust;
    HTMLEntityTableEntry { 9136, 0, 7432, 10, 1 }, // &lmoustache;
    HTMLEntityTableEntry { 8808, 0, 7442, 3, 1 }, // &lnE;
    HTMLEntityTableEntry { 10889, 0, 7445, 4, 1 }, // &lnap;
    HTMLEntityTableEntry { 10889, 0, 7445, 8, 1 }, // &lnapprox;
    HTMLEntityTableEntry { 10887, 0, 7453, 3, 1 }, // &lne;
    HTMLEntityTableEntry { 10887, 0, 7453, 4, 1 }, // &lneq;
    HTMLEntityTableEntry { 8808, 0, 7453, 5, 1 }, // &lneqq;
    HTMLEntityTableEntry { 8934, 0, 7458, 5, 1 }, // &lnsim;
    HTMLEntityTableEntry { 10220, 0, 7463, 5, 1 }, // &loang;
    HTMLEntityTableEntry { 8701, 0, 7468, 5, 1 }, // &loarr;
    HTMLEntityTableEntry { 10214, 0, 7473, 5, 1 }, // &lobrk;
    HTMLEntityTableEntry { 10229, 0, 7478, 13, 1 }, // &longleftarrow;
    HTMLEntityTableEntry { 10231, 0, 7491, 18, 1 }, // &longleftrightarrow;
    HTMLEntityTableEntry { 10236, 0, 7509, 10, 1 }, // &longmapsto;
    HTMLEntityTableEntry { 10230, 0, 7519, 14, 1 }, // &longrightarrow;
    HTMLEntityTableEntry { 8619, 0, 7533, 13, 1 }, // &looparrowleft;
    HTMLEntityTableEntry { 8620, 0, 7546, 14, 1 }, // &looparrowright;
    HTMLEntityTableEntry { 10629, 0, 7560, 5, 1 }, // &lopar;
    HTMLEntityTableEntry { 120157, 0, 7565, 4, 1 }, // &lopf;
    HTMLEntityTableEntry { 10797, 0, 7569, 6, 1 }, // &loplus;
    HTMLEntityTableEntry { 10804, 0, 7575, 7, 1 }, // &lotimes;
    HTMLEntityTableEntry { 8727, 0, 7582, 6, 1 }, // &lowast;
    HTMLEntityTableEntry { 95, 0, 7588, 6, 1 }, // &lowbar;
    HTMLEntityTableEntry { 9674, 0, 4681, 3, 1 }, // &loz;
    HTMLEntityTableEntry { 9674, 0, 4681, 7, 1 }, // &lozenge;
    HTMLEntityTableEntry { 10731, 0, 7594, 4, 1 }, // &lozf;
    HTMLEntityTableEntry { 40, 0, 7598, 4, 1 }, // &lpar;
    HTMLEntityTableEntry { 10643, 0, 7598, 6, 1 }, // &lparlt;
    HTMLEntityTableEntry { 8646, 0, 7604, 5, 1 }, // &lrarr;
    HTMLEntityTableEntry { 8991, 0, 7609, 8, 1 }, // &lrcorner;
    HTMLEntityTableEntry { 8651, 0, 7617, 5, 1 }, // &lrhar;
    HTMLEntityTableEntry { 10605, 0, 7617, 6, 1 }, // &lrhard;
    HTMLEntityTableEntry { 8206, 0, 7623, 3, 1 }, // &lrm;
    HTMLEntityTableEntry { 8895, 0, 7626, 5, 1 }, // &lrtri;
    HTMLEntityTableEntry { 8249, 0, 7631, 6, 1 }, // &lsaquo;
    HTMLEntityTableEntry { 120001, 0, 7637, 4, 1 }, // &lscr;
    HTMLEntityTableEntry { 8624, 0, 7641, 3, 1 }, // &lsh;
    HTMLEntityTableEntry { 8818, 0, 7644, 4, 1 }, // &lsim;
    HTMLEntityTableEntry { 10893, 0, 7644, 5, 1 }, // &lsime;
    HTMLEntityTableEntry { 10895, 0, 7649, 5, 1 }, // &lsimg;
    HTMLEntityTableEntry { 91, 0, 7654, 4, 1 }, // &lsqb;
    HTMLEntityTableEntry { 8216, 0, 7658, 5, 1 }, // &lsquo;
    HTMLEntityTableEntry { 8218, 0, 7658, 6, 1 }, // &lsquor;
    HTMLEntityTableEntry { 322, 0, 7664, 6, 1 }, // &lstrok;
    HTMLEntityTableEntry { 60, 0, 480, 2, 0 }, // &lt
    HTMLEntityTableEntry { 60, 0, 480, 2, 1 }, // &lt;
    HTMLEntityTableEntry { 10918, 0, 7670, 4, 1 }, // &ltcc;
    HTMLEntityTableEntry { 10873, 0, 7674, 5, 1 }, // &ltcir;
    HTMLEntityTableEntry { 8918, 0, 7679, 5, 1 }, // &ltdot;
    HTMLEntityTableEntry { 8907, 0, 7684, 6, 1 }, // &lthree;
    HTMLEntityTableEntry { 8905, 0, 7690, 6, 1 }, // &ltimes;
    HTMLEntityTableEntry { 10614, 0, 7696, 6, 1 }, // &ltlarr;
    HTMLEntityTableEntry { 10875, 0, 7702, 7, 1 }, // &ltquest;
    HTMLEntityTableEntry { 10646, 0, 7709, 6, 1 }, // &ltrPar;
    HTMLEntityTableEntry { 9667, 0, 7422, 4, 1 }, // &ltri;
    HTMLEntityTableEntry { 8884, 0, 7715, 5, 1 }, // &ltrie;
    HTMLEntityTableEntry { 9666, 0, 7720, 5, 1 }, // &ltrif;
    HTMLEntityTableEntry { 10570, 0, 7725, 8, 1 }, // &lurdshar;
    HTMLEntityTableEntry { 10598, 0, 7733, 7, 1 }, // &luruhar;
    HTMLEntityTableEntry { 8808, 65024, 7740, 9, 1 }, // &lvertneqq;
    HTMLEntityTableEntry { 8808, 65024, 7749, 4, 1 }, // &lvnE;
    HTMLEntityTableEntry { 8762, 0, 7753, 5, 1 }, // &mDDot;
    HTMLEntityTableEntry { 175, 0, 43, 4, 0 }, // &macr
    HTMLEntityTableEntry { 175, 0, 43, 4, 1 }, // &macr;
    HTMLEntityTableEntry { 9794, 0, 4229, 4, 1 }, // &male;
    HTMLEntityTableEntry { 10016, 0, 7758, 4, 1 }, // &malt;
    HTMLEntityTableEntry { 10016, 0, 7758, 7, 1 }, // &maltese;
    HTMLEntityTableEntry { 8614, 0, 7513, 3, 1 }, // &map;
    HTMLEntityTableEntry { 8614, 0, 7513, 6, 1 }, // &mapsto;
    HTMLEntityTableEntry { 8615, 0, 7765, 10, 1 }, // &mapstodown;
    HTMLEntityTableEntry { 8612, 0, 7775, 10, 1 }, // &mapstoleft;
    HTMLEntityTableEntry { 8613, 0, 7785, 8, 1 }, // &mapstoup;
    HTMLEntityTableEntry { 9646, 0, 7793, 6, 1 }, // &marker;
    HTMLEntityTableEntry { 10793, 0, 7799, 6, 1 }, // &mcomma;
    HTMLEntityTableEntry { 1084, 0, 7805, 3, 1 }, // &mcy;
    HTMLEntityTableEntry { 8212, 0, 7808, 5, 1 }, // &mdash;
    HTMLEntityTableEntry { 8737, 0, 7813, 13, 1 }, // &measuredangle;
    HTMLEntityTableEntry { 120106, 0, 7826, 3, 1 }, // &mfr;
    HTMLEntityTableEntry { 8487, 0, 7829, 3, 1 }, // &mho;
    HTMLEntityTableEntry { 181, 0, 2952, 5, 0 }, // &micro
    HTMLEntityTableEntry { 181, 0, 2952, 5, 1 }, // &micro;
    HTMLEntityTableEntry { 8739, 0, 1961, 3, 1 }, // &mid;
    HTMLEntityTableEntry { 42, 0, 7832, 6, 1 }, // &midast;
    HTMLEntityTableEntry { 10992, 0, 5274, 6, 1 }, // &midcir;
    HTMLEntityTableEntry { 183, 0, 7838, 6, 0 }, // &middot
    HTMLEntityTableEntry { 183, 0, 7838, 6, 1 }, // &middot;
    HTMLEntityTableEntry { 8722, 0, 4939, 5, 1 }, // &minus;
    HTMLEntityTableEntry { 8863, 0, 4939, 6, 1 }, // &minusb;
    HTMLEntityTableEntry { 8760, 0, 5721, 6, 1 }, // &minusd;
    HTMLEntityTableEntry { 10794, 0, 7844, 7, 1 }, // &minusdu;
    HTMLEntityTableEntry { 10971, 0, 7851, 4, 1 }, // &mlcp;
    HTMLEntityTableEntry { 8230, 0, 7855, 4, 1 }, // &mldr;
    HTMLEntityTableEntry { 8723, 0, 7859, 6, 1 }, // &mnplus;
    HTMLEntityTableEntry { 8871, 0, 7865, 6, 1 }, // &models;
    HTMLEntityTableEntry { 120158, 0, 7871, 4, 1 }, // &mopf;
    HTMLEntityTableEntry { 8723, 0, 158, 2, 1 }, // &mp;
    HTMLEntityTableEntry { 120002, 0, 7875, 4, 1 }, // &mscr;
    HTMLEntityTableEntry { 8766, 0, 7879, 6, 1 }, // &mstpos;
    HTMLEntityTableEntry { 956, 0, 7885, 2, 1 }, // &mu;
    HTMLEntityTableEntry { 8888, 0, 7885, 8, 1 }, // &multimap;
    HTMLEntityTableEntry { 8888, 0, 7893, 5, 1 }, // &mumap;
    HTMLEntityTableEntry { 8921, 824, 7898, 3, 1 }, // &nGg;
    HTMLEntityTableEntry { 8811, 8402, 7901, 3, 1 }, // &nGt;
    HTMLEntityTableEntry { 8811, 824, 7901, 4, 1 }, // &nGtv;
    HTMLEntityTableEntry { 8653, 0, 7905, 10, 1 }, // &nLeftarrow;
    HTMLEntityTableEntry { 8654, 0, 7915, 15, 1 }, // &nLeftrightarrow;
    HTMLEntityTableEntry { 8920, 824, 7930, 3, 1 }, // &nLl;
    HTMLEntityTableEntry { 8810, 8402, 7933, 3, 1 }, // &nLt;
    HTMLEntityTableEntry { 8810, 824, 7933, 4, 1 }, // &nLtv;
    HTMLEntityTableEntry { 8655, 0, 7937, 11, 1 }, // &nRightarrow;
    HTMLEntityTableEntry { 8879, 0, 7948, 6, 1 }, // &nVDash;
    HTMLEntityTableEntry { 8878, 0, 7954, 6, 1 }, // &nVdash;
    HTMLEntityTableEntry { 8711, 0, 7960, 5, 1 }, // &nabla;
    HTMLEntityTableEntry { 324, 0, 7965, 6, 1 }, // &nacute;
    HTMLEntityTableEntry { 8736, 8402, 7971, 4, 1 }, // &nang;
    HTMLEntityTableEntry { 8777, 0, 6390, 3, 1 }, // &nap;
    HTMLEntityTableEntry { 10864, 824, 7975, 4, 1 }, // &napE;
    HTMLEntityTableEntry { 8779, 824, 7979, 5, 1 }, // &napid;
    HTMLEntityTableEntry { 329, 0, 7984, 5, 1 }, // &napos;
    HTMLEntityTableEntry { 8777, 0, 6390, 7, 1 }, // &napprox;
    HTMLEntityTableEntry { 9838, 0, 7989, 5, 1 }, // &natur;
    HTMLEntityTableEntry { 9838, 0, 7989, 7, 1 }, // &natural;
    HTMLEntityTableEntry { 8469, 0, 7989, 8, 1 }, // &naturals;
    HTMLEntityTableEntry { 160, 0, 7997, 4, 0 }, // &nbsp
    HTMLEntityTableEntry { 160, 0, 7997, 4, 1 }, // &nbsp;
    HTMLEntityTableEntry { 8782, 824, 8001, 5, 1 }, // &nbump;
    HTMLEntityTableEntry { 8783, 824, 8001, 6, 1 }, // &nbumpe;
    HTMLEntityTableEntry { 10819, 0, 8007, 4, 1 }, // &ncap;
    HTMLEntityTableEntry { 328, 0, 8011, 6, 1 }, // &ncaron;
    HTMLEntityTableEntry { 326, 0, 8016, 6, 1 }, // &ncedil;
    HTMLEntityTableEntry { 8775, 0, 8022, 5, 1 }, // &ncong;
    HTMLEntityTableEntry { 10861, 824, 8022, 8, 1 }, // &ncongdot;
    HTMLEntityTableEntry { 10818, 0, 8030, 4, 1 }, // &ncup;
    HTMLEntityTableEntry { 1085, 0, 8034, 3, 1 }, // &ncy;
    HTMLEntityTableEntry { 8211, 0, 8037, 5, 1 }, // &ndash;
    HTMLEntityTableEntry { 8800, 0, 358, 2, 1 }, // &ne;
    HTMLEntityTableEntry { 8663, 0, 8042, 5, 1 }, // &neArr;
    HTMLEntityTableEntry { 10532, 0, 8047, 6, 1 }, // &nearhk;
    HTMLEntityTableEntry { 8599, 0, 8053, 5, 1 }, // &nearr;
    HTMLEntityTableEntry { 8599, 0, 8053, 7, 1 }, // &nearrow;
    HTMLEntityTableEntry { 8784, 824, 8060, 5, 1 }, // &nedot;
    HTMLEntityTableEntry { 8802, 0, 4777, 6, 1 }, // &nequiv;
    HTMLEntityTableEntry { 10536, 0, 8065, 6, 1 }, // &nesear;
    HTMLEntityTableEntry { 8770, 824, 8071, 5, 1 }, // &nesim;
    HTMLEntityTableEntry { 8708, 0, 8076, 6, 1 }, // &nexist;
    HTMLEntityTableEntry { 8708, 0, 8076, 7, 1 }, // &nexists;
    HTMLEntityTableEntry { 120107, 0, 8083, 3, 1 }, // &nfr;
    HTMLEntityTableEntry { 8807, 824, 8086, 3, 1 }, // &ngE;
    HTMLEntityTableEntry { 8817, 0, 4272, 3, 1 }, // &nge;
    HTMLEntityTableEntry { 8817, 0, 8089, 4, 1 }, // &ngeq;
    HTMLEntityTableEntry { 8807, 824, 8089, 5, 1 }, // &ngeqq;
    HTMLEntityTableEntry { 10878, 824, 8094, 9, 1 }, // &ngeqslant;
    HTMLEntityTableEntry { 10878, 824, 8103, 4, 1 }, // &nges;
    HTMLEntityTableEntry { 8821, 0, 8107, 5, 1 }, // &ngsim;
    HTMLEntityTableEntry { 8815, 0, 8112, 3, 1 }, // &ngt;
    HTMLEntityTableEntry { 8815, 0, 8112, 4, 1 }, // &ngtr;
    HTMLEntityTableEntry { 8654, 0, 8116, 5, 1 }, // &nhArr;
    HTMLEntityTableEntry { 8622, 0, 8121, 5, 1 }, // &nharr;
    HTMLEntityTableEntry { 10994, 0, 8126, 5, 1 }, // &nhpar;
    HTMLEntityTableEntry { 8715, 0, 223, 2, 1 }, // &ni;
    HTMLEntityTableEntry { 8956, 0, 8131, 3, 1 }, // &nis;
    HTMLEntityTableEntry { 8954, 0, 8131, 4, 1 }, // &nisd;
    HTMLEntityTableEntry { 8715, 0, 8135, 3, 1 }, // &niv;
    HTMLEntityTableEntry { 1114, 0, 8138, 4, 1 }, // &njcy;
    HTMLEntityTableEntry { 8653, 0, 8142, 5, 1 }, // &nlArr;
    HTMLEntityTableEntry { 8806, 824, 8147, 3, 1 }, // &nlE;
    HTMLEntityTableEntry { 8602, 0, 8150, 5, 1 }, // &nlarr;
    HTMLEntityTableEntry { 8229, 0, 8155, 4, 1 }, // &nldr;
    HTMLEntityTableEntry { 8816, 0, 5780, 3, 1 }, // &nle;
    HTMLEntityTableEntry { 8602, 0, 8159, 10, 1 }, // &nleftarrow;
    HTMLEntityTableEntry { 8622, 0, 8169, 15, 1 }, // &nleftrightarrow;
    HTMLEntityTableEntry { 8816, 0, 8184, 4, 1 }, // &nleq;
    HTMLEntityTableEntry { 8806, 824, 8184, 5, 1 }, // &nleqq;
    HTMLEntityTableEntry { 10877, 824, 8189, 9, 1 }, // &nleqslant;
    HTMLEntityTableEntry { 10877, 824, 8198, 4, 1 }, // &nles;
    HTMLEntityTableEntry { 8814, 0, 8198, 5, 1 }, // &nless;
    HTMLEntityTableEntry { 8820, 0, 8203, 5, 1 }, // &nlsim;
    HTMLEntityTableEntry { 8814, 0, 8208, 3, 1 }, // &nlt;
    HTMLEntityTableEntry { 8938, 0, 8208, 5, 1 }, // &nltri;
    HTMLEntityTableEntry { 8940, 0, 8208, 6, 1 }, // &nltrie;
    HTMLEntityTableEntry { 8740, 0, 8214, 4, 1 }, // &nmid;
    HTMLEntityTableEntry { 120159, 0, 8218, 4, 1 }, // &nopf;
    HTMLEntityTableEntry { 172, 0, 4784, 3, 0 }, // &not
    HTMLEntityTableEntry { 172, 0, 4784, 3, 1 }, // &not;
    HTMLEntityTableEntry { 8713, 0, 8222, 5, 1 }, // &notin;
    HTMLEntityTableEntry { 8953, 824, 8222, 6, 1 }, // &notinE;
    HTMLEntityTableEntry { 8949, 824, 8228, 8, 1 }, // &notindot;
    HTMLEntityTableEntry { 8713, 0, 8236, 7, 1 }, // &notinva;
    HTMLEntityTableEntry { 8951, 0, 8243, 7, 1 }, // &notinvb;
    HTMLEntityTableEntry { 8950, 0, 8250, 7, 1 }, // &notinvc;
    HTMLEntityTableEntry { 8716, 0, 8257, 5, 1 }, // &notni;
    HTMLEntityTableEntry { 8716, 0, 8257, 7, 1 }, // &notniva;
    HTMLEntityTableEntry { 8958, 0, 8264, 7, 1 }, // &notnivb;
    HTMLEntityTableEntry { 8957, 0, 8271, 7, 1 }, // &notnivc;
    HTMLEntityTableEntry { 8742, 0, 8278, 4, 1 }, // &npar;
    HTMLEntityTableEntry { 8742, 0, 8278, 9, 1 }, // &nparallel;
    HTMLEntityTableEntry { 11005, 8421, 8287, 6, 1 }, // &nparsl;
    HTMLEntityTableEntry { 8706, 824, 8293, 5, 1 }, // &npart;
    HTMLEntityTableEntry { 10772, 0, 8298, 7, 1 }, // &npolint;
    HTMLEntityTableEntry { 8832, 0, 8305, 3, 1 }, // &npr;
    HTMLEntityTableEntry { 8928, 0, 8305, 6, 1 }, // &nprcue;
    HTMLEntityTableEntry { 10927, 824, 8311, 4, 1 }, // &npre;
    HTMLEntityTableEntry { 8832, 0, 8311, 5, 1 }, // &nprec;
    HTMLEntityTableEntry { 10927, 824, 8311, 7, 1 }, // &npreceq;
    HTMLEntityTableEntry { 8655, 0, 8318, 5, 1 }, // &nrArr;
    HTMLEntityTableEntry { 8603, 0, 8323, 5, 1 }, // &nrarr;
    HTMLEntityTableEntry { 10547, 824, 8323, 6, 1 }, // &nrarrc;
    HTMLEntityTableEntry { 8605, 824, 8329, 6, 1 }, // &nrarrw;
    HTMLEntityTableEntry { 8603, 0, 8335, 11, 1 }, // &nrightarrow;
    HTMLEntityTableEntry { 8939, 0, 8346, 5, 1 }, // &nrtri;
    HTMLEntityTableEntry { 8941, 0, 8346, 6, 1 }, // &nrtrie;
    HTMLEntityTableEntry { 8833, 0, 8352, 3, 1 }, // &nsc;
    HTMLEntityTableEntry { 8929, 0, 8352, 6, 1 }, // &nsccue;
    HTMLEntityTableEntry { 10928, 824, 8358, 4, 1 }, // &nsce;
    HTMLEntityTableEntry { 120003, 0, 8362, 4, 1 }, // &nscr;
    HTMLEntityTableEntry { 8740, 0, 8366, 9, 1 }, // &nshortmid;
    HTMLEntityTableEntry { 8742, 0, 8375, 14, 1 }, // &nshortparallel;
    HTMLEntityTableEntry { 8769, 0, 6403, 4, 1 }, // &nsim;
    HTMLEntityTableEntry { 8772, 0, 8389, 5, 1 }, // &nsime;
    HTMLEntityTableEntry { 8772, 0, 8389, 6, 1 }, // &nsimeq;
    HTMLEntityTableEntry { 8740, 0, 8395, 5, 1 }, // &nsmid;
    HTMLEntityTableEntry { 8742, 0, 8400, 5, 1 }, // &nspar;
    HTMLEntityTableEntry { 8930, 0, 8405, 7, 1 }, // &nsqsube;
    HTMLEntityTableEntry { 8931, 0, 8412, 7, 1 }, // &nsqsupe;
    HTMLEntityTableEntry { 8836, 0, 8419, 4, 1 }, // &nsub;
    HTMLEntityTableEntry { 10949, 824, 8419, 5, 1 }, // &nsubE;
    HTMLEntityTableEntry { 8840, 0, 8424, 5, 1 }, // &nsube;
    HTMLEntityTableEntry { 8834, 8402, 8429, 7, 1 }, // &nsubset;
    HTMLEntityTableEntry { 8840, 0, 8429, 9, 1 }, // &nsubseteq;
    HTMLEntityTableEntry { 10949, 824, 8429, 10, 1 }, // &nsubseteqq;
    HTMLEntityTableEntry { 8833, 0, 8439, 5, 1 }, // &nsucc;
    HTMLEntityTableEntry { 10928, 824, 8439, 7, 1 }, // &nsucceq;
    HTMLEntityTableEntry { 8837, 0, 8446, 4, 1 }, // &nsup;
    HTMLEntityTableEntry { 10950, 824, 8446, 5, 1 }, // &nsupE;
    HTMLEntityTableEntry { 8841, 0, 8451, 5, 1 }, // &nsupe;
    HTMLEntityTableEntry { 8835, 8402, 8456, 7, 1 }, // &nsupset;
    HTMLEntityTableEntry { 8841, 0, 8456, 9, 1 }, // &nsupseteq;
    HTMLEntityTableEntry { 10950, 824, 8456, 10, 1 }, // &nsupseteqq;
    HTMLEntityTableEntry { 8825, 0, 8466, 4, 1 }, // &ntgl;
    HTMLEntityTableEntry { 241, 0, 8470, 6, 0 }, // &ntilde
    HTMLEntityTableEntry { 241, 0, 8470, 6, 1 }, // &ntilde;
    HTMLEntityTableEntry { 8824, 0, 8476, 4, 1 }, // &ntlg;
    HTMLEntityTableEntry { 8938, 0, 8480, 13, 1 }, // &ntriangleleft;
    HTMLEntityTableEntry { 8940, 0, 8480, 15, 1 }, // &ntrianglelefteq;
    HTMLEntityTableEntry { 8939, 0, 8495, 14, 1 }, // &ntriangleright;
    HTMLEntityTableEntry { 8941, 0, 8495, 16, 1 }, // &ntrianglerighteq;
    HTMLEntityTableEntry { 957, 0, 270, 2, 1 }, // &nu;
    HTMLEntityTableEntry { 35, 0, 8511, 3, 1 }, // &num;
    HTMLEntityTableEntry { 8470, 0, 8511, 6, 1 }, // &numero;
    HTMLEntityTableEntry { 8199, 0, 8517, 5, 1 }, // &numsp;
    HTMLEntityTableEntry { 8877, 0, 8522, 6, 1 }, // &nvDash;
    HTMLEntityTableEntry { 10500, 0, 8528, 6, 1 }, // &nvHarr;
    HTMLEntityTableEntry { 8781, 8402, 8534, 4, 1 }, // &nvap;
    HTMLEntityTableEntry { 8876, 0, 8538, 6, 1 }, // &nvdash;
    HTMLEntityTableEntry { 8805, 8402, 8544, 4, 1 }, // &nvge;
    HTMLEntityTableEntry { 62, 8402, 8548, 4, 1 }, // &nvgt;
    HTMLEntityTableEntry { 10718, 0, 8552, 7, 1 }, // &nvinfin;
    HTMLEntityTableEntry { 10498, 0, 8558, 6, 1 }, // &nvlArr;
    HTMLEntityTableEntry { 8804, 8402, 8564, 4, 1 }, // &nvle;
    HTMLEntityTableEntry { 60, 8402, 8568, 4, 1 }, // &nvlt;
    HTMLEntityTableEntry { 8884, 8402, 8568, 7, 1 }, // &nvltrie;
    HTMLEntityTableEntry { 10499, 0, 8575, 6, 1 }, // &nvrArr;
    HTMLEntityTableEntry { 8885, 8402, 8581, 7, 1 }, // &nvrtrie;
    HTMLEntityTableEntry { 8764, 8402, 8588, 5, 1 }, // &nvsim;
    HTMLEntityTableEntry { 8662, 0, 8593, 5, 1 }, // &nwArr;
    HTMLEntityTableEntry { 10531, 0, 8598, 6, 1 }, // &nwarhk;
    HTMLEntityTableEntry { 8598, 0, 8604, 5, 1 }, // &nwarr;
    HTMLEntityTableEntry { 8598, 0, 8604, 7, 1 }, // &nwarrow;
    HTMLEntityTableEntry { 10535, 0, 8611, 6, 1 }, // &nwnear;
    HTMLEntityTableEntry { 9416, 0, 8617, 2, 1 }, // &oS;
    HTMLEntityTableEntry { 243, 0, 8619, 6, 0 }, // &oacute
    HTMLEntityTableEntry { 243, 0, 8619, 6, 1 }, // &oacute;
    HTMLEntityTableEntry { 8859, 0, 8625, 4, 1 }, // &oast;
    HTMLEntityTableEntry { 8858, 0, 3757, 4, 1 }, // &ocir;
    HTMLEntityTableEntry { 244, 0, 8629, 5, 0 }, // &ocirc
    HTMLEntityTableEntry { 244, 0, 8629, 5, 1 }, // &ocirc;
    HTMLEntityTableEntry { 1086, 0, 6826, 3, 1 }, // &ocy;
    HTMLEntityTableEntry { 8861, 0, 8634, 5, 1 }, // &odash;
    HTMLEntityTableEntry { 337, 0, 8639, 6, 1 }, // &odblac;
    HTMLEntityTableEntry { 10808, 0, 8645, 4, 1 }, // &odiv;
    HTMLEntityTableEntry { 8857, 0, 4584, 4, 1 }, // &odot;
    HTMLEntityTableEntry { 10684, 0, 8649, 6, 1 }, // &odsold;
    HTMLEntityTableEntry { 339, 0, 8655, 5, 1 }, // &oelig;
    HTMLEntityTableEntry { 10687, 0, 8660, 5, 1 }, // &ofcir;
    HTMLEntityTableEntry { 120108, 0, 8665, 3, 1 }, // &ofr;
    HTMLEntityTableEntry { 731, 0, 51, 4, 1 }, // &ogon;
    HTMLEntityTableEntry { 242, 0, 8668, 6, 0 }, // &ograve
    HTMLEntityTableEntry { 242, 0, 8668, 6, 1 }, // &ograve;
    HTMLEntityTableEntry { 10689, 0, 8674, 3, 1 }, // &ogt;
    HTMLEntityTableEntry { 10677, 0, 8677, 5, 1 }, // &ohbar;
    HTMLEntityTableEntry { 937, 0, 8682, 3, 1 }, // &ohm;
    HTMLEntityTableEntry { 8750, 0, 8685, 4, 1 }, // &oint;
    HTMLEntityTableEntry { 8634, 0, 7027, 5, 1 }, // &olarr;
    HTMLEntityTableEntry { 10686, 0, 8689, 5, 1 }, // &olcir;
    HTMLEntityTableEntry { 10683, 0, 8694, 7, 1 }, // &olcross;
    HTMLEntityTableEntry { 8254, 0, 8701, 5, 1 }, // &oline;
    HTMLEntityTableEntry { 10688, 0, 8706, 3, 1 }, // &olt;
    HTMLEntityTableEntry { 333, 0, 8709, 5, 1 }, // &omacr;
    HTMLEntityTableEntry { 969, 0, 8714, 5, 1 }, // &omega;
    HTMLEntityTableEntry { 959, 0, 8719, 7, 1 }, // &omicron;
    HTMLEntityTableEntry { 10678, 0, 7831, 4, 1 }, // &omid;
    HTMLEntityTableEntry { 8854, 0, 8726, 6, 1 }, // &ominus;
    HTMLEntityTableEntry { 120160, 0, 8732, 4, 1 }, // &oopf;
    HTMLEntityTableEntry { 10679, 0, 7535, 4, 1 }, // &opar;
    HTMLEntityTableEntry { 10681, 0, 8736, 5, 1 }, // &operp;
    HTMLEntityTableEntry { 8853, 0, 4591, 5, 1 }, // &oplus;
    HTMLEntityTableEntry { 8744, 0, 879, 2, 1 }, // &or;
    HTMLEntityTableEntry { 8635, 0, 8741, 5, 1 }, // &orarr;
    HTMLEntityTableEntry { 10845, 0, 8746, 3, 1 }, // &ord;
    HTMLEntityTableEntry { 8500, 0, 8746, 5, 1 }, // &order;
    HTMLEntityTableEntry { 8500, 0, 8746, 7, 1 }, // &orderof;
    HTMLEntityTableEntry { 170, 0, 8753, 4, 0 }, // &ordf
    HTMLEntityTableEntry { 170, 0, 8753, 4, 1 }, // &ordf;
    HTMLEntityTableEntry { 186, 0, 8757, 4, 0 }, // &ordm
    HTMLEntityTableEntry { 186, 0, 8757, 4, 1 }, // &ordm;
    HTMLEntityTableEntry { 8886, 0, 8761, 6, 1 }, // &origof;
    HTMLEntityTableEntry { 10838, 0, 8767, 4, 1 }, // &oror;
    HTMLEntityTableEntry { 10839, 0, 8769, 7, 1 }, // &orslope;
    HTMLEntityTableEntry { 10843, 0, 8776, 3, 1 }, // &orv;
    HTMLEntityTableEntry { 8500, 0, 8779, 4, 1 }, // &oscr;
    HTMLEntityTableEntry { 248, 0, 8783, 6, 0 }, // &oslash
    HTMLEntityTableEntry { 248, 0, 8783, 6, 1 }, // &oslash;
    HTMLEntityTableEntry { 8856, 0, 8789, 4, 1 }, // &osol;
    HTMLEntityTableEntry { 245, 0, 8793, 6, 0 }, // &otilde
    HTMLEntityTableEntry { 245, 0, 8793, 6, 1 }, // &otilde;
    HTMLEntityTableEntry { 8855, 0, 4599, 6, 1 }, // &otimes;
    HTMLEntityTableEntry { 10806, 0, 8799, 8, 1 }, // &otimesas;
    HTMLEntityTableEntry { 246, 0, 8807, 4, 0 }, // &ouml
    HTMLEntityTableEntry { 246, 0, 8807, 4, 1 }, // &ouml;
    HTMLEntityTableEntry { 9021, 0, 8811, 5, 1 }, // &ovbar;
    HTMLEntityTableEntry { 8741, 0, 3901, 3, 1 }, // &par;
    HTMLEntityTableEntry { 182, 0, 4022, 4, 0 }, // &para
    HTMLEntityTableEntry { 182, 0, 4022, 4, 1 }, // &para;
    HTMLEntityTableEntry { 8741, 0, 8279, 8, 1 }, // &parallel;
    HTMLEntityTableEntry { 10995, 0, 8816, 6, 1 }, // &parsim;
    HTMLEntityTableEntry { 11005, 0, 5990, 5, 1 }, // &parsl;
    HTMLEntityTableEntry { 8706, 0, 6197, 4, 1 }, // &part;
    HTMLEntityTableEntry { 1087, 0, 8822, 3, 1 }, // &pcy;
    HTMLEntityTableEntry { 37, 0, 8825, 6, 1 }, // &percnt;
    HTMLEntityTableEntry { 46, 0, 8831, 6, 1 }, // &period;
    HTMLEntityTableEntry { 8240, 0, 8837, 6, 1 }, // &permil;
    HTMLEntityTableEntry { 8869, 0, 8737, 4, 1 }, // &perp;
    HTMLEntityTableEntry { 8241, 0, 8843, 7, 1 }, // &pertenk;
    HTMLEntityTableEntry { 120109, 0, 8850, 3, 1 }, // &pfr;
    HTMLEntityTableEntry { 966, 0, 8853, 3, 1 }, // &phi;
    HTMLEntityTableEntry { 981, 0, 8853, 4, 1 }, // &phiv;
    HTMLEntityTableEntry { 8499, 0, 8857, 6, 1 }, // &phmmat;
    HTMLEntityTableEntry { 9742, 0, 8863, 5, 1 }, // &phone;
    HTMLEntityTableEntry { 960, 0, 178, 2, 1 }, // &pi;
    HTMLEntityTableEntry { 8916, 0, 8868, 9, 1 }, // &pitchfork;
    HTMLEntityTableEntry { 982, 0, 8877, 3, 1 }, // &piv;
    HTMLEntityTableEntry { 8463, 0, 8880, 6, 1 }, // &planck;
    HTMLEntityTableEntry { 8462, 0, 8880, 7, 1 }, // &planckh;
    HTMLEntityTableEntry { 8463, 0, 8887, 6, 1 }, // &plankv;
    HTMLEntityTableEntry { 43, 0, 4592, 4, 1 }, // &plus;
    HTMLEntityTableEntry { 10787, 0, 8893, 8, 1 }, // &plusacir;
    HTMLEntityTableEntry { 8862, 0, 4592, 5, 1 }, // &plusb;
    HTMLEntityTableEntry { 10786, 0, 8901, 7, 1 }, // &pluscir;
    HTMLEntityTableEntry { 8724, 0, 5729, 6, 1 }, // &plusdo;
    HTMLEntityTableEntry { 10789, 0, 8908, 6, 1 }, // &plusdu;
    HTMLEntityTableEntry { 10866, 0, 5996, 5, 1 }, // &pluse;
    HTMLEntityTableEntry { 177, 0, 8914, 6, 0 }, // &plusmn
    HTMLEntityTableEntry { 177, 0, 8914, 6, 1 }, // &plusmn;
    HTMLEntityTableEntry { 10790, 0, 8920, 7, 1 }, // &plussim;
    HTMLEntityTableEntry { 10791, 0, 8927, 7, 1 }, // &plustwo;
    HTMLEntityTableEntry { 177, 0, 7792, 2, 1 }, // &pm;
    HTMLEntityTableEntry { 10773, 0, 8934, 8, 1 }, // &pointint;
    HTMLEntityTableEntry { 120161, 0, 8942, 4, 1 }, // &popf;
    HTMLEntityTableEntry { 163, 0, 8946, 5, 0 }, // &pound
    HTMLEntityTableEntry { 163, 0, 8946, 5, 1 }, // &pound;
    HTMLEntityTableEntry { 8826, 0, 381, 2, 1 }, // &pr;
    HTMLEntityTableEntry { 10931, 0, 8951, 3, 1 }, // &prE;
    HTMLEntityTableEntry { 10935, 0, 8954, 4, 1 }, // &prap;
    HTMLEntityTableEntry { 8828, 0, 5399, 5, 1 }, // &prcue;
    HTMLEntityTableEntry { 10927, 0, 5448, 3, 1 }, // &pre;
    HTMLEntityTableEntry { 8826, 0, 5448, 4, 1 }, // &prec;
    HTMLEntityTableEntry { 10935, 0, 8957, 10, 1 }, // &precapprox;
    HTMLEntityTableEntry { 8828, 0, 8967, 11, 1 }, // &preccurlyeq;
    HTMLEntityTableEntry { 10927, 0, 8312, 6, 1 }, // &preceq;
    HTMLEntityTableEntry { 10937, 0, 8978, 11, 1 }, // &precnapprox;
    HTMLEntityTableEntry { 10933, 0, 8989, 8, 1 }, // &precneqq;
    HTMLEntityTableEntry { 8936, 0, 8997, 8, 1 }, // &precnsim;
    HTMLEntityTableEntry { 8830, 0, 9005, 7, 1 }, // &precsim;
    HTMLEntityTableEntry { 8242, 0, 4470, 5, 1 }, // &prime;
    HTMLEntityTableEntry { 8473, 0, 9012, 6, 1 }, // &primes;
    HTMLEntityTableEntry { 10933, 0, 9018, 4, 1 }, // &prnE;
    HTMLEntityTableEntry { 10937, 0, 9022, 5, 1 }, // &prnap;
    HTMLEntityTableEntry { 8936, 0, 9026, 6, 1 }, // &prnsim;
    HTMLEntityTableEntry { 8719, 0, 381, 4, 1 }, // &prod;
    HTMLEntityTableEntry { 9006, 0, 9032, 8, 1 }, // &profalar;
    HTMLEntityTableEntry { 8978, 0, 9040, 8, 1 }, // &profline;
    HTMLEntityTableEntry { 8979, 0, 9048, 8, 1 }, // &profsurf;
    HTMLEntityTableEntry { 8733, 0, 9056, 4, 1 }, // &prop;
    HTMLEntityTableEntry { 8733, 0, 9056, 6, 1 }, // &propto;
    HTMLEntityTableEntry { 8830, 0, 9062, 5, 1 }, // &prsim;
    HTMLEntityTableEntry { 8880, 0, 9067, 6, 1 }, // &prurel;
    HTMLEntityTableEntry { 120005, 0, 9073, 4, 1 }, // &pscr;
    HTMLEntityTableEntry { 968, 0, 1079, 3, 1 }, // &psi;
    HTMLEntityTableEntry { 8200, 0, 9077, 6, 1 }, // &puncsp;
    HTMLEntityTableEntry { 120110, 0, 9083, 3, 1 }, // &qfr;
    HTMLEntityTableEntry { 10764, 0, 9086, 4, 1 }, // &qint;
    HTMLEntityTableEntry { 120162, 0, 9090, 4, 1 }, // &qopf;
    HTMLEntityTableEntry { 8279, 0, 9094, 6, 1 }, // &qprime;
    HTMLEntityTableEntry { 120006, 0, 9100, 4, 1 }, // &qscr;
    HTMLEntityTableEntry { 8461, 0, 9104, 11, 1 }, // &quaternions;
    HTMLEntityTableEntry { 10774, 0, 9115, 7, 1 }, // &quatint;
    HTMLEntityTableEntry { 63, 0, 6045, 5, 1 }, // &quest;
    HTMLEntityTableEntry { 8799, 0, 6045, 7, 1 }, // &questeq;
    HTMLEntityTableEntry { 34, 0, 9122, 4, 0 }, // &quot
    HTMLEntityTableEntry { 34, 0, 9122, 4, 1 }, // &quot;
    HTMLEntityTableEntry { 8667, 0, 9126, 5, 1 }, // &rAarr;
    HTMLEntityTableEntry { 8658, 0, 8319, 4, 1 }, // &rArr;
    HTMLEntityTableEntry { 10524, 0, 9130, 6, 1 }, // &rAtail;
    HTMLEntityTableEntry { 10511, 0, 9136, 5, 1 }, // &rBarr;
    HTMLEntityTableEntry { 10596, 0, 9140, 4, 1 }, // &rHar;
    HTMLEntityTableEntry { 8765, 817, 3036, 4, 1 }, // &race;
    HTMLEntityTableEntry { 341, 0, 9143, 6, 1 }, // &racute;
    HTMLEntityTableEntry { 8730, 0, 9149, 5, 1 }, // &radic;
    HTMLEntityTableEntry { 10675, 0, 9154, 8, 1 }, // &raemptyv;
    HTMLEntityTableEntry { 10217, 0, 9162, 4, 1 }, // &rang;
    HTMLEntityTableEntry { 10642, 0, 9162, 5, 1 }, // &rangd;
    HTMLEntityTableEntry { 10661, 0, 9167, 5, 1 }, // &range;
    HTMLEntityTableEntry { 10217, 0, 9172, 6, 1 }, // &rangle;
    HTMLEntityTableEntry { 187, 0, 9178, 5, 0 }, // &raquo
    HTMLEntityTableEntry { 187, 0, 9178, 5, 1 }, // &raquo;
    HTMLEntityTableEntry { 8594, 0, 5354, 4, 1 }, // &rarr;
    HTMLEntityTableEntry { 10613, 0, 9183, 6, 1 }, // &rarrap;
    HTMLEntityTableEntry { 8677, 0, 9189, 5, 1 }, // &rarrb;
    HTMLEntityTableEntry { 10528, 0, 9189, 7, 1 }, // &rarrbfs;
    HTMLEntityTableEntry { 10547, 0, 5354, 5, 1 }, // &rarrc;
    HTMLEntityTableEntry { 10526, 0, 9196, 6, 1 }, // &rarrfs;
    HTMLEntityTableEntry { 8618, 0, 9202, 6, 1 }, // &rarrhk;
    HTMLEntityTableEntry { 8620, 0, 9208, 6, 1 }, // &rarrlp;
    HTMLEntityTableEntry { 10565, 0, 9214, 6, 1 }, // &rarrpl;
    HTMLEntityTableEntry { 10612, 0, 9220, 7, 1 }, // &rarrsim;
    HTMLEntityTableEntry { 8611, 0, 9227, 6, 1 }, // &rarrtl;
    HTMLEntityTableEntry { 8605, 0, 8330, 5, 1 }, // &rarrw;
    HTMLEntityTableEntry { 10522, 0, 9233, 6, 1 }, // &ratail;
    HTMLEntityTableEntry { 8758, 0, 9239, 5, 1 }, // &ratio;
    HTMLEntityTableEntry { 8474, 0, 9239, 9, 1 }, // &rationals;
    HTMLEntityTableEntry { 10509, 0, 9248, 5, 1 }, // &rbarr;
    HTMLEntityTableEntry { 10099, 0, 9252, 5, 1 }, // &rbbrk;
    HTMLEntityTableEntry { 125, 0, 9257, 6, 1 }, // &rbrace;
    HTMLEntityTableEntry { 93, 0, 9263, 6, 1 }, // &rbrack;
    HTMLEntityTableEntry { 10636, 0, 9269, 5, 1 }, // &rbrke;
    HTMLEntityTableEntry { 10638, 0, 9274, 7, 1 }, // &rbrksld;
    HTMLEntityTableEntry { 10640, 0, 9281, 7, 1 }, // &rbrkslu;
    HTMLEntityTableEntry { 345, 0, 9288, 6, 1 }, // &rcaron;
    HTMLEntityTableEntry { 343, 0, 9294, 6, 1 }, // &rcedil;
    HTMLEntityTableEntry { 8969, 0, 9300, 5, 1 }, // &rceil;
    HTMLEntityTableEntry { 125, 0, 9305, 4, 1 }, // &rcub;
    HTMLEntityTableEntry { 1088, 0, 1568, 3, 1 }, // &rcy;
    HTMLEntityTableEntry { 10551, 0, 9309, 4, 1 }, // &rdca;
    HTMLEntityTableEntry { 10601, 0, 9313, 7, 1 }, // &rdldhar;
    HTMLEntityTableEntry { 8221, 0, 9319, 5, 1 }, // &rdquo;
    HTMLEntityTableEntry { 8221, 0, 9319, 6, 1 }, // &rdquor;
    HTMLEntityTableEntry { 8627, 0, 7727, 4, 1 }, // &rdsh;
    HTMLEntityTableEntry { 8476, 0, 9324, 4, 1 }, // &real;
    HTMLEntityTableEntry { 8475, 0, 9324, 7, 1 }, // &realine;
    HTMLEntityTableEntry { 8476, 0, 9331, 8, 1 }, // &realpart;
    HTMLEntityTableEntry { 8477, 0, 9339, 5, 1 }, // &reals;
    HTMLEntityTableEntry { 9645, 0, 9344, 4, 1 }, // &rect;
    HTMLEntityTableEntry { 174, 0, 5925, 3, 0 }, // &reg
    HTMLEntityTableEntry { 174, 0, 5925, 3, 1 }, // &reg;
    HTMLEntityTableEntry { 10621, 0, 9348, 6, 1 }, // &rfisht;
    HTMLEntityTableEntry { 8971, 0, 9354, 6, 1 }, // &rfloor;
    HTMLEntityTableEntry { 120111, 0, 9359, 3, 1 }, // &rfr;
    HTMLEntityTableEntry { 8641, 0, 7618, 5, 1 }, // &rhard;
    HTMLEntityTableEntry { 8640, 0, 9361, 5, 1 }, // &rharu;
    HTMLEntityTableEntry { 10604, 0, 9361, 6, 1 }, // &rharul;
    HTMLEntityTableEntry { 961, 0, 6609, 3, 1 }, // &rho;
    HTMLEntityTableEntry { 1009, 0, 9367, 4, 1 }, // &rhov;
    HTMLEntityTableEntry { 8594, 0, 1881, 10, 1 }, // &rightarrow;
    HTMLEntityTableEntry { 8611, 0, 9371, 14, 1 }, // &rightarrowtail;
    HTMLEntityTableEntry { 8641, 0, 9385, 16, 1 }, // &rightharpoondown;
    HTMLEntityTableEntry { 8640, 0, 9401, 14, 1 }, // &rightharpoonup;
    HTMLEntityTableEntry { 8644, 0, 9415, 15, 1 }, // &rightleftarrows;
    HTMLEntityTableEntry { 8652, 0, 9430, 17, 1 }, // &rightleftharpoons;
    HTMLEntityTableEntry { 8649, 0, 9447, 16, 1 }, // &rightrightarrows;
    HTMLEntityTableEntry { 8605, 0, 7262, 15, 1 }, // &rightsquigarrow;
    HTMLEntityTableEntry { 8908, 0, 9463, 15, 1 }, // &rightthreetimes;
    HTMLEntityTableEntry { 730, 0, 73, 4, 1 }, // &ring;
    HTMLEntityTableEntry { 8787, 0, 9478, 12, 1 }, // &risingdotseq;
    HTMLEntityTableEntry { 8644, 0, 9490, 5, 1 }, // &rlarr;
    HTMLEntityTableEntry { 8652, 0, 9494, 5, 1 }, // &rlhar;
    HTMLEntityTableEntry { 8207, 0, 9498, 3, 1 }, // &rlm;
    HTMLEntityTableEntry { 9137, 0, 9501, 6, 1 }, // &rmoust;
    HTMLEntityTableEntry { 9137, 0, 9501, 10, 1 }, // &rmoustache;
    HTMLEntityTableEntry { 10990, 0, 9511, 5, 1 }, // &rnmid;
    HTMLEntityTableEntry { 10221, 0, 9516, 5, 1 }, // &roang;
    HTMLEntityTableEntry { 8702, 0, 9521, 5, 1 }, // &roarr;
    HTMLEntityTableEntry { 10215, 0, 9525, 5, 1 }, // &robrk;
    HTMLEntityTableEntry { 10630, 0, 9530, 5, 1 }, // &ropar;
    HTMLEntityTableEntry { 120163, 0, 9534, 4, 1 }, // &ropf;
    HTMLEntityTableEntry { 10798, 0, 9538, 6, 1 }, // &roplus;
    HTMLEntityTableEntry { 10805, 0, 9544, 7, 1 }, // &rotimes;
    HTMLEntityTableEntry { 41, 0, 8815, 4, 1 }, // &rpar;
    HTMLEntityTableEntry { 10644, 0, 9551, 6, 1 }, // &rpargt;
    HTMLEntityTableEntry { 10770, 0, 9557, 8, 1 }, // &rppolint;
    HTMLEntityTableEntry { 8649, 0, 9565, 5, 1 }, // &rrarr;
    HTMLEntityTableEntry { 8250, 0, 9569, 6, 1 }, // &rsaquo;
    HTMLEntityTableEntry { 120007, 0, 9575, 4, 1 }, // &rscr;
    HTMLEntityTableEntry { 8625, 0, 9578, 3, 1 }, // &rsh;
    HTMLEntityTableEntry { 93, 0, 9581, 4, 1 }, // &rsqb;
    HTMLEntityTableEntry { 8217, 0, 9585, 5, 1 }, // &rsquo;
    HTMLEntityTableEntry { 8217, 0, 9585, 6, 1 }, // &rsquor;
    HTMLEntityTableEntry { 8908, 0, 9590, 6, 1 }, // &rthree;
    HTMLEntityTableEntry { 8906, 0, 9596, 6, 1 }, // &rtimes;
    HTMLEntityTableEntry { 9657, 0, 7627, 4, 1 }, // &rtri;
    HTMLEntityTableEntry { 8885, 0, 8347, 5, 1 }, // &rtrie;
    HTMLEntityTableEntry { 9656, 0, 9602, 5, 1 }, // &rtrif;
    HTMLEntityTableEntry { 10702, 0, 9607, 8, 1 }, // &rtriltri;
    HTMLEntityTableEntry { 10600, 0, 9615, 7, 1 }, // &ruluhar;
    HTMLEntityTableEntry { 8478, 0, 9621, 2, 1 }, // &rx;
    HTMLEntityTableEntry { 347, 0, 9623, 6, 1 }, // &sacute;
    HTMLEntityTableEntry { 8218, 0, 9629, 5, 1 }, // &sbquo;
    HTMLEntityTableEntry { 8827, 0, 78, 2, 1 }, // &sc;
    HTMLEntityTableEntry { 10932, 0, 9634, 3, 1 }, // &scE;
    HTMLEntityTableEntry { 10936, 0, 9637, 4, 1 }, // &scap;
    HTMLEntityTableEntry { 353, 0, 9641, 6, 1 }, // &scaron;
    HTMLEntityTableEntry { 8829, 0, 8353, 5, 1 }, // &sccue;
    HTMLEntityTableEntry { 10928, 0, 8359, 3, 1 }, // &sce;
    HTMLEntityTableEntry { 351, 0, 9647, 6, 1 }, // &scedil;
    HTMLEntityTableEntry { 349, 0, 5280, 5, 1 }, // &scirc;
    HTMLEntityTableEntry { 10934, 0, 9653, 4, 1 }, // &scnE;
    HTMLEntityTableEntry { 10938, 0, 9657, 5, 1 }, // &scnap;
    HTMLEntityTableEntry { 8937, 0, 9662, 6, 1 }, // &scnsim;
    HTMLEntityTableEntry { 10771, 0, 9668, 8, 1 }, // &scpolint;
    HTMLEntityTableEntry { 8831, 0, 9676, 5, 1 }, // &scsim;
    HTMLEntityTableEntry { 1089, 0, 5826, 3, 1 }, // &scy;
    HTMLEntityTableEntry { 8901, 0, 5725, 4, 1 }, // &sdot;
    HTMLEntityTableEntry { 8865, 0, 9681, 5, 1 }, // &sdotb;
    HTMLEntityTableEntry { 10854, 0, 5933, 5, 1 }, // &sdote;
    HTMLEntityTableEntry { 8664, 0, 9686, 5, 1 }, // &seArr;
    HTMLEntityTableEntry { 10533, 0, 9691, 6, 1 }, // &searhk;
    HTMLEntityTableEntry { 8600, 0, 9697, 5, 1 }, // &searr;
    HTMLEntityTableEntry { 8600, 0, 9697, 7, 1 }, // &searrow;
    HTMLEntityTableEntry { 167, 0, 1482, 4, 0 }, // &sect
    HTMLEntityTableEntry { 167, 0, 1482, 4, 1 }, // &sect;
    HTMLEntityTableEntry { 59, 0, 5026, 4, 1 }, // &semi;
    HTMLEntityTableEntry { 10537, 0, 9704, 6, 1 }, // &seswar;
    HTMLEntityTableEntry { 8726, 0, 9710, 8, 1 }, // &setminus;
    HTMLEntityTableEntry { 8726, 0, 9717, 5, 1 }, // &setmn;
    HTMLEntityTableEntry { 10038, 0, 9722, 4, 1 }, // &sext;
    HTMLEntityTableEntry { 120112, 0, 9726, 3, 1 }, // &sfr;
    HTMLEntityTableEntry { 8994, 0, 9726, 6, 1 }, // &sfrown;
    HTMLEntityTableEntry { 9839, 0, 9732, 5, 1 }, // &sharp;
    HTMLEntityTableEntry { 1097, 0, 9737, 6, 1 }, // &shchcy;
    HTMLEntityTableEntry { 1096, 0, 9743, 4, 1 }, // &shcy;
    HTMLEntityTableEntry { 8739, 0, 8367, 8, 1 }, // &shortmid;
    HTMLEntityTableEntry { 8741, 0, 8376, 13, 1 }, // &shortparallel;
    HTMLEntityTableEntry { 173, 0, 9747, 3, 0 }, // &shy
    HTMLEntityTableEntry { 173, 0, 9747, 3, 1 }, // &shy;
    HTMLEntityTableEntry { 963, 0, 9750, 5, 1 }, // &sigma;
    HTMLEntityTableEntry { 962, 0, 9750, 6, 1 }, // &sigmaf;
    HTMLEntityTableEntry { 962, 0, 9756, 6, 1 }, // &sigmav;
    HTMLEntityTableEntry { 8764, 0, 1111, 3, 1 }, // &sim;
    HTMLEntityTableEntry { 10858, 0, 9762, 6, 1 }, // &simdot;
    HTMLEntityTableEntry { 8771, 0, 4479, 4, 1 }, // &sime;
    HTMLEntityTableEntry { 8771, 0, 4479, 5, 1 }, // &simeq;
    HTMLEntityTableEntry { 10910, 0, 6404, 4, 1 }, // &simg;
    HTMLEntityTableEntry { 10912, 0, 9768, 5, 1 }, // &simgE;
    HTMLEntityTableEntry { 10909, 0, 6421, 4, 1 }, // &siml;
    HTMLEntityTableEntry { 10911, 0, 9773, 5, 1 }, // &simlE;
    HTMLEntityTableEntry { 8774, 0, 8073, 5, 1 }, // &simne;
    HTMLEntityTableEntry { 10788, 0, 8924, 7, 1 }, // &simplus;
    HTMLEntityTableEntry { 10610, 0, 9224, 7, 1 }, // &simrarr;
    HTMLEntityTableEntry { 8592, 0, 7034, 5, 1 }, // &slarr;
    HTMLEntityTableEntry { 8726, 0, 9778, 13, 1 }, // &smallsetminus;
    HTMLEntityTableEntry { 10803, 0, 9790, 6, 1 }, // &smashp;
    HTMLEntityTableEntry { 10724, 0, 9796, 8, 1 }, // &smeparsl;
    HTMLEntityTableEntry { 8739, 0, 8396, 4, 1 }, // &smid;
    HTMLEntityTableEntry { 8995, 0, 9804, 5, 1 }, // &smile;
    HTMLEntityTableEntry { 10922, 0, 9809, 3, 1 }, // &smt;
    HTMLEntityTableEntry { 10924, 0, 9809, 4, 1 }, // &smte;
    HTMLEntityTableEntry { 10924, 65024, 9809, 5, 1 }, // &smtes;
    HTMLEntityTableEntry { 1100, 0, 9813, 6, 1 }, // &softcy;
    HTMLEntityTableEntry { 47, 0, 5036, 3, 1 }, // &sol;
    HTMLEntityTableEntry { 10692, 0, 5036, 4, 1 }, // &solb;
    HTMLEntityTableEntry { 9023, 0, 9819, 6, 1 }, // &solbar;
    HTMLEntityTableEntry { 120164, 0, 9825, 4, 1 }, // &sopf;
    HTMLEntityTableEntry { 9824, 0, 9829, 6, 1 }, // &spades;
    HTMLEntityTableEntry { 9824, 0, 9829, 9, 1 }, // &spadesuit;
    HTMLEntityTableEntry { 8741, 0, 8401, 4, 1 }, // &spar;
    HTMLEntityTableEntry { 8851, 0, 9838, 5, 1 }, // &sqcap;
    HTMLEntityTableEntry { 8851, 65024, 9838, 6, 1 }, // &sqcaps;
    HTMLEntityTableEntry { 8852, 0, 4608, 5, 1 }, // &sqcup;
    HTMLEntityTableEntry { 8852, 65024, 9843, 6, 1 }, // &sqcups;
    HTMLEntityTableEntry { 8847, 0, 8406, 5, 1 }, // &sqsub;
    HTMLEntityTableEntry { 8849, 0, 8406, 6, 1 }, // &sqsube;
    HTMLEntityTableEntry { 8847, 0, 9848, 8, 1 }, // &sqsubset;
    HTMLEntityTableEntry { 8849, 0, 9848, 10, 1 }, // &sqsubseteq;
    HTMLEntityTableEntry { 8848, 0, 8413, 5, 1 }, // &sqsup;
    HTMLEntityTableEntry { 8850, 0, 8413, 6, 1 }, // &sqsupe;
    HTMLEntityTableEntry { 8848, 0, 9858, 8, 1 }, // &sqsupset;
    HTMLEntityTableEntry { 8850, 0, 9858, 10, 1 }, // &sqsupseteq;
    HTMLEntityTableEntry { 9633, 0, 4693, 3, 1 }, // &squ;
    HTMLEntityTableEntry { 9633, 0, 4693, 6, 1 }, // &square;
    HTMLEntityTableEntry { 9642, 0, 9868, 6, 1 }, // &squarf;
    HTMLEntityTableEntry { 9642, 0, 9874, 4, 1 }, // &squf;
    HTMLEntityTableEntry { 8594, 0, 9195, 5, 1 }, // &srarr;
    HTMLEntityTableEntry { 120008, 0, 9878, 4, 1 }, // &sscr;
    HTMLEntityTableEntry { 8726, 0, 9882, 6, 1 }, // &ssetmn;
    HTMLEntityTableEntry { 8995, 0, 9888, 6, 1 }, // &ssmile;
    HTMLEntityTableEntry { 8902, 0, 9894, 6, 1 }, // &sstarf;
    HTMLEntityTableEntry { 9734, 0, 4616, 4, 1 }, // &star;
    HTMLEntityTableEntry { 9733, 0, 9895, 5, 1 }, // &starf;
    HTMLEntityTableEntry { 1013, 0, 9900, 15, 1 }, // &straightepsilon;
    HTMLEntityTableEntry { 981, 0, 9915, 11, 1 }, // &straightphi;
    HTMLEntityTableEntry { 175, 0, 9926, 5, 1 }, // &strns;
    HTMLEntityTableEntry { 8834, 0, 5044, 3, 1 }, // &sub;
    HTMLEntityTableEntry { 10949, 0, 8420, 4, 1 }, // &subE;
    HTMLEntityTableEntry { 10941, 0, 9930, 6, 1 }, // &subdot;
    HTMLEntityTableEntry { 8838, 0, 5368, 4, 1 }, // &sube;
    HTMLEntityTableEntry { 10947, 0, 9936, 7, 1 }, // &subedot;
    HTMLEntityTableEntry { 10945, 0, 9943, 7, 1 }, // &submult;
    HTMLEntityTableEntry { 10955, 0, 9950, 5, 1 }, // &subnE;
    HTMLEntityTableEntry { 8842, 0, 9955, 5, 1 }, // &subne;
    HTMLEntityTableEntry { 10943, 0, 9960, 7, 1 }, // &subplus;
    HTMLEntityTableEntry { 10617, 0, 9966, 7, 1 }, // &subrarr;
    HTMLEntityTableEntry { 8834, 0, 8430, 6, 1 }, // &subset;
    HTMLEntityTableEntry { 8838, 0, 8430, 8, 1 }, // &subseteq;
    HTMLEntityTableEntry { 10949, 0, 8430, 9, 1 }, // &subseteqq;
    HTMLEntityTableEntry { 8842, 0, 9973, 9, 1 }, // &subsetneq;
    HTMLEntityTableEntry { 10955, 0, 9973, 10, 1 }, // &subsetneqq;
    HTMLEntityTableEntry { 10951, 0, 9983, 6, 1 }, // &subsim;
    HTMLEntityTableEntry { 10965, 0, 9989, 6, 1 }, // &subsub;
    HTMLEntityTableEntry { 10963, 0, 9992, 6, 1 }, // &subsup;
    HTMLEntityTableEntry { 8827, 0, 5458, 4, 1 }, // &succ;
    HTMLEntityTableEntry { 10936, 0, 9998, 10, 1 }, // &succapprox;
    HTMLEntityTableEntry { 8829, 0, 10008, 11, 1 }, // &succcurlyeq;
    HTMLEntityTableEntry { 10928, 0, 8440, 6, 1 }, // &succeq;
    HTMLEntityTableEntry { 10938, 0, 10019, 11, 1 }, // &succnapprox;
    HTMLEntityTableEntry { 10934, 0, 10030, 8, 1 }, // &succneqq;
    HTMLEntityTableEntry { 8937, 0, 10038, 8, 1 }, // &succnsim;
    HTMLEntityTableEntry { 8831, 0, 10046, 7, 1 }, // &succsim;
    HTMLEntityTableEntry { 8721, 0, 10053, 3, 1 }, // &sum;
    HTMLEntityTableEntry { 9834, 0, 10056, 4, 1 }, // &sung;
    HTMLEntityTableEntry { 185, 0, 10060, 4, 0 }, // &sup1
    HTMLEntityTableEntry { 185, 0, 10060, 4, 1 }, // &sup1;
    HTMLEntityTableEntry { 178, 0, 10064, 4, 0 }, // &sup2
    HTMLEntityTableEntry { 178, 0, 10064, 4, 1 }, // &sup2;
    HTMLEntityTableEntry { 179, 0, 10068, 4, 0 }, // &sup3
    HTMLEntityTableEntry { 179, 0, 10068, 4, 1 }, // &sup3;
    HTMLEntityTableEntry { 8835, 0, 5373, 3, 1 }, // &sup;
    HTMLEntityTableEntry { 10950, 0, 8447, 4, 1 }, // &supE;
    HTMLEntityTableEntry { 10942, 0, 10072, 6, 1 }, // &supdot;
    HTMLEntityTableEntry { 10968, 0, 10078, 7, 1 }, // &supdsub;
    HTMLEntityTableEntry { 8839, 0, 5373, 4, 1 }, // &supe;
    HTMLEntityTableEntry { 10948, 0, 10085, 7, 1 }, // &supedot;
    HTMLEntityTableEntry { 10185, 0, 10092, 7, 1 }, // &suphsol;
    HTMLEntityTableEntry { 10967, 0, 10099, 7, 1 }, // &suphsub;
    HTMLEntityTableEntry { 10619, 0, 10106, 7, 1 }, // &suplarr;
    HTMLEntityTableEntry { 10946, 0, 10113, 7, 1 }, // &supmult;
    HTMLEntityTableEntry { 10956, 0, 10120, 5, 1 }, // &supnE;
    HTMLEntityTableEntry { 8843, 0, 10125, 5, 1 }, // &supne;
    HTMLEntityTableEntry { 10944, 0, 10130, 7, 1 }, // &supplus;
    HTMLEntityTableEntry { 8835, 0, 8457, 6, 1 }, // &supset;
    HTMLEntityTableEntry { 8839, 0, 8457, 8, 1 }, // &supseteq;
    HTMLEntityTableEntry { 10950, 0, 8457, 9, 1 }, // &supseteqq;
    HTMLEntityTableEntry { 8843, 0, 10136, 9, 1 }, // &supsetneq;
    HTMLEntityTableEntry { 10956, 0, 10136, 10, 1 }, // &supsetneqq;
    HTMLEntityTableEntry { 10952, 0, 10146, 6, 1 }, // &supsim;
    HTMLEntityTableEntry { 10964, 0, 10152, 6, 1 }, // &supsub;
    HTMLEntityTableEntry { 10966, 0, 10158, 6, 1 }, // &supsup;
    HTMLEntityTableEntry { 8665, 0, 10164, 5, 1 }, // &swArr;
    HTMLEntityTableEntry { 10534, 0, 10169, 6, 1 }, // &swarhk;
    HTMLEntityTableEntry { 8601, 0, 10175, 5, 1 }, // &swarr;
    HTMLEntityTableEntry { 8601, 0, 10175, 7, 1 }, // &swarrow;
    HTMLEntityTableEntry { 10538, 0, 10182, 6, 1 }, // &swnwar;
    HTMLEntityTableEntry { 223, 0, 10188, 5, 0 }, // &szlig
    HTMLEntityTableEntry { 223, 0, 10188, 5, 1 }, // &szlig;
    HTMLEntityTableEntry { 8982, 0, 10193, 6, 1 }, // &target;
    HTMLEntityTableEntry { 964, 0, 10198, 3, 1 }, // &tau;
    HTMLEntityTableEntry { 9140, 0, 4502, 4, 1 }, // &tbrk;
    HTMLEntityTableEntry { 357, 0, 10201, 6, 1 }, // &tcaron;
    HTMLEntityTableEntry { 355, 0, 10207, 6, 1 }, // &tcedil;
    HTMLEntityTableEntry { 1090, 0, 5536, 3, 1 }, // &tcy;
    HTMLEntityTableEntry { 8411, 0, 5378, 4, 1 }, // &tdot;
    HTMLEntityTableEntry { 8981, 0, 10213, 6, 1 }, // &telrec;
    HTMLEntityTableEntry { 120113, 0, 6203, 3, 1 }, // &tfr;
    HTMLEntityTableEntry { 8756, 0, 10219, 6, 1 }, // &there4;
    HTMLEntityTableEntry { 8756, 0, 10225, 9, 1 }, // &therefore;
    HTMLEntityTableEntry { 952, 0, 10234, 5, 1 }, // &theta;
    HTMLEntityTableEntry { 977, 0, 10234, 8, 1 }, // &thetasym;
    HTMLEntityTableEntry { 977, 0, 10242, 6, 1 }, // &thetav;
    HTMLEntityTableEntry { 8776, 0, 10248, 11, 1 }, // &thickapprox;
    HTMLEntityTableEntry { 8764, 0, 10259, 8, 1 }, // &thicksim;
    HTMLEntityTableEntry { 8201, 0, 10267, 6, 1 }, // &thinsp;
    HTMLEntityTableEntry { 8776, 0, 10273, 5, 1 }, // &thkap;
    HTMLEntityTableEntry { 8764, 0, 10278, 6, 1 }, // &thksim;
    HTMLEntityTableEntry { 254, 0, 10284, 5, 0 }, // &thorn
    HTMLEntityTableEntry { 254, 0, 10284, 5, 1 }, // &thorn;
    HTMLEntityTableEntry { 732, 0, 88, 5, 1 }, // &tilde;
    HTMLEntityTableEntry { 215, 0, 3015, 5, 0 }, // &times
    HTMLEntityTableEntry { 215, 0, 3015, 5, 1 }, // &times;
    HTMLEntityTableEntry { 8864, 0, 4600, 6, 1 }, // &timesb;
    HTMLEntityTableEntry { 10801, 0, 10289, 8, 1 }, // &timesbar;
    HTMLEntityTableEntry { 10800, 0, 5676, 6, 1 }, // &timesd;
    HTMLEntityTableEntry { 8749, 0, 6200, 4, 1 }, // &tint;
    HTMLEntityTableEntry { 10536, 0, 10297, 4, 1 }, // &toea;
    HTMLEntityTableEntry { 8868, 0, 9060, 3, 1 }, // &top;
    HTMLEntityTableEntry { 9014, 0, 10301, 6, 1 }, // &topbot;
    HTMLEntityTableEntry { 10993, 0, 10306, 6, 1 }, // &topcir;
    HTMLEntityTableEntry { 120165, 0, 10312, 4, 1 }, // &topf;
    HTMLEntityTableEntry { 10970, 0, 10312, 7, 1 }, // &topfork;
    HTMLEntityTableEntry { 10537, 0, 10319, 4, 1 }, // &tosa;
    HTMLEntityTableEntry { 8244, 0, 10323, 6, 1 }, // &tprime;
    HTMLEntityTableEntry { 8482, 0, 10329, 5, 1 }, // &trade;
    HTMLEntityTableEntry { 9653, 0, 4623, 8, 1 }, // &triangle;
    HTMLEntityTableEntry { 9663, 0, 4623, 12, 1 }, // &triangledown;
    HTMLEntityTableEntry { 9667, 0, 4721, 12, 1 }, // &triangleleft;
    HTMLEntityTableEntry { 8884, 0, 8481, 14, 1 }, // &trianglelefteq;
    HTMLEntityTableEntry { 8796, 0, 10334, 9, 1 }, // &triangleq;
    HTMLEntityTableEntry { 9657, 0, 4738, 13, 1 }, // &triangleright;
    HTMLEntityTableEntry { 8885, 0, 8496, 15, 1 }, // &trianglerighteq;
    HTMLEntityTableEntry { 9708, 0, 10343, 6, 1 }, // &tridot;
    HTMLEntityTableEntry { 8796, 0, 7716, 4, 1 }, // &trie;
    HTMLEntityTableEntry { 10810, 0, 10348, 8, 1 }, // &triminus;
    HTMLEntityTableEntry { 10809, 0, 10356, 7, 1 }, // &triplus;
    HTMLEntityTableEntry { 10701, 0, 10363, 5, 1 }, // &trisb;
    HTMLEntityTableEntry { 10811, 0, 10368, 7, 1 }, // &tritime;
    HTMLEntityTableEntry { 9186, 0, 10375, 8, 1 }, // &trpezium;
    HTMLEntityTableEntry { 120009, 0, 10383, 4, 1 }, // &tscr;
    HTMLEntityTableEntry { 1094, 0, 10387, 4, 1 }, // &tscy;
    HTMLEntityTableEntry { 1115, 0, 10391, 5, 1 }, // &tshcy;
    HTMLEntityTableEntry { 359, 0, 10396, 6, 1 }, // &tstrok;
    HTMLEntityTableEntry { 8812, 0, 10402, 5, 1 }, // &twixt;
    HTMLEntityTableEntry { 8606, 0, 10406, 16, 1 }, // &twoheadleftarrow;
    HTMLEntityTableEntry { 8608, 0, 10422, 17, 1 }, // &twoheadrightarrow;
    HTMLEntityTableEntry { 8657, 0, 10439, 4, 1 }, // &uArr;
    HTMLEntityTableEntry { 10595, 0, 10443, 4, 1 }, // &uHar;
    HTMLEntityTableEntry { 250, 0, 10447, 6, 0 }, // &uacute
    HTMLEntityTableEntry { 250, 0, 10447, 6, 1 }, // &uacute;
    HTMLEntityTableEntry { 8593, 0, 5850, 4, 1 }, // &uarr;
    HTMLEntityTableEntry { 1118, 0, 10453, 5, 1 }, // &ubrcy;
    HTMLEntityTableEntry { 365, 0, 10458, 6, 1 }, // &ubreve;
    HTMLEntityTableEntry { 251, 0, 10464, 5, 0 }, // &ucirc
    HTMLEntityTableEntry { 251, 0, 10464, 5, 1 }, // &ucirc;
    HTMLEntityTableEntry { 1091, 0, 10469, 3, 1 }, // &ucy;
    HTMLEntityTableEntry { 8645, 0, 5383, 5, 1 }, // &udarr;
    HTMLEntityTableEntry { 369, 0, 10472, 6, 1 }, // &udblac;
    HTMLEntityTableEntry { 10606, 0, 10478, 5, 1 }, // &udhar;
    HTMLEntityTableEntry { 10622, 0, 10483, 6, 1 }, // &ufisht;
    HTMLEntityTableEntry { 120114, 0, 10489, 3, 1 }, // &ufr;
    HTMLEntityTableEntry { 249, 0, 10492, 6, 0 }, // &ugrave
    HTMLEntityTableEntry { 249, 0, 10492, 6, 1 }, // &ugrave;
    HTMLEntityTableEntry { 8639, 0, 7736, 5, 1 }, // &uharl;
    HTMLEntityTableEntry { 8638, 0, 10498, 5, 1 }, // &uharr;
    HTMLEntityTableEntry { 9600, 0, 10503, 5, 1 }, // &uhblk;
    HTMLEntityTableEntry { 8988, 0, 10508, 6, 1 }, // &ulcorn;
    HTMLEntityTableEntry { 8988, 0, 10508, 8, 1 }, // &ulcorner;
    HTMLEntityTableEntry { 8975, 0, 10516, 6, 1 }, // &ulcrop;
    HTMLEntityTableEntry { 9720, 0, 10522, 5, 1 }, // &ultri;
    HTMLEntityTableEntry { 363, 0, 10527, 5, 1 }, // &umacr;
    HTMLEntityTableEntry { 168, 0, 94, 3, 0 }, // &uml
    HTMLEntityTableEntry { 168, 0, 94, 3, 1 }, // &uml;
    HTMLEntityTableEntry { 371, 0, 10532, 5, 1 }, // &uogon;
    HTMLEntityTableEntry { 120166, 0, 10537, 4, 1 }, // &uopf;
    HTMLEntityTableEntry { 8593, 0, 10541, 7, 1 }, // &uparrow;
    HTMLEntityTableEntry { 8597, 0, 10548, 11, 1 }, // &updownarrow;
    HTMLEntityTableEntry { 8639, 0, 10559, 13, 1 }, // &upharpoonleft;
    HTMLEntityTableEntry { 8638, 0, 10572, 14, 1 }, // &upharpoonright;
    HTMLEntityTableEntry { 8846, 0, 4651, 5, 1 }, // &uplus;
    HTMLEntityTableEntry { 965, 0, 10147, 4, 1 }, // &upsi;
    HTMLEntityTableEntry { 978, 0, 10586, 5, 1 }, // &upsih;
    HTMLEntityTableEntry { 965, 0, 10591, 7, 1 }, // &upsilon;
    HTMLEntityTableEntry { 8648, 0, 10598, 10, 1 }, // &upuparrows;
    HTMLEntityTableEntry { 8989, 0, 10608, 6, 1 }, // &urcorn;
    HTMLEntityTableEntry { 8989, 0, 10608, 8, 1 }, // &urcorner;
    HTMLEntityTableEntry { 8974, 0, 10616, 6, 1 }, // &urcrop;
    HTMLEntityTableEntry { 367, 0, 10622, 5, 1 }, // &uring;
    HTMLEntityTableEntry { 9721, 0, 10627, 5, 1 }, // &urtri;
    HTMLEntityTableEntry { 120010, 0, 10632, 4, 1 }, // &uscr;
    HTMLEntityTableEntry { 8944, 0, 10636, 5, 1 }, // &utdot;
    HTMLEntityTableEntry { 361, 0, 10641, 6, 1 }, // &utilde;
    HTMLEntityTableEntry { 9653, 0, 10647, 4, 1 }, // &utri;
    HTMLEntityTableEntry { 9652, 0, 10647, 5, 1 }, // &utrif;
    HTMLEntityTableEntry { 8648, 0, 10652, 5, 1 }, // &uuarr;
    HTMLEntityTableEntry { 252, 0, 10657, 4, 0 }, // &uuml
    HTMLEntityTableEntry { 252, 0, 10657, 4, 1 }, // &uuml;
    HTMLEntityTableEntry { 10663, 0, 10661, 7, 1 }, // &uwangle;
    HTMLEntityTableEntry { 8661, 0, 10668, 4, 1 }, // &vArr;
    HTMLEntityTableEntry { 10984, 0, 109, 4, 1 }, // &vBar;
    HTMLEntityTableEntry { 10985, 0, 10672, 5, 1 }, // &vBarv;
    HTMLEntityTableEntry { 8872, 0, 8523, 5, 1 }, // &vDash;
    HTMLEntityTableEntry { 10652, 0, 10676, 6, 1 }, // &vangrt;
    HTMLEntityTableEntry { 1013, 0, 10682, 10, 1 }, // &varepsilon;
    HTMLEntityTableEntry { 1008, 0, 10692, 8, 1 }, // &varkappa;
    HTMLEntityTableEntry { 8709, 0, 10700, 10, 1 }, // &varnothing;
    HTMLEntityTableEntry { 981, 0, 10710, 6, 1 }, // &varphi;
    HTMLEntityTableEntry { 982, 0, 10716, 5, 1 }, // &varpi;
    HTMLEntityTableEntry { 8733, 0, 10721, 9, 1 }, // &varpropto;
    HTMLEntityTableEntry { 8597, 0, 10730, 4, 1 }, // &varr;
    HTMLEntityTableEntry { 1009, 0, 10730, 6, 1 }, // &varrho;
    HTMLEntityTableEntry { 962, 0, 10736, 8, 1 }, // &varsigma;
    HTMLEntityTableEntry { 8842, 65024, 10744, 12, 1 }, // &varsubsetneq;
    HTMLEntityTableEntry { 10955, 65024, 10744, 13, 1 }, // &varsubsetneqq;
    HTMLEntityTableEntry { 8843, 65024, 10757, 12, 1 }, // &varsupsetneq;
    HTMLEntityTableEntry { 10956, 65024, 10757, 13, 1 }, // &varsupsetneqq;
    HTMLEntityTableEntry { 977, 0, 10770, 8, 1 }, // &vartheta;
    HTMLEntityTableEntry { 8882, 0, 10778, 15, 1 }, // &vartriangleleft;
    HTMLEntityTableEntry { 8883, 0, 10793, 16, 1 }, // &vartriangleright;
    HTMLEntityTableEntry { 1074, 0, 10809, 3, 1 }, // &vcy;
    HTMLEntityTableEntry { 8866, 0, 4054, 5, 1 }, // &vdash;
    HTMLEntityTableEntry { 8744, 0, 4487, 3, 1 }, // &vee;
    HTMLEntityTableEntry { 8891, 0, 4487, 6, 1 }, // &veebar;
    HTMLEntityTableEntry { 8794, 0, 10812, 5, 1 }, // &veeeq;
    HTMLEntityTableEntry { 8942, 0, 10817, 6, 1 }, // &vellip;
    HTMLEntityTableEntry { 124, 0, 10823, 6, 1 }, // &verbar;
    HTMLEntityTableEntry { 124, 0, 6506, 4, 1 }, // &vert;
    HTMLEntityTableEntry { 120115, 0, 10829, 3, 1 }, // &vfr;
    HTMLEntityTableEntry { 8882, 0, 8569, 5, 1 }, // &vltri;
    HTMLEntityTableEntry { 8834, 8402, 10832, 5, 1 }, // &vnsub;
    HTMLEntityTableEntry { 8835, 8402, 10837, 5, 1 }, // &vnsup;
    HTMLEntityTableEntry { 120167, 0, 10842, 4, 1 }, // &vopf;
    HTMLEntityTableEntry { 8733, 0, 10846, 5, 1 }, // &vprop;
    HTMLEntityTableEntry { 8883, 0, 8582, 5, 1 }, // &vrtri;
    HTMLEntityTableEntry { 120011, 0, 10851, 4, 1 }, // &vscr;
    HTMLEntityTableEntry { 10955, 65024, 10855, 6, 1 }, // &vsubnE;
    HTMLEntityTableEntry { 8842, 65024, 10861, 6, 1 }, // &vsubne;
    HTMLEntityTableEntry { 10956, 65024, 10867, 6, 1 }, // &vsupnE;
    HTMLEntityTableEntry { 8843, 65024, 10873, 6, 1 }, // &vsupne;
    HTMLEntityTableEntry { 10650, 0, 10879, 7, 1 }, // &vzigzag;
    HTMLEntityTableEntry { 373, 0, 10886, 5, 1 }, // &wcirc;
    HTMLEntityTableEntry { 10847, 0, 10891, 6, 1 }, // &wedbar;
    HTMLEntityTableEntry { 8743, 0, 4493, 5, 1 }, // &wedge;
    HTMLEntityTableEntry { 8793, 0, 10897, 6, 1 }, // &wedgeq;
    HTMLEntityTableEntry { 8472, 0, 10903, 6, 1 }, // &weierp;
    HTMLEntityTableEntry { 120116, 0, 10909, 3, 1 }, // &wfr;
    HTMLEntityTableEntry { 120168, 0, 10912, 4, 1 }, // &wopf;
    HTMLEntityTableEntry { 8472, 0, 10916, 2, 1 }, // &wp;
    HTMLEntityTableEntry { 8768, 0, 5209, 2, 1 }, // &wr;
    HTMLEntityTableEntry { 8768, 0, 10918, 6, 1 }, // &wreath;
    HTMLEntityTableEntry { 120012, 0, 10924, 4, 1 }, // &wscr;
    HTMLEntityTableEntry { 8898, 0, 10928, 4, 1 }, // &xcap;
    HTMLEntityTableEntry { 9711, 0, 10932, 5, 1 }, // &xcirc;
    HTMLEntityTableEntry { 8899, 0, 10937, 4, 1 }, // &xcup;
    HTMLEntityTableEntry { 9661, 0, 10941, 5, 1 }, // &xdtri;
    HTMLEntityTableEntry { 120117, 0, 10946, 3, 1 }, // &xfr;
    HTMLEntityTableEntry { 10234, 0, 10949, 5, 1 }, // &xhArr;
    HTMLEntityTableEntry { 10231, 0, 10954, 5, 1 }, // &xharr;
    HTMLEntityTableEntry { 958, 0, 1122, 2, 1 }, // &xi;
    HTMLEntityTableEntry { 10232, 0, 10959, 5, 1 }, // &xlArr;
    HTMLEntityTableEntry { 10229, 0, 10964, 5, 1 }, // &xlarr;
    HTMLEntityTableEntry { 10236, 0, 10969, 4, 1 }, // &xmap;
    HTMLEntityTableEntry { 8955, 0, 10973, 4, 1 }, // &xnis;
    HTMLEntityTableEntry { 10752, 0, 10977, 5, 1 }, // &xodot;
    HTMLEntityTableEntry { 120169, 0, 10982, 4, 1 }, // &xopf;
    HTMLEntityTableEntry { 10753, 0, 10986, 6, 1 }, // &xoplus;
    HTMLEntityTableEntry { 10754, 0, 10992, 6, 1 }, // &xotime;
    HTMLEntityTableEntry { 10233, 0, 10998, 5, 1 }, // &xrArr;
    HTMLEntityTableEntry { 10230, 0, 11003, 5, 1 }, // &xrarr;
    HTMLEntityTableEntry { 120013, 0, 11008, 4, 1 }, // &xscr;
    HTMLEntityTableEntry { 10758, 0, 11012, 6, 1 }, // &xsqcup;
    HTMLEntityTableEntry { 10756, 0, 11018, 6, 1 }, // &xuplus;
    HTMLEntityTableEntry { 9651, 0, 11024, 5, 1 }, // &xutri;
    HTMLEntityTableEntry { 8897, 0, 11029, 4, 1 }, // &xvee;
    HTMLEntityTableEntry { 8896, 0, 11033, 6, 1 }, // &xwedge;
    HTMLEntityTableEntry { 253, 0, 11039, 6, 0 }, // &yacute
    HTMLEntityTableEntry { 253, 0, 11039, 6, 1 }, // &yacute;
    HTMLEntityTableEntry { 1103, 0, 11045, 4, 1 }, // &yacy;
    HTMLEntityTableEntry { 375, 0, 11048, 5, 1 }, // &ycirc;
    HTMLEntityTableEntry { 1099, 0, 11053, 3, 1 }, // &ycy;
    HTMLEntityTableEntry { 165, 0, 11055, 3, 0 }, // &yen
    HTMLEntityTableEntry { 165, 0, 11055, 3, 1 }, // &yen;
    HTMLEntityTableEntry { 120118, 0, 11058, 3, 1 }, // &yfr;
    HTMLEntityTableEntry { 1111, 0, 11061, 4, 1 }, // &yicy;
    HTMLEntityTableEntry { 120170, 0, 11064, 4, 1 }, // &yopf;
    HTMLEntityTableEntry { 120014, 0, 11068, 4, 1 }, // &yscr;
    HTMLEntityTableEntry { 1102, 0, 11072, 4, 1 }, // &yucy;
    HTMLEntityTableEntry { 255, 0, 11075, 4, 0 }, // &yuml
    HTMLEntityTableEntry { 255, 0, 11075, 4, 1 }, // &yuml;
    HTMLEntityTableEntry { 378, 0, 11079, 6, 1 }, // &zacute;
    HTMLEntityTableEntry { 382, 0, 11085, 6, 1 }, // &zcaron;
    HTMLEntityTableEntry { 1079, 0, 5867, 3, 1 }, // &zcy;
    HTMLEntityTableEntry { 380, 0, 11091, 4, 1 }, // &zdot;
    HTMLEntityTableEntry { 8488, 0, 11095, 6, 1 }, // &zeetrf;
    HTMLEntityTableEntry { 950, 0, 11101, 4, 1 }, // &zeta;
    HTMLEntityTableEntry { 120119, 0, 11105, 3, 1 }, // &zfr;
    HTMLEntityTableEntry { 1078, 0, 11108, 4, 1 }, // &zhcy;
    HTMLEntityTableEntry { 8669, 0, 5871, 7, 1 }, // &zigrarr;
    HTMLEntityTableEntry { 120171, 0, 11112, 4, 1 }, // &zopf;
    HTMLEntityTableEntry { 120015, 0, 11116, 4, 1 }, // &zscr;
    HTMLEntityTableEntry { 8205, 0, 11120, 3, 1 }, // &zwj;
    HTMLEntityTableEntry { 8204, 0, 11123, 4, 1 }, // &zwnj;
};

static constexpr auto uppercaseOffset = std::to_array<uint16_t>({
0,
27,
39,
75,
129,
159,
167,
189,
201,
230,
237,
245,
305,
314,
386,
415,
434,
439,
484,
524,
547,
587,
604,
609,
613,
624,
634
});

static constexpr auto lowercaseOffset = std::to_array<uint16_t>({
634,
703,
819,
918,
984,
1051,
1090,
1150,
1178,
1234,
1242,
1252,
1406,
1446,
1614,
1675,
1744,
1755,
1859,
2017,
2075,
2127,
2169,
2180,
2204,
2218,
2231
});

std::span<const char> HTMLEntityTableEntry::nameCharacters() const
{
    return staticEntityStringStorage.span().subspan(nameCharactersOffset);
}

std::span<const HTMLEntityTableEntry> HTMLEntityTable::entriesStartingWith(char16_t c)
{
    if (c >= 'A' && c <= 'Z') {
        auto* start = &staticEntityTable[uppercaseOffset[c - 'A']];
        return unsafeMakeSpan(start, &staticEntityTable[uppercaseOffset[c - 'A' + 1] - 1] - start + 1);
    }
    if (c >= 'a' && c <= 'z') {
        auto* start = &staticEntityTable[lowercaseOffset[c - 'a']];
        return unsafeMakeSpan(start, &staticEntityTable[lowercaseOffset[c - 'a' + 1] - 1] - start + 1);
    }
    return { };
}

std::span<const HTMLEntityTableEntry> HTMLEntityTable::entries()
{
    return staticEntityTable;
}

}

