/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSSVGElement.h"

#include "ActiveDOMObject.h"
#include "ContextDestructionObserverInlines.h"
#include "CustomElementReactionQueue.h"
#include "DocumentInlines.h"
#include "ElementInlines.h"
#include "EventNames.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "IDLTypes.h"
#include "JSCSSStyleProperties.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertBase.h"
#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertDictionary.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNullable.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMOperation.h"
#include "JSDOMStringMap.h"
#include "JSDOMWrapperCache.h"
#include "JSEventListener.h"
#include "JSFocusOptions.h"
#include "JSSVGAnimatedString.h"
#include "JSSVGElement.h"
#include "JSSVGSVGElement.h"
#include "JSStylePropertyMap.h"
#include "SVGNames.h"
#include "ScriptExecutionContext.h"
#include "Settings.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/text/MakeString.h>

namespace WebCore {
using namespace JSC;

// Functions

static JSC_DECLARE_HOST_FUNCTION(jsSVGElementPrototypeFunction_focus);
static JSC_DECLARE_HOST_FUNCTION(jsSVGElementPrototypeFunction_blur);

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsSVGElementConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsSVGElement_className);
static JSC_DECLARE_CUSTOM_GETTER(jsSVGElement_ownerSVGElement);
static JSC_DECLARE_CUSTOM_GETTER(jsSVGElement_viewportElement);
static JSC_DECLARE_CUSTOM_GETTER(jsSVGElement_style);
static JSC_DECLARE_CUSTOM_SETTER(setJSSVGElement_style);
static JSC_DECLARE_CUSTOM_GETTER(jsSVGElement_attributeStyleMap);
static JSC_DECLARE_CUSTOM_GETTER(jsSVGElement_onbeforecopy);
static JSC_DECLARE_CUSTOM_SETTER(setJSSVGElement_onbeforecopy);
static JSC_DECLARE_CUSTOM_GETTER(jsSVGElement_onbeforecut);
static JSC_DECLARE_CUSTOM_SETTER(setJSSVGElement_onbeforecut);
static JSC_DECLARE_CUSTOM_GETTER(jsSVGElement_onbeforepaste);
static JSC_DECLARE_CUSTOM_SETTER(setJSSVGElement_onbeforepaste);
static JSC_DECLARE_CUSTOM_GETTER(jsSVGElement_onabort);
static JSC_DECLARE_CUSTOM_SETTER(setJSSVGElement_onabort);
static JSC_DECLARE_CUSTOM_GETTER(jsSVGElement_onauxclick);
static JSC_DECLARE_CUSTOM_SETTER(setJSSVGElement_onauxclick);
static JSC_DECLARE_CUSTOM_GETTER(jsSVGElement_onbeforeinput);
static JSC_DECLARE_CUSTOM_SETTER(setJSSVGElement_onbeforeinput);
static JSC_DECLARE_CUSTOM_GETTER(jsSVGElement_onbeforematch);
static JSC_DECLARE_CUSTOM_SETTER(setJSSVGElement_onbeforematch);
static JSC_DECLARE_CUSTOM_GETTER(jsSVGElement_onbeforetoggle);
static JSC_DECLARE_CUSTOM_SETTER(setJSSVGElement_onbeforetoggle);
static JSC_DECLARE_CUSTOM_GETTER(jsSVGElement_onblur);
static JSC_DECLARE_CUSTOM_SETTER(setJSSVGElement_onblur);
static JSC_DECLARE_CUSTOM_GETTER(jsSVGElement_oncancel);
static JSC_DECLARE_CUSTOM_SETTER(setJSSVGElement_oncancel);
static JSC_DECLARE_CUSTOM_GETTER(jsSVGElement_oncanplay);
static JSC_DECLARE_CUSTOM_SETTER(setJSSVGElement_oncanplay);
static JSC_DECLARE_CUSTOM_GETTER(jsSVGElement_oncanplaythrough);
static JSC_DECLARE_CUSTOM_SETTER(setJSSVGElement_oncanplaythrough);
static JSC_DECLARE_CUSTOM_GETTER(jsSVGElement_onchange);
static JSC_DECLARE_CUSTOM_SETTER(setJSSVGElement_onchange);
static JSC_DECLARE_CUSTOM_GETTER(jsSVGElement_onclick);
static JSC_DECLARE_CUSTOM_SETTER(setJSSVGElement_onclick);
static JSC_DECLARE_CUSTOM_GETTER(jsSVGElement_onclose);
static JSC_DECLARE_CUSTOM_SETTER(setJSSVGElement_onclose);
static JSC_DECLARE_CUSTOM_GETTER(jsSVGElement_oncommand);
static JSC_DECLARE_CUSTOM_SETTER(setJSSVGElement_oncommand);
static JSC_DECLARE_CUSTOM_GETTER(jsSVGElement_oncontentvisibilityautostatechange);
static JSC_DECLARE_CUSTOM_SETTER(setJSSVGElement_oncontentvisibilityautostatechange);
static JSC_DECLARE_CUSTOM_GETTER(jsSVGElement_oncontextmenu);
static JSC_DECLARE_CUSTOM_SETTER(setJSSVGElement_oncontextmenu);
static JSC_DECLARE_CUSTOM_GETTER(jsSVGElement_oncopy);
static JSC_DECLARE_CUSTOM_SETTER(setJSSVGElement_oncopy);
static JSC_DECLARE_CUSTOM_GETTER(jsSVGElement_oncuechange);
static JSC_DECLARE_CUSTOM_SETTER(setJSSVGElement_oncuechange);
static JSC_DECLARE_CUSTOM_GETTER(jsSVGElement_oncut);
static JSC_DECLARE_CUSTOM_SETTER(setJSSVGElement_oncut);
static JSC_DECLARE_CUSTOM_GETTER(jsSVGElement_ondblclick);
static JSC_DECLARE_CUSTOM_SETTER(setJSSVGElement_ondblclick);
static JSC_DECLARE_CUSTOM_GETTER(jsSVGElement_ondrag);
static JSC_DECLARE_CUSTOM_SETTER(setJSSVGElement_ondrag);
static JSC_DECLARE_CUSTOM_GETTER(jsSVGElement_ondragend);
static JSC_DECLARE_CUSTOM_SETTER(setJSSVGElement_ondragend);
static JSC_DECLARE_CUSTOM_GETTER(jsSVGElement_ondragenter);
static JSC_DECLARE_CUSTOM_SETTER(setJSSVGElement_ondragenter);
static JSC_DECLARE_CUSTOM_GETTER(jsSVGElement_ondragleave);
static JSC_DECLARE_CUSTOM_SETTER(setJSSVGElement_ondragleave);
static JSC_DECLARE_CUSTOM_GETTER(jsSVGElement_ondragover);
static JSC_DECLARE_CUSTOM_SETTER(setJSSVGElement_ondragover);
static JSC_DECLARE_CUSTOM_GETTER(jsSVGElement_ondragstart);
static JSC_DECLARE_CUSTOM_SETTER(setJSSVGElement_ondragstart);
static JSC_DECLARE_CUSTOM_GETTER(jsSVGElement_ondrop);
static JSC_DECLARE_CUSTOM_SETTER(setJSSVGElement_ondrop);
static JSC_DECLARE_CUSTOM_GETTER(jsSVGElement_ondurationchange);
static JSC_DECLARE_CUSTOM_SETTER(setJSSVGElement_ondurationchange);
static JSC_DECLARE_CUSTOM_GETTER(jsSVGElement_onemptied);
static JSC_DECLARE_CUSTOM_SETTER(setJSSVGElement_onemptied);
static JSC_DECLARE_CUSTOM_GETTER(jsSVGElement_onended);
static JSC_DECLARE_CUSTOM_SETTER(setJSSVGElement_onended);
static JSC_DECLARE_CUSTOM_GETTER(jsSVGElement_onerror);
static JSC_DECLARE_CUSTOM_SETTER(setJSSVGElement_onerror);
static JSC_DECLARE_CUSTOM_GETTER(jsSVGElement_onfocus);
static JSC_DECLARE_CUSTOM_SETTER(setJSSVGElement_onfocus);
static JSC_DECLARE_CUSTOM_GETTER(jsSVGElement_onformdata);
static JSC_DECLARE_CUSTOM_SETTER(setJSSVGElement_onformdata);
static JSC_DECLARE_CUSTOM_GETTER(jsSVGElement_oninput);
static JSC_DECLARE_CUSTOM_SETTER(setJSSVGElement_oninput);
static JSC_DECLARE_CUSTOM_GETTER(jsSVGElement_oninvalid);
static JSC_DECLARE_CUSTOM_SETTER(setJSSVGElement_oninvalid);
static JSC_DECLARE_CUSTOM_GETTER(jsSVGElement_onkeydown);
static JSC_DECLARE_CUSTOM_SETTER(setJSSVGElement_onkeydown);
static JSC_DECLARE_CUSTOM_GETTER(jsSVGElement_onkeypress);
static JSC_DECLARE_CUSTOM_SETTER(setJSSVGElement_onkeypress);
static JSC_DECLARE_CUSTOM_GETTER(jsSVGElement_onkeyup);
static JSC_DECLARE_CUSTOM_SETTER(setJSSVGElement_onkeyup);
static JSC_DECLARE_CUSTOM_GETTER(jsSVGElement_onload);
static JSC_DECLARE_CUSTOM_SETTER(setJSSVGElement_onload);
static JSC_DECLARE_CUSTOM_GETTER(jsSVGElement_onloadeddata);
static JSC_DECLARE_CUSTOM_SETTER(setJSSVGElement_onloadeddata);
static JSC_DECLARE_CUSTOM_GETTER(jsSVGElement_onloadedmetadata);
static JSC_DECLARE_CUSTOM_SETTER(setJSSVGElement_onloadedmetadata);
static JSC_DECLARE_CUSTOM_GETTER(jsSVGElement_onloadstart);
static JSC_DECLARE_CUSTOM_SETTER(setJSSVGElement_onloadstart);
static JSC_DECLARE_CUSTOM_GETTER(jsSVGElement_onmousedown);
static JSC_DECLARE_CUSTOM_SETTER(setJSSVGElement_onmousedown);
static JSC_DECLARE_CUSTOM_GETTER(jsSVGElement_onmouseenter);
static JSC_DECLARE_CUSTOM_SETTER(setJSSVGElement_onmouseenter);
static JSC_DECLARE_CUSTOM_GETTER(jsSVGElement_onmouseleave);
static JSC_DECLARE_CUSTOM_SETTER(setJSSVGElement_onmouseleave);
static JSC_DECLARE_CUSTOM_GETTER(jsSVGElement_onmousemove);
static JSC_DECLARE_CUSTOM_SETTER(setJSSVGElement_onmousemove);
static JSC_DECLARE_CUSTOM_GETTER(jsSVGElement_onmouseout);
static JSC_DECLARE_CUSTOM_SETTER(setJSSVGElement_onmouseout);
static JSC_DECLARE_CUSTOM_GETTER(jsSVGElement_onmouseover);
static JSC_DECLARE_CUSTOM_SETTER(setJSSVGElement_onmouseover);
static JSC_DECLARE_CUSTOM_GETTER(jsSVGElement_onmouseup);
static JSC_DECLARE_CUSTOM_SETTER(setJSSVGElement_onmouseup);
static JSC_DECLARE_CUSTOM_GETTER(jsSVGElement_onpaste);
static JSC_DECLARE_CUSTOM_SETTER(setJSSVGElement_onpaste);
static JSC_DECLARE_CUSTOM_GETTER(jsSVGElement_onpause);
static JSC_DECLARE_CUSTOM_SETTER(setJSSVGElement_onpause);
static JSC_DECLARE_CUSTOM_GETTER(jsSVGElement_onplay);
static JSC_DECLARE_CUSTOM_SETTER(setJSSVGElement_onplay);
static JSC_DECLARE_CUSTOM_GETTER(jsSVGElement_onplaying);
static JSC_DECLARE_CUSTOM_SETTER(setJSSVGElement_onplaying);
static JSC_DECLARE_CUSTOM_GETTER(jsSVGElement_onprogress);
static JSC_DECLARE_CUSTOM_SETTER(setJSSVGElement_onprogress);
static JSC_DECLARE_CUSTOM_GETTER(jsSVGElement_onratechange);
static JSC_DECLARE_CUSTOM_SETTER(setJSSVGElement_onratechange);
static JSC_DECLARE_CUSTOM_GETTER(jsSVGElement_onreset);
static JSC_DECLARE_CUSTOM_SETTER(setJSSVGElement_onreset);
static JSC_DECLARE_CUSTOM_GETTER(jsSVGElement_onresize);
static JSC_DECLARE_CUSTOM_SETTER(setJSSVGElement_onresize);
static JSC_DECLARE_CUSTOM_GETTER(jsSVGElement_onscroll);
static JSC_DECLARE_CUSTOM_SETTER(setJSSVGElement_onscroll);
static JSC_DECLARE_CUSTOM_GETTER(jsSVGElement_onscrollend);
static JSC_DECLARE_CUSTOM_SETTER(setJSSVGElement_onscrollend);
static JSC_DECLARE_CUSTOM_GETTER(jsSVGElement_onsecuritypolicyviolation);
static JSC_DECLARE_CUSTOM_SETTER(setJSSVGElement_onsecuritypolicyviolation);
static JSC_DECLARE_CUSTOM_GETTER(jsSVGElement_onseeked);
static JSC_DECLARE_CUSTOM_SETTER(setJSSVGElement_onseeked);
static JSC_DECLARE_CUSTOM_GETTER(jsSVGElement_onseeking);
static JSC_DECLARE_CUSTOM_SETTER(setJSSVGElement_onseeking);
static JSC_DECLARE_CUSTOM_GETTER(jsSVGElement_onselect);
static JSC_DECLARE_CUSTOM_SETTER(setJSSVGElement_onselect);
static JSC_DECLARE_CUSTOM_GETTER(jsSVGElement_onslotchange);
static JSC_DECLARE_CUSTOM_SETTER(setJSSVGElement_onslotchange);
static JSC_DECLARE_CUSTOM_GETTER(jsSVGElement_onstalled);
static JSC_DECLARE_CUSTOM_SETTER(setJSSVGElement_onstalled);
static JSC_DECLARE_CUSTOM_GETTER(jsSVGElement_onsubmit);
static JSC_DECLARE_CUSTOM_SETTER(setJSSVGElement_onsubmit);
static JSC_DECLARE_CUSTOM_GETTER(jsSVGElement_onsuspend);
static JSC_DECLARE_CUSTOM_SETTER(setJSSVGElement_onsuspend);
static JSC_DECLARE_CUSTOM_GETTER(jsSVGElement_ontimeupdate);
static JSC_DECLARE_CUSTOM_SETTER(setJSSVGElement_ontimeupdate);
static JSC_DECLARE_CUSTOM_GETTER(jsSVGElement_ontoggle);
static JSC_DECLARE_CUSTOM_SETTER(setJSSVGElement_ontoggle);
static JSC_DECLARE_CUSTOM_GETTER(jsSVGElement_onvolumechange);
static JSC_DECLARE_CUSTOM_SETTER(setJSSVGElement_onvolumechange);
static JSC_DECLARE_CUSTOM_GETTER(jsSVGElement_onwaiting);
static JSC_DECLARE_CUSTOM_SETTER(setJSSVGElement_onwaiting);
static JSC_DECLARE_CUSTOM_GETTER(jsSVGElement_onwebkitanimationend);
static JSC_DECLARE_CUSTOM_SETTER(setJSSVGElement_onwebkitanimationend);
static JSC_DECLARE_CUSTOM_GETTER(jsSVGElement_onwebkitanimationiteration);
static JSC_DECLARE_CUSTOM_SETTER(setJSSVGElement_onwebkitanimationiteration);
static JSC_DECLARE_CUSTOM_GETTER(jsSVGElement_onwebkitanimationstart);
static JSC_DECLARE_CUSTOM_SETTER(setJSSVGElement_onwebkitanimationstart);
static JSC_DECLARE_CUSTOM_GETTER(jsSVGElement_onwebkittransitionend);
static JSC_DECLARE_CUSTOM_SETTER(setJSSVGElement_onwebkittransitionend);
static JSC_DECLARE_CUSTOM_GETTER(jsSVGElement_onwheel);
static JSC_DECLARE_CUSTOM_SETTER(setJSSVGElement_onwheel);
static JSC_DECLARE_CUSTOM_GETTER(jsSVGElement_onmousewheel);
static JSC_DECLARE_CUSTOM_SETTER(setJSSVGElement_onmousewheel);
#if ENABLE(TOUCH_EVENTS)
static JSC_DECLARE_CUSTOM_GETTER(jsSVGElement_ontouchcancel);
static JSC_DECLARE_CUSTOM_SETTER(setJSSVGElement_ontouchcancel);
#endif
#if ENABLE(TOUCH_EVENTS)
static JSC_DECLARE_CUSTOM_GETTER(jsSVGElement_ontouchend);
static JSC_DECLARE_CUSTOM_SETTER(setJSSVGElement_ontouchend);
#endif
#if ENABLE(TOUCH_EVENTS)
static JSC_DECLARE_CUSTOM_GETTER(jsSVGElement_ontouchmove);
static JSC_DECLARE_CUSTOM_SETTER(setJSSVGElement_ontouchmove);
#endif
#if ENABLE(TOUCH_EVENTS)
static JSC_DECLARE_CUSTOM_GETTER(jsSVGElement_ontouchstart);
static JSC_DECLARE_CUSTOM_SETTER(setJSSVGElement_ontouchstart);
#endif
#if ENABLE(TOUCH_EVENTS)
static JSC_DECLARE_CUSTOM_GETTER(jsSVGElement_ontouchforcechange);
static JSC_DECLARE_CUSTOM_SETTER(setJSSVGElement_ontouchforcechange);
#endif
static JSC_DECLARE_CUSTOM_GETTER(jsSVGElement_onwebkitmouseforcechanged);
static JSC_DECLARE_CUSTOM_SETTER(setJSSVGElement_onwebkitmouseforcechanged);
static JSC_DECLARE_CUSTOM_GETTER(jsSVGElement_onwebkitmouseforcedown);
static JSC_DECLARE_CUSTOM_SETTER(setJSSVGElement_onwebkitmouseforcedown);
static JSC_DECLARE_CUSTOM_GETTER(jsSVGElement_onwebkitmouseforcewillbegin);
static JSC_DECLARE_CUSTOM_SETTER(setJSSVGElement_onwebkitmouseforcewillbegin);
static JSC_DECLARE_CUSTOM_GETTER(jsSVGElement_onwebkitmouseforceup);
static JSC_DECLARE_CUSTOM_SETTER(setJSSVGElement_onwebkitmouseforceup);
static JSC_DECLARE_CUSTOM_GETTER(jsSVGElement_onanimationstart);
static JSC_DECLARE_CUSTOM_SETTER(setJSSVGElement_onanimationstart);
static JSC_DECLARE_CUSTOM_GETTER(jsSVGElement_onanimationiteration);
static JSC_DECLARE_CUSTOM_SETTER(setJSSVGElement_onanimationiteration);
static JSC_DECLARE_CUSTOM_GETTER(jsSVGElement_onanimationend);
static JSC_DECLARE_CUSTOM_SETTER(setJSSVGElement_onanimationend);
static JSC_DECLARE_CUSTOM_GETTER(jsSVGElement_onanimationcancel);
static JSC_DECLARE_CUSTOM_SETTER(setJSSVGElement_onanimationcancel);
static JSC_DECLARE_CUSTOM_GETTER(jsSVGElement_ontransitionrun);
static JSC_DECLARE_CUSTOM_SETTER(setJSSVGElement_ontransitionrun);
static JSC_DECLARE_CUSTOM_GETTER(jsSVGElement_ontransitionstart);
static JSC_DECLARE_CUSTOM_SETTER(setJSSVGElement_ontransitionstart);
static JSC_DECLARE_CUSTOM_GETTER(jsSVGElement_ontransitionend);
static JSC_DECLARE_CUSTOM_SETTER(setJSSVGElement_ontransitionend);
static JSC_DECLARE_CUSTOM_GETTER(jsSVGElement_ontransitioncancel);
static JSC_DECLARE_CUSTOM_SETTER(setJSSVGElement_ontransitioncancel);
static JSC_DECLARE_CUSTOM_GETTER(jsSVGElement_ongotpointercapture);
static JSC_DECLARE_CUSTOM_SETTER(setJSSVGElement_ongotpointercapture);
static JSC_DECLARE_CUSTOM_GETTER(jsSVGElement_onlostpointercapture);
static JSC_DECLARE_CUSTOM_SETTER(setJSSVGElement_onlostpointercapture);
static JSC_DECLARE_CUSTOM_GETTER(jsSVGElement_onpointerdown);
static JSC_DECLARE_CUSTOM_SETTER(setJSSVGElement_onpointerdown);
static JSC_DECLARE_CUSTOM_GETTER(jsSVGElement_onpointermove);
static JSC_DECLARE_CUSTOM_SETTER(setJSSVGElement_onpointermove);
static JSC_DECLARE_CUSTOM_GETTER(jsSVGElement_onpointerup);
static JSC_DECLARE_CUSTOM_SETTER(setJSSVGElement_onpointerup);
static JSC_DECLARE_CUSTOM_GETTER(jsSVGElement_onpointercancel);
static JSC_DECLARE_CUSTOM_SETTER(setJSSVGElement_onpointercancel);
static JSC_DECLARE_CUSTOM_GETTER(jsSVGElement_onpointerover);
static JSC_DECLARE_CUSTOM_SETTER(setJSSVGElement_onpointerover);
static JSC_DECLARE_CUSTOM_GETTER(jsSVGElement_onpointerout);
static JSC_DECLARE_CUSTOM_SETTER(setJSSVGElement_onpointerout);
static JSC_DECLARE_CUSTOM_GETTER(jsSVGElement_onpointerenter);
static JSC_DECLARE_CUSTOM_SETTER(setJSSVGElement_onpointerenter);
static JSC_DECLARE_CUSTOM_GETTER(jsSVGElement_onpointerleave);
static JSC_DECLARE_CUSTOM_SETTER(setJSSVGElement_onpointerleave);
static JSC_DECLARE_CUSTOM_GETTER(jsSVGElement_onselectstart);
static JSC_DECLARE_CUSTOM_SETTER(setJSSVGElement_onselectstart);
static JSC_DECLARE_CUSTOM_GETTER(jsSVGElement_onselectionchange);
static JSC_DECLARE_CUSTOM_SETTER(setJSSVGElement_onselectionchange);
static JSC_DECLARE_CUSTOM_GETTER(jsSVGElement_dataset);
static JSC_DECLARE_CUSTOM_GETTER(jsSVGElement_nonce);
static JSC_DECLARE_CUSTOM_SETTER(setJSSVGElement_nonce);
static JSC_DECLARE_CUSTOM_GETTER(jsSVGElement_autofocus);
static JSC_DECLARE_CUSTOM_SETTER(setJSSVGElement_autofocus);
static JSC_DECLARE_CUSTOM_GETTER(jsSVGElement_tabIndex);
static JSC_DECLARE_CUSTOM_SETTER(setJSSVGElement_tabIndex);

class JSSVGElementPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSSVGElementPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSSVGElementPrototype* ptr = new (NotNull, JSC::allocateCell<JSSVGElementPrototype>(vm)) JSSVGElementPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSSVGElementPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSSVGElementPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSSVGElementPrototype, JSSVGElementPrototype::Base);

using JSSVGElementDOMConstructor = JSDOMConstructorNotConstructable<JSSVGElement>;

template<> const ClassInfo JSSVGElementDOMConstructor::s_info = { "SVGElement"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSSVGElementDOMConstructor) };

template<> JSValue JSSVGElementDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSElement::getConstructor(vm, &globalObject);
}

template<> void JSSVGElementDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "SVGElement"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSSVGElement::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const std::array<HashTableValue, 120> JSSVGElementPrototypeTableValues {
    HashTableValue { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsSVGElementConstructor, 0 } },
    HashTableValue { "className"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSVGElement_className, 0 } },
    HashTableValue { "ownerSVGElement"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSVGElement_ownerSVGElement, 0 } },
    HashTableValue { "viewportElement"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSVGElement_viewportElement, 0 } },
    HashTableValue { "style"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSVGElement_style, setJSSVGElement_style } },
    HashTableValue { "attributeStyleMap"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSVGElement_attributeStyleMap, 0 } },
    HashTableValue { "onbeforecopy"_s, JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSVGElement_onbeforecopy, setJSSVGElement_onbeforecopy } },
    HashTableValue { "onbeforecut"_s, JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSVGElement_onbeforecut, setJSSVGElement_onbeforecut } },
    HashTableValue { "onbeforepaste"_s, JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSVGElement_onbeforepaste, setJSSVGElement_onbeforepaste } },
    HashTableValue { "onabort"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSVGElement_onabort, setJSSVGElement_onabort } },
    HashTableValue { "onauxclick"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSVGElement_onauxclick, setJSSVGElement_onauxclick } },
    HashTableValue { "onbeforeinput"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSVGElement_onbeforeinput, setJSSVGElement_onbeforeinput } },
    HashTableValue { "onbeforematch"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSVGElement_onbeforematch, setJSSVGElement_onbeforematch } },
    HashTableValue { "onbeforetoggle"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSVGElement_onbeforetoggle, setJSSVGElement_onbeforetoggle } },
    HashTableValue { "onblur"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSVGElement_onblur, setJSSVGElement_onblur } },
    HashTableValue { "oncancel"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSVGElement_oncancel, setJSSVGElement_oncancel } },
    HashTableValue { "oncanplay"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSVGElement_oncanplay, setJSSVGElement_oncanplay } },
    HashTableValue { "oncanplaythrough"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSVGElement_oncanplaythrough, setJSSVGElement_oncanplaythrough } },
    HashTableValue { "onchange"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSVGElement_onchange, setJSSVGElement_onchange } },
    HashTableValue { "onclick"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSVGElement_onclick, setJSSVGElement_onclick } },
    HashTableValue { "onclose"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSVGElement_onclose, setJSSVGElement_onclose } },
    HashTableValue { "oncommand"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSVGElement_oncommand, setJSSVGElement_oncommand } },
    HashTableValue { "oncontentvisibilityautostatechange"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSVGElement_oncontentvisibilityautostatechange, setJSSVGElement_oncontentvisibilityautostatechange } },
    HashTableValue { "oncontextmenu"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSVGElement_oncontextmenu, setJSSVGElement_oncontextmenu } },
    HashTableValue { "oncopy"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSVGElement_oncopy, setJSSVGElement_oncopy } },
    HashTableValue { "oncuechange"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSVGElement_oncuechange, setJSSVGElement_oncuechange } },
    HashTableValue { "oncut"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSVGElement_oncut, setJSSVGElement_oncut } },
    HashTableValue { "ondblclick"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSVGElement_ondblclick, setJSSVGElement_ondblclick } },
    HashTableValue { "ondrag"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSVGElement_ondrag, setJSSVGElement_ondrag } },
    HashTableValue { "ondragend"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSVGElement_ondragend, setJSSVGElement_ondragend } },
    HashTableValue { "ondragenter"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSVGElement_ondragenter, setJSSVGElement_ondragenter } },
    HashTableValue { "ondragleave"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSVGElement_ondragleave, setJSSVGElement_ondragleave } },
    HashTableValue { "ondragover"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSVGElement_ondragover, setJSSVGElement_ondragover } },
    HashTableValue { "ondragstart"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSVGElement_ondragstart, setJSSVGElement_ondragstart } },
    HashTableValue { "ondrop"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSVGElement_ondrop, setJSSVGElement_ondrop } },
    HashTableValue { "ondurationchange"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSVGElement_ondurationchange, setJSSVGElement_ondurationchange } },
    HashTableValue { "onemptied"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSVGElement_onemptied, setJSSVGElement_onemptied } },
    HashTableValue { "onended"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSVGElement_onended, setJSSVGElement_onended } },
    HashTableValue { "onerror"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSVGElement_onerror, setJSSVGElement_onerror } },
    HashTableValue { "onfocus"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSVGElement_onfocus, setJSSVGElement_onfocus } },
    HashTableValue { "onformdata"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSVGElement_onformdata, setJSSVGElement_onformdata } },
    HashTableValue { "oninput"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSVGElement_oninput, setJSSVGElement_oninput } },
    HashTableValue { "oninvalid"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSVGElement_oninvalid, setJSSVGElement_oninvalid } },
    HashTableValue { "onkeydown"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSVGElement_onkeydown, setJSSVGElement_onkeydown } },
    HashTableValue { "onkeypress"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSVGElement_onkeypress, setJSSVGElement_onkeypress } },
    HashTableValue { "onkeyup"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSVGElement_onkeyup, setJSSVGElement_onkeyup } },
    HashTableValue { "onload"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSVGElement_onload, setJSSVGElement_onload } },
    HashTableValue { "onloadeddata"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSVGElement_onloadeddata, setJSSVGElement_onloadeddata } },
    HashTableValue { "onloadedmetadata"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSVGElement_onloadedmetadata, setJSSVGElement_onloadedmetadata } },
    HashTableValue { "onloadstart"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSVGElement_onloadstart, setJSSVGElement_onloadstart } },
    HashTableValue { "onmousedown"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSVGElement_onmousedown, setJSSVGElement_onmousedown } },
    HashTableValue { "onmouseenter"_s, static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor), NoIntrinsic, { HashTableValue::GetterSetterType, jsSVGElement_onmouseenter, setJSSVGElement_onmouseenter } },
    HashTableValue { "onmouseleave"_s, static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor), NoIntrinsic, { HashTableValue::GetterSetterType, jsSVGElement_onmouseleave, setJSSVGElement_onmouseleave } },
    HashTableValue { "onmousemove"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSVGElement_onmousemove, setJSSVGElement_onmousemove } },
    HashTableValue { "onmouseout"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSVGElement_onmouseout, setJSSVGElement_onmouseout } },
    HashTableValue { "onmouseover"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSVGElement_onmouseover, setJSSVGElement_onmouseover } },
    HashTableValue { "onmouseup"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSVGElement_onmouseup, setJSSVGElement_onmouseup } },
    HashTableValue { "onpaste"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSVGElement_onpaste, setJSSVGElement_onpaste } },
    HashTableValue { "onpause"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSVGElement_onpause, setJSSVGElement_onpause } },
    HashTableValue { "onplay"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSVGElement_onplay, setJSSVGElement_onplay } },
    HashTableValue { "onplaying"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSVGElement_onplaying, setJSSVGElement_onplaying } },
    HashTableValue { "onprogress"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSVGElement_onprogress, setJSSVGElement_onprogress } },
    HashTableValue { "onratechange"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSVGElement_onratechange, setJSSVGElement_onratechange } },
    HashTableValue { "onreset"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSVGElement_onreset, setJSSVGElement_onreset } },
    HashTableValue { "onresize"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSVGElement_onresize, setJSSVGElement_onresize } },
    HashTableValue { "onscroll"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSVGElement_onscroll, setJSSVGElement_onscroll } },
    HashTableValue { "onscrollend"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSVGElement_onscrollend, setJSSVGElement_onscrollend } },
    HashTableValue { "onsecuritypolicyviolation"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSVGElement_onsecuritypolicyviolation, setJSSVGElement_onsecuritypolicyviolation } },
    HashTableValue { "onseeked"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSVGElement_onseeked, setJSSVGElement_onseeked } },
    HashTableValue { "onseeking"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSVGElement_onseeking, setJSSVGElement_onseeking } },
    HashTableValue { "onselect"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSVGElement_onselect, setJSSVGElement_onselect } },
    HashTableValue { "onslotchange"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSVGElement_onslotchange, setJSSVGElement_onslotchange } },
    HashTableValue { "onstalled"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSVGElement_onstalled, setJSSVGElement_onstalled } },
    HashTableValue { "onsubmit"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSVGElement_onsubmit, setJSSVGElement_onsubmit } },
    HashTableValue { "onsuspend"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSVGElement_onsuspend, setJSSVGElement_onsuspend } },
    HashTableValue { "ontimeupdate"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSVGElement_ontimeupdate, setJSSVGElement_ontimeupdate } },
    HashTableValue { "ontoggle"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSVGElement_ontoggle, setJSSVGElement_ontoggle } },
    HashTableValue { "onvolumechange"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSVGElement_onvolumechange, setJSSVGElement_onvolumechange } },
    HashTableValue { "onwaiting"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSVGElement_onwaiting, setJSSVGElement_onwaiting } },
    HashTableValue { "onwebkitanimationend"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSVGElement_onwebkitanimationend, setJSSVGElement_onwebkitanimationend } },
    HashTableValue { "onwebkitanimationiteration"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSVGElement_onwebkitanimationiteration, setJSSVGElement_onwebkitanimationiteration } },
    HashTableValue { "onwebkitanimationstart"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSVGElement_onwebkitanimationstart, setJSSVGElement_onwebkitanimationstart } },
    HashTableValue { "onwebkittransitionend"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSVGElement_onwebkittransitionend, setJSSVGElement_onwebkittransitionend } },
    HashTableValue { "onwheel"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSVGElement_onwheel, setJSSVGElement_onwheel } },
    HashTableValue { "onmousewheel"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSVGElement_onmousewheel, setJSSVGElement_onmousewheel } },
#if ENABLE(TOUCH_EVENTS)
    HashTableValue { "ontouchcancel"_s, JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSVGElement_ontouchcancel, setJSSVGElement_ontouchcancel } },
#else
    HashTableValue { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(TOUCH_EVENTS)
    HashTableValue { "ontouchend"_s, JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSVGElement_ontouchend, setJSSVGElement_ontouchend } },
#else
    HashTableValue { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(TOUCH_EVENTS)
    HashTableValue { "ontouchmove"_s, JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSVGElement_ontouchmove, setJSSVGElement_ontouchmove } },
#else
    HashTableValue { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(TOUCH_EVENTS)
    HashTableValue { "ontouchstart"_s, JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSVGElement_ontouchstart, setJSSVGElement_ontouchstart } },
#else
    HashTableValue { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(TOUCH_EVENTS)
    HashTableValue { "ontouchforcechange"_s, JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSVGElement_ontouchforcechange, setJSSVGElement_ontouchforcechange } },
#else
    HashTableValue { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
    HashTableValue { "onwebkitmouseforcechanged"_s, JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSVGElement_onwebkitmouseforcechanged, setJSSVGElement_onwebkitmouseforcechanged } },
    HashTableValue { "onwebkitmouseforcedown"_s, JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSVGElement_onwebkitmouseforcedown, setJSSVGElement_onwebkitmouseforcedown } },
    HashTableValue { "onwebkitmouseforcewillbegin"_s, JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSVGElement_onwebkitmouseforcewillbegin, setJSSVGElement_onwebkitmouseforcewillbegin } },
    HashTableValue { "onwebkitmouseforceup"_s, JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSVGElement_onwebkitmouseforceup, setJSSVGElement_onwebkitmouseforceup } },
    HashTableValue { "onanimationstart"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSVGElement_onanimationstart, setJSSVGElement_onanimationstart } },
    HashTableValue { "onanimationiteration"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSVGElement_onanimationiteration, setJSSVGElement_onanimationiteration } },
    HashTableValue { "onanimationend"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSVGElement_onanimationend, setJSSVGElement_onanimationend } },
    HashTableValue { "onanimationcancel"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSVGElement_onanimationcancel, setJSSVGElement_onanimationcancel } },
    HashTableValue { "ontransitionrun"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSVGElement_ontransitionrun, setJSSVGElement_ontransitionrun } },
    HashTableValue { "ontransitionstart"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSVGElement_ontransitionstart, setJSSVGElement_ontransitionstart } },
    HashTableValue { "ontransitionend"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSVGElement_ontransitionend, setJSSVGElement_ontransitionend } },
    HashTableValue { "ontransitioncancel"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSVGElement_ontransitioncancel, setJSSVGElement_ontransitioncancel } },
    HashTableValue { "ongotpointercapture"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSVGElement_ongotpointercapture, setJSSVGElement_ongotpointercapture } },
    HashTableValue { "onlostpointercapture"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSVGElement_onlostpointercapture, setJSSVGElement_onlostpointercapture } },
    HashTableValue { "onpointerdown"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSVGElement_onpointerdown, setJSSVGElement_onpointerdown } },
    HashTableValue { "onpointermove"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSVGElement_onpointermove, setJSSVGElement_onpointermove } },
    HashTableValue { "onpointerup"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSVGElement_onpointerup, setJSSVGElement_onpointerup } },
    HashTableValue { "onpointercancel"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSVGElement_onpointercancel, setJSSVGElement_onpointercancel } },
    HashTableValue { "onpointerover"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSVGElement_onpointerover, setJSSVGElement_onpointerover } },
    HashTableValue { "onpointerout"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSVGElement_onpointerout, setJSSVGElement_onpointerout } },
    HashTableValue { "onpointerenter"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSVGElement_onpointerenter, setJSSVGElement_onpointerenter } },
    HashTableValue { "onpointerleave"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSVGElement_onpointerleave, setJSSVGElement_onpointerleave } },
    HashTableValue { "onselectstart"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSVGElement_onselectstart, setJSSVGElement_onselectstart } },
    HashTableValue { "onselectionchange"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSVGElement_onselectionchange, setJSSVGElement_onselectionchange } },
    HashTableValue { "dataset"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSVGElement_dataset, 0 } },
    HashTableValue { "nonce"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSVGElement_nonce, setJSSVGElement_nonce } },
    HashTableValue { "autofocus"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSVGElement_autofocus, setJSSVGElement_autofocus } },
    HashTableValue { "tabIndex"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSVGElement_tabIndex, setJSSVGElement_tabIndex } },
    HashTableValue { "focus"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsSVGElementPrototypeFunction_focus, 0 } },
    HashTableValue { "blur"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsSVGElementPrototypeFunction_blur, 0 } },
};

const ClassInfo JSSVGElementPrototype::s_info = { "SVGElement"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSSVGElementPrototype) };

void JSSVGElementPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSSVGElement::info(), JSSVGElementPrototypeTableValues, *this);
    bool hasDisabledRuntimeProperties = false;
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().hiddenUntilFoundEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "onbeforematch"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().commandAttributesEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "oncommand"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().scrollendEventEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "onscrollend"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
#if ENABLE(TOUCH_EVENTS)
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().touchEventDOMAttributesEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "ontouchcancel"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
#endif
#if ENABLE(TOUCH_EVENTS)
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().touchEventDOMAttributesEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "ontouchend"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
#endif
#if ENABLE(TOUCH_EVENTS)
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().touchEventDOMAttributesEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "ontouchmove"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
#endif
#if ENABLE(TOUCH_EVENTS)
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().touchEventDOMAttributesEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "ontouchstart"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
#endif
#if ENABLE(TOUCH_EVENTS)
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().touchEventDOMAttributesEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "ontouchforcechange"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
#endif
    if (hasDisabledRuntimeProperties && structure()->isDictionary())
        flattenDictionaryObject(vm);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSSVGElement::s_info = { "SVGElement"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSSVGElement) };

JSSVGElement::JSSVGElement(Structure* structure, JSDOMGlobalObject& globalObject, Ref<SVGElement>&& impl)
    : JSElement(structure, globalObject, WTFMove(impl))
{
}

Ref<SVGElement> JSSVGElement::protectedWrapped() const
{
    return wrapped();
}

JSObject* JSSVGElement::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSSVGElementPrototype::createStructure(vm, &globalObject, JSElement::prototype(vm, globalObject));
    structure->setMayBePrototype(true);
    return JSSVGElementPrototype::create(vm, &globalObject, structure);
}

JSObject* JSSVGElement::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSSVGElement>(vm, globalObject);
}

JSValue JSSVGElement::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSSVGElementDOMConstructor, DOMConstructorID::SVGElement>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsSVGElementConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSSVGElementPrototype*>(JSValue::decode(thisValue));
    if (!prototype) [[unlikely]]
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSSVGElement::getConstructor(vm, prototype->globalObject()));
}

static inline JSValue jsSVGElement_classNameGetter(JSGlobalObject& lexicalGlobalObject, JSSVGElement& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLInterface<SVGAnimatedString>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.classNameAnimated())));
}

JSC_DEFINE_CUSTOM_GETTER(jsSVGElement_className, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGElement>::get<jsSVGElement_classNameGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsSVGElement_ownerSVGElementGetter(JSGlobalObject& lexicalGlobalObject, JSSVGElement& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLNullable<IDLInterface<SVGSVGElement>>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.ownerSVGElement())));
}

JSC_DEFINE_CUSTOM_GETTER(jsSVGElement_ownerSVGElement, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGElement>::get<jsSVGElement_ownerSVGElementGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsSVGElement_viewportElementGetter(JSGlobalObject& lexicalGlobalObject, JSSVGElement& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLNullable<IDLInterface<SVGElement>>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.viewportElement())));
}

JSC_DEFINE_CUSTOM_GETTER(jsSVGElement_viewportElement, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGElement>::get<jsSVGElement_viewportElementGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsSVGElement_styleGetter(JSGlobalObject& lexicalGlobalObject, JSSVGElement& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLInterface<CSSStyleProperties>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.cssomStyle())));
}

JSC_DEFINE_CUSTOM_GETTER(jsSVGElement_style, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGElement>::get<jsSVGElement_styleGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSSVGElement_styleSetter(JSGlobalObject& lexicalGlobalObject, JSSVGElement& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto id = Identifier::fromString(vm, "style"_s);
    auto valueToForwardTo = thisObject.get(&lexicalGlobalObject, id);
    RETURN_IF_EXCEPTION(throwScope, false);
    if (!valueToForwardTo.isObject()) [[unlikely]] {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return false;
    }
    auto forwardId = Identifier::fromString(vm, "cssText"_s);
    PutPropertySlot slot(valueToForwardTo, false);
    asObject(valueToForwardTo)->methodTable()->put(asObject(valueToForwardTo), &lexicalGlobalObject, forwardId, value, slot);
    RETURN_IF_EXCEPTION(throwScope, false);
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSSVGElement_style, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGElement>::set<setJSSVGElement_styleSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsSVGElement_attributeStyleMapGetter(JSGlobalObject& lexicalGlobalObject, JSSVGElement& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    if (JSValue cachedValue = thisObject.m_attributeStyleMap.get())
        return cachedValue;
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLInterface<StylePropertyMap>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.ensureAttributeStyleMap());
    RETURN_IF_EXCEPTION(throwScope, { });
    thisObject.m_attributeStyleMap.set(JSC::getVM(&lexicalGlobalObject), &thisObject, result);
    return result;
}

JSC_DEFINE_CUSTOM_GETTER(jsSVGElement_attributeStyleMap, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGElement>::get<jsSVGElement_attributeStyleMapGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsSVGElement_onbeforecopyGetter(JSGlobalObject& lexicalGlobalObject, JSSVGElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().beforecopyEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsSVGElement_onbeforecopy, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGElement>::get<jsSVGElement_onbeforecopyGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSSVGElement_onbeforecopySetter(JSGlobalObject& lexicalGlobalObject, JSSVGElement& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().beforecopyEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSSVGElement_onbeforecopy, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGElement>::set<setJSSVGElement_onbeforecopySetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsSVGElement_onbeforecutGetter(JSGlobalObject& lexicalGlobalObject, JSSVGElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().beforecutEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsSVGElement_onbeforecut, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGElement>::get<jsSVGElement_onbeforecutGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSSVGElement_onbeforecutSetter(JSGlobalObject& lexicalGlobalObject, JSSVGElement& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().beforecutEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSSVGElement_onbeforecut, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGElement>::set<setJSSVGElement_onbeforecutSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsSVGElement_onbeforepasteGetter(JSGlobalObject& lexicalGlobalObject, JSSVGElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().beforepasteEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsSVGElement_onbeforepaste, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGElement>::get<jsSVGElement_onbeforepasteGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSSVGElement_onbeforepasteSetter(JSGlobalObject& lexicalGlobalObject, JSSVGElement& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().beforepasteEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSSVGElement_onbeforepaste, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGElement>::set<setJSSVGElement_onbeforepasteSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsSVGElement_onabortGetter(JSGlobalObject& lexicalGlobalObject, JSSVGElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().abortEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsSVGElement_onabort, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGElement>::get<jsSVGElement_onabortGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSSVGElement_onabortSetter(JSGlobalObject& lexicalGlobalObject, JSSVGElement& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().abortEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSSVGElement_onabort, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGElement>::set<setJSSVGElement_onabortSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsSVGElement_onauxclickGetter(JSGlobalObject& lexicalGlobalObject, JSSVGElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().auxclickEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsSVGElement_onauxclick, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGElement>::get<jsSVGElement_onauxclickGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSSVGElement_onauxclickSetter(JSGlobalObject& lexicalGlobalObject, JSSVGElement& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().auxclickEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSSVGElement_onauxclick, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGElement>::set<setJSSVGElement_onauxclickSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsSVGElement_onbeforeinputGetter(JSGlobalObject& lexicalGlobalObject, JSSVGElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().beforeinputEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsSVGElement_onbeforeinput, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGElement>::get<jsSVGElement_onbeforeinputGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSSVGElement_onbeforeinputSetter(JSGlobalObject& lexicalGlobalObject, JSSVGElement& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().beforeinputEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSSVGElement_onbeforeinput, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGElement>::set<setJSSVGElement_onbeforeinputSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsSVGElement_onbeforematchGetter(JSGlobalObject& lexicalGlobalObject, JSSVGElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().beforematchEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsSVGElement_onbeforematch, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGElement>::get<jsSVGElement_onbeforematchGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSSVGElement_onbeforematchSetter(JSGlobalObject& lexicalGlobalObject, JSSVGElement& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().beforematchEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSSVGElement_onbeforematch, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGElement>::set<setJSSVGElement_onbeforematchSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsSVGElement_onbeforetoggleGetter(JSGlobalObject& lexicalGlobalObject, JSSVGElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().beforetoggleEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsSVGElement_onbeforetoggle, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGElement>::get<jsSVGElement_onbeforetoggleGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSSVGElement_onbeforetoggleSetter(JSGlobalObject& lexicalGlobalObject, JSSVGElement& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().beforetoggleEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSSVGElement_onbeforetoggle, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGElement>::set<setJSSVGElement_onbeforetoggleSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsSVGElement_onblurGetter(JSGlobalObject& lexicalGlobalObject, JSSVGElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().blurEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsSVGElement_onblur, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGElement>::get<jsSVGElement_onblurGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSSVGElement_onblurSetter(JSGlobalObject& lexicalGlobalObject, JSSVGElement& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().blurEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSSVGElement_onblur, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGElement>::set<setJSSVGElement_onblurSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsSVGElement_oncancelGetter(JSGlobalObject& lexicalGlobalObject, JSSVGElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().cancelEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsSVGElement_oncancel, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGElement>::get<jsSVGElement_oncancelGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSSVGElement_oncancelSetter(JSGlobalObject& lexicalGlobalObject, JSSVGElement& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().cancelEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSSVGElement_oncancel, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGElement>::set<setJSSVGElement_oncancelSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsSVGElement_oncanplayGetter(JSGlobalObject& lexicalGlobalObject, JSSVGElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().canplayEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsSVGElement_oncanplay, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGElement>::get<jsSVGElement_oncanplayGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSSVGElement_oncanplaySetter(JSGlobalObject& lexicalGlobalObject, JSSVGElement& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().canplayEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSSVGElement_oncanplay, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGElement>::set<setJSSVGElement_oncanplaySetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsSVGElement_oncanplaythroughGetter(JSGlobalObject& lexicalGlobalObject, JSSVGElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().canplaythroughEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsSVGElement_oncanplaythrough, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGElement>::get<jsSVGElement_oncanplaythroughGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSSVGElement_oncanplaythroughSetter(JSGlobalObject& lexicalGlobalObject, JSSVGElement& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().canplaythroughEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSSVGElement_oncanplaythrough, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGElement>::set<setJSSVGElement_oncanplaythroughSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsSVGElement_onchangeGetter(JSGlobalObject& lexicalGlobalObject, JSSVGElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().changeEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsSVGElement_onchange, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGElement>::get<jsSVGElement_onchangeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSSVGElement_onchangeSetter(JSGlobalObject& lexicalGlobalObject, JSSVGElement& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().changeEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSSVGElement_onchange, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGElement>::set<setJSSVGElement_onchangeSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsSVGElement_onclickGetter(JSGlobalObject& lexicalGlobalObject, JSSVGElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().clickEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsSVGElement_onclick, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGElement>::get<jsSVGElement_onclickGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSSVGElement_onclickSetter(JSGlobalObject& lexicalGlobalObject, JSSVGElement& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().clickEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSSVGElement_onclick, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGElement>::set<setJSSVGElement_onclickSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsSVGElement_oncloseGetter(JSGlobalObject& lexicalGlobalObject, JSSVGElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().closeEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsSVGElement_onclose, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGElement>::get<jsSVGElement_oncloseGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSSVGElement_oncloseSetter(JSGlobalObject& lexicalGlobalObject, JSSVGElement& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().closeEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSSVGElement_onclose, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGElement>::set<setJSSVGElement_oncloseSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsSVGElement_oncommandGetter(JSGlobalObject& lexicalGlobalObject, JSSVGElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().commandEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsSVGElement_oncommand, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGElement>::get<jsSVGElement_oncommandGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSSVGElement_oncommandSetter(JSGlobalObject& lexicalGlobalObject, JSSVGElement& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().commandEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSSVGElement_oncommand, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGElement>::set<setJSSVGElement_oncommandSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsSVGElement_oncontentvisibilityautostatechangeGetter(JSGlobalObject& lexicalGlobalObject, JSSVGElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().contentvisibilityautostatechangeEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsSVGElement_oncontentvisibilityautostatechange, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGElement>::get<jsSVGElement_oncontentvisibilityautostatechangeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSSVGElement_oncontentvisibilityautostatechangeSetter(JSGlobalObject& lexicalGlobalObject, JSSVGElement& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().contentvisibilityautostatechangeEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSSVGElement_oncontentvisibilityautostatechange, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGElement>::set<setJSSVGElement_oncontentvisibilityautostatechangeSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsSVGElement_oncontextmenuGetter(JSGlobalObject& lexicalGlobalObject, JSSVGElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().contextmenuEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsSVGElement_oncontextmenu, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGElement>::get<jsSVGElement_oncontextmenuGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSSVGElement_oncontextmenuSetter(JSGlobalObject& lexicalGlobalObject, JSSVGElement& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().contextmenuEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSSVGElement_oncontextmenu, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGElement>::set<setJSSVGElement_oncontextmenuSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsSVGElement_oncopyGetter(JSGlobalObject& lexicalGlobalObject, JSSVGElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().copyEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsSVGElement_oncopy, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGElement>::get<jsSVGElement_oncopyGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSSVGElement_oncopySetter(JSGlobalObject& lexicalGlobalObject, JSSVGElement& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().copyEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSSVGElement_oncopy, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGElement>::set<setJSSVGElement_oncopySetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsSVGElement_oncuechangeGetter(JSGlobalObject& lexicalGlobalObject, JSSVGElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().cuechangeEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsSVGElement_oncuechange, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGElement>::get<jsSVGElement_oncuechangeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSSVGElement_oncuechangeSetter(JSGlobalObject& lexicalGlobalObject, JSSVGElement& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().cuechangeEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSSVGElement_oncuechange, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGElement>::set<setJSSVGElement_oncuechangeSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsSVGElement_oncutGetter(JSGlobalObject& lexicalGlobalObject, JSSVGElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().cutEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsSVGElement_oncut, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGElement>::get<jsSVGElement_oncutGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSSVGElement_oncutSetter(JSGlobalObject& lexicalGlobalObject, JSSVGElement& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().cutEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSSVGElement_oncut, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGElement>::set<setJSSVGElement_oncutSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsSVGElement_ondblclickGetter(JSGlobalObject& lexicalGlobalObject, JSSVGElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().dblclickEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsSVGElement_ondblclick, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGElement>::get<jsSVGElement_ondblclickGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSSVGElement_ondblclickSetter(JSGlobalObject& lexicalGlobalObject, JSSVGElement& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().dblclickEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSSVGElement_ondblclick, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGElement>::set<setJSSVGElement_ondblclickSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsSVGElement_ondragGetter(JSGlobalObject& lexicalGlobalObject, JSSVGElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().dragEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsSVGElement_ondrag, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGElement>::get<jsSVGElement_ondragGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSSVGElement_ondragSetter(JSGlobalObject& lexicalGlobalObject, JSSVGElement& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().dragEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSSVGElement_ondrag, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGElement>::set<setJSSVGElement_ondragSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsSVGElement_ondragendGetter(JSGlobalObject& lexicalGlobalObject, JSSVGElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().dragendEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsSVGElement_ondragend, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGElement>::get<jsSVGElement_ondragendGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSSVGElement_ondragendSetter(JSGlobalObject& lexicalGlobalObject, JSSVGElement& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().dragendEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSSVGElement_ondragend, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGElement>::set<setJSSVGElement_ondragendSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsSVGElement_ondragenterGetter(JSGlobalObject& lexicalGlobalObject, JSSVGElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().dragenterEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsSVGElement_ondragenter, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGElement>::get<jsSVGElement_ondragenterGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSSVGElement_ondragenterSetter(JSGlobalObject& lexicalGlobalObject, JSSVGElement& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().dragenterEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSSVGElement_ondragenter, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGElement>::set<setJSSVGElement_ondragenterSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsSVGElement_ondragleaveGetter(JSGlobalObject& lexicalGlobalObject, JSSVGElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().dragleaveEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsSVGElement_ondragleave, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGElement>::get<jsSVGElement_ondragleaveGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSSVGElement_ondragleaveSetter(JSGlobalObject& lexicalGlobalObject, JSSVGElement& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().dragleaveEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSSVGElement_ondragleave, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGElement>::set<setJSSVGElement_ondragleaveSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsSVGElement_ondragoverGetter(JSGlobalObject& lexicalGlobalObject, JSSVGElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().dragoverEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsSVGElement_ondragover, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGElement>::get<jsSVGElement_ondragoverGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSSVGElement_ondragoverSetter(JSGlobalObject& lexicalGlobalObject, JSSVGElement& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().dragoverEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSSVGElement_ondragover, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGElement>::set<setJSSVGElement_ondragoverSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsSVGElement_ondragstartGetter(JSGlobalObject& lexicalGlobalObject, JSSVGElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().dragstartEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsSVGElement_ondragstart, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGElement>::get<jsSVGElement_ondragstartGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSSVGElement_ondragstartSetter(JSGlobalObject& lexicalGlobalObject, JSSVGElement& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().dragstartEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSSVGElement_ondragstart, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGElement>::set<setJSSVGElement_ondragstartSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsSVGElement_ondropGetter(JSGlobalObject& lexicalGlobalObject, JSSVGElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().dropEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsSVGElement_ondrop, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGElement>::get<jsSVGElement_ondropGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSSVGElement_ondropSetter(JSGlobalObject& lexicalGlobalObject, JSSVGElement& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().dropEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSSVGElement_ondrop, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGElement>::set<setJSSVGElement_ondropSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsSVGElement_ondurationchangeGetter(JSGlobalObject& lexicalGlobalObject, JSSVGElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().durationchangeEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsSVGElement_ondurationchange, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGElement>::get<jsSVGElement_ondurationchangeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSSVGElement_ondurationchangeSetter(JSGlobalObject& lexicalGlobalObject, JSSVGElement& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().durationchangeEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSSVGElement_ondurationchange, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGElement>::set<setJSSVGElement_ondurationchangeSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsSVGElement_onemptiedGetter(JSGlobalObject& lexicalGlobalObject, JSSVGElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().emptiedEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsSVGElement_onemptied, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGElement>::get<jsSVGElement_onemptiedGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSSVGElement_onemptiedSetter(JSGlobalObject& lexicalGlobalObject, JSSVGElement& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().emptiedEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSSVGElement_onemptied, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGElement>::set<setJSSVGElement_onemptiedSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsSVGElement_onendedGetter(JSGlobalObject& lexicalGlobalObject, JSSVGElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().endedEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsSVGElement_onended, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGElement>::get<jsSVGElement_onendedGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSSVGElement_onendedSetter(JSGlobalObject& lexicalGlobalObject, JSSVGElement& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().endedEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSSVGElement_onended, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGElement>::set<setJSSVGElement_onendedSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsSVGElement_onerrorGetter(JSGlobalObject& lexicalGlobalObject, JSSVGElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().errorEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsSVGElement_onerror, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGElement>::get<jsSVGElement_onerrorGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSSVGElement_onerrorSetter(JSGlobalObject& lexicalGlobalObject, JSSVGElement& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().errorEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSSVGElement_onerror, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGElement>::set<setJSSVGElement_onerrorSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsSVGElement_onfocusGetter(JSGlobalObject& lexicalGlobalObject, JSSVGElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().focusEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsSVGElement_onfocus, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGElement>::get<jsSVGElement_onfocusGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSSVGElement_onfocusSetter(JSGlobalObject& lexicalGlobalObject, JSSVGElement& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().focusEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSSVGElement_onfocus, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGElement>::set<setJSSVGElement_onfocusSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsSVGElement_onformdataGetter(JSGlobalObject& lexicalGlobalObject, JSSVGElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().formdataEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsSVGElement_onformdata, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGElement>::get<jsSVGElement_onformdataGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSSVGElement_onformdataSetter(JSGlobalObject& lexicalGlobalObject, JSSVGElement& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().formdataEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSSVGElement_onformdata, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGElement>::set<setJSSVGElement_onformdataSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsSVGElement_oninputGetter(JSGlobalObject& lexicalGlobalObject, JSSVGElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().inputEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsSVGElement_oninput, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGElement>::get<jsSVGElement_oninputGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSSVGElement_oninputSetter(JSGlobalObject& lexicalGlobalObject, JSSVGElement& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().inputEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSSVGElement_oninput, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGElement>::set<setJSSVGElement_oninputSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsSVGElement_oninvalidGetter(JSGlobalObject& lexicalGlobalObject, JSSVGElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().invalidEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsSVGElement_oninvalid, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGElement>::get<jsSVGElement_oninvalidGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSSVGElement_oninvalidSetter(JSGlobalObject& lexicalGlobalObject, JSSVGElement& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().invalidEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSSVGElement_oninvalid, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGElement>::set<setJSSVGElement_oninvalidSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsSVGElement_onkeydownGetter(JSGlobalObject& lexicalGlobalObject, JSSVGElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().keydownEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsSVGElement_onkeydown, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGElement>::get<jsSVGElement_onkeydownGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSSVGElement_onkeydownSetter(JSGlobalObject& lexicalGlobalObject, JSSVGElement& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().keydownEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSSVGElement_onkeydown, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGElement>::set<setJSSVGElement_onkeydownSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsSVGElement_onkeypressGetter(JSGlobalObject& lexicalGlobalObject, JSSVGElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().keypressEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsSVGElement_onkeypress, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGElement>::get<jsSVGElement_onkeypressGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSSVGElement_onkeypressSetter(JSGlobalObject& lexicalGlobalObject, JSSVGElement& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().keypressEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSSVGElement_onkeypress, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGElement>::set<setJSSVGElement_onkeypressSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsSVGElement_onkeyupGetter(JSGlobalObject& lexicalGlobalObject, JSSVGElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().keyupEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsSVGElement_onkeyup, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGElement>::get<jsSVGElement_onkeyupGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSSVGElement_onkeyupSetter(JSGlobalObject& lexicalGlobalObject, JSSVGElement& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().keyupEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSSVGElement_onkeyup, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGElement>::set<setJSSVGElement_onkeyupSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsSVGElement_onloadGetter(JSGlobalObject& lexicalGlobalObject, JSSVGElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().loadEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsSVGElement_onload, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGElement>::get<jsSVGElement_onloadGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSSVGElement_onloadSetter(JSGlobalObject& lexicalGlobalObject, JSSVGElement& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().loadEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSSVGElement_onload, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGElement>::set<setJSSVGElement_onloadSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsSVGElement_onloadeddataGetter(JSGlobalObject& lexicalGlobalObject, JSSVGElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().loadeddataEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsSVGElement_onloadeddata, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGElement>::get<jsSVGElement_onloadeddataGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSSVGElement_onloadeddataSetter(JSGlobalObject& lexicalGlobalObject, JSSVGElement& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().loadeddataEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSSVGElement_onloadeddata, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGElement>::set<setJSSVGElement_onloadeddataSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsSVGElement_onloadedmetadataGetter(JSGlobalObject& lexicalGlobalObject, JSSVGElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().loadedmetadataEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsSVGElement_onloadedmetadata, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGElement>::get<jsSVGElement_onloadedmetadataGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSSVGElement_onloadedmetadataSetter(JSGlobalObject& lexicalGlobalObject, JSSVGElement& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().loadedmetadataEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSSVGElement_onloadedmetadata, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGElement>::set<setJSSVGElement_onloadedmetadataSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsSVGElement_onloadstartGetter(JSGlobalObject& lexicalGlobalObject, JSSVGElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().loadstartEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsSVGElement_onloadstart, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGElement>::get<jsSVGElement_onloadstartGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSSVGElement_onloadstartSetter(JSGlobalObject& lexicalGlobalObject, JSSVGElement& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().loadstartEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSSVGElement_onloadstart, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGElement>::set<setJSSVGElement_onloadstartSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsSVGElement_onmousedownGetter(JSGlobalObject& lexicalGlobalObject, JSSVGElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().mousedownEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsSVGElement_onmousedown, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGElement>::get<jsSVGElement_onmousedownGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSSVGElement_onmousedownSetter(JSGlobalObject& lexicalGlobalObject, JSSVGElement& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().mousedownEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSSVGElement_onmousedown, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGElement>::set<setJSSVGElement_onmousedownSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsSVGElement_onmouseenterGetter(JSGlobalObject& lexicalGlobalObject, JSSVGElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().mouseenterEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsSVGElement_onmouseenter, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGElement>::get<jsSVGElement_onmouseenterGetter, CastedThisErrorBehavior::ReturnEarly>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSSVGElement_onmouseenterSetter(JSGlobalObject& lexicalGlobalObject, JSSVGElement& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().mouseenterEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSSVGElement_onmouseenter, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGElement>::set<setJSSVGElement_onmouseenterSetter, CastedThisErrorBehavior::ReturnEarly>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsSVGElement_onmouseleaveGetter(JSGlobalObject& lexicalGlobalObject, JSSVGElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().mouseleaveEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsSVGElement_onmouseleave, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGElement>::get<jsSVGElement_onmouseleaveGetter, CastedThisErrorBehavior::ReturnEarly>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSSVGElement_onmouseleaveSetter(JSGlobalObject& lexicalGlobalObject, JSSVGElement& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().mouseleaveEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSSVGElement_onmouseleave, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGElement>::set<setJSSVGElement_onmouseleaveSetter, CastedThisErrorBehavior::ReturnEarly>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsSVGElement_onmousemoveGetter(JSGlobalObject& lexicalGlobalObject, JSSVGElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().mousemoveEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsSVGElement_onmousemove, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGElement>::get<jsSVGElement_onmousemoveGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSSVGElement_onmousemoveSetter(JSGlobalObject& lexicalGlobalObject, JSSVGElement& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().mousemoveEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSSVGElement_onmousemove, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGElement>::set<setJSSVGElement_onmousemoveSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsSVGElement_onmouseoutGetter(JSGlobalObject& lexicalGlobalObject, JSSVGElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().mouseoutEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsSVGElement_onmouseout, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGElement>::get<jsSVGElement_onmouseoutGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSSVGElement_onmouseoutSetter(JSGlobalObject& lexicalGlobalObject, JSSVGElement& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().mouseoutEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSSVGElement_onmouseout, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGElement>::set<setJSSVGElement_onmouseoutSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsSVGElement_onmouseoverGetter(JSGlobalObject& lexicalGlobalObject, JSSVGElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().mouseoverEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsSVGElement_onmouseover, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGElement>::get<jsSVGElement_onmouseoverGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSSVGElement_onmouseoverSetter(JSGlobalObject& lexicalGlobalObject, JSSVGElement& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().mouseoverEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSSVGElement_onmouseover, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGElement>::set<setJSSVGElement_onmouseoverSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsSVGElement_onmouseupGetter(JSGlobalObject& lexicalGlobalObject, JSSVGElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().mouseupEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsSVGElement_onmouseup, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGElement>::get<jsSVGElement_onmouseupGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSSVGElement_onmouseupSetter(JSGlobalObject& lexicalGlobalObject, JSSVGElement& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().mouseupEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSSVGElement_onmouseup, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGElement>::set<setJSSVGElement_onmouseupSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsSVGElement_onpasteGetter(JSGlobalObject& lexicalGlobalObject, JSSVGElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().pasteEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsSVGElement_onpaste, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGElement>::get<jsSVGElement_onpasteGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSSVGElement_onpasteSetter(JSGlobalObject& lexicalGlobalObject, JSSVGElement& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().pasteEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSSVGElement_onpaste, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGElement>::set<setJSSVGElement_onpasteSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsSVGElement_onpauseGetter(JSGlobalObject& lexicalGlobalObject, JSSVGElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().pauseEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsSVGElement_onpause, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGElement>::get<jsSVGElement_onpauseGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSSVGElement_onpauseSetter(JSGlobalObject& lexicalGlobalObject, JSSVGElement& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().pauseEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSSVGElement_onpause, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGElement>::set<setJSSVGElement_onpauseSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsSVGElement_onplayGetter(JSGlobalObject& lexicalGlobalObject, JSSVGElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().playEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsSVGElement_onplay, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGElement>::get<jsSVGElement_onplayGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSSVGElement_onplaySetter(JSGlobalObject& lexicalGlobalObject, JSSVGElement& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().playEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSSVGElement_onplay, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGElement>::set<setJSSVGElement_onplaySetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsSVGElement_onplayingGetter(JSGlobalObject& lexicalGlobalObject, JSSVGElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().playingEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsSVGElement_onplaying, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGElement>::get<jsSVGElement_onplayingGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSSVGElement_onplayingSetter(JSGlobalObject& lexicalGlobalObject, JSSVGElement& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().playingEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSSVGElement_onplaying, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGElement>::set<setJSSVGElement_onplayingSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsSVGElement_onprogressGetter(JSGlobalObject& lexicalGlobalObject, JSSVGElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().progressEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsSVGElement_onprogress, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGElement>::get<jsSVGElement_onprogressGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSSVGElement_onprogressSetter(JSGlobalObject& lexicalGlobalObject, JSSVGElement& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().progressEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSSVGElement_onprogress, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGElement>::set<setJSSVGElement_onprogressSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsSVGElement_onratechangeGetter(JSGlobalObject& lexicalGlobalObject, JSSVGElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().ratechangeEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsSVGElement_onratechange, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGElement>::get<jsSVGElement_onratechangeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSSVGElement_onratechangeSetter(JSGlobalObject& lexicalGlobalObject, JSSVGElement& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().ratechangeEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSSVGElement_onratechange, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGElement>::set<setJSSVGElement_onratechangeSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsSVGElement_onresetGetter(JSGlobalObject& lexicalGlobalObject, JSSVGElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().resetEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsSVGElement_onreset, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGElement>::get<jsSVGElement_onresetGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSSVGElement_onresetSetter(JSGlobalObject& lexicalGlobalObject, JSSVGElement& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().resetEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSSVGElement_onreset, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGElement>::set<setJSSVGElement_onresetSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsSVGElement_onresizeGetter(JSGlobalObject& lexicalGlobalObject, JSSVGElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().resizeEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsSVGElement_onresize, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGElement>::get<jsSVGElement_onresizeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSSVGElement_onresizeSetter(JSGlobalObject& lexicalGlobalObject, JSSVGElement& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().resizeEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSSVGElement_onresize, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGElement>::set<setJSSVGElement_onresizeSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsSVGElement_onscrollGetter(JSGlobalObject& lexicalGlobalObject, JSSVGElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().scrollEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsSVGElement_onscroll, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGElement>::get<jsSVGElement_onscrollGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSSVGElement_onscrollSetter(JSGlobalObject& lexicalGlobalObject, JSSVGElement& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().scrollEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSSVGElement_onscroll, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGElement>::set<setJSSVGElement_onscrollSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsSVGElement_onscrollendGetter(JSGlobalObject& lexicalGlobalObject, JSSVGElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().scrollendEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsSVGElement_onscrollend, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGElement>::get<jsSVGElement_onscrollendGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSSVGElement_onscrollendSetter(JSGlobalObject& lexicalGlobalObject, JSSVGElement& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().scrollendEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSSVGElement_onscrollend, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGElement>::set<setJSSVGElement_onscrollendSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsSVGElement_onsecuritypolicyviolationGetter(JSGlobalObject& lexicalGlobalObject, JSSVGElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().securitypolicyviolationEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsSVGElement_onsecuritypolicyviolation, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGElement>::get<jsSVGElement_onsecuritypolicyviolationGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSSVGElement_onsecuritypolicyviolationSetter(JSGlobalObject& lexicalGlobalObject, JSSVGElement& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().securitypolicyviolationEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSSVGElement_onsecuritypolicyviolation, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGElement>::set<setJSSVGElement_onsecuritypolicyviolationSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsSVGElement_onseekedGetter(JSGlobalObject& lexicalGlobalObject, JSSVGElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().seekedEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsSVGElement_onseeked, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGElement>::get<jsSVGElement_onseekedGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSSVGElement_onseekedSetter(JSGlobalObject& lexicalGlobalObject, JSSVGElement& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().seekedEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSSVGElement_onseeked, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGElement>::set<setJSSVGElement_onseekedSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsSVGElement_onseekingGetter(JSGlobalObject& lexicalGlobalObject, JSSVGElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().seekingEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsSVGElement_onseeking, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGElement>::get<jsSVGElement_onseekingGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSSVGElement_onseekingSetter(JSGlobalObject& lexicalGlobalObject, JSSVGElement& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().seekingEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSSVGElement_onseeking, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGElement>::set<setJSSVGElement_onseekingSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsSVGElement_onselectGetter(JSGlobalObject& lexicalGlobalObject, JSSVGElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().selectEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsSVGElement_onselect, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGElement>::get<jsSVGElement_onselectGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSSVGElement_onselectSetter(JSGlobalObject& lexicalGlobalObject, JSSVGElement& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().selectEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSSVGElement_onselect, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGElement>::set<setJSSVGElement_onselectSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsSVGElement_onslotchangeGetter(JSGlobalObject& lexicalGlobalObject, JSSVGElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().slotchangeEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsSVGElement_onslotchange, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGElement>::get<jsSVGElement_onslotchangeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSSVGElement_onslotchangeSetter(JSGlobalObject& lexicalGlobalObject, JSSVGElement& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().slotchangeEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSSVGElement_onslotchange, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGElement>::set<setJSSVGElement_onslotchangeSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsSVGElement_onstalledGetter(JSGlobalObject& lexicalGlobalObject, JSSVGElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().stalledEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsSVGElement_onstalled, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGElement>::get<jsSVGElement_onstalledGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSSVGElement_onstalledSetter(JSGlobalObject& lexicalGlobalObject, JSSVGElement& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().stalledEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSSVGElement_onstalled, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGElement>::set<setJSSVGElement_onstalledSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsSVGElement_onsubmitGetter(JSGlobalObject& lexicalGlobalObject, JSSVGElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().submitEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsSVGElement_onsubmit, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGElement>::get<jsSVGElement_onsubmitGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSSVGElement_onsubmitSetter(JSGlobalObject& lexicalGlobalObject, JSSVGElement& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().submitEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSSVGElement_onsubmit, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGElement>::set<setJSSVGElement_onsubmitSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsSVGElement_onsuspendGetter(JSGlobalObject& lexicalGlobalObject, JSSVGElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().suspendEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsSVGElement_onsuspend, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGElement>::get<jsSVGElement_onsuspendGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSSVGElement_onsuspendSetter(JSGlobalObject& lexicalGlobalObject, JSSVGElement& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().suspendEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSSVGElement_onsuspend, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGElement>::set<setJSSVGElement_onsuspendSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsSVGElement_ontimeupdateGetter(JSGlobalObject& lexicalGlobalObject, JSSVGElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().timeupdateEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsSVGElement_ontimeupdate, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGElement>::get<jsSVGElement_ontimeupdateGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSSVGElement_ontimeupdateSetter(JSGlobalObject& lexicalGlobalObject, JSSVGElement& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().timeupdateEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSSVGElement_ontimeupdate, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGElement>::set<setJSSVGElement_ontimeupdateSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsSVGElement_ontoggleGetter(JSGlobalObject& lexicalGlobalObject, JSSVGElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().toggleEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsSVGElement_ontoggle, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGElement>::get<jsSVGElement_ontoggleGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSSVGElement_ontoggleSetter(JSGlobalObject& lexicalGlobalObject, JSSVGElement& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().toggleEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSSVGElement_ontoggle, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGElement>::set<setJSSVGElement_ontoggleSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsSVGElement_onvolumechangeGetter(JSGlobalObject& lexicalGlobalObject, JSSVGElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().volumechangeEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsSVGElement_onvolumechange, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGElement>::get<jsSVGElement_onvolumechangeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSSVGElement_onvolumechangeSetter(JSGlobalObject& lexicalGlobalObject, JSSVGElement& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().volumechangeEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSSVGElement_onvolumechange, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGElement>::set<setJSSVGElement_onvolumechangeSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsSVGElement_onwaitingGetter(JSGlobalObject& lexicalGlobalObject, JSSVGElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().waitingEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsSVGElement_onwaiting, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGElement>::get<jsSVGElement_onwaitingGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSSVGElement_onwaitingSetter(JSGlobalObject& lexicalGlobalObject, JSSVGElement& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().waitingEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSSVGElement_onwaiting, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGElement>::set<setJSSVGElement_onwaitingSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsSVGElement_onwebkitanimationendGetter(JSGlobalObject& lexicalGlobalObject, JSSVGElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().webkitAnimationEndEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsSVGElement_onwebkitanimationend, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGElement>::get<jsSVGElement_onwebkitanimationendGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSSVGElement_onwebkitanimationendSetter(JSGlobalObject& lexicalGlobalObject, JSSVGElement& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().webkitAnimationEndEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSSVGElement_onwebkitanimationend, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGElement>::set<setJSSVGElement_onwebkitanimationendSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsSVGElement_onwebkitanimationiterationGetter(JSGlobalObject& lexicalGlobalObject, JSSVGElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().webkitAnimationIterationEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsSVGElement_onwebkitanimationiteration, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGElement>::get<jsSVGElement_onwebkitanimationiterationGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSSVGElement_onwebkitanimationiterationSetter(JSGlobalObject& lexicalGlobalObject, JSSVGElement& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().webkitAnimationIterationEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSSVGElement_onwebkitanimationiteration, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGElement>::set<setJSSVGElement_onwebkitanimationiterationSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsSVGElement_onwebkitanimationstartGetter(JSGlobalObject& lexicalGlobalObject, JSSVGElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().webkitAnimationStartEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsSVGElement_onwebkitanimationstart, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGElement>::get<jsSVGElement_onwebkitanimationstartGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSSVGElement_onwebkitanimationstartSetter(JSGlobalObject& lexicalGlobalObject, JSSVGElement& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().webkitAnimationStartEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSSVGElement_onwebkitanimationstart, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGElement>::set<setJSSVGElement_onwebkitanimationstartSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsSVGElement_onwebkittransitionendGetter(JSGlobalObject& lexicalGlobalObject, JSSVGElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().webkitTransitionEndEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsSVGElement_onwebkittransitionend, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGElement>::get<jsSVGElement_onwebkittransitionendGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSSVGElement_onwebkittransitionendSetter(JSGlobalObject& lexicalGlobalObject, JSSVGElement& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().webkitTransitionEndEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSSVGElement_onwebkittransitionend, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGElement>::set<setJSSVGElement_onwebkittransitionendSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsSVGElement_onwheelGetter(JSGlobalObject& lexicalGlobalObject, JSSVGElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().wheelEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsSVGElement_onwheel, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGElement>::get<jsSVGElement_onwheelGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSSVGElement_onwheelSetter(JSGlobalObject& lexicalGlobalObject, JSSVGElement& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().wheelEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSSVGElement_onwheel, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGElement>::set<setJSSVGElement_onwheelSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsSVGElement_onmousewheelGetter(JSGlobalObject& lexicalGlobalObject, JSSVGElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().mousewheelEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsSVGElement_onmousewheel, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGElement>::get<jsSVGElement_onmousewheelGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSSVGElement_onmousewheelSetter(JSGlobalObject& lexicalGlobalObject, JSSVGElement& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().mousewheelEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSSVGElement_onmousewheel, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGElement>::set<setJSSVGElement_onmousewheelSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

#if ENABLE(TOUCH_EVENTS)
static inline JSValue jsSVGElement_ontouchcancelGetter(JSGlobalObject& lexicalGlobalObject, JSSVGElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().touchcancelEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsSVGElement_ontouchcancel, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGElement>::get<jsSVGElement_ontouchcancelGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

#endif

#if ENABLE(TOUCH_EVENTS)
static inline bool setJSSVGElement_ontouchcancelSetter(JSGlobalObject& lexicalGlobalObject, JSSVGElement& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().touchcancelEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSSVGElement_ontouchcancel, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGElement>::set<setJSSVGElement_ontouchcancelSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

#endif

#if ENABLE(TOUCH_EVENTS)
static inline JSValue jsSVGElement_ontouchendGetter(JSGlobalObject& lexicalGlobalObject, JSSVGElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().touchendEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsSVGElement_ontouchend, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGElement>::get<jsSVGElement_ontouchendGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

#endif

#if ENABLE(TOUCH_EVENTS)
static inline bool setJSSVGElement_ontouchendSetter(JSGlobalObject& lexicalGlobalObject, JSSVGElement& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().touchendEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSSVGElement_ontouchend, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGElement>::set<setJSSVGElement_ontouchendSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

#endif

#if ENABLE(TOUCH_EVENTS)
static inline JSValue jsSVGElement_ontouchmoveGetter(JSGlobalObject& lexicalGlobalObject, JSSVGElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().touchmoveEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsSVGElement_ontouchmove, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGElement>::get<jsSVGElement_ontouchmoveGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

#endif

#if ENABLE(TOUCH_EVENTS)
static inline bool setJSSVGElement_ontouchmoveSetter(JSGlobalObject& lexicalGlobalObject, JSSVGElement& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().touchmoveEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSSVGElement_ontouchmove, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGElement>::set<setJSSVGElement_ontouchmoveSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

#endif

#if ENABLE(TOUCH_EVENTS)
static inline JSValue jsSVGElement_ontouchstartGetter(JSGlobalObject& lexicalGlobalObject, JSSVGElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().touchstartEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsSVGElement_ontouchstart, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGElement>::get<jsSVGElement_ontouchstartGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

#endif

#if ENABLE(TOUCH_EVENTS)
static inline bool setJSSVGElement_ontouchstartSetter(JSGlobalObject& lexicalGlobalObject, JSSVGElement& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().touchstartEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSSVGElement_ontouchstart, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGElement>::set<setJSSVGElement_ontouchstartSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

#endif

#if ENABLE(TOUCH_EVENTS)
static inline JSValue jsSVGElement_ontouchforcechangeGetter(JSGlobalObject& lexicalGlobalObject, JSSVGElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().touchforcechangeEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsSVGElement_ontouchforcechange, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGElement>::get<jsSVGElement_ontouchforcechangeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

#endif

#if ENABLE(TOUCH_EVENTS)
static inline bool setJSSVGElement_ontouchforcechangeSetter(JSGlobalObject& lexicalGlobalObject, JSSVGElement& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().touchforcechangeEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSSVGElement_ontouchforcechange, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGElement>::set<setJSSVGElement_ontouchforcechangeSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

#endif

static inline JSValue jsSVGElement_onwebkitmouseforcechangedGetter(JSGlobalObject& lexicalGlobalObject, JSSVGElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().webkitmouseforcechangedEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsSVGElement_onwebkitmouseforcechanged, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGElement>::get<jsSVGElement_onwebkitmouseforcechangedGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSSVGElement_onwebkitmouseforcechangedSetter(JSGlobalObject& lexicalGlobalObject, JSSVGElement& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().webkitmouseforcechangedEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSSVGElement_onwebkitmouseforcechanged, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGElement>::set<setJSSVGElement_onwebkitmouseforcechangedSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsSVGElement_onwebkitmouseforcedownGetter(JSGlobalObject& lexicalGlobalObject, JSSVGElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().webkitmouseforcedownEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsSVGElement_onwebkitmouseforcedown, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGElement>::get<jsSVGElement_onwebkitmouseforcedownGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSSVGElement_onwebkitmouseforcedownSetter(JSGlobalObject& lexicalGlobalObject, JSSVGElement& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().webkitmouseforcedownEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSSVGElement_onwebkitmouseforcedown, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGElement>::set<setJSSVGElement_onwebkitmouseforcedownSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsSVGElement_onwebkitmouseforcewillbeginGetter(JSGlobalObject& lexicalGlobalObject, JSSVGElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().webkitmouseforcewillbeginEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsSVGElement_onwebkitmouseforcewillbegin, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGElement>::get<jsSVGElement_onwebkitmouseforcewillbeginGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSSVGElement_onwebkitmouseforcewillbeginSetter(JSGlobalObject& lexicalGlobalObject, JSSVGElement& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().webkitmouseforcewillbeginEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSSVGElement_onwebkitmouseforcewillbegin, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGElement>::set<setJSSVGElement_onwebkitmouseforcewillbeginSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsSVGElement_onwebkitmouseforceupGetter(JSGlobalObject& lexicalGlobalObject, JSSVGElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().webkitmouseforceupEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsSVGElement_onwebkitmouseforceup, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGElement>::get<jsSVGElement_onwebkitmouseforceupGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSSVGElement_onwebkitmouseforceupSetter(JSGlobalObject& lexicalGlobalObject, JSSVGElement& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().webkitmouseforceupEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSSVGElement_onwebkitmouseforceup, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGElement>::set<setJSSVGElement_onwebkitmouseforceupSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsSVGElement_onanimationstartGetter(JSGlobalObject& lexicalGlobalObject, JSSVGElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().animationstartEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsSVGElement_onanimationstart, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGElement>::get<jsSVGElement_onanimationstartGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSSVGElement_onanimationstartSetter(JSGlobalObject& lexicalGlobalObject, JSSVGElement& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().animationstartEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSSVGElement_onanimationstart, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGElement>::set<setJSSVGElement_onanimationstartSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsSVGElement_onanimationiterationGetter(JSGlobalObject& lexicalGlobalObject, JSSVGElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().animationiterationEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsSVGElement_onanimationiteration, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGElement>::get<jsSVGElement_onanimationiterationGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSSVGElement_onanimationiterationSetter(JSGlobalObject& lexicalGlobalObject, JSSVGElement& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().animationiterationEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSSVGElement_onanimationiteration, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGElement>::set<setJSSVGElement_onanimationiterationSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsSVGElement_onanimationendGetter(JSGlobalObject& lexicalGlobalObject, JSSVGElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().animationendEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsSVGElement_onanimationend, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGElement>::get<jsSVGElement_onanimationendGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSSVGElement_onanimationendSetter(JSGlobalObject& lexicalGlobalObject, JSSVGElement& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().animationendEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSSVGElement_onanimationend, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGElement>::set<setJSSVGElement_onanimationendSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsSVGElement_onanimationcancelGetter(JSGlobalObject& lexicalGlobalObject, JSSVGElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().animationcancelEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsSVGElement_onanimationcancel, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGElement>::get<jsSVGElement_onanimationcancelGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSSVGElement_onanimationcancelSetter(JSGlobalObject& lexicalGlobalObject, JSSVGElement& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().animationcancelEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSSVGElement_onanimationcancel, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGElement>::set<setJSSVGElement_onanimationcancelSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsSVGElement_ontransitionrunGetter(JSGlobalObject& lexicalGlobalObject, JSSVGElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().transitionrunEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsSVGElement_ontransitionrun, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGElement>::get<jsSVGElement_ontransitionrunGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSSVGElement_ontransitionrunSetter(JSGlobalObject& lexicalGlobalObject, JSSVGElement& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().transitionrunEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSSVGElement_ontransitionrun, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGElement>::set<setJSSVGElement_ontransitionrunSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsSVGElement_ontransitionstartGetter(JSGlobalObject& lexicalGlobalObject, JSSVGElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().transitionstartEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsSVGElement_ontransitionstart, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGElement>::get<jsSVGElement_ontransitionstartGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSSVGElement_ontransitionstartSetter(JSGlobalObject& lexicalGlobalObject, JSSVGElement& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().transitionstartEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSSVGElement_ontransitionstart, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGElement>::set<setJSSVGElement_ontransitionstartSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsSVGElement_ontransitionendGetter(JSGlobalObject& lexicalGlobalObject, JSSVGElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().transitionendEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsSVGElement_ontransitionend, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGElement>::get<jsSVGElement_ontransitionendGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSSVGElement_ontransitionendSetter(JSGlobalObject& lexicalGlobalObject, JSSVGElement& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().transitionendEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSSVGElement_ontransitionend, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGElement>::set<setJSSVGElement_ontransitionendSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsSVGElement_ontransitioncancelGetter(JSGlobalObject& lexicalGlobalObject, JSSVGElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().transitioncancelEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsSVGElement_ontransitioncancel, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGElement>::get<jsSVGElement_ontransitioncancelGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSSVGElement_ontransitioncancelSetter(JSGlobalObject& lexicalGlobalObject, JSSVGElement& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().transitioncancelEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSSVGElement_ontransitioncancel, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGElement>::set<setJSSVGElement_ontransitioncancelSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsSVGElement_ongotpointercaptureGetter(JSGlobalObject& lexicalGlobalObject, JSSVGElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().gotpointercaptureEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsSVGElement_ongotpointercapture, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGElement>::get<jsSVGElement_ongotpointercaptureGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSSVGElement_ongotpointercaptureSetter(JSGlobalObject& lexicalGlobalObject, JSSVGElement& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().gotpointercaptureEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSSVGElement_ongotpointercapture, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGElement>::set<setJSSVGElement_ongotpointercaptureSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsSVGElement_onlostpointercaptureGetter(JSGlobalObject& lexicalGlobalObject, JSSVGElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().lostpointercaptureEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsSVGElement_onlostpointercapture, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGElement>::get<jsSVGElement_onlostpointercaptureGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSSVGElement_onlostpointercaptureSetter(JSGlobalObject& lexicalGlobalObject, JSSVGElement& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().lostpointercaptureEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSSVGElement_onlostpointercapture, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGElement>::set<setJSSVGElement_onlostpointercaptureSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsSVGElement_onpointerdownGetter(JSGlobalObject& lexicalGlobalObject, JSSVGElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().pointerdownEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsSVGElement_onpointerdown, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGElement>::get<jsSVGElement_onpointerdownGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSSVGElement_onpointerdownSetter(JSGlobalObject& lexicalGlobalObject, JSSVGElement& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().pointerdownEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSSVGElement_onpointerdown, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGElement>::set<setJSSVGElement_onpointerdownSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsSVGElement_onpointermoveGetter(JSGlobalObject& lexicalGlobalObject, JSSVGElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().pointermoveEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsSVGElement_onpointermove, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGElement>::get<jsSVGElement_onpointermoveGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSSVGElement_onpointermoveSetter(JSGlobalObject& lexicalGlobalObject, JSSVGElement& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().pointermoveEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSSVGElement_onpointermove, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGElement>::set<setJSSVGElement_onpointermoveSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsSVGElement_onpointerupGetter(JSGlobalObject& lexicalGlobalObject, JSSVGElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().pointerupEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsSVGElement_onpointerup, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGElement>::get<jsSVGElement_onpointerupGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSSVGElement_onpointerupSetter(JSGlobalObject& lexicalGlobalObject, JSSVGElement& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().pointerupEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSSVGElement_onpointerup, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGElement>::set<setJSSVGElement_onpointerupSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsSVGElement_onpointercancelGetter(JSGlobalObject& lexicalGlobalObject, JSSVGElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().pointercancelEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsSVGElement_onpointercancel, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGElement>::get<jsSVGElement_onpointercancelGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSSVGElement_onpointercancelSetter(JSGlobalObject& lexicalGlobalObject, JSSVGElement& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().pointercancelEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSSVGElement_onpointercancel, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGElement>::set<setJSSVGElement_onpointercancelSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsSVGElement_onpointeroverGetter(JSGlobalObject& lexicalGlobalObject, JSSVGElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().pointeroverEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsSVGElement_onpointerover, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGElement>::get<jsSVGElement_onpointeroverGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSSVGElement_onpointeroverSetter(JSGlobalObject& lexicalGlobalObject, JSSVGElement& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().pointeroverEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSSVGElement_onpointerover, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGElement>::set<setJSSVGElement_onpointeroverSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsSVGElement_onpointeroutGetter(JSGlobalObject& lexicalGlobalObject, JSSVGElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().pointeroutEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsSVGElement_onpointerout, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGElement>::get<jsSVGElement_onpointeroutGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSSVGElement_onpointeroutSetter(JSGlobalObject& lexicalGlobalObject, JSSVGElement& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().pointeroutEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSSVGElement_onpointerout, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGElement>::set<setJSSVGElement_onpointeroutSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsSVGElement_onpointerenterGetter(JSGlobalObject& lexicalGlobalObject, JSSVGElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().pointerenterEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsSVGElement_onpointerenter, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGElement>::get<jsSVGElement_onpointerenterGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSSVGElement_onpointerenterSetter(JSGlobalObject& lexicalGlobalObject, JSSVGElement& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().pointerenterEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSSVGElement_onpointerenter, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGElement>::set<setJSSVGElement_onpointerenterSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsSVGElement_onpointerleaveGetter(JSGlobalObject& lexicalGlobalObject, JSSVGElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().pointerleaveEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsSVGElement_onpointerleave, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGElement>::get<jsSVGElement_onpointerleaveGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSSVGElement_onpointerleaveSetter(JSGlobalObject& lexicalGlobalObject, JSSVGElement& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().pointerleaveEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSSVGElement_onpointerleave, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGElement>::set<setJSSVGElement_onpointerleaveSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsSVGElement_onselectstartGetter(JSGlobalObject& lexicalGlobalObject, JSSVGElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().selectstartEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsSVGElement_onselectstart, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGElement>::get<jsSVGElement_onselectstartGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSSVGElement_onselectstartSetter(JSGlobalObject& lexicalGlobalObject, JSSVGElement& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().selectstartEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSSVGElement_onselectstart, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGElement>::set<setJSSVGElement_onselectstartSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsSVGElement_onselectionchangeGetter(JSGlobalObject& lexicalGlobalObject, JSSVGElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().selectionchangeEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsSVGElement_onselectionchange, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGElement>::get<jsSVGElement_onselectionchangeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSSVGElement_onselectionchangeSetter(JSGlobalObject& lexicalGlobalObject, JSSVGElement& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().selectionchangeEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSSVGElement_onselectionchange, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGElement>::set<setJSSVGElement_onselectionchangeSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsSVGElement_datasetGetter(JSGlobalObject& lexicalGlobalObject, JSSVGElement& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLInterface<DOMStringMap>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.dataset())));
}

JSC_DEFINE_CUSTOM_GETTER(jsSVGElement_dataset, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGElement>::get<jsSVGElement_datasetGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsSVGElement_nonceGetter(JSGlobalObject& lexicalGlobalObject, JSSVGElement& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLAtomStringAdaptor<IDLDOMString>>(lexicalGlobalObject, throwScope, impl.nonce())));
}

JSC_DEFINE_CUSTOM_GETTER(jsSVGElement_nonce, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGElement>::get<jsSVGElement_nonceGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSSVGElement_nonceSetter(JSGlobalObject& lexicalGlobalObject, JSSVGElement& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLAtomStringAdaptor<IDLDOMString>>(lexicalGlobalObject, value);
    if (nativeValueConversionResult.hasException(throwScope)) [[unlikely]]
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setNonce(nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSSVGElement_nonce, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGElement>::set<setJSSVGElement_nonceSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsSVGElement_autofocusGetter(JSGlobalObject& lexicalGlobalObject, JSSVGElement& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.hasAttributeWithoutSynchronization(WebCore::SVGNames::autofocusAttr))));
}

JSC_DEFINE_CUSTOM_GETTER(jsSVGElement_autofocus, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGElement>::get<jsSVGElement_autofocusGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSSVGElement_autofocusSetter(JSGlobalObject& lexicalGlobalObject, JSSVGElement& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    CustomElementReactionDisallowedScope customElementReactionDisallowedScope;
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLBoolean>(lexicalGlobalObject, value);
    if (nativeValueConversionResult.hasException(throwScope)) [[unlikely]]
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setBooleanAttribute(WebCore::SVGNames::autofocusAttr, nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSSVGElement_autofocus, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGElement>::set<setJSSVGElement_autofocusSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsSVGElement_tabIndexGetter(JSGlobalObject& lexicalGlobalObject, JSSVGElement& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLLong>(lexicalGlobalObject, throwScope, impl.tabIndexForBindings())));
}

JSC_DEFINE_CUSTOM_GETTER(jsSVGElement_tabIndex, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGElement>::get<jsSVGElement_tabIndexGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSSVGElement_tabIndexSetter(JSGlobalObject& lexicalGlobalObject, JSSVGElement& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    CustomElementReactionStack customElementReactionStack(lexicalGlobalObject);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLLong>(lexicalGlobalObject, value);
    if (nativeValueConversionResult.hasException(throwScope)) [[unlikely]]
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setTabIndexForBindings(nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSSVGElement_tabIndex, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGElement>::set<setJSSVGElement_tabIndexSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSC::EncodedJSValue jsSVGElementPrototypeFunction_focusBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSSVGElement>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    EnsureStillAliveScope argument0 = callFrame->argument(0);
    auto optionsConversionResult = convert<IDLDictionary<FocusOptions>>(*lexicalGlobalObject, argument0.value());
    if (optionsConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.focusForBindings(optionsConversionResult.releaseReturnValue()); })));
}

JSC_DEFINE_HOST_FUNCTION(jsSVGElementPrototypeFunction_focus, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSSVGElement>::call<jsSVGElementPrototypeFunction_focusBody>(*lexicalGlobalObject, *callFrame, "focus");
}

static inline JSC::EncodedJSValue jsSVGElementPrototypeFunction_blurBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSSVGElement>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.blur(); })));
}

JSC_DEFINE_HOST_FUNCTION(jsSVGElementPrototypeFunction_blur, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSSVGElement>::call<jsSVGElementPrototypeFunction_blurBody>(*lexicalGlobalObject, *callFrame, "blur");
}

JSC::GCClient::IsoSubspace* JSSVGElement::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSSVGElement, UseCustomHeapCellType::No>(vm, "JSSVGElement"_s,
        [] (auto& spaces) { return spaces.m_clientSubspaceForSVGElement.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForSVGElement = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForSVGElement.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForSVGElement = std::forward<decltype(space)>(space); }
    );
}

template<typename Visitor>
void JSSVGElement::visitChildrenImpl(JSCell* cell, Visitor& visitor)
{
    auto* thisObject = jsCast<JSSVGElement*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Base::visitChildren(thisObject, visitor);
    visitor.append(thisObject->m_attributeStyleMap);
}

DEFINE_VISIT_CHILDREN(JSSVGElement);

void JSSVGElement::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSSVGElement*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (RefPtr context = thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, makeString("url "_s, context->url().string()));
    Base::analyzeHeap(cell, analyzer);
}

SVGElement* JSSVGElement::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSSVGElement*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
