/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSGPUBufferBindingType.h"

#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSString.h>
#include <wtf/NeverDestroyed.h>
#include <wtf/SortedArrayMap.h>



namespace WebCore {
using namespace JSC;

String convertEnumerationToString(GPUBufferBindingType enumerationValue)
{
    static const std::array<NeverDestroyed<String>, 3> values {
        MAKE_STATIC_STRING_IMPL("uniform"),
        MAKE_STATIC_STRING_IMPL("storage"),
        MAKE_STATIC_STRING_IMPL("read-only-storage"),
    };
    static_assert(static_cast<size_t>(GPUBufferBindingType::Uniform) == 0, "GPUBufferBindingType::Uniform is not 0 as expected");
    static_assert(static_cast<size_t>(GPUBufferBindingType::Storage) == 1, "GPUBufferBindingType::Storage is not 1 as expected");
    static_assert(static_cast<size_t>(GPUBufferBindingType::ReadOnlyStorage) == 2, "GPUBufferBindingType::ReadOnlyStorage is not 2 as expected");
    ASSERT(static_cast<size_t>(enumerationValue) < std::size(values));
    return values[static_cast<size_t>(enumerationValue)];
}

template<> JSString* convertEnumerationToJS(VM& vm, GPUBufferBindingType enumerationValue)
{
    return jsStringWithCache(vm, convertEnumerationToString(enumerationValue));
}

template<> std::optional<GPUBufferBindingType> parseEnumerationFromString<GPUBufferBindingType>(const String& stringValue)
{
    static constexpr std::array<std::pair<ComparableASCIILiteral, GPUBufferBindingType>, 3> mappings {
        std::pair<ComparableASCIILiteral, GPUBufferBindingType> { "read-only-storage"_s, GPUBufferBindingType::ReadOnlyStorage },
        std::pair<ComparableASCIILiteral, GPUBufferBindingType> { "storage"_s, GPUBufferBindingType::Storage },
        std::pair<ComparableASCIILiteral, GPUBufferBindingType> { "uniform"_s, GPUBufferBindingType::Uniform },
    };
    static constexpr SortedArrayMap enumerationMapping { mappings };
    if (auto* enumerationValue = enumerationMapping.tryGet(stringValue); enumerationValue) [[likely]]
        return *enumerationValue;
    return std::nullopt;
}

template<> std::optional<GPUBufferBindingType> parseEnumeration<GPUBufferBindingType>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    return parseEnumerationFromString<GPUBufferBindingType>(value.toWTFString(&lexicalGlobalObject));
}

template<> ASCIILiteral expectedEnumerationValues<GPUBufferBindingType>()
{
    return "\"uniform\", \"storage\", \"read-only-storage\""_s;
}

} // namespace WebCore

