#ifndef itkImageSourceSwigInterface_h
#define itkImageSourceSwigInterface_h
#include "itkCommand.h"
#include "itkOffset.h"
#include "itkVector.h"
#include "itkCovariantVector.h"
#include "itkContinuousIndex.h"
#include "itkArray.h"
#include "itkFixedArray.h"
#include "itkRGBPixel.h"
#include "itkRGBAPixel.h"
#include "complex"
#include "itkSymmetricSecondRankTensor.h"
#include "itkImage.h"
#include "itkVectorImage.h"
#include "itkVariableLengthVector.h"
#include "itkPoint.h"
#include "itkPhasedArray3DSpecialCoordinatesImage.h"
#include "itkImageSource.h"

using itkImageSourceIUC2 = itk::ImageSource< itk::Image< unsigned char,2 > >;
using itkImageSourceIUC2_Pointer = itk::ImageSource< itk::Image< unsigned char,2 > >::Pointer;
using itkImageSourceIUC3 = itk::ImageSource< itk::Image< unsigned char,3 > >;
using itkImageSourceIUC3_Pointer = itk::ImageSource< itk::Image< unsigned char,3 > >::Pointer;
using itkImageSourceIUC4 = itk::ImageSource< itk::Image< unsigned char,4 > >;
using itkImageSourceIUC4_Pointer = itk::ImageSource< itk::Image< unsigned char,4 > >::Pointer;
using itkImageSourceIRGBUC2 = itk::ImageSource< itk::Image< itk::RGBPixel< unsigned char >,2 > >;
using itkImageSourceIRGBUC2_Pointer = itk::ImageSource< itk::Image< itk::RGBPixel< unsigned char >,2 > >::Pointer;
using itkImageSourceIRGBUC3 = itk::ImageSource< itk::Image< itk::RGBPixel< unsigned char >,3 > >;
using itkImageSourceIRGBUC3_Pointer = itk::ImageSource< itk::Image< itk::RGBPixel< unsigned char >,3 > >::Pointer;
using itkImageSourceIRGBUC4 = itk::ImageSource< itk::Image< itk::RGBPixel< unsigned char >,4 > >;
using itkImageSourceIRGBUC4_Pointer = itk::ImageSource< itk::Image< itk::RGBPixel< unsigned char >,4 > >::Pointer;
using itkImageSourceIRGBAUC2 = itk::ImageSource< itk::Image< itk::RGBAPixel< unsigned char >,2 > >;
using itkImageSourceIRGBAUC2_Pointer = itk::ImageSource< itk::Image< itk::RGBAPixel< unsigned char >,2 > >::Pointer;
using itkImageSourceIRGBAUC3 = itk::ImageSource< itk::Image< itk::RGBAPixel< unsigned char >,3 > >;
using itkImageSourceIRGBAUC3_Pointer = itk::ImageSource< itk::Image< itk::RGBAPixel< unsigned char >,3 > >::Pointer;
using itkImageSourceIRGBAUC4 = itk::ImageSource< itk::Image< itk::RGBAPixel< unsigned char >,4 > >;
using itkImageSourceIRGBAUC4_Pointer = itk::ImageSource< itk::Image< itk::RGBAPixel< unsigned char >,4 > >::Pointer;
using itkImageSourceISI2 = itk::ImageSource< itk::Image< signed int,2 > >;
using itkImageSourceISI2_Pointer = itk::ImageSource< itk::Image< signed int,2 > >::Pointer;
using itkImageSourceISI3 = itk::ImageSource< itk::Image< signed int,3 > >;
using itkImageSourceISI3_Pointer = itk::ImageSource< itk::Image< signed int,3 > >::Pointer;
using itkImageSourceISI4 = itk::ImageSource< itk::Image< signed int,4 > >;
using itkImageSourceISI4_Pointer = itk::ImageSource< itk::Image< signed int,4 > >::Pointer;
using itkImageSourceIUI2 = itk::ImageSource< itk::Image< unsigned int,2 > >;
using itkImageSourceIUI2_Pointer = itk::ImageSource< itk::Image< unsigned int,2 > >::Pointer;
using itkImageSourceIUI3 = itk::ImageSource< itk::Image< unsigned int,3 > >;
using itkImageSourceIUI3_Pointer = itk::ImageSource< itk::Image< unsigned int,3 > >::Pointer;
using itkImageSourceIUI4 = itk::ImageSource< itk::Image< unsigned int,4 > >;
using itkImageSourceIUI4_Pointer = itk::ImageSource< itk::Image< unsigned int,4 > >::Pointer;
using itkImageSourceIUL2 = itk::ImageSource< itk::Image< unsigned long,2 > >;
using itkImageSourceIUL2_Pointer = itk::ImageSource< itk::Image< unsigned long,2 > >::Pointer;
using itkImageSourceIUL3 = itk::ImageSource< itk::Image< unsigned long,3 > >;
using itkImageSourceIUL3_Pointer = itk::ImageSource< itk::Image< unsigned long,3 > >::Pointer;
using itkImageSourceIUL4 = itk::ImageSource< itk::Image< unsigned long,4 > >;
using itkImageSourceIUL4_Pointer = itk::ImageSource< itk::Image< unsigned long,4 > >::Pointer;
using itkImageSourceIULL2 = itk::ImageSource< itk::Image< unsigned long long,2 > >;
using itkImageSourceIULL2_Pointer = itk::ImageSource< itk::Image< unsigned long long,2 > >::Pointer;
using itkImageSourceIULL3 = itk::ImageSource< itk::Image< unsigned long long,3 > >;
using itkImageSourceIULL3_Pointer = itk::ImageSource< itk::Image< unsigned long long,3 > >::Pointer;
using itkImageSourceIULL4 = itk::ImageSource< itk::Image< unsigned long long,4 > >;
using itkImageSourceIULL4_Pointer = itk::ImageSource< itk::Image< unsigned long long,4 > >::Pointer;
using itkImageSourceIRGBUS2 = itk::ImageSource< itk::Image< itk::RGBPixel< unsigned short >,2 > >;
using itkImageSourceIRGBUS2_Pointer = itk::ImageSource< itk::Image< itk::RGBPixel< unsigned short >,2 > >::Pointer;
using itkImageSourceIRGBUS3 = itk::ImageSource< itk::Image< itk::RGBPixel< unsigned short >,3 > >;
using itkImageSourceIRGBUS3_Pointer = itk::ImageSource< itk::Image< itk::RGBPixel< unsigned short >,3 > >::Pointer;
using itkImageSourceIRGBUS4 = itk::ImageSource< itk::Image< itk::RGBPixel< unsigned short >,4 > >;
using itkImageSourceIRGBUS4_Pointer = itk::ImageSource< itk::Image< itk::RGBPixel< unsigned short >,4 > >::Pointer;
using itkImageSourceIRGBAUS2 = itk::ImageSource< itk::Image< itk::RGBAPixel< unsigned short >,2 > >;
using itkImageSourceIRGBAUS2_Pointer = itk::ImageSource< itk::Image< itk::RGBAPixel< unsigned short >,2 > >::Pointer;
using itkImageSourceIRGBAUS3 = itk::ImageSource< itk::Image< itk::RGBAPixel< unsigned short >,3 > >;
using itkImageSourceIRGBAUS3_Pointer = itk::ImageSource< itk::Image< itk::RGBAPixel< unsigned short >,3 > >::Pointer;
using itkImageSourceIRGBAUS4 = itk::ImageSource< itk::Image< itk::RGBAPixel< unsigned short >,4 > >;
using itkImageSourceIRGBAUS4_Pointer = itk::ImageSource< itk::Image< itk::RGBAPixel< unsigned short >,4 > >::Pointer;
using itkImageSourceIVD22 = itk::ImageSource< itk::Image< itk::Vector< double,2 >,2 > >;
using itkImageSourceIVD22_Pointer = itk::ImageSource< itk::Image< itk::Vector< double,2 >,2 > >::Pointer;
using itkImageSourceIVD23 = itk::ImageSource< itk::Image< itk::Vector< double,2 >,3 > >;
using itkImageSourceIVD23_Pointer = itk::ImageSource< itk::Image< itk::Vector< double,2 >,3 > >::Pointer;
using itkImageSourceIVD24 = itk::ImageSource< itk::Image< itk::Vector< double,2 >,4 > >;
using itkImageSourceIVD24_Pointer = itk::ImageSource< itk::Image< itk::Vector< double,2 >,4 > >::Pointer;
using itkImageSourceIVD32 = itk::ImageSource< itk::Image< itk::Vector< double,3 >,2 > >;
using itkImageSourceIVD32_Pointer = itk::ImageSource< itk::Image< itk::Vector< double,3 >,2 > >::Pointer;
using itkImageSourceIVD33 = itk::ImageSource< itk::Image< itk::Vector< double,3 >,3 > >;
using itkImageSourceIVD33_Pointer = itk::ImageSource< itk::Image< itk::Vector< double,3 >,3 > >::Pointer;
using itkImageSourceIVD34 = itk::ImageSource< itk::Image< itk::Vector< double,3 >,4 > >;
using itkImageSourceIVD34_Pointer = itk::ImageSource< itk::Image< itk::Vector< double,3 >,4 > >::Pointer;
using itkImageSourceIVD42 = itk::ImageSource< itk::Image< itk::Vector< double,4 >,2 > >;
using itkImageSourceIVD42_Pointer = itk::ImageSource< itk::Image< itk::Vector< double,4 >,2 > >::Pointer;
using itkImageSourceIVD43 = itk::ImageSource< itk::Image< itk::Vector< double,4 >,3 > >;
using itkImageSourceIVD43_Pointer = itk::ImageSource< itk::Image< itk::Vector< double,4 >,3 > >::Pointer;
using itkImageSourceIVD44 = itk::ImageSource< itk::Image< itk::Vector< double,4 >,4 > >;
using itkImageSourceIVD44_Pointer = itk::ImageSource< itk::Image< itk::Vector< double,4 >,4 > >::Pointer;
using itkImageSourceIVF22 = itk::ImageSource< itk::Image< itk::Vector< float,2 >,2 > >;
using itkImageSourceIVF22_Pointer = itk::ImageSource< itk::Image< itk::Vector< float,2 >,2 > >::Pointer;
using itkImageSourceIVF23 = itk::ImageSource< itk::Image< itk::Vector< float,2 >,3 > >;
using itkImageSourceIVF23_Pointer = itk::ImageSource< itk::Image< itk::Vector< float,2 >,3 > >::Pointer;
using itkImageSourceIVF24 = itk::ImageSource< itk::Image< itk::Vector< float,2 >,4 > >;
using itkImageSourceIVF24_Pointer = itk::ImageSource< itk::Image< itk::Vector< float,2 >,4 > >::Pointer;
using itkImageSourceIVF32 = itk::ImageSource< itk::Image< itk::Vector< float,3 >,2 > >;
using itkImageSourceIVF32_Pointer = itk::ImageSource< itk::Image< itk::Vector< float,3 >,2 > >::Pointer;
using itkImageSourceIVF33 = itk::ImageSource< itk::Image< itk::Vector< float,3 >,3 > >;
using itkImageSourceIVF33_Pointer = itk::ImageSource< itk::Image< itk::Vector< float,3 >,3 > >::Pointer;
using itkImageSourceIVF34 = itk::ImageSource< itk::Image< itk::Vector< float,3 >,4 > >;
using itkImageSourceIVF34_Pointer = itk::ImageSource< itk::Image< itk::Vector< float,3 >,4 > >::Pointer;
using itkImageSourceIVF42 = itk::ImageSource< itk::Image< itk::Vector< float,4 >,2 > >;
using itkImageSourceIVF42_Pointer = itk::ImageSource< itk::Image< itk::Vector< float,4 >,2 > >::Pointer;
using itkImageSourceIVF43 = itk::ImageSource< itk::Image< itk::Vector< float,4 >,3 > >;
using itkImageSourceIVF43_Pointer = itk::ImageSource< itk::Image< itk::Vector< float,4 >,3 > >::Pointer;
using itkImageSourceIVF44 = itk::ImageSource< itk::Image< itk::Vector< float,4 >,4 > >;
using itkImageSourceIVF44_Pointer = itk::ImageSource< itk::Image< itk::Vector< float,4 >,4 > >::Pointer;
using itkImageSourceICVD22 = itk::ImageSource< itk::Image< itk::CovariantVector< double,2 >,2 > >;
using itkImageSourceICVD22_Pointer = itk::ImageSource< itk::Image< itk::CovariantVector< double,2 >,2 > >::Pointer;
using itkImageSourceICVD23 = itk::ImageSource< itk::Image< itk::CovariantVector< double,2 >,3 > >;
using itkImageSourceICVD23_Pointer = itk::ImageSource< itk::Image< itk::CovariantVector< double,2 >,3 > >::Pointer;
using itkImageSourceICVD24 = itk::ImageSource< itk::Image< itk::CovariantVector< double,2 >,4 > >;
using itkImageSourceICVD24_Pointer = itk::ImageSource< itk::Image< itk::CovariantVector< double,2 >,4 > >::Pointer;
using itkImageSourceICVD32 = itk::ImageSource< itk::Image< itk::CovariantVector< double,3 >,2 > >;
using itkImageSourceICVD32_Pointer = itk::ImageSource< itk::Image< itk::CovariantVector< double,3 >,2 > >::Pointer;
using itkImageSourceICVD33 = itk::ImageSource< itk::Image< itk::CovariantVector< double,3 >,3 > >;
using itkImageSourceICVD33_Pointer = itk::ImageSource< itk::Image< itk::CovariantVector< double,3 >,3 > >::Pointer;
using itkImageSourceICVD34 = itk::ImageSource< itk::Image< itk::CovariantVector< double,3 >,4 > >;
using itkImageSourceICVD34_Pointer = itk::ImageSource< itk::Image< itk::CovariantVector< double,3 >,4 > >::Pointer;
using itkImageSourceICVD42 = itk::ImageSource< itk::Image< itk::CovariantVector< double,4 >,2 > >;
using itkImageSourceICVD42_Pointer = itk::ImageSource< itk::Image< itk::CovariantVector< double,4 >,2 > >::Pointer;
using itkImageSourceICVD43 = itk::ImageSource< itk::Image< itk::CovariantVector< double,4 >,3 > >;
using itkImageSourceICVD43_Pointer = itk::ImageSource< itk::Image< itk::CovariantVector< double,4 >,3 > >::Pointer;
using itkImageSourceICVD44 = itk::ImageSource< itk::Image< itk::CovariantVector< double,4 >,4 > >;
using itkImageSourceICVD44_Pointer = itk::ImageSource< itk::Image< itk::CovariantVector< double,4 >,4 > >::Pointer;
using itkImageSourceICVF22 = itk::ImageSource< itk::Image< itk::CovariantVector< float,2 >,2 > >;
using itkImageSourceICVF22_Pointer = itk::ImageSource< itk::Image< itk::CovariantVector< float,2 >,2 > >::Pointer;
using itkImageSourceICVF23 = itk::ImageSource< itk::Image< itk::CovariantVector< float,2 >,3 > >;
using itkImageSourceICVF23_Pointer = itk::ImageSource< itk::Image< itk::CovariantVector< float,2 >,3 > >::Pointer;
using itkImageSourceICVF24 = itk::ImageSource< itk::Image< itk::CovariantVector< float,2 >,4 > >;
using itkImageSourceICVF24_Pointer = itk::ImageSource< itk::Image< itk::CovariantVector< float,2 >,4 > >::Pointer;
using itkImageSourceICVF32 = itk::ImageSource< itk::Image< itk::CovariantVector< float,3 >,2 > >;
using itkImageSourceICVF32_Pointer = itk::ImageSource< itk::Image< itk::CovariantVector< float,3 >,2 > >::Pointer;
using itkImageSourceICVF33 = itk::ImageSource< itk::Image< itk::CovariantVector< float,3 >,3 > >;
using itkImageSourceICVF33_Pointer = itk::ImageSource< itk::Image< itk::CovariantVector< float,3 >,3 > >::Pointer;
using itkImageSourceICVF34 = itk::ImageSource< itk::Image< itk::CovariantVector< float,3 >,4 > >;
using itkImageSourceICVF34_Pointer = itk::ImageSource< itk::Image< itk::CovariantVector< float,3 >,4 > >::Pointer;
using itkImageSourceICVF42 = itk::ImageSource< itk::Image< itk::CovariantVector< float,4 >,2 > >;
using itkImageSourceICVF42_Pointer = itk::ImageSource< itk::Image< itk::CovariantVector< float,4 >,2 > >::Pointer;
using itkImageSourceICVF43 = itk::ImageSource< itk::Image< itk::CovariantVector< float,4 >,3 > >;
using itkImageSourceICVF43_Pointer = itk::ImageSource< itk::Image< itk::CovariantVector< float,4 >,3 > >::Pointer;
using itkImageSourceICVF44 = itk::ImageSource< itk::Image< itk::CovariantVector< float,4 >,4 > >;
using itkImageSourceICVF44_Pointer = itk::ImageSource< itk::Image< itk::CovariantVector< float,4 >,4 > >::Pointer;
using itkImageSourceISC2 = itk::ImageSource< itk::Image< signed char,2 > >;
using itkImageSourceISC2_Pointer = itk::ImageSource< itk::Image< signed char,2 > >::Pointer;
using itkImageSourceISC3 = itk::ImageSource< itk::Image< signed char,3 > >;
using itkImageSourceISC3_Pointer = itk::ImageSource< itk::Image< signed char,3 > >::Pointer;
using itkImageSourceISC4 = itk::ImageSource< itk::Image< signed char,4 > >;
using itkImageSourceISC4_Pointer = itk::ImageSource< itk::Image< signed char,4 > >::Pointer;
using itkImageSourceISS2 = itk::ImageSource< itk::Image< signed short,2 > >;
using itkImageSourceISS2_Pointer = itk::ImageSource< itk::Image< signed short,2 > >::Pointer;
using itkImageSourceISS3 = itk::ImageSource< itk::Image< signed short,3 > >;
using itkImageSourceISS3_Pointer = itk::ImageSource< itk::Image< signed short,3 > >::Pointer;
using itkImageSourceISS4 = itk::ImageSource< itk::Image< signed short,4 > >;
using itkImageSourceISS4_Pointer = itk::ImageSource< itk::Image< signed short,4 > >::Pointer;
using itkImageSourceIUS2 = itk::ImageSource< itk::Image< unsigned short,2 > >;
using itkImageSourceIUS2_Pointer = itk::ImageSource< itk::Image< unsigned short,2 > >::Pointer;
using itkImageSourceIUS3 = itk::ImageSource< itk::Image< unsigned short,3 > >;
using itkImageSourceIUS3_Pointer = itk::ImageSource< itk::Image< unsigned short,3 > >::Pointer;
using itkImageSourceIUS4 = itk::ImageSource< itk::Image< unsigned short,4 > >;
using itkImageSourceIUS4_Pointer = itk::ImageSource< itk::Image< unsigned short,4 > >::Pointer;
using itkImageSourceIF2 = itk::ImageSource< itk::Image< float,2 > >;
using itkImageSourceIF2_Pointer = itk::ImageSource< itk::Image< float,2 > >::Pointer;
using itkImageSourceIF3 = itk::ImageSource< itk::Image< float,3 > >;
using itkImageSourceIF3_Pointer = itk::ImageSource< itk::Image< float,3 > >::Pointer;
using itkImageSourceIF4 = itk::ImageSource< itk::Image< float,4 > >;
using itkImageSourceIF4_Pointer = itk::ImageSource< itk::Image< float,4 > >::Pointer;
using itkImageSourceID2 = itk::ImageSource< itk::Image< double,2 > >;
using itkImageSourceID2_Pointer = itk::ImageSource< itk::Image< double,2 > >::Pointer;
using itkImageSourceID3 = itk::ImageSource< itk::Image< double,3 > >;
using itkImageSourceID3_Pointer = itk::ImageSource< itk::Image< double,3 > >::Pointer;
using itkImageSourceID4 = itk::ImageSource< itk::Image< double,4 > >;
using itkImageSourceID4_Pointer = itk::ImageSource< itk::Image< double,4 > >::Pointer;
using itkImageSourceICD2 = itk::ImageSource< itk::Image< std::complex< double >,2 > >;
using itkImageSourceICD2_Pointer = itk::ImageSource< itk::Image< std::complex< double >,2 > >::Pointer;
using itkImageSourceICD3 = itk::ImageSource< itk::Image< std::complex< double >,3 > >;
using itkImageSourceICD3_Pointer = itk::ImageSource< itk::Image< std::complex< double >,3 > >::Pointer;
using itkImageSourceICD4 = itk::ImageSource< itk::Image< std::complex< double >,4 > >;
using itkImageSourceICD4_Pointer = itk::ImageSource< itk::Image< std::complex< double >,4 > >::Pointer;
using itkImageSourceICF2 = itk::ImageSource< itk::Image< std::complex< float >,2 > >;
using itkImageSourceICF2_Pointer = itk::ImageSource< itk::Image< std::complex< float >,2 > >::Pointer;
using itkImageSourceICF3 = itk::ImageSource< itk::Image< std::complex< float >,3 > >;
using itkImageSourceICF3_Pointer = itk::ImageSource< itk::Image< std::complex< float >,3 > >::Pointer;
using itkImageSourceICF4 = itk::ImageSource< itk::Image< std::complex< float >,4 > >;
using itkImageSourceICF4_Pointer = itk::ImageSource< itk::Image< std::complex< float >,4 > >::Pointer;
using itkImageSourceVISC2 = itk::ImageSource< itk::VectorImage< signed char,2 > >;
using itkImageSourceVISC2_Pointer = itk::ImageSource< itk::VectorImage< signed char,2 > >::Pointer;
using itkImageSourceVISS2 = itk::ImageSource< itk::VectorImage< signed short,2 > >;
using itkImageSourceVISS2_Pointer = itk::ImageSource< itk::VectorImage< signed short,2 > >::Pointer;
using itkImageSourceVIUC2 = itk::ImageSource< itk::VectorImage< unsigned char,2 > >;
using itkImageSourceVIUC2_Pointer = itk::ImageSource< itk::VectorImage< unsigned char,2 > >::Pointer;
using itkImageSourceVIULL2 = itk::ImageSource< itk::VectorImage< unsigned long long,2 > >;
using itkImageSourceVIULL2_Pointer = itk::ImageSource< itk::VectorImage< unsigned long long,2 > >::Pointer;
using itkImageSourceVIUS2 = itk::ImageSource< itk::VectorImage< unsigned short,2 > >;
using itkImageSourceVIUS2_Pointer = itk::ImageSource< itk::VectorImage< unsigned short,2 > >::Pointer;
using itkImageSourceVIF2 = itk::ImageSource< itk::VectorImage< float,2 > >;
using itkImageSourceVIF2_Pointer = itk::ImageSource< itk::VectorImage< float,2 > >::Pointer;
using itkImageSourceVID2 = itk::ImageSource< itk::VectorImage< double,2 > >;
using itkImageSourceVID2_Pointer = itk::ImageSource< itk::VectorImage< double,2 > >::Pointer;
using itkImageSourceISSRTF22 = itk::ImageSource< itk::Image< itk::SymmetricSecondRankTensor< float, 2 >, 2 > >;
using itkImageSourceISSRTF22_Pointer = itk::ImageSource< itk::Image< itk::SymmetricSecondRankTensor< float, 2 >, 2 > >::Pointer;
using itkImageSourceISSRTD22 = itk::ImageSource< itk::Image< itk::SymmetricSecondRankTensor< double, 2 >, 2 > >;
using itkImageSourceISSRTD22_Pointer = itk::ImageSource< itk::Image< itk::SymmetricSecondRankTensor< double, 2 >, 2 > >::Pointer;
using itkImageSourceVISC3 = itk::ImageSource< itk::VectorImage< signed char,3 > >;
using itkImageSourceVISC3_Pointer = itk::ImageSource< itk::VectorImage< signed char,3 > >::Pointer;
using itkImageSourceVISS3 = itk::ImageSource< itk::VectorImage< signed short,3 > >;
using itkImageSourceVISS3_Pointer = itk::ImageSource< itk::VectorImage< signed short,3 > >::Pointer;
using itkImageSourceVIUC3 = itk::ImageSource< itk::VectorImage< unsigned char,3 > >;
using itkImageSourceVIUC3_Pointer = itk::ImageSource< itk::VectorImage< unsigned char,3 > >::Pointer;
using itkImageSourceVIULL3 = itk::ImageSource< itk::VectorImage< unsigned long long,3 > >;
using itkImageSourceVIULL3_Pointer = itk::ImageSource< itk::VectorImage< unsigned long long,3 > >::Pointer;
using itkImageSourceVIUS3 = itk::ImageSource< itk::VectorImage< unsigned short,3 > >;
using itkImageSourceVIUS3_Pointer = itk::ImageSource< itk::VectorImage< unsigned short,3 > >::Pointer;
using itkImageSourceVIF3 = itk::ImageSource< itk::VectorImage< float,3 > >;
using itkImageSourceVIF3_Pointer = itk::ImageSource< itk::VectorImage< float,3 > >::Pointer;
using itkImageSourceVID3 = itk::ImageSource< itk::VectorImage< double,3 > >;
using itkImageSourceVID3_Pointer = itk::ImageSource< itk::VectorImage< double,3 > >::Pointer;
using itkImageSourceISSRTF33 = itk::ImageSource< itk::Image< itk::SymmetricSecondRankTensor< float, 3 >, 3 > >;
using itkImageSourceISSRTF33_Pointer = itk::ImageSource< itk::Image< itk::SymmetricSecondRankTensor< float, 3 >, 3 > >::Pointer;
using itkImageSourceISSRTD33 = itk::ImageSource< itk::Image< itk::SymmetricSecondRankTensor< double, 3 >, 3 > >;
using itkImageSourceISSRTD33_Pointer = itk::ImageSource< itk::Image< itk::SymmetricSecondRankTensor< double, 3 >, 3 > >::Pointer;
using itkImageSourceVISC4 = itk::ImageSource< itk::VectorImage< signed char,4 > >;
using itkImageSourceVISC4_Pointer = itk::ImageSource< itk::VectorImage< signed char,4 > >::Pointer;
using itkImageSourceVISS4 = itk::ImageSource< itk::VectorImage< signed short,4 > >;
using itkImageSourceVISS4_Pointer = itk::ImageSource< itk::VectorImage< signed short,4 > >::Pointer;
using itkImageSourceVIUC4 = itk::ImageSource< itk::VectorImage< unsigned char,4 > >;
using itkImageSourceVIUC4_Pointer = itk::ImageSource< itk::VectorImage< unsigned char,4 > >::Pointer;
using itkImageSourceVIULL4 = itk::ImageSource< itk::VectorImage< unsigned long long,4 > >;
using itkImageSourceVIULL4_Pointer = itk::ImageSource< itk::VectorImage< unsigned long long,4 > >::Pointer;
using itkImageSourceVIUS4 = itk::ImageSource< itk::VectorImage< unsigned short,4 > >;
using itkImageSourceVIUS4_Pointer = itk::ImageSource< itk::VectorImage< unsigned short,4 > >::Pointer;
using itkImageSourceVIF4 = itk::ImageSource< itk::VectorImage< float,4 > >;
using itkImageSourceVIF4_Pointer = itk::ImageSource< itk::VectorImage< float,4 > >::Pointer;
using itkImageSourceVID4 = itk::ImageSource< itk::VectorImage< double,4 > >;
using itkImageSourceVID4_Pointer = itk::ImageSource< itk::VectorImage< double,4 > >::Pointer;
using itkImageSourceISSRTF44 = itk::ImageSource< itk::Image< itk::SymmetricSecondRankTensor< float, 4 >, 4 > >;
using itkImageSourceISSRTF44_Pointer = itk::ImageSource< itk::Image< itk::SymmetricSecondRankTensor< float, 4 >, 4 > >::Pointer;
using itkImageSourceISSRTD44 = itk::ImageSource< itk::Image< itk::SymmetricSecondRankTensor< double, 4 >, 4 > >;
using itkImageSourceISSRTD44_Pointer = itk::ImageSource< itk::Image< itk::SymmetricSecondRankTensor< double, 4 >, 4 > >::Pointer;
using itkImageSourcePA3DSCISC = itk::ImageSource< itk::PhasedArray3DSpecialCoordinatesImage<signed char> >;
using itkImageSourcePA3DSCISC_Pointer = itk::ImageSource< itk::PhasedArray3DSpecialCoordinatesImage<signed char> >::Pointer;
using itkImageSourcePA3DSCISS = itk::ImageSource< itk::PhasedArray3DSpecialCoordinatesImage<signed short> >;
using itkImageSourcePA3DSCISS_Pointer = itk::ImageSource< itk::PhasedArray3DSpecialCoordinatesImage<signed short> >::Pointer;
using itkImageSourcePA3DSCIUC = itk::ImageSource< itk::PhasedArray3DSpecialCoordinatesImage<unsigned char> >;
using itkImageSourcePA3DSCIUC_Pointer = itk::ImageSource< itk::PhasedArray3DSpecialCoordinatesImage<unsigned char> >::Pointer;
using itkImageSourcePA3DSCIULL = itk::ImageSource< itk::PhasedArray3DSpecialCoordinatesImage<unsigned long long> >;
using itkImageSourcePA3DSCIULL_Pointer = itk::ImageSource< itk::PhasedArray3DSpecialCoordinatesImage<unsigned long long> >::Pointer;
using itkImageSourcePA3DSCIUS = itk::ImageSource< itk::PhasedArray3DSpecialCoordinatesImage<unsigned short> >;
using itkImageSourcePA3DSCIUS_Pointer = itk::ImageSource< itk::PhasedArray3DSpecialCoordinatesImage<unsigned short> >::Pointer;
using itkImageSourcePA3DSCIF = itk::ImageSource< itk::PhasedArray3DSpecialCoordinatesImage<float> >;
using itkImageSourcePA3DSCIF_Pointer = itk::ImageSource< itk::PhasedArray3DSpecialCoordinatesImage<float> >::Pointer;
using itkImageSourcePA3DSCID = itk::ImageSource< itk::PhasedArray3DSpecialCoordinatesImage<double> >;
using itkImageSourcePA3DSCID_Pointer = itk::ImageSource< itk::PhasedArray3DSpecialCoordinatesImage<double> >::Pointer;
using itkImageSourcePA3DSCICD = itk::ImageSource< itk::PhasedArray3DSpecialCoordinatesImage<std::complex< double >> >;
using itkImageSourcePA3DSCICD_Pointer = itk::ImageSource< itk::PhasedArray3DSpecialCoordinatesImage<std::complex< double >> >::Pointer;
using itkImageSourcePA3DSCICF = itk::ImageSource< itk::PhasedArray3DSpecialCoordinatesImage<std::complex< float >> >;
using itkImageSourcePA3DSCICF_Pointer = itk::ImageSource< itk::PhasedArray3DSpecialCoordinatesImage<std::complex< float >> >::Pointer;


#include "itkPhasedArray3DSpecialCoordinatesImageSwigInterface.h"
#include "ITKCommonBaseSwigInterface.h"
#include "itkImageSwigInterface.h"
#include "itkImageRegionSwigInterface.h"
#include "itkVectorImageSwigInterface.h"
#include "itkImageSourceCommonSwigInterface.h"
#include "itkImageSourceSwigInterface.h"
#endif
