/* A Bison parser, made by GNU Bison 3.8.2.  */

/* Bison implementation for Yacc-like parsers in C

   Copyright (C) 1984, 1989-1990, 2000-2015, 2018-2021 Free Software Foundation,
   Inc.

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <https://www.gnu.org/licenses/>.  */

/* As a special exception, you may create a larger work that contains
   part or all of the Bison parser skeleton and distribute that work
   under terms of your choice, so long as that work isn't itself a
   parser generator using the skeleton or a modified version thereof
   as a parser skeleton.  Alternatively, if you modify or redistribute
   the parser skeleton itself, you may (at your option) remove this
   special exception, which will cause the skeleton and the resulting
   Bison output files to be licensed under the GNU General Public
   License without this special exception.

   This special exception was added by the Free Software Foundation in
   version 2.2 of Bison.  */

/* C LALR(1) parser skeleton written by Richard Stallman, by
   simplifying the original so-called "semantic" parser.  */

/* DO NOT RELY ON FEATURES THAT ARE NOT DOCUMENTED in the manual,
   especially those whose name start with YY_ or yy_.  They are
   private implementation details that can be changed or removed.  */

/* All symbols defined below should begin with yy or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

/* Identify Bison output, and Bison version.  */
#define YYBISON 30802

/* Bison version string.  */
#define YYBISON_VERSION "3.8.2"

/* Skeleton name.  */
#define YYSKELETON_NAME "yacc.c"

/* Pure parsers.  */
#define YYPURE 0

/* Push parsers.  */
#define YYPUSH 0

/* Pull parsers.  */
#define YYPULL 1


/* Substitute the variable and function names.  */
#define yyparse         CISAparse
#define yylex           CISAlex
#define yyerror         CISAerror
#define yydebug         CISAdebug
#define yynerrs         CISAnerrs
#define yylval          CISAlval
#define yychar          CISAchar

/* First part of user prologue.  */
#line 9 "CISA.y"

#include <stdio.h>
#include <math.h>
#include <string>
#include <vector>

#include "visa_igc_common_header.h"
#include "Common_ISA.h"
#include "Common_ISA_util.h"
#include "Common_ISA_framework.h"
#include "JitterDataStruct.h"
#include "VISAKernel.h"

static int lscCheckExecSize(
    CISA_IR_Builder* pBuilder,
    LSC_SFID sfid,
    LSC_OP op,
    LSC_DATA_ORDER data_order,
    int exec_size);

void CISAerror(CISA_IR_Builder* builder, char const* msg);
int yylex(CISA_IR_Builder *pBuilder);
extern int CISAlineno;

[[maybe_unused]] static bool streq(const char *sym0, const char *sym1);
static bool ParseAlign(CISA_IR_Builder* pBuilder, const char *sym, VISA_Align &value);
static bool AlignBytesToVisaAlignment(int bytes, VISA_Align &val);
static bool ParseEMask(const char* sym, VISA_EMask_Ctrl &emask);

//
// check if the cond is true.
// if cond is false, then print errorMessage (syntax error) and YYABORT
#define MUST_HOLD(cond, errorMessage) \
  {if (!(cond)) {pBuilder->RecordParseError(CISAlineno, errorMessage); YYABORT;}}
#define PARSE_ERROR_AT(LINE,...)\
  {pBuilder->RecordParseError(LINE, __VA_ARGS__); YYABORT;}
#define PARSE_ERROR(...)\
    PARSE_ERROR_AT(CISAlineno, __VA_ARGS__)

// Use this to wrap API calls that return false, nullptr, or 0 on failure
// It's assumed that the API call reported the parse error
#define ABORT_ON_FAIL(X) \
    do \
        if (!(X)) \
            YYABORT;\
    while (0)
#define TRACE(S) \
    do { \
      if (CISAout && pBuilder->debugParse()) \
          fprintf(CISAout, "line %d: %s", CISAlineno, S); \
    } while (0)

std::deque<const char*> switchLabels;
std::vector<VISA_opnd*> RTRWOperandsVec;

VISA_RawOpnd* rawOperandArray[16];

// global var for non-kernel attribute option.
// The var needs to be cleared before each use.
std::vector<attr_gen_struct*> AttrOptVar;


#line 141 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"

# ifndef YY_CAST
#  ifdef __cplusplus
#   define YY_CAST(Type, Val) static_cast<Type> (Val)
#   define YY_REINTERPRET_CAST(Type, Val) reinterpret_cast<Type> (Val)
#  else
#   define YY_CAST(Type, Val) ((Type) (Val))
#   define YY_REINTERPRET_CAST(Type, Val) ((Type) (Val))
#  endif
# endif
# ifndef YY_NULLPTR
#  if defined __cplusplus
#   if 201103L <= __cplusplus
#    define YY_NULLPTR nullptr
#   else
#    define YY_NULLPTR 0
#   endif
#  else
#   define YY_NULLPTR ((void*)0)
#  endif
# endif

#include "CISA.tab.hpp"
/* Symbol kind.  */
enum yysymbol_kind_t
{
  YYSYMBOL_YYEMPTY = -2,
  YYSYMBOL_YYEOF = 0,                      /* "end of file"  */
  YYSYMBOL_YYerror = 1,                    /* error  */
  YYSYMBOL_YYUNDEF = 2,                    /* "invalid token"  */
  YYSYMBOL_ALIGN_KEYWORD = 3,              /* ALIGN_KEYWORD  */
  YYSYMBOL_ATOMIC_SUB_OP = 4,              /* ATOMIC_SUB_OP  */
  YYSYMBOL_DIRECTIVE_DECL = 5,             /* DIRECTIVE_DECL  */
  YYSYMBOL_DIRECTIVE_FUNC = 6,             /* DIRECTIVE_FUNC  */
  YYSYMBOL_DIRECTIVE_FUNCDECL = 7,         /* DIRECTIVE_FUNCDECL  */
  YYSYMBOL_DIRECTIVE_GLOBAL_FUNC = 8,      /* DIRECTIVE_GLOBAL_FUNC  */
  YYSYMBOL_DIRECTIVE_IMPLICIT = 9,         /* DIRECTIVE_IMPLICIT  */
  YYSYMBOL_DIRECTIVE_INPUT = 10,           /* DIRECTIVE_INPUT  */
  YYSYMBOL_DIRECTIVE_KERNEL = 11,          /* DIRECTIVE_KERNEL  */
  YYSYMBOL_DIRECTIVE_KERNEL_ATTR = 12,     /* DIRECTIVE_KERNEL_ATTR  */
  YYSYMBOL_DIRECTIVE_VERSION = 13,         /* DIRECTIVE_VERSION  */
  YYSYMBOL_ALIAS_EQ = 14,                  /* ALIAS_EQ  */
  YYSYMBOL_ALIGN_EQ = 15,                  /* ALIGN_EQ  */
  YYSYMBOL_ATTR_EQ = 16,                   /* ATTR_EQ  */
  YYSYMBOL_OFFSET_EQ = 17,                 /* OFFSET_EQ  */
  YYSYMBOL_NUM_ELTS_EQ = 18,               /* NUM_ELTS_EQ  */
  YYSYMBOL_V_NAME_EQ = 19,                 /* V_NAME_EQ  */
  YYSYMBOL_SIZE_EQ = 20,                   /* SIZE_EQ  */
  YYSYMBOL_V_TYPE_EQ_G = 21,               /* V_TYPE_EQ_G  */
  YYSYMBOL_V_TYPE_EQ_P = 22,               /* V_TYPE_EQ_P  */
  YYSYMBOL_V_TYPE_EQ_A = 23,               /* V_TYPE_EQ_A  */
  YYSYMBOL_V_TYPE_EQ_S = 24,               /* V_TYPE_EQ_S  */
  YYSYMBOL_V_TYPE_EQ_T = 25,               /* V_TYPE_EQ_T  */
  YYSYMBOL_CPS = 26,                       /* CPS  */
  YYSYMBOL_NON_UNIFORM_SAMPLER = 27,       /* NON_UNIFORM_SAMPLER  */
  YYSYMBOL_PIXEL_NULL_MASK = 28,           /* PIXEL_NULL_MASK  */
  YYSYMBOL_RAW_SEND_STRING = 29,           /* RAW_SEND_STRING  */
  YYSYMBOL_RAW_SENDC_STRING = 30,          /* RAW_SENDC_STRING  */
  YYSYMBOL_RAW_SENDS_STRING = 31,          /* RAW_SENDS_STRING  */
  YYSYMBOL_RAW_SENDS_EOT_STRING = 32,      /* RAW_SENDS_EOT_STRING  */
  YYSYMBOL_RAW_SENDSC_STRING = 33,         /* RAW_SENDSC_STRING  */
  YYSYMBOL_RAW_SENDSC_EOT_STRING = 34,     /* RAW_SENDSC_EOT_STRING  */
  YYSYMBOL_RAW_SENDG_STRING = 35,          /* RAW_SENDG_STRING  */
  YYSYMBOL_RAW_SENDG_EOT_STRING = 36,      /* RAW_SENDG_EOT_STRING  */
  YYSYMBOL_RAW_SENDGC_STRING = 37,         /* RAW_SENDGC_STRING  */
  YYSYMBOL_RAW_SENDGC_EOT_STRING = 38,     /* RAW_SENDGC_EOT_STRING  */
  YYSYMBOL_SAT = 39,                       /* SAT  */
  YYSYMBOL_SRCMOD_ABS = 40,                /* SRCMOD_ABS  */
  YYSYMBOL_SRCMOD_NEG = 41,                /* SRCMOD_NEG  */
  YYSYMBOL_SRCMOD_NEGABS = 42,             /* SRCMOD_NEGABS  */
  YYSYMBOL_SRCMOD_NOT = 43,                /* SRCMOD_NOT  */
  YYSYMBOL_BFN_OP = 44,                    /* BFN_OP  */
  YYSYMBOL_DPAS_OP = 45,                   /* DPAS_OP  */
  YYSYMBOL_SVM_ALIGNED = 46,               /* SVM_ALIGNED  */
  YYSYMBOL_SVM_UNALIGNED = 47,             /* SVM_UNALIGNED  */
  YYSYMBOL_BDPAS_OP = 48,                  /* BDPAS_OP  */
  YYSYMBOL_NBARRIER_SIGNAL = 49,           /* NBARRIER_SIGNAL  */
  YYSYMBOL_NBARRIER_WAIT = 50,             /* NBARRIER_WAIT  */
  YYSYMBOL_ITYPE = 51,                     /* ITYPE  */
  YYSYMBOL_DECL_DATA_TYPE = 52,            /* DECL_DATA_TYPE  */
  YYSYMBOL_DFTYPE = 53,                    /* DFTYPE  */
  YYSYMBOL_FTYPE = 54,                     /* FTYPE  */
  YYSYMBOL_HFTYPE = 55,                    /* HFTYPE  */
  YYSYMBOL_BFTYPE = 56,                    /* BFTYPE  */
  YYSYMBOL_VTYPE = 57,                     /* VTYPE  */
  YYSYMBOL_COND_MOD = 58,                  /* COND_MOD  */
  YYSYMBOL_LANGLE = 59,                    /* LANGLE  */
  YYSYMBOL_RANGLE = 60,                    /* RANGLE  */
  YYSYMBOL_LBRACK = 61,                    /* LBRACK  */
  YYSYMBOL_RBRACK = 62,                    /* RBRACK  */
  YYSYMBOL_IND_LBRACK = 63,                /* IND_LBRACK  */
  YYSYMBOL_LPAREN = 64,                    /* LPAREN  */
  YYSYMBOL_RPAREN = 65,                    /* RPAREN  */
  YYSYMBOL_LBRACE = 66,                    /* LBRACE  */
  YYSYMBOL_RBRACE = 67,                    /* RBRACE  */
  YYSYMBOL_DOT = 68,                       /* DOT  */
  YYSYMBOL_COMMA = 69,                     /* COMMA  */
  YYSYMBOL_SEMI = 70,                      /* SEMI  */
  YYSYMBOL_COLON = 71,                     /* COLON  */
  YYSYMBOL_SLASH = 72,                     /* SLASH  */
  YYSYMBOL_PERCENT = 73,                   /* PERCENT  */
  YYSYMBOL_EQUALS = 74,                    /* EQUALS  */
  YYSYMBOL_PLUS = 75,                      /* PLUS  */
  YYSYMBOL_MINUS = 76,                     /* MINUS  */
  YYSYMBOL_TIMES = 77,                     /* TIMES  */
  YYSYMBOL_AMP = 78,                       /* AMP  */
  YYSYMBOL_CIRC = 79,                      /* CIRC  */
  YYSYMBOL_PIPE = 80,                      /* PIPE  */
  YYSYMBOL_TILDE = 81,                     /* TILDE  */
  YYSYMBOL_BANG = 82,                      /* BANG  */
  YYSYMBOL_QUESTION = 83,                  /* QUESTION  */
  YYSYMBOL_LEQ = 84,                       /* LEQ  */
  YYSYMBOL_GEQ = 85,                       /* GEQ  */
  YYSYMBOL_EQ = 86,                        /* EQ  */
  YYSYMBOL_NEQ = 87,                       /* NEQ  */
  YYSYMBOL_SHL = 88,                       /* SHL  */
  YYSYMBOL_SHRS = 89,                      /* SHRS  */
  YYSYMBOL_SHRZ = 90,                      /* SHRZ  */
  YYSYMBOL_LABEL = 91,                     /* LABEL  */
  YYSYMBOL_IDENT = 92,                     /* IDENT  */
  YYSYMBOL_BUILTIN_NULL = 93,              /* BUILTIN_NULL  */
  YYSYMBOL_BUILTIN = 94,                   /* BUILTIN  */
  YYSYMBOL_STRING_LIT = 95,                /* STRING_LIT  */
  YYSYMBOL_NEWLINE = 96,                   /* NEWLINE  */
  YYSYMBOL_BUILD_OPTION_LINE = 97,         /* BUILD_OPTION_LINE  */
  YYSYMBOL_UNIFORM = 98,                   /* UNIFORM  */
  YYSYMBOL_RTWRITE_OPTION = 99,            /* RTWRITE_OPTION  */
  YYSYMBOL_MEDIA_MODE = 100,               /* MEDIA_MODE  */
  YYSYMBOL_OWORD_MODIFIER = 101,           /* OWORD_MODIFIER  */
  YYSYMBOL_SAMPLER_CHANNEL = 102,          /* SAMPLER_CHANNEL  */
  YYSYMBOL_CHANNEL_OUTPUT = 103,           /* CHANNEL_OUTPUT  */
  YYSYMBOL_EXECMODE = 104,                 /* EXECMODE  */
  YYSYMBOL_CNTRL = 105,                    /* CNTRL  */
  YYSYMBOL_FENCE_OPTIONS = 106,            /* FENCE_OPTIONS  */
  YYSYMBOL_ADDR_ADD_OP = 107,              /* ADDR_ADD_OP  */
  YYSYMBOL_UNARY_LOGIC_OP = 108,           /* UNARY_LOGIC_OP  */
  YYSYMBOL_BINARY_LOGIC_OP = 109,          /* BINARY_LOGIC_OP  */
  YYSYMBOL_TERNARY_LOGIC_OP = 110,         /* TERNARY_LOGIC_OP  */
  YYSYMBOL_QUATERNARY_LOGIC_OP = 111,      /* QUATERNARY_LOGIC_OP  */
  YYSYMBOL_SEL_OP = 112,                   /* SEL_OP  */
  YYSYMBOL_MIN_OP = 113,                   /* MIN_OP  */
  YYSYMBOL_MAX_OP = 114,                   /* MAX_OP  */
  YYSYMBOL_ANTI_TRIG_OP = 115,             /* ANTI_TRIG_OP  */
  YYSYMBOL_MATH2_OP = 116,                 /* MATH2_OP  */
  YYSYMBOL_MATH3_OP = 117,                 /* MATH3_OP  */
  YYSYMBOL_ARITH2_OP = 118,                /* ARITH2_OP  */
  YYSYMBOL_ARITH3_OP = 119,                /* ARITH3_OP  */
  YYSYMBOL_ARITH4_OP = 120,                /* ARITH4_OP  */
  YYSYMBOL_ARITH4_OP2 = 121,               /* ARITH4_OP2  */
  YYSYMBOL_ARITH5_OP2 = 122,               /* ARITH5_OP2  */
  YYSYMBOL_CMP_OP = 123,                   /* CMP_OP  */
  YYSYMBOL_SVM_OP = 124,                   /* SVM_OP  */
  YYSYMBOL_SVM_SCATTER_OP = 125,           /* SVM_SCATTER_OP  */
  YYSYMBOL_SVM_GATHER4SCALED_OP = 126,     /* SVM_GATHER4SCALED_OP  */
  YYSYMBOL_SVM_SCATTER4SCALED_OP = 127,    /* SVM_SCATTER4SCALED_OP  */
  YYSYMBOL_SVM_ATOMIC_OP = 128,            /* SVM_ATOMIC_OP  */
  YYSYMBOL_OWORD_OP = 129,                 /* OWORD_OP  */
  YYSYMBOL_MEDIA_OP = 130,                 /* MEDIA_OP  */
  YYSYMBOL_SCATTER_OP = 131,               /* SCATTER_OP  */
  YYSYMBOL_SCATTER_TYPED_OP = 132,         /* SCATTER_TYPED_OP  */
  YYSYMBOL_SCATTER_SCALED_OP = 133,        /* SCATTER_SCALED_OP  */
  YYSYMBOL_SCATTER4_SCALED_OP = 134,       /* SCATTER4_SCALED_OP  */
  YYSYMBOL_BARRIER_OP = 135,               /* BARRIER_OP  */
  YYSYMBOL_SBARRIER_SIGNAL = 136,          /* SBARRIER_SIGNAL  */
  YYSYMBOL_SBARRIER_WAIT = 137,            /* SBARRIER_WAIT  */
  YYSYMBOL_DWORD_ATOMIC_OP = 138,          /* DWORD_ATOMIC_OP  */
  YYSYMBOL_TYPED_ATOMIC_OP = 139,          /* TYPED_ATOMIC_OP  */
  YYSYMBOL_SAMPLE_OP = 140,                /* SAMPLE_OP  */
  YYSYMBOL_SAMPLE_UNORM_OP = 141,          /* SAMPLE_UNORM_OP  */
  YYSYMBOL_VME_IME_OP = 142,               /* VME_IME_OP  */
  YYSYMBOL_VME_SIC_OP = 143,               /* VME_SIC_OP  */
  YYSYMBOL_VME_FBR_OP = 144,               /* VME_FBR_OP  */
  YYSYMBOL_BRANCH_OP = 145,                /* BRANCH_OP  */
  YYSYMBOL_RET_OP = 146,                   /* RET_OP  */
  YYSYMBOL_IFCALL = 147,                   /* IFCALL  */
  YYSYMBOL_FCALL = 148,                    /* FCALL  */
  YYSYMBOL_FADDR = 149,                    /* FADDR  */
  YYSYMBOL_SWITCHJMP_OP = 150,             /* SWITCHJMP_OP  */
  YYSYMBOL_MOVS_OP = 151,                  /* MOVS_OP  */
  YYSYMBOL_SETP_OP = 152,                  /* SETP_OP  */
  YYSYMBOL_MOV_OP = 153,                   /* MOV_OP  */
  YYSYMBOL_FILE_OP = 154,                  /* FILE_OP  */
  YYSYMBOL_LOC_OP = 155,                   /* LOC_OP  */
  YYSYMBOL_CACHE_FLUSH_OP = 156,           /* CACHE_FLUSH_OP  */
  YYSYMBOL_WAIT_OP = 157,                  /* WAIT_OP  */
  YYSYMBOL_FENCE_GLOBAL_OP = 158,          /* FENCE_GLOBAL_OP  */
  YYSYMBOL_FENCE_LOCAL_OP = 159,           /* FENCE_LOCAL_OP  */
  YYSYMBOL_FENCE_SW_OP = 160,              /* FENCE_SW_OP  */
  YYSYMBOL_YIELD_OP = 161,                 /* YIELD_OP  */
  YYSYMBOL_SAMPLE_3D_OP = 162,             /* SAMPLE_3D_OP  */
  YYSYMBOL_LOAD_3D_OP = 163,               /* LOAD_3D_OP  */
  YYSYMBOL_SAMPLE4_3D_OP = 164,            /* SAMPLE4_3D_OP  */
  YYSYMBOL_RESINFO_OP_3D = 165,            /* RESINFO_OP_3D  */
  YYSYMBOL_SAMPLEINFO_OP_3D = 166,         /* SAMPLEINFO_OP_3D  */
  YYSYMBOL_RTWRITE_OP_3D = 167,            /* RTWRITE_OP_3D  */
  YYSYMBOL_RTWRITE_OP_3D_UNIFIED = 168,    /* RTWRITE_OP_3D_UNIFIED  */
  YYSYMBOL_URBWRITE_OP_3D = 169,           /* URBWRITE_OP_3D  */
  YYSYMBOL_LIFETIME_START_OP = 170,        /* LIFETIME_START_OP  */
  YYSYMBOL_LIFETIME_END_OP = 171,          /* LIFETIME_END_OP  */
  YYSYMBOL_AVS_OP = 172,                   /* AVS_OP  */
  YYSYMBOL_BREAKPOINT_OP = 173,            /* BREAKPOINT_OP  */
  YYSYMBOL_SHFL_IDX4_OP = 174,             /* SHFL_IDX4_OP  */
  YYSYMBOL_LFSR_SUB_OP = 175,              /* LFSR_SUB_OP  */
  YYSYMBOL_DNSCL_OP = 176,                 /* DNSCL_OP  */
  YYSYMBOL_CALL_OP = 177,                  /* CALL_OP  */
  YYSYMBOL_PRED_CNTL = 178,                /* PRED_CNTL  */
  YYSYMBOL_F32_LIT = 179,                  /* F32_LIT  */
  YYSYMBOL_F64_LIT = 180,                  /* F64_LIT  */
  YYSYMBOL_DEC_LIT = 181,                  /* DEC_LIT  */
  YYSYMBOL_HEX_LIT = 182,                  /* HEX_LIT  */
  YYSYMBOL_BUILTIN_SIZEOF = 183,           /* BUILTIN_SIZEOF  */
  YYSYMBOL_BUILTIN_DISPATCH_SIMD_SIZE = 184, /* BUILTIN_DISPATCH_SIMD_SIZE  */
  YYSYMBOL_QW_SCATTER_OP = 185,            /* QW_SCATTER_OP  */
  YYSYMBOL_LSC_CACHING_OPT = 186,          /* LSC_CACHING_OPT  */
  YYSYMBOL_LSC_CACHE_CTRL_SIZE_TYPE = 187, /* LSC_CACHE_CTRL_SIZE_TYPE  */
  YYSYMBOL_LSC_CACHE_CTRL_OPERATION_TYPE = 188, /* LSC_CACHE_CTRL_OPERATION_TYPE  */
  YYSYMBOL_OV = 189,                       /* OV  */
  YYSYMBOL_LSC_ADDR_SIZE_TK = 190,         /* LSC_ADDR_SIZE_TK  */
  YYSYMBOL_LSC_DATA_SHAPE_TK = 191,        /* LSC_DATA_SHAPE_TK  */
  YYSYMBOL_LSC_DATA_SHAPE_TK_CHMASK = 192, /* LSC_DATA_SHAPE_TK_CHMASK  */
  YYSYMBOL_LSC_DATA_SHAPE_TK_BLOCK2D = 193, /* LSC_DATA_SHAPE_TK_BLOCK2D  */
  YYSYMBOL_LSC_AM_FLAT = 194,              /* LSC_AM_FLAT  */
  YYSYMBOL_LSC_AM_BTI = 195,               /* LSC_AM_BTI  */
  YYSYMBOL_LSC_AM_BSS = 196,               /* LSC_AM_BSS  */
  YYSYMBOL_LSC_AM_SS = 197,                /* LSC_AM_SS  */
  YYSYMBOL_LSC_AM_ARG = 198,               /* LSC_AM_ARG  */
  YYSYMBOL_LSC_AM_SURF = 199,              /* LSC_AM_SURF  */
  YYSYMBOL_LSC_FENCE_OP_TYPE = 200,        /* LSC_FENCE_OP_TYPE  */
  YYSYMBOL_LSC_FENCE_SCOPE = 201,          /* LSC_FENCE_SCOPE  */
  YYSYMBOL_LSC_SFID_UNTYPED_TOKEN = 202,   /* LSC_SFID_UNTYPED_TOKEN  */
  YYSYMBOL_LSC_SFID_TYPED_TOKEN = 203,     /* LSC_SFID_TYPED_TOKEN  */
  YYSYMBOL_LSC_LOAD_MNEMONIC = 204,        /* LSC_LOAD_MNEMONIC  */
  YYSYMBOL_LSC_LOAD_STRIDED_MNEMONIC = 205, /* LSC_LOAD_STRIDED_MNEMONIC  */
  YYSYMBOL_LSC_LOAD_BLOCK2D_MNEMONIC = 206, /* LSC_LOAD_BLOCK2D_MNEMONIC  */
  YYSYMBOL_LSC_STORE_MNEMONIC = 207,       /* LSC_STORE_MNEMONIC  */
  YYSYMBOL_LSC_STORE_STRIDED_MNEMONIC = 208, /* LSC_STORE_STRIDED_MNEMONIC  */
  YYSYMBOL_LSC_STORE_BLOCK2D_MNEMONIC = 209, /* LSC_STORE_BLOCK2D_MNEMONIC  */
  YYSYMBOL_LSC_ATOMIC_MNEMONIC = 210,      /* LSC_ATOMIC_MNEMONIC  */
  YYSYMBOL_LSC_READ_STATE_INFO_MNEMONIC = 211, /* LSC_READ_STATE_INFO_MNEMONIC  */
  YYSYMBOL_LSC_LOAD_MSRT_MNEMONIC = 212,   /* LSC_LOAD_MSRT_MNEMONIC  */
  YYSYMBOL_LSC_STORE_MSRT_MNEMONIC = 213,  /* LSC_STORE_MSRT_MNEMONIC  */
  YYSYMBOL_LSC_EXTENDED_CACHE_CTRL_MNEMONIC = 214, /* LSC_EXTENDED_CACHE_CTRL_MNEMONIC  */
  YYSYMBOL_LSC_FENCE_MNEMONIC = 215,       /* LSC_FENCE_MNEMONIC  */
  YYSYMBOL_FCVT_OP = 216,                  /* FCVT_OP  */
  YYSYMBOL_LSC_DATA_SHAPE_TK_TYPED_BLOCK2D = 217, /* LSC_DATA_SHAPE_TK_TYPED_BLOCK2D  */
  YYSYMBOL_YYACCEPT = 218,                 /* $accept  */
  YYSYMBOL_Listing = 219,                  /* Listing  */
  YYSYMBOL_ListingHeader = 220,            /* ListingHeader  */
  YYSYMBOL_Statements = 221,               /* Statements  */
  YYSYMBOL_Newlines = 222,                 /* Newlines  */
  YYSYMBOL_NewlinesOpt = 223,              /* NewlinesOpt  */
  YYSYMBOL_Statement = 224,                /* Statement  */
  YYSYMBOL_Scope = 225,                    /* Scope  */
  YYSYMBOL_ScopeStart = 226,               /* ScopeStart  */
  YYSYMBOL_ScopeEnd = 227,                 /* ScopeEnd  */
  YYSYMBOL_IdentOrStringLit = 228,         /* IdentOrStringLit  */
  YYSYMBOL_DirectiveKernel = 229,          /* DirectiveKernel  */
  YYSYMBOL_DirectiveGlobalFunction = 230,  /* DirectiveGlobalFunction  */
  YYSYMBOL_DirectiveVersion = 231,         /* DirectiveVersion  */
  YYSYMBOL_DirectiveDecl = 232,            /* DirectiveDecl  */
  YYSYMBOL_DeclFunction = 233,             /* DeclFunction  */
  YYSYMBOL_DeclVariable = 234,             /* DeclVariable  */
  YYSYMBOL_DeclAddress = 235,              /* DeclAddress  */
  YYSYMBOL_DeclPredicate = 236,            /* DeclPredicate  */
  YYSYMBOL_DeclSampler = 237,              /* DeclSampler  */
  YYSYMBOL_VNameEqOpt = 238,               /* VNameEqOpt  */
  YYSYMBOL_DeclSurface = 239,              /* DeclSurface  */
  YYSYMBOL_DirectiveInput = 240,           /* DirectiveInput  */
  YYSYMBOL_DirectiveImplicitInput = 241,   /* DirectiveImplicitInput  */
  YYSYMBOL_InputOffset = 242,              /* InputOffset  */
  YYSYMBOL_InputSize = 243,                /* InputSize  */
  YYSYMBOL_DirectiveAttr = 244,            /* DirectiveAttr  */
  YYSYMBOL_DirectiveFunc = 245,            /* DirectiveFunc  */
  YYSYMBOL_AlignAttrOpt = 246,             /* AlignAttrOpt  */
  YYSYMBOL_Align = 247,                    /* Align  */
  YYSYMBOL_AliasAttrOpt = 248,             /* AliasAttrOpt  */
  YYSYMBOL_OneAttr = 249,                  /* OneAttr  */
  YYSYMBOL_AttrOpt = 250,                  /* AttrOpt  */
  YYSYMBOL_GenAttrOpt = 251,               /* GenAttrOpt  */
  YYSYMBOL_Instruction = 252,              /* Instruction  */
  YYSYMBOL_Label = 253,                    /* Label  */
  YYSYMBOL_LogicInstruction = 254,         /* LogicInstruction  */
  YYSYMBOL_UnaryLogicInstruction = 255,    /* UnaryLogicInstruction  */
  YYSYMBOL_MathInstruction_2OPND = 256,    /* MathInstruction_2OPND  */
  YYSYMBOL_MathInstruction_3OPND = 257,    /* MathInstruction_3OPND  */
  YYSYMBOL_ArithInstruction_2OPND = 258,   /* ArithInstruction_2OPND  */
  YYSYMBOL_ArithInstruction_3OPND = 259,   /* ArithInstruction_3OPND  */
  YYSYMBOL_ArithInstruction_4OPND = 260,   /* ArithInstruction_4OPND  */
  YYSYMBOL_BdpasInstruction = 261,         /* BdpasInstruction  */
  YYSYMBOL_DpasInstruction = 262,          /* DpasInstruction  */
  YYSYMBOL_BfnInstruction = 263,           /* BfnInstruction  */
  YYSYMBOL_QwScatterInstruction = 264,     /* QwScatterInstruction  */
  YYSYMBOL_FCvtInstruction = 265,          /* FCvtInstruction  */
  YYSYMBOL_AntiTrigInstruction = 266,      /* AntiTrigInstruction  */
  YYSYMBOL_AddrAddInstruction = 267,       /* AddrAddInstruction  */
  YYSYMBOL_SetpInstruction = 268,          /* SetpInstruction  */
  YYSYMBOL_SelInstruction = 269,           /* SelInstruction  */
  YYSYMBOL_MinInstruction = 270,           /* MinInstruction  */
  YYSYMBOL_MaxInstruction = 271,           /* MaxInstruction  */
  YYSYMBOL_MovInstruction = 272,           /* MovInstruction  */
  YYSYMBOL_BreakpointInstruction = 273,    /* BreakpointInstruction  */
  YYSYMBOL_MovsInstruction = 274,          /* MovsInstruction  */
  YYSYMBOL_CmpInstruction = 275,           /* CmpInstruction  */
  YYSYMBOL_MediaInstruction = 276,         /* MediaInstruction  */
  YYSYMBOL_MediaInstructionPlaneID = 277,  /* MediaInstructionPlaneID  */
  YYSYMBOL_ScatterInstruction = 278,       /* ScatterInstruction  */
  YYSYMBOL_ScatterTypedInstruction = 279,  /* ScatterTypedInstruction  */
  YYSYMBOL_Scatter4ScaledInstruction = 280, /* Scatter4ScaledInstruction  */
  YYSYMBOL_ScatterScaledInstruction = 281, /* ScatterScaledInstruction  */
  YYSYMBOL_SynchronizationInstruction = 282, /* SynchronizationInstruction  */
  YYSYMBOL_DwordAtomicInstruction = 283,   /* DwordAtomicInstruction  */
  YYSYMBOL_TypedAtomicInstruction = 284,   /* TypedAtomicInstruction  */
  YYSYMBOL_Atomic16Opt = 285,              /* Atomic16Opt  */
  YYSYMBOL_SampleUnormInstruction = 286,   /* SampleUnormInstruction  */
  YYSYMBOL_SampleInstruction = 287,        /* SampleInstruction  */
  YYSYMBOL_SamplerAddrOperand = 288,       /* SamplerAddrOperand  */
  YYSYMBOL_Sample3dInstruction = 289,      /* Sample3dInstruction  */
  YYSYMBOL_CPSEnableOpt = 290,             /* CPSEnableOpt  */
  YYSYMBOL_NonUniformSamplerEnableOpt = 291, /* NonUniformSamplerEnableOpt  */
  YYSYMBOL_Load3dInstruction = 292,        /* Load3dInstruction  */
  YYSYMBOL_Gather43dInstruction = 293,     /* Gather43dInstruction  */
  YYSYMBOL_PixelNullMaskEnableOpt = 294,   /* PixelNullMaskEnableOpt  */
  YYSYMBOL_ResInfo3dInstruction = 295,     /* ResInfo3dInstruction  */
  YYSYMBOL_SampleInfo3dInstruction = 296,  /* SampleInfo3dInstruction  */
  YYSYMBOL_RTWriteOperands = 297,          /* RTWriteOperands  */
  YYSYMBOL_RTWriteInstruction = 298,       /* RTWriteInstruction  */
  YYSYMBOL_RTWriteModeOpt = 299,           /* RTWriteModeOpt  */
  YYSYMBOL_URBWriteInstruction = 300,      /* URBWriteInstruction  */
  YYSYMBOL_AVSInstruction = 301,           /* AVSInstruction  */
  YYSYMBOL_VMEInstruction = 302,           /* VMEInstruction  */
  YYSYMBOL_OwordInstruction = 303,         /* OwordInstruction  */
  YYSYMBOL_SvmInstruction = 304,           /* SvmInstruction  */
  YYSYMBOL_AtomicBitwidthOpt = 305,        /* AtomicBitwidthOpt  */
  YYSYMBOL_LscInstruction = 306,           /* LscInstruction  */
  YYSYMBOL_LscUntypedLoad = 307,           /* LscUntypedLoad  */
  YYSYMBOL_LscUntypedStridedLoad = 308,    /* LscUntypedStridedLoad  */
  YYSYMBOL_LscUntypedBlock2dLoad = 309,    /* LscUntypedBlock2dLoad  */
  YYSYMBOL_LscExtendedCacheCtrl = 310,     /* LscExtendedCacheCtrl  */
  YYSYMBOL_LscUntypedStore = 311,          /* LscUntypedStore  */
  YYSYMBOL_LscUntypedStridedStore = 312,   /* LscUntypedStridedStore  */
  YYSYMBOL_LscUntypedBlock2dStore = 313,   /* LscUntypedBlock2dStore  */
  YYSYMBOL_LscUntypedAtomic = 314,         /* LscUntypedAtomic  */
  YYSYMBOL_LscTypedMSRTLoad = 315,         /* LscTypedMSRTLoad  */
  YYSYMBOL_LscTypedMSRTStore = 316,        /* LscTypedMSRTStore  */
  YYSYMBOL_LscTypedLoad = 317,             /* LscTypedLoad  */
  YYSYMBOL_LscTypedStore = 318,            /* LscTypedStore  */
  YYSYMBOL_LscTypedAtomic = 319,           /* LscTypedAtomic  */
  YYSYMBOL_LscTypedReadStateInfo = 320,    /* LscTypedReadStateInfo  */
  YYSYMBOL_LscFence = 321,                 /* LscFence  */
  YYSYMBOL_LscSfid = 322,                  /* LscSfid  */
  YYSYMBOL_LscCacheOpts = 323,             /* LscCacheOpts  */
  YYSYMBOL_OVOpt = 324,                    /* OVOpt  */
  YYSYMBOL_LscUntypedAddrOperand = 325,    /* LscUntypedAddrOperand  */
  YYSYMBOL_LscUntypedStridedAddrOperand = 326, /* LscUntypedStridedAddrOperand  */
  YYSYMBOL_LscUntypedBlock2dAddrOperand = 327, /* LscUntypedBlock2dAddrOperand  */
  YYSYMBOL_LscTypedAddrWithOffsetOperand = 328, /* LscTypedAddrWithOffsetOperand  */
  YYSYMBOL_LscTypedAddrWithOffsetOperandList = 329, /* LscTypedAddrWithOffsetOperandList  */
  YYSYMBOL_LscTypedAddrOperandWithOffsets = 330, /* LscTypedAddrOperandWithOffsets  */
  YYSYMBOL_LscAddrImmOffsetOpt = 331,      /* LscAddrImmOffsetOpt  */
  YYSYMBOL_LscAddrImmScaleOpt = 332,       /* LscAddrImmScaleOpt  */
  YYSYMBOL_LscAddrModelOpt = 333,          /* LscAddrModelOpt  */
  YYSYMBOL_LscAddrModelStateful = 334,     /* LscAddrModelStateful  */
  YYSYMBOL_LscVectorOpRegOrImm32 = 335,    /* LscVectorOpRegOrImm32  */
  YYSYMBOL_LscVectorOpRegOrImm64 = 336,    /* LscVectorOpRegOrImm64  */
  YYSYMBOL_LscVectorOpImm32 = 337,         /* LscVectorOpImm32  */
  YYSYMBOL_LscVectorOpImm64 = 338,         /* LscVectorOpImm64  */
  YYSYMBOL_LscVectorOpReg = 339,           /* LscVectorOpReg  */
  YYSYMBOL_LscDataOperand = 340,           /* LscDataOperand  */
  YYSYMBOL_LscDataOperand2D = 341,         /* LscDataOperand2D  */
  YYSYMBOL_LscPayloadReg = 342,            /* LscPayloadReg  */
  YYSYMBOL_LscPayloadNonNullReg = 343,     /* LscPayloadNonNullReg  */
  YYSYMBOL_LscInstructionXe2 = 344,        /* LscInstructionXe2  */
  YYSYMBOL_LscTypedBlock2dLoad = 345,      /* LscTypedBlock2dLoad  */
  YYSYMBOL_LscTypedBlock2dStore = 346,     /* LscTypedBlock2dStore  */
  YYSYMBOL_LscTypedBlock2dAddrOperand = 347, /* LscTypedBlock2dAddrOperand  */
  YYSYMBOL_LscDataOperandTyped2D = 348,    /* LscDataOperandTyped2D  */
  YYSYMBOL_LscUntypedApndCtrAtomic = 349,  /* LscUntypedApndCtrAtomic  */
  YYSYMBOL_SwitchLabels = 350,             /* SwitchLabels  */
  YYSYMBOL_BranchInstruction = 351,        /* BranchInstruction  */
  YYSYMBOL_FILE = 352,                     /* FILE  */
  YYSYMBOL_LOC = 353,                      /* LOC  */
  YYSYMBOL_RawSendInstruction = 354,       /* RawSendInstruction  */
  YYSYMBOL_LifetimeStartInst = 355,        /* LifetimeStartInst  */
  YYSYMBOL_LifetimeEndInst = 356,          /* LifetimeEndInst  */
  YYSYMBOL_RawSendsInstruction = 357,      /* RawSendsInstruction  */
  YYSYMBOL_RawSendgInstruction = 358,      /* RawSendgInstruction  */
  YYSYMBOL_RawSendgMnemonic = 359,         /* RawSendgMnemonic  */
  YYSYMBOL_RawSendgSfid = 360,             /* RawSendgSfid  */
  YYSYMBOL_RawSendgPayloadSize = 361,      /* RawSendgPayloadSize  */
  YYSYMBOL_NullaryInstruction = 362,       /* NullaryInstruction  */
  YYSYMBOL_OwordModifier = 363,            /* OwordModifier  */
  YYSYMBOL_ShflIdx4Instruction = 364,      /* ShflIdx4Instruction  */
  YYSYMBOL_LfsrInstruction = 365,          /* LfsrInstruction  */
  YYSYMBOL_DnsclInstruction = 366,         /* DnsclInstruction  */
  YYSYMBOL_Predicate = 367,                /* Predicate  */
  YYSYMBOL_PredSign = 368,                 /* PredSign  */
  YYSYMBOL_PredCtrlOpt = 369,              /* PredCtrlOpt  */
  YYSYMBOL_SatModOpt = 370,                /* SatModOpt  */
  YYSYMBOL_SrcModifier = 371,              /* SrcModifier  */
  YYSYMBOL_ConditionalModifier = 372,      /* ConditionalModifier  */
  YYSYMBOL_VecDstOperand_A = 373,          /* VecDstOperand_A  */
  YYSYMBOL_VecDstOperand_G = 374,          /* VecDstOperand_G  */
  YYSYMBOL_VecDstOperand_G_I = 375,        /* VecDstOperand_G_I  */
  YYSYMBOL_VecSrcOperand_G_I_IMM_A_AO = 376, /* VecSrcOperand_G_I_IMM_A_AO  */
  YYSYMBOL_VecSrcOperand_G_I_IMM_A = 377,  /* VecSrcOperand_G_I_IMM_A  */
  YYSYMBOL_VecSrcOperand_G_I_IMM = 378,    /* VecSrcOperand_G_I_IMM  */
  YYSYMBOL_VecSrcOperand_G_IMM = 379,      /* VecSrcOperand_G_IMM  */
  YYSYMBOL_VecSrcOperand_G_IMM_AO = 380,   /* VecSrcOperand_G_IMM_AO  */
  YYSYMBOL_VecSrcOperand_G_A = 381,        /* VecSrcOperand_G_A  */
  YYSYMBOL_VecSrcOperand_G_A_AO = 382,     /* VecSrcOperand_G_A_AO  */
  YYSYMBOL_VecSrcOperand_G = 383,          /* VecSrcOperand_G  */
  YYSYMBOL_VecSrcOpndSimple = 384,         /* VecSrcOpndSimple  */
  YYSYMBOL_VMEOpndIME = 385,               /* VMEOpndIME  */
  YYSYMBOL_VMEOpndFBR = 386,               /* VMEOpndFBR  */
  YYSYMBOL_SrcStateOperand = 387,          /* SrcStateOperand  */
  YYSYMBOL_DstStateOperand = 388,          /* DstStateOperand  */
  YYSYMBOL_RawOperand = 389,               /* RawOperand  */
  YYSYMBOL_RawOperandNonNull = 390,        /* RawOperandNonNull  */
  YYSYMBOL_RawOperandOffsetSuffix = 391,   /* RawOperandOffsetSuffix  */
  YYSYMBOL_RawOperandArray = 392,          /* RawOperandArray  */
  YYSYMBOL_DstAddrOperand = 393,           /* DstAddrOperand  */
  YYSYMBOL_DstGeneralOperand = 394,        /* DstGeneralOperand  */
  YYSYMBOL_DstIndirectOperand = 395,       /* DstIndirectOperand  */
  YYSYMBOL_SrcAddrOfOperand = 396,         /* SrcAddrOfOperand  */
  YYSYMBOL_AddrOfVar = 397,                /* AddrOfVar  */
  YYSYMBOL_SrcAddrOperand = 398,           /* SrcAddrOperand  */
  YYSYMBOL_SrcGeneralOperand = 399,        /* SrcGeneralOperand  */
  YYSYMBOL_SrcImmOperand = 400,            /* SrcImmOperand  */
  YYSYMBOL_FloatLit = 401,                 /* FloatLit  */
  YYSYMBOL_DoubleFloatLit = 402,           /* DoubleFloatLit  */
  YYSYMBOL_SrcIndirectOperand = 403,       /* SrcIndirectOperand  */
  YYSYMBOL_DstRegion = 404,                /* DstRegion  */
  YYSYMBOL_SrcRegionDirect = 405,          /* SrcRegionDirect  */
  YYSYMBOL_SrcRegionIndirect = 406,        /* SrcRegionIndirect  */
  YYSYMBOL_IndirectVarAccess = 407,        /* IndirectVarAccess  */
  YYSYMBOL_TwoDimOffset = 408,             /* TwoDimOffset  */
  YYSYMBOL_PredVar = 409,                  /* PredVar  */
  YYSYMBOL_AddrVarAccess = 410,            /* AddrVarAccess  */
  YYSYMBOL_AddrVarAccessWithWidth = 411,   /* AddrVarAccessWithWidth  */
  YYSYMBOL_SIMDMode = 412,                 /* SIMDMode  */
  YYSYMBOL_ElemNum = 413,                  /* ElemNum  */
  YYSYMBOL_ExecSize = 414,                 /* ExecSize  */
  YYSYMBOL_ExecSizeInt = 415,              /* ExecSizeInt  */
  YYSYMBOL_Var = 416,                      /* Var  */
  YYSYMBOL_VarNonNull = 417,               /* VarNonNull  */
  YYSYMBOL_IntExp = 418,                   /* IntExp  */
  YYSYMBOL_IntExpCond = 419,               /* IntExpCond  */
  YYSYMBOL_IntExpAND = 420,                /* IntExpAND  */
  YYSYMBOL_IntExpXOR = 421,                /* IntExpXOR  */
  YYSYMBOL_IntExpOR = 422,                 /* IntExpOR  */
  YYSYMBOL_IntExpCmp = 423,                /* IntExpCmp  */
  YYSYMBOL_IntExpRel = 424,                /* IntExpRel  */
  YYSYMBOL_IntExpNRA = 425,                /* IntExpNRA  */
  YYSYMBOL_IntExpShift = 426,              /* IntExpShift  */
  YYSYMBOL_IntExpAdd = 427,                /* IntExpAdd  */
  YYSYMBOL_IntExpMul = 428,                /* IntExpMul  */
  YYSYMBOL_IntExpUnr = 429,                /* IntExpUnr  */
  YYSYMBOL_IntExpPrim = 430,               /* IntExpPrim  */
  YYSYMBOL_DataType = 431,                 /* DataType  */
  YYSYMBOL_DataTypeIntOrVector = 432,      /* DataTypeIntOrVector  */
  YYSYMBOL_BuildOptions = 433              /* BuildOptions  */
};
typedef enum yysymbol_kind_t yysymbol_kind_t;




#ifdef short
# undef short
#endif

/* On compilers that do not define __PTRDIFF_MAX__ etc., make sure
   <limits.h> and (if available) <stdint.h> are included
   so that the code can choose integer types of a good width.  */

#ifndef __PTRDIFF_MAX__
# include <limits.h> /* INFRINGES ON USER NAME SPACE */
# if defined __STDC_VERSION__ && 199901 <= __STDC_VERSION__
#  include <stdint.h> /* INFRINGES ON USER NAME SPACE */
#  define YY_STDINT_H
# endif
#endif

/* Narrow types that promote to a signed type and that can represent a
   signed or unsigned integer of at least N bits.  In tables they can
   save space and decrease cache pressure.  Promoting to a signed type
   helps avoid bugs in integer arithmetic.  */

#ifdef __INT_LEAST8_MAX__
typedef __INT_LEAST8_TYPE__ yytype_int8;
#elif defined YY_STDINT_H
typedef int_least8_t yytype_int8;
#else
typedef signed char yytype_int8;
#endif

#ifdef __INT_LEAST16_MAX__
typedef __INT_LEAST16_TYPE__ yytype_int16;
#elif defined YY_STDINT_H
typedef int_least16_t yytype_int16;
#else
typedef short yytype_int16;
#endif

/* Work around bug in HP-UX 11.23, which defines these macros
   incorrectly for preprocessor constants.  This workaround can likely
   be removed in 2023, as HPE has promised support for HP-UX 11.23
   (aka HP-UX 11i v2) only through the end of 2022; see Table 2 of
   <https://h20195.www2.hpe.com/V2/getpdf.aspx/4AA4-7673ENW.pdf>.  */
#ifdef __hpux
# undef UINT_LEAST8_MAX
# undef UINT_LEAST16_MAX
# define UINT_LEAST8_MAX 255
# define UINT_LEAST16_MAX 65535
#endif

#if defined __UINT_LEAST8_MAX__ && __UINT_LEAST8_MAX__ <= __INT_MAX__
typedef __UINT_LEAST8_TYPE__ yytype_uint8;
#elif (!defined __UINT_LEAST8_MAX__ && defined YY_STDINT_H \
       && UINT_LEAST8_MAX <= INT_MAX)
typedef uint_least8_t yytype_uint8;
#elif !defined __UINT_LEAST8_MAX__ && UCHAR_MAX <= INT_MAX
typedef unsigned char yytype_uint8;
#else
typedef short yytype_uint8;
#endif

#if defined __UINT_LEAST16_MAX__ && __UINT_LEAST16_MAX__ <= __INT_MAX__
typedef __UINT_LEAST16_TYPE__ yytype_uint16;
#elif (!defined __UINT_LEAST16_MAX__ && defined YY_STDINT_H \
       && UINT_LEAST16_MAX <= INT_MAX)
typedef uint_least16_t yytype_uint16;
#elif !defined __UINT_LEAST16_MAX__ && USHRT_MAX <= INT_MAX
typedef unsigned short yytype_uint16;
#else
typedef int yytype_uint16;
#endif

#ifndef YYPTRDIFF_T
# if defined __PTRDIFF_TYPE__ && defined __PTRDIFF_MAX__
#  define YYPTRDIFF_T __PTRDIFF_TYPE__
#  define YYPTRDIFF_MAXIMUM __PTRDIFF_MAX__
# elif defined PTRDIFF_MAX
#  ifndef ptrdiff_t
#   include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  endif
#  define YYPTRDIFF_T ptrdiff_t
#  define YYPTRDIFF_MAXIMUM PTRDIFF_MAX
# else
#  define YYPTRDIFF_T long
#  define YYPTRDIFF_MAXIMUM LONG_MAX
# endif
#endif

#ifndef YYSIZE_T
# ifdef __SIZE_TYPE__
#  define YYSIZE_T __SIZE_TYPE__
# elif defined size_t
#  define YYSIZE_T size_t
# elif defined __STDC_VERSION__ && 199901 <= __STDC_VERSION__
#  include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  define YYSIZE_T size_t
# else
#  define YYSIZE_T unsigned
# endif
#endif

#define YYSIZE_MAXIMUM                                  \
  YY_CAST (YYPTRDIFF_T,                                 \
           (YYPTRDIFF_MAXIMUM < YY_CAST (YYSIZE_T, -1)  \
            ? YYPTRDIFF_MAXIMUM                         \
            : YY_CAST (YYSIZE_T, -1)))

#define YYSIZEOF(X) YY_CAST (YYPTRDIFF_T, sizeof (X))


/* Stored state numbers (used for stacks). */
typedef yytype_int16 yy_state_t;

/* State numbers in computations.  */
typedef int yy_state_fast_t;

#ifndef YY_
# if defined YYENABLE_NLS && YYENABLE_NLS
#  if ENABLE_NLS
#   include <libintl.h> /* INFRINGES ON USER NAME SPACE */
#   define YY_(Msgid) dgettext ("bison-runtime", Msgid)
#  endif
# endif
# ifndef YY_
#  define YY_(Msgid) Msgid
# endif
#endif


#ifndef YY_ATTRIBUTE_PURE
# if defined __GNUC__ && 2 < __GNUC__ + (96 <= __GNUC_MINOR__)
#  define YY_ATTRIBUTE_PURE __attribute__ ((__pure__))
# else
#  define YY_ATTRIBUTE_PURE
# endif
#endif

#ifndef YY_ATTRIBUTE_UNUSED
# if defined __GNUC__ && 2 < __GNUC__ + (7 <= __GNUC_MINOR__)
#  define YY_ATTRIBUTE_UNUSED __attribute__ ((__unused__))
# else
#  define YY_ATTRIBUTE_UNUSED
# endif
#endif

/* Suppress unused-variable warnings by "using" E.  */
#if ! defined lint || defined __GNUC__
# define YY_USE(E) ((void) (E))
#else
# define YY_USE(E) /* empty */
#endif

/* Suppress an incorrect diagnostic about yylval being uninitialized.  */
#if defined __GNUC__ && ! defined __ICC && 406 <= __GNUC__ * 100 + __GNUC_MINOR__
# if __GNUC__ * 100 + __GNUC_MINOR__ < 407
#  define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN                           \
    _Pragma ("GCC diagnostic push")                                     \
    _Pragma ("GCC diagnostic ignored \"-Wuninitialized\"")
# else
#  define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN                           \
    _Pragma ("GCC diagnostic push")                                     \
    _Pragma ("GCC diagnostic ignored \"-Wuninitialized\"")              \
    _Pragma ("GCC diagnostic ignored \"-Wmaybe-uninitialized\"")
# endif
# define YY_IGNORE_MAYBE_UNINITIALIZED_END      \
    _Pragma ("GCC diagnostic pop")
#else
# define YY_INITIAL_VALUE(Value) Value
#endif
#ifndef YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
# define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
# define YY_IGNORE_MAYBE_UNINITIALIZED_END
#endif
#ifndef YY_INITIAL_VALUE
# define YY_INITIAL_VALUE(Value) /* Nothing. */
#endif

#if defined __cplusplus && defined __GNUC__ && ! defined __ICC && 6 <= __GNUC__
# define YY_IGNORE_USELESS_CAST_BEGIN                          \
    _Pragma ("GCC diagnostic push")                            \
    _Pragma ("GCC diagnostic ignored \"-Wuseless-cast\"")
# define YY_IGNORE_USELESS_CAST_END            \
    _Pragma ("GCC diagnostic pop")
#endif
#ifndef YY_IGNORE_USELESS_CAST_BEGIN
# define YY_IGNORE_USELESS_CAST_BEGIN
# define YY_IGNORE_USELESS_CAST_END
#endif


#define YY_ASSERT(E) ((void) (0 && (E)))

#if 1

/* The parser invokes alloca or malloc; define the necessary symbols.  */

# ifdef YYSTACK_USE_ALLOCA
#  if YYSTACK_USE_ALLOCA
#   ifdef __GNUC__
#    define YYSTACK_ALLOC __builtin_alloca
#   elif defined __BUILTIN_VA_ARG_INCR
#    include <alloca.h> /* INFRINGES ON USER NAME SPACE */
#   elif defined _AIX
#    define YYSTACK_ALLOC __alloca
#   elif defined _MSC_VER
#    include <malloc.h> /* INFRINGES ON USER NAME SPACE */
#    define alloca _alloca
#   else
#    define YYSTACK_ALLOC alloca
#    if ! defined _ALLOCA_H && ! defined EXIT_SUCCESS
#     include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
      /* Use EXIT_SUCCESS as a witness for stdlib.h.  */
#     ifndef EXIT_SUCCESS
#      define EXIT_SUCCESS 0
#     endif
#    endif
#   endif
#  endif
# endif

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's 'empty if-body' warning.  */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (0)
#  ifndef YYSTACK_ALLOC_MAXIMUM
    /* The OS might guarantee only one guard page at the bottom of the stack,
       and a page size can be as small as 4096 bytes.  So we cannot safely
       invoke alloca (N) if N exceeds 4096.  Use a slightly smaller number
       to allow for a few compiler-allocated temporary stack slots.  */
#   define YYSTACK_ALLOC_MAXIMUM 4032 /* reasonable circa 2006 */
#  endif
# else
#  define YYSTACK_ALLOC YYMALLOC
#  define YYSTACK_FREE YYFREE
#  ifndef YYSTACK_ALLOC_MAXIMUM
#   define YYSTACK_ALLOC_MAXIMUM YYSIZE_MAXIMUM
#  endif
#  if (defined __cplusplus && ! defined EXIT_SUCCESS \
       && ! ((defined YYMALLOC || defined malloc) \
             && (defined YYFREE || defined free)))
#   include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#   ifndef EXIT_SUCCESS
#    define EXIT_SUCCESS 0
#   endif
#  endif
#  ifndef YYMALLOC
#   define YYMALLOC malloc
#   if ! defined malloc && ! defined EXIT_SUCCESS
void *malloc (YYSIZE_T); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
#  ifndef YYFREE
#   define YYFREE free
#   if ! defined free && ! defined EXIT_SUCCESS
void free (void *); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
# endif
#endif /* 1 */

#if (! defined yyoverflow \
     && (! defined __cplusplus \
         || (defined YYSTYPE_IS_TRIVIAL && YYSTYPE_IS_TRIVIAL)))

/* A type that is properly aligned for any stack member.  */
union yyalloc
{
  yy_state_t yyss_alloc;
  YYSTYPE yyvs_alloc;
};

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAXIMUM (YYSIZEOF (union yyalloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# define YYSTACK_BYTES(N) \
     ((N) * (YYSIZEOF (yy_state_t) + YYSIZEOF (YYSTYPE)) \
      + YYSTACK_GAP_MAXIMUM)

# define YYCOPY_NEEDED 1

/* Relocate STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Stack_alloc, Stack)                           \
    do                                                                  \
      {                                                                 \
        YYPTRDIFF_T yynewbytes;                                         \
        YYCOPY (&yyptr->Stack_alloc, Stack, yysize);                    \
        Stack = &yyptr->Stack_alloc;                                    \
        yynewbytes = yystacksize * YYSIZEOF (*Stack) + YYSTACK_GAP_MAXIMUM; \
        yyptr += yynewbytes / YYSIZEOF (*yyptr);                        \
      }                                                                 \
    while (0)

#endif

#if defined YYCOPY_NEEDED && YYCOPY_NEEDED
/* Copy COUNT objects from SRC to DST.  The source and destination do
   not overlap.  */
# ifndef YYCOPY
#  if defined __GNUC__ && 1 < __GNUC__
#   define YYCOPY(Dst, Src, Count) \
      __builtin_memcpy (Dst, Src, YY_CAST (YYSIZE_T, (Count)) * sizeof (*(Src)))
#  else
#   define YYCOPY(Dst, Src, Count)              \
      do                                        \
        {                                       \
          YYPTRDIFF_T yyi;                      \
          for (yyi = 0; yyi < (Count); yyi++)   \
            (Dst)[yyi] = (Src)[yyi];            \
        }                                       \
      while (0)
#  endif
# endif
#endif /* !YYCOPY_NEEDED */

/* YYFINAL -- State number of the termination state.  */
#define YYFINAL  5
/* YYLAST -- Last index in YYTABLE.  */
#define YYLAST   3985

/* YYNTOKENS -- Number of terminals.  */
#define YYNTOKENS  218
/* YYNNTS -- Number of nonterminals.  */
#define YYNNTS  216
/* YYNRULES -- Number of rules.  */
#define YYNRULES  498
/* YYNSTATES -- Number of states.  */
#define YYNSTATES  1279

/* YYMAXUTOK -- Last valid token kind.  */
#define YYMAXUTOK   472


/* YYTRANSLATE(TOKEN-NUM) -- Symbol number corresponding to TOKEN-NUM
   as returned by yylex, with out-of-bounds checking.  */
#define YYTRANSLATE(YYX)                                \
  (0 <= (YYX) && (YYX) <= YYMAXUTOK                     \
   ? YY_CAST (yysymbol_kind_t, yytranslate[YYX])        \
   : YYSYMBOL_YYUNDEF)

/* YYTRANSLATE[TOKEN-NUM] -- Symbol number corresponding to TOKEN-NUM
   as returned by yylex.  */
static const yytype_uint8 yytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35,    36,    37,    38,    39,    40,    41,    42,    43,    44,
      45,    46,    47,    48,    49,    50,    51,    52,    53,    54,
      55,    56,    57,    58,    59,    60,    61,    62,    63,    64,
      65,    66,    67,    68,    69,    70,    71,    72,    73,    74,
      75,    76,    77,    78,    79,    80,    81,    82,    83,    84,
      85,    86,    87,    88,    89,    90,    91,    92,    93,    94,
      95,    96,    97,    98,    99,   100,   101,   102,   103,   104,
     105,   106,   107,   108,   109,   110,   111,   112,   113,   114,
     115,   116,   117,   118,   119,   120,   121,   122,   123,   124,
     125,   126,   127,   128,   129,   130,   131,   132,   133,   134,
     135,   136,   137,   138,   139,   140,   141,   142,   143,   144,
     145,   146,   147,   148,   149,   150,   151,   152,   153,   154,
     155,   156,   157,   158,   159,   160,   161,   162,   163,   164,
     165,   166,   167,   168,   169,   170,   171,   172,   173,   174,
     175,   176,   177,   178,   179,   180,   181,   182,   183,   184,
     185,   186,   187,   188,   189,   190,   191,   192,   193,   194,
     195,   196,   197,   198,   199,   200,   201,   202,   203,   204,
     205,   206,   207,   208,   209,   210,   211,   212,   213,   214,
     215,   216,   217
};

#if YYDEBUG
/* YYRLINE[YYN] -- Source line where rule number YYN was defined.  */
static const yytype_int16 yyrline[] =
{
       0,   709,   709,   714,   716,   716,   718,   718,   719,   719,
     722,   723,   724,   725,   726,   727,   728,   729,   730,   731,
     732,   737,   738,   739,   743,   747,   750,   750,   757,   765,
     773,   780,   781,   782,   783,   784,   785,   787,   794,   802,
     810,   817,   821,   821,   824,   832,   837,   849,   856,   864,
     864,   865,   871,   875,   879,   883,   888,   894,   894,   896,
     900,   906,   913,   919,   924,   929,   935,   939,   943,   949,
     954,   960,   964,   974,   975,   976,   977,   978,   979,   980,
     981,   982,   983,   984,   985,   986,   987,   988,   989,   990,
     991,   992,   993,   994,   995,   996,   997,   998,   999,  1000,
    1001,  1002,  1003,  1004,  1005,  1006,  1007,  1008,  1009,  1010,
    1011,  1012,  1013,  1014,  1015,  1016,  1017,  1018,  1019,  1020,
    1021,  1022,  1023,  1024,  1025,  1026,  1027,  1028,  1029,  1030,
    1032,  1036,  1042,  1047,  1053,  1060,  1066,  1073,  1080,  1087,
    1094,  1104,  1113,  1120,  1127,  1135,  1147,  1157,  1163,  1170,
    1176,  1185,  1195,  1202,  1209,  1217,  1226,  1233,  1240,  1246,
    1252,  1258,  1264,  1282,  1289,  1299,  1307,  1314,  1321,  1330,
    1339,  1348,  1356,  1359,  1362,  1365,  1368,  1371,  1376,  1383,
    1391,  1392,  1398,  1411,  1419,  1426,  1431,  1436,  1453,  1453,
    1455,  1455,  1458,  1475,  1493,  1493,  1496,  1504,  1512,  1515,
    1519,  1525,  1538,  1538,  1542,  1550,  1562,  1578,  1584,  1597,
    1605,  1612,  1620,  1626,  1632,  1638,  1644,  1651,  1652,  1661,
    1662,  1663,  1665,  1666,  1667,  1669,  1672,  1673,  1674,  1675,
    1676,  1677,  1678,  1680,  1715,  1748,  1778,  1803,  1830,  1857,
    1885,  1918,  1945,  1978,  2021,  2067,  2114,  2154,  2193,  2198,
    2198,  2201,  2202,  2203,  2205,  2205,  2209,  2219,  2226,  2232,
    2241,  2261,  2281,  2301,  2321,  2328,  2332,  2335,  2340,  2343,
    2348,  2354,  2362,  2375,  2376,  2377,  2382,  2383,  2386,  2387,
    2388,  2389,  2390,  2394,  2397,  2400,  2403,  2406,  2409,  2412,
    2415,  2420,  2420,  2421,  2421,  2424,  2428,  2434,  2442,  2450,
    2464,  2468,  2474,  2479,  2482,  2486,  2489,  2495,  2497,  2498,
    2510,  2539,  2561,  2573,  2584,  2593,  2615,  2618,  2621,  2628,
    2632,  2636,  2640,  2646,  2651,  2658,  2665,  2670,  2675,  2681,
    2688,  2695,  2701,  2707,  2715,  2723,  2731,  2744,  2767,  2768,
    2769,  2770,  2779,  2783,  2789,  2793,  2811,  2814,  2819,  2824,
    2829,  2834,  2839,  2844,  2849,  2854,  2854,  2858,  2867,  2876,
    2886,  2891,  2896,  2896,  2898,  2898,  2901,  2901,  2904,  2905,
    2906,  2907,  2909,  2909,  2914,  2915,  2917,  2918,  2922,  2923,
    2926,  2927,  2930,  2931,  2932,  2935,  2936,  2939,  2940,  2941,
    2944,  2945,  2948,  2949,  2951,  2953,  2963,  2970,  2978,  2986,
    3005,  3017,  3024,  3036,  3041,  3048,  3053,  3061,  3069,  3075,
    3080,  3102,  3106,  3112,  3122,  3130,  3137,  3147,  3153,  3160,
    3164,  3169,  3173,  3179,  3180,  3187,  3195,  3196,  3202,  3212,
    3220,  3229,  3247,  3261,  3264,  3275,  3286,  3291,  3296,  3304,
    3313,  3325,  3339,  3341,  3352,  3364,  3370,  3378,  3387,  3387,
    3388,  3388,  3391,  3393,  3394,  3396,  3397,  3399,  3400,  3402,
    3403,  3405,  3406,  3407,  3409,  3410,  3411,  3412,  3413,  3432,
    3435,  3436,  3437,  3438,  3440,  3441,  3442,  3444,  3445,  3450,
    3455,  3457,  3458,  3459,  3460,  3464,  3465,  3467,  3471,  3475,
    3481,  3490,  3491,  3492,  3493,  3494,  3496,  3497,  3500
};
#endif

/** Accessing symbol of state STATE.  */
#define YY_ACCESSING_SYMBOL(State) YY_CAST (yysymbol_kind_t, yystos[State])

#if 1
/* The user-facing name of the symbol whose (internal) number is
   YYSYMBOL.  No bounds checking.  */
static const char *yysymbol_name (yysymbol_kind_t yysymbol) YY_ATTRIBUTE_UNUSED;

/* YYTNAME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
   First, the terminals, then, starting at YYNTOKENS, nonterminals.  */
static const char *const yytname[] =
{
  "\"end of file\"", "error", "\"invalid token\"", "ALIGN_KEYWORD",
  "ATOMIC_SUB_OP", "DIRECTIVE_DECL", "DIRECTIVE_FUNC",
  "DIRECTIVE_FUNCDECL", "DIRECTIVE_GLOBAL_FUNC", "DIRECTIVE_IMPLICIT",
  "DIRECTIVE_INPUT", "DIRECTIVE_KERNEL", "DIRECTIVE_KERNEL_ATTR",
  "DIRECTIVE_VERSION", "ALIAS_EQ", "ALIGN_EQ", "ATTR_EQ", "OFFSET_EQ",
  "NUM_ELTS_EQ", "V_NAME_EQ", "SIZE_EQ", "V_TYPE_EQ_G", "V_TYPE_EQ_P",
  "V_TYPE_EQ_A", "V_TYPE_EQ_S", "V_TYPE_EQ_T", "CPS",
  "NON_UNIFORM_SAMPLER", "PIXEL_NULL_MASK", "RAW_SEND_STRING",
  "RAW_SENDC_STRING", "RAW_SENDS_STRING", "RAW_SENDS_EOT_STRING",
  "RAW_SENDSC_STRING", "RAW_SENDSC_EOT_STRING", "RAW_SENDG_STRING",
  "RAW_SENDG_EOT_STRING", "RAW_SENDGC_STRING", "RAW_SENDGC_EOT_STRING",
  "SAT", "SRCMOD_ABS", "SRCMOD_NEG", "SRCMOD_NEGABS", "SRCMOD_NOT",
  "BFN_OP", "DPAS_OP", "SVM_ALIGNED", "SVM_UNALIGNED", "BDPAS_OP",
  "NBARRIER_SIGNAL", "NBARRIER_WAIT", "ITYPE", "DECL_DATA_TYPE", "DFTYPE",
  "FTYPE", "HFTYPE", "BFTYPE", "VTYPE", "COND_MOD", "LANGLE", "RANGLE",
  "LBRACK", "RBRACK", "IND_LBRACK", "LPAREN", "RPAREN", "LBRACE", "RBRACE",
  "DOT", "COMMA", "SEMI", "COLON", "SLASH", "PERCENT", "EQUALS", "PLUS",
  "MINUS", "TIMES", "AMP", "CIRC", "PIPE", "TILDE", "BANG", "QUESTION",
  "LEQ", "GEQ", "EQ", "NEQ", "SHL", "SHRS", "SHRZ", "LABEL", "IDENT",
  "BUILTIN_NULL", "BUILTIN", "STRING_LIT", "NEWLINE", "BUILD_OPTION_LINE",
  "UNIFORM", "RTWRITE_OPTION", "MEDIA_MODE", "OWORD_MODIFIER",
  "SAMPLER_CHANNEL", "CHANNEL_OUTPUT", "EXECMODE", "CNTRL",
  "FENCE_OPTIONS", "ADDR_ADD_OP", "UNARY_LOGIC_OP", "BINARY_LOGIC_OP",
  "TERNARY_LOGIC_OP", "QUATERNARY_LOGIC_OP", "SEL_OP", "MIN_OP", "MAX_OP",
  "ANTI_TRIG_OP", "MATH2_OP", "MATH3_OP", "ARITH2_OP", "ARITH3_OP",
  "ARITH4_OP", "ARITH4_OP2", "ARITH5_OP2", "CMP_OP", "SVM_OP",
  "SVM_SCATTER_OP", "SVM_GATHER4SCALED_OP", "SVM_SCATTER4SCALED_OP",
  "SVM_ATOMIC_OP", "OWORD_OP", "MEDIA_OP", "SCATTER_OP",
  "SCATTER_TYPED_OP", "SCATTER_SCALED_OP", "SCATTER4_SCALED_OP",
  "BARRIER_OP", "SBARRIER_SIGNAL", "SBARRIER_WAIT", "DWORD_ATOMIC_OP",
  "TYPED_ATOMIC_OP", "SAMPLE_OP", "SAMPLE_UNORM_OP", "VME_IME_OP",
  "VME_SIC_OP", "VME_FBR_OP", "BRANCH_OP", "RET_OP", "IFCALL", "FCALL",
  "FADDR", "SWITCHJMP_OP", "MOVS_OP", "SETP_OP", "MOV_OP", "FILE_OP",
  "LOC_OP", "CACHE_FLUSH_OP", "WAIT_OP", "FENCE_GLOBAL_OP",
  "FENCE_LOCAL_OP", "FENCE_SW_OP", "YIELD_OP", "SAMPLE_3D_OP",
  "LOAD_3D_OP", "SAMPLE4_3D_OP", "RESINFO_OP_3D", "SAMPLEINFO_OP_3D",
  "RTWRITE_OP_3D", "RTWRITE_OP_3D_UNIFIED", "URBWRITE_OP_3D",
  "LIFETIME_START_OP", "LIFETIME_END_OP", "AVS_OP", "BREAKPOINT_OP",
  "SHFL_IDX4_OP", "LFSR_SUB_OP", "DNSCL_OP", "CALL_OP", "PRED_CNTL",
  "F32_LIT", "F64_LIT", "DEC_LIT", "HEX_LIT", "BUILTIN_SIZEOF",
  "BUILTIN_DISPATCH_SIMD_SIZE", "QW_SCATTER_OP", "LSC_CACHING_OPT",
  "LSC_CACHE_CTRL_SIZE_TYPE", "LSC_CACHE_CTRL_OPERATION_TYPE", "OV",
  "LSC_ADDR_SIZE_TK", "LSC_DATA_SHAPE_TK", "LSC_DATA_SHAPE_TK_CHMASK",
  "LSC_DATA_SHAPE_TK_BLOCK2D", "LSC_AM_FLAT", "LSC_AM_BTI", "LSC_AM_BSS",
  "LSC_AM_SS", "LSC_AM_ARG", "LSC_AM_SURF", "LSC_FENCE_OP_TYPE",
  "LSC_FENCE_SCOPE", "LSC_SFID_UNTYPED_TOKEN", "LSC_SFID_TYPED_TOKEN",
  "LSC_LOAD_MNEMONIC", "LSC_LOAD_STRIDED_MNEMONIC",
  "LSC_LOAD_BLOCK2D_MNEMONIC", "LSC_STORE_MNEMONIC",
  "LSC_STORE_STRIDED_MNEMONIC", "LSC_STORE_BLOCK2D_MNEMONIC",
  "LSC_ATOMIC_MNEMONIC", "LSC_READ_STATE_INFO_MNEMONIC",
  "LSC_LOAD_MSRT_MNEMONIC", "LSC_STORE_MSRT_MNEMONIC",
  "LSC_EXTENDED_CACHE_CTRL_MNEMONIC", "LSC_FENCE_MNEMONIC", "FCVT_OP",
  "LSC_DATA_SHAPE_TK_TYPED_BLOCK2D", "$accept", "Listing", "ListingHeader",
  "Statements", "Newlines", "NewlinesOpt", "Statement", "Scope",
  "ScopeStart", "ScopeEnd", "IdentOrStringLit", "DirectiveKernel",
  "DirectiveGlobalFunction", "DirectiveVersion", "DirectiveDecl",
  "DeclFunction", "DeclVariable", "DeclAddress", "DeclPredicate",
  "DeclSampler", "VNameEqOpt", "DeclSurface", "DirectiveInput",
  "DirectiveImplicitInput", "InputOffset", "InputSize", "DirectiveAttr",
  "DirectiveFunc", "AlignAttrOpt", "Align", "AliasAttrOpt", "OneAttr",
  "AttrOpt", "GenAttrOpt", "Instruction", "Label", "LogicInstruction",
  "UnaryLogicInstruction", "MathInstruction_2OPND",
  "MathInstruction_3OPND", "ArithInstruction_2OPND",
  "ArithInstruction_3OPND", "ArithInstruction_4OPND", "BdpasInstruction",
  "DpasInstruction", "BfnInstruction", "QwScatterInstruction",
  "FCvtInstruction", "AntiTrigInstruction", "AddrAddInstruction",
  "SetpInstruction", "SelInstruction", "MinInstruction", "MaxInstruction",
  "MovInstruction", "BreakpointInstruction", "MovsInstruction",
  "CmpInstruction", "MediaInstruction", "MediaInstructionPlaneID",
  "ScatterInstruction", "ScatterTypedInstruction",
  "Scatter4ScaledInstruction", "ScatterScaledInstruction",
  "SynchronizationInstruction", "DwordAtomicInstruction",
  "TypedAtomicInstruction", "Atomic16Opt", "SampleUnormInstruction",
  "SampleInstruction", "SamplerAddrOperand", "Sample3dInstruction",
  "CPSEnableOpt", "NonUniformSamplerEnableOpt", "Load3dInstruction",
  "Gather43dInstruction", "PixelNullMaskEnableOpt", "ResInfo3dInstruction",
  "SampleInfo3dInstruction", "RTWriteOperands", "RTWriteInstruction",
  "RTWriteModeOpt", "URBWriteInstruction", "AVSInstruction",
  "VMEInstruction", "OwordInstruction", "SvmInstruction",
  "AtomicBitwidthOpt", "LscInstruction", "LscUntypedLoad",
  "LscUntypedStridedLoad", "LscUntypedBlock2dLoad", "LscExtendedCacheCtrl",
  "LscUntypedStore", "LscUntypedStridedStore", "LscUntypedBlock2dStore",
  "LscUntypedAtomic", "LscTypedMSRTLoad", "LscTypedMSRTStore",
  "LscTypedLoad", "LscTypedStore", "LscTypedAtomic",
  "LscTypedReadStateInfo", "LscFence", "LscSfid", "LscCacheOpts", "OVOpt",
  "LscUntypedAddrOperand", "LscUntypedStridedAddrOperand",
  "LscUntypedBlock2dAddrOperand", "LscTypedAddrWithOffsetOperand",
  "LscTypedAddrWithOffsetOperandList", "LscTypedAddrOperandWithOffsets",
  "LscAddrImmOffsetOpt", "LscAddrImmScaleOpt", "LscAddrModelOpt",
  "LscAddrModelStateful", "LscVectorOpRegOrImm32", "LscVectorOpRegOrImm64",
  "LscVectorOpImm32", "LscVectorOpImm64", "LscVectorOpReg",
  "LscDataOperand", "LscDataOperand2D", "LscPayloadReg",
  "LscPayloadNonNullReg", "LscInstructionXe2", "LscTypedBlock2dLoad",
  "LscTypedBlock2dStore", "LscTypedBlock2dAddrOperand",
  "LscDataOperandTyped2D", "LscUntypedApndCtrAtomic", "SwitchLabels",
  "BranchInstruction", "FILE", "LOC", "RawSendInstruction",
  "LifetimeStartInst", "LifetimeEndInst", "RawSendsInstruction",
  "RawSendgInstruction", "RawSendgMnemonic", "RawSendgSfid",
  "RawSendgPayloadSize", "NullaryInstruction", "OwordModifier",
  "ShflIdx4Instruction", "LfsrInstruction", "DnsclInstruction",
  "Predicate", "PredSign", "PredCtrlOpt", "SatModOpt", "SrcModifier",
  "ConditionalModifier", "VecDstOperand_A", "VecDstOperand_G",
  "VecDstOperand_G_I", "VecSrcOperand_G_I_IMM_A_AO",
  "VecSrcOperand_G_I_IMM_A", "VecSrcOperand_G_I_IMM",
  "VecSrcOperand_G_IMM", "VecSrcOperand_G_IMM_AO", "VecSrcOperand_G_A",
  "VecSrcOperand_G_A_AO", "VecSrcOperand_G", "VecSrcOpndSimple",
  "VMEOpndIME", "VMEOpndFBR", "SrcStateOperand", "DstStateOperand",
  "RawOperand", "RawOperandNonNull", "RawOperandOffsetSuffix",
  "RawOperandArray", "DstAddrOperand", "DstGeneralOperand",
  "DstIndirectOperand", "SrcAddrOfOperand", "AddrOfVar", "SrcAddrOperand",
  "SrcGeneralOperand", "SrcImmOperand", "FloatLit", "DoubleFloatLit",
  "SrcIndirectOperand", "DstRegion", "SrcRegionDirect",
  "SrcRegionIndirect", "IndirectVarAccess", "TwoDimOffset", "PredVar",
  "AddrVarAccess", "AddrVarAccessWithWidth", "SIMDMode", "ElemNum",
  "ExecSize", "ExecSizeInt", "Var", "VarNonNull", "IntExp", "IntExpCond",
  "IntExpAND", "IntExpXOR", "IntExpOR", "IntExpCmp", "IntExpRel",
  "IntExpNRA", "IntExpShift", "IntExpAdd", "IntExpMul", "IntExpUnr",
  "IntExpPrim", "DataType", "DataTypeIntOrVector", "BuildOptions", YY_NULLPTR
};

static const char *
yysymbol_name (yysymbol_kind_t yysymbol)
{
  return yytname[yysymbol];
}
#endif

#define YYPACT_NINF (-1147)

#define yypact_value_is_default(Yyn) \
  ((Yyn) == YYPACT_NINF)

#define YYTABLE_NINF (-486)

#define yytable_value_is_error(Yyn) \
  0

/* YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
   STATE-NUM.  */
static const yytype_int16 yypact[] =
{
     -27, -1147,   111,    65,   104, -1147, -1147,    14,   -27, -1147,
     109,  1602,    55,   119,    76,   121,    76,   139,   141,    76,
     147,   201,   201,   221,   221,   162, -1147, -1147, -1147,   201,
     238,    13,   178,   212,   253, -1147, -1147, -1147,   228,   249,
     276,    56,   284,    76,   201,   201,   201,   237,   172, -1147,
    1182,   256,   303, -1147, -1147,   257,   289,   320,   331,   315,
   -1147,   -73,   408,   -27, -1147, -1147,  3614, -1147, -1147, -1147,
   -1147, -1147, -1147, -1147, -1147, -1147, -1147, -1147, -1147, -1147,
   -1147, -1147, -1147, -1147, -1147, -1147, -1147, -1147, -1147, -1147,
   -1147, -1147, -1147, -1147, -1147, -1147, -1147, -1147, -1147, -1147,
   -1147, -1147, -1147, -1147, -1147, -1147, -1147, -1147, -1147, -1147,
   -1147, -1147, -1147, -1147, -1147, -1147, -1147, -1147, -1147, -1147,
   -1147, -1147, -1147, -1147, -1147, -1147, -1147, -1147, -1147, -1147,
   -1147, -1147, -1147, -1147, -1147, -1147, -1147, -1147, -1147, -1147,
   -1147, -1147, -1147, -1147, -1147, -1147, -1147, -1147, -1147, -1147,
   -1147, -1147, -1147, -1147, -1147, -1147, -1147,  3771, -1147, -1147,
     295, -1147, -1147, -1147, -1147, -1147,   425,   425, -1147,   407,
     -40,   343,   343, -1147, -1147, -1147, -1147,    56,   367,   246,
     367,   367, -1147, -1147, -1147, -1147, -1147,   171,   205,    -8,
   -1147,    -6,   221, -1147, -1147, -1147, -1147, -1147, -1147,   418,
     419, -1147,    11, -1147, -1147, -1147,    56,    56, -1147,   201,
     201,   201,   221, -1147,   201,   419,   335,   201,   435,   414,
     337,    56,   343,   221,    56,    -6,   221,    56,    56, -1147,
   -1147,    56, -1147, -1147, -1147, -1147, -1147,   201,   201, -1147,
   -1147,    56, -1147, -1147,   322, -1147,   201,  3112, -1147, -1147,
    3295,   201,   201,   253,   253,   253,   253, -1147, -1147, -1147,
   -1147,   408,   408,   408,   408,   408,   408,   408,   408,   408,
     408,   408,   408,   408,   408,   201,   201,   451,   423,   424,
     516,   428,   459,   429,   529,   532,   201,   201,    -9,   201,
     408,   512,   512,   512,   442,   201,   201,   201,   201,   201,
     474,    44,   342,    70,   204,   344,   217,   230,   354,   355,
     360,   345,   -29,   493,   538,   546,   548,   549,   367,   272,
     552,   501, -1147,   509,   506,   508,   343, -1147,   511,   343,
      -4,   517,   367, -1147, -1147,   520, -1147,    64,   513,   507,
   -1147,   359,    21, -1147,   166,     6, -1147,   413, -1147, -1147,
   -1147, -1147, -1147, -1147, -1147, -1147, -1147, -1147,   499, -1147,
     418,   419,   221,   367, -1147,   318,   367,   534, -1147, -1147,
   -1147,   422, -1147,   460, -1147, -1147,   540,    -6,   221,   221,
     343,    56,    56, -1147,   178,   421,    56,    56,   537,   343,
     343,   539,   343, -1147, -1147, -1147,   554,    50,   543,    56,
     221, -1147,    93,   221,    39,    39,    56,   417,    56, -1147,
   -1147,   -27, -1147,   433,   437,   253,   253,   253,   253,   201,
     201,   201,   201,   201,   201,   201,   201,   201,   201,   201,
     201,   201,   201,    -6,    -6,   439,   201,   201,   557,   201,
     452,   201,   564,   564,    76, -1147,   201,   221,   550,   201,
   -1147,   609,   544,   545, -1147,   201,   462,   343,    56,   343,
      76,   464,   454,   454,   454,   454,   454,   454,   454,   454,
     454,   454,   454,   454,   347,   454,   454,   454,    87, -1147,
   -1147,   201,   623,   367,   367,   367,   367, -1147,   582,   367,
     633, -1147, -1147, -1147, -1147, -1147,   469,   470,   343,   -15,
   -1147,   343, -1147,   367,   367, -1147,   367,   367,   367,   367,
     367,   367,   367,   367,   367,   367,   367,   367,   367,   367,
     367,   367,   367,   367,   591,   318,   534,   221,   399,    61,
   -1147, -1147, -1147, -1147, -1147, -1147,   594,   367, -1147, -1147,
     595,    56, -1147,  1120, -1147, -1147,   606, -1147, -1147,   605,
     367,   221,   221,    50,   343,   343, -1147,   221,   612,    56,
     607,   347,    56,   489,   343,   343,   221,   343,   367,   318,
   -1147,   554,     1, -1147,   610, -1147, -1147,   613,   367, -1147,
      56,   343, -1147,   343,   221, -1147,  1182,   604,   492,   497,
     253,   253,   253,   253,    -6,    -6,    -6,    -6,    -6,    -6,
      -6,    -6,    -6,    -6,    -6,    -6,    -6,    -6,    -6,    56,
     611,   221,   221,   500,   201,    56,   201,    56,   505,   201,
     201, -1147,   221,   514,   518,    -6, -1147,   653,   201,   201,
      56,   522,    32,    32,   343, -1147,   201,   503,   498,   201,
     201,   201,   347,   201,   201,   201,   201,    22,   201,   201,
     508,    22, -1147, -1147,   511,   201,   201,   504, -1147, -1147,
     343,   367,   633,   633,   682,   682,   615, -1147, -1147,   643,
   -1147,    56,   367, -1147,   343,   647,   645,   513,    -7,   507,
   -1147, -1147, -1147, -1147, -1147, -1147, -1147,     6,     6,   395,
     395,   395, -1147, -1147, -1147, -1147, -1147, -1147, -1147,   530,
     367,   367,   367,   642, -1147, -1147, -1147, -1147, -1147, -1147,
     367,   367,   648,   221,   221, -1147, -1147,   343,   229,   221,
     221,   221, -1147,   343,   343,   221,   649,   343, -1147,   646,
     343,   656, -1147, -1147,     1,     1,   652,   367,   367,   180,
     650,   343, -1147,   221, -1147, -1147,   547,   566,   253,   253,
     201,   201,   221,   221,    56,   221,    56,   221,   221,   221,
     221,   221,   221,   221,   221,   221,   221,   221,   221,   221,
     567,   343,   343, -1147,   343,   343,    56,   221, -1147,    56,
      56,   568,   569,   570,   994,   994,   103, -1147,   616,   221,
     221, -1147,   343,    32,  1182,   343,    56,   535, -1147,   201,
     347,   347,   347,   510,    22,   110,    22,   110,   558,   662,
     667,   669,   689,   694,   347,   347,   347,   696,   347,    22,
     571,   687,   745, -1147, -1147,   670,   633,   633,   690, -1147,
     113, -1147, -1147,   419,   698,    56, -1147, -1147,   367,   701,
     699,   700,   708,   224,   712, -1147, -1147, -1147,   221,   343,
     343,   343,   343,   221, -1147,   343,   221, -1147, -1147, -1147,
   -1147, -1147,   707,   268, -1147,    94, -1147,   221,  1182,  1182,
     201,   201,  1182,  1182,   221, -1147, -1147,   221,    56,   221,
     221,   221,   221,   221, -1147, -1147,   221, -1147,   221,   221,
     221,   221,   201,   343,   343,   343,   343,   221,   343,   343,
     343,   592, -1147, -1147, -1147, -1147, -1147, -1147, -1147, -1147,
   -1147,   605,   201,    39,    39,  1213,   343, -1147, -1147,   343,
     343, -1147,   347,    22,   281,   110,   558,   581, -1147, -1147,
     711, -1147,   347,   716, -1147,   347,   717, -1147,   347,   718,
     720,   347,    46,    46,    46,    46,    46, -1147,   110,    22,
     116,    22,   347,   201,    94,   343,    31,   768, -1147, -1147,
   -1147, -1147,   541, -1147,   615, -1147, -1147,    56, -1147, -1147,
     367, -1147, -1147,   367,   343, -1147,   343,   343,   343,   221,
     343,   721, -1147,   722,   221,   343,   343,  1182,  1182,  1182,
    1182,   221, -1147, -1147,   221,   221, -1147, -1147, -1147, -1147,
   -1147,   221, -1147, -1147,   343, -1147, -1147,   343,   343,   343,
     343,   343,   343, -1147,   221,   343,    39, -1147, -1147,   343,
   -1147,   343,   110, -1147, -1147, -1147, -1147, -1147, -1147,    46,
   -1147,     3, -1147,   116, -1147,     3,    56, -1147,   285, -1147,
   -1147,   319, -1147,   317,   325,   353, -1147, -1147, -1147,   714,
     400,   347,   347,   347,   726, -1147,   511, -1147, -1147,   110,
   -1147,   687, -1147, -1147, -1147, -1147,   738,   633, -1147, -1147,
   -1147, -1147,   739,   740, -1147, -1147, -1147,   343,   221,   343,
   -1147, -1147,   221,   343,   343,  1182,  1182,   343,   343, -1147,
   -1147,   221, -1147,   343,   343,   343,   343, -1147,   343,   343,
      39,   343,   343,   343, -1147, -1147,   733,   742,   116,   724,
     737,   748,   404,   116,    68, -1147,   367,   367,   631, -1147,
     367, -1147,   367, -1147,   367,   367,   367,   367,   744,   347,
   -1147,   347, -1147, -1147,   343,    42, -1147, -1147, -1147, -1147,
     343, -1147,   221, -1147, -1147,   343,   343,   343,   343, -1147,
   -1147, -1147,   343, -1147,   343,   343,    39, -1147,   343, -1147,
   -1147, -1147,   400, -1147,   116,   624,   367,   367,   400,    46,
     751,   752,   749, -1147,   756,   757,   758,   762,   395,     6,
      56, -1147, -1147,   687, -1147,   759, -1147,   221,   343,   343,
     343,   343, -1147, -1147,   343,   343,   343, -1147,   764,   763,
   -1147,     6,     6,    30,   765,   367, -1147,   367, -1147, -1147,
   -1147, -1147,   400,  1182,   367,   730,   343,   343, -1147, -1147,
     343,   343, -1147,   343,   637,   116,    46,    46,   769,   766,
     777,  1182,   780,   221, -1147, -1147,   343, -1147, -1147,   772,
     781,   773,   367, -1147, -1147,    94, -1147,   741, -1147,   343,
     116,   657,    46,   783, -1147,   221, -1147, -1147,   784,   787,
     343,    46, -1147, -1147,   793,   400,    46,   795,   788,   400,
      46, -1147,   790,   807,   400, -1147, -1147,   808, -1147
};

/* YYDEFACT[STATE-NUM] -- Default reduction number in state STATE-NUM.
   Performed when YYTABLE does not specify something else to do.  Zero
   means the default is an error.  */
static const yytype_int16 yydefact[] =
{
       8,     7,     0,     9,     0,     1,     6,     0,     8,     3,
       0,   360,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   362,    24,   130,   498,     0,
     372,     0,   355,     0,     0,   172,   173,   174,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   347,
       0,   350,   352,   354,   349,     0,     0,     0,     0,     0,
     159,     0,   366,     8,     5,    19,     0,    11,    12,    10,
      36,    31,    32,    33,    34,    35,    14,    13,    16,    15,
      17,    18,    73,    75,    76,    77,    78,    79,    80,   123,
     118,   119,   120,   122,    81,    82,   103,   100,   101,   102,
      99,   129,    98,    83,    84,    86,    87,    89,    88,    90,
      92,    93,    95,    94,   108,   109,   110,   111,   112,   113,
     114,    97,    96,    85,    74,   121,   219,   220,   221,   232,
     222,   223,   224,   225,   230,   231,   226,   227,   228,   229,
     233,   124,   308,   309,   307,    91,   104,   105,   106,   115,
     116,   107,   125,   117,   126,   127,   128,     0,    20,    30,
       0,    26,    27,    56,    37,    29,    49,    49,    28,    54,
       0,     0,     0,   369,   368,   370,   371,     0,     0,     0,
       0,     0,   450,   449,   451,   423,   426,   485,   486,     0,
     490,     0,     0,   382,   394,   384,   419,   421,   383,     0,
       0,   448,     0,   484,   177,   363,     0,     0,   373,     0,
       0,     0,     0,   356,     0,     0,     0,     0,   442,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   327,
     328,     0,   348,   385,   386,   351,   353,     0,     0,   331,
     332,     0,   249,   250,     0,   367,     0,   360,     2,    23,
     360,     0,     0,     0,     0,     0,     0,   338,   339,   340,
     341,   366,   366,   366,   366,   366,   366,   366,   366,   366,
     366,   366,   366,   366,   366,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     366,   194,   194,   194,   202,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    71,
      46,    55,   447,     0,     0,     0,     0,   400,     0,     0,
       0,     0,     0,   485,   486,     0,   452,   454,   456,   458,
     460,   463,   468,   469,   473,   476,   480,   486,   420,   422,
     481,   482,   483,   427,   424,   428,   425,   418,     0,   488,
       0,     0,   176,     0,   433,     0,     0,     0,   496,   497,
     417,   364,   439,     0,   374,   407,     0,     0,     0,     0,
       0,     0,     0,   444,   355,     0,     0,     0,     0,     0,
       0,     0,     0,   326,   376,   377,     0,     0,     0,     0,
       0,   375,     0,     0,     0,     0,     0,     0,     0,     4,
      25,     8,    21,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   217,     0,
       0,     0,   180,   180,     0,   321,     0,     0,     0,     0,
     195,   188,     0,     0,   203,     0,     0,     0,     0,     0,
       0,     0,   251,   251,   251,   251,   251,   251,   251,   251,
     251,   251,   251,   251,     0,   251,   251,   251,     0,   343,
     344,     0,     0,     0,     0,     0,     0,    50,     0,     0,
      71,    48,    45,    52,    53,   445,     0,     0,     0,     0,
     402,     0,   437,     0,     0,   487,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   468,
     492,   493,   494,   495,   429,   491,     0,     0,   415,   365,
       0,     0,   392,     0,   390,   393,   411,   391,   414,     0,
       0,     0,     0,   439,     0,     0,   212,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     409,     0,   316,   161,     0,   162,   160,     0,     0,   152,
       0,     0,   185,     0,     0,   248,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   319,     0,     0,     0,     0,   189,   190,     0,     0,
       0,     0,     0,     0,     0,   320,     0,     0,   254,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     449,     0,   303,   304,   448,     0,     0,     0,   345,   342,
       0,     0,    71,    71,    42,    42,     0,    51,    47,     0,
     401,     0,     0,   403,     0,     0,     0,   455,     0,   457,
     459,   461,   462,   464,   465,   466,   467,   474,   475,   470,
     471,   472,   478,   479,   477,   489,   430,   416,   175,     0,
       0,   435,     0,     0,   361,   413,   151,   387,   389,   388,
       0,     0,     0,     0,     0,   210,   211,     0,   167,     0,
       0,     0,   443,     0,     0,     0,     0,     0,   207,     0,
       0,     0,   410,   408,   316,   316,     0,     0,     0,     0,
       0,     0,   197,     0,   149,    22,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   218,     0,     0,     0,     0,   181,     0,
       0,     0,     0,     0,     0,     0,     0,   191,     0,     0,
       0,   198,     0,     0,     0,     0,     0,   252,   255,     0,
       0,     0,     0,     0,     0,   278,     0,   278,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    57,    40,    39,     0,    71,    71,    68,    70,
       0,   446,   146,     0,     0,     0,   436,   440,     0,     0,
       0,     0,     0,     0,     0,   164,   163,   209,     0,     0,
       0,     0,     0,     0,   396,     0,     0,   208,   431,   317,
     318,   322,     0,     0,   399,     0,   196,     0,     0,     0,
       0,     0,     0,     0,     0,   135,   136,     0,     0,     0,
       0,     0,     0,     0,   150,   137,     0,   139,     0,     0,
       0,   141,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   324,   323,   157,   378,   380,   379,   381,   156,
     158,   439,     0,     0,     0,   201,     0,   357,   358,     0,
       0,   253,     0,     0,     0,   278,     0,     0,   314,   310,
     279,   280,     0,     0,   282,     0,     0,   259,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   311,   278,     0,
       0,     0,     0,     0,     0,     0,     0,    63,    58,    43,
      41,    44,     0,    72,     0,   395,   404,     0,   453,   434,
       0,   438,   412,     0,     0,   166,     0,     0,     0,     0,
       0,     0,   398,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   131,   132,     0,     0,   153,   154,   155,   138,
     140,     0,   143,   144,     0,   215,   216,     0,     0,     0,
       0,     0,     0,   325,     0,     0,     0,   199,   200,     0,
     359,     0,   278,   244,   300,   301,   235,   236,   302,     0,
     238,   276,   245,     0,   239,   276,     0,   240,     0,   292,
     291,   297,   295,     0,     0,     0,   294,   293,   296,     0,
     273,     0,   282,     0,     0,   305,   306,   242,   243,   278,
     346,     0,    62,    59,    60,    61,     0,    71,    67,    66,
      69,   145,     0,     0,   165,   168,   184,     0,     0,     0,
     397,   186,     0,     0,     0,     0,     0,     0,     0,   147,
     133,     0,   142,     0,     0,     0,     0,   170,     0,     0,
       0,     0,     0,     0,   148,   234,     0,     0,     0,     0,
     268,     0,   265,     0,     0,   287,     0,     0,     0,   283,
       0,   285,     0,   289,     0,     0,     0,     0,     0,     0,
     315,     0,   247,   237,     0,     0,    38,   432,   441,   183,
       0,   206,     0,   329,   330,     0,     0,     0,     0,   134,
     213,   214,     0,   171,     0,     0,     0,   405,     0,   204,
     281,   257,   273,   277,     0,     0,     0,     0,   273,     0,
       0,     0,     0,   298,     0,     0,     0,     0,   274,   275,
       0,   241,   246,     0,    65,     0,   182,     0,     0,     0,
       0,     0,   169,   178,     0,     0,   192,   405,     0,   269,
     272,   266,   267,     0,     0,     0,   288,     0,   284,   286,
     290,   312,   273,     0,     0,     0,     0,     0,   335,   336,
       0,     0,   406,   193,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   333,   334,     0,   405,   256,   270,
       0,     0,     0,   299,   313,     0,    64,     0,   179,   187,
       0,     0,     0,     0,   337,     0,   271,   258,     0,     0,
       0,     0,   264,   205,     0,   273,     0,     0,     0,   273,
       0,   261,     0,     0,   273,   262,   263,     0,   260
};

/* YYPGOTO[NTERM-NUM].  */
static const yytype_int16 yypgoto[] =
{
   -1147, -1147, -1147,   621,   -53,     0,   625, -1147, -1147,   286,
     -10, -1147, -1147, -1147, -1147, -1147, -1147, -1147, -1147, -1147,
     210, -1147, -1147, -1147,   709,   573, -1147, -1147, -1147, -1147,
   -1147,   -68, -1147,  -466, -1147, -1147, -1147, -1147, -1147, -1147,
   -1147, -1147, -1147, -1147, -1147, -1147, -1147, -1147, -1147, -1147,
   -1147, -1147, -1147, -1147, -1147, -1147, -1147, -1147, -1147, -1147,
   -1147, -1147, -1147, -1147, -1147, -1147, -1147,   457, -1147, -1147,
    -400, -1147, -1147, -1147, -1147, -1147,   213, -1147, -1147, -1147,
   -1147, -1147, -1147, -1147, -1147, -1147, -1147, -1147, -1147, -1147,
   -1147, -1147, -1147, -1147, -1147, -1147, -1147, -1147, -1147, -1147,
   -1147, -1147, -1147, -1147, -1147,   415, -1147,  -785,   -28,   -25,
   -1117, -1147,  -779,  -881,  -133,  -766,  -553,  -926,  -124,  -885,
   -1147,  -932,  -700,   -35,  -467,  -925, -1147, -1147, -1147,   105,
      96, -1147,  -227, -1147, -1147, -1147, -1147, -1147, -1147, -1147,
   -1147, -1147, -1147, -1019, -1147,   527, -1147, -1147, -1147, -1147,
   -1147, -1147,   665,    26, -1147,   287,  -358,  -110,   128, -1147,
     -23,  -574, -1147, -1147, -1147,    35,  -791, -1147, -1147,   515,
   -1147,  1774,  -914, -1147, -1146, -1147,  -201, -1147,  -338, -1147,
     572,  -595,    52,   735,   743, -1147,  -369,  -322,   556,  -143,
    -196,  -217, -1147,  -204, -1147,  -225,  2765,   427,   403,  1291,
    -140,    79,   411,   434,   438,   410,    -1,  -359, -1147,  -497,
    -501,   868,  -476,  -479,   746, -1147
};

/* YYDEFGOTO[NTERM-NUM].  */
static const yytype_int16 yydefgoto[] =
{
       0,     2,     8,    63,     3,     4,    64,    65,    66,   412,
     163,    67,    68,     9,    69,    70,    71,    72,    73,    74,
     826,    75,    76,    77,   319,   490,    78,    79,   957,   958,
    1067,   829,   830,   491,    80,    81,    82,    83,    84,    85,
      86,    87,    88,    89,    90,    91,    92,    93,    94,    95,
      96,    97,    98,    99,   100,   101,   102,   103,   104,   719,
     105,   106,   107,   108,   109,   110,   111,   619,   112,   113,
     581,   114,   627,   788,   115,   116,   451,   117,   118,   915,
     119,   455,   120,   121,   122,   123,   124,   614,   125,   126,
     127,   128,   129,   130,   131,   132,   133,   134,   135,   136,
     137,   138,   139,   140,   244,   638,   799,   937,   938,   941,
    1110,  1111,   935,  1128,  1108,   933,   934,  1038,  1045,  1039,
    1046,  1040,   923,   926,   924,  1112,   141,   142,   143,   814,
     804,   144,   736,   145,   146,   147,   148,   149,   150,   151,
     152,   312,   481,   955,   153,   214,   154,   155,   156,   157,
     206,   540,   246,   191,   209,   373,   399,   393,   904,   905,
     906,   232,   706,   542,   543,   193,   832,   221,   224,   573,
     400,   652,   327,   500,  1196,   374,   394,   395,   907,   546,
     908,   194,   195,   196,   197,   198,   570,   364,   365,   199,
     367,   371,   330,   548,   386,   217,   171,   323,   200,   201,
    1042,   336,   337,   338,   339,   340,   341,   342,   343,   344,
     345,   202,   203,   534,   535,   158
};

/* YYTABLE[YYPACT[STATE-NUM]] -- What to do in state STATE-NUM.  If
   positive, shift that token.  If negative, reduce the rule whose
   number is the opposite.  If YYTABLE_NINF, syntax error.  */
static const yytype_int16 yytable[] =
{
     192,   204,   659,   375,   529,   583,   165,   651,    11,   168,
     247,   403,   744,  1047,  1050,   687,   688,  1043,  1044,   382,
     932,   689,   690,   691,   668,  1054,   401,   569,   415,   416,
     417,   418,  1062,   225,  1063,   545,  1055,   793,   335,   478,
     952,   939,  1134,  1184,   967,   538,   696,  1199,   360,   672,
     586,  1223,   182,   183,   184,   170,   358,   177,   502,   210,
     211,  1049,   368,   248,   838,   503,   250,   178,   369,     1,
     734,   506,   173,   174,   175,   176,   231,   170,   521,   522,
     512,   513,   396,   523,   359,   233,   182,   183,   184,   446,
     732,  1249,  1224,   735,   813,   178,  1107,  1047,   817,  1226,
     633,   925,   234,   580,  1114,   514,   515,   332,  1239,   568,
     178,     5,   180,   181,   366,   948,   949,     7,   951,  1055,
     512,   701,   332,  1064,   182,   183,   184,   180,   181,   242,
     243,   182,   183,   184,   182,   183,   184,  1169,   182,   183,
     184,   322,   506,  1170,  1023,   514,   515,   507,   182,   183,
     184,   178,   568,   683,   684,   685,   686,   578,   178,   939,
     552,     6,   568,  1051,  1213,   526,   673,   711,   161,   362,
    1053,   162,  1057,   479,   480,   803,  1071,    12,   487,   658,
     963,   494,   964,  1162,   333,   334,   189,   190,  1168,   380,
     590,   591,   592,   593,  1055,    10,   823,   824,   917,  1055,
     391,   571,   733,   398,   697,   708,   571,   401,   182,   731,
     184,   160,   333,   334,   189,   190,   164,   809,   810,   811,
     918,   812,  1022,   528,   353,   354,   536,   333,   334,   189,
     190,   166,  1030,   167,   396,  1032,   159,  1105,  1034,   169,
    1177,   516,   517,  1204,   205,   864,   462,   463,  1212,   702,
    1055,   813,  1058,   936,   518,   519,   520,   401,   355,   356,
     357,   173,   174,   175,   176,   170,   936,   551,   333,   334,
     189,   190,   465,   466,  1133,   333,   334,   189,   190,   213,
    -485,  1198,   353,   354,   177,   178,  -485,  1203,   488,   844,
     396,   396,   489,   702,   985,   986,   208,   179,   989,   990,
    1240,  1241,   180,   181,   930,   809,   810,   811,   931,   812,
     178,  1055,   215,   182,   183,   184,   313,   314,   315,   316,
     317,   216,   332,   608,   609,  1256,  1258,   180,   181,  1265,
     218,  1230,   229,   982,  1269,   927,  1055,   702,  1274,   527,
     220,  1017,   684,   662,   663,   664,   665,   803,   223,   667,
    1115,   219,  1130,   230,  1116,   554,   555,   571,   247,   237,
     960,   961,   235,   675,   676,   748,   749,   750,   751,   368,
     936,   530,   531,   532,   533,   369,  1264,   575,   754,   756,
     579,  1268,  1119,  1117,  1267,  1273,  1120,  1118,  1272,   983,
    1121,   238,   769,  1277,  1122,  1052,   936,   703,   936,   231,
     185,   186,   187,   188,   189,   190,   467,   468,   544,   236,
     712,   587,   239,  1085,  1086,  1087,  1088,   241,  1123,   470,
     471,   375,  1124,   240,   623,   185,   186,   187,   347,   189,
     190,   178,   472,   473,   621,   182,   325,   184,   739,   182,
     650,   184,   318,   332,   222,   510,   511,   245,   180,   181,
     635,   396,   396,   396,   396,   396,   396,   396,   396,   396,
     396,   396,   396,   396,   396,   396,   355,   356,   699,   700,
     516,   517,  1024,  1025,   927,  1126,  1127,   363,  1060,  1166,
    1167,   321,   396,   366,   752,   753,   755,   757,   758,   759,
     760,   761,   762,   763,   764,   765,   766,   767,   768,   385,
     173,   174,   175,   176,   698,   452,   453,   859,   860,   681,
     682,  1145,  1146,  1015,  1016,   785,   383,   387,   388,   435,
     438,   822,   407,   870,   871,   436,   437,   440,   713,   714,
     439,   441,   834,   442,   717,   720,   443,   876,   541,   878,
     450,   454,   461,   729,   464,   482,   469,   477,   333,   334,
     189,   190,   182,   183,   184,  1109,   483,   474,   475,  1109,
     840,   743,   841,   476,   484,   178,   485,   486,   910,   231,
     842,   843,   489,   324,   495,   496,   497,   332,   707,   499,
     331,   504,   180,   181,  1129,   505,  1131,   509,   771,   772,
     571,   524,   508,   537,   361,   709,   493,   862,   863,   781,
     539,  1136,   560,  1069,   550,   178,   563,   572,   566,   372,
     376,  1072,   231,   568,  1073,   588,  1102,   332,   585,   589,
     610,   233,   180,   181,   389,   613,  1179,   392,   397,  1178,
     402,   372,   618,   616,   361,   626,  1068,   965,   234,  1231,
     637,   661,   624,   631,   406,   636,   628,   629,   666,   488,
     322,   670,   173,   174,   175,   176,   695,  1245,   231,   231,
     704,   993,  1181,   702,  1182,  1201,  1202,   710,   794,   711,
     726,   410,   722,   746,   737,   177,   178,   738,   747,   770,
     787,   773,   333,   334,   189,   190,   778,   798,   179,   797,
     845,   846,   820,   180,   181,   782,   848,   849,   850,   783,
    1156,   825,   853,   792,   182,   183,   184,   828,   831,   836,
     837,   839,   700,   844,   854,   856,   858,   861,   912,   865,
     867,   921,   333,   334,   189,   190,   942,   928,   868,   874,
     875,   943,   877,   944,   879,   880,   881,   882,   883,   884,
     885,   886,   887,   888,   889,   890,   891,   869,   892,   901,
     902,   903,   940,   945,   898,   946,  1195,   950,   953,   954,
     956,   969,   959,   966,   962,   971,   913,   914,   970,  1254,
     972,   973,   982,  1013,  1028,  1029,   549,  1031,  1033,  1035,
     553,  1036,  1066,  1125,   557,   558,  1080,  1081,  1132,   561,
     562,   185,   186,   718,   188,   189,   190,  1135,  1160,  1137,
    1138,  1163,   574,   577,  1161,  1048,  1164,   582,   582,   584,
    1165,   397,  1173,  1180,  1200,  1205,  1065,  1206,  1207,   231,
     231,  1208,  1209,  1210,  1211,   974,  1224,  1238,  1214,   233,
     979,  1243,  1225,   981,  1227,  1233,   397,   397,  1242,  1244,
    1246,  1250,  1252,  1251,   984,  1255,   234,  1257,  1259,  1262,
    1271,   991,  1275,  1261,   992,  1232,   994,   995,   996,   997,
     998,   397,  1266,   999,  1270,  1000,  1001,  1002,  1003,  1276,
    1278,   411,   409,   745,  1009,   827,   320,   653,   639,   640,
     641,   642,   643,   644,   645,   646,   647,   648,   649,  1048,
     655,   656,   657,   492,   231,   231,  1070,  1026,   231,   231,
     620,  1027,  1113,   233,   233,  1106,  1037,   233,   233,   929,
     947,   559,   784,   909,   348,   576,   525,   968,   678,   680,
     234,   234,   349,   669,   234,   234,   419,   420,   421,   422,
     423,   424,   425,   426,   427,   428,   429,   430,   431,   432,
     677,   231,     0,     0,   705,   547,   679,     0,   370,     0,
     233,     0,     0,     0,     0,   449,  1078,     0,     0,     0,
       0,  1082,   721,     0,   724,   725,     0,   234,  1089,     0,
       0,  1090,  1091,     0,     0,     0,  1171,  1172,  1092,     0,
    1174,     0,  1175,   740,  1176,     0,     0,     0,     0,     0,
       0,  1100,     0,     0,     0,     0,     0,   397,   553,   553,
     397,   397,   397,   397,   397,   397,   397,   397,   397,   397,
     397,   397,   372,   231,   231,   231,   231,     0,   775,     0,
     777,     0,   233,   233,   233,   233,     0,     0,   786,     0,
       0,     0,     0,   791,   173,   174,   175,   176,     0,   234,
     234,   234,   234,     0,     0,   653,   346,   350,   351,   352,
       0,     0,     0,     0,     0,  1140,     0,   177,   178,  1142,
       0,     0,     0,     0,     0,     0,     0,  1229,  1149,     0,
     179,     0,   541,     0,   833,   180,   181,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   182,   183,   184,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   231,   231,     0,     0,     0,     0,     0,     0,  1187,
     233,   233,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   234,   234,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   372,     0,   372,
     173,   174,   175,   176,  1215,     0,     0,     0,     0,     0,
       0,     0,     0,   185,   186,   187,   188,   189,   190,   897,
       0,     0,   899,   900,   178,     0,   346,   549,   911,   346,
       0,     0,     0,     0,     0,     0,   179,     0,   541,   920,
     350,   180,   181,   653,   653,   653,     0,     0,     0,     0,
    1247,     0,   182,   183,   184,     0,     0,   653,   653,   653,
       0,   653,   173,   174,   175,   176,     0,     0,     0,     0,
       0,   346,  1260,     0,   346,     0,     0,     0,   833,   231,
       0,     0,     0,     0,     0,     0,   178,     0,   233,     0,
       0,     0,     0,   173,   174,   175,   176,   231,   179,     0,
       0,     0,     0,   180,   181,   234,   233,     0,     0,     0,
       0,     0,     0,     0,   182,   183,   184,   178,     0,     0,
       0,   372,     0,   234,     0,     0,     0,     0,     0,   179,
       0,     0,     0,     0,   180,   181,     0,     0,     0,   185,
     186,   187,   188,   189,   190,   182,   650,   184,     0,     0,
       0,     0,     0,     0,     0,     0,   582,   582,     0,     0,
       0,     0,     0,     0,     0,   653,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   653,     0,     0,   653,     0,
       0,   653,     0,     0,   653,  1041,  1041,  1041,  1041,  1041,
       0,   346,   346,   346,   346,   653,     0,   346,     0,     0,
       0,   185,   186,   187,   188,   189,   190,     0,     0,     0,
     833,   346,   346,     0,   346,   346,   346,   346,   346,   346,
     346,   346,   346,   346,   346,   346,   346,   346,   346,   692,
     693,   694,   185,   186,   187,   188,   189,   190,     0,     0,
       0,     0,     0,     0,     0,   346,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   346,   582,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1041,     0,     0,     0,   346,     0,     0,  1041,
       0,     0,     0,     0,     0,     0,   346,     0,     0,     0,
       0,     0,     0,     0,   653,   653,   653,     0,     0,     0,
       0,     0,   328,   328,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   582,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   328,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   346,
       0,     0,   653,     0,   653,     0,     0,     0,  1185,     0,
     346,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   582,
       0,     0,     0,     0,     0,     0,     0,     0,   346,   346,
     346,     0,  1041,     0,     0,     0,     0,     0,   346,   346,
       0,     0,     0,  1041,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   346,   346,    13,    14,    15,
      16,    17,    18,    19,    20,     0,     0,   328,     0,     0,
     328,     0,     0,     0,     0,     0,     0,     0,     0,  1041,
    1041,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    21,     0,     0,
      22,    23,    24,     0,     0,  1041,     0,     0,     0,     0,
       0,     0,     0,     0,  1041,     0,    25,     0,    26,  1041,
       0,   328,     0,  1041,     0,     0,     0,     0,     0,     0,
     328,   328,     0,   328,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    27,     0,     0,     0,     0,     0,    28,
       0,     0,     0,     0,     0,     0,   346,     0,     0,    29,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    30,    31,     0,     0,     0,
       0,    32,    33,    34,     0,     0,     0,    35,    36,    37,
       0,     0,    38,    39,    40,    41,    42,     0,   328,     0,
     328,    43,    44,    45,    46,     0,    47,    48,    49,    50,
      51,    52,    53,    54,     0,   654,     0,    55,    56,     0,
       0,     0,    57,    58,    59,    60,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   328,
       0,     0,   328,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     346,   346,   346,   346,   346,     0,     0,    61,    62,     0,
       0,     0,     0,     0,   346,     0,     0,     0,     0,     0,
     346,     0,     0,     0,     0,     0,     0,     0,   346,     0,
       0,   346,     0,     0,     0,   328,   328,     0,     0,     0,
       0,     0,   654,     0,     0,   328,   328,     0,   328,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   328,     0,   328,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   346,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   328,     0,     0,     0,     0,
       0,     0,     0,   654,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   326,   329,     0,     0,     0,
       0,   328,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   328,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   346,   346,     0,     0,   346,     0,
     346,     0,   346,   346,   346,   346,   390,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   328,     0,
       0,     0,     0,     0,   328,   328,     0,     0,   328,     0,
       0,   328,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   328,     0,   346,   346,     0,   346,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   328,   328,     0,   328,   328,     0,     0,     0,
       0,     0,     0,  1228,     0,   346,     0,     0,     0,     0,
       0,     0,   346,   328,     0,     0,   328,     0,     0,     0,
       0,   654,   654,   654,   346,   346,     0,     0,     0,     0,
     498,     0,     0,   501,     0,   654,   654,   654,     0,   654,
    1253,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     346,     0,     0,     0,     0,     0,     0,     0,     0,   346,
       0,     0,     0,     0,   346,     0,     0,     0,   346,     0,
     328,   328,   328,   328,     0,     0,   328,     0,     0,     0,
       0,     0,     0,     0,   556,     0,     0,     0,     0,     0,
       0,     0,     0,   564,   565,     0,   567,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   328,   328,   328,   328,     0,   328,
     328,   328,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   654,   328,     0,     0,
     328,   328,     0,   654,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   654,     0,     0,   654,     0,     0,   654,
       0,   632,   654,   634,     0,     0,     0,     0,     0,     0,
       0,  1056,     0,   654,     0,     0,   328,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   328,     0,   328,   328,   328,
       0,   328,   671,     0,     0,   674,   328,   328,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   328,     0,     0,   328,   328,
     328,   328,   328,   328,     0,     0,   328,     0,     0,     0,
     328,     0,   328,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1056,     0,     0,     0,   715,   716,
       0,     0,     0,     0,     0,   723,     0,     0,   727,   728,
       0,   730,   654,   654,   654,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   741,     0,   742,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   328,     0,
     328,     0,     0,     0,   328,   328,     0,     0,   328,   328,
       0,     0,     0,     0,   328,   328,   328,   328,     0,   328,
     328,     0,   328,   328,   328,     0,     0,     0,     0,  1056,
       0,     0,     0,     0,  1056,     0,     0,     0,   795,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     654,     0,   654,     0,     0,   328,     0,     0,     0,     0,
       0,   328,     0,     0,   821,     0,   328,   328,   328,   328,
       0,     0,     0,   328,     0,   328,   328,     0,   835,   328,
       0,     0,     0,     0,     0,  1056,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   328,
     328,   328,   328,     0,     0,   328,   328,   328,     0,     0,
       0,   847,     0,     0,     0,     0,     0,   851,   852,     0,
       0,   855,     0,     0,   857,     0,     0,   328,   328,     0,
       0,   328,   328,     0,   328,   866,  1056,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   328,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     328,  1056,     0,     0,     0,   893,   894,     0,   895,   896,
       0,   328,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   916,     0,     0,   919,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   975,   976,   977,   978,     0,     0,   980,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1005,  1006,  1007,
    1008,     0,  1010,  1011,  1012,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1018,
    1019,     0,     0,  1020,  1021,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1061,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1074,     0,
    1075,  1076,  1077,     0,  1079,     0,     0,     0,     0,  1083,
    1084,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1093,     0,
       0,  1094,  1095,  1096,  1097,  1098,  1099,   172,     0,  1101,
       0,     0,     0,  1103,   207,  1104,   212,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   226,
     227,   228,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1139,     0,  1141,     0,     0,     0,  1143,  1144,     0,
       0,  1147,  1148,     0,     0,     0,     0,  1150,  1151,  1152,
    1153,     0,  1154,  1155,     0,  1157,  1158,  1159,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1183,     0,
       0,     0,     0,     0,  1186,     0,     0,     0,     0,  1188,
    1189,  1190,  1191,     0,     0,     0,  1192,     0,  1193,  1194,
       0,     0,  1197,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1216,  1217,  1218,  1219,     0,     0,  1220,  1221,
    1222,     0,     0,     0,   377,   378,   379,     0,     0,   381,
       0,     0,   384,     0,     0,     0,     0,     0,     0,     0,
    1234,  1235,     0,     0,  1236,  1237,     0,  1222,     0,     0,
       0,     0,   404,   405,     0,     0,     0,     0,     0,     0,
    1248,   408,     0,     0,     0,     0,   413,   414,     0,     0,
       0,     0,     0,  1222,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1263,     0,     0,     0,     0,     0,
     433,   434,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   444,   445,   447,   448,     0,     0,     0,     0,     0,
     456,   457,   458,   459,   460,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    -9,     0,     0,     0,     0,    13,    14,    15,
      16,    17,    18,    19,    20,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    21,     0,     0,
      22,    23,    24,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    25,     0,    26,    -9,
       0,     0,     0,     0,   594,   595,   596,   597,   598,   599,
     600,   601,   602,   603,   604,   605,   606,   607,     0,     0,
       0,   611,   612,    27,   615,     0,   617,     0,     6,    28,
       0,   622,     0,     0,   625,     0,     0,     0,     0,    29,
     630,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    30,    31,     0,     0,     0,
       0,    32,    33,    34,     0,     0,   660,    35,    36,    37,
       0,     0,    38,    39,    40,    41,    42,     0,     0,     0,
       0,    43,    44,    45,    46,     0,    47,    48,    49,    50,
      51,    52,    53,    54,     0,     0,     0,    55,    56,     0,
       0,     0,    57,    58,    59,    60,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      13,    14,    15,    16,    17,    18,    19,    20,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    61,    62,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      21,     0,     0,    22,    23,    24,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    25,
       0,    26,   410,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   774,
       0,   776,     0,     0,   779,   780,    27,     0,     0,     0,
       0,     0,    28,   789,   790,     0,     0,     0,     0,     0,
       0,   796,    29,     0,   800,   801,   802,     0,   805,   806,
     807,   808,     0,   815,   816,     0,     0,     0,    30,    31,
     818,   819,     0,     0,    32,    33,    34,     0,     0,     0,
      35,    36,    37,     0,     0,    38,    39,    40,    41,    42,
       0,     0,     0,     0,    43,    44,    45,    46,     0,    47,
      48,    49,    50,    51,    52,    53,    54,     0,     0,     0,
      55,    56,     0,     0,     0,    57,    58,    59,    60,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      61,    62,     0,     0,     0,   872,   873,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   922,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   249,     0,     0,     0,    -8,
      -8,    -8,    -8,    -8,    -8,    -8,    -8,     0,     0,     0,
       0,     0,     0,     0,     0,   987,   988,     0,     0,     0,
       0,     0,     0,    -8,    -8,    -8,    -8,    -8,    -8,    -8,
      -8,    -8,    -8,     0,     0,     0,     0,  1004,    -8,    -8,
       0,     0,    -8,    -8,    -8,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1014,    -8,     0,
      -8,    -8,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    -8,     0,     0,     0,     0,
       1,    -8,     0,     0,     0,     0,     0,     0,  1059,     0,
       0,    -8,    -8,    -8,    -8,    -8,    -8,    -8,    -8,    -8,
      -8,    -8,    -8,    -8,    -8,    -8,    -8,    -8,    -8,    -8,
      -8,    -8,    -8,    -8,    -8,    -8,    -8,    -8,    -8,    -8,
      -8,    -8,    -8,    -8,    -8,    -8,    -8,    -8,    -8,    -8,
      -8,    -8,    -8,    -8,    -8,    -8,    -8,    -8,    -8,    -8,
      -8,    -8,    -8,    -8,    -8,    -8,    -8,    -8,    -8,    -8,
      -8,    -8,     0,    -8,    -8,    -8,    -8,    -8,    -8,    -8,
      -8,    -8,     0,     0,     0,     0,     0,     0,     0,    -8,
     251,   252,   253,   254,   255,   256,   257,   258,   259,   260,
       0,     0,     0,     0,     0,   261,     0,     0,    -8,    -8,
      -8,    -8,    -8,    -8,    -8,    -8,    -8,    -8,    -8,    -8,
      -8,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   262,
     263,   264,   265,   266,   267,   268,   269,   270,   271,   272,
     273,   274,   275,   276,     0,     0,   277,   278,   279,   280,
       0,     0,     0,   281,   282,   283,     0,     0,     0,   284,
     285,     0,     0,     0,     0,     0,   286,   287,   288,   289,
       0,     0,     0,     0,   290,     0,     0,     0,     0,     0,
       0,     0,     0,   291,   292,   293,     0,     0,   294,     0,
     295,     0,     0,     0,     0,   296,   297,   298,   299,     0,
       0,     0,     0,     0,     0,     0,   300,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   301,   302,   303,   304,   305,
     306,   307,   308,   309,   310,   311
};

static const yytype_int16 yycheck[] =
{
      23,    24,   478,   207,   363,   405,    16,   474,     8,    19,
      63,   228,   586,   945,   946,   516,   517,   943,   944,   215,
     805,   518,   519,   520,   490,   950,   227,   396,   253,   254,
     255,   256,     1,    43,     3,   373,   950,   632,   178,    68,
     819,   807,  1061,     1,   835,   367,   525,  1164,   191,    64,
     408,  1197,    92,    93,    94,    64,    64,    63,    62,    46,
      47,   946,    51,    63,    71,    69,    66,    64,    57,    96,
      69,    78,    40,    41,    42,    43,    50,    64,    72,    73,
      59,    60,   225,    77,    92,    50,    92,    93,    94,    98,
     569,  1237,    62,    92,   647,    64,    93,  1029,   651,    69,
     458,   801,    50,    64,  1036,    84,    85,    76,  1225,    59,
      64,     0,    81,    82,    64,   815,   816,    13,   818,  1033,
      59,    60,    76,    92,    92,    93,    94,    81,    82,   202,
     203,    92,    93,    94,    92,    93,    94,    69,    92,    93,
      94,   181,    78,    75,   923,    84,    85,    83,    92,    93,
      94,    64,    59,   512,   513,   514,   515,    64,    64,   925,
     377,    96,    59,   948,  1183,   361,   181,    64,    92,   192,
     949,    95,   951,   202,   203,   642,   967,    68,   318,    92,
      67,   321,    69,  1108,   181,   182,   183,   184,  1113,   212,
     415,   416,   417,   418,  1108,   181,   662,   663,   793,  1113,
     223,   397,   571,   226,   526,   543,   402,   408,    92,   568,
      94,    92,   181,   182,   183,   184,    95,   195,   196,   197,
     794,   199,   922,   363,    53,    54,   366,   181,   182,   183,
     184,    92,   932,    92,   377,   935,   181,  1022,   938,    92,
    1125,    75,    76,  1169,    82,    65,   202,   203,  1180,    69,
    1164,   804,   952,   806,    88,    89,    90,   458,    53,    54,
      55,    40,    41,    42,    43,    64,   819,   377,   181,   182,
     183,   184,   202,   203,  1059,   181,   182,   183,   184,   101,
      51,  1162,    53,    54,    63,    64,    57,  1168,    16,    65,
     433,   434,    20,    69,   868,   869,    58,    76,   872,   873,
    1226,  1227,    81,    82,   194,   195,   196,   197,   198,   199,
      64,  1225,   100,    92,    93,    94,    21,    22,    23,    24,
      25,    68,    76,   433,   434,  1250,  1252,    81,    82,  1261,
     102,  1212,    95,    65,  1266,   802,  1250,    69,  1270,   362,
      64,   915,   701,   483,   484,   485,   486,   814,    64,   489,
      65,   102,  1052,   181,    69,   378,   379,   553,   411,   102,
     826,   827,   106,   503,   504,   590,   591,   592,   593,    51,
     923,    53,    54,    55,    56,    57,  1261,   400,   595,   596,
     403,  1266,    65,    64,  1265,  1270,    69,    68,  1269,   865,
      65,   102,   609,  1274,    69,   948,   949,   537,   951,   373,
     179,   180,   181,   182,   183,   184,   202,   203,   373,   106,
     550,   411,    92,   987,   988,   989,   990,   102,    65,   202,
     203,   625,    69,    92,   447,   179,   180,   181,   182,   183,
     184,    64,   202,   203,   444,    92,    93,    94,   578,    92,
      93,    94,    17,    76,    41,    86,    87,    39,    81,    82,
     460,   594,   595,   596,   597,   598,   599,   600,   601,   602,
     603,   604,   605,   606,   607,   608,    53,    54,    69,    70,
      75,    76,   191,   192,   941,    75,    76,    59,   954,    75,
      76,    74,   625,    64,   594,   595,   596,   597,   598,   599,
     600,   601,   602,   603,   604,   605,   606,   607,   608,    64,
      40,    41,    42,    43,   527,   292,   293,   734,   735,   510,
     511,  1085,  1086,   913,   914,   625,   181,   103,   181,    68,
       4,   661,   200,   748,   749,   102,   102,    68,   551,   552,
     102,   102,   672,     4,   557,   558,     4,   754,    78,   756,
      28,    99,    68,   566,   202,    52,   202,   202,   181,   182,
     183,   184,    92,    93,    94,  1031,    18,   203,   203,  1035,
     700,   584,   702,   203,    18,    64,    18,    18,   785,   543,
     710,   711,    20,   170,    65,    69,    68,    76,   543,    68,
     177,    64,    81,    82,  1051,    65,  1053,    80,   611,   612,
     786,    92,    79,    59,   191,   543,    95,   737,   738,   622,
     178,  1067,   181,   962,    64,    64,    69,    64,    69,   206,
     207,   970,   586,    59,   973,   182,  1016,    76,   201,   182,
     181,   586,    81,    82,   221,    68,  1127,   224,   225,  1126,
     227,   228,    68,   181,   231,    26,    95,   833,   586,  1213,
     186,    18,    92,   181,   241,   181,   102,   102,    66,    16,
     181,   181,    40,    41,    42,    43,    65,  1231,   632,   633,
      65,   878,  1129,    69,  1131,  1166,  1167,    61,   633,    64,
     181,    67,    65,   181,    64,    63,    64,    64,   181,    68,
      27,   181,   181,   182,   183,   184,   181,   189,    76,   186,
     713,   714,   188,    81,    82,   181,   719,   720,   721,   181,
    1100,    19,   725,   181,    92,    93,    94,    92,    65,    62,
      65,   181,    70,    65,    65,    69,    60,    65,   102,    69,
     743,   186,   181,   182,   183,   184,    64,   217,   181,   752,
     753,    64,   755,    64,   757,   758,   759,   760,   761,   762,
     763,   764,   765,   766,   767,   768,   769,   181,   181,   181,
     181,   181,   194,    64,   777,    61,  1156,    61,   187,    72,
      15,    60,    92,    65,    74,    65,   789,   790,    69,  1245,
      62,    59,    65,   181,   193,    64,   373,    61,    61,    61,
     377,    61,    14,    69,   381,   382,    65,    65,    62,   386,
     387,   179,   180,   181,   182,   183,   184,    59,    65,    60,
      60,    77,   399,   400,    62,   945,    69,   404,   405,   406,
      62,   408,   181,    69,   190,    64,   956,    65,    69,   793,
     794,    65,    65,    65,    62,   848,    62,   190,    69,   794,
     853,    65,    69,   856,    69,   105,   433,   434,    69,    62,
      60,    69,    69,    62,   867,   104,   794,   190,    65,    62,
      62,   874,    62,    69,   877,  1214,   879,   880,   881,   882,
     883,   458,    69,   886,    69,   888,   889,   890,   891,    62,
      62,   250,   247,   587,   897,   665,   167,   474,   463,   464,
     465,   466,   467,   468,   469,   470,   471,   472,   473,  1029,
     475,   476,   477,   320,   868,   869,   964,   925,   872,   873,
     443,   926,  1035,   868,   869,  1029,   941,   872,   873,   804,
     814,   384,   625,   785,   179,   400,   360,   838,   507,   509,
     868,   869,   179,   496,   872,   873,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     506,   915,    -1,    -1,   541,   373,   508,    -1,   202,    -1,
     915,    -1,    -1,    -1,    -1,   290,   979,    -1,    -1,    -1,
      -1,   984,   559,    -1,   561,   562,    -1,   915,   991,    -1,
      -1,   994,   995,    -1,    -1,    -1,  1116,  1117,  1001,    -1,
    1120,    -1,  1122,   580,  1124,    -1,    -1,    -1,    -1,    -1,
      -1,  1014,    -1,    -1,    -1,    -1,    -1,   594,   595,   596,
     597,   598,   599,   600,   601,   602,   603,   604,   605,   606,
     607,   608,   609,   987,   988,   989,   990,    -1,   615,    -1,
     617,    -1,   987,   988,   989,   990,    -1,    -1,   625,    -1,
      -1,    -1,    -1,   630,    40,    41,    42,    43,    -1,   987,
     988,   989,   990,    -1,    -1,   642,   178,   179,   180,   181,
      -1,    -1,    -1,    -1,    -1,  1078,    -1,    63,    64,  1082,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  1207,  1091,    -1,
      76,    -1,    78,    -1,   671,    81,    82,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    92,    93,    94,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1085,  1086,    -1,    -1,    -1,    -1,    -1,    -1,  1142,
    1085,  1086,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  1085,  1086,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   754,    -1,   756,
      40,    41,    42,    43,  1187,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   179,   180,   181,   182,   183,   184,   776,
      -1,    -1,   779,   780,    64,    -1,   318,   784,   785,   321,
      -1,    -1,    -1,    -1,    -1,    -1,    76,    -1,    78,   796,
     332,    81,    82,   800,   801,   802,    -1,    -1,    -1,    -1,
    1233,    -1,    92,    93,    94,    -1,    -1,   814,   815,   816,
      -1,   818,    40,    41,    42,    43,    -1,    -1,    -1,    -1,
      -1,   363,  1255,    -1,   366,    -1,    -1,    -1,   835,  1213,
      -1,    -1,    -1,    -1,    -1,    -1,    64,    -1,  1213,    -1,
      -1,    -1,    -1,    40,    41,    42,    43,  1231,    76,    -1,
      -1,    -1,    -1,    81,    82,  1213,  1231,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    92,    93,    94,    64,    -1,    -1,
      -1,   878,    -1,  1231,    -1,    -1,    -1,    -1,    -1,    76,
      -1,    -1,    -1,    -1,    81,    82,    -1,    -1,    -1,   179,
     180,   181,   182,   183,   184,    92,    93,    94,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   913,   914,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   922,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   932,    -1,    -1,   935,    -1,
      -1,   938,    -1,    -1,   941,   942,   943,   944,   945,   946,
      -1,   483,   484,   485,   486,   952,    -1,   489,    -1,    -1,
      -1,   179,   180,   181,   182,   183,   184,    -1,    -1,    -1,
     967,   503,   504,    -1,   506,   507,   508,   509,   510,   511,
     512,   513,   514,   515,   516,   517,   518,   519,   520,   521,
     522,   523,   179,   180,   181,   182,   183,   184,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   537,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   550,  1016,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  1029,    -1,    -1,    -1,   568,    -1,    -1,  1036,
      -1,    -1,    -1,    -1,    -1,    -1,   578,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  1051,  1052,  1053,    -1,    -1,    -1,
      -1,    -1,   171,   172,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  1100,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   222,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   661,
      -1,    -1,  1129,    -1,  1131,    -1,    -1,    -1,  1135,    -1,
     672,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1156,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   700,   701,
     702,    -1,  1169,    -1,    -1,    -1,    -1,    -1,   710,   711,
      -1,    -1,    -1,  1180,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   737,   738,     5,     6,     7,
       8,     9,    10,    11,    12,    -1,    -1,   326,    -1,    -1,
     329,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1226,
    1227,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    45,    -1,    -1,
      48,    49,    50,    -1,    -1,  1252,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  1261,    -1,    64,    -1,    66,  1266,
      -1,   380,    -1,  1270,    -1,    -1,    -1,    -1,    -1,    -1,
     389,   390,    -1,   392,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    91,    -1,    -1,    -1,    -1,    -1,    97,
      -1,    -1,    -1,    -1,    -1,    -1,   838,    -1,    -1,   107,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   123,   124,    -1,    -1,    -1,
      -1,   129,   130,   131,    -1,    -1,    -1,   135,   136,   137,
      -1,    -1,   140,   141,   142,   143,   144,    -1,   457,    -1,
     459,   149,   150,   151,   152,    -1,   154,   155,   156,   157,
     158,   159,   160,   161,    -1,   474,    -1,   165,   166,    -1,
      -1,    -1,   170,   171,   172,   173,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   498,
      -1,    -1,   501,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     942,   943,   944,   945,   946,    -1,    -1,   215,   216,    -1,
      -1,    -1,    -1,    -1,   956,    -1,    -1,    -1,    -1,    -1,
     962,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   970,    -1,
      -1,   973,    -1,    -1,    -1,   554,   555,    -1,    -1,    -1,
      -1,    -1,   561,    -1,    -1,   564,   565,    -1,   567,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   581,    -1,   583,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  1029,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   634,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   642,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   171,   172,    -1,    -1,    -1,
      -1,   660,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   674,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  1116,  1117,    -1,    -1,  1120,    -1,
    1122,    -1,  1124,  1125,  1126,  1127,   222,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   717,    -1,
      -1,    -1,    -1,    -1,   723,   724,    -1,    -1,   727,    -1,
      -1,   730,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   741,    -1,  1166,  1167,    -1,  1169,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   771,   772,    -1,   774,   775,    -1,    -1,    -1,
      -1,    -1,    -1,  1205,    -1,  1207,    -1,    -1,    -1,    -1,
      -1,    -1,  1214,   792,    -1,    -1,   795,    -1,    -1,    -1,
      -1,   800,   801,   802,  1226,  1227,    -1,    -1,    -1,    -1,
     326,    -1,    -1,   329,    -1,   814,   815,   816,    -1,   818,
    1242,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    1252,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1261,
      -1,    -1,    -1,    -1,  1266,    -1,    -1,    -1,  1270,    -1,
     849,   850,   851,   852,    -1,    -1,   855,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   380,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   389,   390,    -1,   392,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   893,   894,   895,   896,    -1,   898,
     899,   900,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   915,   916,    -1,    -1,
     919,   920,    -1,   922,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   932,    -1,    -1,   935,    -1,    -1,   938,
      -1,   457,   941,   459,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   950,    -1,   952,    -1,    -1,   955,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   974,    -1,   976,   977,   978,
      -1,   980,   498,    -1,    -1,   501,   985,   986,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  1004,    -1,    -1,  1007,  1008,
    1009,  1010,  1011,  1012,    -1,    -1,  1015,    -1,    -1,    -1,
    1019,    -1,  1021,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  1033,    -1,    -1,    -1,   554,   555,
      -1,    -1,    -1,    -1,    -1,   561,    -1,    -1,   564,   565,
      -1,   567,  1051,  1052,  1053,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   581,    -1,   583,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1077,    -1,
    1079,    -1,    -1,    -1,  1083,  1084,    -1,    -1,  1087,  1088,
      -1,    -1,    -1,    -1,  1093,  1094,  1095,  1096,    -1,  1098,
    1099,    -1,  1101,  1102,  1103,    -1,    -1,    -1,    -1,  1108,
      -1,    -1,    -1,    -1,  1113,    -1,    -1,    -1,   634,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    1129,    -1,  1131,    -1,    -1,  1134,    -1,    -1,    -1,    -1,
      -1,  1140,    -1,    -1,   660,    -1,  1145,  1146,  1147,  1148,
      -1,    -1,    -1,  1152,    -1,  1154,  1155,    -1,   674,  1158,
      -1,    -1,    -1,    -1,    -1,  1164,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1188,
    1189,  1190,  1191,    -1,    -1,  1194,  1195,  1196,    -1,    -1,
      -1,   717,    -1,    -1,    -1,    -1,    -1,   723,   724,    -1,
      -1,   727,    -1,    -1,   730,    -1,    -1,  1216,  1217,    -1,
      -1,  1220,  1221,    -1,  1223,   741,  1225,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  1236,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    1249,  1250,    -1,    -1,    -1,   771,   772,    -1,   774,   775,
      -1,  1260,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   792,    -1,    -1,   795,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   849,   850,   851,   852,    -1,    -1,   855,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   893,   894,   895,
     896,    -1,   898,   899,   900,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   915,
     916,    -1,    -1,   919,   920,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   955,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   974,    -1,
     976,   977,   978,    -1,   980,    -1,    -1,    -1,    -1,   985,
     986,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1004,    -1,
      -1,  1007,  1008,  1009,  1010,  1011,  1012,    22,    -1,  1015,
      -1,    -1,    -1,  1019,    29,  1021,    31,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    44,
      45,    46,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1077,    -1,  1079,    -1,    -1,    -1,  1083,  1084,    -1,
      -1,  1087,  1088,    -1,    -1,    -1,    -1,  1093,  1094,  1095,
    1096,    -1,  1098,  1099,    -1,  1101,  1102,  1103,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1134,    -1,
      -1,    -1,    -1,    -1,  1140,    -1,    -1,    -1,    -1,  1145,
    1146,  1147,  1148,    -1,    -1,    -1,  1152,    -1,  1154,  1155,
      -1,    -1,  1158,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  1188,  1189,  1190,  1191,    -1,    -1,  1194,  1195,
    1196,    -1,    -1,    -1,   209,   210,   211,    -1,    -1,   214,
      -1,    -1,   217,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    1216,  1217,    -1,    -1,  1220,  1221,    -1,  1223,    -1,    -1,
      -1,    -1,   237,   238,    -1,    -1,    -1,    -1,    -1,    -1,
    1236,   246,    -1,    -1,    -1,    -1,   251,   252,    -1,    -1,
      -1,    -1,    -1,  1249,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  1260,    -1,    -1,    -1,    -1,    -1,
     275,   276,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   286,   287,   288,   289,    -1,    -1,    -1,    -1,    -1,
     295,   296,   297,   298,   299,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,     0,    -1,    -1,    -1,    -1,     5,     6,     7,
       8,     9,    10,    11,    12,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    45,    -1,    -1,
      48,    49,    50,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    64,    -1,    66,    67,
      -1,    -1,    -1,    -1,   419,   420,   421,   422,   423,   424,
     425,   426,   427,   428,   429,   430,   431,   432,    -1,    -1,
      -1,   436,   437,    91,   439,    -1,   441,    -1,    96,    97,
      -1,   446,    -1,    -1,   449,    -1,    -1,    -1,    -1,   107,
     455,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   123,   124,    -1,    -1,    -1,
      -1,   129,   130,   131,    -1,    -1,   481,   135,   136,   137,
      -1,    -1,   140,   141,   142,   143,   144,    -1,    -1,    -1,
      -1,   149,   150,   151,   152,    -1,   154,   155,   156,   157,
     158,   159,   160,   161,    -1,    -1,    -1,   165,   166,    -1,
      -1,    -1,   170,   171,   172,   173,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
       5,     6,     7,     8,     9,    10,    11,    12,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   215,   216,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      45,    -1,    -1,    48,    49,    50,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    64,
      -1,    66,    67,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   614,
      -1,   616,    -1,    -1,   619,   620,    91,    -1,    -1,    -1,
      -1,    -1,    97,   628,   629,    -1,    -1,    -1,    -1,    -1,
      -1,   636,   107,    -1,   639,   640,   641,    -1,   643,   644,
     645,   646,    -1,   648,   649,    -1,    -1,    -1,   123,   124,
     655,   656,    -1,    -1,   129,   130,   131,    -1,    -1,    -1,
     135,   136,   137,    -1,    -1,   140,   141,   142,   143,   144,
      -1,    -1,    -1,    -1,   149,   150,   151,   152,    -1,   154,
     155,   156,   157,   158,   159,   160,   161,    -1,    -1,    -1,
     165,   166,    -1,    -1,    -1,   170,   171,   172,   173,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     215,   216,    -1,    -1,    -1,   750,   751,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   799,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,     1,    -1,    -1,    -1,     5,
       6,     7,     8,     9,    10,    11,    12,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   870,   871,    -1,    -1,    -1,
      -1,    -1,    -1,    29,    30,    31,    32,    33,    34,    35,
      36,    37,    38,    -1,    -1,    -1,    -1,   892,    44,    45,
      -1,    -1,    48,    49,    50,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   912,    64,    -1,
      66,    67,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    91,    -1,    -1,    -1,    -1,
      96,    97,    -1,    -1,    -1,    -1,    -1,    -1,   953,    -1,
      -1,   107,   108,   109,   110,   111,   112,   113,   114,   115,
     116,   117,   118,   119,   120,   121,   122,   123,   124,   125,
     126,   127,   128,   129,   130,   131,   132,   133,   134,   135,
     136,   137,   138,   139,   140,   141,   142,   143,   144,   145,
     146,   147,   148,   149,   150,   151,   152,   153,   154,   155,
     156,   157,   158,   159,   160,   161,   162,   163,   164,   165,
     166,   167,    -1,   169,   170,   171,   172,   173,   174,   175,
     176,   177,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   185,
      29,    30,    31,    32,    33,    34,    35,    36,    37,    38,
      -1,    -1,    -1,    -1,    -1,    44,    -1,    -1,   204,   205,
     206,   207,   208,   209,   210,   211,   212,   213,   214,   215,
     216,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   108,
     109,   110,   111,   112,   113,   114,   115,   116,   117,   118,
     119,   120,   121,   122,    -1,    -1,   125,   126,   127,   128,
      -1,    -1,    -1,   132,   133,   134,    -1,    -1,    -1,   138,
     139,    -1,    -1,    -1,    -1,    -1,   145,   146,   147,   148,
      -1,    -1,    -1,    -1,   153,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   162,   163,   164,    -1,    -1,   167,    -1,
     169,    -1,    -1,    -1,    -1,   174,   175,   176,   177,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   185,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   204,   205,   206,   207,   208,
     209,   210,   211,   212,   213,   214
};

/* YYSTOS[STATE-NUM] -- The symbol kind of the accessing symbol of
   state STATE-NUM.  */
static const yytype_int16 yystos[] =
{
       0,    96,   219,   222,   223,     0,    96,    13,   220,   231,
     181,   223,    68,     5,     6,     7,     8,     9,    10,    11,
      12,    45,    48,    49,    50,    64,    66,    91,    97,   107,
     123,   124,   129,   130,   131,   135,   136,   137,   140,   141,
     142,   143,   144,   149,   150,   151,   152,   154,   155,   156,
     157,   158,   159,   160,   161,   165,   166,   170,   171,   172,
     173,   215,   216,   221,   224,   225,   226,   229,   230,   232,
     233,   234,   235,   236,   237,   239,   240,   241,   244,   245,
     252,   253,   254,   255,   256,   257,   258,   259,   260,   261,
     262,   263,   264,   265,   266,   267,   268,   269,   270,   271,
     272,   273,   274,   275,   276,   278,   279,   280,   281,   282,
     283,   284,   286,   287,   289,   292,   293,   295,   296,   298,
     300,   301,   302,   303,   304,   306,   307,   308,   309,   310,
     311,   312,   313,   314,   315,   316,   317,   318,   319,   320,
     321,   344,   345,   346,   349,   351,   352,   353,   354,   355,
     356,   357,   358,   362,   364,   365,   366,   367,   433,   181,
      92,    92,    95,   228,    95,   228,    92,    92,   228,    92,
      64,   414,   414,    40,    41,    42,    43,    63,    64,    76,
      81,    82,    92,    93,    94,   179,   180,   181,   182,   183,
     184,   371,   378,   383,   399,   400,   401,   402,   403,   407,
     416,   417,   429,   430,   378,    82,   368,   414,    58,   372,
      46,    47,   414,   101,   363,   100,    68,   413,   102,   102,
      64,   385,   416,    64,   386,   228,   414,   414,   414,    95,
     181,   371,   379,   383,   400,   106,   106,   102,   102,    92,
      92,   102,   202,   203,   322,    39,   370,   222,   223,     1,
     223,    29,    30,    31,    32,    33,    34,    35,    36,    37,
      38,    44,   108,   109,   110,   111,   112,   113,   114,   115,
     116,   117,   118,   119,   120,   121,   122,   125,   126,   127,
     128,   132,   133,   134,   138,   139,   145,   146,   147,   148,
     153,   162,   163,   164,   167,   169,   174,   175,   176,   177,
     185,   204,   205,   206,   207,   208,   209,   210,   211,   212,
     213,   214,   359,    21,    22,    23,    24,    25,    17,   242,
     242,    74,   181,   415,   416,    93,   389,   390,   417,   389,
     410,   416,    76,   181,   182,   418,   419,   420,   421,   422,
     423,   424,   425,   426,   427,   428,   429,   182,   401,   402,
     429,   429,   429,    53,    54,    53,    54,    55,    64,    92,
     407,   416,   378,    59,   405,   406,    64,   408,    51,    57,
     432,   409,   416,   373,   393,   411,   416,   414,   414,   414,
     378,   414,   408,   181,   414,    64,   412,   103,   181,   416,
     389,   378,   416,   375,   394,   395,   407,   416,   378,   374,
     388,   394,   416,   409,   414,   414,   416,   200,   414,   224,
      67,   221,   227,   414,   414,   413,   413,   413,   413,   370,
     370,   370,   370,   370,   370,   370,   370,   370,   370,   370,
     370,   370,   370,   414,   414,    68,   102,   102,     4,   102,
      68,   102,     4,     4,   414,   414,    98,   414,   414,   370,
      28,   294,   294,   294,    99,   299,   414,   414,   414,   414,
     414,    68,   202,   203,   202,   202,   203,   202,   203,   202,
     202,   203,   202,   203,   203,   203,   203,   202,    68,   202,
     203,   360,    52,    18,    18,    18,    18,   418,    16,    20,
     243,   251,   243,    95,   418,    65,    69,    68,   389,    68,
     391,   389,    62,    69,    64,    65,    78,    83,    79,    80,
      86,    87,    59,    60,    84,    85,    75,    76,    88,    89,
      90,    72,    73,    77,    92,   406,   408,   378,   418,   425,
      53,    54,    55,    56,   431,   432,   418,    59,   405,   178,
     369,    78,   381,   382,   383,   396,   397,   398,   411,   416,
      64,   375,   409,   416,   378,   378,   389,   416,   416,   363,
     181,   416,   416,    69,   389,   389,    69,   389,    59,   404,
     404,   408,    64,   387,   416,   378,   387,   416,    64,   378,
      64,   288,   416,   288,   416,   201,   374,   223,   182,   182,
     413,   413,   413,   413,   414,   414,   414,   414,   414,   414,
     414,   414,   414,   414,   414,   414,   414,   414,   375,   375,
     181,   414,   414,    68,   305,   414,   181,   414,    68,   285,
     285,   228,   414,   378,    92,   414,    26,   290,   102,   102,
     414,   181,   389,   374,   389,   228,   181,   186,   323,   323,
     323,   323,   323,   323,   323,   323,   323,   323,   323,   323,
      93,   342,   389,   416,   417,   323,   323,   323,    92,   430,
     414,    18,   418,   418,   418,   418,    66,   418,   251,   415,
     181,   389,    64,   181,   389,   418,   418,   421,   420,   422,
     423,   424,   424,   425,   425,   425,   425,   428,   428,   427,
     427,   427,   429,   429,   429,    65,   431,   405,   378,    69,
      70,    60,    69,   418,    65,   416,   380,   383,   396,   400,
      61,    64,   418,   378,   378,   389,   389,   378,   181,   277,
     378,   416,    65,   389,   416,   416,   181,   389,   389,   378,
     389,   425,   431,   404,    69,    92,   350,    64,    64,   418,
     416,   389,   389,   378,   379,   227,   181,   181,   413,   413,
     413,   413,   375,   375,   409,   375,   409,   375,   375,   375,
     375,   375,   375,   375,   375,   375,   375,   375,   375,   409,
      68,   378,   378,   181,   414,   416,   414,   416,   181,   414,
     414,   378,   181,   181,   373,   375,   416,    27,   291,   414,
     414,   416,   181,   399,   383,   389,   414,   186,   189,   324,
     414,   414,   414,   342,   348,   414,   414,   414,   414,   195,
     196,   197,   199,   334,   347,   414,   414,   334,   414,   414,
     188,   389,   418,   251,   251,    19,   238,   238,    92,   249,
     250,    65,   384,   416,   418,   389,    62,    65,    71,   181,
     418,   418,   418,   418,    65,   378,   378,   389,   378,   378,
     378,   389,   389,   378,    65,   389,    69,   389,    60,   350,
     350,    65,   418,   418,    65,    69,   389,   378,   181,   181,
     413,   413,   414,   414,   378,   378,   409,   378,   409,   378,
     378,   378,   378,   378,   378,   378,   378,   378,   378,   378,
     378,   378,   181,   389,   389,   389,   389,   416,   378,   416,
     416,   181,   181,   181,   376,   377,   378,   396,   398,   376,
     409,   416,   102,   378,   378,   297,   389,   399,   379,   389,
     416,   186,   414,   340,   342,   340,   341,   342,   217,   347,
     194,   198,   325,   333,   334,   330,   334,   325,   326,   333,
     194,   327,    64,    64,    64,    64,    61,   348,   340,   340,
      61,   340,   330,   187,    72,   361,    15,   246,   247,    92,
     251,   251,    74,    67,    69,   408,    65,   384,   419,    60,
      69,    65,    62,    59,   378,   389,   389,   389,   389,   378,
     389,   378,    65,   430,   378,   379,   379,   414,   414,   379,
     379,   378,   378,   409,   378,   378,   378,   378,   378,   378,
     378,   378,   378,   378,   414,   389,   389,   389,   389,   378,
     389,   389,   389,   181,   414,   288,   288,   379,   389,   389,
     389,   389,   340,   330,   191,   192,   326,   327,   193,    64,
     340,    61,   340,    61,   340,    61,    61,   341,   335,   337,
     339,   416,   418,   335,   335,   336,   338,   339,   418,   337,
     339,   325,   334,   330,   343,   390,   417,   330,   340,   414,
     430,   389,     1,     3,    92,   418,    14,   248,    95,   425,
     249,   384,   425,   425,   389,   389,   389,   389,   378,   389,
      65,    65,   378,   389,   389,   379,   379,   379,   379,   378,
     378,   378,   378,   389,   389,   389,   389,   389,   389,   389,
     378,   389,   288,   389,   389,   325,   336,    93,   332,   430,
     328,   329,   343,   332,   339,    65,    69,    64,    68,    65,
      69,    65,    69,    65,    69,    69,    75,    76,   331,   342,
     340,   342,    62,   325,   361,    59,   251,    60,    60,   389,
     378,   389,   378,   389,   389,   379,   379,   389,   389,   378,
     389,   389,   389,   389,   389,   389,   288,   389,   389,   389,
      65,    62,   343,    77,    69,    62,    75,    76,   343,    69,
      75,   418,   418,   181,   418,   418,   418,   337,   427,   428,
      69,   342,   342,   389,     1,   416,   389,   378,   389,   389,
     389,   389,   389,   389,   389,   288,   392,   389,   331,   328,
     190,   428,   428,   331,   335,    64,    65,    69,    65,    65,
      65,    62,   339,   361,    69,   378,   389,   389,   389,   389,
     389,   389,   389,   392,    62,    69,    69,    69,   429,   418,
     331,   379,   425,   105,   389,   389,   389,   389,   190,   328,
     335,   335,    69,    65,    62,   379,    60,   378,   389,   392,
      69,    62,    69,   429,   430,   104,   343,   190,   335,    65,
     378,    69,    62,   389,   337,   339,    69,   331,   337,   339,
      69,    62,   331,   337,   339,    62,    62,   331,    62
};

/* YYR1[RULE-NUM] -- Symbol kind of the left-hand side of rule RULE-NUM.  */
static const yytype_int16 yyr1[] =
{
       0,   218,   219,   220,   221,   221,   222,   222,   223,   223,
     224,   224,   224,   224,   224,   224,   224,   224,   224,   224,
     224,   225,   225,   225,   226,   227,   228,   228,   229,   230,
     231,   232,   232,   232,   232,   232,   232,   233,   234,   235,
     236,   237,   238,   238,   239,   240,   240,   241,   241,   242,
     242,   243,   244,   244,   244,   244,   245,   246,   246,   247,
     247,   247,   247,   248,   248,   248,   249,   249,   249,   250,
     250,   251,   251,   252,   252,   252,   252,   252,   252,   252,
     252,   252,   252,   252,   252,   252,   252,   252,   252,   252,
     252,   252,   252,   252,   252,   252,   252,   252,   252,   252,
     252,   252,   252,   252,   252,   252,   252,   252,   252,   252,
     252,   252,   252,   252,   252,   252,   252,   252,   252,   252,
     252,   252,   252,   252,   252,   252,   252,   252,   252,   252,
     253,   254,   254,   254,   254,   255,   255,   256,   257,   258,
     259,   259,   260,   260,   260,   261,   262,   263,   264,   265,
     266,   267,   268,   269,   270,   271,   272,   272,   272,   273,
     274,   274,   274,   275,   275,   276,   276,   277,   278,   279,
     280,   281,   282,   282,   282,   282,   282,   282,   283,   284,
     285,   285,   286,   287,   287,   288,   288,   289,   290,   290,
     291,   291,   292,   293,   294,   294,   295,   296,   297,   297,
     297,   298,   299,   299,   300,   301,   302,   302,   302,   303,
     304,   304,   304,   304,   304,   304,   304,   305,   305,   306,
     306,   306,   306,   306,   306,   306,   306,   306,   306,   306,
     306,   306,   306,   306,   307,   308,   309,   310,   311,   312,
     313,   314,   315,   316,   317,   318,   319,   320,   321,   322,
     322,   323,   323,   323,   324,   324,   325,   325,   326,   326,
     327,   327,   327,   327,   327,   328,   328,   328,   329,   329,
     329,   329,   330,   331,   331,   331,   332,   332,   333,   333,
     333,   333,   333,   334,   334,   334,   334,   334,   334,   334,
     334,   335,   335,   336,   336,   337,   338,   339,   339,   339,
     340,   340,   341,   342,   342,   343,   343,   344,   344,   344,
     345,   346,   347,   347,   348,   349,   350,   350,   350,   351,
     351,   351,   351,   351,   351,   351,   351,   352,   353,   354,
     354,   355,   356,   357,   357,   357,   357,   358,   359,   359,
     359,   359,   360,   360,   360,   360,   361,   362,   362,   362,
     362,   362,   362,   362,   362,   363,   363,   364,   365,   366,
     367,   367,   368,   368,   369,   369,   370,   370,   371,   371,
     371,   371,   372,   372,   373,   374,   375,   375,   376,   376,
     377,   377,   378,   378,   378,   379,   379,   380,   380,   380,
     381,   381,   382,   382,   383,   384,   385,   386,   387,   388,
     389,   389,   390,   391,   391,   392,   392,   393,   394,   394,
     395,   396,   396,   397,   398,   399,   399,   400,   400,   400,
     400,   400,   400,   401,   401,   401,   402,   402,   402,   403,
     403,   404,   405,   406,   406,   406,   407,   407,   408,   409,
     410,   411,   412,   412,   413,   414,   414,   415,   416,   416,
     417,   417,   418,   419,   419,   420,   420,   421,   421,   422,
     422,   423,   423,   423,   424,   424,   424,   424,   424,   425,
     426,   426,   426,   426,   427,   427,   427,   428,   428,   428,
     428,   429,   429,   429,   429,   430,   430,   430,   430,   430,
     430,   431,   431,   431,   431,   431,   432,   432,   433
};

/* YYR2[RULE-NUM] -- Number of symbols on the right-hand side of rule RULE-NUM.  */
static const yytype_int8 yyr2[] =
{
       0,     2,     5,     1,     3,     1,     2,     1,     0,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     3,     5,     2,     1,     1,     1,     1,     2,     2,
       4,     1,     1,     1,     1,     1,     1,     2,     9,     6,
       6,     7,     0,     2,     7,     4,     3,     5,     4,     0,
       2,     2,     4,     4,     2,     3,     2,     0,     1,     2,
       2,     2,     2,     0,     6,     3,     3,     3,     1,     3,
       1,     0,     4,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     7,     7,     8,     9,     6,     6,     6,     7,     6,
       7,     6,     8,     7,     7,     8,     6,     8,     8,     5,
       6,     5,     4,     7,     7,     7,     6,     6,     6,     1,
       4,     4,     4,     6,     6,     8,     7,     1,     8,    10,
       8,     9,     1,     1,     1,     5,     3,     2,    10,    13,
       0,     2,    10,     9,     8,     1,     5,    13,     0,     1,
       0,     1,    10,    11,     0,     1,     6,     5,     0,     2,
       2,     6,     0,     1,     9,    16,     9,     5,     6,     6,
       5,     5,     4,     9,     9,     7,     7,     0,     2,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     8,     7,     7,     8,     7,     7,
       7,     9,     7,     7,     7,     7,     9,     8,     4,     1,
       1,     0,     2,     3,     0,     1,     7,     4,     9,     1,
      16,    14,    15,    15,    10,     1,     3,     3,     1,     3,
       5,     7,     5,     0,     2,     2,     0,     2,     0,     1,
       1,     4,     1,     4,     6,     4,     6,     4,     6,     4,
       6,     1,     1,     1,     1,     1,     1,     1,     3,     6,
       2,     2,     2,     1,     1,     1,     1,     1,     1,     1,
       6,     6,     6,     8,     2,     8,     0,     2,     2,     4,
       4,     3,     6,     6,     6,     7,     3,     2,     2,     9,
       9,     2,     2,    12,    12,    11,    11,    13,     1,     1,
       1,     1,     2,     1,     1,     2,     2,     1,     2,     1,
       1,     2,     1,     2,     1,     0,     1,     6,     6,     7,
       0,     5,     0,     1,     0,     1,     0,     1,     1,     1,
       1,     1,     0,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     2,     5,     7,     4,     4,
       1,     3,     2,     2,     4,     0,     2,     1,     3,     2,
       3,     1,     4,     2,     1,     3,     4,     2,     2,     1,
       2,     1,     2,     1,     2,     2,     1,     2,     2,     3,
       4,     3,     7,     1,     5,     3,     5,     3,     5,     1,
       4,     7,     0,     3,     2,     3,     5,     1,     1,     1,
       1,     1,     1,     5,     1,     3,     1,     3,     1,     3,
       1,     3,     3,     1,     3,     3,     3,     3,     1,     1,
       3,     3,     3,     1,     3,     3,     1,     3,     3,     3,
       1,     2,     2,     2,     1,     1,     1,     3,     2,     4,
       1,     1,     1,     1,     1,     1,     1,     1,     1
};


enum { YYENOMEM = -2 };

#define yyerrok         (yyerrstatus = 0)
#define yyclearin       (yychar = YYEMPTY)

#define YYACCEPT        goto yyacceptlab
#define YYABORT         goto yyabortlab
#define YYERROR         goto yyerrorlab
#define YYNOMEM         goto yyexhaustedlab


#define YYRECOVERING()  (!!yyerrstatus)

#define YYBACKUP(Token, Value)                                    \
  do                                                              \
    if (yychar == YYEMPTY)                                        \
      {                                                           \
        yychar = (Token);                                         \
        yylval = (Value);                                         \
        YYPOPSTACK (yylen);                                       \
        yystate = *yyssp;                                         \
        goto yybackup;                                            \
      }                                                           \
    else                                                          \
      {                                                           \
        yyerror (pBuilder, YY_("syntax error: cannot back up")); \
        YYERROR;                                                  \
      }                                                           \
  while (0)

/* Backward compatibility with an undocumented macro.
   Use YYerror or YYUNDEF. */
#define YYERRCODE YYUNDEF


/* Enable debugging if requested.  */
#if YYDEBUG

# ifndef YYFPRINTF
#  include <stdio.h> /* INFRINGES ON USER NAME SPACE */
#  define YYFPRINTF fprintf
# endif

# define YYDPRINTF(Args)                        \
do {                                            \
  if (yydebug)                                  \
    YYFPRINTF Args;                             \
} while (0)




# define YY_SYMBOL_PRINT(Title, Kind, Value, Location)                    \
do {                                                                      \
  if (yydebug)                                                            \
    {                                                                     \
      YYFPRINTF (stderr, "%s ", Title);                                   \
      yy_symbol_print (stderr,                                            \
                  Kind, Value, pBuilder); \
      YYFPRINTF (stderr, "\n");                                           \
    }                                                                     \
} while (0)


/*-----------------------------------.
| Print this symbol's value on YYO.  |
`-----------------------------------*/

static void
yy_symbol_value_print (FILE *yyo,
                       yysymbol_kind_t yykind, YYSTYPE const * const yyvaluep, CISA_IR_Builder* pBuilder)
{
  FILE *yyoutput = yyo;
  YY_USE (yyoutput);
  YY_USE (pBuilder);
  if (!yyvaluep)
    return;
  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  YY_USE (yykind);
  YY_IGNORE_MAYBE_UNINITIALIZED_END
}


/*---------------------------.
| Print this symbol on YYO.  |
`---------------------------*/

static void
yy_symbol_print (FILE *yyo,
                 yysymbol_kind_t yykind, YYSTYPE const * const yyvaluep, CISA_IR_Builder* pBuilder)
{
  YYFPRINTF (yyo, "%s %s (",
             yykind < YYNTOKENS ? "token" : "nterm", yysymbol_name (yykind));

  yy_symbol_value_print (yyo, yykind, yyvaluep, pBuilder);
  YYFPRINTF (yyo, ")");
}

/*------------------------------------------------------------------.
| yy_stack_print -- Print the state stack from its BOTTOM up to its |
| TOP (included).                                                   |
`------------------------------------------------------------------*/

static void
yy_stack_print (yy_state_t *yybottom, yy_state_t *yytop)
{
  YYFPRINTF (stderr, "Stack now");
  for (; yybottom <= yytop; yybottom++)
    {
      int yybot = *yybottom;
      YYFPRINTF (stderr, " %d", yybot);
    }
  YYFPRINTF (stderr, "\n");
}

# define YY_STACK_PRINT(Bottom, Top)                            \
do {                                                            \
  if (yydebug)                                                  \
    yy_stack_print ((Bottom), (Top));                           \
} while (0)


/*------------------------------------------------.
| Report that the YYRULE is going to be reduced.  |
`------------------------------------------------*/

static void
yy_reduce_print (yy_state_t *yyssp, YYSTYPE *yyvsp,
                 int yyrule, CISA_IR_Builder* pBuilder)
{
  int yylno = yyrline[yyrule];
  int yynrhs = yyr2[yyrule];
  int yyi;
  YYFPRINTF (stderr, "Reducing stack by rule %d (line %d):\n",
             yyrule - 1, yylno);
  /* The symbols being reduced.  */
  for (yyi = 0; yyi < yynrhs; yyi++)
    {
      YYFPRINTF (stderr, "   $%d = ", yyi + 1);
      yy_symbol_print (stderr,
                       YY_ACCESSING_SYMBOL (+yyssp[yyi + 1 - yynrhs]),
                       &yyvsp[(yyi + 1) - (yynrhs)], pBuilder);
      YYFPRINTF (stderr, "\n");
    }
}

# define YY_REDUCE_PRINT(Rule)          \
do {                                    \
  if (yydebug)                          \
    yy_reduce_print (yyssp, yyvsp, Rule, pBuilder); \
} while (0)

/* Nonzero means print parse trace.  It is left uninitialized so that
   multiple parsers can coexist.  */
int yydebug;
#else /* !YYDEBUG */
# define YYDPRINTF(Args) ((void) 0)
# define YY_SYMBOL_PRINT(Title, Kind, Value, Location)
# define YY_STACK_PRINT(Bottom, Top)
# define YY_REDUCE_PRINT(Rule)
#endif /* !YYDEBUG */


/* YYINITDEPTH -- initial size of the parser's stacks.  */
#ifndef YYINITDEPTH
# define YYINITDEPTH 200
#endif

/* YYMAXDEPTH -- maximum size the stacks can grow to (effective only
   if the built-in stack extension method is used).

   Do not make this value too large; the results are undefined if
   YYSTACK_ALLOC_MAXIMUM < YYSTACK_BYTES (YYMAXDEPTH)
   evaluated with infinite-precision integer arithmetic.  */

#ifndef YYMAXDEPTH
# define YYMAXDEPTH 10000
#endif


/* Context of a parse error.  */
typedef struct
{
  yy_state_t *yyssp;
  yysymbol_kind_t yytoken;
} yypcontext_t;

/* Put in YYARG at most YYARGN of the expected tokens given the
   current YYCTX, and return the number of tokens stored in YYARG.  If
   YYARG is null, return the number of expected tokens (guaranteed to
   be less than YYNTOKENS).  Return YYENOMEM on memory exhaustion.
   Return 0 if there are more than YYARGN expected tokens, yet fill
   YYARG up to YYARGN. */
static int
yypcontext_expected_tokens (const yypcontext_t *yyctx,
                            yysymbol_kind_t yyarg[], int yyargn)
{
  /* Actual size of YYARG. */
  int yycount = 0;
  int yyn = yypact[+*yyctx->yyssp];
  if (!yypact_value_is_default (yyn))
    {
      /* Start YYX at -YYN if negative to avoid negative indexes in
         YYCHECK.  In other words, skip the first -YYN actions for
         this state because they are default actions.  */
      int yyxbegin = yyn < 0 ? -yyn : 0;
      /* Stay within bounds of both yycheck and yytname.  */
      int yychecklim = YYLAST - yyn + 1;
      int yyxend = yychecklim < YYNTOKENS ? yychecklim : YYNTOKENS;
      int yyx;
      for (yyx = yyxbegin; yyx < yyxend; ++yyx)
        if (yycheck[yyx + yyn] == yyx && yyx != YYSYMBOL_YYerror
            && !yytable_value_is_error (yytable[yyx + yyn]))
          {
            if (!yyarg)
              ++yycount;
            else if (yycount == yyargn)
              return 0;
            else
              yyarg[yycount++] = YY_CAST (yysymbol_kind_t, yyx);
          }
    }
  if (yyarg && yycount == 0 && 0 < yyargn)
    yyarg[0] = YYSYMBOL_YYEMPTY;
  return yycount;
}




#ifndef yystrlen
# if defined __GLIBC__ && defined _STRING_H
#  define yystrlen(S) (YY_CAST (YYPTRDIFF_T, strlen (S)))
# else
/* Return the length of YYSTR.  */
static YYPTRDIFF_T
yystrlen (const char *yystr)
{
  YYPTRDIFF_T yylen;
  for (yylen = 0; yystr[yylen]; yylen++)
    continue;
  return yylen;
}
# endif
#endif

#ifndef yystpcpy
# if defined __GLIBC__ && defined _STRING_H && defined _GNU_SOURCE
#  define yystpcpy stpcpy
# else
/* Copy YYSRC to YYDEST, returning the address of the terminating '\0' in
   YYDEST.  */
static char *
yystpcpy (char *yydest, const char *yysrc)
{
  char *yyd = yydest;
  const char *yys = yysrc;

  while ((*yyd++ = *yys++) != '\0')
    continue;

  return yyd - 1;
}
# endif
#endif

#ifndef yytnamerr
/* Copy to YYRES the contents of YYSTR after stripping away unnecessary
   quotes and backslashes, so that it's suitable for yyerror.  The
   heuristic is that double-quoting is unnecessary unless the string
   contains an apostrophe, a comma, or backslash (other than
   backslash-backslash).  YYSTR is taken from yytname.  If YYRES is
   null, do not copy; instead, return the length of what the result
   would have been.  */
static YYPTRDIFF_T
yytnamerr (char *yyres, const char *yystr)
{
  if (*yystr == '"')
    {
      YYPTRDIFF_T yyn = 0;
      char const *yyp = yystr;
      for (;;)
        switch (*++yyp)
          {
          case '\'':
          case ',':
            goto do_not_strip_quotes;

          case '\\':
            if (*++yyp != '\\')
              goto do_not_strip_quotes;
            else
              goto append;

          append:
          default:
            if (yyres)
              yyres[yyn] = *yyp;
            yyn++;
            break;

          case '"':
            if (yyres)
              yyres[yyn] = '\0';
            return yyn;
          }
    do_not_strip_quotes: ;
    }

  if (yyres)
    return yystpcpy (yyres, yystr) - yyres;
  else
    return yystrlen (yystr);
}
#endif


static int
yy_syntax_error_arguments (const yypcontext_t *yyctx,
                           yysymbol_kind_t yyarg[], int yyargn)
{
  /* Actual size of YYARG. */
  int yycount = 0;
  /* There are many possibilities here to consider:
     - If this state is a consistent state with a default action, then
       the only way this function was invoked is if the default action
       is an error action.  In that case, don't check for expected
       tokens because there are none.
     - The only way there can be no lookahead present (in yychar) is if
       this state is a consistent state with a default action.  Thus,
       detecting the absence of a lookahead is sufficient to determine
       that there is no unexpected or expected token to report.  In that
       case, just report a simple "syntax error".
     - Don't assume there isn't a lookahead just because this state is a
       consistent state with a default action.  There might have been a
       previous inconsistent state, consistent state with a non-default
       action, or user semantic action that manipulated yychar.
     - Of course, the expected token list depends on states to have
       correct lookahead information, and it depends on the parser not
       to perform extra reductions after fetching a lookahead from the
       scanner and before detecting a syntax error.  Thus, state merging
       (from LALR or IELR) and default reductions corrupt the expected
       token list.  However, the list is correct for canonical LR with
       one exception: it will still contain any token that will not be
       accepted due to an error action in a later state.
  */
  if (yyctx->yytoken != YYSYMBOL_YYEMPTY)
    {
      int yyn;
      if (yyarg)
        yyarg[yycount] = yyctx->yytoken;
      ++yycount;
      yyn = yypcontext_expected_tokens (yyctx,
                                        yyarg ? yyarg + 1 : yyarg, yyargn - 1);
      if (yyn == YYENOMEM)
        return YYENOMEM;
      else
        yycount += yyn;
    }
  return yycount;
}

/* Copy into *YYMSG, which is of size *YYMSG_ALLOC, an error message
   about the unexpected token YYTOKEN for the state stack whose top is
   YYSSP.

   Return 0 if *YYMSG was successfully written.  Return -1 if *YYMSG is
   not large enough to hold the message.  In that case, also set
   *YYMSG_ALLOC to the required number of bytes.  Return YYENOMEM if the
   required number of bytes is too large to store.  */
static int
yysyntax_error (YYPTRDIFF_T *yymsg_alloc, char **yymsg,
                const yypcontext_t *yyctx)
{
  enum { YYARGS_MAX = 5 };
  /* Internationalized format string. */
  const char *yyformat = YY_NULLPTR;
  /* Arguments of yyformat: reported tokens (one for the "unexpected",
     one per "expected"). */
  yysymbol_kind_t yyarg[YYARGS_MAX];
  /* Cumulated lengths of YYARG.  */
  YYPTRDIFF_T yysize = 0;

  /* Actual size of YYARG. */
  int yycount = yy_syntax_error_arguments (yyctx, yyarg, YYARGS_MAX);
  if (yycount == YYENOMEM)
    return YYENOMEM;

  switch (yycount)
    {
#define YYCASE_(N, S)                       \
      case N:                               \
        yyformat = S;                       \
        break
    default: /* Avoid compiler warnings. */
      YYCASE_(0, YY_("syntax error"));
      YYCASE_(1, YY_("syntax error, unexpected %s"));
      YYCASE_(2, YY_("syntax error, unexpected %s, expecting %s"));
      YYCASE_(3, YY_("syntax error, unexpected %s, expecting %s or %s"));
      YYCASE_(4, YY_("syntax error, unexpected %s, expecting %s or %s or %s"));
      YYCASE_(5, YY_("syntax error, unexpected %s, expecting %s or %s or %s or %s"));
#undef YYCASE_
    }

  /* Compute error message size.  Don't count the "%s"s, but reserve
     room for the terminator.  */
  yysize = yystrlen (yyformat) - 2 * yycount + 1;
  {
    int yyi;
    for (yyi = 0; yyi < yycount; ++yyi)
      {
        YYPTRDIFF_T yysize1
          = yysize + yytnamerr (YY_NULLPTR, yytname[yyarg[yyi]]);
        if (yysize <= yysize1 && yysize1 <= YYSTACK_ALLOC_MAXIMUM)
          yysize = yysize1;
        else
          return YYENOMEM;
      }
  }

  if (*yymsg_alloc < yysize)
    {
      *yymsg_alloc = 2 * yysize;
      if (! (yysize <= *yymsg_alloc
             && *yymsg_alloc <= YYSTACK_ALLOC_MAXIMUM))
        *yymsg_alloc = YYSTACK_ALLOC_MAXIMUM;
      return -1;
    }

  /* Avoid sprintf, as that infringes on the user's name space.
     Don't have undefined behavior even if the translation
     produced a string with the wrong number of "%s"s.  */
  {
    char *yyp = *yymsg;
    int yyi = 0;
    while ((*yyp = *yyformat) != '\0')
      if (*yyp == '%' && yyformat[1] == 's' && yyi < yycount)
        {
          yyp += yytnamerr (yyp, yytname[yyarg[yyi++]]);
          yyformat += 2;
        }
      else
        {
          ++yyp;
          ++yyformat;
        }
  }
  return 0;
}


/*-----------------------------------------------.
| Release the memory associated to this symbol.  |
`-----------------------------------------------*/

static void
yydestruct (const char *yymsg,
            yysymbol_kind_t yykind, YYSTYPE *yyvaluep, CISA_IR_Builder* pBuilder)
{
  YY_USE (yyvaluep);
  YY_USE (pBuilder);
  if (!yymsg)
    yymsg = "Deleting";
  YY_SYMBOL_PRINT (yymsg, yykind, yyvaluep, yylocationp);

  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  YY_USE (yykind);
  YY_IGNORE_MAYBE_UNINITIALIZED_END
}


/* Lookahead token kind.  */
int yychar;

/* The semantic value of the lookahead symbol.  */
YYSTYPE yylval;
/* Number of syntax errors so far.  */
int yynerrs;




/*----------.
| yyparse.  |
`----------*/

int
yyparse (CISA_IR_Builder* pBuilder)
{
    yy_state_fast_t yystate = 0;
    /* Number of tokens to shift before error messages enabled.  */
    int yyerrstatus = 0;

    /* Refer to the stacks through separate pointers, to allow yyoverflow
       to reallocate them elsewhere.  */

    /* Their size.  */
    YYPTRDIFF_T yystacksize = YYINITDEPTH;

    /* The state stack: array, bottom, top.  */
    yy_state_t yyssa[YYINITDEPTH];
    yy_state_t *yyss = yyssa;
    yy_state_t *yyssp = yyss;

    /* The semantic value stack: array, bottom, top.  */
    YYSTYPE yyvsa[YYINITDEPTH];
    YYSTYPE *yyvs = yyvsa;
    YYSTYPE *yyvsp = yyvs;

  int yyn;
  /* The return value of yyparse.  */
  int yyresult;
  /* Lookahead symbol kind.  */
  yysymbol_kind_t yytoken = YYSYMBOL_YYEMPTY;
  /* The variables used to return semantic value and location from the
     action routines.  */
  YYSTYPE yyval;

  /* Buffer for error messages, and its allocated size.  */
  char yymsgbuf[128];
  char *yymsg = yymsgbuf;
  YYPTRDIFF_T yymsg_alloc = sizeof yymsgbuf;

#define YYPOPSTACK(N)   (yyvsp -= (N), yyssp -= (N))

  /* The number of symbols on the RHS of the reduced rule.
     Keep to zero when no symbol should be popped.  */
  int yylen = 0;

  YYDPRINTF ((stderr, "Starting parse\n"));

  yychar = YYEMPTY; /* Cause a token to be read.  */

  goto yysetstate;


/*------------------------------------------------------------.
| yynewstate -- push a new state, which is found in yystate.  |
`------------------------------------------------------------*/
yynewstate:
  /* In all cases, when you get here, the value and location stacks
     have just been pushed.  So pushing a state here evens the stacks.  */
  yyssp++;


/*--------------------------------------------------------------------.
| yysetstate -- set current state (the top of the stack) to yystate.  |
`--------------------------------------------------------------------*/
yysetstate:
  YYDPRINTF ((stderr, "Entering state %d\n", yystate));
  YY_ASSERT (0 <= yystate && yystate < YYNSTATES);
  YY_IGNORE_USELESS_CAST_BEGIN
  *yyssp = YY_CAST (yy_state_t, yystate);
  YY_IGNORE_USELESS_CAST_END
  YY_STACK_PRINT (yyss, yyssp);

  if (yyss + yystacksize - 1 <= yyssp)
#if !defined yyoverflow && !defined YYSTACK_RELOCATE
    YYNOMEM;
#else
    {
      /* Get the current used size of the three stacks, in elements.  */
      YYPTRDIFF_T yysize = yyssp - yyss + 1;

# if defined yyoverflow
      {
        /* Give user a chance to reallocate the stack.  Use copies of
           these so that the &'s don't force the real ones into
           memory.  */
        yy_state_t *yyss1 = yyss;
        YYSTYPE *yyvs1 = yyvs;

        /* Each stack pointer address is followed by the size of the
           data in use in that stack, in bytes.  This used to be a
           conditional around just the two extra args, but that might
           be undefined if yyoverflow is a macro.  */
        yyoverflow (YY_("memory exhausted"),
                    &yyss1, yysize * YYSIZEOF (*yyssp),
                    &yyvs1, yysize * YYSIZEOF (*yyvsp),
                    &yystacksize);
        yyss = yyss1;
        yyvs = yyvs1;
      }
# else /* defined YYSTACK_RELOCATE */
      /* Extend the stack our own way.  */
      if (YYMAXDEPTH <= yystacksize)
        YYNOMEM;
      yystacksize *= 2;
      if (YYMAXDEPTH < yystacksize)
        yystacksize = YYMAXDEPTH;

      {
        yy_state_t *yyss1 = yyss;
        union yyalloc *yyptr =
          YY_CAST (union yyalloc *,
                   YYSTACK_ALLOC (YY_CAST (YYSIZE_T, YYSTACK_BYTES (yystacksize))));
        if (! yyptr)
          YYNOMEM;
        YYSTACK_RELOCATE (yyss_alloc, yyss);
        YYSTACK_RELOCATE (yyvs_alloc, yyvs);
#  undef YYSTACK_RELOCATE
        if (yyss1 != yyssa)
          YYSTACK_FREE (yyss1);
      }
# endif

      yyssp = yyss + yysize - 1;
      yyvsp = yyvs + yysize - 1;

      YY_IGNORE_USELESS_CAST_BEGIN
      YYDPRINTF ((stderr, "Stack size increased to %ld\n",
                  YY_CAST (long, yystacksize)));
      YY_IGNORE_USELESS_CAST_END

      if (yyss + yystacksize - 1 <= yyssp)
        YYABORT;
    }
#endif /* !defined yyoverflow && !defined YYSTACK_RELOCATE */


  if (yystate == YYFINAL)
    YYACCEPT;

  goto yybackup;


/*-----------.
| yybackup.  |
`-----------*/
yybackup:
  /* Do appropriate processing given the current state.  Read a
     lookahead token if we need one and don't already have one.  */

  /* First try to decide what to do without reference to lookahead token.  */
  yyn = yypact[yystate];
  if (yypact_value_is_default (yyn))
    goto yydefault;

  /* Not known => get a lookahead token if don't already have one.  */

  /* YYCHAR is either empty, or end-of-input, or a valid lookahead.  */
  if (yychar == YYEMPTY)
    {
      YYDPRINTF ((stderr, "Reading a token\n"));
      yychar = yylex (pBuilder);
    }

  if (yychar <= YYEOF)
    {
      yychar = YYEOF;
      yytoken = YYSYMBOL_YYEOF;
      YYDPRINTF ((stderr, "Now at end of input.\n"));
    }
  else if (yychar == YYerror)
    {
      /* The scanner already issued an error message, process directly
         to error recovery.  But do not keep the error token as
         lookahead, it is too special and may lead us to an endless
         loop in error recovery. */
      yychar = YYUNDEF;
      yytoken = YYSYMBOL_YYerror;
      goto yyerrlab1;
    }
  else
    {
      yytoken = YYTRANSLATE (yychar);
      YY_SYMBOL_PRINT ("Next token is", yytoken, &yylval, &yylloc);
    }

  /* If the proper action on seeing token YYTOKEN is to reduce or to
     detect an error, take that action.  */
  yyn += yytoken;
  if (yyn < 0 || YYLAST < yyn || yycheck[yyn] != yytoken)
    goto yydefault;
  yyn = yytable[yyn];
  if (yyn <= 0)
    {
      if (yytable_value_is_error (yyn))
        goto yyerrlab;
      yyn = -yyn;
      goto yyreduce;
    }

  /* Count tokens shifted since error; after three, turn off error
     status.  */
  if (yyerrstatus)
    yyerrstatus--;

  /* Shift the lookahead token.  */
  YY_SYMBOL_PRINT ("Shifting", yytoken, &yylval, &yylloc);
  yystate = yyn;
  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  *++yyvsp = yylval;
  YY_IGNORE_MAYBE_UNINITIALIZED_END

  /* Discard the shifted token.  */
  yychar = YYEMPTY;
  goto yynewstate;


/*-----------------------------------------------------------.
| yydefault -- do the default action for the current state.  |
`-----------------------------------------------------------*/
yydefault:
  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;
  goto yyreduce;


/*-----------------------------.
| yyreduce -- do a reduction.  |
`-----------------------------*/
yyreduce:
  /* yyn is the number of a rule to reduce with.  */
  yylen = yyr2[yyn];

  /* If YYLEN is nonzero, implement the default value of the action:
     '$$ = $1'.

     Otherwise, the following line sets YYVAL to garbage.
     This behavior is undocumented and Bison
     users should not rely upon it.  Assigning to YYVAL
     unconditionally makes the parser a bit smaller, and it avoids a
     GCC warning that YYVAL may be used uninitialized.  */
  yyval = yyvsp[1-yylen];


  YY_REDUCE_PRINT (yyn);
  switch (yyn)
    {
  case 2: /* Listing: NewlinesOpt ListingHeader NewlinesOpt Statements NewlinesOpt  */
#line 709 "CISA.y"
                                                                      {
        TRACE("** Listing Complete\n");
        pBuilder->CISA_post_file_parse();
    }
#line 3326 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 23: /* Scope: ScopeStart error  */
#line 739 "CISA.y"
                       {
        PARSE_ERROR_AT((int)(yyvsp[-1].intval), "unclosed scope");
    }
#line 3334 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 24: /* ScopeStart: LBRACE  */
#line 743 "CISA.y"
           {
        pBuilder->CISA_push_decl_scope();
        (yyval.intval) = CISAlineno;
    }
#line 3343 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 25: /* ScopeEnd: RBRACE  */
#line 747 "CISA.y"
                 {pBuilder->CISA_pop_decl_scope();}
#line 3349 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 28: /* DirectiveKernel: DIRECTIVE_KERNEL IdentOrStringLit  */
#line 758 "CISA.y"
    {
        VISAKernel *cisa_kernel = NULL;
        pBuilder->AddKernel(cisa_kernel, (yyvsp[0].string));
    }
#line 3358 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 29: /* DirectiveGlobalFunction: DIRECTIVE_GLOBAL_FUNC IdentOrStringLit  */
#line 766 "CISA.y"
  {
      VISAFunction *cisa_kernel = NULL;
      pBuilder->AddFunction(cisa_kernel, (yyvsp[0].string));
  }
#line 3367 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 30: /* DirectiveVersion: DIRECTIVE_VERSION DEC_LIT DOT DEC_LIT  */
#line 774 "CISA.y"
   {
       pBuilder->CISA_IR_setVersion((unsigned char)(yyvsp[-2].intval), (unsigned char)(yyvsp[0].intval));
   }
#line 3375 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 37: /* DeclFunction: DIRECTIVE_FUNCDECL STRING_LIT  */
#line 788 "CISA.y"
    {
        // do nothing as it's informational only
    }
#line 3383 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 38: /* DeclVariable: DIRECTIVE_DECL IDENT V_TYPE_EQ_G DECL_DATA_TYPE NUM_ELTS_EQ IntExp AlignAttrOpt AliasAttrOpt GenAttrOpt  */
#line 795 "CISA.y"
    {
       ABORT_ON_FAIL(pBuilder->CISA_general_variable_decl(
           (yyvsp[-7].string), (unsigned int)(yyvsp[-3].intval), (yyvsp[-5].type), (yyvsp[-2].align), (yyvsp[-1].alias).aliasname, (yyvsp[-1].alias).offset, AttrOptVar, CISAlineno));
       AttrOptVar.clear();
    }
#line 3393 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 39: /* DeclAddress: DIRECTIVE_DECL IDENT V_TYPE_EQ_A NUM_ELTS_EQ IntExp GenAttrOpt  */
#line 803 "CISA.y"
   {
       ABORT_ON_FAIL(
           pBuilder->CISA_addr_variable_decl((yyvsp[-4].string), (unsigned int)(yyvsp[-1].intval), ISA_TYPE_UW, AttrOptVar, CISAlineno));
       AttrOptVar.clear();
   }
#line 3403 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 40: /* DeclPredicate: DIRECTIVE_DECL IDENT V_TYPE_EQ_P NUM_ELTS_EQ IntExp GenAttrOpt  */
#line 811 "CISA.y"
   {
       ABORT_ON_FAIL(pBuilder->CISA_predicate_variable_decl((yyvsp[-4].string), (unsigned int)(yyvsp[-1].intval), AttrOptVar, CISAlineno));
       AttrOptVar.clear();
   }
#line 3412 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 41: /* DeclSampler: DIRECTIVE_DECL IDENT V_TYPE_EQ_S NUM_ELTS_EQ IntExp VNameEqOpt GenAttrOpt  */
#line 818 "CISA.y"
   {
       ABORT_ON_FAIL(pBuilder->CISA_sampler_variable_decl((yyvsp[-5].string), (int)(yyvsp[-2].intval), (yyvsp[-1].string), CISAlineno));
   }
#line 3420 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 42: /* VNameEqOpt: %empty  */
#line 821 "CISA.y"
                    {(yyval.string) = "";}
#line 3426 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 43: /* VNameEqOpt: V_NAME_EQ IDENT  */
#line 821 "CISA.y"
                                                 {(yyval.string) = (yyvsp[0].string);}
#line 3432 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 44: /* DeclSurface: DIRECTIVE_DECL IDENT V_TYPE_EQ_T NUM_ELTS_EQ IntExp VNameEqOpt GenAttrOpt  */
#line 825 "CISA.y"
   {
       ABORT_ON_FAIL(pBuilder->CISA_surface_variable_decl((yyvsp[-5].string), (int)(yyvsp[-2].intval), (yyvsp[-1].string), AttrOptVar, CISAlineno));
       AttrOptVar.clear();
   }
#line 3441 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 45: /* DirectiveInput: DIRECTIVE_INPUT IDENT InputOffset InputSize  */
#line 833 "CISA.y"
    {
        ABORT_ON_FAIL(pBuilder->CISA_input_directive((yyvsp[-2].string), (short)(yyvsp[-1].intval), (unsigned short)(yyvsp[0].intval), CISAlineno));
    }
#line 3449 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 46: /* DirectiveInput: DIRECTIVE_INPUT IDENT InputOffset  */
#line 838 "CISA.y"
    {
        int64_t size = 0;
        ABORT_ON_FAIL(pBuilder->CISA_eval_sizeof_decl(CISAlineno, (yyvsp[-1].string), size));
        MUST_HOLD(size < 0x10000, "declaration size is too large");
        ABORT_ON_FAIL(pBuilder->CISA_input_directive((yyvsp[-1].string), (short)(yyvsp[0].intval), (unsigned short)size, CISAlineno));
    }
#line 3460 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 47: /* DirectiveImplicitInput: DIRECTIVE_IMPLICIT IDENT InputOffset InputSize GenAttrOpt  */
#line 850 "CISA.y"
    {
        ABORT_ON_FAIL(pBuilder->CISA_implicit_input_directive(
            (yyvsp[-4].string), (yyvsp[-3].string), (short)(yyvsp[-2].intval), (unsigned short)(yyvsp[-1].intval), CISAlineno));
    }
#line 3469 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 48: /* DirectiveImplicitInput: DIRECTIVE_IMPLICIT IDENT InputOffset GenAttrOpt  */
#line 857 "CISA.y"
    {
        int64_t size = 0;
        ABORT_ON_FAIL(pBuilder->CISA_eval_sizeof_decl(CISAlineno, (yyvsp[-2].string), size));
        MUST_HOLD(size < 0x10000, "declaration size is too large");
        ABORT_ON_FAIL(pBuilder->CISA_input_directive((yyvsp[-2].string), (short)(yyvsp[-1].intval), (unsigned short)size, CISAlineno));
    }
#line 3480 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 49: /* InputOffset: %empty  */
#line 864 "CISA.y"
                    {(yyval.intval) = 0;}
#line 3486 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 50: /* InputOffset: OFFSET_EQ IntExp  */
#line 864 "CISA.y"
                                                 {(yyval.intval) = (yyvsp[0].intval);}
#line 3492 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 51: /* InputSize: SIZE_EQ IntExp  */
#line 865 "CISA.y"
                          {(yyval.intval) = (yyvsp[0].intval);}
#line 3498 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 52: /* DirectiveAttr: DIRECTIVE_KERNEL_ATTR IDENT EQUALS STRING_LIT  */
#line 871 "CISA.y"
                                                  {
        ABORT_ON_FAIL(pBuilder->CISA_attr_directive((yyvsp[-2].string), (yyvsp[0].string), CISAlineno));
    }
#line 3506 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 53: /* DirectiveAttr: DIRECTIVE_KERNEL_ATTR IDENT EQUALS IntExp  */
#line 875 "CISA.y"
                                              {
        ABORT_ON_FAIL(pBuilder->CISA_attr_directiveNum((yyvsp[-2].string), (uint32_t)(yyvsp[0].intval), CISAlineno));
    }
#line 3514 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 54: /* DirectiveAttr: DIRECTIVE_KERNEL_ATTR IDENT  */
#line 879 "CISA.y"
                                {
        ABORT_ON_FAIL(pBuilder->CISA_attr_directive((yyvsp[0].string), nullptr, CISAlineno));
    }
#line 3522 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 55: /* DirectiveAttr: DIRECTIVE_KERNEL_ATTR IDENT EQUALS  */
#line 883 "CISA.y"
                                       {
        ABORT_ON_FAIL(pBuilder->CISA_attr_directive((yyvsp[-1].string), nullptr, CISAlineno));
    }
#line 3530 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 56: /* DirectiveFunc: DIRECTIVE_FUNC IdentOrStringLit  */
#line 889 "CISA.y"
    {
        ABORT_ON_FAIL(pBuilder->CISA_function_directive((yyvsp[0].string), CISAlineno));
    }
#line 3538 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 57: /* AlignAttrOpt: %empty  */
#line 894 "CISA.y"
                     {(yyval.align) = ALIGN_BYTE;}
#line 3544 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 59: /* Align: ALIGN_EQ ALIGN_KEYWORD  */
#line 896 "CISA.y"
                           { // 2GRF, 32word, ...
        (yyval.align) = (yyvsp[0].align);
    }
#line 3552 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 60: /* Align: ALIGN_EQ IDENT  */
#line 900 "CISA.y"
                   { // e.g. byte, word, dword, qword, GRF, GRFx2
       if (!ParseAlign(pBuilder, (yyvsp[0].string), (yyval.align))) {
           PARSE_ERROR((yyvsp[0].string), ": invalid align value");
       }
    }
#line 3562 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 61: /* Align: ALIGN_EQ IntExp  */
#line 906 "CISA.y"
                    {
        // e.g. %sizeof(GRF) or %sizeof(DECL)
        if (!AlignBytesToVisaAlignment((int)(yyvsp[0].intval), (yyval.align))) {
            PARSE_ERROR("invalid align size (must be 1, 2, 4, 8, ..., 128)");
        }
    }
#line 3573 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 62: /* Align: ALIGN_EQ error  */
#line 913 "CISA.y"
                   {
        PARSE_ERROR("syntax error in align attribute");
    }
#line 3581 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 63: /* AliasAttrOpt: %empty  */
#line 920 "CISA.y"
    {
       (yyval.alias).aliasname = NULL;
       (yyval.alias).offset = 0;
    }
#line 3590 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 64: /* AliasAttrOpt: ALIAS_EQ LANGLE Var COMMA IntExpNRA RANGLE  */
#line 925 "CISA.y"
    {
       (yyval.alias).aliasname = (yyvsp[-3].string);
       (yyval.alias).offset = (int)(yyvsp[-1].intval);
    }
#line 3599 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 65: /* AliasAttrOpt: ALIAS_EQ LANGLE error  */
#line 930 "CISA.y"
    {
       PARSE_ERROR("syntax error in alias attribute");
    }
#line 3607 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 66: /* OneAttr: IDENT EQUALS IntExpNRA  */
#line 936 "CISA.y"
    {
      (yyval.pattr_gen) = pBuilder->CISA_Create_Attr((yyvsp[-2].string), (yyvsp[0].intval), nullptr);
    }
#line 3615 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 67: /* OneAttr: IDENT EQUALS STRING_LIT  */
#line 940 "CISA.y"
    {
      (yyval.pattr_gen) = pBuilder->CISA_Create_Attr((yyvsp[-2].string), 0, (yyvsp[0].string));
    }
#line 3623 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 68: /* OneAttr: IDENT  */
#line 944 "CISA.y"
    {
      (yyval.pattr_gen) = pBuilder->CISA_Create_Attr((yyvsp[0].string), 0, nullptr);
    }
#line 3631 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 69: /* AttrOpt: AttrOpt COMMA OneAttr  */
#line 950 "CISA.y"
    {
      AttrOptVar.push_back((yyvsp[0].pattr_gen));
    }
#line 3639 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 70: /* AttrOpt: OneAttr  */
#line 955 "CISA.y"
    {
      AttrOptVar.push_back((yyvsp[0].pattr_gen));
    }
#line 3647 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 71: /* GenAttrOpt: %empty  */
#line 961 "CISA.y"
    {
        (yyval.intval) = 0;
    }
#line 3655 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 72: /* GenAttrOpt: ATTR_EQ LBRACE AttrOpt RBRACE  */
#line 965 "CISA.y"
    {
        (yyval.intval) = 1;
    }
#line 3663 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 130: /* Label: LABEL  */
#line 1032 "CISA.y"
             {pBuilder->CISA_create_label((yyvsp[0].string), CISAlineno);}
#line 3669 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 131: /* LogicInstruction: Predicate BINARY_LOGIC_OP SatModOpt ExecSize VecDstOperand_G_I VecSrcOperand_G_I_IMM VecSrcOperand_G_I_IMM  */
#line 1037 "CISA.y"
    {
        pBuilder->CISA_create_logic_instruction((yyvsp[-6].pred_reg), (yyvsp[-5].opcode), (yyvsp[-4].sat), (yyvsp[-3].emask_exec_size).emask, (yyvsp[-3].emask_exec_size).exec_size,
            (yyvsp[-2].genOperand).cisa_gen_opnd, (yyvsp[-1].genOperand).cisa_gen_opnd, (yyvsp[0].genOperand).cisa_gen_opnd, NULL, NULL, CISAlineno);
    }
#line 3678 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 132: /* LogicInstruction: Predicate BINARY_LOGIC_OP SatModOpt ExecSize PredVar PredVar PredVar  */
#line 1043 "CISA.y"
    {
        pBuilder->CISA_create_logic_instruction((yyvsp[-5].opcode), (yyvsp[-3].emask_exec_size).emask, (yyvsp[-3].emask_exec_size).exec_size, (yyvsp[-2].vISADecl), (yyvsp[-1].vISADecl), (yyvsp[0].vISADecl), CISAlineno);
    }
#line 3686 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 133: /* LogicInstruction: Predicate TERNARY_LOGIC_OP SatModOpt ExecSize VecDstOperand_G_I VecSrcOperand_G_I_IMM VecSrcOperand_G_I_IMM VecSrcOperand_G_I_IMM  */
#line 1048 "CISA.y"
    {
        pBuilder->CISA_create_logic_instruction((yyvsp[-7].pred_reg), (yyvsp[-6].opcode), (yyvsp[-5].sat), (yyvsp[-4].emask_exec_size).emask, (yyvsp[-4].emask_exec_size).exec_size,
            (yyvsp[-3].genOperand).cisa_gen_opnd, (yyvsp[-2].genOperand).cisa_gen_opnd, (yyvsp[-1].genOperand).cisa_gen_opnd, (yyvsp[0].genOperand).cisa_gen_opnd, NULL, CISAlineno);
    }
#line 3695 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 134: /* LogicInstruction: Predicate QUATERNARY_LOGIC_OP SatModOpt ExecSize VecDstOperand_G_I VecSrcOperand_G_I_IMM VecSrcOperand_G_I_IMM VecSrcOperand_G_I_IMM VecSrcOperand_G_I_IMM  */
#line 1054 "CISA.y"
    {
        pBuilder->CISA_create_logic_instruction((yyvsp[-8].pred_reg), (yyvsp[-7].opcode), (yyvsp[-6].sat), (yyvsp[-5].emask_exec_size).emask, (yyvsp[-5].emask_exec_size).exec_size,
            (yyvsp[-4].genOperand).cisa_gen_opnd, (yyvsp[-3].genOperand).cisa_gen_opnd, (yyvsp[-2].genOperand).cisa_gen_opnd, (yyvsp[-1].genOperand).cisa_gen_opnd, (yyvsp[0].genOperand).cisa_gen_opnd, CISAlineno);
    }
#line 3704 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 135: /* UnaryLogicInstruction: Predicate UNARY_LOGIC_OP SatModOpt ExecSize VecDstOperand_G_I VecSrcOperand_G_I_IMM  */
#line 1061 "CISA.y"
    {
        pBuilder->CISA_create_logic_instruction((yyvsp[-5].pred_reg), (yyvsp[-4].opcode), (yyvsp[-3].sat), (yyvsp[-2].emask_exec_size).emask, (yyvsp[-2].emask_exec_size).exec_size,
            (yyvsp[-1].genOperand).cisa_gen_opnd, (yyvsp[0].genOperand).cisa_gen_opnd, NULL, NULL, NULL, CISAlineno);
    }
#line 3713 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 136: /* UnaryLogicInstruction: Predicate UNARY_LOGIC_OP SatModOpt ExecSize PredVar PredVar  */
#line 1067 "CISA.y"
    {
        pBuilder->CISA_create_logic_instruction((yyvsp[-4].opcode), (yyvsp[-2].emask_exec_size).emask, (yyvsp[-2].emask_exec_size).exec_size,
            (yyvsp[-1].vISADecl), (yyvsp[0].vISADecl), NULL, CISAlineno);
    }
#line 3722 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 137: /* MathInstruction_2OPND: Predicate MATH2_OP SatModOpt ExecSize VecDstOperand_G_I VecSrcOperand_G_I_IMM  */
#line 1074 "CISA.y"
    {
        pBuilder->CISA_create_math_instruction((yyvsp[-5].pred_reg), (yyvsp[-4].opcode), (yyvsp[-3].sat), (yyvsp[-2].emask_exec_size).emask, (yyvsp[-2].emask_exec_size).exec_size,
            (yyvsp[-1].genOperand).cisa_gen_opnd, (yyvsp[0].genOperand).cisa_gen_opnd, NULL, CISAlineno);
    }
#line 3731 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 138: /* MathInstruction_3OPND: Predicate MATH3_OP SatModOpt ExecSize VecDstOperand_G_I VecSrcOperand_G_I_IMM VecSrcOperand_G_I_IMM  */
#line 1081 "CISA.y"
    {
        pBuilder->CISA_create_math_instruction((yyvsp[-6].pred_reg), (yyvsp[-5].opcode), (yyvsp[-4].sat), (yyvsp[-3].emask_exec_size).emask, (yyvsp[-3].emask_exec_size).exec_size,
            (yyvsp[-2].genOperand).cisa_gen_opnd, (yyvsp[-1].genOperand).cisa_gen_opnd, (yyvsp[0].genOperand).cisa_gen_opnd, CISAlineno);
    }
#line 3740 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 139: /* ArithInstruction_2OPND: Predicate ARITH2_OP SatModOpt ExecSize VecDstOperand_G_I VecSrcOperand_G_I_IMM  */
#line 1088 "CISA.y"
    {
        pBuilder->CISA_create_arith_instruction((yyvsp[-5].pred_reg), (yyvsp[-4].opcode), (yyvsp[-3].sat), (yyvsp[-2].emask_exec_size).emask, (yyvsp[-2].emask_exec_size).exec_size,
            (yyvsp[-1].genOperand).cisa_gen_opnd, (yyvsp[0].genOperand).cisa_gen_opnd, NULL, NULL, CISAlineno);
    }
#line 3749 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 140: /* ArithInstruction_3OPND: Predicate ARITH3_OP SatModOpt ExecSize VecDstOperand_G_I VecSrcOperand_G_I_IMM VecSrcOperand_G_I_IMM  */
#line 1095 "CISA.y"
    {
        MUST_HOLD(!(((yyvsp[-5].opcode) == ISA_LINE) && ((yyvsp[-1].genOperand).type == OPERAND_IMMEDIATE || (yyvsp[-1].genOperand).type == OPERAND_INDIRECT)),
            "wrong type of src0 operand");
        pBuilder->CISA_create_arith_instruction(
            (yyvsp[-6].pred_reg), (yyvsp[-5].opcode), (yyvsp[-4].sat), (yyvsp[-3].emask_exec_size).emask, (yyvsp[-3].emask_exec_size).exec_size,
            (yyvsp[-2].genOperand).cisa_gen_opnd, (yyvsp[-1].genOperand).cisa_gen_opnd, (yyvsp[0].genOperand).cisa_gen_opnd, NULL, CISAlineno);
    }
#line 3761 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 141: /* ArithInstruction_3OPND: Predicate ARITH5_OP2 ExecSize VecDstOperand_G_I PredVar VecSrcOperand_G_I_IMM  */
#line 1105 "CISA.y"
    {
        pBuilder->CISA_create_arith_instruction2_predDst((yyvsp[-5].pred_reg), (yyvsp[-4].opcode), (yyvsp[-3].emask_exec_size).emask, (yyvsp[-3].emask_exec_size).exec_size,
            (yyvsp[-2].genOperand).cisa_gen_opnd, (yyvsp[-1].vISADecl), (yyvsp[0].genOperand).cisa_gen_opnd, nullptr, CISAlineno);
    }
#line 3770 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 142: /* ArithInstruction_4OPND: Predicate ARITH4_OP SatModOpt ExecSize VecDstOperand_G_I VecSrcOperand_G_I_IMM VecSrcOperand_G_I_IMM VecSrcOperand_G_I_IMM  */
#line 1114 "CISA.y"
     {
         pBuilder->CISA_create_arith_instruction((yyvsp[-7].pred_reg), (yyvsp[-6].opcode), (yyvsp[-5].sat), (yyvsp[-4].emask_exec_size).emask, (yyvsp[-4].emask_exec_size).exec_size,
            (yyvsp[-3].genOperand).cisa_gen_opnd, (yyvsp[-2].genOperand).cisa_gen_opnd, (yyvsp[-1].genOperand).cisa_gen_opnd, (yyvsp[0].genOperand).cisa_gen_opnd, CISAlineno);
     }
#line 3779 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 143: /* ArithInstruction_4OPND: Predicate ARITH4_OP2 ExecSize VecDstOperand_G_I VecDstOperand_G_I VecSrcOperand_G_I_IMM VecSrcOperand_G_I_IMM  */
#line 1121 "CISA.y"
     {
        pBuilder->CISA_create_arith_instruction2((yyvsp[-6].pred_reg), (yyvsp[-5].opcode), (yyvsp[-4].emask_exec_size).emask, (yyvsp[-4].emask_exec_size).exec_size,
            (yyvsp[-3].genOperand).cisa_gen_opnd, (yyvsp[-2].genOperand).cisa_gen_opnd, (yyvsp[-1].genOperand).cisa_gen_opnd, (yyvsp[0].genOperand).cisa_gen_opnd, CISAlineno);
     }
#line 3788 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 144: /* ArithInstruction_4OPND: Predicate ARITH5_OP2 ExecSize VecDstOperand_G_I PredVar VecSrcOperand_G_I_IMM VecSrcOperand_G_I_IMM  */
#line 1128 "CISA.y"
     {
        pBuilder->CISA_create_arith_instruction2_predDst((yyvsp[-6].pred_reg), (yyvsp[-5].opcode), (yyvsp[-4].emask_exec_size).emask, (yyvsp[-4].emask_exec_size).exec_size,
            (yyvsp[-3].genOperand).cisa_gen_opnd, (yyvsp[-2].vISADecl), (yyvsp[-1].genOperand).cisa_gen_opnd, (yyvsp[0].genOperand).cisa_gen_opnd, CISAlineno);
     }
#line 3797 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 145: /* BdpasInstruction: BDPAS_OP ExecSize RawOperand RawOperand RawOperand RawOperand VecSrcOpndSimple VecSrcOpndSimple  */
#line 1136 "CISA.y"
    {
        MUST_HOLD((yyvsp[-6].emask_exec_size).exec_size == 16, "The execution size must be 16");
        MUST_HOLD((yyvsp[-7].dpas_info).depth == 8 && (yyvsp[-7].dpas_info).count == 8, "SD and RC of bdpas must be 8");
        pBuilder->CISA_create_bdpas_instruction(
            (yyvsp[-7].dpas_info).opcode, (yyvsp[-6].emask_exec_size).emask, (yyvsp[-6].emask_exec_size).exec_size,
            (yyvsp[-5].RawVar), (yyvsp[-4].RawVar), (yyvsp[-3].RawVar), (yyvsp[-2].RawVar), (yyvsp[-1].genOperand).cisa_gen_opnd, (yyvsp[0].genOperand).cisa_gen_opnd,
            (yyvsp[-7].dpas_info).src2Precision, (yyvsp[-7].dpas_info).src1Precision, (yyvsp[-7].dpas_info).depth, (yyvsp[-7].dpas_info).count, CISAlineno);
    }
#line 3810 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 146: /* DpasInstruction: DPAS_OP ExecSize RawOperand RawOperand RawOperand VecSrcOpndSimple  */
#line 1148 "CISA.y"
    {
        pBuilder->CISA_create_dpas_instruction(
            (yyvsp[-5].dpas_info).opcode, (yyvsp[-4].emask_exec_size).emask, (yyvsp[-4].emask_exec_size).exec_size,
            (yyvsp[-3].RawVar), (yyvsp[-2].RawVar), (yyvsp[-1].RawVar), (yyvsp[0].genOperand).cisa_gen_opnd,
            (yyvsp[-5].dpas_info).src2Precision, (yyvsp[-5].dpas_info).src1Precision, (yyvsp[-5].dpas_info).depth, (yyvsp[-5].dpas_info).count, CISAlineno);
    }
#line 3821 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 147: /* BfnInstruction: Predicate BFN_OP SatModOpt ExecSize VecDstOperand_G_I VecSrcOperand_G_I_IMM VecSrcOperand_G_I_IMM VecSrcOperand_G_I_IMM  */
#line 1158 "CISA.y"
    {
        pBuilder->CISA_create_bfn_instruction((yyvsp[-7].pred_reg), (yyvsp[-6].bfn_info).func_ctrl , (yyvsp[-5].sat), (yyvsp[-4].emask_exec_size).emask, (yyvsp[-4].emask_exec_size).exec_size,
            (yyvsp[-3].genOperand).cisa_gen_opnd, (yyvsp[-2].genOperand).cisa_gen_opnd, (yyvsp[-1].genOperand).cisa_gen_opnd, (yyvsp[0].genOperand).cisa_gen_opnd, CISAlineno);
    }
#line 3830 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 148: /* QwScatterInstruction: Predicate QW_SCATTER_OP DOT DEC_LIT ExecSize Var RawOperand RawOperand  */
#line 1164 "CISA.y"
    {
        ABORT_ON_FAIL(pBuilder->CISA_create_qword_scatter_instruction(
            (yyvsp[-6].opcode), (yyvsp[-7].pred_reg), (yyvsp[-3].emask_exec_size).emask, (yyvsp[-3].emask_exec_size).exec_size, (uint32_t)(yyvsp[-4].intval), (yyvsp[-2].string), (yyvsp[-1].RawVar), (yyvsp[0].RawVar), CISAlineno));
    }
#line 3839 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 149: /* FCvtInstruction: FCVT_OP SatModOpt ExecSize VecDstOperand_G VecSrcOperand_G_IMM  */
#line 1171 "CISA.y"
    {
        pBuilder->CISA_create_fcvt_instruction((yyvsp[-3].sat), (yyvsp[-2].emask_exec_size).emask, (yyvsp[-2].emask_exec_size).exec_size, (yyvsp[-1].genOperand).cisa_gen_opnd, (yyvsp[0].genOperand).cisa_gen_opnd, CISAlineno);
    }
#line 3847 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 150: /* AntiTrigInstruction: Predicate ANTI_TRIG_OP SatModOpt ExecSize VecDstOperand_G_I VecSrcOperand_G_I_IMM  */
#line 1177 "CISA.y"
    {
        pBuilder->CISA_create_invtri_inst((yyvsp[-5].pred_reg), (yyvsp[-4].opcode), (yyvsp[-3].sat), (yyvsp[-2].emask_exec_size).emask, (yyvsp[-2].emask_exec_size).exec_size,
            (yyvsp[-1].genOperand).cisa_gen_opnd, (yyvsp[0].genOperand).cisa_gen_opnd, CISAlineno);
    }
#line 3856 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 151: /* AddrAddInstruction: ADDR_ADD_OP ExecSize VecDstOperand_A VecSrcOperand_G_A_AO VecSrcOperand_G_IMM_AO  */
#line 1186 "CISA.y"
    {
        // a grammatically problematic instruction
        //   addr_add (M1_NM, 1) A0(0)<1> &V127 - 0x10...
        //                                        ^^^^ next operand or V127 offset
        pBuilder->CISA_create_address_instruction((yyvsp[-4].opcode), (yyvsp[-3].emask_exec_size).emask, (yyvsp[-3].emask_exec_size).exec_size,
            (yyvsp[-2].genOperand).cisa_gen_opnd, (yyvsp[-1].genOperand).cisa_gen_opnd, (yyvsp[0].genOperand).cisa_gen_opnd, CISAlineno);
    }
#line 3868 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 152: /* SetpInstruction: SETP_OP ExecSize PredVar VecSrcOperand_G_I_IMM  */
#line 1196 "CISA.y"
    {
        pBuilder->CISA_create_setp_instruction(
            (yyvsp[-3].opcode), (yyvsp[-2].emask_exec_size).emask, (yyvsp[-2].emask_exec_size).exec_size, (yyvsp[-1].vISADecl), (yyvsp[0].genOperand).cisa_gen_opnd, CISAlineno);
    }
#line 3877 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 153: /* SelInstruction: Predicate SEL_OP SatModOpt ExecSize VecDstOperand_G_I VecSrcOperand_G_I_IMM VecSrcOperand_G_I_IMM  */
#line 1203 "CISA.y"
    {
        pBuilder->CISA_create_sel_instruction((yyvsp[-5].opcode), (yyvsp[-4].sat), (yyvsp[-6].pred_reg), (yyvsp[-3].emask_exec_size).emask, (yyvsp[-3].emask_exec_size).exec_size,
            (yyvsp[-2].genOperand).cisa_gen_opnd, (yyvsp[-1].genOperand).cisa_gen_opnd, (yyvsp[0].genOperand).cisa_gen_opnd, CISAlineno);
    }
#line 3886 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 154: /* MinInstruction: Predicate MIN_OP SatModOpt ExecSize VecDstOperand_G_I VecSrcOperand_G_I_IMM VecSrcOperand_G_I_IMM  */
#line 1210 "CISA.y"
    {
        pBuilder->CISA_create_fminmax_instruction(0, ISA_FMINMAX, (yyvsp[-4].sat), (yyvsp[-6].pred_reg), (yyvsp[-3].emask_exec_size).emask, (yyvsp[-3].emask_exec_size).exec_size,
            (yyvsp[-2].genOperand).cisa_gen_opnd, (yyvsp[-1].genOperand).cisa_gen_opnd, (yyvsp[0].genOperand).cisa_gen_opnd, CISAlineno);
    }
#line 3895 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 155: /* MaxInstruction: Predicate MAX_OP SatModOpt ExecSize VecDstOperand_G_I VecSrcOperand_G_I_IMM VecSrcOperand_G_I_IMM  */
#line 1218 "CISA.y"
    {
        pBuilder->CISA_create_fminmax_instruction(
            1, ISA_FMINMAX, (yyvsp[-4].sat), (yyvsp[-6].pred_reg), (yyvsp[-3].emask_exec_size).emask, (yyvsp[-3].emask_exec_size).exec_size,
            (yyvsp[-2].genOperand).cisa_gen_opnd, (yyvsp[-1].genOperand).cisa_gen_opnd, (yyvsp[0].genOperand).cisa_gen_opnd, CISAlineno);
    }
#line 3905 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 156: /* MovInstruction: Predicate MOV_OP SatModOpt ExecSize VecDstOperand_G_I VecSrcOperand_G_I_IMM_A_AO  */
#line 1227 "CISA.y"
    {
        ABORT_ON_FAIL(pBuilder->CISA_create_mov_instruction(
            (yyvsp[-5].pred_reg), (yyvsp[-4].opcode), (yyvsp[-2].emask_exec_size).emask, (yyvsp[-2].emask_exec_size).exec_size, (yyvsp[-3].sat),
            (yyvsp[-1].genOperand).cisa_gen_opnd, (yyvsp[0].genOperand).cisa_gen_opnd, CISAlineno));
    }
#line 3915 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 157: /* MovInstruction: Predicate MOV_OP SatModOpt ExecSize VecDstOperand_A VecSrcOperand_G_I_IMM_A_AO  */
#line 1234 "CISA.y"
    {
        pBuilder->CISA_create_mov_instruction(
            (yyvsp[-5].pred_reg), (yyvsp[-4].opcode), (yyvsp[-2].emask_exec_size).emask, (yyvsp[-2].emask_exec_size).exec_size, (yyvsp[-3].sat),
            (yyvsp[-1].genOperand).cisa_gen_opnd, (yyvsp[0].genOperand).cisa_gen_opnd, CISAlineno);
    }
#line 3925 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 158: /* MovInstruction: Predicate MOV_OP SatModOpt ExecSize VecDstOperand_G_I PredVar  */
#line 1241 "CISA.y"
    {
        ABORT_ON_FAIL(pBuilder->CISA_create_mov_instruction((yyvsp[-1].genOperand).cisa_gen_opnd, (yyvsp[0].vISADecl), CISAlineno));
    }
#line 3933 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 159: /* BreakpointInstruction: BREAKPOINT_OP  */
#line 1247 "CISA.y"
    {
      pBuilder->CISA_create_breakpoint_instruction(CISAlineno);
    }
#line 3941 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 160: /* MovsInstruction: MOVS_OP ExecSize DstStateOperand SrcStateOperand  */
#line 1253 "CISA.y"
    {
        pBuilder->CISA_create_movs_instruction((yyvsp[-2].emask_exec_size).emask, ISA_MOVS, (yyvsp[-2].emask_exec_size).exec_size,
            (yyvsp[-1].StateVar).cisa_gen_opnd, (yyvsp[0].StateVar).cisa_gen_opnd, CISAlineno);
    }
#line 3950 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 161: /* MovsInstruction: MOVS_OP ExecSize VecDstOperand_G SrcStateOperand  */
#line 1259 "CISA.y"
    {
        pBuilder->CISA_create_movs_instruction((yyvsp[-2].emask_exec_size).emask, ISA_MOVS, (yyvsp[-2].emask_exec_size).exec_size,
            (yyvsp[-1].genOperand).cisa_gen_opnd, (yyvsp[0].StateVar).cisa_gen_opnd, CISAlineno);
    }
#line 3959 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 162: /* MovsInstruction: MOVS_OP ExecSize DstStateOperand VecSrcOperand_G_I_IMM  */
#line 1265 "CISA.y"
    {
        pBuilder->CISA_create_movs_instruction((yyvsp[-2].emask_exec_size).emask, ISA_MOVS, (yyvsp[-2].emask_exec_size).exec_size,
            (yyvsp[-1].StateVar).cisa_gen_opnd, (yyvsp[0].genOperand).cisa_gen_opnd, CISAlineno);
    }
#line 3968 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 163: /* CmpInstruction: CMP_OP ConditionalModifier ExecSize PredVar VecSrcOperand_G_I_IMM VecSrcOperand_G_I_IMM  */
#line 1283 "CISA.y"
    {
        pBuilder->CISA_create_cmp_instruction((yyvsp[-4].cond_mod), (yyvsp[-3].emask_exec_size).emask, (yyvsp[-3].emask_exec_size).exec_size,
            (yyvsp[-2].vISADecl), (yyvsp[-1].genOperand).cisa_gen_opnd, (yyvsp[0].genOperand).cisa_gen_opnd, CISAlineno);
    }
#line 3977 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 164: /* CmpInstruction: CMP_OP ConditionalModifier ExecSize VecDstOperand_G_I VecSrcOperand_G_I_IMM VecSrcOperand_G_I_IMM  */
#line 1290 "CISA.y"
    {
        // NOTE: predication not permitted.  Apparently the vISA API doesn't allow for predicated compares
        pBuilder->CISA_create_cmp_instruction(
            (yyvsp[-4].cond_mod), ISA_CMP, (yyvsp[-3].emask_exec_size).emask, (yyvsp[-3].emask_exec_size).exec_size,
            (yyvsp[-2].genOperand).cisa_gen_opnd, (yyvsp[-1].genOperand).cisa_gen_opnd, (yyvsp[0].genOperand).cisa_gen_opnd, CISAlineno);
    }
#line 3988 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 165: /* MediaInstruction: MEDIA_OP MEDIA_MODE TwoDimOffset Var MediaInstructionPlaneID VecSrcOperand_G_I_IMM VecSrcOperand_G_I_IMM RawOperand  */
#line 1300 "CISA.y"
    {
        ABORT_ON_FAIL(pBuilder->CISA_create_media_instruction(
            (yyvsp[-7].opcode), (yyvsp[-6].media_mode), (yyvsp[-5].offset).row, (yyvsp[-5].offset).elem, (int)(yyvsp[-3].intval), (yyvsp[-4].string),
            (yyvsp[-2].genOperand).cisa_gen_opnd, (yyvsp[-1].genOperand).cisa_gen_opnd, (yyvsp[0].RawVar), CISAlineno));
    }
#line 3998 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 166: /* MediaInstruction: MEDIA_OP MEDIA_MODE TwoDimOffset Var VecSrcOperand_G_I_IMM VecSrcOperand_G_I_IMM RawOperand  */
#line 1308 "CISA.y"
    {
        ABORT_ON_FAIL(pBuilder->CISA_create_media_instruction(
            (yyvsp[-6].opcode), (yyvsp[-5].media_mode), (yyvsp[-4].offset).row, (yyvsp[-4].offset).elem, (int)0, (yyvsp[-3].string),
            (yyvsp[-2].genOperand).cisa_gen_opnd, (yyvsp[-1].genOperand).cisa_gen_opnd, (yyvsp[0].RawVar), CISAlineno));
    }
#line 4008 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 167: /* MediaInstructionPlaneID: DEC_LIT  */
#line 1314 "CISA.y"
                                 {
        MUST_HOLD((yyvsp[0].intval) <= 0xF, "PlaneID must less than 0xF");
        (yyval.intval) = (yyvsp[0].intval);
    }
#line 4017 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 168: /* ScatterInstruction: SCATTER_OP ElemNum ExecSize OwordModifier Var VecSrcOperand_G_I_IMM RawOperand RawOperand  */
#line 1322 "CISA.y"
    {
        ABORT_ON_FAIL(pBuilder->CISA_create_scatter_instruction(
            (yyvsp[-7].opcode), (int)(yyvsp[-6].intval), (yyvsp[-5].emask_exec_size).emask, (yyvsp[-5].emask_exec_size).exec_size, (yyvsp[-4].oword_mod), (yyvsp[-3].string),
            (yyvsp[-2].genOperand).cisa_gen_opnd, (yyvsp[-1].RawVar), (yyvsp[0].RawVar), CISAlineno));
    }
#line 4027 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 169: /* ScatterTypedInstruction: Predicate SCATTER_TYPED_OP SAMPLER_CHANNEL ExecSize Var RawOperand RawOperand RawOperand RawOperand RawOperand  */
#line 1331 "CISA.y"
    {
        ABORT_ON_FAIL(pBuilder->CISA_create_scatter4_typed_instruction(
            (yyvsp[-8].opcode), (yyvsp[-9].pred_reg), ChannelMask::createFromAPI((yyvsp[-7].s_channel)), (yyvsp[-6].emask_exec_size).emask, (yyvsp[-6].emask_exec_size).exec_size, (yyvsp[-5].string),
            (yyvsp[-4].RawVar), (yyvsp[-3].RawVar), (yyvsp[-2].RawVar), (yyvsp[-1].RawVar), (yyvsp[0].RawVar), CISAlineno));
    }
#line 4037 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 170: /* Scatter4ScaledInstruction: Predicate SCATTER4_SCALED_OP SAMPLER_CHANNEL ExecSize Var VecSrcOperand_G_I_IMM RawOperand RawOperand  */
#line 1340 "CISA.y"
    {
        ABORT_ON_FAIL(pBuilder->CISA_create_scatter4_scaled_instruction(
            (yyvsp[-6].opcode), (yyvsp[-7].pred_reg), (yyvsp[-4].emask_exec_size).emask, (yyvsp[-4].emask_exec_size).exec_size, ChannelMask::createFromAPI((yyvsp[-5].s_channel)), (yyvsp[-3].string),
            (yyvsp[-2].genOperand).cisa_gen_opnd, (yyvsp[-1].RawVar), (yyvsp[0].RawVar), CISAlineno));
    }
#line 4047 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 171: /* ScatterScaledInstruction: Predicate SCATTER_SCALED_OP DOT DEC_LIT ExecSize Var VecSrcOperand_G_I_IMM RawOperand RawOperand  */
#line 1349 "CISA.y"
    {
        ABORT_ON_FAIL(pBuilder->CISA_create_scatter_scaled_instruction(
            (yyvsp[-7].opcode), (yyvsp[-8].pred_reg), (yyvsp[-4].emask_exec_size).emask, (yyvsp[-4].emask_exec_size).exec_size, (uint32_t) (yyvsp[-5].intval), (yyvsp[-3].string),
            (yyvsp[-2].genOperand).cisa_gen_opnd, (yyvsp[-1].RawVar), (yyvsp[0].RawVar), CISAlineno));
    }
#line 4057 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 172: /* SynchronizationInstruction: BARRIER_OP  */
#line 1356 "CISA.y"
               {
        pBuilder->CISA_create_sync_instruction((yyvsp[0].opcode), CISAlineno);
    }
#line 4065 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 173: /* SynchronizationInstruction: SBARRIER_SIGNAL  */
#line 1359 "CISA.y"
                      {
        pBuilder->CISA_create_sbarrier_instruction(true, CISAlineno);
    }
#line 4073 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 174: /* SynchronizationInstruction: SBARRIER_WAIT  */
#line 1362 "CISA.y"
                    {
        pBuilder->CISA_create_sbarrier_instruction(false, CISAlineno);
    }
#line 4081 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 175: /* SynchronizationInstruction: NBARRIER_SIGNAL VecSrcOperand_G_I_IMM VecSrcOperand_G_I_IMM VecSrcOperand_G_I_IMM VecSrcOperand_G_I_IMM  */
#line 1365 "CISA.y"
                                                                                                              {
        pBuilder->CISA_create_nbarrier_signal((yyvsp[-3].genOperand).cisa_gen_opnd, (yyvsp[-2].genOperand).cisa_gen_opnd, (yyvsp[-1].genOperand).cisa_gen_opnd, (yyvsp[0].genOperand).cisa_gen_opnd, CISAlineno);
    }
#line 4089 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 176: /* SynchronizationInstruction: NBARRIER_SIGNAL VecSrcOperand_G_I_IMM VecSrcOperand_G_I_IMM  */
#line 1368 "CISA.y"
                                                                  {
        pBuilder->CISA_create_nbarrier(false, (yyvsp[-1].genOperand).cisa_gen_opnd, (yyvsp[0].genOperand).cisa_gen_opnd, CISAlineno);
    }
#line 4097 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 177: /* SynchronizationInstruction: NBARRIER_WAIT VecSrcOperand_G_I_IMM  */
#line 1371 "CISA.y"
                                          {
        pBuilder->CISA_create_nbarrier(true, (yyvsp[0].genOperand).cisa_gen_opnd, NULL, CISAlineno);
    }
#line 4105 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 178: /* DwordAtomicInstruction: Predicate DWORD_ATOMIC_OP ATOMIC_SUB_OP Atomic16Opt ExecSize Var RawOperand RawOperand RawOperand RawOperand  */
#line 1377 "CISA.y"
    {
        ABORT_ON_FAIL(pBuilder->CISA_create_dword_atomic_instruction(
            (yyvsp[-9].pred_reg), (yyvsp[-7].atomic_op), (yyvsp[-6].flag), (yyvsp[-5].emask_exec_size).emask, (yyvsp[-5].emask_exec_size).exec_size, (yyvsp[-4].string), (yyvsp[-3].RawVar), (yyvsp[-2].RawVar), (yyvsp[-1].RawVar), (yyvsp[0].RawVar), CISAlineno));
    }
#line 4114 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 179: /* TypedAtomicInstruction: Predicate TYPED_ATOMIC_OP ATOMIC_SUB_OP Atomic16Opt ExecSize Var RawOperand RawOperand RawOperand RawOperand RawOperand RawOperand RawOperand  */
#line 1384 "CISA.y"
    {
        ABORT_ON_FAIL(pBuilder->CISA_create_typed_atomic_instruction(
            (yyvsp[-12].pred_reg), (yyvsp[-10].atomic_op), (yyvsp[-9].flag), (yyvsp[-8].emask_exec_size).emask, (yyvsp[-8].emask_exec_size).exec_size, (yyvsp[-7].string),
            (yyvsp[-6].RawVar), (yyvsp[-5].RawVar), (yyvsp[-4].RawVar), (yyvsp[-3].RawVar), (yyvsp[-2].RawVar), (yyvsp[-1].RawVar), (yyvsp[0].RawVar), CISAlineno));
    }
#line 4124 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 180: /* Atomic16Opt: %empty  */
#line 1391 "CISA.y"
             {(yyval.flag) = false;}
#line 4130 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 181: /* Atomic16Opt: DOT DEC_LIT  */
#line 1392 "CISA.y"
                  { // .16
        MUST_HOLD(((yyvsp[0].intval) == 16), "only supports 16");
        (yyval.flag) = true;
    }
#line 4139 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 182: /* SampleUnormInstruction: SAMPLE_UNORM_OP SAMPLER_CHANNEL CHANNEL_OUTPUT Var Var VecSrcOperand_G_I_IMM VecSrcOperand_G_I_IMM VecSrcOperand_G_I_IMM VecSrcOperand_G_I_IMM RawOperand  */
#line 1399 "CISA.y"
    {
        ABORT_ON_FAIL(pBuilder->CISA_create_sampleunorm_instruction(
            (yyvsp[-9].opcode), ChannelMask::createFromAPI((yyvsp[-8].s_channel)), (yyvsp[-7].s_channel_output), (yyvsp[-6].string), (yyvsp[-5].string),
            (yyvsp[-4].genOperand).cisa_gen_opnd, (yyvsp[-3].genOperand).cisa_gen_opnd, (yyvsp[-2].genOperand).cisa_gen_opnd, (yyvsp[-1].genOperand).cisa_gen_opnd, (yyvsp[0].RawVar), CISAlineno));
    }
#line 4149 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 183: /* SampleInstruction: SAMPLE_OP SAMPLER_CHANNEL SIMDMode Var Var RawOperand RawOperand RawOperand RawOperand  */
#line 1412 "CISA.y"
    {
        ABORT_ON_FAIL(pBuilder->CISA_create_sample_instruction(
            (yyvsp[-8].opcode), ChannelMask::createFromAPI((yyvsp[-7].s_channel)), (int)(yyvsp[-6].intval), (yyvsp[-5].string), (yyvsp[-4].string),
            (yyvsp[-3].RawVar), (yyvsp[-2].RawVar), (yyvsp[-1].RawVar), (yyvsp[0].RawVar), CISAlineno));
    }
#line 4159 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 184: /* SampleInstruction: SAMPLE_OP SAMPLER_CHANNEL SIMDMode Var RawOperand RawOperand RawOperand RawOperand  */
#line 1420 "CISA.y"
   {
       ABORT_ON_FAIL(pBuilder->CISA_create_sample_instruction(
           (yyvsp[-7].opcode), ChannelMask::createFromAPI((yyvsp[-6].s_channel)), (int)(yyvsp[-5].intval), "", (yyvsp[-4].string),
           (yyvsp[-3].RawVar), (yyvsp[-2].RawVar), (yyvsp[-1].RawVar), (yyvsp[0].RawVar), CISAlineno));
   }
#line 4169 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 185: /* SamplerAddrOperand: Var  */
#line 1427 "CISA.y"
                     {
                      (yyval.sampler_base) = {(yyvsp[0].string), (unsigned int)0};
                     }
#line 4177 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 186: /* SamplerAddrOperand: LPAREN Var COMMA IntExpPrim RPAREN  */
#line 1432 "CISA.y"
                     {
                      (yyval.sampler_base) = {(yyvsp[-3].string), (unsigned int)(yyvsp[-1].intval)};
                     }
#line 4185 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 187: /* Sample3dInstruction: Predicate SAMPLE_3D_OP PixelNullMaskEnableOpt CPSEnableOpt NonUniformSamplerEnableOpt SAMPLER_CHANNEL ExecSize VecSrcOperand_G_I_IMM SamplerAddrOperand SamplerAddrOperand RawOperand RawOperand RawOperandArray  */
#line 1443 "CISA.y"
   {
       const bool success = pBuilder->create3DSampleInstruction(
           (yyvsp[-12].pred_reg), (yyvsp[-11].sample3DOp), (yyvsp[-10].pixel_null_mask), (yyvsp[-9].cps), (yyvsp[-8].non_uniform_sampler), ChannelMask::createFromAPI((yyvsp[-7].s_channel)),
           (yyvsp[-6].emask_exec_size).emask, (yyvsp[-6].emask_exec_size).exec_size, (yyvsp[-5].genOperand).cisa_gen_opnd, (yyvsp[-4].sampler_base).base, (yyvsp[-4].sampler_base).offset,
           (yyvsp[-3].sampler_base).base, (yyvsp[-3].sampler_base).offset,
           (yyvsp[-1].RawVar), (yyvsp[-2].RawVar), (unsigned int)(yyvsp[0].intval), rawOperandArray, CISAlineno);

    ABORT_ON_FAIL(success);
   }
#line 4199 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 188: /* CPSEnableOpt: %empty  */
#line 1453 "CISA.y"
                     {(yyval.cps) = false;}
#line 4205 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 189: /* CPSEnableOpt: CPS  */
#line 1453 "CISA.y"
                                          {(yyval.cps) = true;}
#line 4211 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 190: /* NonUniformSamplerEnableOpt: %empty  */
#line 1455 "CISA.y"
                                   {(yyval.non_uniform_sampler) = false;}
#line 4217 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 191: /* NonUniformSamplerEnableOpt: NON_UNIFORM_SAMPLER  */
#line 1455 "CISA.y"
                                                                       {(yyval.non_uniform_sampler) = true;}
#line 4223 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 192: /* Load3dInstruction: Predicate LOAD_3D_OP PixelNullMaskEnableOpt SAMPLER_CHANNEL ExecSize VecSrcOperand_G_I_IMM SamplerAddrOperand RawOperand RawOperand RawOperandArray  */
#line 1465 "CISA.y"
   {
       const bool success = pBuilder->create3DLoadInstruction(
           (yyvsp[-9].pred_reg), (yyvsp[-8].sample3DOp), (yyvsp[-7].pixel_null_mask), ChannelMask::createFromAPI((yyvsp[-6].s_channel)),
           (yyvsp[-5].emask_exec_size).emask, (yyvsp[-5].emask_exec_size).exec_size, (yyvsp[-4].genOperand).cisa_gen_opnd, (yyvsp[-3].sampler_base).base, (yyvsp[-3].sampler_base).offset,
           (yyvsp[-1].RawVar), (yyvsp[-2].RawVar), (unsigned int)(yyvsp[0].intval), rawOperandArray, CISAlineno);

    ABORT_ON_FAIL(success);
   }
#line 4236 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 193: /* Gather43dInstruction: Predicate SAMPLE4_3D_OP PixelNullMaskEnableOpt SAMPLER_CHANNEL ExecSize VecSrcOperand_G_I_IMM SamplerAddrOperand SamplerAddrOperand RawOperand RawOperand RawOperandArray  */
#line 1482 "CISA.y"
   {
       const bool success = pBuilder->createSample4Instruction(
          (yyvsp[-10].pred_reg), (yyvsp[-9].sample3DOp), (yyvsp[-8].pixel_null_mask), ChannelMask::createFromAPI((yyvsp[-7].s_channel)), (yyvsp[-6].emask_exec_size).emask, (yyvsp[-6].emask_exec_size).exec_size,
          (yyvsp[-5].genOperand).cisa_gen_opnd, (yyvsp[-4].sampler_base).base, (yyvsp[-4].sampler_base).offset, (yyvsp[-3].sampler_base).base, (yyvsp[-3].sampler_base).offset,
           (yyvsp[-1].RawVar), (yyvsp[-2].RawVar),
          (unsigned int)(yyvsp[0].intval), rawOperandArray, CISAlineno);

    ABORT_ON_FAIL(success);
   }
#line 4250 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 194: /* PixelNullMaskEnableOpt: %empty  */
#line 1493 "CISA.y"
                               {(yyval.pixel_null_mask) = false;}
#line 4256 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 195: /* PixelNullMaskEnableOpt: PIXEL_NULL_MASK  */
#line 1493 "CISA.y"
                                                               {(yyval.pixel_null_mask) = true;}
#line 4262 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 196: /* ResInfo3dInstruction: RESINFO_OP_3D SAMPLER_CHANNEL ExecSize SamplerAddrOperand RawOperand RawOperand  */
#line 1497 "CISA.y"
   {
        ABORT_ON_FAIL(pBuilder->CISA_create_info_3d_instruction(
            VISA_3D_RESINFO, (yyvsp[-3].emask_exec_size).emask, (yyvsp[-3].emask_exec_size).exec_size,
            ChannelMask::createFromAPI((yyvsp[-4].s_channel)), (yyvsp[-2].sampler_base).base, (yyvsp[-2].sampler_base).offset, (yyvsp[-1].RawVar), (yyvsp[0].RawVar), CISAlineno));
   }
#line 4272 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 197: /* SampleInfo3dInstruction: SAMPLEINFO_OP_3D SAMPLER_CHANNEL ExecSize SamplerAddrOperand RawOperand  */
#line 1505 "CISA.y"
   {
        ABORT_ON_FAIL(pBuilder->CISA_create_info_3d_instruction(
            VISA_3D_SAMPLEINFO, (yyvsp[-2].emask_exec_size).emask, (yyvsp[-2].emask_exec_size).exec_size,
            ChannelMask::createFromAPI((yyvsp[-3].s_channel)), (yyvsp[-1].sampler_base).base, (yyvsp[-1].sampler_base).offset, NULL, (yyvsp[0].RawVar), CISAlineno));
   }
#line 4282 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 198: /* RTWriteOperands: %empty  */
#line 1513 "CISA.y"
    {
    }
#line 4289 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 199: /* RTWriteOperands: RTWriteOperands VecSrcOperand_G_IMM  */
#line 1516 "CISA.y"
    {
        RTRWOperandsVec.push_back((yyvsp[0].genOperand).cisa_gen_opnd);
    }
#line 4297 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 200: /* RTWriteOperands: RTWriteOperands RawOperand  */
#line 1520 "CISA.y"
    {
        RTRWOperandsVec.push_back((yyvsp[0].RawVar));
    }
#line 4305 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 201: /* RTWriteInstruction: Predicate RTWRITE_OP_3D RTWriteModeOpt ExecSize Var RTWriteOperands  */
#line 1528 "CISA.y"
   {
       bool result = pBuilder->CISA_create_rtwrite_3d_instruction(
           (yyvsp[-5].pred_reg), (yyvsp[-3].string), (yyvsp[-2].emask_exec_size).emask, (unsigned int)(yyvsp[-2].emask_exec_size).exec_size, (yyvsp[-1].string),
           RTRWOperandsVec, CISAlineno);
       RTRWOperandsVec.clear();
       if (!result)
           YYABORT; // already reported
   }
#line 4318 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 202: /* RTWriteModeOpt: %empty  */
#line 1538 "CISA.y"
                       {(yyval.string) = 0;}
#line 4324 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 204: /* URBWriteInstruction: Predicate URBWRITE_OP_3D ExecSize DEC_LIT DEC_LIT RawOperand RawOperand RawOperand RawOperand  */
#line 1543 "CISA.y"
    {
        pBuilder->CISA_create_urb_write_3d_instruction(
            (yyvsp[-8].pred_reg), (yyvsp[-6].emask_exec_size).emask, (unsigned int)(yyvsp[-6].emask_exec_size).exec_size, (unsigned int)(yyvsp[-5].intval), (unsigned int)(yyvsp[-4].intval),
            (yyvsp[-3].RawVar), (yyvsp[-2].RawVar), (yyvsp[-1].RawVar), (yyvsp[0].RawVar), CISAlineno);
    }
#line 4334 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 205: /* AVSInstruction: AVS_OP SAMPLER_CHANNEL Var Var VecSrcOperand_G_I_IMM VecSrcOperand_G_I_IMM VecSrcOperand_G_I_IMM VecSrcOperand_G_I_IMM VecSrcOperand_G_I_IMM VecSrcOperand_G_I_IMM VecSrcOperand_G_I_IMM CNTRL VecSrcOperand_G_I_IMM EXECMODE VecSrcOperand_G_I_IMM RawOperand  */
#line 1551 "CISA.y"
    {
        pBuilder->CISA_create_avs_instruction(
            ChannelMask::createFromAPI((yyvsp[-14].s_channel)), (yyvsp[-13].string), (yyvsp[-12].string),
            (yyvsp[-11].genOperand).cisa_gen_opnd, (yyvsp[-10].genOperand).cisa_gen_opnd, (yyvsp[-9].genOperand).cisa_gen_opnd, (yyvsp[-8].genOperand).cisa_gen_opnd,
            (yyvsp[-7].genOperand).cisa_gen_opnd, (yyvsp[-6].genOperand).cisa_gen_opnd, (yyvsp[-5].genOperand).cisa_gen_opnd, (yyvsp[-4].cntrl), (yyvsp[-3].genOperand).cisa_gen_opnd,
            (yyvsp[-2].execMode), (yyvsp[-1].genOperand).cisa_gen_opnd, (yyvsp[0].RawVar), CISAlineno);
    }
#line 4346 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 206: /* VMEInstruction: VME_IME_OP VMEOpndIME Var RawOperand RawOperand RawOperand RawOperand RawOperand RawOperand  */
#line 1563 "CISA.y"
   {
       //     1 - OP
       //     2 - StreamMode, SearchCtrl
       //     3 - Surface
       //     4 - UNIInput
       //     5 - IMEInput
       //     6 - ref0
       //     7 - ref1
       //     8 - CostCenter
       //     9 - Output
        ABORT_ON_FAIL(pBuilder->CISA_create_vme_ime_instruction(
            (yyvsp[-8].opcode), (yyvsp[-7].vmeOpndIvb).streamMode, (yyvsp[-7].vmeOpndIvb).searchCtrl, (yyvsp[-5].RawVar), (yyvsp[-4].RawVar), (yyvsp[-6].string), (yyvsp[-3].RawVar), (yyvsp[-2].RawVar), (yyvsp[-1].RawVar), (yyvsp[0].RawVar), CISAlineno));
   }
#line 4364 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 207: /* VMEInstruction: VME_SIC_OP Var RawOperand RawOperand RawOperand  */
#line 1579 "CISA.y"
   {
        ABORT_ON_FAIL(pBuilder->CISA_create_vme_sic_instruction((yyvsp[-4].opcode), (yyvsp[-2].RawVar), (yyvsp[-1].RawVar), (yyvsp[-3].string), (yyvsp[0].RawVar), CISAlineno));
   }
#line 4372 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 208: /* VMEInstruction: VME_FBR_OP VMEOpndFBR Var RawOperand RawOperand RawOperand  */
#line 1585 "CISA.y"
   {
        //    1 - OP
        //    2 - FBRMdMode, FBRSubMbShape, FBRSubPredMode
        //    3 - surface
        //    4 - UNIInput
        //    5 - FBRInput
        //    6 - output
        ABORT_ON_FAIL(pBuilder->CISA_create_vme_fbr_instruction((yyvsp[-5].opcode), (yyvsp[-2].RawVar), (yyvsp[-1].RawVar), (yyvsp[-3].string),
            (yyvsp[-4].vmeOpndFbr).cisa_fbrMbMode_opnd, (yyvsp[-4].vmeOpndFbr).cisa_fbrSubMbShape_opnd, (yyvsp[-4].vmeOpndFbr).cisa_fbrSubPredMode_opnd, (yyvsp[0].RawVar), CISAlineno));
    }
#line 4387 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 209: /* OwordInstruction: OWORD_OP OwordModifier ExecSize Var VecSrcOperand_G_I_IMM RawOperand  */
#line 1598 "CISA.y"
    {
        ABORT_ON_FAIL(
            pBuilder->CISA_create_oword_instruction((yyvsp[-5].opcode), (yyvsp[-4].oword_mod), (yyvsp[-3].emask_exec_size).exec_size, (yyvsp[-2].string), (yyvsp[-1].genOperand).cisa_gen_opnd, (yyvsp[0].RawVar), CISAlineno));
    }
#line 4396 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 210: /* SvmInstruction: SVM_OP SVM_ALIGNED ExecSize VecSrcOperand_G_I_IMM RawOperand  */
#line 1606 "CISA.y"
    {
        pBuilder->CISA_create_svm_block_instruction((SVMSubOpcode)(yyvsp[-4].opcode),
(yyvsp[-2].emask_exec_size).exec_size, false, (yyvsp[-1].genOperand).cisa_gen_opnd, (yyvsp[0].RawVar), CISAlineno);
    }
#line 4405 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 211: /* SvmInstruction: SVM_OP SVM_UNALIGNED ExecSize VecSrcOperand_G_I_IMM RawOperand  */
#line 1613 "CISA.y"
    {
        pBuilder->CISA_create_svm_block_instruction((SVMSubOpcode)(yyvsp[-4].opcode),
(yyvsp[-2].emask_exec_size).exec_size, true, (yyvsp[-1].genOperand).cisa_gen_opnd, (yyvsp[0].RawVar), CISAlineno);
    }
#line 4414 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 212: /* SvmInstruction: SVM_OP ExecSize VecSrcOperand_G_I_IMM RawOperand  */
#line 1621 "CISA.y"
    {
        pBuilder->CISA_create_svm_block_instruction((SVMSubOpcode)(yyvsp[-3].opcode),
(yyvsp[-2].emask_exec_size).exec_size, true, (yyvsp[-1].genOperand).cisa_gen_opnd, (yyvsp[0].RawVar), CISAlineno);
    }
#line 4423 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 213: /* SvmInstruction: Predicate SVM_SCATTER_OP DOT DEC_LIT DOT DEC_LIT ExecSize RawOperand RawOperand  */
#line 1627 "CISA.y"
    {
        pBuilder->CISA_create_svm_scatter_instruction((yyvsp[-8].pred_reg), (SVMSubOpcode)(yyvsp[-7].opcode), (yyvsp[-2].emask_exec_size).emask, (yyvsp[-2].emask_exec_size).exec_size,
            (unsigned int)(yyvsp[-5].intval), (unsigned int)(yyvsp[-3].intval), (yyvsp[-1].RawVar), (yyvsp[0].RawVar), CISAlineno);
    }
#line 4432 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 214: /* SvmInstruction: Predicate SVM_ATOMIC_OP ATOMIC_SUB_OP AtomicBitwidthOpt ExecSize RawOperand RawOperand RawOperand RawOperand  */
#line 1633 "CISA.y"
    {
        pBuilder->CISA_create_svm_atomic_instruction((yyvsp[-8].pred_reg), (yyvsp[-4].emask_exec_size).emask, (yyvsp[-4].emask_exec_size).exec_size, (yyvsp[-6].atomic_op), (unsigned short)(yyvsp[-5].intval),
            (yyvsp[-3].RawVar), (yyvsp[-1].RawVar), (yyvsp[0].RawVar), (yyvsp[-2].RawVar), CISAlineno);
    }
#line 4441 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 215: /* SvmInstruction: Predicate SVM_GATHER4SCALED_OP SAMPLER_CHANNEL ExecSize VecSrcOperand_G_I_IMM RawOperand RawOperand  */
#line 1639 "CISA.y"
    {
        pBuilder->CISA_create_svm_gather4_scaled((yyvsp[-6].pred_reg), (yyvsp[-3].emask_exec_size).emask, (yyvsp[-3].emask_exec_size).exec_size, ChannelMask::createFromAPI((yyvsp[-4].s_channel)),
            (yyvsp[-2].genOperand).cisa_gen_opnd, (yyvsp[-1].RawVar), (yyvsp[0].RawVar), CISAlineno);
    }
#line 4450 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 216: /* SvmInstruction: Predicate SVM_SCATTER4SCALED_OP SAMPLER_CHANNEL ExecSize VecSrcOperand_G_I_IMM RawOperand RawOperand  */
#line 1645 "CISA.y"
    {
        pBuilder->CISA_create_svm_scatter4_scaled((yyvsp[-6].pred_reg), (yyvsp[-3].emask_exec_size).emask, (yyvsp[-3].emask_exec_size).exec_size, ChannelMask::createFromAPI((yyvsp[-4].s_channel)),
            (yyvsp[-2].genOperand).cisa_gen_opnd, (yyvsp[-1].RawVar), (yyvsp[0].RawVar), CISAlineno);
    }
#line 4459 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 217: /* AtomicBitwidthOpt: %empty  */
#line 1651 "CISA.y"
             {(yyval.intval) = 32;}
#line 4465 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 218: /* AtomicBitwidthOpt: DOT DEC_LIT  */
#line 1652 "CISA.y"
                  {
        MUST_HOLD((yyvsp[0].intval) == 16 || (yyvsp[0].intval) == 32 || (yyvsp[0].intval) == 64, "only supports 16 or 64");
        (yyval.intval) = (yyvsp[0].intval);
    }
#line 4474 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 234: /* LscUntypedLoad: Predicate LSC_LOAD_MNEMONIC LSC_SFID_UNTYPED_TOKEN LscCacheOpts OVOpt ExecSize LscDataOperand LscUntypedAddrOperand  */
#line 1718 "CISA.y"
    {
        (yyvsp[-2].emask_exec_size).exec_size =
            lscCheckExecSize(pBuilder, (yyvsp[-5].lsc_sfid), (yyvsp[-6].lsc_subOpcode), (yyvsp[-1].lsc_data_operand).shape.order, (yyvsp[-2].emask_exec_size).exec_size);
        pBuilder->CISA_create_lsc_untyped_inst(
            (yyvsp[-7].pred_reg),  // predicate
            (yyvsp[-6].lsc_subOpcode),  // subop
            (yyvsp[-5].lsc_sfid),  // sfid
            (yyvsp[-4].lsc_caching_opts),  // caching settings
            (yyvsp[-3].ov),  // ov
            Get_VISA_Exec_Size_From_Raw_Size((yyvsp[-2].emask_exec_size).exec_size),
            (yyvsp[-2].emask_exec_size).emask,
            (yyvsp[0].lsc_addr_operand).addr,     // address
            (yyvsp[-1].lsc_data_operand).shape,    // data
            (yyvsp[0].lsc_addr_operand).surface,  // surface
            (yyvsp[0].lsc_addr_operand).surfaceIndex, // surface index
            (yyvsp[-1].lsc_data_operand).reg,      // dst
            (yyvsp[0].lsc_addr_operand).regs[0],  // src0
            nullptr,     // src1
            nullptr,     // src2
            CISAlineno);
    }
#line 4500 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 235: /* LscUntypedStridedLoad: Predicate LSC_LOAD_STRIDED_MNEMONIC LSC_SFID_UNTYPED_TOKEN LscCacheOpts ExecSize LscDataOperand LscUntypedStridedAddrOperand  */
#line 1751 "CISA.y"
    {
        (yyvsp[-2].emask_exec_size).exec_size =
            lscCheckExecSize(pBuilder, (yyvsp[-4].lsc_sfid), (yyvsp[-5].lsc_subOpcode), (yyvsp[-1].lsc_data_operand).shape.order, (yyvsp[-2].emask_exec_size).exec_size);
        pBuilder->CISA_create_lsc_untyped_strided_inst(
            (yyvsp[-6].pred_reg),  // predicate
            (yyvsp[-5].lsc_subOpcode),  // subop
            (yyvsp[-4].lsc_sfid),  // sfid
            (yyvsp[-3].lsc_caching_opts),  // caching settings
            Get_VISA_Exec_Size_From_Raw_Size((yyvsp[-2].emask_exec_size).exec_size),
            (yyvsp[-2].emask_exec_size).emask,
            (yyvsp[0].lsc_addr_operand).addr,     // address
            (yyvsp[-1].lsc_data_operand).shape,    // data
            (yyvsp[0].lsc_addr_operand).surface,  // surface
            (yyvsp[0].lsc_addr_operand).surfaceIndex, // surface index
            (yyvsp[-1].lsc_data_operand).reg,      // dst
            (yyvsp[0].lsc_addr_operand).regs[0],  // src0 base
            (yyvsp[0].lsc_addr_operand).regs[1],  // src0 stride
            nullptr,     // src1
            CISAlineno);
    }
#line 4525 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 236: /* LscUntypedBlock2dLoad: Predicate LSC_LOAD_BLOCK2D_MNEMONIC LSC_SFID_UNTYPED_TOKEN LscCacheOpts ExecSize LscDataOperand2D LscUntypedBlock2dAddrOperand  */
#line 1781 "CISA.y"
    {
        (yyvsp[-2].emask_exec_size).exec_size =
            lscCheckExecSize(pBuilder, (yyvsp[-4].lsc_sfid), (yyvsp[-5].lsc_subOpcode), (yyvsp[-1].lsc_data_operand2d).shape2D.order, (yyvsp[-2].emask_exec_size).exec_size);
        pBuilder->CISA_create_lsc_untyped_block2d_inst(
            (yyvsp[-6].pred_reg),  // predicate
            (yyvsp[-5].lsc_subOpcode),  // subop
            (yyvsp[-4].lsc_sfid),  // sfid
            (yyvsp[-3].lsc_caching_opts),  // caching settings
            Get_VISA_Exec_Size_From_Raw_Size((yyvsp[-2].emask_exec_size).exec_size),
            (yyvsp[-2].emask_exec_size).emask,
            (yyvsp[-1].lsc_data_operand2d).shape2D,  // data shape
            (yyvsp[-1].lsc_data_operand2d).reg,      // dst
            (yyvsp[0].lsc_block2d_addr_operand).regs,     // src0 surface info / addrs
            nullptr,     // src1
            (yyvsp[0].lsc_block2d_addr_operand).immOffsets[0],
            (yyvsp[0].lsc_block2d_addr_operand).immOffsets[1],
            CISAlineno);
    }
#line 4548 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 237: /* LscExtendedCacheCtrl: Predicate LSC_EXTENDED_CACHE_CTRL_MNEMONIC LSC_SFID_UNTYPED_TOKEN LscCacheOpts LSC_CACHE_CTRL_OPERATION_TYPE LSC_CACHE_CTRL_SIZE_TYPE ExecSize LscUntypedAddrOperand  */
#line 1808 "CISA.y"
  {
        (yyvsp[-1].emask_exec_size).exec_size =
            lscCheckExecSize(pBuilder, (yyvsp[-5].lsc_sfid), (yyvsp[-6].lsc_subOpcode), LSC_DATA_ORDER_INVALID, (yyvsp[-1].emask_exec_size).exec_size);
        pBuilder->CISA_create_lsc_extended_cache_ctrl_inst(
          (yyvsp[-7].pred_reg), // predicate
          (yyvsp[-6].lsc_subOpcode), // subop
          (yyvsp[-5].lsc_sfid), // sfid
          (yyvsp[-3].lsc_cache_ctrl_operation), // cache ctrl operation
          (yyvsp[-2].lsc_cache_ctrl_size), // cache ctrl size
          (yyvsp[-4].lsc_caching_opts), // cache ctrl opts
          Get_VISA_Exec_Size_From_Raw_Size((yyvsp[-1].emask_exec_size).exec_size),
          (yyvsp[-1].emask_exec_size).emask,
          (yyvsp[0].lsc_addr_operand).addr, // address
          (yyvsp[0].lsc_addr_operand).regs[0], // src0
          CISAlineno);
  }
#line 4569 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 238: /* LscUntypedStore: Predicate LSC_STORE_MNEMONIC LSC_SFID_UNTYPED_TOKEN LscCacheOpts ExecSize LscUntypedAddrOperand LscDataOperand  */
#line 1833 "CISA.y"
    {
        (yyvsp[-2].emask_exec_size).exec_size =
            lscCheckExecSize(pBuilder, (yyvsp[-4].lsc_sfid), (yyvsp[-5].lsc_subOpcode), (yyvsp[0].lsc_data_operand).shape.order, (yyvsp[-2].emask_exec_size).exec_size);
        pBuilder->CISA_create_lsc_untyped_inst(
            (yyvsp[-6].pred_reg),  // predicate
            (yyvsp[-5].lsc_subOpcode),  // subop
            (yyvsp[-4].lsc_sfid),  // SFID
            (yyvsp[-3].lsc_caching_opts),  // caching settings
            false,  // ov
            Get_VISA_Exec_Size_From_Raw_Size((yyvsp[-2].emask_exec_size).exec_size),
            (yyvsp[-2].emask_exec_size).emask,
            (yyvsp[-1].lsc_addr_operand).addr,     // address
            (yyvsp[0].lsc_data_operand).shape,    // data
            (yyvsp[-1].lsc_addr_operand).surface,  // surface
            (yyvsp[-1].lsc_addr_operand).surfaceIndex, // surface index
            nullptr,     // dst
            (yyvsp[-1].lsc_addr_operand).regs[0],  // src0
            (yyvsp[0].lsc_data_operand).reg,      // src1
            nullptr,     // src2
            CISAlineno);
    }
#line 4595 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 239: /* LscUntypedStridedStore: Predicate LSC_STORE_STRIDED_MNEMONIC LSC_SFID_UNTYPED_TOKEN LscCacheOpts ExecSize LscUntypedStridedAddrOperand LscDataOperand  */
#line 1860 "CISA.y"
    {
        (yyvsp[-2].emask_exec_size).exec_size =
            lscCheckExecSize(pBuilder, (yyvsp[-4].lsc_sfid), (yyvsp[-5].lsc_subOpcode), (yyvsp[0].lsc_data_operand).shape.order, (yyvsp[-2].emask_exec_size).exec_size);
        pBuilder->CISA_create_lsc_untyped_strided_inst(
            (yyvsp[-6].pred_reg),  // predicate
            (yyvsp[-5].lsc_subOpcode),  // subop
            (yyvsp[-4].lsc_sfid),  // SFID
            (yyvsp[-3].lsc_caching_opts),  // caching settings
            Get_VISA_Exec_Size_From_Raw_Size((yyvsp[-2].emask_exec_size).exec_size),
            (yyvsp[-2].emask_exec_size).emask,
            (yyvsp[-1].lsc_addr_operand).addr,     // address
            (yyvsp[0].lsc_data_operand).shape,    // data
            (yyvsp[-1].lsc_addr_operand).surface,  // surface
            (yyvsp[-1].lsc_addr_operand).surfaceIndex, // surface index
            nullptr,     // dst
            (yyvsp[-1].lsc_addr_operand).regs[0],  // src0 base
            (yyvsp[-1].lsc_addr_operand).regs[1],  // src0 stride
            (yyvsp[0].lsc_data_operand).reg,      // src1
            CISAlineno);
    }
#line 4620 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 240: /* LscUntypedBlock2dStore: Predicate LSC_STORE_BLOCK2D_MNEMONIC LSC_SFID_UNTYPED_TOKEN LscCacheOpts ExecSize LscUntypedBlock2dAddrOperand LscDataOperand2D  */
#line 1888 "CISA.y"
    {
        (yyvsp[-2].emask_exec_size).exec_size =
            lscCheckExecSize(pBuilder, (yyvsp[-4].lsc_sfid), (yyvsp[-5].lsc_subOpcode), (yyvsp[0].lsc_data_operand2d).shape2D.order, (yyvsp[-2].emask_exec_size).exec_size);
        pBuilder->CISA_create_lsc_untyped_block2d_inst(
            (yyvsp[-6].pred_reg),  // predicate
            (yyvsp[-5].lsc_subOpcode),  // subop
            (yyvsp[-4].lsc_sfid),  // sfid
            (yyvsp[-3].lsc_caching_opts),  // caching settings
            Get_VISA_Exec_Size_From_Raw_Size((yyvsp[-2].emask_exec_size).exec_size),
            (yyvsp[-2].emask_exec_size).emask,
            (yyvsp[0].lsc_data_operand2d).shape2D,  // data2d
            nullptr,     // dst
            (yyvsp[-1].lsc_block2d_addr_operand).regs,     // src0 addrs
            (yyvsp[0].lsc_data_operand2d).reg,      // src1
            (yyvsp[-1].lsc_block2d_addr_operand).immOffsets[0],
            (yyvsp[-1].lsc_block2d_addr_operand).immOffsets[1],
            CISAlineno);
    }
#line 4643 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 241: /* LscUntypedAtomic: Predicate LSC_ATOMIC_MNEMONIC LSC_SFID_UNTYPED_TOKEN LscCacheOpts ExecSize LscDataOperand LscUntypedAddrOperand LscPayloadReg LscPayloadReg  */
#line 1921 "CISA.y"
    {
        (yyvsp[-4].emask_exec_size).exec_size =
            lscCheckExecSize(pBuilder, (yyvsp[-6].lsc_sfid), (yyvsp[-7].lsc_subOpcode), (yyvsp[-3].lsc_data_operand).shape.order, (yyvsp[-4].emask_exec_size).exec_size);
        pBuilder->CISA_create_lsc_untyped_inst(
            (yyvsp[-8].pred_reg),  // predicate
            (yyvsp[-7].lsc_subOpcode),                // op
            (yyvsp[-6].lsc_sfid),                // sfid
            (yyvsp[-5].lsc_caching_opts),                // caching settings
            false,             // ov
            Get_VISA_Exec_Size_From_Raw_Size((yyvsp[-4].emask_exec_size).exec_size),
            (yyvsp[-4].emask_exec_size).emask,
            (yyvsp[-2].lsc_addr_operand).addr,         // address info
            (yyvsp[-3].lsc_data_operand).shape,        // data type
            (yyvsp[-2].lsc_addr_operand).surface,      // surface array base
            (yyvsp[-2].lsc_addr_operand).surfaceIndex, // surface index
            (yyvsp[-3].lsc_data_operand).reg,          // dst data
            (yyvsp[-2].lsc_addr_operand).regs[0],      // src0 addr
            (yyvsp[-1].RawVar),              // src1 data
            (yyvsp[0].RawVar),              // src2 data (for icas/fcas)
            CISAlineno);
    }
#line 4669 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 242: /* LscTypedMSRTLoad: Predicate LSC_LOAD_MSRT_MNEMONIC LSC_SFID_TYPED_TOKEN LscCacheOpts ExecSize LscDataOperand LscTypedAddrOperandWithOffsets  */
#line 1948 "CISA.y"
    {
        (yyvsp[-2].emask_exec_size).exec_size =
            lscCheckExecSize(pBuilder, (yyvsp[-4].lsc_sfid), (yyvsp[-5].lsc_subOpcode), (yyvsp[-1].lsc_data_operand).shape.order, (yyvsp[-2].emask_exec_size).exec_size);
        pBuilder->CISA_create_lsc_typed_inst(
            (yyvsp[-6].pred_reg),  // predicate
            (yyvsp[-5].lsc_subOpcode),  // subop
            (yyvsp[-4].lsc_sfid),  // sfid
            (yyvsp[-3].lsc_caching_opts),  // caching settings
            Get_VISA_Exec_Size_From_Raw_Size((yyvsp[-2].emask_exec_size).exec_size),
            (yyvsp[-2].emask_exec_size).emask,
            (yyvsp[0].lsc_typed_operand).addr.type,     // address model
            (yyvsp[0].lsc_typed_operand).addr.size,     // address size
            (yyvsp[-1].lsc_data_operand).shape,         // data type
            (yyvsp[0].lsc_typed_operand).surface,       // surface array base
            (yyvsp[0].lsc_typed_operand).surfaceIndex,  // surface index
            (yyvsp[-1].lsc_data_operand).reg,           // dst data
            (yyvsp[0].lsc_typed_operand).regs[0],       // src0_u
            (yyvsp[0].lsc_typed_operand).uvrOffsets[0], // src0-u imm offsets
            (yyvsp[0].lsc_typed_operand).regs[1],       // src0_v
            (yyvsp[0].lsc_typed_operand).uvrOffsets[1], // src0-v imm offsets
            (yyvsp[0].lsc_typed_operand).regs[2],       // src0_r
            (yyvsp[0].lsc_typed_operand).uvrOffsets[2], // src0-r imm offsets
            (yyvsp[0].lsc_typed_operand).regs[3],       // sample index
            nullptr,          // src1 data
            nullptr,          // src2 data
            CISAlineno);
    }
#line 4701 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 243: /* LscTypedMSRTStore: Predicate LSC_STORE_MSRT_MNEMONIC LSC_SFID_TYPED_TOKEN LscCacheOpts ExecSize LscTypedAddrOperandWithOffsets LscDataOperand  */
#line 1981 "CISA.y"
    {
        (yyvsp[-2].emask_exec_size).exec_size =
            lscCheckExecSize(pBuilder, (yyvsp[-4].lsc_sfid), (yyvsp[-5].lsc_subOpcode), (yyvsp[0].lsc_data_operand).shape.order, (yyvsp[-2].emask_exec_size).exec_size);
        pBuilder->CISA_create_lsc_typed_inst(
            (yyvsp[-6].pred_reg),  // predicate
            (yyvsp[-5].lsc_subOpcode),  // subop
            (yyvsp[-4].lsc_sfid),  // sfid
            (yyvsp[-3].lsc_caching_opts),  // caching settings
            Get_VISA_Exec_Size_From_Raw_Size((yyvsp[-2].emask_exec_size).exec_size),
            (yyvsp[-2].emask_exec_size).emask,
            (yyvsp[-1].lsc_typed_operand).addr.type,     // address model
            (yyvsp[-1].lsc_typed_operand).addr.size,     // address size
            (yyvsp[0].lsc_data_operand).shape,         // data type
            (yyvsp[-1].lsc_typed_operand).surface,       // surface array base
            (yyvsp[-1].lsc_typed_operand).surfaceIndex,  // surface index
            nullptr,          // dst
            (yyvsp[-1].lsc_typed_operand).regs[0],       // src0-u
            (yyvsp[-1].lsc_typed_operand).uvrOffsets[0], // src0-u imm offsets
            (yyvsp[-1].lsc_typed_operand).regs[1],       // src0-v
            (yyvsp[-1].lsc_typed_operand).uvrOffsets[1], // src0-v imm offsets
            (yyvsp[-1].lsc_typed_operand).regs[2],       // src0-r
            (yyvsp[-1].lsc_typed_operand).uvrOffsets[2], // src0-r imm offsets
            (yyvsp[-1].lsc_typed_operand).regs[3],       // src0-sample-index
            (yyvsp[0].lsc_data_operand).reg,           // src1 data
            nullptr,          // src2 data
            CISAlineno);
    }
#line 4733 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 244: /* LscTypedLoad: Predicate LSC_LOAD_MNEMONIC LSC_SFID_TYPED_TOKEN LscCacheOpts ExecSize LscDataOperand LscTypedAddrOperandWithOffsets  */
#line 2024 "CISA.y"
    {
        if ((yyvsp[-5].lsc_subOpcode) != LSC_LOAD_QUAD && (yyvsp[-5].lsc_subOpcode) != LSC_LOAD_QUAD_STATUS) {
            PARSE_ERROR("unsupported load operation for .tgm");
        }
        (yyvsp[-2].emask_exec_size).exec_size =
            lscCheckExecSize(pBuilder, (yyvsp[-4].lsc_sfid), (yyvsp[-5].lsc_subOpcode), (yyvsp[-1].lsc_data_operand).shape.order, (yyvsp[-2].emask_exec_size).exec_size);
        pBuilder->CISA_create_lsc_typed_inst(
            (yyvsp[-6].pred_reg),  // predicate
            (yyvsp[-5].lsc_subOpcode),  // subop
            (yyvsp[-4].lsc_sfid),  // sfid
            (yyvsp[-3].lsc_caching_opts),  // caching settings
            Get_VISA_Exec_Size_From_Raw_Size((yyvsp[-2].emask_exec_size).exec_size),
            (yyvsp[-2].emask_exec_size).emask,
            (yyvsp[0].lsc_typed_operand).addr.type,      // address type
            (yyvsp[0].lsc_typed_operand).addr.size,      // address size
            (yyvsp[-1].lsc_data_operand).shape,          // data
            (yyvsp[0].lsc_typed_operand).surface,        // surface
            (yyvsp[0].lsc_typed_operand).surfaceIndex,   // surface index
            (yyvsp[-1].lsc_data_operand).reg,            // dst
            (yyvsp[0].lsc_typed_operand).regs[0],        // src0_u
            (yyvsp[0].lsc_typed_operand).uvrOffsets[0],  // u offset
            (yyvsp[0].lsc_typed_operand).regs[1],        // src0_v
            (yyvsp[0].lsc_typed_operand).uvrOffsets[1],  // v offset
            (yyvsp[0].lsc_typed_operand).regs[2],        // src0_r
            (yyvsp[0].lsc_typed_operand).uvrOffsets[2],  // r offset
            (yyvsp[0].lsc_typed_operand).regs[3],        // src0_lod
            nullptr,           // src1 data
            nullptr,           // src2 data
            CISAlineno);
    }
#line 4768 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 245: /* LscTypedStore: Predicate LSC_STORE_MNEMONIC LSC_SFID_TYPED_TOKEN LscCacheOpts ExecSize LscTypedAddrOperandWithOffsets LscDataOperand  */
#line 2070 "CISA.y"
    {
        if ((yyvsp[-5].lsc_subOpcode) != LSC_STORE_QUAD) {
            PARSE_ERROR("unsupported store operation for .tgm");
        }
        (yyvsp[-2].emask_exec_size).exec_size =
            lscCheckExecSize(pBuilder, (yyvsp[-4].lsc_sfid), (yyvsp[-5].lsc_subOpcode), (yyvsp[0].lsc_data_operand).shape.order, (yyvsp[-2].emask_exec_size).exec_size);
        pBuilder->CISA_create_lsc_typed_inst(
            (yyvsp[-6].pred_reg),  // predicate
            (yyvsp[-5].lsc_subOpcode),  // subop
            (yyvsp[-4].lsc_sfid),  // sfid
            (yyvsp[-3].lsc_caching_opts),  // caching settings
            Get_VISA_Exec_Size_From_Raw_Size((yyvsp[-2].emask_exec_size).exec_size),
            (yyvsp[-2].emask_exec_size).emask,
            (yyvsp[-1].lsc_typed_operand).addr.type,     // address model
            (yyvsp[-1].lsc_typed_operand).addr.size,     // address size
            (yyvsp[0].lsc_data_operand).shape,         // data size
            (yyvsp[-1].lsc_typed_operand).surface,       // surface
            (yyvsp[-1].lsc_typed_operand).surfaceIndex,  // surface index
            nullptr,          // dst
            (yyvsp[-1].lsc_typed_operand).regs[0],       // src0_u
            (yyvsp[-1].lsc_typed_operand).uvrOffsets[0], // u offset
            (yyvsp[-1].lsc_typed_operand).regs[1],       // src0_v
            (yyvsp[-1].lsc_typed_operand).uvrOffsets[1], // v offset
            (yyvsp[-1].lsc_typed_operand).regs[2],       // src0-r
            (yyvsp[-1].lsc_typed_operand).uvrOffsets[2], // r offset
            (yyvsp[-1].lsc_typed_operand).regs[3],       // src0_lod
            (yyvsp[0].lsc_data_operand).reg,           // stored data
            nullptr,          // src2
            CISAlineno);
    }
#line 4803 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 246: /* LscTypedAtomic: Predicate LSC_ATOMIC_MNEMONIC LSC_SFID_TYPED_TOKEN LscCacheOpts ExecSize LscDataOperand LscTypedAddrOperandWithOffsets LscPayloadReg LscPayloadReg  */
#line 2117 "CISA.y"
    {
        (yyvsp[-4].emask_exec_size).exec_size =
            lscCheckExecSize(pBuilder, (yyvsp[-6].lsc_sfid), (yyvsp[-7].lsc_subOpcode), (yyvsp[-3].lsc_data_operand).shape.order, (yyvsp[-4].emask_exec_size).exec_size);
        pBuilder->CISA_create_lsc_typed_inst(
            (yyvsp[-8].pred_reg),  // predicate
            (yyvsp[-7].lsc_subOpcode),  // subop
            (yyvsp[-6].lsc_sfid),  // sfid
            (yyvsp[-5].lsc_caching_opts),  // caching settings
            Get_VISA_Exec_Size_From_Raw_Size((yyvsp[-4].emask_exec_size).exec_size),
            (yyvsp[-4].emask_exec_size).emask,
            (yyvsp[-2].lsc_typed_operand).addr.type, // address model
            (yyvsp[-2].lsc_typed_operand).addr.size,  // address size
            (yyvsp[-3].lsc_data_operand).shape,    // data type
            (yyvsp[-2].lsc_typed_operand).surface,  // surface
            (yyvsp[-2].lsc_typed_operand).surfaceIndex, // surface index
            (yyvsp[-3].lsc_data_operand).reg,      // dst data
            (yyvsp[-2].lsc_typed_operand).regs[0],  // src0 addrs u
            (yyvsp[-2].lsc_typed_operand).uvrOffsets[0], // u offset
            (yyvsp[-2].lsc_typed_operand).regs[1],  // src0 addrs v
            (yyvsp[-2].lsc_typed_operand).uvrOffsets[1], // v offset
            (yyvsp[-2].lsc_typed_operand).regs[2],  // src0 addrs r
            (yyvsp[-2].lsc_typed_operand).uvrOffsets[2], // r offset
            (yyvsp[-2].lsc_typed_operand).regs[3],  // src0 addrs lod
            (yyvsp[-1].RawVar),          // src1 data
            (yyvsp[0].RawVar),          // src2 data
            CISAlineno);
    }
#line 4835 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 247: /* LscTypedReadStateInfo: Predicate LSC_READ_STATE_INFO_MNEMONIC LSC_SFID_TYPED_TOKEN LscPayloadReg LscAddrModelStateful LBRACK LscPayloadNonNullReg RBRACK  */
#line 2157 "CISA.y"
   {
        LSC_CACHE_OPTS caching {LSC_CACHING_DEFAULT,LSC_CACHING_DEFAULT};
        LSC_DATA_SHAPE dataShape {LSC_DATA_SIZE_32b,LSC_DATA_ORDER_TRANSPOSE};
        dataShape.elems = LSC_DATA_ELEMS_16;
        pBuilder->CISA_create_lsc_typed_inst(
            (yyvsp[-7].pred_reg),              // predicate
            (yyvsp[-6].lsc_subOpcode),              // subop
            (yyvsp[-5].lsc_sfid),              // sfid
            caching,         // no caching settings
            EXEC_SIZE_1,
            vISA_EMASK_M1_NM,
            (yyvsp[-3].lsc_addr_model).type,           // address type
            LSC_ADDR_SIZE_32b, // address size
            dataShape,         // data type
            (yyvsp[-3].lsc_addr_model).surface,        // surface
            (yyvsp[-3].lsc_addr_model).surfaceIndex,   // SS_IDX
            (yyvsp[-4].RawVar),                // dst data
            (yyvsp[-1].RawVar),                // src0 coords (u, v, r, lod) SIMD1 are packed in
            0,                 // no uvr-offsets
            nullptr,           // no other coords
            0,                 // no uvr-offsets
            nullptr,           // no other coords
            0,                 // no uvr-offsets
            nullptr,           // no other coords
            nullptr,           // no src1 data
            nullptr,           // no src2 data
            CISAlineno);
   }
#line 4868 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 248: /* LscFence: LSC_FENCE_MNEMONIC LscSfid LSC_FENCE_OP_TYPE LSC_FENCE_SCOPE  */
#line 2194 "CISA.y"
    {
        pBuilder->CISA_create_lsc_fence((yyvsp[-2].lsc_sfid), (yyvsp[-1].lsc_fence_op), (yyvsp[0].lsc_scope), CISAlineno);
    }
#line 4876 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 251: /* LscCacheOpts: %empty  */
#line 2201 "CISA.y"
                                    {(yyval.lsc_caching_opts) = pBuilder->CISA_create_caching_opts(CISAlineno);}
#line 4882 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 252: /* LscCacheOpts: LSC_CACHING_OPT LSC_CACHING_OPT  */
#line 2202 "CISA.y"
                                    {(yyval.lsc_caching_opts) = pBuilder->CISA_create_caching_opts((yyvsp[-1].lsc_caching_opt),(yyvsp[0].lsc_caching_opt), CISAlineno);}
#line 4888 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 253: /* LscCacheOpts: LSC_CACHING_OPT LSC_CACHING_OPT LSC_CACHING_OPT  */
#line 2203 "CISA.y"
                                                    {(yyval.lsc_caching_opts) = pBuilder->CISA_create_caching_opts((yyvsp[-2].lsc_caching_opt),(yyvsp[-1].lsc_caching_opt),(yyvsp[0].lsc_caching_opt),CISAlineno);}
#line 4894 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 254: /* OVOpt: %empty  */
#line 2205 "CISA.y"
              {(yyval.ov) = false;}
#line 4900 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 255: /* OVOpt: OV  */
#line 2205 "CISA.y"
                                 {(yyval.ov) = true;}
#line 4906 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 256: /* LscUntypedAddrOperand: LscAddrModelOpt LBRACK LscAddrImmScaleOpt LscPayloadNonNullReg LscAddrImmOffsetOpt RBRACK LSC_ADDR_SIZE_TK  */
#line 2212 "CISA.y"
    {
        (yyval.lsc_addr_operand) = {(yyvsp[-6].lsc_addr_model).surface, (yyvsp[-6].lsc_addr_model).surfaceIndex, {(yyvsp[-3].RawVar)}, {(yyvsp[-6].lsc_addr_model).type, (int)(yyvsp[-4].intval), (int)(yyvsp[-2].intval), (yyvsp[0].lsc_addr_size)}};
    }
#line 4914 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 257: /* LscUntypedAddrOperand: LscAddrModelOpt LBRACK BUILTIN_NULL RBRACK  */
#line 2220 "CISA.y"
    {
        (yyval.lsc_addr_operand) = {(yyvsp[-3].lsc_addr_model).surface, (yyvsp[-3].lsc_addr_model).surfaceIndex, {nullptr}, {(yyvsp[-3].lsc_addr_model).type, 1, 0, LSC_ADDR_SIZE_32bU}};
    }
#line 4922 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 258: /* LscUntypedStridedAddrOperand: LscAddrModelOpt LBRACK LscAddrImmScaleOpt LscPayloadNonNullReg LscAddrImmOffsetOpt COMMA LscVectorOpRegOrImm32 RBRACK LSC_ADDR_SIZE_TK  */
#line 2229 "CISA.y"
    {
        (yyval.lsc_addr_operand) = {(yyvsp[-8].lsc_addr_model).surface, (yyvsp[-8].lsc_addr_model).surfaceIndex, {(yyvsp[-5].RawVar), (yyvsp[-2].lsc_addr_surface_ident)}, {(yyvsp[-8].lsc_addr_model).type, (int)(yyvsp[-6].intval), (int)(yyvsp[-4].intval), (yyvsp[0].lsc_addr_size)}};
    }
#line 4930 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 259: /* LscUntypedStridedAddrOperand: LscUntypedAddrOperand  */
#line 2232 "CISA.y"
                            {
        (yyval.lsc_addr_operand) = (yyvsp[0].lsc_addr_operand);
        (yyval.lsc_addr_operand).regs[1] = nullptr;
    }
#line 4939 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 260: /* LscUntypedBlock2dAddrOperand: LSC_AM_FLAT LBRACK LscVectorOpReg COMMA LscVectorOpRegOrImm32 COMMA LscVectorOpRegOrImm32 COMMA LscVectorOpRegOrImm32 COMMA LscVectorOpReg LscAddrImmOffsetOpt COMMA LscVectorOpReg LscAddrImmOffsetOpt RBRACK  */
#line 2256 "CISA.y"
    {
        (yyval.lsc_block2d_addr_operand) = {nullptr,0,{(yyvsp[-13].lsc_addr_surface_ident),(yyvsp[-11].lsc_addr_surface_ident),(yyvsp[-9].lsc_addr_surface_ident),(yyvsp[-7].lsc_addr_surface_ident),(yyvsp[-5].lsc_addr_surface_ident),(yyvsp[-2].lsc_addr_surface_ident)},{(int)(yyvsp[-4].intval), (int)(yyvsp[-1].intval)},{LSC_ADDR_TYPE_FLAT,1,0,LSC_ADDR_SIZE_64b}};
    }
#line 4947 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 261: /* LscUntypedBlock2dAddrOperand: LSC_AM_FLAT LBRACK LscVectorOpReg COMMA LscVectorOpRegOrImm32 COMMA LscVectorOpRegOrImm32 COMMA LscVectorOpRegOrImm32 COMMA LscVectorOpImm32 COMMA LscVectorOpImm32 RBRACK  */
#line 2276 "CISA.y"
    {
        (yyval.lsc_block2d_addr_operand) = {nullptr,0,{(yyvsp[-11].lsc_addr_surface_ident),(yyvsp[-9].lsc_addr_surface_ident),(yyvsp[-7].lsc_addr_surface_ident),(yyvsp[-5].lsc_addr_surface_ident),(yyvsp[-3].lsc_addr_surface_ident),(yyvsp[-1].lsc_addr_surface_ident)},{0, 0},{LSC_ADDR_TYPE_FLAT,1,0,LSC_ADDR_SIZE_64b}};
    }
#line 4955 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 262: /* LscUntypedBlock2dAddrOperand: LSC_AM_FLAT LBRACK LscVectorOpReg COMMA LscVectorOpRegOrImm32 COMMA LscVectorOpRegOrImm32 COMMA LscVectorOpRegOrImm32 COMMA LscVectorOpImm32 COMMA LscVectorOpReg LscAddrImmOffsetOpt RBRACK  */
#line 2296 "CISA.y"
    {
        (yyval.lsc_block2d_addr_operand) = {nullptr,0,{(yyvsp[-12].lsc_addr_surface_ident),(yyvsp[-10].lsc_addr_surface_ident),(yyvsp[-8].lsc_addr_surface_ident),(yyvsp[-6].lsc_addr_surface_ident),(yyvsp[-4].lsc_addr_surface_ident),(yyvsp[-2].lsc_addr_surface_ident)},{0, (int)(yyvsp[-1].intval)},{LSC_ADDR_TYPE_FLAT,1,0,LSC_ADDR_SIZE_64b}};
    }
#line 4963 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 263: /* LscUntypedBlock2dAddrOperand: LSC_AM_FLAT LBRACK LscVectorOpReg COMMA LscVectorOpRegOrImm32 COMMA LscVectorOpRegOrImm32 COMMA LscVectorOpRegOrImm32 COMMA LscVectorOpReg LscAddrImmOffsetOpt COMMA LscVectorOpImm32 RBRACK  */
#line 2316 "CISA.y"
    {
        (yyval.lsc_block2d_addr_operand) = {nullptr,0,{(yyvsp[-12].lsc_addr_surface_ident),(yyvsp[-10].lsc_addr_surface_ident),(yyvsp[-8].lsc_addr_surface_ident),(yyvsp[-6].lsc_addr_surface_ident),(yyvsp[-4].lsc_addr_surface_ident),(yyvsp[-1].lsc_addr_surface_ident)},{(int)(yyvsp[-3].intval), 0},{LSC_ADDR_TYPE_FLAT,1,0,LSC_ADDR_SIZE_64b}};
    }
#line 4971 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 264: /* LscUntypedBlock2dAddrOperand: LSC_AM_FLAT LBRACK LscVectorOpReg PLUS LPAREN IntExpUnr COMMA IntExpUnr RPAREN RBRACK  */
#line 2324 "CISA.y"
    {
        (yyval.lsc_block2d_addr_operand) = {nullptr,0,{(yyvsp[-7].lsc_addr_surface_ident),nullptr,nullptr,nullptr,nullptr,nullptr},{(int)(yyvsp[-4].intval),(int)(yyvsp[-2].intval)},{LSC_ADDR_TYPE_FLAT,1,0,LSC_ADDR_SIZE_64b}};
    }
#line 4979 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 265: /* LscTypedAddrWithOffsetOperand: LscPayloadNonNullReg  */
#line 2329 "CISA.y"
    {
        (yyval.lsc_typed_addr_operand) = {(yyvsp[0].RawVar), 0};
    }
#line 4987 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 266: /* LscTypedAddrWithOffsetOperand: LscPayloadNonNullReg PLUS IntExpMul  */
#line 2332 "CISA.y"
                                          {
        (yyval.lsc_typed_addr_operand) = {(yyvsp[-2].RawVar), (int)(yyvsp[0].intval)};
    }
#line 4995 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 267: /* LscTypedAddrWithOffsetOperand: LscPayloadNonNullReg MINUS IntExpMul  */
#line 2336 "CISA.y"
    {
        (yyval.lsc_typed_addr_operand) = {(yyvsp[-2].RawVar), (int)-(yyvsp[0].intval)};
    }
#line 5003 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 268: /* LscTypedAddrWithOffsetOperandList: LscTypedAddrWithOffsetOperand  */
#line 2340 "CISA.y"
                                    {
        (yyval.lsc_typed_addr_operand_list) = {{(yyvsp[0].lsc_typed_addr_operand).reg}, {(yyvsp[0].lsc_typed_addr_operand).offset, 0, 0}};
      }
#line 5011 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 269: /* LscTypedAddrWithOffsetOperandList: LscTypedAddrWithOffsetOperand COMMA LscTypedAddrWithOffsetOperand  */
#line 2345 "CISA.y"
      {
        (yyval.lsc_typed_addr_operand_list) = {{(yyvsp[-2].lsc_typed_addr_operand).reg,(yyvsp[0].lsc_typed_addr_operand).reg}, {(yyvsp[-2].lsc_typed_addr_operand).offset, (yyvsp[0].lsc_typed_addr_operand).offset, 0}};
      }
#line 5019 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 270: /* LscTypedAddrWithOffsetOperandList: LscTypedAddrWithOffsetOperand COMMA LscTypedAddrWithOffsetOperand COMMA LscTypedAddrWithOffsetOperand  */
#line 2351 "CISA.y"
    {
        (yyval.lsc_typed_addr_operand_list) = {{(yyvsp[-4].lsc_typed_addr_operand).reg,(yyvsp[-2].lsc_typed_addr_operand).reg,(yyvsp[0].lsc_typed_addr_operand).reg}, {(yyvsp[-4].lsc_typed_addr_operand).offset, (yyvsp[-2].lsc_typed_addr_operand).offset, (yyvsp[0].lsc_typed_addr_operand).offset}};
    }
#line 5027 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 271: /* LscTypedAddrWithOffsetOperandList: LscTypedAddrWithOffsetOperand COMMA LscTypedAddrWithOffsetOperand COMMA LscTypedAddrWithOffsetOperand COMMA LscPayloadNonNullReg  */
#line 2358 "CISA.y"
    {
        (yyval.lsc_typed_addr_operand_list) = {{(yyvsp[-6].lsc_typed_addr_operand).reg,(yyvsp[-4].lsc_typed_addr_operand).reg,(yyvsp[-2].lsc_typed_addr_operand).reg,(yyvsp[0].RawVar)}, {(yyvsp[-6].lsc_typed_addr_operand).offset, (yyvsp[-4].lsc_typed_addr_operand).offset, (yyvsp[-2].lsc_typed_addr_operand).offset}};
    }
#line 5035 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 272: /* LscTypedAddrOperandWithOffsets: LscAddrModelStateful LBRACK LscTypedAddrWithOffsetOperandList RBRACK LSC_ADDR_SIZE_TK  */
#line 2364 "CISA.y"
    {
        (yyval.lsc_typed_operand) = {(yyvsp[-4].lsc_addr_model).surface, (yyvsp[-4].lsc_addr_model).surfaceIndex,
               {(yyvsp[-2].lsc_typed_addr_operand_list).regs[0], (yyvsp[-2].lsc_typed_addr_operand_list).regs[1], (yyvsp[-2].lsc_typed_addr_operand_list).regs[2],(yyvsp[-2].lsc_typed_addr_operand_list).regs[3]},
               {(yyvsp[-2].lsc_typed_addr_operand_list).uvrOffsets[0], (yyvsp[-2].lsc_typed_addr_operand_list).uvrOffsets[1], (yyvsp[-2].lsc_typed_addr_operand_list).uvrOffsets[2]},
               {(yyvsp[-4].lsc_addr_model).type, 1, 0, (yyvsp[0].lsc_addr_size)}};
    }
#line 5046 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 273: /* LscAddrImmOffsetOpt: %empty  */
#line 2375 "CISA.y"
                     {(yyval.intval) =   0;}
#line 5052 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 274: /* LscAddrImmOffsetOpt: PLUS IntExpAdd  */
#line 2376 "CISA.y"
                     {(yyval.intval) =  (yyvsp[0].intval);}
#line 5058 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 275: /* LscAddrImmOffsetOpt: MINUS IntExpMul  */
#line 2377 "CISA.y"
                     {(yyval.intval) = -(yyvsp[0].intval);}
#line 5064 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 276: /* LscAddrImmScaleOpt: %empty  */
#line 2382 "CISA.y"
                     {(yyval.intval) = 1;}
#line 5070 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 277: /* LscAddrImmScaleOpt: IntExpPrim TIMES  */
#line 2383 "CISA.y"
                     {(yyval.intval) = (yyvsp[-1].intval);}
#line 5076 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 278: /* LscAddrModelOpt: %empty  */
#line 2386 "CISA.y"
                 {(yyval.lsc_addr_model) = {LSC_ADDR_TYPE_FLAT, nullptr, 0};}
#line 5082 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 279: /* LscAddrModelOpt: LSC_AM_FLAT  */
#line 2387 "CISA.y"
                 {(yyval.lsc_addr_model) = {LSC_ADDR_TYPE_FLAT, nullptr, 0};}
#line 5088 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 280: /* LscAddrModelOpt: LSC_AM_ARG  */
#line 2388 "CISA.y"
                 {(yyval.lsc_addr_model) = {LSC_ADDR_TYPE_ARG, nullptr, 0};}
#line 5094 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 281: /* LscAddrModelOpt: LSC_AM_FLAT LPAREN LscVectorOpRegOrImm64 RPAREN  */
#line 2389 "CISA.y"
                                                     {(yyval.lsc_addr_model) = {LSC_ADDR_TYPE_FLAT, (yyvsp[-1].lsc_addr_surface_ident), 0};}
#line 5100 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 283: /* LscAddrModelStateful: LSC_AM_BSS LPAREN LscVectorOpRegOrImm32 RPAREN  */
#line 2394 "CISA.y"
                                                     {
      (yyval.lsc_addr_model) = {LSC_ADDR_TYPE_BSS,(yyvsp[-1].lsc_addr_surface_ident), 0};
    }
#line 5108 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 284: /* LscAddrModelStateful: LSC_AM_BSS LPAREN LscVectorOpRegOrImm32 COMMA IntExp RPAREN  */
#line 2397 "CISA.y"
                                                                  {
      (yyval.lsc_addr_model) = {LSC_ADDR_TYPE_BSS, (yyvsp[-3].lsc_addr_surface_ident), (int)(yyvsp[-1].intval)};
    }
#line 5116 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 285: /* LscAddrModelStateful: LSC_AM_SS LPAREN LscVectorOpRegOrImm32 RPAREN  */
#line 2400 "CISA.y"
                                                     {
      (yyval.lsc_addr_model) = {LSC_ADDR_TYPE_SS,(yyvsp[-1].lsc_addr_surface_ident), 0};
    }
#line 5124 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 286: /* LscAddrModelStateful: LSC_AM_SS LPAREN LscVectorOpRegOrImm32 COMMA IntExp RPAREN  */
#line 2403 "CISA.y"
                                                                  {
      (yyval.lsc_addr_model) = {LSC_ADDR_TYPE_SS,(yyvsp[-3].lsc_addr_surface_ident), (int)(yyvsp[-1].intval)};
    }
#line 5132 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 287: /* LscAddrModelStateful: LSC_AM_BTI LPAREN LscVectorOpRegOrImm32 RPAREN  */
#line 2406 "CISA.y"
                                                     {
      (yyval.lsc_addr_model) = {LSC_ADDR_TYPE_BTI,(yyvsp[-1].lsc_addr_surface_ident), 0};
    }
#line 5140 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 288: /* LscAddrModelStateful: LSC_AM_BTI LPAREN LscVectorOpRegOrImm32 COMMA IntExp RPAREN  */
#line 2409 "CISA.y"
                                                                  {
      (yyval.lsc_addr_model) = {LSC_ADDR_TYPE_BTI,(yyvsp[-3].lsc_addr_surface_ident), (int)(yyvsp[-1].intval)};
    }
#line 5148 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 289: /* LscAddrModelStateful: LSC_AM_SURF LPAREN LscVectorOpRegOrImm64 RPAREN  */
#line 2412 "CISA.y"
                                                      {
      (yyval.lsc_addr_model) = {LSC_ADDR_TYPE_SURF, (yyvsp[-1].lsc_addr_surface_ident), 0};
    }
#line 5156 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 290: /* LscAddrModelStateful: LSC_AM_SURF LPAREN LscVectorOpRegOrImm64 COMMA IntExp RPAREN  */
#line 2415 "CISA.y"
                                                                   {
      (yyval.lsc_addr_model) = {LSC_ADDR_TYPE_SURF, (yyvsp[-3].lsc_addr_surface_ident), (int)(yyvsp[-1].intval)};
    }
#line 5164 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 295: /* LscVectorOpImm32: IntExp  */
#line 2424 "CISA.y"
           {
        (yyval.lsc_addr_surface_ident) = pBuilder->CISA_create_immed((yyvsp[0].intval), ISA_TYPE_UD, CISAlineno);
    }
#line 5172 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 296: /* LscVectorOpImm64: IntExp  */
#line 2428 "CISA.y"
           {
        (yyval.lsc_addr_surface_ident) = pBuilder->CISA_create_immed((yyvsp[0].intval), ISA_TYPE_UQ, CISAlineno);
    }
#line 5180 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 297: /* LscVectorOpReg: Var  */
#line 2434 "CISA.y"
        {
        ABORT_ON_FAIL((yyval.lsc_addr_surface_ident) = pBuilder->CISA_create_gen_src_operand(
            (yyvsp[0].string),
            0, 1, 0, // region
            0, 0, // row and col offset
            MODIFIER_NONE, CISAlineno));
    }
#line 5192 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 298: /* LscVectorOpReg: Var DOT DEC_LIT  */
#line 2442 "CISA.y"
                    {
        ABORT_ON_FAIL((yyval.lsc_addr_surface_ident) = pBuilder->CISA_create_gen_src_operand(
            (yyvsp[-2].string),
            0, 1, 0, // region
            0, (unsigned char)(yyvsp[0].intval), // row and col offset
            MODIFIER_NONE, CISAlineno));
    }
#line 5204 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 299: /* LscVectorOpReg: Var LPAREN IntExp COMMA IntExp RPAREN  */
#line 2450 "CISA.y"
                                          {
        MUST_HOLD((yyvsp[-3].intval) <= 255 || (yyvsp[-3].intval) >= 0, "row is out of bounds");
        MUST_HOLD((yyvsp[-1].intval) <= 255 || (yyvsp[-1].intval) >= 0, "col is out of bounds");
        (yyval.lsc_addr_surface_ident) = pBuilder->CISA_create_gen_src_operand(
            (yyvsp[-5].string),
            0, 1, 0,
            (unsigned char)(yyvsp[-3].intval), (unsigned char)(yyvsp[-1].intval), // row and col offset
            MODIFIER_NONE, CISAlineno);
        if ((yyval.lsc_addr_surface_ident) == nullptr) {
            PARSE_ERROR("cannot find surface variable");
        }
    }
#line 5221 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 300: /* LscDataOperand: LscPayloadReg LSC_DATA_SHAPE_TK  */
#line 2464 "CISA.y"
                                     {
        (yyval.lsc_data_operand) = {(yyvsp[-1].RawVar),(yyvsp[0].lsc_data_shape)};
    }
#line 5229 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 301: /* LscDataOperand: LscPayloadReg LSC_DATA_SHAPE_TK_CHMASK  */
#line 2468 "CISA.y"
                                            {
        (yyval.lsc_data_operand) = {(yyvsp[-1].RawVar),(yyvsp[0].lsc_data_shape)};
    }
#line 5237 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 302: /* LscDataOperand2D: LscPayloadReg LSC_DATA_SHAPE_TK_BLOCK2D  */
#line 2474 "CISA.y"
                                            {
        (yyval.lsc_data_operand2d) = {(yyvsp[-1].RawVar),(yyvsp[0].lsc_data_shape2d)};
    }
#line 5245 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 304: /* LscPayloadReg: Var  */
#line 2482 "CISA.y"
        {
        ABORT_ON_FAIL((yyval.RawVar) = pBuilder->CISA_create_RAW_operand((yyvsp[0].string), 0, CISAlineno));
    }
#line 5253 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 306: /* LscPayloadNonNullReg: VarNonNull  */
#line 2489 "CISA.y"
               {
        ABORT_ON_FAIL((yyval.RawVar) = pBuilder->CISA_create_RAW_operand((yyvsp[0].string), 0, CISAlineno));
    }
#line 5261 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 310: /* LscTypedBlock2dLoad: Predicate LSC_LOAD_BLOCK2D_MNEMONIC LSC_SFID_TYPED_TOKEN LscCacheOpts LscDataOperandTyped2D LscTypedBlock2dAddrOperand  */
#line 2513 "CISA.y"
    {
        pBuilder->CISA_create_lsc_typed_block2d_inst(
            (yyvsp[-4].lsc_subOpcode),  // subop
            (yyvsp[-2].lsc_caching_opts),  // caching settings
            (yyvsp[0].lsc_block2d_addr_operand).addr.type, // address model
            (yyvsp[-1].lsc_data_operand_typed2d).shape_typed2d,  // data shape
            (yyvsp[0].lsc_block2d_addr_operand).surface,  //surface
            (yyvsp[0].lsc_block2d_addr_operand).surfaceIndex, // surface index
            (yyvsp[-1].lsc_data_operand_typed2d).reg,      // dst
            (yyvsp[0].lsc_block2d_addr_operand).regs[0],     // src0 addrs(block start offset x)
            (yyvsp[0].lsc_block2d_addr_operand).regs[1],     // src0 addrs(block start offset y)
            (yyvsp[0].lsc_block2d_addr_operand).immOffsets[0], // x immediate offset
            (yyvsp[0].lsc_block2d_addr_operand).immOffsets[1], // y immediate offset
            nullptr,     // src1
            CISAlineno);
   }
#line 5282 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 311: /* LscTypedBlock2dStore: Predicate LSC_STORE_BLOCK2D_MNEMONIC LSC_SFID_TYPED_TOKEN LscCacheOpts LscTypedBlock2dAddrOperand LscDataOperandTyped2D  */
#line 2542 "CISA.y"
    {
        pBuilder->CISA_create_lsc_typed_block2d_inst(
            (yyvsp[-4].lsc_subOpcode),  // subop
            (yyvsp[-2].lsc_caching_opts),  // caching settings
            (yyvsp[-1].lsc_block2d_addr_operand).addr.type, // address model
            (yyvsp[0].lsc_data_operand_typed2d).shape_typed2d,  // data shape
            (yyvsp[-1].lsc_block2d_addr_operand).surface,  //surface
            (yyvsp[-1].lsc_block2d_addr_operand).surfaceIndex,
            nullptr,     // dst
            (yyvsp[-1].lsc_block2d_addr_operand).regs[0],     // src0 addrs(block start offset x)
            (yyvsp[-1].lsc_block2d_addr_operand).regs[1],     // src0 addrs(block start offset y)
            (yyvsp[-1].lsc_block2d_addr_operand).immOffsets[0], // x immediate offset
            (yyvsp[-1].lsc_block2d_addr_operand).immOffsets[1], // y immediate offset
            (yyvsp[0].lsc_data_operand_typed2d).reg,      // src1
            CISAlineno);
    }
#line 5303 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 312: /* LscTypedBlock2dAddrOperand: LscAddrModelStateful LBRACK LscVectorOpImm32 COMMA LscVectorOpImm32 RBRACK  */
#line 2568 "CISA.y"
    {
        (yyval.lsc_block2d_addr_operand) = {(yyvsp[-5].lsc_addr_model).surface, 0, {(yyvsp[-3].lsc_addr_surface_ident),(yyvsp[-1].lsc_addr_surface_ident)},{0,0},{(yyvsp[-5].lsc_addr_model).type,1,0,LSC_ADDR_SIZE_64b}};
    }
#line 5311 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 313: /* LscTypedBlock2dAddrOperand: LscAddrModelStateful LBRACK LscVectorOpReg LscAddrImmOffsetOpt COMMA LscVectorOpReg LscAddrImmOffsetOpt RBRACK  */
#line 2578 "CISA.y"
    {
        (yyval.lsc_block2d_addr_operand) = {(yyvsp[-7].lsc_addr_model).surface, (yyvsp[-7].lsc_addr_model).surfaceIndex, {(yyvsp[-5].lsc_addr_surface_ident), (yyvsp[-2].lsc_addr_surface_ident)}, {(int)(yyvsp[-4].intval), (int)(yyvsp[-1].intval)}, {(yyvsp[-7].lsc_addr_model).type, 1, 0, LSC_ADDR_SIZE_64b}};
    }
#line 5319 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 314: /* LscDataOperandTyped2D: LscPayloadReg LSC_DATA_SHAPE_TK_TYPED_BLOCK2D  */
#line 2584 "CISA.y"
                                                  {
        (yyval.lsc_data_operand_typed2d) = {(yyvsp[-1].RawVar),(yyvsp[0].lsc_data_shape_typed2d)};
    }
#line 5327 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 315: /* LscUntypedApndCtrAtomic: Predicate LSC_ATOMIC_MNEMONIC LSC_SFID_UNTYPED_TOKEN LscCacheOpts ExecSize LscDataOperand LscAddrModelStateful LscDataOperand  */
#line 2596 "CISA.y"
    {
        (yyvsp[-3].emask_exec_size).exec_size =
            lscCheckExecSize(pBuilder, (yyvsp[-5].lsc_sfid), (yyvsp[-6].lsc_subOpcode), (yyvsp[-2].lsc_data_operand).shape.order, (yyvsp[-3].emask_exec_size).exec_size);
        pBuilder->CISA_create_lsc_untyped_append_counter_atomic_inst(
            (yyvsp[-6].lsc_subOpcode),          // op
            (yyvsp[-7].pred_reg),          // predicate
            Get_VISA_Exec_Size_From_Raw_Size((yyvsp[-3].emask_exec_size).exec_size),
            (yyvsp[-3].emask_exec_size).emask,    // execution mask
            (yyvsp[-4].lsc_caching_opts),          // caching settings
            (yyvsp[-1].lsc_addr_model).type,     // address type
            (yyvsp[-2].lsc_data_operand).shape,    // data shape
            (yyvsp[-1].lsc_addr_model).surface,  // surface
            (yyvsp[-1].lsc_addr_model).surfaceIndex,
            (yyvsp[-2].lsc_data_operand).reg,      // dst data
            (yyvsp[0].lsc_data_operand).reg,      // src1 data
            CISAlineno);
    }
#line 5349 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 316: /* SwitchLabels: %empty  */
#line 2616 "CISA.y"
    {
    }
#line 5356 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 317: /* SwitchLabels: COMMA SwitchLabels  */
#line 2619 "CISA.y"
    {
    }
#line 5363 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 318: /* SwitchLabels: IDENT SwitchLabels  */
#line 2622 "CISA.y"
    {
        // parse rule means we see last label first
        switchLabels.push_front((yyvsp[-1].string));
    }
#line 5372 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 319: /* BranchInstruction: Predicate BRANCH_OP ExecSize IdentOrStringLit  */
#line 2629 "CISA.y"
    {
        pBuilder->CISA_create_branch_instruction((yyvsp[-3].pred_reg), (yyvsp[-2].opcode), (yyvsp[-1].emask_exec_size).emask, (yyvsp[-1].emask_exec_size).exec_size, (yyvsp[0].string), false, CISAlineno);
    }
#line 5380 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 320: /* BranchInstruction: Predicate CALL_OP ExecSize IdentOrStringLit  */
#line 2633 "CISA.y"
    {
        pBuilder->CISA_create_branch_instruction((yyvsp[-3].pred_reg), (yyvsp[-2].cisa_call).opcode, (yyvsp[-1].emask_exec_size).emask, (yyvsp[-1].emask_exec_size).exec_size, (yyvsp[0].string), (yyvsp[-2].cisa_call).is_fccall, CISAlineno);
    }
#line 5388 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 321: /* BranchInstruction: Predicate RET_OP ExecSize  */
#line 2637 "CISA.y"
    {
        pBuilder->CISA_Create_Ret((yyvsp[-2].pred_reg), (yyvsp[-1].opcode), (yyvsp[0].emask_exec_size).emask, (yyvsp[0].emask_exec_size).exec_size, CISAlineno);
    }
#line 5396 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 322: /* BranchInstruction: SWITCHJMP_OP ExecSize VecSrcOperand_G_I_IMM LPAREN SwitchLabels RPAREN  */
#line 2641 "CISA.y"
    {
        pBuilder->CISA_create_switch_instruction((yyvsp[-5].opcode), (yyvsp[-4].emask_exec_size).exec_size, (yyvsp[-3].genOperand).cisa_gen_opnd, switchLabels, CISAlineno);
        switchLabels.clear();
    }
#line 5405 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 323: /* BranchInstruction: Predicate FCALL ExecSize IDENT DEC_LIT DEC_LIT  */
#line 2647 "CISA.y"
    {
        pBuilder->CISA_create_fcall_instruction((yyvsp[-5].pred_reg), (yyvsp[-4].opcode), (yyvsp[-3].emask_exec_size).emask, (yyvsp[-3].emask_exec_size).exec_size, (yyvsp[-2].string), (unsigned)(yyvsp[-1].intval), (unsigned)(yyvsp[0].intval), CISAlineno);
    }
#line 5413 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 324: /* BranchInstruction: Predicate IFCALL ExecSize VecSrcOperand_G_I_IMM DEC_LIT DEC_LIT  */
#line 2652 "CISA.y"
    {
        pBuilder->CISA_create_ifcall_instruction(
        (yyvsp[-5].pred_reg), (yyvsp[-3].emask_exec_size).emask, (yyvsp[-3].emask_exec_size).exec_size, false,
        (yyvsp[-2].genOperand).cisa_gen_opnd, (unsigned)(yyvsp[-1].intval), (unsigned)(yyvsp[0].intval), CISAlineno);
    }
#line 5423 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 325: /* BranchInstruction: Predicate IFCALL UNIFORM ExecSize VecSrcOperand_G_I_IMM DEC_LIT DEC_LIT  */
#line 2659 "CISA.y"
    {
        pBuilder->CISA_create_ifcall_instruction(
        (yyvsp[-6].pred_reg), (yyvsp[-3].emask_exec_size).emask, (yyvsp[-3].emask_exec_size).exec_size, true,
        (yyvsp[-2].genOperand).cisa_gen_opnd, (unsigned)(yyvsp[-1].intval), (unsigned)(yyvsp[0].intval), CISAlineno);
    }
#line 5433 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 326: /* BranchInstruction: FADDR IdentOrStringLit VecDstOperand_G_I  */
#line 2666 "CISA.y"
    {
        pBuilder->CISA_create_faddr_instruction((yyvsp[-1].string), (yyvsp[0].genOperand).cisa_gen_opnd, CISAlineno);
    }
#line 5441 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 327: /* FILE: FILE_OP STRING_LIT  */
#line 2671 "CISA.y"
    {
        pBuilder->CISA_create_FILE_instruction((yyvsp[-1].opcode), (yyvsp[0].string), CISAlineno);
    }
#line 5449 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 328: /* LOC: LOC_OP DEC_LIT  */
#line 2676 "CISA.y"
    {
        pBuilder->CISA_create_LOC_instruction((yyvsp[-1].opcode), (unsigned)(yyvsp[0].intval), CISAlineno);
    }
#line 5457 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 329: /* RawSendInstruction: Predicate RAW_SEND_STRING ExecSize HEX_LIT DEC_LIT DEC_LIT VecSrcOperand_G_IMM RawOperand RawOperand  */
#line 2682 "CISA.y"
    {
        pBuilder->CISA_create_raw_send_instruction(ISA_RAW_SEND, false, (yyvsp[-6].emask_exec_size).emask, (yyvsp[-6].emask_exec_size).exec_size, (yyvsp[-8].pred_reg),
            (unsigned)(yyvsp[-5].intval), (unsigned char)(yyvsp[-4].intval), (unsigned char)(yyvsp[-3].intval), (yyvsp[-2].genOperand).cisa_gen_opnd, (yyvsp[-1].RawVar), (yyvsp[0].RawVar), CISAlineno);
    }
#line 5466 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 330: /* RawSendInstruction: Predicate RAW_SENDC_STRING ExecSize HEX_LIT DEC_LIT DEC_LIT VecSrcOperand_G_IMM RawOperand RawOperand  */
#line 2689 "CISA.y"
    {
        pBuilder->CISA_create_raw_send_instruction(ISA_RAW_SEND, true, (yyvsp[-6].emask_exec_size).emask, (yyvsp[-6].emask_exec_size).exec_size, (yyvsp[-8].pred_reg),
            (unsigned)(yyvsp[-5].intval), (unsigned char)(yyvsp[-4].intval), (unsigned char)(yyvsp[-3].intval), (yyvsp[-2].genOperand).cisa_gen_opnd, (yyvsp[-1].RawVar), (yyvsp[0].RawVar), CISAlineno);
    }
#line 5475 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 331: /* LifetimeStartInst: LIFETIME_START_OP IDENT  */
#line 2696 "CISA.y"
    {
        ABORT_ON_FAIL(pBuilder->CISA_create_lifetime_inst((unsigned char)0, (yyvsp[0].string), CISAlineno));
    }
#line 5483 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 332: /* LifetimeEndInst: LIFETIME_END_OP IDENT  */
#line 2702 "CISA.y"
    {
        ABORT_ON_FAIL(pBuilder->CISA_create_lifetime_inst((unsigned char)1, (yyvsp[0].string), CISAlineno));
    }
#line 5491 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 333: /* RawSendsInstruction: Predicate RAW_SENDS_STRING ElemNum ElemNum ElemNum ElemNum ExecSize VecSrcOperand_G_IMM VecSrcOperand_G_IMM RawOperand RawOperand RawOperand  */
#line 2708 "CISA.y"
    {
        pBuilder->CISA_create_raw_sends_instruction(
            ISA_RAW_SENDS, false, false, (yyvsp[-5].emask_exec_size).emask, (yyvsp[-5].emask_exec_size).exec_size, (yyvsp[-11].pred_reg), (yyvsp[-4].genOperand).cisa_gen_opnd,
            (unsigned char)(yyvsp[-9].intval), (unsigned char)(yyvsp[-8].intval), (unsigned char)(yyvsp[-7].intval), (unsigned char)(yyvsp[-6].intval),
            (yyvsp[-3].genOperand).cisa_gen_opnd, (yyvsp[-2].RawVar), (yyvsp[-1].RawVar), (yyvsp[0].RawVar), CISAlineno);
    }
#line 5502 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 334: /* RawSendsInstruction: Predicate RAW_SENDS_EOT_STRING ElemNum ElemNum ElemNum ElemNum ExecSize VecSrcOperand_G_IMM VecSrcOperand_G_IMM RawOperand RawOperand RawOperand  */
#line 2716 "CISA.y"
    {
        pBuilder->CISA_create_raw_sends_instruction(
            ISA_RAW_SENDS, false, true, (yyvsp[-5].emask_exec_size).emask, (yyvsp[-5].emask_exec_size).exec_size, (yyvsp[-11].pred_reg), (yyvsp[-4].genOperand).cisa_gen_opnd,
            (unsigned char)(yyvsp[-9].intval), (unsigned char)(yyvsp[-8].intval), (unsigned char)(yyvsp[-7].intval), (unsigned char)(yyvsp[-6].intval),
            (yyvsp[-3].genOperand).cisa_gen_opnd, (yyvsp[-2].RawVar), (yyvsp[-1].RawVar), (yyvsp[0].RawVar), CISAlineno);
    }
#line 5513 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 335: /* RawSendsInstruction: Predicate RAW_SENDSC_STRING ElemNum ElemNum ElemNum ExecSize VecSrcOperand_G_IMM VecSrcOperand_G_IMM RawOperand RawOperand RawOperand  */
#line 2724 "CISA.y"
    {
        pBuilder->CISA_create_raw_sends_instruction(
            ISA_RAW_SENDS, true, false, (yyvsp[-5].emask_exec_size).emask, (yyvsp[-5].emask_exec_size).exec_size, (yyvsp[-10].pred_reg), (yyvsp[-4].genOperand).cisa_gen_opnd,
            0, (unsigned char)(yyvsp[-8].intval), (unsigned char)(yyvsp[-7].intval), (unsigned char)(yyvsp[-6].intval),
            (yyvsp[-3].genOperand).cisa_gen_opnd, (yyvsp[-2].RawVar), (yyvsp[-1].RawVar), (yyvsp[0].RawVar), CISAlineno);
    }
#line 5524 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 336: /* RawSendsInstruction: Predicate RAW_SENDSC_EOT_STRING ElemNum ElemNum ElemNum ExecSize VecSrcOperand_G_IMM VecSrcOperand_G_IMM RawOperand RawOperand RawOperand  */
#line 2732 "CISA.y"
    {
        pBuilder->CISA_create_raw_sends_instruction(
            ISA_RAW_SENDS, true, true, (yyvsp[-5].emask_exec_size).emask, (yyvsp[-5].emask_exec_size).exec_size, (yyvsp[-10].pred_reg), (yyvsp[-4].genOperand).cisa_gen_opnd,
            0, (unsigned char)(yyvsp[-8].intval), (unsigned char)(yyvsp[-7].intval), (unsigned char)(yyvsp[-6].intval),
            (yyvsp[-3].genOperand).cisa_gen_opnd, (yyvsp[-2].RawVar), (yyvsp[-1].RawVar), (yyvsp[0].RawVar), CISAlineno);
    }
#line 5535 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 337: /* RawSendgInstruction: Predicate RawSendgMnemonic RawSendgSfid ExecSize RawOperand RawSendgPayloadSize RawOperand RawSendgPayloadSize RawOperand RawSendgPayloadSize VecSrcOperand_G_IMM VecSrcOperand_G_IMM IntExpPrim  */
#line 2751 "CISA.y"
    {
      pBuilder->CISA_create_raw_sendg_instruction(
        (unsigned)(yyvsp[-10].intval), // sfid
        (yyvsp[-12].pred_reg), // pred
        (yyvsp[-9].emask_exec_size).emask, Get_VISA_Exec_Size_From_Raw_Size((yyvsp[-9].emask_exec_size).exec_size), // emask, esize
        (yyvsp[-8].RawVar), (int)(yyvsp[-7].intval), // dst
        (yyvsp[-6].RawVar), (int)(yyvsp[-5].intval), // src0
        (yyvsp[-4].RawVar), (int)(yyvsp[-3].intval), // src1
        (yyvsp[-2].genOperand).cisa_gen_opnd, // ind0
        (yyvsp[-1].genOperand).cisa_gen_opnd, // ind1
        (yyvsp[0].intval), // desc
        (yyvsp[-11].raw_sendg_info).raw_sendg_is_conditional,
        (yyvsp[-11].raw_sendg_info).raw_sendg_is_eot, // hasEoT
        CISAlineno);
    }
#line 5555 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 338: /* RawSendgMnemonic: RAW_SENDG_STRING  */
#line 2767 "CISA.y"
                          {(yyval.raw_sendg_info).raw_sendg_is_conditional = false; (yyval.raw_sendg_info).raw_sendg_is_eot = false;}
#line 5561 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 339: /* RawSendgMnemonic: RAW_SENDG_EOT_STRING  */
#line 2768 "CISA.y"
                          {(yyval.raw_sendg_info).raw_sendg_is_conditional = false; (yyval.raw_sendg_info).raw_sendg_is_eot = true;}
#line 5567 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 340: /* RawSendgMnemonic: RAW_SENDGC_STRING  */
#line 2769 "CISA.y"
                          {(yyval.raw_sendg_info).raw_sendg_is_conditional = true; (yyval.raw_sendg_info).raw_sendg_is_eot = false;}
#line 5573 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 341: /* RawSendgMnemonic: RAW_SENDGC_EOT_STRING  */
#line 2770 "CISA.y"
                          {(yyval.raw_sendg_info).raw_sendg_is_conditional = true; (yyval.raw_sendg_info).raw_sendg_is_eot = true;}
#line 5579 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 342: /* RawSendgSfid: DOT IntExpPrim  */
#line 2779 "CISA.y"
                   {
      MUST_HOLD((yyvsp[0].intval) >= 0 && (yyvsp[0].intval) < 16, "invalid sfid value");
      (yyval.intval) = (int)(yyvsp[0].intval);
    }
#line 5588 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 343: /* RawSendgSfid: LSC_SFID_UNTYPED_TOKEN  */
#line 2783 "CISA.y"
                           {
    if ((yyvsp[0].lsc_sfid) == LSC_SLM) {(yyval.intval) = 0xF;}
    else if ((yyvsp[0].lsc_sfid) == LSC_UGM) {(yyval.intval) = 0xE;}
    else if ((yyvsp[0].lsc_sfid) == LSC_URB) {(yyval.intval) = 0x6;}
    else {(yyval.intval) = 0; MUST_HOLD(false, "invalid sfid symbol");}
  }
#line 5599 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 344: /* RawSendgSfid: LSC_SFID_TYPED_TOKEN  */
#line 2789 "CISA.y"
                         {
    if ((yyvsp[0].lsc_sfid) == LSC_TGM) {(yyval.intval) = 0xD;}
    else {(yyval.intval) = 0; MUST_HOLD(false, "invalid sfid symbol");}
  }
#line 5608 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 345: /* RawSendgSfid: DOT IDENT  */
#line 2793 "CISA.y"
              { // for SFIDs that lack contiguous token
    if (streq((yyvsp[0].string), "null")) {
      (yyval.intval) = 0x0;
    } else if (streq((yyvsp[0].string), "smpl")) {
      (yyval.intval) = 0x2;
    } else if (streq((yyvsp[0].string), "gtwy")) {
      (yyval.intval) = 0x3;
    } else if (streq((yyvsp[0].string), "rc")) {
      (yyval.intval) = 0x5;
    } else if (streq((yyvsp[0].string), "btd")) {
      (yyval.intval) = 0x7;
    } else if (streq((yyvsp[0].string), "rta")) {
      (yyval.intval) = 0x8;
    } else {
      pBuilder->RecordParseError(CISAlineno, "unrecognized SFID");
    }
  }
#line 5630 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 346: /* RawSendgPayloadSize: SLASH IntExpPrim  */
#line 2811 "CISA.y"
                                      {(yyval.intval) = (yyvsp[0].intval);}
#line 5636 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 347: /* NullaryInstruction: CACHE_FLUSH_OP  */
#line 2815 "CISA.y"
    {
        pBuilder->CISA_create_NO_OPND_instruction((yyvsp[0].opcode), CISAlineno);
    }
#line 5644 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 348: /* NullaryInstruction: WAIT_OP VecSrcOperand_G_IMM  */
#line 2820 "CISA.y"
    {
        pBuilder->CISA_create_wait_instruction((yyvsp[0].genOperand).cisa_gen_opnd, CISAlineno);
    }
#line 5652 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 349: /* NullaryInstruction: YIELD_OP  */
#line 2825 "CISA.y"
    {
        pBuilder->CISA_create_yield_instruction((yyvsp[0].opcode), CISAlineno);
    }
#line 5660 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 350: /* NullaryInstruction: FENCE_GLOBAL_OP  */
#line 2830 "CISA.y"
    {
        pBuilder->CISA_create_fence_instruction((yyvsp[0].opcode), 0x0, CISAlineno);
    }
#line 5668 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 351: /* NullaryInstruction: FENCE_GLOBAL_OP FENCE_OPTIONS  */
#line 2835 "CISA.y"
    {
        pBuilder->CISA_create_fence_instruction((yyvsp[-1].opcode), (yyvsp[0].fence_options), CISAlineno);
    }
#line 5676 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 352: /* NullaryInstruction: FENCE_LOCAL_OP  */
#line 2840 "CISA.y"
    {
        pBuilder->CISA_create_fence_instruction((yyvsp[0].opcode), 0x20, CISAlineno);
    }
#line 5684 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 353: /* NullaryInstruction: FENCE_LOCAL_OP FENCE_OPTIONS  */
#line 2845 "CISA.y"
    {
        pBuilder->CISA_create_fence_instruction((yyvsp[-1].opcode), (yyvsp[0].fence_options) | 0x20, CISAlineno);
    }
#line 5692 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 354: /* NullaryInstruction: FENCE_SW_OP  */
#line 2850 "CISA.y"
    {
        pBuilder->CISA_create_fence_instruction((yyvsp[0].opcode), 0x80, CISAlineno);
    }
#line 5700 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 355: /* OwordModifier: %empty  */
#line 2854 "CISA.y"
                      {(yyval.oword_mod) = false;}
#line 5706 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 357: /* ShflIdx4Instruction: Predicate SHFL_IDX4_OP ExecSize RawOperand SrcGeneralOperand SrcGeneralOperand  */
#line 2859 "CISA.y"
    {
        pBuilder->CISA_create_shfl_idx4_instruction(
            (yyvsp[-5].pred_reg), (yyvsp[-4].opcode), (yyvsp[-3].emask_exec_size).emask, Get_VISA_Exec_Size_From_Raw_Size((yyvsp[-3].emask_exec_size).exec_size), (yyvsp[-2].RawVar),
            (yyvsp[-1].genOperand).cisa_gen_opnd, (yyvsp[0].genOperand).cisa_gen_opnd, CISAlineno);
    }
#line 5716 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 358: /* LfsrInstruction: Predicate LFSR_SUB_OP ExecSize VecDstOperand_G VecSrcOperand_G VecSrcOperand_G_IMM  */
#line 2868 "CISA.y"
    {
        pBuilder->CISA_create_lfsr_instruction(
            (yyvsp[-5].pred_reg), (yyvsp[-3].emask_exec_size).emask, Get_VISA_Exec_Size_From_Raw_Size((yyvsp[-3].emask_exec_size).exec_size), (yyvsp[-4].lfsr_fctrl),
            (yyvsp[-2].genOperand).cisa_gen_opnd, (yyvsp[-1].genOperand).cisa_gen_opnd, (yyvsp[0].genOperand).cisa_gen_opnd, CISAlineno);
    }
#line 5726 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 359: /* DnsclInstruction: Predicate DNSCL_OP ExecSize RawOperand RawOperand RawOperand RawOperand  */
#line 2877 "CISA.y"
    {
        pBuilder->CISA_create_dnscl_instruction(
            (yyvsp[-6].pred_reg), (yyvsp[-4].emask_exec_size).emask, Get_VISA_Exec_Size_From_Raw_Size((yyvsp[-4].emask_exec_size).exec_size), (yyvsp[-5].dnscl_info).type,
            (yyvsp[-5].dnscl_info).mode, (yyvsp[-5].dnscl_info).rnd_mode, (yyvsp[-3].RawVar), (yyvsp[-2].RawVar), (yyvsp[-1].RawVar), (yyvsp[0].RawVar), CISAlineno);
    }
#line 5736 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 360: /* Predicate: %empty  */
#line 2887 "CISA.y"
    {
        (yyval.pred_reg) = NULL;
    }
#line 5744 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 361: /* Predicate: LPAREN PredSign PredVar PredCtrlOpt RPAREN  */
#line 2892 "CISA.y"
    {
        (yyval.pred_reg) = pBuilder->CISA_create_predicate_operand((yyvsp[-2].vISADecl), (yyvsp[-3].pred_sign), (yyvsp[-1].pred_ctrl), CISAlineno);
    }
#line 5752 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 362: /* PredSign: %empty  */
#line 2896 "CISA.y"
                 {(yyval.pred_sign) = PredState_NO_INVERSE;}
#line 5758 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 363: /* PredSign: BANG  */
#line 2896 "CISA.y"
                                                     {(yyval.pred_sign) = PredState_INVERSE;}
#line 5764 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 364: /* PredCtrlOpt: %empty  */
#line 2898 "CISA.y"
                    {(yyval.pred_ctrl) = PRED_CTRL_NON;}
#line 5770 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 366: /* SatModOpt: %empty  */
#line 2901 "CISA.y"
                  {(yyval.sat) = false;}
#line 5776 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 367: /* SatModOpt: SAT  */
#line 2901 "CISA.y"
                                      {(yyval.sat) = true;}
#line 5782 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 368: /* SrcModifier: SRCMOD_NEG  */
#line 2904 "CISA.y"
                    {(yyval.src_mod).mod = MODIFIER_NEG;}
#line 5788 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 369: /* SrcModifier: SRCMOD_ABS  */
#line 2905 "CISA.y"
                    {(yyval.src_mod).mod = MODIFIER_ABS;}
#line 5794 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 370: /* SrcModifier: SRCMOD_NEGABS  */
#line 2906 "CISA.y"
                    {(yyval.src_mod).mod = MODIFIER_NEG_ABS;}
#line 5800 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 371: /* SrcModifier: SRCMOD_NOT  */
#line 2907 "CISA.y"
                    {(yyval.src_mod).mod = MODIFIER_NOT;}
#line 5806 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 372: /* ConditionalModifier: %empty  */
#line 2909 "CISA.y"
                            {(yyval.cond_mod) = ISA_CMP_UNDEF;}
#line 5812 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 374: /* VecDstOperand_A: DstAddrOperand  */
#line 2914 "CISA.y"
                                   {(yyval.genOperand) = (yyvsp[0].genOperand); (yyval.genOperand).type = OPERAND_ADDRESS;}
#line 5818 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 375: /* VecDstOperand_G: DstGeneralOperand  */
#line 2915 "CISA.y"
                                   {(yyval.genOperand) = (yyvsp[0].genOperand); (yyval.genOperand).type = OPERAND_GENERAL;}
#line 5824 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 376: /* VecDstOperand_G_I: DstGeneralOperand  */
#line 2917 "CISA.y"
                           {(yyval.genOperand) = (yyvsp[0].genOperand); (yyval.genOperand).type = OPERAND_GENERAL;}
#line 5830 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 377: /* VecDstOperand_G_I: DstIndirectOperand  */
#line 2918 "CISA.y"
                           {(yyval.genOperand) = (yyvsp[0].genOperand); (yyval.genOperand).type = OPERAND_INDIRECT;}
#line 5836 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 379: /* VecSrcOperand_G_I_IMM_A_AO: SrcAddrOfOperand  */
#line 2923 "CISA.y"
                           {(yyval.genOperand) = (yyvsp[0].genOperand); (yyval.genOperand).type = OPERAND_ADDRESSOF;}
#line 5842 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 381: /* VecSrcOperand_G_I_IMM_A: SrcAddrOperand  */
#line 2927 "CISA.y"
                           {(yyval.genOperand) = (yyvsp[0].genOperand); (yyval.genOperand).type = OPERAND_ADDRESS;}
#line 5848 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 383: /* VecSrcOperand_G_I_IMM: SrcIndirectOperand  */
#line 2931 "CISA.y"
                           {(yyval.genOperand) = (yyvsp[0].genOperand); (yyval.genOperand).type = OPERAND_INDIRECT;}
#line 5854 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 384: /* VecSrcOperand_G_I_IMM: SrcImmOperand  */
#line 2932 "CISA.y"
                           {(yyval.genOperand) = (yyvsp[0].genOperand); (yyval.genOperand).type = OPERAND_IMMEDIATE;}
#line 5860 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 386: /* VecSrcOperand_G_IMM: SrcImmOperand  */
#line 2936 "CISA.y"
                          {(yyval.genOperand) = (yyvsp[0].genOperand); (yyval.genOperand).type = OPERAND_IMMEDIATE;}
#line 5866 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 388: /* VecSrcOperand_G_IMM_AO: SrcImmOperand  */
#line 2940 "CISA.y"
                          {(yyval.genOperand) = (yyvsp[0].genOperand); (yyval.genOperand).type = OPERAND_IMMEDIATE;}
#line 5872 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 389: /* VecSrcOperand_G_IMM_AO: SrcAddrOfOperand  */
#line 2941 "CISA.y"
                          {(yyval.genOperand) = (yyvsp[0].genOperand); (yyval.genOperand).type = OPERAND_ADDRESSOF;}
#line 5878 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 391: /* VecSrcOperand_G_A: SrcAddrOperand  */
#line 2945 "CISA.y"
                          {(yyval.genOperand) = (yyvsp[0].genOperand); (yyval.genOperand).type = OPERAND_ADDRESS;}
#line 5884 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 393: /* VecSrcOperand_G_A_AO: SrcAddrOfOperand  */
#line 2949 "CISA.y"
                          {(yyval.genOperand) = (yyvsp[0].genOperand); (yyval.genOperand).type = OPERAND_ADDRESS;}
#line 5890 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 394: /* VecSrcOperand_G: SrcGeneralOperand  */
#line 2951 "CISA.y"
                                   {(yyval.genOperand) = (yyvsp[0].genOperand); (yyval.genOperand).type = OPERAND_GENERAL;}
#line 5896 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 395: /* VecSrcOpndSimple: Var TwoDimOffset  */
#line 2954 "CISA.y"
    {
        // simple vector operand with no modifier that has an
        // implicit src region = <1,1,0>
        (yyval.genOperand).type = OPERAND_GENERAL;
        ABORT_ON_FAIL((yyval.genOperand).cisa_gen_opnd = pBuilder->CISA_create_gen_src_operand(
            (yyvsp[-1].string), 1, 1, 0, (yyvsp[0].offset).row, (yyvsp[0].offset).elem, MODIFIER_NONE, CISAlineno));
    }
#line 5908 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 396: /* VMEOpndIME: LPAREN DEC_LIT COMMA DEC_LIT RPAREN  */
#line 2964 "CISA.y"
    {
        (yyval.vmeOpndIvb).streamMode = (unsigned char)(yyvsp[-3].intval);
        (yyval.vmeOpndIvb).searchCtrl = (unsigned char)(yyvsp[-1].intval);
    }
#line 5917 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 397: /* VMEOpndFBR: LPAREN VecSrcOperand_G_I_IMM COMMA VecSrcOperand_G_I_IMM COMMA VecSrcOperand_G_I_IMM RPAREN  */
#line 2971 "CISA.y"
    {
        (yyval.vmeOpndFbr).cisa_fbrMbMode_opnd = (yyvsp[-5].genOperand).cisa_gen_opnd;
        (yyval.vmeOpndFbr).cisa_fbrSubMbShape_opnd = (yyvsp[-3].genOperand).cisa_gen_opnd;
        (yyval.vmeOpndFbr).cisa_fbrSubPredMode_opnd = (yyvsp[-1].genOperand).cisa_gen_opnd;
    }
#line 5927 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 398: /* SrcStateOperand: Var LPAREN IntExp RPAREN  */
#line 2979 "CISA.y"
    {
        MUST_HOLD((yyvsp[-1].intval) < 0x100, "offset out of bounds");
        (yyval.StateVar).offset = (unsigned char)(yyvsp[-1].intval);
        ABORT_ON_FAIL((yyval.StateVar).cisa_gen_opnd = pBuilder->CISA_create_state_operand((yyvsp[-3].string), (unsigned char)(yyvsp[-1].intval), CISAlineno, false));
    }
#line 5937 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 399: /* DstStateOperand: Var LPAREN IntExp RPAREN  */
#line 2987 "CISA.y"
    {
        MUST_HOLD((yyvsp[-1].intval) < 0x100, "offset out of bounds");
        (yyval.StateVar).offset = (unsigned char)(yyvsp[-1].intval);
        ABORT_ON_FAIL((yyval.StateVar).cisa_gen_opnd = pBuilder->CISA_create_state_operand((yyvsp[-3].string), (unsigned char)(yyvsp[-1].intval), CISAlineno, true));
    }
#line 5947 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 401: /* RawOperand: BUILTIN_NULL DOT DEC_LIT  */
#line 3018 "CISA.y"
    {
        MUST_HOLD((yyvsp[0].intval) == 0, "%null must have 0 as offset");
        (yyval.RawVar) = pBuilder->CISA_create_RAW_NULL_operand(CISAlineno); // can't fail
    }
#line 5956 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 402: /* RawOperandNonNull: VarNonNull RawOperandOffsetSuffix  */
#line 3025 "CISA.y"
    {
        ABORT_ON_FAIL((yyval.RawVar) = pBuilder->CISA_create_RAW_operand((yyvsp[-1].string), (unsigned short)(yyvsp[0].intval), CISAlineno));
    }
#line 5964 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 403: /* RawOperandOffsetSuffix: DOT DEC_LIT  */
#line 3036 "CISA.y"
                {
        MUST_HOLD((yyvsp[0].intval) <= 0x10000, "offset out of bounds");
        (yyval.intval) = (yyvsp[0].intval);
    }
#line 5973 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 404: /* RawOperandOffsetSuffix: DOT LPAREN IntExp RPAREN  */
#line 3041 "CISA.y"
                             {
        MUST_HOLD((yyvsp[-1].intval) <= 0x10000, "offset out of bounds");
        (yyval.intval) = (yyvsp[-1].intval);
    }
#line 5982 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 405: /* RawOperandArray: %empty  */
#line 3049 "CISA.y"
    {
        (yyval.intval) = 0;
    }
#line 5990 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 406: /* RawOperandArray: RawOperandArray RawOperand  */
#line 3054 "CISA.y"
    {
        rawOperandArray[(yyvsp[-1].intval)++] = (VISA_RawOpnd*)(yyvsp[0].RawVar);
        (yyval.intval) = (yyvsp[-1].intval);
    }
#line 5999 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 407: /* DstAddrOperand: AddrVarAccessWithWidth  */
#line 3062 "CISA.y"
    {
        ABORT_ON_FAIL((yyval.genOperand).cisa_gen_opnd =
          pBuilder->CISA_set_address_operand(
            (yyvsp[0].regAccess).cisa_decl, (yyvsp[0].regAccess).elem, (yyvsp[0].regAccess).row, true, CISAlineno));
    }
#line 6009 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 408: /* DstGeneralOperand: Var TwoDimOffset DstRegion  */
#line 3070 "CISA.y"
    {
        ABORT_ON_FAIL((yyval.genOperand).cisa_gen_opnd = pBuilder->CISA_dst_general_operand(
            (yyvsp[-2].string), (yyvsp[-1].offset).row, (yyvsp[-1].offset).elem, (unsigned short)(yyvsp[0].intval), CISAlineno));
    }
#line 6018 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 409: /* DstGeneralOperand: Var DstRegion  */
#line 3075 "CISA.y"
                  {
        ABORT_ON_FAIL((yyval.genOperand).cisa_gen_opnd = pBuilder->CISA_dst_general_operand(
            (yyvsp[-1].string), 0, 0, (unsigned short)(yyvsp[0].intval), CISAlineno));
    }
#line 6027 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 410: /* DstIndirectOperand: IndirectVarAccess DstRegion DataType  */
#line 3081 "CISA.y"
    {
        ABORT_ON_FAIL((yyval.genOperand).cisa_gen_opnd = pBuilder->CISA_create_indirect_dst(
            (yyvsp[-2].regAccess).cisa_decl, MODIFIER_NONE, (yyvsp[-2].regAccess).row, (yyvsp[-2].regAccess).elem, (yyvsp[-2].regAccess).immOff, (unsigned short)(yyvsp[-1].intval), (yyvsp[0].type), CISAlineno));
    }
#line 6036 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 411: /* SrcAddrOfOperand: AddrOfVar  */
#line 3102 "CISA.y"
              {
         (yyval.genOperand).cisa_gen_opnd = pBuilder->CISA_set_address_expression((yyvsp[0].regAccess).cisa_decl, 0, CISAlineno);
    }
#line 6044 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 412: /* SrcAddrOfOperand: AddrOfVar LBRACK IntExp RBRACK  */
#line 3106 "CISA.y"
                                   {
         MUST_HOLD((short)(yyvsp[-1].intval) == (yyvsp[-1].intval), "variable address offset is too large");
         (yyval.genOperand).cisa_gen_opnd = pBuilder->CISA_set_address_expression((yyvsp[-3].regAccess).cisa_decl, (short)(yyvsp[-1].intval), CISAlineno);
    }
#line 6053 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 413: /* AddrOfVar: AMP Var  */
#line 3112 "CISA.y"
            {
        // Both GENERAL_VAR and SURFACE_VAR are addressable
        (yyval.regAccess).cisa_decl = pBuilder->CISA_find_decl((yyvsp[0].string));
        if ((yyval.regAccess).cisa_decl == nullptr)
            PARSE_ERROR("unbound variable");
        (yyval.regAccess).row = 0;
        (yyval.regAccess).elem = 0;
    }
#line 6066 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 414: /* SrcAddrOperand: AddrVarAccessWithWidth  */
#line 3123 "CISA.y"
    {
        ABORT_ON_FAIL((yyval.genOperand).cisa_gen_opnd =
            pBuilder->CISA_set_address_operand(
                (yyvsp[0].regAccess).cisa_decl, (yyvsp[0].regAccess).elem, (yyvsp[0].regAccess).row, false, CISAlineno));
    }
#line 6076 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 415: /* SrcGeneralOperand: Var TwoDimOffset SrcRegionDirect  */
#line 3131 "CISA.y"
    {
        ABORT_ON_FAIL((yyval.genOperand).cisa_gen_opnd =
            pBuilder->CISA_create_gen_src_operand(
                (yyvsp[-2].string), (yyvsp[0].cisa_region).v_stride, (yyvsp[0].cisa_region).width, (yyvsp[0].cisa_region).h_stride, (yyvsp[-1].offset).row, (yyvsp[-1].offset).elem, MODIFIER_NONE, CISAlineno));
    }
#line 6086 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 416: /* SrcGeneralOperand: SrcModifier Var TwoDimOffset SrcRegionDirect  */
#line 3138 "CISA.y"
    {
        ABORT_ON_FAIL((yyval.genOperand).cisa_gen_opnd =
            pBuilder->CISA_create_gen_src_operand(
                (yyvsp[-2].string), (yyvsp[0].cisa_region).v_stride, (yyvsp[0].cisa_region).width, (yyvsp[0].cisa_region).h_stride, (yyvsp[-1].offset).row, (yyvsp[-1].offset).elem, (yyvsp[-3].src_mod).mod, CISAlineno));
    }
#line 6096 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 417: /* SrcImmOperand: IntExpUnr DataTypeIntOrVector  */
#line 3148 "CISA.y"
    {
        (yyval.genOperand).cisa_gen_opnd = pBuilder->CISA_create_immed((yyvsp[-1].intval), (yyvsp[0].type), CISAlineno);
    }
#line 6104 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 418: /* SrcImmOperand: HEX_LIT HFTYPE  */
#line 3153 "CISA.y"
                     {
        MUST_HOLD((yyvsp[-1].intval) < 0x10000, "literal too large for half float");
        (yyval.genOperand).cisa_gen_opnd = pBuilder->CISA_create_immed(
            (unsigned short)(yyvsp[-1].intval), ISA_TYPE_HF, CISAlineno);
    }
#line 6114 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 419: /* SrcImmOperand: FloatLit  */
#line 3161 "CISA.y"
    {
        (yyval.genOperand).cisa_gen_opnd = pBuilder->CISA_create_float_immed((yyvsp[0].fltval), ISA_TYPE_F, CISAlineno);
    }
#line 6122 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 420: /* SrcImmOperand: MINUS FloatLit  */
#line 3164 "CISA.y"
                     {
        (yyval.genOperand).cisa_gen_opnd = pBuilder->CISA_create_float_immed(-(yyvsp[0].fltval), ISA_TYPE_F, CISAlineno);
    }
#line 6130 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 421: /* SrcImmOperand: DoubleFloatLit  */
#line 3170 "CISA.y"
    {
        (yyval.genOperand).cisa_gen_opnd = pBuilder->CISA_create_float_immed((yyvsp[0].fltval), ISA_TYPE_DF, CISAlineno);
    }
#line 6138 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 422: /* SrcImmOperand: MINUS DoubleFloatLit  */
#line 3174 "CISA.y"
    {
        (yyval.genOperand).cisa_gen_opnd = pBuilder->CISA_create_float_immed(-(yyvsp[0].fltval), ISA_TYPE_DF, CISAlineno);
    }
#line 6146 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 424: /* FloatLit: DEC_LIT FTYPE  */
#line 3181 "CISA.y"
   {
        // "1:f" means 1.4e-45
        int number = (int)(yyvsp[-1].intval);
        float *fp = (float *)&number;
        (yyval.fltval) = *fp;
   }
#line 6157 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 425: /* FloatLit: HEX_LIT FTYPE  */
#line 3188 "CISA.y"
   {
        int number = (int)(yyvsp[-1].intval);
        float *fp = (float *)&number;
        (yyval.fltval) = *fp;
   }
#line 6167 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 427: /* DoubleFloatLit: DEC_LIT DFTYPE  */
#line 3196 "CISA.y"
                    {
        // "1:df" means 5e-324
        int64_t number = (yyvsp[-1].intval);
        double *fp = (double *)&number;
        (yyval.fltval) = *fp;
   }
#line 6178 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 428: /* DoubleFloatLit: HEX_LIT DFTYPE  */
#line 3202 "CISA.y"
                    {
        // to support 0x7ff0000000000000:df
        int64_t number = (yyvsp[-1].intval);
        double *fp = (double *)&number;
        (yyval.fltval) = *fp;
   }
#line 6189 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 429: /* SrcIndirectOperand: IndirectVarAccess SrcRegionIndirect DataType  */
#line 3213 "CISA.y"
    {
        ABORT_ON_FAIL((yyval.genOperand).cisa_gen_opnd =
            pBuilder->CISA_create_indirect(
                (yyvsp[-2].regAccess).cisa_decl, MODIFIER_NONE, (yyvsp[-2].regAccess).row, (yyvsp[-2].regAccess).elem, (yyvsp[-2].regAccess).immOff,
                (yyvsp[-1].cisa_region).v_stride, (yyvsp[-1].cisa_region).width, (yyvsp[-1].cisa_region).h_stride, (yyvsp[0].type), CISAlineno));
    }
#line 6200 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 430: /* SrcIndirectOperand: SrcModifier IndirectVarAccess SrcRegionIndirect DataType  */
#line 3221 "CISA.y"
    {
        ABORT_ON_FAIL((yyval.genOperand).cisa_gen_opnd =
            pBuilder->CISA_create_indirect(
                (yyvsp[-2].regAccess).cisa_decl, (yyvsp[-3].src_mod).mod, (yyvsp[-2].regAccess).row, (yyvsp[-2].regAccess).elem, (yyvsp[-2].regAccess).immOff,
                (yyvsp[-1].cisa_region).v_stride, (yyvsp[-1].cisa_region).width, (yyvsp[-1].cisa_region).h_stride, (yyvsp[0].type), CISAlineno));
    }
#line 6211 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 431: /* DstRegion: LANGLE IntExpNRA RANGLE  */
#line 3230 "CISA.y"
    {
        MUST_HOLD(((yyvsp[-1].intval) == 0 || (yyvsp[-1].intval) == 1 || (yyvsp[-1].intval) == 2 || (yyvsp[-1].intval) == 4),
             "Dst HorzStride must be 0, 1, 2, or 4");
        (yyval.intval) = (yyvsp[-1].intval);
    }
#line 6221 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 432: /* SrcRegionDirect: LANGLE IntExp SEMI IntExp COMMA IntExpNRA RANGLE  */
#line 3248 "CISA.y"
    {
        MUST_HOLD(((yyvsp[-5].intval) == 0 || (yyvsp[-5].intval) == 1 || (yyvsp[-5].intval) == 2 || (yyvsp[-5].intval) == 4 || (yyvsp[-5].intval) == 8 || (yyvsp[-5].intval) == 16 || (yyvsp[-5].intval) == 32),
                 "Src Region VertStride must be 0, 1, 2, 4, 8, 16, or 32");
        MUST_HOLD(((yyvsp[-3].intval) == 0 || (yyvsp[-3].intval) == 1 || (yyvsp[-3].intval) == 2 || (yyvsp[-3].intval) == 4 || (yyvsp[-3].intval) == 8 || (yyvsp[-3].intval) == 16),
                 "Src Region Width must be 0, 1, 2, 4, 8 or 16");
        MUST_HOLD(((yyvsp[-1].intval) == 0 || (yyvsp[-1].intval) == 1 || (yyvsp[-1].intval) == 2 || (yyvsp[-1].intval) == 4),
                 "Src Region HorzStride must be 0, 1, 2, or 4");
        (yyval.cisa_region).v_stride = (unsigned)(yyvsp[-5].intval);
        (yyval.cisa_region).width = (unsigned)(yyvsp[-3].intval);
        (yyval.cisa_region).h_stride = (unsigned)(yyvsp[-1].intval);
    }
#line 6237 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 434: /* SrcRegionIndirect: LANGLE IntExp COMMA DEC_LIT RANGLE  */
#line 3265 "CISA.y"
    {
        MUST_HOLD(((yyvsp[-3].intval) == 0 || (yyvsp[-3].intval) == 1 || (yyvsp[-3].intval) == 2 || (yyvsp[-3].intval) == 4 || (yyvsp[-3].intval) == 8 || (yyvsp[-3].intval) == 16),
                 "Width must be 0, 1, 2, 4, 8 or 16");
        MUST_HOLD(((yyvsp[-1].intval) == 0 || (yyvsp[-1].intval) == 1 || (yyvsp[-1].intval) == 2 || (yyvsp[-1].intval) == 4),
                 "HorzStride must be 0, 1, 2, or 4");
        (yyval.cisa_region).v_stride = -1;
        (yyval.cisa_region).width = (unsigned)(yyvsp[-3].intval);
        (yyval.cisa_region).h_stride = (unsigned)(yyvsp[-1].intval);
    }
#line 6251 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 435: /* SrcRegionIndirect: LANGLE IntExpNRA RANGLE  */
#line 3276 "CISA.y"
    {
        MUST_HOLD(((yyvsp[-1].intval) == 0 || (yyvsp[-1].intval) == 1 || (yyvsp[-1].intval) == 2 || (yyvsp[-1].intval) == 4),
             "HorzStride must be 0, 1, 2, or 4");
        (yyval.cisa_region).v_stride = -1;
        (yyval.cisa_region).width = -1;
        (yyval.cisa_region).h_stride = (unsigned)(yyvsp[-1].intval);
    }
#line 6263 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 436: /* IndirectVarAccess: IND_LBRACK AddrVarAccess COMMA IntExp RBRACK  */
#line 3286 "CISA.y"
                                                 {
        (yyval.regAccess) = (yyvsp[-3].regAccess);
        (yyval.regAccess).immOff = (int)(yyvsp[-1].intval);
    }
#line 6272 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 437: /* IndirectVarAccess: IND_LBRACK AddrVarAccess RBRACK  */
#line 3291 "CISA.y"
                                                 {
          (yyval.regAccess) = (yyvsp[-1].regAccess);
          (yyval.regAccess).immOff = 0;
    }
#line 6281 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 438: /* TwoDimOffset: LPAREN IntExp COMMA IntExp RPAREN  */
#line 3296 "CISA.y"
                                                {
        MUST_HOLD((yyvsp[-3].intval) >= 0, "row (register) offset must be positive");
        (yyval.offset).row = (int)(yyvsp[-3].intval);
        MUST_HOLD((yyvsp[-1].intval) >= 0 && (yyvsp[-1].intval) <= 0xFFFF, "sub-register offset out of bounds");
        (yyval.offset).elem = (int)(yyvsp[-1].intval);
    }
#line 6292 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 439: /* PredVar: Var  */
#line 3304 "CISA.y"
        {
        (yyval.vISADecl) = pBuilder->CISA_find_decl((yyvsp[0].string));
        if ((yyval.vISADecl) == nullptr)
            PARSE_ERROR((yyvsp[0].string), ": undefined predicate variable");
        if ((yyval.vISADecl)->type != PREDICATE_VAR)
            PARSE_ERROR((yyvsp[0].string), ": not a predicate variable");
    }
#line 6304 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 440: /* AddrVarAccess: Var LPAREN IntExp RPAREN  */
#line 3313 "CISA.y"
                             {
        (yyval.regAccess).cisa_decl = pBuilder->CISA_find_decl((yyvsp[-3].string));
        if ((yyval.regAccess).cisa_decl == nullptr) {
            PARSE_ERROR((yyvsp[-3].string), ": unbound variable");
        } else if ((yyval.regAccess).cisa_decl->type != ADDRESS_VAR) {
            PARSE_ERROR((yyvsp[-3].string), ": not an address variable");
        }
        (yyval.regAccess).row = 1;
        (yyval.regAccess).elem = (int)(yyvsp[-1].intval);
    }
#line 6319 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 441: /* AddrVarAccessWithWidth: Var LPAREN IntExp RPAREN LANGLE IntExpNRA RANGLE  */
#line 3325 "CISA.y"
                                                     {
        (yyval.regAccess).cisa_decl = pBuilder->CISA_find_decl((yyvsp[-6].string));
        if ((yyval.regAccess).cisa_decl == nullptr) {
            PARSE_ERROR((yyvsp[-6].string), ": unbound variable");
        } else if ((yyval.regAccess).cisa_decl->type != ADDRESS_VAR) {
            PARSE_ERROR((yyvsp[-6].string), ": not an address variable");
        }
        (yyval.regAccess).row = (int)(yyvsp[-1].intval);
        (yyval.regAccess).elem = (int)(yyvsp[-4].intval);
    }
#line 6334 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 442: /* SIMDMode: %empty  */
#line 3339 "CISA.y"
           {(yyval.intval) = 0;}
#line 6340 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 443: /* SIMDMode: LPAREN DEC_LIT RPAREN  */
#line 3342 "CISA.y"
    {
       MUST_HOLD(((yyvsp[-1].intval) == 8 || (yyvsp[-1].intval) == 16 || (yyvsp[-1].intval) == 32),
                 "SIMD mode can only be 8, 16, or 32");
       (yyval.intval) = (yyvsp[-1].intval);
    }
#line 6350 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 444: /* ElemNum: DOT DEC_LIT  */
#line 3353 "CISA.y"
    {
        (yyval.intval) = (yyvsp[0].intval);
    }
#line 6358 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 445: /* ExecSize: LPAREN ExecSizeInt RPAREN  */
#line 3365 "CISA.y"
    {
        (yyval.emask_exec_size).emask = vISA_EMASK_M1;
        (yyval.emask_exec_size).exec_size = (int)(yyvsp[-1].intval);
    }
#line 6367 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 446: /* ExecSize: LPAREN Var COMMA ExecSizeInt RPAREN  */
#line 3371 "CISA.y"
    {
        if (!ParseEMask((yyvsp[-3].string), (yyval.emask_exec_size).emask)) {
            PARSE_ERROR("invalid execution offset info");
        }
        (yyval.emask_exec_size).exec_size = (int)(yyvsp[-1].intval);
    }
#line 6378 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 447: /* ExecSizeInt: DEC_LIT  */
#line 3379 "CISA.y"
    {
        if ((yyvsp[0].intval) != 1 && (yyvsp[0].intval) != 2 && (yyvsp[0].intval) != 4 && (yyvsp[0].intval) != 8 && (yyvsp[0].intval) != 16 && (yyvsp[0].intval) != 32) {
            PARSE_ERROR("invalid execution size");
        }
        (yyval.intval) = (unsigned short)(yyvsp[0].intval);
    }
#line 6389 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 453: /* IntExpCond: IntExpAND QUESTION IntExpAND COLON IntExpCond  */
#line 3393 "CISA.y"
                                                    {(yyval.intval) = (yyvsp[-4].intval) ? (yyvsp[-2].intval) : (yyvsp[0].intval);}
#line 6395 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 455: /* IntExpAND: IntExpAND AMP IntExpXOR  */
#line 3396 "CISA.y"
                               {(yyval.intval) = (yyvsp[-2].intval) & (yyvsp[0].intval);}
#line 6401 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 457: /* IntExpXOR: IntExpXOR CIRC IntExpOR  */
#line 3399 "CISA.y"
                               {(yyval.intval) = (yyvsp[-2].intval) ^ (yyvsp[0].intval);}
#line 6407 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 459: /* IntExpOR: IntExpOR PIPE IntExpCmp  */
#line 3402 "CISA.y"
                                {(yyval.intval) = (yyvsp[-2].intval) | (yyvsp[0].intval);}
#line 6413 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 461: /* IntExpCmp: IntExpRel EQ IntExpRel  */
#line 3405 "CISA.y"
                               {(yyval.intval) = (yyvsp[-2].intval) == (yyvsp[0].intval);}
#line 6419 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 462: /* IntExpCmp: IntExpRel NEQ IntExpRel  */
#line 3406 "CISA.y"
                               {(yyval.intval) = (yyvsp[-2].intval) != (yyvsp[0].intval);}
#line 6425 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 464: /* IntExpRel: IntExpNRA LANGLE IntExpNRA  */
#line 3409 "CISA.y"
                                 {(yyval.intval) = (yyvsp[-2].intval) < (yyvsp[0].intval);}
#line 6431 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 465: /* IntExpRel: IntExpNRA RANGLE IntExpNRA  */
#line 3410 "CISA.y"
                                 {(yyval.intval) = (yyvsp[-2].intval) > (yyvsp[0].intval);}
#line 6437 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 466: /* IntExpRel: IntExpNRA LEQ IntExpNRA  */
#line 3411 "CISA.y"
                                 {(yyval.intval) = (yyvsp[-2].intval) <= (yyvsp[0].intval);}
#line 6443 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 467: /* IntExpRel: IntExpNRA GEQ IntExpNRA  */
#line 3412 "CISA.y"
                                 {(yyval.intval) = (yyvsp[-2].intval) >= (yyvsp[0].intval);}
#line 6449 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 470: /* IntExpShift: IntExpAdd SHL IntExpAdd  */
#line 3435 "CISA.y"
                               {(yyval.intval) = (yyvsp[-2].intval) << (yyvsp[0].intval);}
#line 6455 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 471: /* IntExpShift: IntExpAdd SHRS IntExpAdd  */
#line 3436 "CISA.y"
                               {(yyval.intval) = (int64_t)(yyvsp[-2].intval) >> (int)(yyvsp[0].intval);}
#line 6461 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 472: /* IntExpShift: IntExpAdd SHRZ IntExpAdd  */
#line 3437 "CISA.y"
                               {(yyval.intval) = (int64_t)((uint64_t)(yyvsp[-2].intval) >> (uint64_t)(yyvsp[0].intval));}
#line 6467 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 474: /* IntExpAdd: IntExpAdd PLUS IntExpMul  */
#line 3440 "CISA.y"
                                {(yyval.intval) = (yyvsp[-2].intval) + (yyvsp[0].intval);}
#line 6473 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 475: /* IntExpAdd: IntExpAdd MINUS IntExpMul  */
#line 3441 "CISA.y"
                                {(yyval.intval) = (yyvsp[-2].intval) - (yyvsp[0].intval);}
#line 6479 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 477: /* IntExpMul: IntExpMul TIMES IntExpUnr  */
#line 3444 "CISA.y"
                                {(yyval.intval) = (yyvsp[-2].intval) * (yyvsp[0].intval);}
#line 6485 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 478: /* IntExpMul: IntExpMul SLASH IntExpUnr  */
#line 3445 "CISA.y"
                                {
            if ((yyvsp[0].intval) == 0)
                PARSE_ERROR("division by 0");
            (yyval.intval) = (yyvsp[-2].intval) / (yyvsp[0].intval);
        }
#line 6495 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 479: /* IntExpMul: IntExpMul PERCENT IntExpUnr  */
#line 3450 "CISA.y"
                                  {
            if ((yyvsp[0].intval) == 0)
                PARSE_ERROR("division by 0");
            (yyval.intval) = (yyvsp[-2].intval) % (yyvsp[0].intval);
        }
#line 6505 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 481: /* IntExpUnr: MINUS IntExpUnr  */
#line 3457 "CISA.y"
                      {(yyval.intval) = -(yyvsp[0].intval);}
#line 6511 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 482: /* IntExpUnr: TILDE IntExpUnr  */
#line 3458 "CISA.y"
                      {(yyval.intval) = ~(yyvsp[0].intval);}
#line 6517 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 483: /* IntExpUnr: BANG IntExpUnr  */
#line 3459 "CISA.y"
                      {(yyval.intval) = !((yyvsp[0].intval));}
#line 6523 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 487: /* IntExpPrim: LPAREN IntExp RPAREN  */
#line 3467 "CISA.y"
                           {(yyval.intval) = (yyvsp[-1].intval);}
#line 6529 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 488: /* IntExpPrim: BUILTIN_SIZEOF IDENT  */
#line 3471 "CISA.y"
                           {
        (yyval.intval) = 0;
        ABORT_ON_FAIL(pBuilder->CISA_eval_sizeof_decl(CISAlineno, (yyvsp[0].string), (yyval.intval)));
    }
#line 6538 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 489: /* IntExpPrim: BUILTIN_SIZEOF LPAREN IDENT RPAREN  */
#line 3475 "CISA.y"
                                         {
        // TODO: %AlignOf(...), %Max(..)
        (yyval.intval) = 0;
        ABORT_ON_FAIL(pBuilder->CISA_eval_sizeof_decl(CISAlineno, (yyvsp[-1].string), (yyval.intval)));
    }
#line 6548 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 490: /* IntExpPrim: BUILTIN_DISPATCH_SIMD_SIZE  */
#line 3481 "CISA.y"
                                 {
        // e.g. %DispatchSimdSize
        // N.B. %sizeof happens above
        (yyval.intval) = 0;
        ABORT_ON_FAIL(pBuilder->CISA_lookup_builtin_constant(CISAlineno, "%DispatchSimd", (yyval.intval)));
    }
#line 6559 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;

  case 498: /* BuildOptions: BUILD_OPTION_LINE  */
#line 3501 "CISA.y"
    {
        pBuilder->CISA_parse_build_options((yyvsp[0].string));
    }
#line 6567 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"
    break;


#line 6571 "/build/intel-graphics-compiler/src/build/IGC/visa/CISA.tab.cpp"

      default: break;
    }
  /* User semantic actions sometimes alter yychar, and that requires
     that yytoken be updated with the new translation.  We take the
     approach of translating immediately before every use of yytoken.
     One alternative is translating here after every semantic action,
     but that translation would be missed if the semantic action invokes
     YYABORT, YYACCEPT, or YYERROR immediately after altering yychar or
     if it invokes YYBACKUP.  In the case of YYABORT or YYACCEPT, an
     incorrect destructor might then be invoked immediately.  In the
     case of YYERROR or YYBACKUP, subsequent parser actions might lead
     to an incorrect destructor call or verbose syntax error message
     before the lookahead is translated.  */
  YY_SYMBOL_PRINT ("-> $$ =", YY_CAST (yysymbol_kind_t, yyr1[yyn]), &yyval, &yyloc);

  YYPOPSTACK (yylen);
  yylen = 0;

  *++yyvsp = yyval;

  /* Now 'shift' the result of the reduction.  Determine what state
     that goes to, based on the state we popped back to and the rule
     number reduced by.  */
  {
    const int yylhs = yyr1[yyn] - YYNTOKENS;
    const int yyi = yypgoto[yylhs] + *yyssp;
    yystate = (0 <= yyi && yyi <= YYLAST && yycheck[yyi] == *yyssp
               ? yytable[yyi]
               : yydefgoto[yylhs]);
  }

  goto yynewstate;


/*--------------------------------------.
| yyerrlab -- here on detecting error.  |
`--------------------------------------*/
yyerrlab:
  /* Make sure we have latest lookahead translation.  See comments at
     user semantic actions for why this is necessary.  */
  yytoken = yychar == YYEMPTY ? YYSYMBOL_YYEMPTY : YYTRANSLATE (yychar);
  /* If not already recovering from an error, report this error.  */
  if (!yyerrstatus)
    {
      ++yynerrs;
      {
        yypcontext_t yyctx
          = {yyssp, yytoken};
        char const *yymsgp = YY_("syntax error");
        int yysyntax_error_status;
        yysyntax_error_status = yysyntax_error (&yymsg_alloc, &yymsg, &yyctx);
        if (yysyntax_error_status == 0)
          yymsgp = yymsg;
        else if (yysyntax_error_status == -1)
          {
            if (yymsg != yymsgbuf)
              YYSTACK_FREE (yymsg);
            yymsg = YY_CAST (char *,
                             YYSTACK_ALLOC (YY_CAST (YYSIZE_T, yymsg_alloc)));
            if (yymsg)
              {
                yysyntax_error_status
                  = yysyntax_error (&yymsg_alloc, &yymsg, &yyctx);
                yymsgp = yymsg;
              }
            else
              {
                yymsg = yymsgbuf;
                yymsg_alloc = sizeof yymsgbuf;
                yysyntax_error_status = YYENOMEM;
              }
          }
        yyerror (pBuilder, yymsgp);
        if (yysyntax_error_status == YYENOMEM)
          YYNOMEM;
      }
    }

  if (yyerrstatus == 3)
    {
      /* If just tried and failed to reuse lookahead token after an
         error, discard it.  */

      if (yychar <= YYEOF)
        {
          /* Return failure if at end of input.  */
          if (yychar == YYEOF)
            YYABORT;
        }
      else
        {
          yydestruct ("Error: discarding",
                      yytoken, &yylval, pBuilder);
          yychar = YYEMPTY;
        }
    }

  /* Else will try to reuse lookahead token after shifting the error
     token.  */
  goto yyerrlab1;


/*---------------------------------------------------.
| yyerrorlab -- error raised explicitly by YYERROR.  |
`---------------------------------------------------*/
yyerrorlab:
  /* Pacify compilers when the user code never invokes YYERROR and the
     label yyerrorlab therefore never appears in user code.  */
  if (0)
    YYERROR;
  ++yynerrs;

  /* Do not reclaim the symbols of the rule whose action triggered
     this YYERROR.  */
  YYPOPSTACK (yylen);
  yylen = 0;
  YY_STACK_PRINT (yyss, yyssp);
  yystate = *yyssp;
  goto yyerrlab1;


/*-------------------------------------------------------------.
| yyerrlab1 -- common code for both syntax error and YYERROR.  |
`-------------------------------------------------------------*/
yyerrlab1:
  yyerrstatus = 3;      /* Each real token shifted decrements this.  */

  /* Pop stack until we find a state that shifts the error token.  */
  for (;;)
    {
      yyn = yypact[yystate];
      if (!yypact_value_is_default (yyn))
        {
          yyn += YYSYMBOL_YYerror;
          if (0 <= yyn && yyn <= YYLAST && yycheck[yyn] == YYSYMBOL_YYerror)
            {
              yyn = yytable[yyn];
              if (0 < yyn)
                break;
            }
        }

      /* Pop the current state because it cannot handle the error token.  */
      if (yyssp == yyss)
        YYABORT;


      yydestruct ("Error: popping",
                  YY_ACCESSING_SYMBOL (yystate), yyvsp, pBuilder);
      YYPOPSTACK (1);
      yystate = *yyssp;
      YY_STACK_PRINT (yyss, yyssp);
    }

  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  *++yyvsp = yylval;
  YY_IGNORE_MAYBE_UNINITIALIZED_END


  /* Shift the error token.  */
  YY_SYMBOL_PRINT ("Shifting", YY_ACCESSING_SYMBOL (yyn), yyvsp, yylsp);

  yystate = yyn;
  goto yynewstate;


/*-------------------------------------.
| yyacceptlab -- YYACCEPT comes here.  |
`-------------------------------------*/
yyacceptlab:
  yyresult = 0;
  goto yyreturnlab;


/*-----------------------------------.
| yyabortlab -- YYABORT comes here.  |
`-----------------------------------*/
yyabortlab:
  yyresult = 1;
  goto yyreturnlab;


/*-----------------------------------------------------------.
| yyexhaustedlab -- YYNOMEM (memory exhaustion) comes here.  |
`-----------------------------------------------------------*/
yyexhaustedlab:
  yyerror (pBuilder, YY_("memory exhausted"));
  yyresult = 2;
  goto yyreturnlab;


/*----------------------------------------------------------.
| yyreturnlab -- parsing is finished, clean up and return.  |
`----------------------------------------------------------*/
yyreturnlab:
  if (yychar != YYEMPTY)
    {
      /* Make sure we have latest lookahead translation.  See comments at
         user semantic actions for why this is necessary.  */
      yytoken = YYTRANSLATE (yychar);
      yydestruct ("Cleanup: discarding lookahead",
                  yytoken, &yylval, pBuilder);
    }
  /* Do not reclaim the symbols of the rule whose action triggered
     this YYABORT or YYACCEPT.  */
  YYPOPSTACK (yylen);
  YY_STACK_PRINT (yyss, yyssp);
  while (yyssp != yyss)
    {
      yydestruct ("Cleanup: popping",
                  YY_ACCESSING_SYMBOL (+*yyssp), yyvsp, pBuilder);
      YYPOPSTACK (1);
    }
#ifndef yyoverflow
  if (yyss != yyssa)
    YYSTACK_FREE (yyss);
#endif
  if (yymsg != yymsgbuf)
    YYSTACK_FREE (yymsg);
  return yyresult;
}

#line 3506 "CISA.y"

///////////////////////////////////////////////////////////////////////////////
//                                                                           //
//                        Utility Functions                                  //
//                                                                           //
///////////////////////////////////////////////////////////////////////////////

void CISAerror(CISA_IR_Builder* pBuilder, char const *s)
{
    pBuilder->RecordParseError(CISAlineno, s);
}

static bool streq(const char *sym0, const char *sym1)
{
  return strcmp(sym0, sym1) == 0;
}

static bool ParseAlign(CISA_IR_Builder* pBuilder, const char *sym, VISA_Align &value)
{
    if (strcmp(sym, "byte") == 0) {
        value = ALIGN_BYTE;
    } else if (strcmp(sym, "word") == 0) {
        value = ALIGN_WORD;
    } else if (strcmp(sym, "dword") == 0) {
        value = ALIGN_DWORD;
    } else if (strcmp(sym, "qword") == 0) {
        value = ALIGN_QWORD;
    } else if (strcmp(sym, "oword") == 0) {
        value = ALIGN_OWORD;
    } else if (strcmp(sym, "GRF") == 0) {
        value = ALIGN_GRF;
    } else if (strcmp(sym, "GRFx2") == 0 || strcmp(sym, "2GRF") == 0) {
        value = ALIGN_2_GRF;
    } else if (strcmp(sym, "hword") == 0) {
        value = ALIGN_HWORD;
    } else if (strcmp(sym, "wordx32") == 0) {
        value = ALIGN_32WORD;
    } else if (strcmp(sym, "wordx64") == 0) {
        value = ALIGN_64WORD;
    } else {
        value = ALIGN_UNDEF;
        return false;
    }
    return true;
}


static bool AlignBytesToVisaAlignment(int bytes, VISA_Align &val)
{
    switch (bytes) {
    case 1:   val = ALIGN_BYTE; break;
    case 2:   val = ALIGN_WORD; break;
    case 4:   val = ALIGN_DWORD; break;
    case 8:   val = ALIGN_QWORD; break;
    case 16:  val = ALIGN_OWORD; break;
    case 32:  val = ALIGN_HWORD; break;
    case 64:  val = ALIGN_32WORD; break;
    case 128: val = ALIGN_64WORD; break;
    default:  val = ALIGN_UNDEF; return false;
    }
    return true;
}



static bool ParseEMask(
    const char* sym,
    VISA_EMask_Ctrl &emask)
{
    if (strcmp(sym, "NoMask") == 0) {
        emask = vISA_EMASK_M1_NM;
        return true;
    }
    for (int i = 0; i < vISA_NUM_EMASK +1; i++)
    {
        if (!strcmp(emask_str[i], sym))
        {
            emask = (VISA_EMask_Ctrl)i;
            return true;
        }
    }

    emask = vISA_NUM_EMASK;
    return false;
}

static int lscCheckExecSize(
    CISA_IR_Builder* pBuilder,
    LSC_SFID sfid,
    LSC_OP op,
    LSC_DATA_ORDER data_order,
    int exec_size)
{
    int is_vector_op =
        op != LSC_LOAD_BLOCK2D &&
        op != LSC_STORE_BLOCK2D;
        // other ops like LSC_LOAD_SURFACE_INFO may be SIMD1
    if (op == LSC_READ_STATE_INFO) {
        exec_size = 1;
    } else if (data_order == LSC_DATA_ORDER_NONTRANSPOSE && is_vector_op) {
        if (exec_size == UNDEFINED_EXEC_SIZE) {
            if (pBuilder->getPlatform() == Xe_DG2) // for DG2 typed is 8, untyped is 16
                exec_size = sfid == LSC_TGM ? 8 : 16;
            else if (pBuilder->getPlatform() >= Xe_PVC) // on PVC typed is 16, untyped is 32
                exec_size = sfid == LSC_TGM ? 16 : 32;
            else
                exec_size = 32; // the world is finally sane
        }
    } else {
        // block and transpose get SIMD by default
        if (exec_size == UNDEFINED_EXEC_SIZE) {
           exec_size = 1; // transpose is implicitly 1 if needed
        }
    }
    return exec_size;
}
