{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- Virtual table for handling subtrees registered with 'GI.Gio.Objects.DBusConnection.dBusConnectionRegisterSubtree'.
-- 
-- /Since: 2.26/

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gio.Structs.DBusSubtreeVTable
    ( 

-- * Exported types
    DBusSubtreeVTable(..)                   ,
    newZeroDBusSubtreeVTable                ,


 -- * Methods

#if defined(ENABLE_OVERLOADING)
    ResolveDBusSubtreeVTableMethod          ,
#endif



 -- * Properties


-- ** dispatch #attr:dispatch#
-- | Function for dispatching a remote call on a child node.

    clearDBusSubtreeVTableDispatch          ,
#if defined(ENABLE_OVERLOADING)
    dBusSubtreeVTable_dispatch              ,
#endif
    getDBusSubtreeVTableDispatch            ,
    setDBusSubtreeVTableDispatch            ,


-- ** enumerate #attr:enumerate#
-- | Function for enumerating child nodes.

    clearDBusSubtreeVTableEnumerate         ,
#if defined(ENABLE_OVERLOADING)
    dBusSubtreeVTable_enumerate             ,
#endif
    getDBusSubtreeVTableEnumerate           ,
    setDBusSubtreeVTableEnumerate           ,


-- ** introspect #attr:introspect#
-- | Function for introspecting a child node.

    clearDBusSubtreeVTableIntrospect        ,
#if defined(ENABLE_OVERLOADING)
    dBusSubtreeVTable_introspect            ,
#endif
    getDBusSubtreeVTableIntrospect          ,
    setDBusSubtreeVTableIntrospect          ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.Gio.Callbacks as Gio.Callbacks

#else
import qualified GI.Gio.Callbacks as Gio.Callbacks

#endif

-- | Memory-managed wrapper type.
newtype DBusSubtreeVTable = DBusSubtreeVTable (SP.ManagedPtr DBusSubtreeVTable)
    deriving (Eq)

instance SP.ManagedPtrNewtype DBusSubtreeVTable where
    toManagedPtr (DBusSubtreeVTable p) = p

instance BoxedPtr DBusSubtreeVTable where
    boxedPtrCopy = \p -> B.ManagedPtr.withManagedPtr p (copyBytes 88 >=> B.ManagedPtr.wrapPtr DBusSubtreeVTable)
    boxedPtrFree = \x -> SP.withManagedPtr x SP.freeMem
instance CallocPtr DBusSubtreeVTable where
    boxedPtrCalloc = callocBytes 88


-- | Construct a t'DBusSubtreeVTable' struct initialized to zero.
newZeroDBusSubtreeVTable :: MonadIO m => m DBusSubtreeVTable
newZeroDBusSubtreeVTable = liftIO $ boxedPtrCalloc >>= wrapPtr DBusSubtreeVTable

instance tag ~ 'AttrSet => Constructible DBusSubtreeVTable tag where
    new _ attrs = do
        o <- newZeroDBusSubtreeVTable
        GI.Attributes.set o attrs
        return o


-- | Get the value of the “@enumerate@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' dBusSubtreeVTable #enumerate
-- @
getDBusSubtreeVTableEnumerate :: MonadIO m => DBusSubtreeVTable -> m (Maybe Gio.Callbacks.DBusSubtreeEnumerateFunc_WithClosures)
getDBusSubtreeVTableEnumerate s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 0) :: IO (FunPtr Gio.Callbacks.C_DBusSubtreeEnumerateFunc)
    result <- SP.convertFunPtrIfNonNull val $ \val' -> do
        let val'' = Gio.Callbacks.dynamic_DBusSubtreeEnumerateFunc val'
        return val''
    return result

-- | Set the value of the “@enumerate@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' dBusSubtreeVTable [ #enumerate 'Data.GI.Base.Attributes.:=' value ]
-- @
setDBusSubtreeVTableEnumerate :: MonadIO m => DBusSubtreeVTable -> FunPtr Gio.Callbacks.C_DBusSubtreeEnumerateFunc -> m ()
setDBusSubtreeVTableEnumerate s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 0) (val :: FunPtr Gio.Callbacks.C_DBusSubtreeEnumerateFunc)

-- | Set the value of the “@enumerate@” field to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #enumerate
-- @
clearDBusSubtreeVTableEnumerate :: MonadIO m => DBusSubtreeVTable -> m ()
clearDBusSubtreeVTableEnumerate s = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 0) (FP.nullFunPtr :: FunPtr Gio.Callbacks.C_DBusSubtreeEnumerateFunc)

#if defined(ENABLE_OVERLOADING)
data DBusSubtreeVTableEnumerateFieldInfo
instance AttrInfo DBusSubtreeVTableEnumerateFieldInfo where
    type AttrBaseTypeConstraint DBusSubtreeVTableEnumerateFieldInfo = (~) DBusSubtreeVTable
    type AttrAllowedOps DBusSubtreeVTableEnumerateFieldInfo = '[ 'AttrSet, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint DBusSubtreeVTableEnumerateFieldInfo = (~) (FunPtr Gio.Callbacks.C_DBusSubtreeEnumerateFunc)
    type AttrTransferTypeConstraint DBusSubtreeVTableEnumerateFieldInfo = (~)Gio.Callbacks.DBusSubtreeEnumerateFunc_WithClosures
    type AttrTransferType DBusSubtreeVTableEnumerateFieldInfo = (FunPtr Gio.Callbacks.C_DBusSubtreeEnumerateFunc)
    type AttrGetType DBusSubtreeVTableEnumerateFieldInfo = Maybe Gio.Callbacks.DBusSubtreeEnumerateFunc_WithClosures
    type AttrLabel DBusSubtreeVTableEnumerateFieldInfo = "enumerate"
    type AttrOrigin DBusSubtreeVTableEnumerateFieldInfo = DBusSubtreeVTable
    attrGet = getDBusSubtreeVTableEnumerate
    attrSet = setDBusSubtreeVTableEnumerate
    attrConstruct = undefined
    attrClear = clearDBusSubtreeVTableEnumerate
    attrTransfer _ v = do
        Gio.Callbacks.mk_DBusSubtreeEnumerateFunc (Gio.Callbacks.wrap_DBusSubtreeEnumerateFunc Nothing v)
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Structs.DBusSubtreeVTable.enumerate"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Structs-DBusSubtreeVTable.html#g:attr:enumerate"
        })

dBusSubtreeVTable_enumerate :: AttrLabelProxy "enumerate"
dBusSubtreeVTable_enumerate = AttrLabelProxy

#endif


-- | Get the value of the “@introspect@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' dBusSubtreeVTable #introspect
-- @
getDBusSubtreeVTableIntrospect :: MonadIO m => DBusSubtreeVTable -> m (Maybe Gio.Callbacks.DBusSubtreeIntrospectFunc_WithClosures)
getDBusSubtreeVTableIntrospect s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 8) :: IO (FunPtr Gio.Callbacks.C_DBusSubtreeIntrospectFunc)
    result <- SP.convertFunPtrIfNonNull val $ \val' -> do
        let val'' = Gio.Callbacks.dynamic_DBusSubtreeIntrospectFunc val'
        return val''
    return result

-- | Set the value of the “@introspect@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' dBusSubtreeVTable [ #introspect 'Data.GI.Base.Attributes.:=' value ]
-- @
setDBusSubtreeVTableIntrospect :: MonadIO m => DBusSubtreeVTable -> FunPtr Gio.Callbacks.C_DBusSubtreeIntrospectFunc -> m ()
setDBusSubtreeVTableIntrospect s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 8) (val :: FunPtr Gio.Callbacks.C_DBusSubtreeIntrospectFunc)

-- | Set the value of the “@introspect@” field to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #introspect
-- @
clearDBusSubtreeVTableIntrospect :: MonadIO m => DBusSubtreeVTable -> m ()
clearDBusSubtreeVTableIntrospect s = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 8) (FP.nullFunPtr :: FunPtr Gio.Callbacks.C_DBusSubtreeIntrospectFunc)

#if defined(ENABLE_OVERLOADING)
data DBusSubtreeVTableIntrospectFieldInfo
instance AttrInfo DBusSubtreeVTableIntrospectFieldInfo where
    type AttrBaseTypeConstraint DBusSubtreeVTableIntrospectFieldInfo = (~) DBusSubtreeVTable
    type AttrAllowedOps DBusSubtreeVTableIntrospectFieldInfo = '[ 'AttrSet, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint DBusSubtreeVTableIntrospectFieldInfo = (~) (FunPtr Gio.Callbacks.C_DBusSubtreeIntrospectFunc)
    type AttrTransferTypeConstraint DBusSubtreeVTableIntrospectFieldInfo = (~)Gio.Callbacks.DBusSubtreeIntrospectFunc_WithClosures
    type AttrTransferType DBusSubtreeVTableIntrospectFieldInfo = (FunPtr Gio.Callbacks.C_DBusSubtreeIntrospectFunc)
    type AttrGetType DBusSubtreeVTableIntrospectFieldInfo = Maybe Gio.Callbacks.DBusSubtreeIntrospectFunc_WithClosures
    type AttrLabel DBusSubtreeVTableIntrospectFieldInfo = "introspect"
    type AttrOrigin DBusSubtreeVTableIntrospectFieldInfo = DBusSubtreeVTable
    attrGet = getDBusSubtreeVTableIntrospect
    attrSet = setDBusSubtreeVTableIntrospect
    attrConstruct = undefined
    attrClear = clearDBusSubtreeVTableIntrospect
    attrTransfer _ v = do
        Gio.Callbacks.mk_DBusSubtreeIntrospectFunc (Gio.Callbacks.wrap_DBusSubtreeIntrospectFunc Nothing v)
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Structs.DBusSubtreeVTable.introspect"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Structs-DBusSubtreeVTable.html#g:attr:introspect"
        })

dBusSubtreeVTable_introspect :: AttrLabelProxy "introspect"
dBusSubtreeVTable_introspect = AttrLabelProxy

#endif


-- | Get the value of the “@dispatch@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' dBusSubtreeVTable #dispatch
-- @
getDBusSubtreeVTableDispatch :: MonadIO m => DBusSubtreeVTable -> m (Maybe Gio.Callbacks.DBusSubtreeDispatchFunc_WithClosures)
getDBusSubtreeVTableDispatch s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 16) :: IO (FunPtr Gio.Callbacks.C_DBusSubtreeDispatchFunc)
    result <- SP.convertFunPtrIfNonNull val $ \val' -> do
        let val'' = Gio.Callbacks.dynamic_DBusSubtreeDispatchFunc val'
        return val''
    return result

-- | Set the value of the “@dispatch@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' dBusSubtreeVTable [ #dispatch 'Data.GI.Base.Attributes.:=' value ]
-- @
setDBusSubtreeVTableDispatch :: MonadIO m => DBusSubtreeVTable -> FunPtr Gio.Callbacks.C_DBusSubtreeDispatchFunc -> m ()
setDBusSubtreeVTableDispatch s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 16) (val :: FunPtr Gio.Callbacks.C_DBusSubtreeDispatchFunc)

-- | Set the value of the “@dispatch@” field to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #dispatch
-- @
clearDBusSubtreeVTableDispatch :: MonadIO m => DBusSubtreeVTable -> m ()
clearDBusSubtreeVTableDispatch s = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 16) (FP.nullFunPtr :: FunPtr Gio.Callbacks.C_DBusSubtreeDispatchFunc)

#if defined(ENABLE_OVERLOADING)
data DBusSubtreeVTableDispatchFieldInfo
instance AttrInfo DBusSubtreeVTableDispatchFieldInfo where
    type AttrBaseTypeConstraint DBusSubtreeVTableDispatchFieldInfo = (~) DBusSubtreeVTable
    type AttrAllowedOps DBusSubtreeVTableDispatchFieldInfo = '[ 'AttrSet, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint DBusSubtreeVTableDispatchFieldInfo = (~) (FunPtr Gio.Callbacks.C_DBusSubtreeDispatchFunc)
    type AttrTransferTypeConstraint DBusSubtreeVTableDispatchFieldInfo = (~)Gio.Callbacks.DBusSubtreeDispatchFunc_WithClosures
    type AttrTransferType DBusSubtreeVTableDispatchFieldInfo = (FunPtr Gio.Callbacks.C_DBusSubtreeDispatchFunc)
    type AttrGetType DBusSubtreeVTableDispatchFieldInfo = Maybe Gio.Callbacks.DBusSubtreeDispatchFunc_WithClosures
    type AttrLabel DBusSubtreeVTableDispatchFieldInfo = "dispatch"
    type AttrOrigin DBusSubtreeVTableDispatchFieldInfo = DBusSubtreeVTable
    attrGet = getDBusSubtreeVTableDispatch
    attrSet = setDBusSubtreeVTableDispatch
    attrConstruct = undefined
    attrClear = clearDBusSubtreeVTableDispatch
    attrTransfer _ v = do
        Gio.Callbacks.mk_DBusSubtreeDispatchFunc (Gio.Callbacks.wrap_DBusSubtreeDispatchFunc Nothing v)
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Structs.DBusSubtreeVTable.dispatch"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Structs-DBusSubtreeVTable.html#g:attr:dispatch"
        })

dBusSubtreeVTable_dispatch :: AttrLabelProxy "dispatch"
dBusSubtreeVTable_dispatch = AttrLabelProxy

#endif



#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList DBusSubtreeVTable
type instance O.AttributeList DBusSubtreeVTable = DBusSubtreeVTableAttributeList
type DBusSubtreeVTableAttributeList = ('[ '("enumerate", DBusSubtreeVTableEnumerateFieldInfo), '("introspect", DBusSubtreeVTableIntrospectFieldInfo), '("dispatch", DBusSubtreeVTableDispatchFieldInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
type family ResolveDBusSubtreeVTableMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveDBusSubtreeVTableMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveDBusSubtreeVTableMethod t DBusSubtreeVTable, O.OverloadedMethod info DBusSubtreeVTable p) => OL.IsLabel t (DBusSubtreeVTable -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveDBusSubtreeVTableMethod t DBusSubtreeVTable, O.OverloadedMethod info DBusSubtreeVTable p, R.HasField t DBusSubtreeVTable p) => R.HasField t DBusSubtreeVTable p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveDBusSubtreeVTableMethod t DBusSubtreeVTable, O.OverloadedMethodInfo info DBusSubtreeVTable) => OL.IsLabel t (O.MethodProxy info DBusSubtreeVTable) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif


