// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package pprofile

import (
	"go.opentelemetry.io/collector/pdata/internal"
	"go.opentelemetry.io/collector/pdata/pcommon"
)

// Profile are an implementation of the pprofextended data model.

// This is a reference type, if passed by value and callee modifies it the
// caller will see the modification.
//
// Must use NewProfile function to create new instances.
// Important: zero-initialized instance is not valid for use.
type Profile struct {
	orig  *internal.Profile
	state *internal.State
}

func newProfile(orig *internal.Profile, state *internal.State) Profile {
	return Profile{orig: orig, state: state}
}

// NewProfile creates a new empty Profile.
//
// This must be used only in testing code. Users should use "AppendEmpty" when part of a Slice,
// OR directly access the member if this is embedded in another struct.
func NewProfile() Profile {
	return newProfile(internal.NewProfile(), internal.NewState())
}

// MoveTo moves all properties from the current struct overriding the destination and
// resetting the current instance to its zero value
func (ms Profile) MoveTo(dest Profile) {
	ms.state.AssertMutable()
	dest.state.AssertMutable()
	// If they point to the same data, they are the same, nothing to do.
	if ms.orig == dest.orig {
		return
	}
	internal.DeleteProfile(dest.orig, false)
	*dest.orig, *ms.orig = *ms.orig, *dest.orig
}

// SampleType returns the sampletype associated with this Profile.
func (ms Profile) SampleType() ValueType {
	return newValueType(&ms.orig.SampleType, ms.state)
}

// Sample returns the Sample associated with this Profile.
func (ms Profile) Sample() SampleSlice {
	return newSampleSlice(&ms.orig.Sample, ms.state)
}

// Time returns the time associated with this Profile.
func (ms Profile) Time() pcommon.Timestamp {
	return pcommon.Timestamp(ms.orig.TimeUnixNano)
}

// SetTime replaces the time associated with this Profile.
func (ms Profile) SetTime(v pcommon.Timestamp) {
	ms.state.AssertMutable()
	ms.orig.TimeUnixNano = uint64(v)
}

// Duration returns the duration associated with this Profile.
func (ms Profile) Duration() pcommon.Timestamp {
	return pcommon.Timestamp(ms.orig.DurationNano)
}

// SetDuration replaces the duration associated with this Profile.
func (ms Profile) SetDuration(v pcommon.Timestamp) {
	ms.state.AssertMutable()
	ms.orig.DurationNano = uint64(v)
}

// PeriodType returns the periodtype associated with this Profile.
func (ms Profile) PeriodType() ValueType {
	return newValueType(&ms.orig.PeriodType, ms.state)
}

// Period returns the period associated with this Profile.
func (ms Profile) Period() int64 {
	return ms.orig.Period
}

// SetPeriod replaces the period associated with this Profile.
func (ms Profile) SetPeriod(v int64) {
	ms.state.AssertMutable()
	ms.orig.Period = v
}

// CommentStrindices returns the CommentStrindices associated with this Profile.
func (ms Profile) CommentStrindices() pcommon.Int32Slice {
	return pcommon.Int32Slice(internal.NewInt32SliceWrapper(&ms.orig.CommentStrindices, ms.state))
}

// ProfileID returns the profileid associated with this Profile.
func (ms Profile) ProfileID() ProfileID {
	return ProfileID(ms.orig.ProfileId)
}

// SetProfileID replaces the profileid associated with this Profile.
func (ms Profile) SetProfileID(v ProfileID) {
	ms.state.AssertMutable()
	ms.orig.ProfileId = internal.ProfileID(v)
}

// DroppedAttributesCount returns the droppedattributescount associated with this Profile.
func (ms Profile) DroppedAttributesCount() uint32 {
	return ms.orig.DroppedAttributesCount
}

// SetDroppedAttributesCount replaces the droppedattributescount associated with this Profile.
func (ms Profile) SetDroppedAttributesCount(v uint32) {
	ms.state.AssertMutable()
	ms.orig.DroppedAttributesCount = v
}

// OriginalPayloadFormat returns the originalpayloadformat associated with this Profile.
func (ms Profile) OriginalPayloadFormat() string {
	return ms.orig.OriginalPayloadFormat
}

// SetOriginalPayloadFormat replaces the originalpayloadformat associated with this Profile.
func (ms Profile) SetOriginalPayloadFormat(v string) {
	ms.state.AssertMutable()
	ms.orig.OriginalPayloadFormat = v
}

// OriginalPayload returns the OriginalPayload associated with this Profile.
func (ms Profile) OriginalPayload() pcommon.ByteSlice {
	return pcommon.ByteSlice(internal.NewByteSliceWrapper(&ms.orig.OriginalPayload, ms.state))
}

// AttributeIndices returns the AttributeIndices associated with this Profile.
func (ms Profile) AttributeIndices() pcommon.Int32Slice {
	return pcommon.Int32Slice(internal.NewInt32SliceWrapper(&ms.orig.AttributeIndices, ms.state))
}

// CopyTo copies all properties from the current struct overriding the destination.
func (ms Profile) CopyTo(dest Profile) {
	dest.state.AssertMutable()
	internal.CopyProfile(dest.orig, ms.orig)
}
