/*
 * Copyright 2020 Free Software Foundation, Inc.
 *
 * This file is part of GNU Radio
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 *
 */
#include "pydoc_macros.h"
#define D(...) DOC(gr, fec, __VA_ARGS__)
/*
  This file contains placeholders for docstrings for the Python bindings.
  Do not edit! These were automatically extracted during the binding process
  and will be overwritten during the build process
 */


static const char* __doc_gr_fec_decoder = R"doc(General FEC decoding block that takes in a decoder variable object (derived from gr::fec::general_decoder) for use in a flowgraph.

This block uses a decoder variable object (derived from gr::fec::generic_decoder) to decode data within a flowgraph. This block interacts with the general FECAPI architecture to handle all passing all input and output data in a flowgraph. The decoder variable takes care of understanding the requirements, data types and sizes, and boundary conditions of the specific FEC decoding algorithm.


Generally, this block is used within the fec.extended_decoder Python block to handle some input/output formatting issues. In the FECAPI, the decoder variable sets properties like the input and output types and sizes and whether the output is packed or unpacked bytes. The fec.extended_decoder uses this information to set up an gr::hier_block2 structure to make sure the I/O to the variable is handled consistently, such as to make sure all inputs are floats with one soft symbol per item and the outputs are unpacked bytes with the bit in the LSB.


See gr::fec::generic_decoder for detail on what information an FECAPI variable object can set if using this block directly and not as part of the fec.extended_decoder.

Constructor Specific Documentation:

Create the FEC decoder block by taking in the FECAPI decoder object as well as input and output sizes.

Args:
    my_decoder : An FECAPI decoder object (See gr::fec::generic_decoder).
    input_item_size : The size of the input items (often the my_decoder object can tell us this).
    output_item_size : The size of the output items (often the my_decoder object can tell us this).)doc";


static const char* __doc_gr_fec_decoder_decoder_0 = R"doc()doc";


static const char* __doc_gr_fec_decoder_decoder_1 = R"doc()doc";


static const char* __doc_gr_fec_decoder_make = R"doc(General FEC decoding block that takes in a decoder variable object (derived from gr::fec::general_decoder) for use in a flowgraph.

This block uses a decoder variable object (derived from gr::fec::generic_decoder) to decode data within a flowgraph. This block interacts with the general FECAPI architecture to handle all passing all input and output data in a flowgraph. The decoder variable takes care of understanding the requirements, data types and sizes, and boundary conditions of the specific FEC decoding algorithm.


Generally, this block is used within the fec.extended_decoder Python block to handle some input/output formatting issues. In the FECAPI, the decoder variable sets properties like the input and output types and sizes and whether the output is packed or unpacked bytes. The fec.extended_decoder uses this information to set up an gr::hier_block2 structure to make sure the I/O to the variable is handled consistently, such as to make sure all inputs are floats with one soft symbol per item and the outputs are unpacked bytes with the bit in the LSB.


See gr::fec::generic_decoder for detail on what information an FECAPI variable object can set if using this block directly and not as part of the fec.extended_decoder.

Constructor Specific Documentation:

Create the FEC decoder block by taking in the FECAPI decoder object as well as input and output sizes.

Args:
    my_decoder : An FECAPI decoder object (See gr::fec::generic_decoder).
    input_item_size : The size of the input items (often the my_decoder object can tell us this).
    output_item_size : The size of the output items (often the my_decoder object can tell us this).)doc";


static const char* __doc_gr_fec_decoder_general_work = R"doc(compute output items from input items

WORK_CALLED_PRODUCE is used where not all outputs produce the same number of items. general_work must call produce() for each output to indicate the number of items actually produced.


WORK_DONE indicates that no more data will be produced by this block.


general_work must call consume or consume_each to indicate how many items were consumed on each input stream.)doc";


static const char* __doc_gr_fec_decoder_fixed_rate_ninput_to_noutput = R"doc(Given ninput samples, return number of output samples that will be produced. N.B. this is only defined if fixed_rate returns true. Generally speaking, you don't need to override this.)doc";


static const char* __doc_gr_fec_decoder_fixed_rate_noutput_to_ninput = R"doc(Given noutput samples, return number of input samples required to produce noutput. N.B. this is only defined if fixed_rate returns true. Generally speaking, you don't need to override this.)doc";


static const char* __doc_gr_fec_decoder_forecast = R"doc(Estimate input requirements given output request.

Given a request to product , estimate the number of data items required on each input stream. The estimate doesn't have to be exact, but should be close.)doc";
