/* THIS FILE IS AUTOGENERATED FROM InspectorUtils.webidl BY Codegen.py - DO NOT EDIT */

#include <type_traits>
#include "AtomList.h"
#include "InspectorUtilsBinding.h"
#include "MainThreadUtils.h"
#include "WrapperFactory.h"
#include "XrayWrapper.h"
#include "js/Array.h"
#include "js/CallAndConstruct.h"
#include "js/Exception.h"
#include "js/ForOfIterator.h"
#include "js/MapAndSet.h"
#include "js/Object.h"
#include "js/PropertyAndElement.h"
#include "js/PropertyDescriptor.h"
#include "js/experimental/JitInfo.h"
#include "jsapi.h"
#include "mozilla/Atomics.h"
#include "mozilla/FloatingPoint.h"
#include "mozilla/OwningNonNull.h"
#include "mozilla/ProfilerLabels.h"
#include "mozilla/StyleSheet.h"
#include "mozilla/StyleSheetInlines.h"
#include "mozilla/css/Rule.h"
#include "mozilla/dom/BindingCallContext.h"
#include "mozilla/dom/BindingUtils.h"
#include "mozilla/dom/BrowsingContext.h"
#include "mozilla/dom/CSSFontFaceRule.h"
#include "mozilla/dom/CharacterData.h"
#include "mozilla/dom/DOMJSClass.h"
#include "mozilla/dom/Document.h"
#include "mozilla/dom/Element.h"
#include "mozilla/dom/InspectorCSSParser.h"
#include "mozilla/dom/InspectorFontFace.h"
#include "mozilla/dom/InspectorUtils.h"
#include "mozilla/dom/NonRefcountedDOMObject.h"
#include "mozilla/dom/Nullable.h"
#include "mozilla/dom/PrimitiveConversions.h"
#include "mozilla/dom/ScriptSettings.h"
#include "mozilla/dom/SimpleGlobalObject.h"
#include "mozilla/dom/XrayExpandoClass.h"
#include "nsContentUtils.h"
#include "nsIContent.h"
#include "nsINodeList.h"
#include "nsRange.h"

namespace mozilla {

namespace dom {

namespace binding_detail {}; // Just to make sure it's known as a namespace
using namespace mozilla::dom::binding_detail;


namespace binding_detail {
constexpr nsLiteralCString EnumStrings<DeclarationOrigin>::Values[7];
} // namespace binding_detail

bool
ToJSValue(JSContext* aCx, DeclarationOrigin aArgument, JS::MutableHandle<JS::Value> aValue)
{
  MOZ_ASSERT(uint32_t(aArgument) < std::size(binding_detail::EnumStrings<DeclarationOrigin>::Values));
  JSString* resultStr =
    JS_NewStringCopyN(aCx, binding_detail::EnumStrings<DeclarationOrigin>::Values[uint32_t(aArgument)].BeginReading(),
                      binding_detail::EnumStrings<DeclarationOrigin>::Values[uint32_t(aArgument)].Length());
  if (!resultStr) {
    return false;
  }
  aValue.setString(resultStr);
  return true;
}


namespace binding_detail {
constexpr nsLiteralCString EnumStrings<InspectorPropertyType>::Values[3];
} // namespace binding_detail

bool
ToJSValue(JSContext* aCx, InspectorPropertyType aArgument, JS::MutableHandle<JS::Value> aValue)
{
  MOZ_ASSERT(uint32_t(aArgument) < std::size(binding_detail::EnumStrings<InspectorPropertyType>::Values));
  JSString* resultStr =
    JS_NewStringCopyN(aCx, binding_detail::EnumStrings<InspectorPropertyType>::Values[uint32_t(aArgument)].BeginReading(),
                      binding_detail::EnumStrings<InspectorPropertyType>::Values[uint32_t(aArgument)].Length());
  if (!resultStr) {
    return false;
  }
  aValue.setString(resultStr);
  return true;
}


void
ImplCycleCollectionTraverse(nsCycleCollectionTraversalCallback& aCallback, OwningCSSRuleOrInspectorDeclaration& aUnion, const char* aName, uint32_t aFlags)
{
  if (aUnion.IsCSSRule()) {
    ImplCycleCollectionTraverse(aCallback, aUnion.GetAsCSSRule(), "mCSSRule", aFlags);
  } else if (aUnion.IsInspectorDeclaration()) {
    ImplCycleCollectionTraverse(aCallback, aUnion.GetAsInspectorDeclaration(), "mInspectorDeclaration", aFlags);
  }
}


void
ImplCycleCollectionUnlink(OwningCSSRuleOrInspectorDeclaration& aUnion)
{
  aUnion.Uninit();
}



InspectorCSSPropertyDefinition::InspectorCSSPropertyDefinition()
{
  // Safe to pass a null context if we pass a null value
  Init(nullptr, JS::NullHandleValue);
}




bool
InspectorCSSPropertyDefinition::InitIds(JSContext* cx, InspectorCSSPropertyDefinitionAtoms* atomsCache)
{
  MOZ_ASSERT(reinterpret_cast<jsid*>(atomsCache)->isVoid());

  // Initialize these in reverse order so that any failure leaves the first one
  // uninitialized.
  if (!atomsCache->syntax_id.init(cx, "syntax") ||
      !atomsCache->name_id.init(cx, "name") ||
      !atomsCache->initialValue_id.init(cx, "initialValue") ||
      !atomsCache->inherits_id.init(cx, "inherits") ||
      !atomsCache->fromJS_id.init(cx, "fromJS")) {
    return false;
  }
  return true;
}

bool
InspectorCSSPropertyDefinition::Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription, bool passedToJSImpl)
{
  // Passing a null JSContext is OK only if we're initing from null,
  // Since in that case we will not have to do any property gets
  // Also evaluate isNullOrUndefined in order to avoid false-positive
  // checkers by static analysis tools
  MOZ_ASSERT_IF(!cx, val.isNull() && val.isNullOrUndefined());
  InspectorCSSPropertyDefinitionAtoms* atomsCache = nullptr;
  if (cx) {
    atomsCache = GetAtomCache<InspectorCSSPropertyDefinitionAtoms>(cx);
    if (reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
        !InitIds(cx, atomsCache)) {
      return false;
    }
  }

  if (!IsConvertibleToDictionary(val)) {
    return cx.ThrowErrorMessage<MSG_CONVERSION_ERROR>(sourceDescription, "dictionary");
  }

  bool isNull = val.isNullOrUndefined();
  // We only need these if !isNull, in which case we have |cx|.
  Maybe<JS::Rooted<JSObject *> > object;
  Maybe<JS::Rooted<JS::Value> > temp;
  if (!isNull) {
    MOZ_ASSERT(cx);
    object.emplace(cx, &val.toObject());
    temp.emplace(cx);
  }
  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->fromJS_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    if (!ValueToPrimitive<bool, eDefault>(cx, temp.ref(), "'fromJS' member of InspectorCSSPropertyDefinition", &mFromJS)) {
      return false;
    }
    mIsAnyMemberPresent = true;
  } else if (cx) {
    // Don't error out if we have no cx.  In that
    // situation the caller is default-constructing us and we'll
    // just assume they know what they're doing.
    return cx.ThrowErrorMessage<MSG_MISSING_REQUIRED_DICTIONARY_MEMBER>("'fromJS' member of InspectorCSSPropertyDefinition");
  }

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->inherits_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    if (!ValueToPrimitive<bool, eDefault>(cx, temp.ref(), "'inherits' member of InspectorCSSPropertyDefinition", &mInherits)) {
      return false;
    }
    mIsAnyMemberPresent = true;
  } else if (cx) {
    // Don't error out if we have no cx.  In that
    // situation the caller is default-constructing us and we'll
    // just assume they know what they're doing.
    return cx.ThrowErrorMessage<MSG_MISSING_REQUIRED_DICTIONARY_MEMBER>("'inherits' member of InspectorCSSPropertyDefinition");
  }

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->initialValue_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    if (!ConvertJSValueToString(cx, temp.ref(), eNull, eNull, mInitialValue)) {
      return false;
    }
    mIsAnyMemberPresent = true;
  } else if (cx) {
    // Don't error out if we have no cx.  In that
    // situation the caller is default-constructing us and we'll
    // just assume they know what they're doing.
    return cx.ThrowErrorMessage<MSG_MISSING_REQUIRED_DICTIONARY_MEMBER>("'initialValue' member of InspectorCSSPropertyDefinition");
  }

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->name_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    if (!ConvertJSValueToString(cx, temp.ref(), eStringify, eStringify, mName)) {
      return false;
    }
    mIsAnyMemberPresent = true;
  } else if (cx) {
    // Don't error out if we have no cx.  In that
    // situation the caller is default-constructing us and we'll
    // just assume they know what they're doing.
    return cx.ThrowErrorMessage<MSG_MISSING_REQUIRED_DICTIONARY_MEMBER>("'name' member of InspectorCSSPropertyDefinition");
  }

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->syntax_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    if (!ConvertJSValueToString(cx, temp.ref(), eStringify, eStringify, mSyntax)) {
      return false;
    }
    mIsAnyMemberPresent = true;
  } else if (cx) {
    // Don't error out if we have no cx.  In that
    // situation the caller is default-constructing us and we'll
    // just assume they know what they're doing.
    return cx.ThrowErrorMessage<MSG_MISSING_REQUIRED_DICTIONARY_MEMBER>("'syntax' member of InspectorCSSPropertyDefinition");
  }
  return true;
}

bool
InspectorCSSPropertyDefinition::Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription, bool passedToJSImpl)
{
  // We don't want to use sourceDescription for our context here;
  // that's not really what it's formatted for.
  BindingCallContext cx(cx_, nullptr);
  return Init(cx, val, sourceDescription, passedToJSImpl);
}

bool
InspectorCSSPropertyDefinition::ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const
{
  InspectorCSSPropertyDefinitionAtoms* atomsCache = GetAtomCache<InspectorCSSPropertyDefinitionAtoms>(cx);
  if (reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
      !InitIds(cx, atomsCache)) {
    return false;
  }

  JS::Rooted<JSObject*> obj(cx, JS_NewPlainObject(cx));
  if (!obj) {
    return false;
  }
  rval.set(JS::ObjectValue(*obj));

  do {
    // block for our 'break' successCode and scope for 'temp' and 'currentValue'
    JS::Rooted<JS::Value> temp(cx);
    bool const & currentValue = mFromJS;
    temp.setBoolean(currentValue);
    if (!JS_DefinePropertyById(cx, obj, atomsCache->fromJS_id, temp, JSPROP_ENUMERATE)) {
      return false;
    }
    break;
  } while(false);

  do {
    // block for our 'break' successCode and scope for 'temp' and 'currentValue'
    JS::Rooted<JS::Value> temp(cx);
    bool const & currentValue = mInherits;
    temp.setBoolean(currentValue);
    if (!JS_DefinePropertyById(cx, obj, atomsCache->inherits_id, temp, JSPROP_ENUMERATE)) {
      return false;
    }
    break;
  } while(false);

  do {
    // block for our 'break' successCode and scope for 'temp' and 'currentValue'
    JS::Rooted<JS::Value> temp(cx);
    nsCString const & currentValue = mInitialValue;
    if (!UTF8StringToJsval(cx, currentValue, &temp)) {
      return false;
    }
    if (!JS_DefinePropertyById(cx, obj, atomsCache->initialValue_id, temp, JSPROP_ENUMERATE)) {
      return false;
    }
    break;
  } while(false);

  do {
    // block for our 'break' successCode and scope for 'temp' and 'currentValue'
    JS::Rooted<JS::Value> temp(cx);
    nsCString const & currentValue = mName;
    if (!NonVoidUTF8StringToJsval(cx, currentValue, &temp)) {
      return false;
    }
    if (!JS_DefinePropertyById(cx, obj, atomsCache->name_id, temp, JSPROP_ENUMERATE)) {
      return false;
    }
    break;
  } while(false);

  do {
    // block for our 'break' successCode and scope for 'temp' and 'currentValue'
    JS::Rooted<JS::Value> temp(cx);
    nsCString const & currentValue = mSyntax;
    if (!NonVoidUTF8StringToJsval(cx, currentValue, &temp)) {
      return false;
    }
    if (!JS_DefinePropertyById(cx, obj, atomsCache->syntax_id, temp, JSPROP_ENUMERATE)) {
      return false;
    }
    break;
  } while(false);

  return true;
}

void
InspectorCSSPropertyDefinition::TraceDictionary(JSTracer* trc)
{
}

InspectorCSSPropertyDefinition&
InspectorCSSPropertyDefinition::operator=(const InspectorCSSPropertyDefinition& aOther)
{
  DictionaryBase::operator=(aOther);
  mFromJS = aOther.mFromJS;
  mInherits = aOther.mInherits;
  mInitialValue = aOther.mInitialValue;
  mName = aOther.mName;
  mSyntax = aOther.mSyntax;
  return *this;
}



InspectorCSSToken::InspectorCSSToken()
{
  // Safe to pass a null context if we pass a null value
  Init();
}




bool
InspectorCSSToken::InitIds(JSContext* cx, InspectorCSSTokenAtoms* atomsCache)
{
  MOZ_ASSERT(reinterpret_cast<jsid*>(atomsCache)->isVoid());

  // Initialize these in reverse order so that any failure leaves the first one
  // uninitialized.
  if (!atomsCache->value_id.init(cx, "value") ||
      !atomsCache->unit_id.init(cx, "unit") ||
      !atomsCache->tokenType_id.init(cx, "tokenType") ||
      !atomsCache->text_id.init(cx, "text") ||
      !atomsCache->number_id.init(cx, "number")) {
    return false;
  }
  return true;
}

bool
InspectorCSSToken::Init(const char* sourceDescription, bool passedToJSImpl)
{
  mNumber.SetNull();
  mIsAnyMemberPresent = true;
  return true;
}

bool
InspectorCSSToken::ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const
{
  InspectorCSSTokenAtoms* atomsCache = GetAtomCache<InspectorCSSTokenAtoms>(cx);
  if (reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
      !InitIds(cx, atomsCache)) {
    return false;
  }

  JS::Rooted<JSObject*> obj(cx, JS_NewPlainObject(cx));
  if (!obj) {
    return false;
  }
  rval.set(JS::ObjectValue(*obj));

  do {
    // block for our 'break' successCode and scope for 'temp' and 'currentValue'
    JS::Rooted<JS::Value> temp(cx);
    Nullable<double> const & currentValue = mNumber;
    if (currentValue.IsNull()) {
      temp.setNull();
      if (!JS_DefinePropertyById(cx, obj, atomsCache->number_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    }
    temp.set(JS_NumberValue(double(currentValue.Value())));
    if (!JS_DefinePropertyById(cx, obj, atomsCache->number_id, temp, JSPROP_ENUMERATE)) {
      return false;
    }
    break;
  } while(false);

  do {
    // block for our 'break' successCode and scope for 'temp' and 'currentValue'
    JS::Rooted<JS::Value> temp(cx);
    nsCString const & currentValue = mText;
    if (!NonVoidUTF8StringToJsval(cx, currentValue, &temp)) {
      return false;
    }
    if (!JS_DefinePropertyById(cx, obj, atomsCache->text_id, temp, JSPROP_ENUMERATE)) {
      return false;
    }
    break;
  } while(false);

  do {
    // block for our 'break' successCode and scope for 'temp' and 'currentValue'
    JS::Rooted<JS::Value> temp(cx);
    nsCString const & currentValue = mTokenType;
    if (!NonVoidUTF8StringToJsval(cx, currentValue, &temp)) {
      return false;
    }
    if (!JS_DefinePropertyById(cx, obj, atomsCache->tokenType_id, temp, JSPROP_ENUMERATE)) {
      return false;
    }
    break;
  } while(false);

  do {
    // block for our 'break' successCode and scope for 'temp' and 'currentValue'
    JS::Rooted<JS::Value> temp(cx);
    nsCString const & currentValue = mUnit;
    if (!UTF8StringToJsval(cx, currentValue, &temp)) {
      return false;
    }
    if (!JS_DefinePropertyById(cx, obj, atomsCache->unit_id, temp, JSPROP_ENUMERATE)) {
      return false;
    }
    break;
  } while(false);

  do {
    // block for our 'break' successCode and scope for 'temp' and 'currentValue'
    JS::Rooted<JS::Value> temp(cx);
    nsCString const & currentValue = mValue;
    if (!UTF8StringToJsval(cx, currentValue, &temp)) {
      return false;
    }
    if (!JS_DefinePropertyById(cx, obj, atomsCache->value_id, temp, JSPROP_ENUMERATE)) {
      return false;
    }
    break;
  } while(false);

  return true;
}

void
InspectorCSSToken::TraceDictionary(JSTracer* trc)
{
}

InspectorCSSToken&
InspectorCSSToken::operator=(const InspectorCSSToken& aOther)
{
  DictionaryBase::operator=(aOther);
  mNumber = aOther.mNumber;
  mText = aOther.mText;
  mTokenType = aOther.mTokenType;
  mUnit = aOther.mUnit;
  mValue = aOther.mValue;
  return *this;
}



InspectorColorToResult::InspectorColorToResult()
{
  // Safe to pass a null context if we pass a null value
  Init();
}




bool
InspectorColorToResult::InitIds(JSContext* cx, InspectorColorToResultAtoms* atomsCache)
{
  MOZ_ASSERT(reinterpret_cast<jsid*>(atomsCache)->isVoid());

  // Initialize these in reverse order so that any failure leaves the first one
  // uninitialized.
  if (!atomsCache->components_id.init(cx, "components") ||
      !atomsCache->color_id.init(cx, "color") ||
      !atomsCache->adjusted_id.init(cx, "adjusted")) {
    return false;
  }
  return true;
}

bool
InspectorColorToResult::Init(const char* sourceDescription, bool passedToJSImpl)
{
  return true;
}

bool
InspectorColorToResult::ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const
{
  InspectorColorToResultAtoms* atomsCache = GetAtomCache<InspectorColorToResultAtoms>(cx);
  if (reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
      !InitIds(cx, atomsCache)) {
    return false;
  }

  JS::Rooted<JSObject*> obj(cx, JS_NewPlainObject(cx));
  if (!obj) {
    return false;
  }
  rval.set(JS::ObjectValue(*obj));

  do {
    // block for our 'break' successCode and scope for 'temp' and 'currentValue'
    JS::Rooted<JS::Value> temp(cx);
    bool const & currentValue = mAdjusted;
    temp.setBoolean(currentValue);
    if (!JS_DefinePropertyById(cx, obj, atomsCache->adjusted_id, temp, JSPROP_ENUMERATE)) {
      return false;
    }
    break;
  } while(false);

  do {
    // block for our 'break' successCode and scope for 'temp' and 'currentValue'
    JS::Rooted<JS::Value> temp(cx);
    nsString const & currentValue = mColor;
    if (!xpc::NonVoidStringToJsval(cx, currentValue, &temp)) {
      return false;
    }
    if (!JS_DefinePropertyById(cx, obj, atomsCache->color_id, temp, JSPROP_ENUMERATE)) {
      return false;
    }
    break;
  } while(false);

  do {
    // block for our 'break' successCode and scope for 'temp' and 'currentValue'
    JS::Rooted<JS::Value> temp(cx);
    Sequence<float> const & currentValue = mComponents;

    uint32_t length = currentValue.Length();
    JS::Rooted<JSObject*> returnArray(cx, JS::NewArrayObject(cx, length));
    if (!returnArray) {
      return false;
    }
    // Scope for 'tmp'
    {
      JS::Rooted<JS::Value> tmp(cx);
      for (uint32_t sequenceIdx0 = 0; sequenceIdx0 < length; ++sequenceIdx0) {
        // Control block to let us common up the JS_DefineElement calls when there
        // are different ways to succeed at wrapping the object.
        do {
          tmp.set(JS_NumberValue(double(currentValue[sequenceIdx0])));
          break;
        } while (false);
        if (!JS_DefineElement(cx, returnArray, sequenceIdx0, tmp,
                              JSPROP_ENUMERATE)) {
          return false;
        }
      }
    }
    temp.setObject(*returnArray);
    if (!JS_DefinePropertyById(cx, obj, atomsCache->components_id, temp, JSPROP_ENUMERATE)) {
      return false;
    }
    break;
  } while(false);

  return true;
}

void
InspectorColorToResult::TraceDictionary(JSTracer* trc)
{
}

InspectorColorToResult&
InspectorColorToResult::operator=(const InspectorColorToResult& aOther)
{
  DictionaryBase::operator=(aOther);
  mAdjusted = aOther.mAdjusted;
  mColor = aOther.mColor;
  mComponents = aOther.mComponents;
  return *this;
}



InspectorDeclaration::InspectorDeclaration()
{
  // Safe to pass a null context if we pass a null value
  Init(nullptr, JS::NullHandleValue);
}




bool
InspectorDeclaration::InitIds(JSContext* cx, InspectorDeclarationAtoms* atomsCache)
{
  MOZ_ASSERT(reinterpret_cast<jsid*>(atomsCache)->isVoid());

  // Initialize these in reverse order so that any failure leaves the first one
  // uninitialized.
  if (!atomsCache->style_id.init(cx, "style") ||
      !atomsCache->declarationOrigin_id.init(cx, "declarationOrigin")) {
    return false;
  }
  return true;
}

bool
InspectorDeclaration::Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription, bool passedToJSImpl)
{
  // Passing a null JSContext is OK only if we're initing from null,
  // Since in that case we will not have to do any property gets
  // Also evaluate isNullOrUndefined in order to avoid false-positive
  // checkers by static analysis tools
  MOZ_ASSERT_IF(!cx, val.isNull() && val.isNullOrUndefined());
  InspectorDeclarationAtoms* atomsCache = nullptr;
  if (cx) {
    atomsCache = GetAtomCache<InspectorDeclarationAtoms>(cx);
    if (reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
        !InitIds(cx, atomsCache)) {
      return false;
    }
  }

  if (!IsConvertibleToDictionary(val)) {
    return cx.ThrowErrorMessage<MSG_CONVERSION_ERROR>(sourceDescription, "dictionary");
  }

  bool isNull = val.isNullOrUndefined();
  // We only need these if !isNull, in which case we have |cx|.
  Maybe<JS::Rooted<JSObject *> > object;
  Maybe<JS::Rooted<JS::Value> > temp;
  if (!isNull) {
    MOZ_ASSERT(cx);
    object.emplace(cx, &val.toObject());
    temp.emplace(cx);
  }
  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->declarationOrigin_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    {
      int index;
      if (!binding_detail::FindEnumStringIndex<true>(cx, temp.ref(),
                                                                         binding_detail::EnumStrings<DeclarationOrigin>::Values,
                                                                         "DeclarationOrigin", "'declarationOrigin' member of InspectorDeclaration",
                                                                         &index)) {
        return false;
      }
      MOZ_ASSERT(index >= 0);
      mDeclarationOrigin = static_cast<DeclarationOrigin>(index);
    }
    mIsAnyMemberPresent = true;
  } else if (cx) {
    // Don't error out if we have no cx.  In that
    // situation the caller is default-constructing us and we'll
    // just assume they know what they're doing.
    return cx.ThrowErrorMessage<MSG_MISSING_REQUIRED_DICTIONARY_MEMBER>("'declarationOrigin' member of InspectorDeclaration");
  }

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->style_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    if (temp.ref().isObject()) {
      static_assert(IsRefcounted<nsICSSDeclaration>::value, "We can only store refcounted classes.");
      {
        // Our JSContext should be in the right global to do unwrapping in.
        nsresult rv = UnwrapObject<prototypes::id::CSSStyleDeclaration, nsICSSDeclaration>(temp.ptr(), mStyle, cx);
        if (NS_FAILED(rv)) {
          cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("'style' member of InspectorDeclaration", "CSSStyleDeclaration");
          return false;
        }
      }
    } else {
      cx.ThrowErrorMessage<MSG_NOT_OBJECT>("'style' member of InspectorDeclaration");
      return false;
    }
    mIsAnyMemberPresent = true;
  } else if (cx) {
    // Don't error out if we have no cx.  In that
    // situation the caller is default-constructing us and we'll
    // just assume they know what they're doing.
    return cx.ThrowErrorMessage<MSG_MISSING_REQUIRED_DICTIONARY_MEMBER>("'style' member of InspectorDeclaration");
  }
  return true;
}

bool
InspectorDeclaration::Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription, bool passedToJSImpl)
{
  // We don't want to use sourceDescription for our context here;
  // that's not really what it's formatted for.
  BindingCallContext cx(cx_, nullptr);
  return Init(cx, val, sourceDescription, passedToJSImpl);
}

bool
InspectorDeclaration::ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const
{
  InspectorDeclarationAtoms* atomsCache = GetAtomCache<InspectorDeclarationAtoms>(cx);
  if (reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
      !InitIds(cx, atomsCache)) {
    return false;
  }

  JS::Rooted<JSObject*> obj(cx, JS_NewPlainObject(cx));
  if (!obj) {
    return false;
  }
  rval.set(JS::ObjectValue(*obj));

  do {
    // block for our 'break' successCode and scope for 'temp' and 'currentValue'
    JS::Rooted<JS::Value> temp(cx);
    DeclarationOrigin const & currentValue = mDeclarationOrigin;
    if (!ToJSValue(cx, currentValue, &temp)) {
      return false;
    }
    if (!JS_DefinePropertyById(cx, obj, atomsCache->declarationOrigin_id, temp, JSPROP_ENUMERATE)) {
      return false;
    }
    break;
  } while(false);

  do {
    // block for our 'break' successCode and scope for 'temp' and 'currentValue'
    JS::Rooted<JS::Value> temp(cx);
    OwningNonNull<nsICSSDeclaration> const & currentValue = mStyle;
    if (!GetOrCreateDOMReflector(cx, currentValue, &temp)) {
      MOZ_ASSERT(JS_IsExceptionPending(cx));
      return false;
    }
    if (!JS_DefinePropertyById(cx, obj, atomsCache->style_id, temp, JSPROP_ENUMERATE)) {
      return false;
    }
    break;
  } while(false);

  return true;
}

void
InspectorDeclaration::TraceDictionary(JSTracer* trc)
{
}



InspectorDeclaration&
InspectorDeclaration::operator=(const InspectorDeclaration& aOther)
{
  DictionaryBase::operator=(aOther);
  mDeclarationOrigin = aOther.mDeclarationOrigin;
  mStyle = aOther.mStyle;
  return *this;
}



InspectorFontFeature::InspectorFontFeature()
{
  // Safe to pass a null context if we pass a null value
  Init();
}




bool
InspectorFontFeature::InitIds(JSContext* cx, InspectorFontFeatureAtoms* atomsCache)
{
  MOZ_ASSERT(reinterpret_cast<jsid*>(atomsCache)->isVoid());

  // Initialize these in reverse order so that any failure leaves the first one
  // uninitialized.
  if (!atomsCache->tag_id.init(cx, "tag") ||
      !atomsCache->script_id.init(cx, "script") ||
      !atomsCache->languageSystem_id.init(cx, "languageSystem")) {
    return false;
  }
  return true;
}

bool
InspectorFontFeature::Init(const char* sourceDescription, bool passedToJSImpl)
{
  return true;
}

bool
InspectorFontFeature::ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const
{
  InspectorFontFeatureAtoms* atomsCache = GetAtomCache<InspectorFontFeatureAtoms>(cx);
  if (reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
      !InitIds(cx, atomsCache)) {
    return false;
  }

  JS::Rooted<JSObject*> obj(cx, JS_NewPlainObject(cx));
  if (!obj) {
    return false;
  }
  rval.set(JS::ObjectValue(*obj));

  do {
    // block for our 'break' successCode and scope for 'temp' and 'currentValue'
    JS::Rooted<JS::Value> temp(cx);
    nsString const & currentValue = mLanguageSystem;
    if (!xpc::NonVoidStringToJsval(cx, currentValue, &temp)) {
      return false;
    }
    if (!JS_DefinePropertyById(cx, obj, atomsCache->languageSystem_id, temp, JSPROP_ENUMERATE)) {
      return false;
    }
    break;
  } while(false);

  do {
    // block for our 'break' successCode and scope for 'temp' and 'currentValue'
    JS::Rooted<JS::Value> temp(cx);
    nsString const & currentValue = mScript;
    if (!xpc::NonVoidStringToJsval(cx, currentValue, &temp)) {
      return false;
    }
    if (!JS_DefinePropertyById(cx, obj, atomsCache->script_id, temp, JSPROP_ENUMERATE)) {
      return false;
    }
    break;
  } while(false);

  do {
    // block for our 'break' successCode and scope for 'temp' and 'currentValue'
    JS::Rooted<JS::Value> temp(cx);
    nsString const & currentValue = mTag;
    if (!xpc::NonVoidStringToJsval(cx, currentValue, &temp)) {
      return false;
    }
    if (!JS_DefinePropertyById(cx, obj, atomsCache->tag_id, temp, JSPROP_ENUMERATE)) {
      return false;
    }
    break;
  } while(false);

  return true;
}

void
InspectorFontFeature::TraceDictionary(JSTracer* trc)
{
}

InspectorFontFeature&
InspectorFontFeature::operator=(const InspectorFontFeature& aOther)
{
  DictionaryBase::operator=(aOther);
  mLanguageSystem = aOther.mLanguageSystem;
  mScript = aOther.mScript;
  mTag = aOther.mTag;
  return *this;
}



InspectorNearestColor::InspectorNearestColor()
{
  // Safe to pass a null context if we pass a null value
  Init();
}




bool
InspectorNearestColor::InitIds(JSContext* cx, InspectorNearestColorAtoms* atomsCache)
{
  MOZ_ASSERT(reinterpret_cast<jsid*>(atomsCache)->isVoid());

  // Initialize these in reverse order so that any failure leaves the first one
  // uninitialized.
  if (!atomsCache->exact_id.init(cx, "exact") ||
      !atomsCache->colorName_id.init(cx, "colorName")) {
    return false;
  }
  return true;
}

bool
InspectorNearestColor::Init(const char* sourceDescription, bool passedToJSImpl)
{
  return true;
}

bool
InspectorNearestColor::ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const
{
  InspectorNearestColorAtoms* atomsCache = GetAtomCache<InspectorNearestColorAtoms>(cx);
  if (reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
      !InitIds(cx, atomsCache)) {
    return false;
  }

  JS::Rooted<JSObject*> obj(cx, JS_NewPlainObject(cx));
  if (!obj) {
    return false;
  }
  rval.set(JS::ObjectValue(*obj));

  do {
    // block for our 'break' successCode and scope for 'temp' and 'currentValue'
    JS::Rooted<JS::Value> temp(cx);
    nsCString const & currentValue = mColorName;
    if (!NonVoidUTF8StringToJsval(cx, currentValue, &temp)) {
      return false;
    }
    if (!JS_DefinePropertyById(cx, obj, atomsCache->colorName_id, temp, JSPROP_ENUMERATE)) {
      return false;
    }
    break;
  } while(false);

  do {
    // block for our 'break' successCode and scope for 'temp' and 'currentValue'
    JS::Rooted<JS::Value> temp(cx);
    bool const & currentValue = mExact;
    temp.setBoolean(currentValue);
    if (!JS_DefinePropertyById(cx, obj, atomsCache->exact_id, temp, JSPROP_ENUMERATE)) {
      return false;
    }
    break;
  } while(false);

  return true;
}

void
InspectorNearestColor::TraceDictionary(JSTracer* trc)
{
}

InspectorNearestColor&
InspectorNearestColor::operator=(const InspectorNearestColor& aOther)
{
  DictionaryBase::operator=(aOther);
  mColorName = aOther.mColorName;
  mExact = aOther.mExact;
  return *this;
}



InspectorRGBATuple::InspectorRGBATuple()
{
  // Safe to pass a null context if we pass a null value
  Init();
}




bool
InspectorRGBATuple::InitIds(JSContext* cx, InspectorRGBATupleAtoms* atomsCache)
{
  MOZ_ASSERT(reinterpret_cast<jsid*>(atomsCache)->isVoid());

  // Initialize these in reverse order so that any failure leaves the first one
  // uninitialized.
  if (!atomsCache->r_id.init(cx, "r") ||
      !atomsCache->g_id.init(cx, "g") ||
      !atomsCache->b_id.init(cx, "b") ||
      !atomsCache->a_id.init(cx, "a")) {
    return false;
  }
  return true;
}

bool
InspectorRGBATuple::Init(const char* sourceDescription, bool passedToJSImpl)
{
  {
    // scope for any temporaries our default value setting needs.
    mA = 1.0;
  }
  mIsAnyMemberPresent = true;

  {
    // scope for any temporaries our default value setting needs.
    mB = 0.0;
  }
  mIsAnyMemberPresent = true;

  {
    // scope for any temporaries our default value setting needs.
    mG = 0.0;
  }
  mIsAnyMemberPresent = true;

  {
    // scope for any temporaries our default value setting needs.
    mR = 0.0;
  }
  mIsAnyMemberPresent = true;
  return true;
}

bool
InspectorRGBATuple::ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const
{
  InspectorRGBATupleAtoms* atomsCache = GetAtomCache<InspectorRGBATupleAtoms>(cx);
  if (reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
      !InitIds(cx, atomsCache)) {
    return false;
  }

  JS::Rooted<JSObject*> obj(cx, JS_NewPlainObject(cx));
  if (!obj) {
    return false;
  }
  rval.set(JS::ObjectValue(*obj));

  do {
    // block for our 'break' successCode and scope for 'temp' and 'currentValue'
    JS::Rooted<JS::Value> temp(cx);
    double const & currentValue = mA;
    temp.set(JS_NumberValue(double(currentValue)));
    if (!JS_DefinePropertyById(cx, obj, atomsCache->a_id, temp, JSPROP_ENUMERATE)) {
      return false;
    }
    break;
  } while(false);

  do {
    // block for our 'break' successCode and scope for 'temp' and 'currentValue'
    JS::Rooted<JS::Value> temp(cx);
    double const & currentValue = mB;
    temp.set(JS_NumberValue(double(currentValue)));
    if (!JS_DefinePropertyById(cx, obj, atomsCache->b_id, temp, JSPROP_ENUMERATE)) {
      return false;
    }
    break;
  } while(false);

  do {
    // block for our 'break' successCode and scope for 'temp' and 'currentValue'
    JS::Rooted<JS::Value> temp(cx);
    double const & currentValue = mG;
    temp.set(JS_NumberValue(double(currentValue)));
    if (!JS_DefinePropertyById(cx, obj, atomsCache->g_id, temp, JSPROP_ENUMERATE)) {
      return false;
    }
    break;
  } while(false);

  do {
    // block for our 'break' successCode and scope for 'temp' and 'currentValue'
    JS::Rooted<JS::Value> temp(cx);
    double const & currentValue = mR;
    temp.set(JS_NumberValue(double(currentValue)));
    if (!JS_DefinePropertyById(cx, obj, atomsCache->r_id, temp, JSPROP_ENUMERATE)) {
      return false;
    }
    break;
  } while(false);

  return true;
}

void
InspectorRGBATuple::TraceDictionary(JSTracer* trc)
{
}

InspectorRGBATuple&
InspectorRGBATuple::operator=(const InspectorRGBATuple& aOther)
{
  DictionaryBase::operator=(aOther);
  mA = aOther.mA;
  mB = aOther.mB;
  mG = aOther.mG;
  mR = aOther.mR;
  return *this;
}



InspectorStyleSheetRuleCountAndAtRulesResult::InspectorStyleSheetRuleCountAndAtRulesResult()
{
  // Safe to pass a null context if we pass a null value
  Init();
}




bool
InspectorStyleSheetRuleCountAndAtRulesResult::InitIds(JSContext* cx, InspectorStyleSheetRuleCountAndAtRulesResultAtoms* atomsCache)
{
  MOZ_ASSERT(reinterpret_cast<jsid*>(atomsCache)->isVoid());

  // Initialize these in reverse order so that any failure leaves the first one
  // uninitialized.
  if (!atomsCache->ruleCount_id.init(cx, "ruleCount") ||
      !atomsCache->atRules_id.init(cx, "atRules")) {
    return false;
  }
  return true;
}

bool
InspectorStyleSheetRuleCountAndAtRulesResult::Init(const char* sourceDescription, bool passedToJSImpl)
{
  return true;
}

bool
InspectorStyleSheetRuleCountAndAtRulesResult::ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const
{
  InspectorStyleSheetRuleCountAndAtRulesResultAtoms* atomsCache = GetAtomCache<InspectorStyleSheetRuleCountAndAtRulesResultAtoms>(cx);
  if (reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
      !InitIds(cx, atomsCache)) {
    return false;
  }

  JS::Rooted<JSObject*> obj(cx, JS_NewPlainObject(cx));
  if (!obj) {
    return false;
  }
  rval.set(JS::ObjectValue(*obj));

  do {
    // block for our 'break' successCode and scope for 'temp' and 'currentValue'
    JS::Rooted<JS::Value> temp(cx);
    Sequence<OwningNonNull<mozilla::css::Rule>> const & currentValue = mAtRules;

    uint32_t length = currentValue.Length();
    JS::Rooted<JSObject*> returnArray(cx, JS::NewArrayObject(cx, length));
    if (!returnArray) {
      return false;
    }
    // Scope for 'tmp'
    {
      JS::Rooted<JS::Value> tmp(cx);
      for (uint32_t sequenceIdx0 = 0; sequenceIdx0 < length; ++sequenceIdx0) {
        // Control block to let us common up the JS_DefineElement calls when there
        // are different ways to succeed at wrapping the object.
        do {
          if (!GetOrCreateDOMReflector(cx, currentValue[sequenceIdx0], &tmp)) {
            MOZ_ASSERT(JS_IsExceptionPending(cx));
            return false;
          }
          break;
        } while (false);
        if (!JS_DefineElement(cx, returnArray, sequenceIdx0, tmp,
                              JSPROP_ENUMERATE)) {
          return false;
        }
      }
    }
    temp.setObject(*returnArray);
    if (!JS_DefinePropertyById(cx, obj, atomsCache->atRules_id, temp, JSPROP_ENUMERATE)) {
      return false;
    }
    break;
  } while(false);

  do {
    // block for our 'break' successCode and scope for 'temp' and 'currentValue'
    JS::Rooted<JS::Value> temp(cx);
    uint32_t const & currentValue = mRuleCount;
    temp.setNumber(currentValue);
    if (!JS_DefinePropertyById(cx, obj, atomsCache->ruleCount_id, temp, JSPROP_ENUMERATE)) {
      return false;
    }
    break;
  } while(false);

  return true;
}

void
InspectorStyleSheetRuleCountAndAtRulesResult::TraceDictionary(JSTracer* trc)
{
}



InspectorStyleSheetRuleCountAndAtRulesResult&
InspectorStyleSheetRuleCountAndAtRulesResult::operator=(const InspectorStyleSheetRuleCountAndAtRulesResult& aOther)
{
  DictionaryBase::operator=(aOther);
  mAtRules = aOther.mAtRules;
  mRuleCount = aOther.mRuleCount;
  return *this;
}



InspectorVariationAxis::InspectorVariationAxis()
{
  // Safe to pass a null context if we pass a null value
  Init();
}




bool
InspectorVariationAxis::InitIds(JSContext* cx, InspectorVariationAxisAtoms* atomsCache)
{
  MOZ_ASSERT(reinterpret_cast<jsid*>(atomsCache)->isVoid());

  // Initialize these in reverse order so that any failure leaves the first one
  // uninitialized.
  if (!atomsCache->tag_id.init(cx, "tag") ||
      !atomsCache->name_id.init(cx, "name") ||
      !atomsCache->minValue_id.init(cx, "minValue") ||
      !atomsCache->maxValue_id.init(cx, "maxValue") ||
      !atomsCache->defaultValue_id.init(cx, "defaultValue")) {
    return false;
  }
  return true;
}

bool
InspectorVariationAxis::Init(const char* sourceDescription, bool passedToJSImpl)
{
  return true;
}

bool
InspectorVariationAxis::ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const
{
  InspectorVariationAxisAtoms* atomsCache = GetAtomCache<InspectorVariationAxisAtoms>(cx);
  if (reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
      !InitIds(cx, atomsCache)) {
    return false;
  }

  JS::Rooted<JSObject*> obj(cx, JS_NewPlainObject(cx));
  if (!obj) {
    return false;
  }
  rval.set(JS::ObjectValue(*obj));

  do {
    // block for our 'break' successCode and scope for 'temp' and 'currentValue'
    JS::Rooted<JS::Value> temp(cx);
    float const & currentValue = mDefaultValue;
    temp.set(JS_NumberValue(double(currentValue)));
    if (!JS_DefinePropertyById(cx, obj, atomsCache->defaultValue_id, temp, JSPROP_ENUMERATE)) {
      return false;
    }
    break;
  } while(false);

  do {
    // block for our 'break' successCode and scope for 'temp' and 'currentValue'
    JS::Rooted<JS::Value> temp(cx);
    float const & currentValue = mMaxValue;
    temp.set(JS_NumberValue(double(currentValue)));
    if (!JS_DefinePropertyById(cx, obj, atomsCache->maxValue_id, temp, JSPROP_ENUMERATE)) {
      return false;
    }
    break;
  } while(false);

  do {
    // block for our 'break' successCode and scope for 'temp' and 'currentValue'
    JS::Rooted<JS::Value> temp(cx);
    float const & currentValue = mMinValue;
    temp.set(JS_NumberValue(double(currentValue)));
    if (!JS_DefinePropertyById(cx, obj, atomsCache->minValue_id, temp, JSPROP_ENUMERATE)) {
      return false;
    }
    break;
  } while(false);

  do {
    // block for our 'break' successCode and scope for 'temp' and 'currentValue'
    JS::Rooted<JS::Value> temp(cx);
    nsString const & currentValue = mName;
    if (!xpc::NonVoidStringToJsval(cx, currentValue, &temp)) {
      return false;
    }
    if (!JS_DefinePropertyById(cx, obj, atomsCache->name_id, temp, JSPROP_ENUMERATE)) {
      return false;
    }
    break;
  } while(false);

  do {
    // block for our 'break' successCode and scope for 'temp' and 'currentValue'
    JS::Rooted<JS::Value> temp(cx);
    nsString const & currentValue = mTag;
    if (!xpc::NonVoidStringToJsval(cx, currentValue, &temp)) {
      return false;
    }
    if (!JS_DefinePropertyById(cx, obj, atomsCache->tag_id, temp, JSPROP_ENUMERATE)) {
      return false;
    }
    break;
  } while(false);

  return true;
}

void
InspectorVariationAxis::TraceDictionary(JSTracer* trc)
{
}

InspectorVariationAxis&
InspectorVariationAxis::operator=(const InspectorVariationAxis& aOther)
{
  DictionaryBase::operator=(aOther);
  mDefaultValue = aOther.mDefaultValue;
  mMaxValue = aOther.mMaxValue;
  mMinValue = aOther.mMinValue;
  mName = aOther.mName;
  mTag = aOther.mTag;
  return *this;
}



InspectorVariationValue::InspectorVariationValue()
{
  // Safe to pass a null context if we pass a null value
  Init();
}




bool
InspectorVariationValue::InitIds(JSContext* cx, InspectorVariationValueAtoms* atomsCache)
{
  MOZ_ASSERT(reinterpret_cast<jsid*>(atomsCache)->isVoid());

  // Initialize these in reverse order so that any failure leaves the first one
  // uninitialized.
  if (!atomsCache->value_id.init(cx, "value") ||
      !atomsCache->axis_id.init(cx, "axis")) {
    return false;
  }
  return true;
}

bool
InspectorVariationValue::Init(const char* sourceDescription, bool passedToJSImpl)
{
  return true;
}

bool
InspectorVariationValue::ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const
{
  InspectorVariationValueAtoms* atomsCache = GetAtomCache<InspectorVariationValueAtoms>(cx);
  if (reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
      !InitIds(cx, atomsCache)) {
    return false;
  }

  JS::Rooted<JSObject*> obj(cx, JS_NewPlainObject(cx));
  if (!obj) {
    return false;
  }
  rval.set(JS::ObjectValue(*obj));

  do {
    // block for our 'break' successCode and scope for 'temp' and 'currentValue'
    JS::Rooted<JS::Value> temp(cx);
    nsString const & currentValue = mAxis;
    if (!xpc::NonVoidStringToJsval(cx, currentValue, &temp)) {
      return false;
    }
    if (!JS_DefinePropertyById(cx, obj, atomsCache->axis_id, temp, JSPROP_ENUMERATE)) {
      return false;
    }
    break;
  } while(false);

  do {
    // block for our 'break' successCode and scope for 'temp' and 'currentValue'
    JS::Rooted<JS::Value> temp(cx);
    float const & currentValue = mValue;
    temp.set(JS_NumberValue(double(currentValue)));
    if (!JS_DefinePropertyById(cx, obj, atomsCache->value_id, temp, JSPROP_ENUMERATE)) {
      return false;
    }
    break;
  } while(false);

  return true;
}

void
InspectorVariationValue::TraceDictionary(JSTracer* trc)
{
}

InspectorVariationValue&
InspectorVariationValue::operator=(const InspectorVariationValue& aOther)
{
  DictionaryBase::operator=(aOther);
  mAxis = aOther.mAxis;
  mValue = aOther.mValue;
  return *this;
}



PropertyNamesOptions::PropertyNamesOptions()
{
  // Safe to pass a null context if we pass a null value
  Init(nullptr, JS::NullHandleValue);
}




bool
PropertyNamesOptions::InitIds(JSContext* cx, PropertyNamesOptionsAtoms* atomsCache)
{
  MOZ_ASSERT(reinterpret_cast<jsid*>(atomsCache)->isVoid());

  // Initialize these in reverse order so that any failure leaves the first one
  // uninitialized.
  if (!atomsCache->includeShorthands_id.init(cx, "includeShorthands") ||
      !atomsCache->includeExperimentals_id.init(cx, "includeExperimentals") ||
      !atomsCache->includeAliases_id.init(cx, "includeAliases")) {
    return false;
  }
  return true;
}

bool
PropertyNamesOptions::Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription, bool passedToJSImpl)
{
  // Passing a null JSContext is OK only if we're initing from null,
  // Since in that case we will not have to do any property gets
  // Also evaluate isNullOrUndefined in order to avoid false-positive
  // checkers by static analysis tools
  MOZ_ASSERT_IF(!cx, val.isNull() && val.isNullOrUndefined());
  PropertyNamesOptionsAtoms* atomsCache = nullptr;
  if (cx) {
    atomsCache = GetAtomCache<PropertyNamesOptionsAtoms>(cx);
    if (reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
        !InitIds(cx, atomsCache)) {
      return false;
    }
  }

  if (!IsConvertibleToDictionary(val)) {
    return cx.ThrowErrorMessage<MSG_CONVERSION_ERROR>(sourceDescription, "dictionary");
  }

  bool isNull = val.isNullOrUndefined();
  // We only need these if !isNull, in which case we have |cx|.
  Maybe<JS::Rooted<JSObject *> > object;
  Maybe<JS::Rooted<JS::Value> > temp;
  if (!isNull) {
    MOZ_ASSERT(cx);
    object.emplace(cx, &val.toObject());
    temp.emplace(cx);
  }
  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->includeAliases_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    if (!ValueToPrimitive<bool, eDefault>(cx, temp.ref(), "'includeAliases' member of PropertyNamesOptions", &mIncludeAliases)) {
      return false;
    }
  } else {
    mIncludeAliases = false;
  }
  mIsAnyMemberPresent = true;

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->includeExperimentals_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    if (!ValueToPrimitive<bool, eDefault>(cx, temp.ref(), "'includeExperimentals' member of PropertyNamesOptions", &mIncludeExperimentals)) {
      return false;
    }
  } else {
    mIncludeExperimentals = false;
  }
  mIsAnyMemberPresent = true;

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->includeShorthands_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    if (!ValueToPrimitive<bool, eDefault>(cx, temp.ref(), "'includeShorthands' member of PropertyNamesOptions", &mIncludeShorthands)) {
      return false;
    }
  } else {
    mIncludeShorthands = true;
  }
  mIsAnyMemberPresent = true;
  return true;
}

bool
PropertyNamesOptions::Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription, bool passedToJSImpl)
{
  // We don't want to use sourceDescription for our context here;
  // that's not really what it's formatted for.
  BindingCallContext cx(cx_, nullptr);
  return Init(cx, val, sourceDescription, passedToJSImpl);
}

void
PropertyNamesOptions::TraceDictionary(JSTracer* trc)
{
}

PropertyNamesOptions&
PropertyNamesOptions::operator=(const PropertyNamesOptions& aOther)
{
  DictionaryBase::operator=(aOther);
  mIncludeAliases = aOther.mIncludeAliases;
  mIncludeExperimentals = aOther.mIncludeExperimentals;
  mIncludeShorthands = aOther.mIncludeShorthands;
  return *this;
}



PropertyPref::PropertyPref()
{
  // Safe to pass a null context if we pass a null value
  Init();
}




bool
PropertyPref::InitIds(JSContext* cx, PropertyPrefAtoms* atomsCache)
{
  MOZ_ASSERT(reinterpret_cast<jsid*>(atomsCache)->isVoid());

  // Initialize these in reverse order so that any failure leaves the first one
  // uninitialized.
  if (!atomsCache->pref_id.init(cx, "pref") ||
      !atomsCache->name_id.init(cx, "name")) {
    return false;
  }
  return true;
}

bool
PropertyPref::Init(const char* sourceDescription, bool passedToJSImpl)
{
  return true;
}

bool
PropertyPref::ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const
{
  PropertyPrefAtoms* atomsCache = GetAtomCache<PropertyPrefAtoms>(cx);
  if (reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
      !InitIds(cx, atomsCache)) {
    return false;
  }

  JS::Rooted<JSObject*> obj(cx, JS_NewPlainObject(cx));
  if (!obj) {
    return false;
  }
  rval.set(JS::ObjectValue(*obj));

  do {
    // block for our 'break' successCode and scope for 'temp' and 'currentValue'
    JS::Rooted<JS::Value> temp(cx);
    nsString const & currentValue = mName;
    if (!xpc::NonVoidStringToJsval(cx, currentValue, &temp)) {
      return false;
    }
    if (!JS_DefinePropertyById(cx, obj, atomsCache->name_id, temp, JSPROP_ENUMERATE)) {
      return false;
    }
    break;
  } while(false);

  do {
    // block for our 'break' successCode and scope for 'temp' and 'currentValue'
    JS::Rooted<JS::Value> temp(cx);
    nsString const & currentValue = mPref;
    if (!xpc::NonVoidStringToJsval(cx, currentValue, &temp)) {
      return false;
    }
    if (!JS_DefinePropertyById(cx, obj, atomsCache->pref_id, temp, JSPROP_ENUMERATE)) {
      return false;
    }
    break;
  } while(false);

  return true;
}

void
PropertyPref::TraceDictionary(JSTracer* trc)
{
}

PropertyPref&
PropertyPref::operator=(const PropertyPref& aOther)
{
  DictionaryBase::operator=(aOther);
  mName = aOther.mName;
  mPref = aOther.mPref;
  return *this;
}



SupportsOptions::SupportsOptions()
{
  // Safe to pass a null context if we pass a null value
  Init(nullptr, JS::NullHandleValue);
}




bool
SupportsOptions::InitIds(JSContext* cx, SupportsOptionsAtoms* atomsCache)
{
  MOZ_ASSERT(reinterpret_cast<jsid*>(atomsCache)->isVoid());

  // Initialize these in reverse order so that any failure leaves the first one
  // uninitialized.
  if (!atomsCache->userAgent_id.init(cx, "userAgent") ||
      !atomsCache->quirks_id.init(cx, "quirks") ||
      !atomsCache->chrome_id.init(cx, "chrome")) {
    return false;
  }
  return true;
}

bool
SupportsOptions::Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription, bool passedToJSImpl)
{
  // Passing a null JSContext is OK only if we're initing from null,
  // Since in that case we will not have to do any property gets
  // Also evaluate isNullOrUndefined in order to avoid false-positive
  // checkers by static analysis tools
  MOZ_ASSERT_IF(!cx, val.isNull() && val.isNullOrUndefined());
  SupportsOptionsAtoms* atomsCache = nullptr;
  if (cx) {
    atomsCache = GetAtomCache<SupportsOptionsAtoms>(cx);
    if (reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
        !InitIds(cx, atomsCache)) {
      return false;
    }
  }

  if (!IsConvertibleToDictionary(val)) {
    return cx.ThrowErrorMessage<MSG_CONVERSION_ERROR>(sourceDescription, "dictionary");
  }

  bool isNull = val.isNullOrUndefined();
  // We only need these if !isNull, in which case we have |cx|.
  Maybe<JS::Rooted<JSObject *> > object;
  Maybe<JS::Rooted<JS::Value> > temp;
  if (!isNull) {
    MOZ_ASSERT(cx);
    object.emplace(cx, &val.toObject());
    temp.emplace(cx);
  }
  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->chrome_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    if (!ValueToPrimitive<bool, eDefault>(cx, temp.ref(), "'chrome' member of SupportsOptions", &mChrome)) {
      return false;
    }
  } else {
    mChrome = false;
  }
  mIsAnyMemberPresent = true;

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->quirks_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    if (!ValueToPrimitive<bool, eDefault>(cx, temp.ref(), "'quirks' member of SupportsOptions", &mQuirks)) {
      return false;
    }
  } else {
    mQuirks = false;
  }
  mIsAnyMemberPresent = true;

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->userAgent_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    if (!ValueToPrimitive<bool, eDefault>(cx, temp.ref(), "'userAgent' member of SupportsOptions", &mUserAgent)) {
      return false;
    }
  } else {
    mUserAgent = false;
  }
  mIsAnyMemberPresent = true;
  return true;
}

bool
SupportsOptions::Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription, bool passedToJSImpl)
{
  // We don't want to use sourceDescription for our context here;
  // that's not really what it's formatted for.
  BindingCallContext cx(cx_, nullptr);
  return Init(cx, val, sourceDescription, passedToJSImpl);
}

void
SupportsOptions::TraceDictionary(JSTracer* trc)
{
}

SupportsOptions&
SupportsOptions::operator=(const SupportsOptions& aOther)
{
  DictionaryBase::operator=(aOther);
  mChrome = aOther.mChrome;
  mQuirks = aOther.mQuirks;
  mUserAgent = aOther.mUserAgent;
  return *this;
}


bool
CSSRuleOrInspectorDeclaration::TrySetToCSSRule(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl)
{
  tryNext = false;
  { // scope for memberSlot
    NonNull<mozilla::css::Rule>& memberSlot = RawSetAsCSSRule();
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::CSSRule, mozilla::css::Rule>(value, memberSlot, cx);
      if (NS_FAILED(rv)) {
        DestroyCSSRule();
        tryNext = true;
        return true;
      }
    }
  }
  return true;
}

bool
CSSRuleOrInspectorDeclaration::TrySetToCSSRule(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl)
{
  BindingCallContext cx(cx_, nullptr);
  return TrySetToCSSRule(cx, value, tryNext, passedToJSImpl);
}







bool
CSSRuleOrInspectorDeclaration::TrySetToInspectorDeclaration(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl)
{
  tryNext = false;
  { // scope for memberSlot
    binding_detail::FastInspectorDeclaration& memberSlot = RawSetAsInspectorDeclaration();
    if (!IsConvertibleToDictionary(value)) {
      DestroyInspectorDeclaration();
      tryNext = true;
      return true;
    }
    if (!memberSlot.Init(cx, value, "InspectorDeclaration branch of (CSSRule or InspectorDeclaration)", passedToJSImpl)) {
      return false;
    }
  }
  return true;
}

bool
CSSRuleOrInspectorDeclaration::TrySetToInspectorDeclaration(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl)
{
  BindingCallContext cx(cx_, nullptr);
  return TrySetToInspectorDeclaration(cx, value, tryNext, passedToJSImpl);
}







bool
CSSRuleOrInspectorDeclaration::Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription, bool passedToJSImpl)
{
  MOZ_ASSERT(mType == eUninitialized);

  bool done = false, failed = false, tryNext;
  if (value.isObject()) {
    done = (failed = !TrySetToCSSRule(cx, value, tryNext, passedToJSImpl)) || !tryNext;
  }
  if (!done) {
    done = (failed = !TrySetToInspectorDeclaration(cx, value, tryNext, passedToJSImpl)) || !tryNext;
  }
  if (failed) {
    return false;
  }
  if (!done) {
    cx.ThrowErrorMessage<MSG_NOT_IN_UNION>(sourceDescription, "CSSRule, InspectorDeclaration");
    return false;
  }
  return true;
}

bool
CSSRuleOrInspectorDeclaration::Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription, bool passedToJSImpl)
{
  BindingCallContext cx(cx_, nullptr);
  return Init(cx, value, sourceDescription, passedToJSImpl);
}


bool
CSSRuleOrInspectorDeclaration::ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const
{
  switch (mType) {
    case eUninitialized: {
      return false;
    }
    case eCSSRule: {
      if (!GetOrCreateDOMReflector(cx, mValue.mCSSRule.Value(), rval)) {
        MOZ_ASSERT(JS_IsExceptionPending(cx));
        return false;
      }
      return true;
    }
    case eInspectorDeclaration: {
      if (!mValue.mInspectorDeclaration.Value().ToObjectInternal(cx, rval)) {
        return false;
      }
      return true;
    }
    default: {
      return false;
    }
  }
}



OwningCSSRuleOrInspectorDeclaration::OwningCSSRuleOrInspectorDeclaration(OwningCSSRuleOrInspectorDeclaration&& aOther)
  : mType(eUninitialized)
{
  switch (aOther.mType) {
    case eUninitialized: {
      MOZ_ASSERT(mType == eUninitialized,
                 "We need to destroy ourselves?");
      break;
    }
    case eCSSRule: {
      mType = eCSSRule;
      mValue.mCSSRule.SetValue(std::move(aOther.mValue.mCSSRule.Value()));
      break;
    }
    case eInspectorDeclaration: {
      mType = eInspectorDeclaration;
      mValue.mInspectorDeclaration.SetValue(std::move(aOther.mValue.mInspectorDeclaration.Value()));
      break;
    }
  }
}



bool
OwningCSSRuleOrInspectorDeclaration::TrySetToCSSRule(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl)
{
  tryNext = false;
  { // scope for memberSlot
    OwningNonNull<mozilla::css::Rule>& memberSlot = RawSetAsCSSRule();
    static_assert(IsRefcounted<mozilla::css::Rule>::value, "We can only store refcounted classes.");
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::CSSRule, mozilla::css::Rule>(value, memberSlot, cx);
      if (NS_FAILED(rv)) {
        DestroyCSSRule();
        tryNext = true;
        return true;
      }
    }
  }
  return true;
}

bool
OwningCSSRuleOrInspectorDeclaration::TrySetToCSSRule(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl)
{
  BindingCallContext cx(cx_, nullptr);
  return TrySetToCSSRule(cx, value, tryNext, passedToJSImpl);
}

[[nodiscard]] OwningNonNull<mozilla::css::Rule>&
OwningCSSRuleOrInspectorDeclaration::RawSetAsCSSRule()
{
  if (mType == eCSSRule) {
    return mValue.mCSSRule.Value();
  }
  MOZ_ASSERT(mType == eUninitialized);
  mType = eCSSRule;
  return mValue.mCSSRule.SetValue();
}

[[nodiscard]] OwningNonNull<mozilla::css::Rule>&
OwningCSSRuleOrInspectorDeclaration::SetAsCSSRule()
{
  if (mType == eCSSRule) {
    return mValue.mCSSRule.Value();
  }
  Uninit();
  mType = eCSSRule;
  return mValue.mCSSRule.SetValue();
}


void
OwningCSSRuleOrInspectorDeclaration::DestroyCSSRule()
{
  MOZ_RELEASE_ASSERT(IsCSSRule(), "Wrong type!");
  mValue.mCSSRule.Destroy();
  mType = eUninitialized;
}



bool
OwningCSSRuleOrInspectorDeclaration::TrySetToInspectorDeclaration(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl)
{
  tryNext = false;
  { // scope for memberSlot
    InspectorDeclaration& memberSlot = RawSetAsInspectorDeclaration();
    if (!IsConvertibleToDictionary(value)) {
      DestroyInspectorDeclaration();
      tryNext = true;
      return true;
    }
    if (!memberSlot.Init(cx, value, "InspectorDeclaration branch of (CSSRule or InspectorDeclaration)", passedToJSImpl)) {
      return false;
    }
  }
  return true;
}

bool
OwningCSSRuleOrInspectorDeclaration::TrySetToInspectorDeclaration(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl)
{
  BindingCallContext cx(cx_, nullptr);
  return TrySetToInspectorDeclaration(cx, value, tryNext, passedToJSImpl);
}

[[nodiscard]] InspectorDeclaration&
OwningCSSRuleOrInspectorDeclaration::RawSetAsInspectorDeclaration()
{
  if (mType == eInspectorDeclaration) {
    return mValue.mInspectorDeclaration.Value();
  }
  MOZ_ASSERT(mType == eUninitialized);
  mType = eInspectorDeclaration;
  return mValue.mInspectorDeclaration.SetValue();
}

[[nodiscard]] InspectorDeclaration&
OwningCSSRuleOrInspectorDeclaration::SetAsInspectorDeclaration()
{
  if (mType == eInspectorDeclaration) {
    return mValue.mInspectorDeclaration.Value();
  }
  Uninit();
  mType = eInspectorDeclaration;
  return mValue.mInspectorDeclaration.SetValue();
}


void
OwningCSSRuleOrInspectorDeclaration::DestroyInspectorDeclaration()
{
  MOZ_RELEASE_ASSERT(IsInspectorDeclaration(), "Wrong type!");
  mValue.mInspectorDeclaration.Destroy();
  mType = eUninitialized;
}



bool
OwningCSSRuleOrInspectorDeclaration::Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription, bool passedToJSImpl)
{
  MOZ_ASSERT(mType == eUninitialized);

  bool done = false, failed = false, tryNext;
  if (value.isObject()) {
    done = (failed = !TrySetToCSSRule(cx, value, tryNext, passedToJSImpl)) || !tryNext;
  }
  if (!done) {
    done = (failed = !TrySetToInspectorDeclaration(cx, value, tryNext, passedToJSImpl)) || !tryNext;
  }
  if (failed) {
    return false;
  }
  if (!done) {
    cx.ThrowErrorMessage<MSG_NOT_IN_UNION>(sourceDescription, "CSSRule, InspectorDeclaration");
    return false;
  }
  return true;
}

bool
OwningCSSRuleOrInspectorDeclaration::Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription, bool passedToJSImpl)
{
  BindingCallContext cx(cx_, nullptr);
  return Init(cx, value, sourceDescription, passedToJSImpl);
}

void
OwningCSSRuleOrInspectorDeclaration::Uninit()
{
  switch (mType) {
    case eUninitialized: {
      break;
    }
    case eCSSRule: {
      DestroyCSSRule();
      break;
    }
    case eInspectorDeclaration: {
      DestroyInspectorDeclaration();
      break;
    }
  }
}

bool
OwningCSSRuleOrInspectorDeclaration::ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const
{
  switch (mType) {
    case eUninitialized: {
      return false;
    }
    case eCSSRule: {
      if (!GetOrCreateDOMReflector(cx, mValue.mCSSRule.Value(), rval)) {
        MOZ_ASSERT(JS_IsExceptionPending(cx));
        return false;
      }
      return true;
    }
    case eInspectorDeclaration: {
      if (!mValue.mInspectorDeclaration.Value().ToObjectInternal(cx, rval)) {
        return false;
      }
      return true;
    }
    default: {
      return false;
    }
  }
}

OwningCSSRuleOrInspectorDeclaration&
OwningCSSRuleOrInspectorDeclaration::operator=(OwningCSSRuleOrInspectorDeclaration&& aOther)
{
  this->~OwningCSSRuleOrInspectorDeclaration();
  new (this) OwningCSSRuleOrInspectorDeclaration (std::move(aOther));
  return *this;
}


OwningCSSRuleOrInspectorDeclaration&
OwningCSSRuleOrInspectorDeclaration::operator=(const OwningCSSRuleOrInspectorDeclaration& aOther)
{
  switch (aOther.mType) {
    case eUninitialized: {
      MOZ_ASSERT(mType == eUninitialized,
                 "We need to destroy ourselves?");
      break;
    }
    case eCSSRule: {
      SetAsCSSRule() = aOther.GetAsCSSRule();
      break;
    }
    case eInspectorDeclaration: {
      SetAsInspectorDeclaration() = aOther.GetAsInspectorDeclaration();
      break;
    }
  }
  return *this;
}



InspectorVariationInstance::InspectorVariationInstance()
{
  // Safe to pass a null context if we pass a null value
  Init();
}




bool
InspectorVariationInstance::InitIds(JSContext* cx, InspectorVariationInstanceAtoms* atomsCache)
{
  MOZ_ASSERT(reinterpret_cast<jsid*>(atomsCache)->isVoid());

  // Initialize these in reverse order so that any failure leaves the first one
  // uninitialized.
  if (!atomsCache->values_id.init(cx, "values") ||
      !atomsCache->name_id.init(cx, "name")) {
    return false;
  }
  return true;
}

bool
InspectorVariationInstance::Init(const char* sourceDescription, bool passedToJSImpl)
{
  return true;
}

bool
InspectorVariationInstance::ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const
{
  InspectorVariationInstanceAtoms* atomsCache = GetAtomCache<InspectorVariationInstanceAtoms>(cx);
  if (reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
      !InitIds(cx, atomsCache)) {
    return false;
  }

  JS::Rooted<JSObject*> obj(cx, JS_NewPlainObject(cx));
  if (!obj) {
    return false;
  }
  rval.set(JS::ObjectValue(*obj));

  do {
    // block for our 'break' successCode and scope for 'temp' and 'currentValue'
    JS::Rooted<JS::Value> temp(cx);
    nsString const & currentValue = mName;
    if (!xpc::NonVoidStringToJsval(cx, currentValue, &temp)) {
      return false;
    }
    if (!JS_DefinePropertyById(cx, obj, atomsCache->name_id, temp, JSPROP_ENUMERATE)) {
      return false;
    }
    break;
  } while(false);

  do {
    // block for our 'break' successCode and scope for 'temp' and 'currentValue'
    JS::Rooted<JS::Value> temp(cx);
    Sequence<InspectorVariationValue> const & currentValue = mValues;

    uint32_t length = currentValue.Length();
    JS::Rooted<JSObject*> returnArray(cx, JS::NewArrayObject(cx, length));
    if (!returnArray) {
      return false;
    }
    // Scope for 'tmp'
    {
      JS::Rooted<JS::Value> tmp(cx);
      for (uint32_t sequenceIdx0 = 0; sequenceIdx0 < length; ++sequenceIdx0) {
        // Control block to let us common up the JS_DefineElement calls when there
        // are different ways to succeed at wrapping the object.
        do {
          if (!currentValue[sequenceIdx0].ToObjectInternal(cx, &tmp)) {
            return false;
          }
          break;
        } while (false);
        if (!JS_DefineElement(cx, returnArray, sequenceIdx0, tmp,
                              JSPROP_ENUMERATE)) {
          return false;
        }
      }
    }
    temp.setObject(*returnArray);
    if (!JS_DefinePropertyById(cx, obj, atomsCache->values_id, temp, JSPROP_ENUMERATE)) {
      return false;
    }
    break;
  } while(false);

  return true;
}

void
InspectorVariationInstance::TraceDictionary(JSTracer* trc)
{
}

InspectorVariationInstance&
InspectorVariationInstance::operator=(const InspectorVariationInstance& aOther)
{
  DictionaryBase::operator=(aOther);
  mName = aOther.mName;
  mValues = aOther.mValues;
  return *this;
}


namespace InspectorCSSParser_Binding {

MOZ_CAN_RUN_SCRIPT static bool
get_lineNumber(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "InspectorCSSParser", "lineNumber", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::InspectorCSSParser*>(void_self);
  uint32_t result(MOZ_KnownLive(self)->LineNumber());
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setNumber(result);
  return true;
}

static const JSJitInfo lineNumber_getterinfo = {
  { get_lineNumber },
  { prototypes::id::InspectorCSSParser },
  { PrototypeTraits<prototypes::id::InspectorCSSParser>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_DOUBLE,  /* returnType.  Not relevant for setters. */
  true,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_columnNumber(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "InspectorCSSParser", "columnNumber", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::InspectorCSSParser*>(void_self);
  uint32_t result(MOZ_KnownLive(self)->ColumnNumber());
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setNumber(result);
  return true;
}

static const JSJitInfo columnNumber_getterinfo = {
  { get_columnNumber },
  { prototypes::id::InspectorCSSParser },
  { PrototypeTraits<prototypes::id::InspectorCSSParser>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_DOUBLE,  /* returnType.  Not relevant for setters. */
  true,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
nextToken(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "InspectorCSSParser", "nextToken", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::InspectorCSSParser*>(void_self);
  Nullable<InspectorCSSToken> result;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->NextToken(result))>, "Should be returning void here");
  MOZ_KnownLive(self)->NextToken(result);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (result.IsNull()) {
    args.rval().setNull();
    return true;
  }
  if (!result.Value().ToObjectInternal(cx, args.rval())) {
    return false;
  }
  return true;
}

static const JSJitInfo nextToken_methodinfo = {
  { (JSJitGetterOp)nextToken },
  { prototypes::id::InspectorCSSParser },
  { PrototypeTraits<prototypes::id::InspectorCSSParser>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

static void
_finalize(JS::GCContext* gcx, JSObject* obj)
{
  mozilla::dom::InspectorCSSParser* self = UnwrapPossiblyNotInitializedDOMObject<mozilla::dom::InspectorCSSParser>(obj);
  if (self) {
    JS::SetReservedSlot(obj, DOM_OBJECT_SLOT, JS::UndefinedValue());
    if (size_t mallocBytes = BindingJSObjectMallocBytes(self)) {
      JS::RemoveAssociatedMemory(obj, mallocBytes,
                                 JS::MemoryUse::DOMBinding);
    }
    AddForDeferredFinalization<mozilla::dom::InspectorCSSParser>(self);
  }
}

MOZ_GLOBINIT static const JSFunctionSpec sMethods_specs[] = {
  JS_FNSPEC("nextToken", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&nextToken_methodinfo), 0, JSPROP_ENUMERATE, nullptr),
  JS_FS_END
};


static const Prefable<const JSFunctionSpec> sMethods[] = {
  { nullptr, &sMethods_specs[0] },
  { nullptr, nullptr }
};

static_assert(1 <= 1ull << NUM_BITS_PROPERTY_INFO_PREF_INDEX,
    "We have a prefable index that is >= (1 << NUM_BITS_PROPERTY_INFO_PREF_INDEX)");
static_assert(1 <= 1ull << NUM_BITS_PROPERTY_INFO_SPEC_INDEX,
    "We have a spec index that is >= (1 << NUM_BITS_PROPERTY_INFO_SPEC_INDEX)");

MOZ_GLOBINIT static const JSPropertySpec sAttributes_specs[] = {
  JSPropertySpec::nativeAccessors("lineNumber", JSPROP_ENUMERATE, GenericGetter<NormalThisPolicy, ThrowExceptions>, &lineNumber_getterinfo, nullptr, nullptr),
  JSPropertySpec::nativeAccessors("columnNumber", JSPROP_ENUMERATE, GenericGetter<NormalThisPolicy, ThrowExceptions>, &columnNumber_getterinfo, nullptr, nullptr),
  JS_PS_END
};


static const Prefable<const JSPropertySpec> sAttributes[] = {
  { nullptr, &sAttributes_specs[0] },
  { nullptr, nullptr }
};

static_assert(1 <= 1ull << NUM_BITS_PROPERTY_INFO_PREF_INDEX,
    "We have a prefable index that is >= (1 << NUM_BITS_PROPERTY_INFO_PREF_INDEX)");
static_assert(2 <= 1ull << NUM_BITS_PROPERTY_INFO_SPEC_INDEX,
    "We have a spec index that is >= (1 << NUM_BITS_PROPERTY_INFO_SPEC_INDEX)");


static uint16_t sNativeProperties_sortedPropertyIndices[3];
static PropertyInfo sNativeProperties_propertyInfos[3];

static const NativePropertiesN<2> sNativeProperties = {
  false, 0,
  false, 0,
  true,  0 /* sMethods */,
  true,  1 /* sAttributes */,
  false, 0,
  false, 0,
  false, 0,
  -1,
  3,
  sNativeProperties_sortedPropertyIndices,
  {
    { sMethods, &sNativeProperties_propertyInfos[0] },
    { sAttributes, &sNativeProperties_propertyInfos[1] }
  }
};
static_assert(3 < 1ull << (CHAR_BIT * sizeof(sNativeProperties.propertyInfoCount)),
    "We have a property info count that is oversized");

bool sNativePropertiesInited = false;
const NativePropertyHooks sNativePropertyHooks = {
  nullptr,
  { sNativeProperties.Upcast(), nullptr, &sNativePropertiesInited },
  prototypes::id::InspectorCSSParser,
  constructors::id::InspectorCSSParser,
  &DefaultXrayExpandoObjectClass
};

static bool
_constructor(JSContext* cx, unsigned argc, JS::Value* vp)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "InspectorCSSParser", "constructor", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  JS::CallArgs args = JS::CallArgsFromVp(argc, vp);
  JS::Rooted<JSObject*> obj(cx, &args.callee());
  if (!args.isConstructing()) {
    return ThrowConstructorWithoutNew(cx, "InspectorCSSParser");
  }

  JS::Rooted<JSObject*> desiredProto(cx);
  if (!GetDesiredProto(cx, args,
                       prototypes::id::InspectorCSSParser,
                       CreateInterfaceObjects,
                       &desiredProto)) {
    return false;
  }

  if (!args.requireAtLeast(cx, "InspectorCSSParser constructor", 1)) {
    return false;
  }
  GlobalObject global(cx, obj);
  if (global.Failed()) {
    return false;
  }

  bool objIsXray = xpc::WrapperFactory::IsXrayWrapper(obj);
  binding_detail::FakeString<char> arg0;
  if (!ConvertJSValueToString(cx, args[0], eStringify, eStringify, arg0)) {
    return false;
  }
  Maybe<JSAutoRealm> ar;
  if (objIsXray) {
    // Since our object is an Xray, we can just CheckedUnwrapStatic:
    // we know Xrays have no dynamic unwrap behavior.
    obj = js::CheckedUnwrapStatic(obj);
    if (!obj) {
      return false;
    }
    ar.emplace(cx, obj);
    if (!JS_WrapObject(cx, &desiredProto)) {
      return false;
    }
  }
  auto result(StrongOrRawPtr<mozilla::dom::InspectorCSSParser>(mozilla::dom::InspectorCSSParser::Constructor(global, Constify(arg0))));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  static_assert(!std::is_pointer_v<decltype(result)>,
                "NewObject implies that we need to keep the object alive with a strong reference.");
  if (!WrapNewBindingNonWrapperCachedObject(cx, obj, result, args.rval(), desiredProto)) {
    MOZ_ASSERT(JS_IsExceptionPending(cx));
    return false;
  }
  return true;
}

static const DOMInterfaceInfo sInterfaceObjectInfo = {
  { _constructor, &sNativePropertyHooks },
  JS::GetRealmFunctionPrototypeHandle,
  PrototypeTraits<prototypes::id::InspectorCSSParser>::Depth,
  prototypes::id::InspectorCSSParser,
  true,
  1,
  "InspectorCSSParser",
};

static const DOMIfaceAndProtoJSClass sPrototypeClass = {
  {
    "InspectorCSSParserPrototype",
    JSCLASS_IS_DOMIFACEANDPROTOJSCLASS | JSCLASS_HAS_RESERVED_SLOTS(DOM_INTERFACE_PROTO_SLOTS_BASE),
    JS_NULL_CLASS_OPS,
    JS_NULL_CLASS_SPEC,
    JS_NULL_CLASS_EXT,
    JS_NULL_OBJECT_OPS
  },
  eInterfacePrototype,
  prototypes::id::InspectorCSSParser,
  PrototypeTraits<prototypes::id::InspectorCSSParser>::Depth,
  &sNativePropertyHooks,
  JS::GetRealmObjectPrototype
};

bool
ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj)
{
  return nsContentUtils::IsCallerChromeOrFuzzingEnabled(aCx, aObj);
}

static JS::Handle<JSObject*>
GetProtoObjectHandle(JSContext* aCx);

static const JSClassOps sClassOps = {
  nullptr,               /* addProperty */
  nullptr,               /* delProperty */
  nullptr,               /* enumerate */
  nullptr, /* newEnumerate */
  nullptr, /* resolve */
  nullptr, /* mayResolve */
  _finalize, /* finalize */
  nullptr, /* call */
  nullptr,               /* construct */
  nullptr, /* trace */
};

static const DOMJSClass sClass = {
  { "InspectorCSSParser",
    JSCLASS_IS_DOMJSCLASS | JSCLASS_FOREGROUND_FINALIZE | JSCLASS_HAS_RESERVED_SLOTS(1),
    &sClassOps,
    JS_NULL_CLASS_SPEC,
    JS_NULL_CLASS_EXT,
    JS_NULL_OBJECT_OPS
  },
  { prototypes::id::InspectorCSSParser, prototypes::id::_ID_Count, prototypes::id::_ID_Count, prototypes::id::_ID_Count, prototypes::id::_ID_Count, prototypes::id::_ID_Count, prototypes::id::_ID_Count, prototypes::id::_ID_Count },
  std::is_base_of_v<nsISupports, mozilla::dom::InspectorCSSParser>,
  &sNativePropertyHooks,
  FindAssociatedGlobalForNative<mozilla::dom::InspectorCSSParser>::Get,
  GetProtoObjectHandle,
  GetCCParticipant<mozilla::dom::InspectorCSSParser>::Get(),
  nullptr,
  nullptr
};
static_assert(1 == DOM_INSTANCE_RESERVED_SLOTS,
              "Must have the right minimal number of reserved slots.");
static_assert(1 >= 1,
              "Must have enough reserved slots.");

bool
Wrap(JSContext* aCx, mozilla::dom::InspectorCSSParser* aObject, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector)
{
  static_assert(std::is_same_v<decltype(aObject), mozilla::dom::InspectorCSSParser*>);
  MOZ_ASSERT(ToSupportsIsCorrect(aObject));
  MOZ_ASSERT_IF(aGivenProto, js::IsObjectInContextCompartment(aGivenProto, aCx));

  JS::Rooted<JSObject*> global(aCx, JS::CurrentGlobalOrNull(aCx));
  JS::Handle<JSObject*> canonicalProto = GetProtoObjectHandle(aCx);
  if (!canonicalProto) {
    return false;
  }
  JS::Rooted<JSObject*> proto(aCx);
  if (aGivenProto) {
    proto = aGivenProto;
    // Unfortunately, while aGivenProto was in the compartment of aCx
    // coming in, we changed compartments to that of "parent" so may need
    // to wrap the proto here.
    if (js::GetContextCompartment(aCx) != JS::GetCompartment(proto)) {
      if (!JS_WrapObject(aCx, &proto)) {
        return false;
      }
    }
  } else {
    proto = canonicalProto;
  }

  BindingJSObjectCreator<mozilla::dom::InspectorCSSParser> creator(aCx);
  creator.CreateObject(aCx, sClass.ToJSClass(), proto, aObject, aReflector);
  if (!aReflector) {
    return false;
  }



  creator.InitializationSucceeded();
  return true;
}

void
CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, DefineInterfaceProperty aDefineOnGlobal)
{
  JS::Heap<JSObject*>* protoCache = &aProtoAndIfaceCache.EntrySlotOrCreate(prototypes::id::InspectorCSSParser);
  JS::Heap<JSObject*>* interfaceCache = &aProtoAndIfaceCache.EntrySlotOrCreate(constructors::id::InspectorCSSParser);

  JS::Handle<JSObject*> parentProto(JS::GetRealmObjectPrototypeHandle(aCx));
  if (!parentProto) {
    return;
  }

  JS::Handle<JSObject*> constructorProto(JS::GetRealmFunctionPrototypeHandle(aCx));
  if (!constructorProto) {
    return;
  }

  dom::CreateInterfaceObjects(aCx, aGlobal, parentProto,
                              &sPrototypeClass, protoCache,
                              constructorProto, &sInterfaceObjectInfo, 1, false, Span<const LegacyFactoryFunction, 0>{},
                              interfaceCache,
                              sNativeProperties.Upcast(),
                              nullptr,
                              "InspectorCSSParser",
                              ShouldExpose<InspectorCSSParser_Binding::ConstructorEnabled>(aCx, aGlobal, aDefineOnGlobal),
                              nullptr,
                              false,
                              nullptr);
}

static JS::Handle<JSObject*>
GetProtoObjectHandle(JSContext* aCx)
{
  /* Get the interface prototype object for this class.  This will create the
     object as needed. */
  return GetPerInterfaceObjectHandle(aCx, prototypes::id::InspectorCSSParser,
                                     &CreateInterfaceObjects,
                                     DefineInterfaceProperty::CheckExposure);

}

JS::Handle<JSObject*>
GetConstructorObjectHandle(JSContext* aCx)
{
  /* Get the interface object for this class.  This will create the object as
     needed. */

  return GetPerInterfaceObjectHandle(aCx, constructors::id::InspectorCSSParser,
                                     &CreateInterfaceObjects,
                                     DefineInterfaceProperty::CheckExposure);
}

} // namespace InspectorCSSParser_Binding



namespace InspectorFontFace_Binding {

MOZ_CAN_RUN_SCRIPT static bool
get_fromFontGroup(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "InspectorFontFace", "fromFontGroup", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::InspectorFontFace*>(void_self);
  bool result(MOZ_KnownLive(self)->FromFontGroup());
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setBoolean(result);
  return true;
}

static const JSJitInfo fromFontGroup_getterinfo = {
  { get_fromFontGroup },
  { prototypes::id::InspectorFontFace },
  { PrototypeTraits<prototypes::id::InspectorFontFace>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_BOOLEAN,  /* returnType.  Not relevant for setters. */
  true,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_fromLanguagePrefs(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "InspectorFontFace", "fromLanguagePrefs", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::InspectorFontFace*>(void_self);
  bool result(MOZ_KnownLive(self)->FromLanguagePrefs());
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setBoolean(result);
  return true;
}

static const JSJitInfo fromLanguagePrefs_getterinfo = {
  { get_fromLanguagePrefs },
  { prototypes::id::InspectorFontFace },
  { PrototypeTraits<prototypes::id::InspectorFontFace>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_BOOLEAN,  /* returnType.  Not relevant for setters. */
  true,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_fromSystemFallback(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "InspectorFontFace", "fromSystemFallback", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::InspectorFontFace*>(void_self);
  bool result(MOZ_KnownLive(self)->FromSystemFallback());
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setBoolean(result);
  return true;
}

static const JSJitInfo fromSystemFallback_getterinfo = {
  { get_fromSystemFallback },
  { prototypes::id::InspectorFontFace },
  { PrototypeTraits<prototypes::id::InspectorFontFace>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_BOOLEAN,  /* returnType.  Not relevant for setters. */
  true,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_name(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "InspectorFontFace", "name", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::InspectorFontFace*>(void_self);
  DOMString result;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->GetName(result))>, "Should be returning void here");
  MOZ_KnownLive(self)->GetName(result);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!xpc::NonVoidStringToJsval(cx, result, args.rval())) {
    return false;
  }
  return true;
}

static const JSJitInfo name_getterinfo = {
  { get_name },
  { prototypes::id::InspectorFontFace },
  { PrototypeTraits<prototypes::id::InspectorFontFace>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_CSSFamilyName(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "InspectorFontFace", "CSSFamilyName", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::InspectorFontFace*>(void_self);
  DOMString result;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->GetCSSFamilyName(result))>, "Should be returning void here");
  MOZ_KnownLive(self)->GetCSSFamilyName(result);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!xpc::NonVoidStringToJsval(cx, result, args.rval())) {
    return false;
  }
  return true;
}

static const JSJitInfo CSSFamilyName_getterinfo = {
  { get_CSSFamilyName },
  { prototypes::id::InspectorFontFace },
  { PrototypeTraits<prototypes::id::InspectorFontFace>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_CSSGeneric(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "InspectorFontFace", "CSSGeneric", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::InspectorFontFace*>(void_self);
  DOMString result;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->GetCSSGeneric(result))>, "Should be returning void here");
  MOZ_KnownLive(self)->GetCSSGeneric(result);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!xpc::NonVoidStringToJsval(cx, result, args.rval())) {
    return false;
  }
  return true;
}

static const JSJitInfo CSSGeneric_getterinfo = {
  { get_CSSGeneric },
  { prototypes::id::InspectorFontFace },
  { PrototypeTraits<prototypes::id::InspectorFontFace>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
getNameString(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "InspectorFontFace", "getNameString", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::InspectorFontFace*>(void_self);
  if (!args.requireAtLeast(cx, "InspectorFontFace.getNameString", 1)) {
    return false;
  }
  uint16_t arg0;
  if (!ValueToPrimitive<uint16_t, eDefault>(cx, args[0], "Argument 1", &arg0)) {
    return false;
  }
  DOMString result;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->GetNameString(arg0, result))>, "Should be returning void here");
  MOZ_KnownLive(self)->GetNameString(arg0, result);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!xpc::NonVoidStringToJsval(cx, result, args.rval())) {
    return false;
  }
  return true;
}

static const JSJitInfo getNameString_methodinfo = {
  { (JSJitGetterOp)getNameString },
  { prototypes::id::InspectorFontFace },
  { PrototypeTraits<prototypes::id::InspectorFontFace>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
getVariationAxes(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "InspectorFontFace", "getVariationAxes", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::InspectorFontFace*>(void_self);
  FastErrorResult rv;
  nsTArray<InspectorVariationAxis> result;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->GetVariationAxes(result, rv))>, "Should be returning void here");
  MOZ_KnownLive(self)->GetVariationAxes(result, rv);
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "InspectorFontFace.getVariationAxes"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));

  uint32_t length = result.Length();
  JS::Rooted<JSObject*> returnArray(cx, JS::NewArrayObject(cx, length));
  if (!returnArray) {
    return false;
  }
  // Scope for 'tmp'
  {
    JS::Rooted<JS::Value> tmp(cx);
    for (uint32_t sequenceIdx0 = 0; sequenceIdx0 < length; ++sequenceIdx0) {
      // Control block to let us common up the JS_DefineElement calls when there
      // are different ways to succeed at wrapping the object.
      do {
        if (!result[sequenceIdx0].ToObjectInternal(cx, &tmp)) {
          return false;
        }
        break;
      } while (false);
      if (!JS_DefineElement(cx, returnArray, sequenceIdx0, tmp,
                            JSPROP_ENUMERATE)) {
        return false;
      }
    }
  }
  args.rval().setObject(*returnArray);
  return true;
}

static const JSJitInfo getVariationAxes_methodinfo = {
  { (JSJitGetterOp)getVariationAxes },
  { prototypes::id::InspectorFontFace },
  { PrototypeTraits<prototypes::id::InspectorFontFace>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_OBJECT,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
getVariationInstances(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "InspectorFontFace", "getVariationInstances", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::InspectorFontFace*>(void_self);
  FastErrorResult rv;
  nsTArray<InspectorVariationInstance> result;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->GetVariationInstances(result, rv))>, "Should be returning void here");
  MOZ_KnownLive(self)->GetVariationInstances(result, rv);
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "InspectorFontFace.getVariationInstances"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));

  uint32_t length = result.Length();
  JS::Rooted<JSObject*> returnArray(cx, JS::NewArrayObject(cx, length));
  if (!returnArray) {
    return false;
  }
  // Scope for 'tmp'
  {
    JS::Rooted<JS::Value> tmp(cx);
    for (uint32_t sequenceIdx0 = 0; sequenceIdx0 < length; ++sequenceIdx0) {
      // Control block to let us common up the JS_DefineElement calls when there
      // are different ways to succeed at wrapping the object.
      do {
        if (!result[sequenceIdx0].ToObjectInternal(cx, &tmp)) {
          return false;
        }
        break;
      } while (false);
      if (!JS_DefineElement(cx, returnArray, sequenceIdx0, tmp,
                            JSPROP_ENUMERATE)) {
        return false;
      }
    }
  }
  args.rval().setObject(*returnArray);
  return true;
}

static const JSJitInfo getVariationInstances_methodinfo = {
  { (JSJitGetterOp)getVariationInstances },
  { prototypes::id::InspectorFontFace },
  { PrototypeTraits<prototypes::id::InspectorFontFace>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_OBJECT,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
getFeatures(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "InspectorFontFace", "getFeatures", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::InspectorFontFace*>(void_self);
  FastErrorResult rv;
  nsTArray<InspectorFontFeature> result;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->GetFeatures(result, rv))>, "Should be returning void here");
  MOZ_KnownLive(self)->GetFeatures(result, rv);
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "InspectorFontFace.getFeatures"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));

  uint32_t length = result.Length();
  JS::Rooted<JSObject*> returnArray(cx, JS::NewArrayObject(cx, length));
  if (!returnArray) {
    return false;
  }
  // Scope for 'tmp'
  {
    JS::Rooted<JS::Value> tmp(cx);
    for (uint32_t sequenceIdx0 = 0; sequenceIdx0 < length; ++sequenceIdx0) {
      // Control block to let us common up the JS_DefineElement calls when there
      // are different ways to succeed at wrapping the object.
      do {
        if (!result[sequenceIdx0].ToObjectInternal(cx, &tmp)) {
          return false;
        }
        break;
      } while (false);
      if (!JS_DefineElement(cx, returnArray, sequenceIdx0, tmp,
                            JSPROP_ENUMERATE)) {
        return false;
      }
    }
  }
  args.rval().setObject(*returnArray);
  return true;
}

static const JSJitInfo getFeatures_methodinfo = {
  { (JSJitGetterOp)getFeatures },
  { prototypes::id::InspectorFontFace },
  { PrototypeTraits<prototypes::id::InspectorFontFace>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_OBJECT,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_ranges(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "InspectorFontFace", "ranges", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::InspectorFontFace*>(void_self);
  // Have to either root across the getter call or reget after.
  bool isXray;
  JS::Rooted<JSObject*> slotStorage(cx, GetCachedSlotStorageObject(cx, obj, &isXray));
  if (!slotStorage) {
    return false;
  }
  const size_t slotIndex = isXray ? (DOM_EXPANDO_RESERVED_SLOTS + 0) : (DOM_INSTANCE_RESERVED_SLOTS + 0);
  MOZ_ASSERT(slotIndex < JSCLASS_RESERVED_SLOTS(JS::GetClass(slotStorage)));
  {
    // Scope for cachedVal
    JS::Value cachedVal = JS::GetReservedSlot(slotStorage, slotIndex);
    if (!cachedVal.isUndefined()) {
      args.rval().set(cachedVal);
      // The cached value is in the compartment of slotStorage,
      // so wrap into the caller compartment as needed.
      return MaybeWrapNonDOMObjectValue(cx, args.rval());
    }
  }

  nsTArray<StrongPtrForMember<nsRange>> result;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->GetRanges(result))>, "Should be returning void here");
  MOZ_KnownLive(self)->GetRanges(result);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  {
    JS::Rooted<JSObject*> conversionScope(cx, isXray ? JS::CurrentGlobalOrNull(cx) : slotStorage);
    JSAutoRealm ar(cx, conversionScope);
    do { // block we break out of when done wrapping

      uint32_t length = result.Length();
      JS::Rooted<JSObject*> returnArray(cx, JS::NewArrayObject(cx, length));
      if (!returnArray) {
        return false;
      }
      // Scope for 'tmp'
      {
        JS::Rooted<JS::Value> tmp(cx);
        for (uint32_t sequenceIdx0 = 0; sequenceIdx0 < length; ++sequenceIdx0) {
          // Control block to let us common up the JS_DefineElement calls when there
          // are different ways to succeed at wrapping the object.
          do {
            if (!GetOrCreateDOMReflector(cx, result[sequenceIdx0], &tmp)) {
              MOZ_ASSERT(JS_IsExceptionPending(cx));
              return false;
            }
            break;
          } while (false);
          if (!JS_DefineElement(cx, returnArray, sequenceIdx0, tmp,
                                JSPROP_ENUMERATE)) {
            return false;
          }
        }
      }
      args.rval().setObject(*returnArray);
      break;
    } while (false);
  }
  { // And now store things in the realm of our slotStorage.
    JSAutoRealm ar(cx, slotStorage);
    // Make a copy so that we don't do unnecessary wrapping on args.rval().
    JS::Rooted<JS::Value> storedVal(cx, args.rval());
    if (!MaybeWrapNonDOMObjectValue(cx, &storedVal)) {
      return false;
    }
    JS::SetReservedSlot(slotStorage, slotIndex, storedVal);
  }
  // And now make sure args.rval() is in the caller realm.
  return MaybeWrapNonDOMObjectValue(cx, args.rval());
}

static const JSJitInfo ranges_getterinfo = {
  { get_ranges },
  { prototypes::id::InspectorFontFace },
  { PrototypeTraits<prototypes::id::InspectorFontFace>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasNone, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_OBJECT,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  true,  /* isMovable.  Not relevant for setters. */
  true, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  true, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  (DOM_INSTANCE_RESERVED_SLOTS + 0)   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static_assert((DOM_INSTANCE_RESERVED_SLOTS + 0) <= JSJitInfo::maxSlotIndex, "We won't fit");
static_assert((DOM_INSTANCE_RESERVED_SLOTS + 0) < 2, "There is no slot for us");

MOZ_CAN_RUN_SCRIPT static bool
get_rule(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "InspectorFontFace", "rule", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::InspectorFontFace*>(void_self);
  auto result(StrongOrRawPtr<mozilla::dom::CSSFontFaceRule>(MOZ_KnownLive(self)->GetRule()));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!result) {
    args.rval().setNull();
    return true;
  }
  if (!GetOrCreateDOMReflector(cx, result, args.rval())) {
    MOZ_ASSERT(JS_IsExceptionPending(cx));
    return false;
  }
  return true;
}

static const JSJitInfo rule_getterinfo = {
  { get_rule },
  { prototypes::id::InspectorFontFace },
  { PrototypeTraits<prototypes::id::InspectorFontFace>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_srcIndex(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "InspectorFontFace", "srcIndex", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::InspectorFontFace*>(void_self);
  int32_t result(MOZ_KnownLive(self)->SrcIndex());
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setInt32(int32_t(result));
  return true;
}

static const JSJitInfo srcIndex_getterinfo = {
  { get_srcIndex },
  { prototypes::id::InspectorFontFace },
  { PrototypeTraits<prototypes::id::InspectorFontFace>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_INT32,  /* returnType.  Not relevant for setters. */
  true,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_URI(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "InspectorFontFace", "URI", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::InspectorFontFace*>(void_self);
  DOMString result;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->GetURI(result))>, "Should be returning void here");
  MOZ_KnownLive(self)->GetURI(result);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!xpc::NonVoidStringToJsval(cx, result, args.rval())) {
    return false;
  }
  return true;
}

static const JSJitInfo URI_getterinfo = {
  { get_URI },
  { prototypes::id::InspectorFontFace },
  { PrototypeTraits<prototypes::id::InspectorFontFace>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_localName(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "InspectorFontFace", "localName", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::InspectorFontFace*>(void_self);
  DOMString result;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->GetLocalName(result))>, "Should be returning void here");
  MOZ_KnownLive(self)->GetLocalName(result);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!xpc::NonVoidStringToJsval(cx, result, args.rval())) {
    return false;
  }
  return true;
}

static const JSJitInfo localName_getterinfo = {
  { get_localName },
  { prototypes::id::InspectorFontFace },
  { PrototypeTraits<prototypes::id::InspectorFontFace>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_format(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "InspectorFontFace", "format", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::InspectorFontFace*>(void_self);
  DOMString result;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->GetFormat(result))>, "Should be returning void here");
  MOZ_KnownLive(self)->GetFormat(result);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!xpc::NonVoidStringToJsval(cx, result, args.rval())) {
    return false;
  }
  return true;
}

static const JSJitInfo format_getterinfo = {
  { get_format },
  { prototypes::id::InspectorFontFace },
  { PrototypeTraits<prototypes::id::InspectorFontFace>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_metadata(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "InspectorFontFace", "metadata", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::InspectorFontFace*>(void_self);
  DOMString result;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->GetMetadata(result))>, "Should be returning void here");
  MOZ_KnownLive(self)->GetMetadata(result);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!xpc::NonVoidStringToJsval(cx, result, args.rval())) {
    return false;
  }
  return true;
}

static const JSJitInfo metadata_getterinfo = {
  { get_metadata },
  { prototypes::id::InspectorFontFace },
  { PrototypeTraits<prototypes::id::InspectorFontFace>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

static void
_finalize(JS::GCContext* gcx, JSObject* obj)
{
  mozilla::dom::InspectorFontFace* self = UnwrapPossiblyNotInitializedDOMObject<mozilla::dom::InspectorFontFace>(obj);
  if (self) {
    JS::SetReservedSlot(obj, DOM_OBJECT_SLOT, JS::UndefinedValue());
    if (size_t mallocBytes = BindingJSObjectMallocBytes(self)) {
      JS::RemoveAssociatedMemory(obj, mallocBytes,
                                 JS::MemoryUse::DOMBinding);
    }
    AddForDeferredFinalization<mozilla::dom::InspectorFontFace>(self);
  }
}

MOZ_GLOBINIT static const JSFunctionSpec sMethods_specs[] = {
  JS_FNSPEC("getNameString", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&getNameString_methodinfo), 1, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("getVariationAxes", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&getVariationAxes_methodinfo), 0, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("getVariationInstances", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&getVariationInstances_methodinfo), 0, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("getFeatures", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&getFeatures_methodinfo), 0, JSPROP_ENUMERATE, nullptr),
  JS_FS_END
};


static const Prefable<const JSFunctionSpec> sMethods[] = {
  { nullptr, &sMethods_specs[0] },
  { nullptr, nullptr }
};

static_assert(1 <= 1ull << NUM_BITS_PROPERTY_INFO_PREF_INDEX,
    "We have a prefable index that is >= (1 << NUM_BITS_PROPERTY_INFO_PREF_INDEX)");
static_assert(4 <= 1ull << NUM_BITS_PROPERTY_INFO_SPEC_INDEX,
    "We have a spec index that is >= (1 << NUM_BITS_PROPERTY_INFO_SPEC_INDEX)");

MOZ_GLOBINIT static const JSPropertySpec sAttributes_specs[] = {
  JSPropertySpec::nativeAccessors("fromFontGroup", JSPROP_ENUMERATE, GenericGetter<NormalThisPolicy, ThrowExceptions>, &fromFontGroup_getterinfo, nullptr, nullptr),
  JSPropertySpec::nativeAccessors("fromLanguagePrefs", JSPROP_ENUMERATE, GenericGetter<NormalThisPolicy, ThrowExceptions>, &fromLanguagePrefs_getterinfo, nullptr, nullptr),
  JSPropertySpec::nativeAccessors("fromSystemFallback", JSPROP_ENUMERATE, GenericGetter<NormalThisPolicy, ThrowExceptions>, &fromSystemFallback_getterinfo, nullptr, nullptr),
  JSPropertySpec::nativeAccessors("name", JSPROP_ENUMERATE, GenericGetter<NormalThisPolicy, ThrowExceptions>, &name_getterinfo, nullptr, nullptr),
  JSPropertySpec::nativeAccessors("CSSFamilyName", JSPROP_ENUMERATE, GenericGetter<NormalThisPolicy, ThrowExceptions>, &CSSFamilyName_getterinfo, nullptr, nullptr),
  JSPropertySpec::nativeAccessors("CSSGeneric", JSPROP_ENUMERATE, GenericGetter<NormalThisPolicy, ThrowExceptions>, &CSSGeneric_getterinfo, nullptr, nullptr),
  JSPropertySpec::nativeAccessors("ranges", JSPROP_ENUMERATE, GenericGetter<NormalThisPolicy, ThrowExceptions>, &ranges_getterinfo, nullptr, nullptr),
  JSPropertySpec::nativeAccessors("rule", JSPROP_ENUMERATE, GenericGetter<NormalThisPolicy, ThrowExceptions>, &rule_getterinfo, nullptr, nullptr),
  JSPropertySpec::nativeAccessors("srcIndex", JSPROP_ENUMERATE, GenericGetter<NormalThisPolicy, ThrowExceptions>, &srcIndex_getterinfo, nullptr, nullptr),
  JSPropertySpec::nativeAccessors("URI", JSPROP_ENUMERATE, GenericGetter<NormalThisPolicy, ThrowExceptions>, &URI_getterinfo, nullptr, nullptr),
  JSPropertySpec::nativeAccessors("localName", JSPROP_ENUMERATE, GenericGetter<NormalThisPolicy, ThrowExceptions>, &localName_getterinfo, nullptr, nullptr),
  JSPropertySpec::nativeAccessors("format", JSPROP_ENUMERATE, GenericGetter<NormalThisPolicy, ThrowExceptions>, &format_getterinfo, nullptr, nullptr),
  JSPropertySpec::nativeAccessors("metadata", JSPROP_ENUMERATE, GenericGetter<NormalThisPolicy, ThrowExceptions>, &metadata_getterinfo, nullptr, nullptr),
  JS_PS_END
};


static const Prefable<const JSPropertySpec> sAttributes[] = {
  { nullptr, &sAttributes_specs[0] },
  { nullptr, nullptr }
};

static_assert(1 <= 1ull << NUM_BITS_PROPERTY_INFO_PREF_INDEX,
    "We have a prefable index that is >= (1 << NUM_BITS_PROPERTY_INFO_PREF_INDEX)");
static_assert(13 <= 1ull << NUM_BITS_PROPERTY_INFO_SPEC_INDEX,
    "We have a spec index that is >= (1 << NUM_BITS_PROPERTY_INFO_SPEC_INDEX)");

MOZ_GLOBINIT static const ConstantSpec sConstants_specs[] = {
  { "NAME_ID_COPYRIGHT", JS::Int32Value(0) },
  { "NAME_ID_FAMILY", JS::Int32Value(1) },
  { "NAME_ID_SUBFAMILY", JS::Int32Value(2) },
  { "NAME_ID_UNIQUE", JS::Int32Value(3) },
  { "NAME_ID_FULL", JS::Int32Value(4) },
  { "NAME_ID_VERSION", JS::Int32Value(5) },
  { "NAME_ID_POSTSCRIPT", JS::Int32Value(6) },
  { "NAME_ID_TRADEMARK", JS::Int32Value(7) },
  { "NAME_ID_MANUFACTURER", JS::Int32Value(8) },
  { "NAME_ID_DESIGNER", JS::Int32Value(9) },
  { "NAME_ID_DESCRIPTION", JS::Int32Value(10) },
  { "NAME_ID_VENDOR_URL", JS::Int32Value(11) },
  { "NAME_ID_DESIGNER_URL", JS::Int32Value(12) },
  { "NAME_ID_LICENSE", JS::Int32Value(13) },
  { "NAME_ID_LICENSE_URL", JS::Int32Value(14) },
  { "NAME_ID_TYPOGRAPHIC_FAMILY", JS::Int32Value(16) },
  { "NAME_ID_TYPOGRAPHIC_SUBFAMILY", JS::Int32Value(17) },
  { "NAME_ID_COMPATIBLE_FULL", JS::Int32Value(18) },
  { "NAME_ID_SAMPLE_TEXT", JS::Int32Value(19) },
  { 0, JS::UndefinedValue() }
};


static const Prefable<const ConstantSpec> sConstants[] = {
  { nullptr, &sConstants_specs[0] },
  { nullptr, nullptr }
};

static_assert(1 <= 1ull << NUM_BITS_PROPERTY_INFO_PREF_INDEX,
    "We have a prefable index that is >= (1 << NUM_BITS_PROPERTY_INFO_PREF_INDEX)");
static_assert(19 <= 1ull << NUM_BITS_PROPERTY_INFO_SPEC_INDEX,
    "We have a spec index that is >= (1 << NUM_BITS_PROPERTY_INFO_SPEC_INDEX)");


static uint16_t sNativeProperties_sortedPropertyIndices[36];
static PropertyInfo sNativeProperties_propertyInfos[36];

static const NativePropertiesN<3> sNativeProperties = {
  false, 0,
  false, 0,
  true,  0 /* sMethods */,
  true,  1 /* sAttributes */,
  false, 0,
  false, 0,
  true,  2 /* sConstants */,
  -1,
  36,
  sNativeProperties_sortedPropertyIndices,
  {
    { sMethods, &sNativeProperties_propertyInfos[0] },
    { sAttributes, &sNativeProperties_propertyInfos[4] },
    { sConstants, &sNativeProperties_propertyInfos[17] }
  }
};
static_assert(36 < 1ull << (CHAR_BIT * sizeof(sNativeProperties.propertyInfoCount)),
    "We have a property info count that is oversized");

// This may allocate too many slots, because we only really need
// slots for our non-interface-typed members that we cache.  But
// allocating slots only for those would make the slot index
// computations much more complicated, so let's do this the simple
// way for now.
DEFINE_XRAY_EXPANDO_CLASS_WITH_OPS(static, sXrayExpandoObjectClass, 1,
                                   &xpc::XrayExpandoObjectClassOps);

bool sNativePropertiesInited = false;
const NativePropertyHooks sNativePropertyHooks = {
  nullptr,
  { sNativeProperties.Upcast(), nullptr, &sNativePropertiesInited },
  prototypes::id::InspectorFontFace,
  constructors::id::InspectorFontFace,
  &sXrayExpandoObjectClass
};

static const DOMInterfaceInfo sInterfaceObjectInfo = {
  { ThrowingConstructor, &sNativePropertyHooks },
  JS::GetRealmFunctionPrototypeHandle,
  PrototypeTraits<prototypes::id::InspectorFontFace>::Depth,
  prototypes::id::InspectorFontFace,
  true,
  0,
  "InspectorFontFace",
};

static const DOMIfaceAndProtoJSClass sPrototypeClass = {
  {
    "InspectorFontFacePrototype",
    JSCLASS_IS_DOMIFACEANDPROTOJSCLASS | JSCLASS_HAS_RESERVED_SLOTS(DOM_INTERFACE_PROTO_SLOTS_BASE),
    JS_NULL_CLASS_OPS,
    JS_NULL_CLASS_SPEC,
    JS_NULL_CLASS_EXT,
    JS_NULL_OBJECT_OPS
  },
  eInterfacePrototype,
  prototypes::id::InspectorFontFace,
  PrototypeTraits<prototypes::id::InspectorFontFace>::Depth,
  &sNativePropertyHooks,
  JS::GetRealmObjectPrototype
};

bool
ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj)
{
  return nsContentUtils::IsCallerChromeOrFuzzingEnabled(aCx, aObj);
}

static JS::Handle<JSObject*>
GetProtoObjectHandle(JSContext* aCx);

static const JSClassOps sClassOps = {
  nullptr,               /* addProperty */
  nullptr,               /* delProperty */
  nullptr,               /* enumerate */
  nullptr, /* newEnumerate */
  nullptr, /* resolve */
  nullptr, /* mayResolve */
  _finalize, /* finalize */
  nullptr, /* call */
  nullptr,               /* construct */
  nullptr, /* trace */
};

static const DOMJSClass sClass = {
  { "InspectorFontFace",
    JSCLASS_IS_DOMJSCLASS | JSCLASS_FOREGROUND_FINALIZE | JSCLASS_HAS_RESERVED_SLOTS(2),
    &sClassOps,
    JS_NULL_CLASS_SPEC,
    JS_NULL_CLASS_EXT,
    JS_NULL_OBJECT_OPS
  },
  { prototypes::id::InspectorFontFace, prototypes::id::_ID_Count, prototypes::id::_ID_Count, prototypes::id::_ID_Count, prototypes::id::_ID_Count, prototypes::id::_ID_Count, prototypes::id::_ID_Count, prototypes::id::_ID_Count },
  std::is_base_of_v<nsISupports, mozilla::dom::InspectorFontFace>,
  &sNativePropertyHooks,
  FindAssociatedGlobalForNative<mozilla::dom::InspectorFontFace>::Get,
  GetProtoObjectHandle,
  GetCCParticipant<mozilla::dom::InspectorFontFace>::Get(),
  nullptr,
  nullptr
};
static_assert(1 == DOM_INSTANCE_RESERVED_SLOTS,
              "Must have the right minimal number of reserved slots.");
static_assert(2 >= 2,
              "Must have enough reserved slots.");

bool
Wrap(JSContext* aCx, mozilla::dom::InspectorFontFace* aObject, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector)
{
  static_assert(std::is_same_v<decltype(aObject), mozilla::dom::InspectorFontFace*>);
  MOZ_ASSERT(ToSupportsIsCorrect(aObject));
  MOZ_ASSERT_IF(aGivenProto, js::IsObjectInContextCompartment(aGivenProto, aCx));

  JS::Rooted<JSObject*> global(aCx, JS::CurrentGlobalOrNull(aCx));
  JS::Handle<JSObject*> canonicalProto = GetProtoObjectHandle(aCx);
  if (!canonicalProto) {
    return false;
  }
  JS::Rooted<JSObject*> proto(aCx);
  if (aGivenProto) {
    proto = aGivenProto;
    // Unfortunately, while aGivenProto was in the compartment of aCx
    // coming in, we changed compartments to that of "parent" so may need
    // to wrap the proto here.
    if (js::GetContextCompartment(aCx) != JS::GetCompartment(proto)) {
      if (!JS_WrapObject(aCx, &proto)) {
        return false;
      }
    }
  } else {
    proto = canonicalProto;
  }

  BindingJSObjectCreator<mozilla::dom::InspectorFontFace> creator(aCx);
  creator.CreateObject(aCx, sClass.ToJSClass(), proto, aObject, aReflector);
  if (!aReflector) {
    return false;
  }



  creator.InitializationSucceeded();
  return true;
}

void
CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, DefineInterfaceProperty aDefineOnGlobal)
{
  JS::Heap<JSObject*>* protoCache = &aProtoAndIfaceCache.EntrySlotOrCreate(prototypes::id::InspectorFontFace);
  JS::Heap<JSObject*>* interfaceCache = &aProtoAndIfaceCache.EntrySlotOrCreate(constructors::id::InspectorFontFace);

  JS::Handle<JSObject*> parentProto(JS::GetRealmObjectPrototypeHandle(aCx));
  if (!parentProto) {
    return;
  }

  JS::Handle<JSObject*> constructorProto(JS::GetRealmFunctionPrototypeHandle(aCx));
  if (!constructorProto) {
    return;
  }

  dom::CreateInterfaceObjects(aCx, aGlobal, parentProto,
                              &sPrototypeClass, protoCache,
                              constructorProto, &sInterfaceObjectInfo, 0, false, Span<const LegacyFactoryFunction, 0>{},
                              interfaceCache,
                              sNativeProperties.Upcast(),
                              nullptr,
                              "InspectorFontFace",
                              ShouldExpose<InspectorFontFace_Binding::ConstructorEnabled>(aCx, aGlobal, aDefineOnGlobal),
                              nullptr,
                              false,
                              nullptr);
}

static JS::Handle<JSObject*>
GetProtoObjectHandle(JSContext* aCx)
{
  /* Get the interface prototype object for this class.  This will create the
     object as needed. */
  return GetPerInterfaceObjectHandle(aCx, prototypes::id::InspectorFontFace,
                                     &CreateInterfaceObjects,
                                     DefineInterfaceProperty::CheckExposure);

}

JS::Handle<JSObject*>
GetConstructorObjectHandle(JSContext* aCx)
{
  /* Get the interface object for this class.  This will create the object as
     needed. */

  return GetPerInterfaceObjectHandle(aCx, constructors::id::InspectorFontFace,
                                     &CreateInterfaceObjects,
                                     DefineInterfaceProperty::CheckExposure);
}

} // namespace InspectorFontFace_Binding



namespace InspectorUtils_Binding {

MOZ_CAN_RUN_SCRIPT static bool
getAllStyleSheets(JSContext* cx_, unsigned argc, JS::Value* vp)
{
  BindingCallContext cx(cx_, "InspectorUtils.getAllStyleSheets");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "InspectorUtils", "getAllStyleSheets", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  JS::CallArgs args = JS::CallArgsFromVp(argc, vp);
  JS::Rooted<JSObject*> obj(cx, &args.callee());

  if (!args.requireAtLeast(cx, "InspectorUtils.getAllStyleSheets", 1)) {
    return false;
  }
  GlobalObject global(cx, xpc::XrayAwareCalleeGlobal(obj));
  if (global.Failed()) {
    return false;
  }

  NonNull<mozilla::dom::Document> arg0;
  if (args[0].isObject()) {
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::Document, mozilla::dom::Document>(args[0], arg0, cx);
      if (NS_FAILED(rv)) {
        cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Argument 1", "Document");
        return false;
      }
    }
  } else {
    cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 1");
    return false;
  }
  bool arg1;
  if (args.hasDefined(1)) {
    if (!ValueToPrimitive<bool, eDefault>(cx, args[1], "Argument 2", &arg1)) {
      return false;
    }
  } else {
    arg1 = false;
  }
  nsTArray<StrongPtrForMember<mozilla::StyleSheet>> result;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(mozilla::dom::InspectorUtils::GetAllStyleSheets(global, MOZ_KnownLive(NonNullHelper(arg0)), arg1, result))>, "Should be returning void here");
  mozilla::dom::InspectorUtils::GetAllStyleSheets(global, MOZ_KnownLive(NonNullHelper(arg0)), arg1, result);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));

  uint32_t length = result.Length();
  JS::Rooted<JSObject*> returnArray(cx, JS::NewArrayObject(cx, length));
  if (!returnArray) {
    return false;
  }
  // Scope for 'tmp'
  {
    JS::Rooted<JS::Value> tmp(cx);
    for (uint32_t sequenceIdx0 = 0; sequenceIdx0 < length; ++sequenceIdx0) {
      // Control block to let us common up the JS_DefineElement calls when there
      // are different ways to succeed at wrapping the object.
      do {
        if (!GetOrCreateDOMReflector(cx, result[sequenceIdx0], &tmp)) {
          MOZ_ASSERT(JS_IsExceptionPending(cx));
          return false;
        }
        break;
      } while (false);
      if (!JS_DefineElement(cx, returnArray, sequenceIdx0, tmp,
                            JSPROP_ENUMERATE)) {
        return false;
      }
    }
  }
  args.rval().setObject(*returnArray);
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
getMatchingCSSRules(JSContext* cx_, unsigned argc, JS::Value* vp)
{
  BindingCallContext cx(cx_, "InspectorUtils.getMatchingCSSRules");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "InspectorUtils", "getMatchingCSSRules", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  JS::CallArgs args = JS::CallArgsFromVp(argc, vp);
  JS::Rooted<JSObject*> obj(cx, &args.callee());

  if (!args.requireAtLeast(cx, "InspectorUtils.getMatchingCSSRules", 1)) {
    return false;
  }
  GlobalObject global(cx, xpc::XrayAwareCalleeGlobal(obj));
  if (global.Failed()) {
    return false;
  }

  NonNull<mozilla::dom::Element> arg0;
  if (args[0].isObject()) {
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::Element, mozilla::dom::Element>(args[0], arg0, cx);
      if (NS_FAILED(rv)) {
        cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Argument 1", "Element");
        return false;
      }
    }
  } else {
    cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 1");
    return false;
  }
  binding_detail::FakeString<char16_t> arg1;
  if (args.hasDefined(1)) {
    if (!ConvertJSValueToString(cx, args[1], eEmpty, eStringify, arg1)) {
      return false;
    }
  } else {
    arg1.AssignLiteral(u"");
  }
  bool arg2;
  if (args.hasDefined(2)) {
    if (!ValueToPrimitive<bool, eDefault>(cx, args[2], "Argument 3", &arg2)) {
      return false;
    }
  } else {
    arg2 = false;
  }
  bool arg3;
  if (args.hasDefined(3)) {
    if (!ValueToPrimitive<bool, eDefault>(cx, args[3], "Argument 4", &arg3)) {
      return false;
    }
  } else {
    arg3 = false;
  }
  nsTArray<OwningCSSRuleOrInspectorDeclaration> result;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(mozilla::dom::InspectorUtils::GetMatchingCSSRules(global, MOZ_KnownLive(NonNullHelper(arg0)), NonNullHelper(Constify(arg1)), arg2, arg3, result))>, "Should be returning void here");
  mozilla::dom::InspectorUtils::GetMatchingCSSRules(global, MOZ_KnownLive(NonNullHelper(arg0)), NonNullHelper(Constify(arg1)), arg2, arg3, result);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));

  uint32_t length = result.Length();
  JS::Rooted<JSObject*> returnArray(cx, JS::NewArrayObject(cx, length));
  if (!returnArray) {
    return false;
  }
  // Scope for 'tmp'
  {
    JS::Rooted<JS::Value> tmp(cx);
    for (uint32_t sequenceIdx0 = 0; sequenceIdx0 < length; ++sequenceIdx0) {
      // Control block to let us common up the JS_DefineElement calls when there
      // are different ways to succeed at wrapping the object.
      do {
        if (!result[sequenceIdx0].ToJSVal(cx, returnArray, &tmp)) {
          return false;
        }
        break;
      } while (false);
      if (!JS_DefineElement(cx, returnArray, sequenceIdx0, tmp,
                            JSPROP_ENUMERATE)) {
        return false;
      }
    }
  }
  args.rval().setObject(*returnArray);
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
getRuleLine(JSContext* cx_, unsigned argc, JS::Value* vp)
{
  BindingCallContext cx(cx_, "InspectorUtils.getRuleLine");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "InspectorUtils", "getRuleLine", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  JS::CallArgs args = JS::CallArgsFromVp(argc, vp);
  JS::Rooted<JSObject*> obj(cx, &args.callee());

  if (!args.requireAtLeast(cx, "InspectorUtils.getRuleLine", 1)) {
    return false;
  }
  GlobalObject global(cx, xpc::XrayAwareCalleeGlobal(obj));
  if (global.Failed()) {
    return false;
  }

  NonNull<mozilla::css::Rule> arg0;
  if (args[0].isObject()) {
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::CSSRule, mozilla::css::Rule>(args[0], arg0, cx);
      if (NS_FAILED(rv)) {
        cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Argument 1", "CSSRule");
        return false;
      }
    }
  } else {
    cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 1");
    return false;
  }
  uint32_t result(mozilla::dom::InspectorUtils::GetRuleLine(global, MOZ_KnownLive(NonNullHelper(arg0))));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setNumber(result);
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
getRuleColumn(JSContext* cx_, unsigned argc, JS::Value* vp)
{
  BindingCallContext cx(cx_, "InspectorUtils.getRuleColumn");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "InspectorUtils", "getRuleColumn", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  JS::CallArgs args = JS::CallArgsFromVp(argc, vp);
  JS::Rooted<JSObject*> obj(cx, &args.callee());

  if (!args.requireAtLeast(cx, "InspectorUtils.getRuleColumn", 1)) {
    return false;
  }
  GlobalObject global(cx, xpc::XrayAwareCalleeGlobal(obj));
  if (global.Failed()) {
    return false;
  }

  NonNull<mozilla::css::Rule> arg0;
  if (args[0].isObject()) {
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::CSSRule, mozilla::css::Rule>(args[0], arg0, cx);
      if (NS_FAILED(rv)) {
        cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Argument 1", "CSSRule");
        return false;
      }
    }
  } else {
    cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 1");
    return false;
  }
  uint32_t result(mozilla::dom::InspectorUtils::GetRuleColumn(global, MOZ_KnownLive(NonNullHelper(arg0))));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setNumber(result);
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
getRelativeRuleLine(JSContext* cx_, unsigned argc, JS::Value* vp)
{
  BindingCallContext cx(cx_, "InspectorUtils.getRelativeRuleLine");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "InspectorUtils", "getRelativeRuleLine", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  JS::CallArgs args = JS::CallArgsFromVp(argc, vp);
  JS::Rooted<JSObject*> obj(cx, &args.callee());

  if (!args.requireAtLeast(cx, "InspectorUtils.getRelativeRuleLine", 1)) {
    return false;
  }
  GlobalObject global(cx, xpc::XrayAwareCalleeGlobal(obj));
  if (global.Failed()) {
    return false;
  }

  NonNull<mozilla::css::Rule> arg0;
  if (args[0].isObject()) {
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::CSSRule, mozilla::css::Rule>(args[0], arg0, cx);
      if (NS_FAILED(rv)) {
        cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Argument 1", "CSSRule");
        return false;
      }
    }
  } else {
    cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 1");
    return false;
  }
  uint32_t result(mozilla::dom::InspectorUtils::GetRelativeRuleLine(global, MOZ_KnownLive(NonNullHelper(arg0))));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setNumber(result);
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
getRuleIndex(JSContext* cx_, unsigned argc, JS::Value* vp)
{
  BindingCallContext cx(cx_, "InspectorUtils.getRuleIndex");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "InspectorUtils", "getRuleIndex", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  JS::CallArgs args = JS::CallArgsFromVp(argc, vp);
  JS::Rooted<JSObject*> obj(cx, &args.callee());

  if (!args.requireAtLeast(cx, "InspectorUtils.getRuleIndex", 1)) {
    return false;
  }
  GlobalObject global(cx, xpc::XrayAwareCalleeGlobal(obj));
  if (global.Failed()) {
    return false;
  }

  NonNull<mozilla::css::Rule> arg0;
  if (args[0].isObject()) {
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::CSSRule, mozilla::css::Rule>(args[0], arg0, cx);
      if (NS_FAILED(rv)) {
        cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Argument 1", "CSSRule");
        return false;
      }
    }
  } else {
    cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 1");
    return false;
  }
  nsTArray<uint32_t> result;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(mozilla::dom::InspectorUtils::GetRuleIndex(global, MOZ_KnownLive(NonNullHelper(arg0)), result))>, "Should be returning void here");
  mozilla::dom::InspectorUtils::GetRuleIndex(global, MOZ_KnownLive(NonNullHelper(arg0)), result);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));

  uint32_t length = result.Length();
  JS::Rooted<JSObject*> returnArray(cx, JS::NewArrayObject(cx, length));
  if (!returnArray) {
    return false;
  }
  // Scope for 'tmp'
  {
    JS::Rooted<JS::Value> tmp(cx);
    for (uint32_t sequenceIdx0 = 0; sequenceIdx0 < length; ++sequenceIdx0) {
      // Control block to let us common up the JS_DefineElement calls when there
      // are different ways to succeed at wrapping the object.
      do {
        tmp.setNumber(result[sequenceIdx0]);
        break;
      } while (false);
      if (!JS_DefineElement(cx, returnArray, sequenceIdx0, tmp,
                            JSPROP_ENUMERATE)) {
        return false;
      }
    }
  }
  args.rval().setObject(*returnArray);
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
hasRulesModifiedByCSSOM(JSContext* cx_, unsigned argc, JS::Value* vp)
{
  BindingCallContext cx(cx_, "InspectorUtils.hasRulesModifiedByCSSOM");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "InspectorUtils", "hasRulesModifiedByCSSOM", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  JS::CallArgs args = JS::CallArgsFromVp(argc, vp);
  JS::Rooted<JSObject*> obj(cx, &args.callee());

  if (!args.requireAtLeast(cx, "InspectorUtils.hasRulesModifiedByCSSOM", 1)) {
    return false;
  }
  GlobalObject global(cx, xpc::XrayAwareCalleeGlobal(obj));
  if (global.Failed()) {
    return false;
  }

  NonNull<mozilla::StyleSheet> arg0;
  if (args[0].isObject()) {
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::CSSStyleSheet, mozilla::StyleSheet>(args[0], arg0, cx);
      if (NS_FAILED(rv)) {
        cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Argument 1", "CSSStyleSheet");
        return false;
      }
    }
  } else {
    cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 1");
    return false;
  }
  bool result(mozilla::dom::InspectorUtils::HasRulesModifiedByCSSOM(global, MOZ_KnownLive(NonNullHelper(arg0))));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setBoolean(result);
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
getStyleSheetRuleCountAndAtRules(JSContext* cx_, unsigned argc, JS::Value* vp)
{
  BindingCallContext cx(cx_, "InspectorUtils.getStyleSheetRuleCountAndAtRules");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "InspectorUtils", "getStyleSheetRuleCountAndAtRules", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  JS::CallArgs args = JS::CallArgsFromVp(argc, vp);
  JS::Rooted<JSObject*> obj(cx, &args.callee());

  if (!args.requireAtLeast(cx, "InspectorUtils.getStyleSheetRuleCountAndAtRules", 1)) {
    return false;
  }
  GlobalObject global(cx, xpc::XrayAwareCalleeGlobal(obj));
  if (global.Failed()) {
    return false;
  }

  NonNull<mozilla::StyleSheet> arg0;
  if (args[0].isObject()) {
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::CSSStyleSheet, mozilla::StyleSheet>(args[0], arg0, cx);
      if (NS_FAILED(rv)) {
        cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Argument 1", "CSSStyleSheet");
        return false;
      }
    }
  } else {
    cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 1");
    return false;
  }
  InspectorStyleSheetRuleCountAndAtRulesResult result;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(mozilla::dom::InspectorUtils::GetStyleSheetRuleCountAndAtRules(global, MOZ_KnownLive(NonNullHelper(arg0)), result))>, "Should be returning void here");
  mozilla::dom::InspectorUtils::GetStyleSheetRuleCountAndAtRules(global, MOZ_KnownLive(NonNullHelper(arg0)), result);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!result.ToObjectInternal(cx, args.rval())) {
    return false;
  }
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
isInheritedProperty(JSContext* cx_, unsigned argc, JS::Value* vp)
{
  BindingCallContext cx(cx_, "InspectorUtils.isInheritedProperty");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "InspectorUtils", "isInheritedProperty", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  JS::CallArgs args = JS::CallArgsFromVp(argc, vp);
  JS::Rooted<JSObject*> obj(cx, &args.callee());

  if (!args.requireAtLeast(cx, "InspectorUtils.isInheritedProperty", 2)) {
    return false;
  }
  GlobalObject global(cx, xpc::XrayAwareCalleeGlobal(obj));
  if (global.Failed()) {
    return false;
  }

  NonNull<mozilla::dom::Document> arg0;
  if (args[0].isObject()) {
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::Document, mozilla::dom::Document>(args[0], arg0, cx);
      if (NS_FAILED(rv)) {
        cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Argument 1", "Document");
        return false;
      }
    }
  } else {
    cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 1");
    return false;
  }
  binding_detail::FakeString<char> arg1;
  if (!ConvertJSValueToString(cx, args[1], eStringify, eStringify, arg1)) {
    return false;
  }
  bool result(mozilla::dom::InspectorUtils::IsInheritedProperty(global, MOZ_KnownLive(NonNullHelper(arg0)), Constify(arg1)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setBoolean(result);
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
getCSSPropertyNames(JSContext* cx_, unsigned argc, JS::Value* vp)
{
  BindingCallContext cx(cx_, "InspectorUtils.getCSSPropertyNames");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "InspectorUtils", "getCSSPropertyNames", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  JS::CallArgs args = JS::CallArgsFromVp(argc, vp);
  JS::Rooted<JSObject*> obj(cx, &args.callee());

  GlobalObject global(cx, xpc::XrayAwareCalleeGlobal(obj));
  if (global.Failed()) {
    return false;
  }

  binding_detail::FastPropertyNamesOptions arg0;
  if (!arg0.Init(cx, (args.hasDefined(0)) ? args[0] : JS::NullHandleValue, "Argument 1", false)) {
    return false;
  }
  nsTArray<nsString> result;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(mozilla::dom::InspectorUtils::GetCSSPropertyNames(global, Constify(arg0), result))>, "Should be returning void here");
  mozilla::dom::InspectorUtils::GetCSSPropertyNames(global, Constify(arg0), result);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));

  uint32_t length = result.Length();
  JS::Rooted<JSObject*> returnArray(cx, JS::NewArrayObject(cx, length));
  if (!returnArray) {
    return false;
  }
  // Scope for 'tmp'
  {
    JS::Rooted<JS::Value> tmp(cx);
    for (uint32_t sequenceIdx0 = 0; sequenceIdx0 < length; ++sequenceIdx0) {
      // Control block to let us common up the JS_DefineElement calls when there
      // are different ways to succeed at wrapping the object.
      do {
        if (!xpc::NonVoidStringToJsval(cx, result[sequenceIdx0], &tmp)) {
          return false;
        }
        break;
      } while (false);
      if (!JS_DefineElement(cx, returnArray, sequenceIdx0, tmp,
                            JSPROP_ENUMERATE)) {
        return false;
      }
    }
  }
  args.rval().setObject(*returnArray);
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
getCSSPropertyPrefs(JSContext* cx, unsigned argc, JS::Value* vp)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "InspectorUtils", "getCSSPropertyPrefs", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  JS::CallArgs args = JS::CallArgsFromVp(argc, vp);
  JS::Rooted<JSObject*> obj(cx, &args.callee());

  GlobalObject global(cx, xpc::XrayAwareCalleeGlobal(obj));
  if (global.Failed()) {
    return false;
  }

  nsTArray<PropertyPref> result;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(mozilla::dom::InspectorUtils::GetCSSPropertyPrefs(global, result))>, "Should be returning void here");
  mozilla::dom::InspectorUtils::GetCSSPropertyPrefs(global, result);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));

  uint32_t length = result.Length();
  JS::Rooted<JSObject*> returnArray(cx, JS::NewArrayObject(cx, length));
  if (!returnArray) {
    return false;
  }
  // Scope for 'tmp'
  {
    JS::Rooted<JS::Value> tmp(cx);
    for (uint32_t sequenceIdx0 = 0; sequenceIdx0 < length; ++sequenceIdx0) {
      // Control block to let us common up the JS_DefineElement calls when there
      // are different ways to succeed at wrapping the object.
      do {
        if (!result[sequenceIdx0].ToObjectInternal(cx, &tmp)) {
          return false;
        }
        break;
      } while (false);
      if (!JS_DefineElement(cx, returnArray, sequenceIdx0, tmp,
                            JSPROP_ENUMERATE)) {
        return false;
      }
    }
  }
  args.rval().setObject(*returnArray);
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
getCSSValuesForProperty(JSContext* cx, unsigned argc, JS::Value* vp)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "InspectorUtils", "getCSSValuesForProperty", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  JS::CallArgs args = JS::CallArgsFromVp(argc, vp);
  JS::Rooted<JSObject*> obj(cx, &args.callee());

  if (!args.requireAtLeast(cx, "InspectorUtils.getCSSValuesForProperty", 1)) {
    return false;
  }
  GlobalObject global(cx, xpc::XrayAwareCalleeGlobal(obj));
  if (global.Failed()) {
    return false;
  }

  binding_detail::FakeString<char> arg0;
  if (!ConvertJSValueToString(cx, args[0], eStringify, eStringify, arg0)) {
    return false;
  }
  FastErrorResult rv;
  nsTArray<nsString> result;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(mozilla::dom::InspectorUtils::GetCSSValuesForProperty(global, Constify(arg0), result, rv))>, "Should be returning void here");
  mozilla::dom::InspectorUtils::GetCSSValuesForProperty(global, Constify(arg0), result, rv);
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "InspectorUtils.getCSSValuesForProperty"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));

  uint32_t length = result.Length();
  JS::Rooted<JSObject*> returnArray(cx, JS::NewArrayObject(cx, length));
  if (!returnArray) {
    return false;
  }
  // Scope for 'tmp'
  {
    JS::Rooted<JS::Value> tmp(cx);
    for (uint32_t sequenceIdx0 = 0; sequenceIdx0 < length; ++sequenceIdx0) {
      // Control block to let us common up the JS_DefineElement calls when there
      // are different ways to succeed at wrapping the object.
      do {
        if (!xpc::NonVoidStringToJsval(cx, result[sequenceIdx0], &tmp)) {
          return false;
        }
        break;
      } while (false);
      if (!JS_DefineElement(cx, returnArray, sequenceIdx0, tmp,
                            JSPROP_ENUMERATE)) {
        return false;
      }
    }
  }
  args.rval().setObject(*returnArray);
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
rgbToColorName(JSContext* cx, unsigned argc, JS::Value* vp)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "InspectorUtils", "rgbToColorName", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  JS::CallArgs args = JS::CallArgsFromVp(argc, vp);
  JS::Rooted<JSObject*> obj(cx, &args.callee());

  if (!args.requireAtLeast(cx, "InspectorUtils.rgbToColorName", 3)) {
    return false;
  }
  GlobalObject global(cx, xpc::XrayAwareCalleeGlobal(obj));
  if (global.Failed()) {
    return false;
  }

  uint8_t arg0;
  if (!ValueToPrimitive<uint8_t, eDefault>(cx, args[0], "Argument 1", &arg0)) {
    return false;
  }
  uint8_t arg1;
  if (!ValueToPrimitive<uint8_t, eDefault>(cx, args[1], "Argument 2", &arg1)) {
    return false;
  }
  uint8_t arg2;
  if (!ValueToPrimitive<uint8_t, eDefault>(cx, args[2], "Argument 3", &arg2)) {
    return false;
  }
  nsAutoCString result;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(mozilla::dom::InspectorUtils::RgbToColorName(global, arg0, arg1, arg2, result))>, "Should be returning void here");
  mozilla::dom::InspectorUtils::RgbToColorName(global, arg0, arg1, arg2, result);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!NonVoidUTF8StringToJsval(cx, result, args.rval())) {
    return false;
  }
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
rgbToNearestColorName(JSContext* cx_, unsigned argc, JS::Value* vp)
{
  BindingCallContext cx(cx_, "InspectorUtils.rgbToNearestColorName");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "InspectorUtils", "rgbToNearestColorName", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  JS::CallArgs args = JS::CallArgsFromVp(argc, vp);
  JS::Rooted<JSObject*> obj(cx, &args.callee());

  if (!args.requireAtLeast(cx, "InspectorUtils.rgbToNearestColorName", 3)) {
    return false;
  }
  GlobalObject global(cx, xpc::XrayAwareCalleeGlobal(obj));
  if (global.Failed()) {
    return false;
  }

  float arg0;
  if (!ValueToPrimitive<float, eDefault>(cx, args[0], "Argument 1", &arg0)) {
    return false;
  } else if (!std::isfinite(arg0)) {
    cx.ThrowErrorMessage<MSG_NOT_FINITE>("Argument 1");
    return false;
  }
  float arg1;
  if (!ValueToPrimitive<float, eDefault>(cx, args[1], "Argument 2", &arg1)) {
    return false;
  } else if (!std::isfinite(arg1)) {
    cx.ThrowErrorMessage<MSG_NOT_FINITE>("Argument 2");
    return false;
  }
  float arg2;
  if (!ValueToPrimitive<float, eDefault>(cx, args[2], "Argument 3", &arg2)) {
    return false;
  } else if (!std::isfinite(arg2)) {
    cx.ThrowErrorMessage<MSG_NOT_FINITE>("Argument 3");
    return false;
  }
  InspectorNearestColor result;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(mozilla::dom::InspectorUtils::RgbToNearestColorName(global, arg0, arg1, arg2, result))>, "Should be returning void here");
  mozilla::dom::InspectorUtils::RgbToNearestColorName(global, arg0, arg1, arg2, result);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!result.ToObjectInternal(cx, args.rval())) {
    return false;
  }
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
rgbToHsv(JSContext* cx_, unsigned argc, JS::Value* vp)
{
  BindingCallContext cx(cx_, "InspectorUtils.rgbToHsv");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "InspectorUtils", "rgbToHsv", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  JS::CallArgs args = JS::CallArgsFromVp(argc, vp);
  JS::Rooted<JSObject*> obj(cx, &args.callee());

  if (!args.requireAtLeast(cx, "InspectorUtils.rgbToHsv", 3)) {
    return false;
  }
  GlobalObject global(cx, xpc::XrayAwareCalleeGlobal(obj));
  if (global.Failed()) {
    return false;
  }

  float arg0;
  if (!ValueToPrimitive<float, eDefault>(cx, args[0], "Argument 1", &arg0)) {
    return false;
  } else if (!std::isfinite(arg0)) {
    cx.ThrowErrorMessage<MSG_NOT_FINITE>("Argument 1");
    return false;
  }
  float arg1;
  if (!ValueToPrimitive<float, eDefault>(cx, args[1], "Argument 2", &arg1)) {
    return false;
  } else if (!std::isfinite(arg1)) {
    cx.ThrowErrorMessage<MSG_NOT_FINITE>("Argument 2");
    return false;
  }
  float arg2;
  if (!ValueToPrimitive<float, eDefault>(cx, args[2], "Argument 3", &arg2)) {
    return false;
  } else if (!std::isfinite(arg2)) {
    cx.ThrowErrorMessage<MSG_NOT_FINITE>("Argument 3");
    return false;
  }
  nsTArray<float> result;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(mozilla::dom::InspectorUtils::RgbToHsv(global, arg0, arg1, arg2, result))>, "Should be returning void here");
  mozilla::dom::InspectorUtils::RgbToHsv(global, arg0, arg1, arg2, result);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));

  uint32_t length = result.Length();
  JS::Rooted<JSObject*> returnArray(cx, JS::NewArrayObject(cx, length));
  if (!returnArray) {
    return false;
  }
  // Scope for 'tmp'
  {
    JS::Rooted<JS::Value> tmp(cx);
    for (uint32_t sequenceIdx0 = 0; sequenceIdx0 < length; ++sequenceIdx0) {
      // Control block to let us common up the JS_DefineElement calls when there
      // are different ways to succeed at wrapping the object.
      do {
        tmp.set(JS_NumberValue(double(result[sequenceIdx0])));
        break;
      } while (false);
      if (!JS_DefineElement(cx, returnArray, sequenceIdx0, tmp,
                            JSPROP_ENUMERATE)) {
        return false;
      }
    }
  }
  args.rval().setObject(*returnArray);
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
hsvToRgb(JSContext* cx_, unsigned argc, JS::Value* vp)
{
  BindingCallContext cx(cx_, "InspectorUtils.hsvToRgb");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "InspectorUtils", "hsvToRgb", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  JS::CallArgs args = JS::CallArgsFromVp(argc, vp);
  JS::Rooted<JSObject*> obj(cx, &args.callee());

  if (!args.requireAtLeast(cx, "InspectorUtils.hsvToRgb", 3)) {
    return false;
  }
  GlobalObject global(cx, xpc::XrayAwareCalleeGlobal(obj));
  if (global.Failed()) {
    return false;
  }

  float arg0;
  if (!ValueToPrimitive<float, eDefault>(cx, args[0], "Argument 1", &arg0)) {
    return false;
  } else if (!std::isfinite(arg0)) {
    cx.ThrowErrorMessage<MSG_NOT_FINITE>("Argument 1");
    return false;
  }
  float arg1;
  if (!ValueToPrimitive<float, eDefault>(cx, args[1], "Argument 2", &arg1)) {
    return false;
  } else if (!std::isfinite(arg1)) {
    cx.ThrowErrorMessage<MSG_NOT_FINITE>("Argument 2");
    return false;
  }
  float arg2;
  if (!ValueToPrimitive<float, eDefault>(cx, args[2], "Argument 3", &arg2)) {
    return false;
  } else if (!std::isfinite(arg2)) {
    cx.ThrowErrorMessage<MSG_NOT_FINITE>("Argument 3");
    return false;
  }
  nsTArray<float> result;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(mozilla::dom::InspectorUtils::HsvToRgb(global, arg0, arg1, arg2, result))>, "Should be returning void here");
  mozilla::dom::InspectorUtils::HsvToRgb(global, arg0, arg1, arg2, result);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));

  uint32_t length = result.Length();
  JS::Rooted<JSObject*> returnArray(cx, JS::NewArrayObject(cx, length));
  if (!returnArray) {
    return false;
  }
  // Scope for 'tmp'
  {
    JS::Rooted<JS::Value> tmp(cx);
    for (uint32_t sequenceIdx0 = 0; sequenceIdx0 < length; ++sequenceIdx0) {
      // Control block to let us common up the JS_DefineElement calls when there
      // are different ways to succeed at wrapping the object.
      do {
        tmp.set(JS_NumberValue(double(result[sequenceIdx0])));
        break;
      } while (false);
      if (!JS_DefineElement(cx, returnArray, sequenceIdx0, tmp,
                            JSPROP_ENUMERATE)) {
        return false;
      }
    }
  }
  args.rval().setObject(*returnArray);
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
relativeLuminance(JSContext* cx_, unsigned argc, JS::Value* vp)
{
  BindingCallContext cx(cx_, "InspectorUtils.relativeLuminance");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "InspectorUtils", "relativeLuminance", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  JS::CallArgs args = JS::CallArgsFromVp(argc, vp);
  JS::Rooted<JSObject*> obj(cx, &args.callee());

  if (!args.requireAtLeast(cx, "InspectorUtils.relativeLuminance", 3)) {
    return false;
  }
  GlobalObject global(cx, xpc::XrayAwareCalleeGlobal(obj));
  if (global.Failed()) {
    return false;
  }

  float arg0;
  if (!ValueToPrimitive<float, eDefault>(cx, args[0], "Argument 1", &arg0)) {
    return false;
  } else if (!std::isfinite(arg0)) {
    cx.ThrowErrorMessage<MSG_NOT_FINITE>("Argument 1");
    return false;
  }
  float arg1;
  if (!ValueToPrimitive<float, eDefault>(cx, args[1], "Argument 2", &arg1)) {
    return false;
  } else if (!std::isfinite(arg1)) {
    cx.ThrowErrorMessage<MSG_NOT_FINITE>("Argument 2");
    return false;
  }
  float arg2;
  if (!ValueToPrimitive<float, eDefault>(cx, args[2], "Argument 3", &arg2)) {
    return false;
  } else if (!std::isfinite(arg2)) {
    cx.ThrowErrorMessage<MSG_NOT_FINITE>("Argument 3");
    return false;
  }
  float result(mozilla::dom::InspectorUtils::RelativeLuminance(global, arg0, arg1, arg2));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().set(JS_NumberValue(double(result)));
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
colorToRGBA(JSContext* cx, unsigned argc, JS::Value* vp)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "InspectorUtils", "colorToRGBA", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  JS::CallArgs args = JS::CallArgsFromVp(argc, vp);
  JS::Rooted<JSObject*> obj(cx, &args.callee());

  if (!args.requireAtLeast(cx, "InspectorUtils.colorToRGBA", 1)) {
    return false;
  }
  GlobalObject global(cx, xpc::XrayAwareCalleeGlobal(obj));
  if (global.Failed()) {
    return false;
  }

  binding_detail::FakeString<char> arg0;
  if (!ConvertJSValueToString(cx, args[0], eStringify, eStringify, arg0)) {
    return false;
  }
  Nullable<InspectorRGBATuple> result;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(mozilla::dom::InspectorUtils::ColorToRGBA(global, Constify(arg0), result))>, "Should be returning void here");
  mozilla::dom::InspectorUtils::ColorToRGBA(global, Constify(arg0), result);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (result.IsNull()) {
    args.rval().setNull();
    return true;
  }
  if (!result.Value().ToObjectInternal(cx, args.rval())) {
    return false;
  }
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
colorTo(JSContext* cx, unsigned argc, JS::Value* vp)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "InspectorUtils", "colorTo", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  JS::CallArgs args = JS::CallArgsFromVp(argc, vp);
  JS::Rooted<JSObject*> obj(cx, &args.callee());

  if (!args.requireAtLeast(cx, "InspectorUtils.colorTo", 2)) {
    return false;
  }
  GlobalObject global(cx, xpc::XrayAwareCalleeGlobal(obj));
  if (global.Failed()) {
    return false;
  }

  binding_detail::FakeString<char> arg0;
  if (!ConvertJSValueToString(cx, args[0], eStringify, eStringify, arg0)) {
    return false;
  }
  binding_detail::FakeString<char> arg1;
  if (!ConvertJSValueToString(cx, args[1], eStringify, eStringify, arg1)) {
    return false;
  }
  Nullable<InspectorColorToResult> result;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(mozilla::dom::InspectorUtils::ColorTo(global, Constify(arg0), Constify(arg1), result))>, "Should be returning void here");
  mozilla::dom::InspectorUtils::ColorTo(global, Constify(arg0), Constify(arg1), result);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (result.IsNull()) {
    args.rval().setNull();
    return true;
  }
  if (!result.Value().ToObjectInternal(cx, args.rval())) {
    return false;
  }
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
isValidCSSColor(JSContext* cx, unsigned argc, JS::Value* vp)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "InspectorUtils", "isValidCSSColor", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  JS::CallArgs args = JS::CallArgsFromVp(argc, vp);
  JS::Rooted<JSObject*> obj(cx, &args.callee());

  if (!args.requireAtLeast(cx, "InspectorUtils.isValidCSSColor", 1)) {
    return false;
  }
  GlobalObject global(cx, xpc::XrayAwareCalleeGlobal(obj));
  if (global.Failed()) {
    return false;
  }

  binding_detail::FakeString<char> arg0;
  if (!ConvertJSValueToString(cx, args[0], eStringify, eStringify, arg0)) {
    return false;
  }
  bool result(mozilla::dom::InspectorUtils::IsValidCSSColor(global, Constify(arg0)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setBoolean(result);
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
getSubpropertiesForCSSProperty(JSContext* cx, unsigned argc, JS::Value* vp)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "InspectorUtils", "getSubpropertiesForCSSProperty", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  JS::CallArgs args = JS::CallArgsFromVp(argc, vp);
  JS::Rooted<JSObject*> obj(cx, &args.callee());

  if (!args.requireAtLeast(cx, "InspectorUtils.getSubpropertiesForCSSProperty", 1)) {
    return false;
  }
  GlobalObject global(cx, xpc::XrayAwareCalleeGlobal(obj));
  if (global.Failed()) {
    return false;
  }

  binding_detail::FakeString<char> arg0;
  if (!ConvertJSValueToString(cx, args[0], eStringify, eStringify, arg0)) {
    return false;
  }
  FastErrorResult rv;
  nsTArray<nsString> result;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(mozilla::dom::InspectorUtils::GetSubpropertiesForCSSProperty(global, Constify(arg0), result, rv))>, "Should be returning void here");
  mozilla::dom::InspectorUtils::GetSubpropertiesForCSSProperty(global, Constify(arg0), result, rv);
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "InspectorUtils.getSubpropertiesForCSSProperty"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));

  uint32_t length = result.Length();
  JS::Rooted<JSObject*> returnArray(cx, JS::NewArrayObject(cx, length));
  if (!returnArray) {
    return false;
  }
  // Scope for 'tmp'
  {
    JS::Rooted<JS::Value> tmp(cx);
    for (uint32_t sequenceIdx0 = 0; sequenceIdx0 < length; ++sequenceIdx0) {
      // Control block to let us common up the JS_DefineElement calls when there
      // are different ways to succeed at wrapping the object.
      do {
        if (!xpc::NonVoidStringToJsval(cx, result[sequenceIdx0], &tmp)) {
          return false;
        }
        break;
      } while (false);
      if (!JS_DefineElement(cx, returnArray, sequenceIdx0, tmp,
                            JSPROP_ENUMERATE)) {
        return false;
      }
    }
  }
  args.rval().setObject(*returnArray);
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
cssPropertyIsShorthand(JSContext* cx, unsigned argc, JS::Value* vp)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "InspectorUtils", "cssPropertyIsShorthand", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  JS::CallArgs args = JS::CallArgsFromVp(argc, vp);
  JS::Rooted<JSObject*> obj(cx, &args.callee());

  if (!args.requireAtLeast(cx, "InspectorUtils.cssPropertyIsShorthand", 1)) {
    return false;
  }
  GlobalObject global(cx, xpc::XrayAwareCalleeGlobal(obj));
  if (global.Failed()) {
    return false;
  }

  binding_detail::FakeString<char> arg0;
  if (!ConvertJSValueToString(cx, args[0], eStringify, eStringify, arg0)) {
    return false;
  }
  FastErrorResult rv;
  bool result(mozilla::dom::InspectorUtils::CssPropertyIsShorthand(global, Constify(arg0), rv));
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "InspectorUtils.cssPropertyIsShorthand"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setBoolean(result);
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
cssPropertySupportsType(JSContext* cx_, unsigned argc, JS::Value* vp)
{
  BindingCallContext cx(cx_, "InspectorUtils.cssPropertySupportsType");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "InspectorUtils", "cssPropertySupportsType", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  JS::CallArgs args = JS::CallArgsFromVp(argc, vp);
  JS::Rooted<JSObject*> obj(cx, &args.callee());

  if (!args.requireAtLeast(cx, "InspectorUtils.cssPropertySupportsType", 2)) {
    return false;
  }
  GlobalObject global(cx, xpc::XrayAwareCalleeGlobal(obj));
  if (global.Failed()) {
    return false;
  }

  binding_detail::FakeString<char> arg0;
  if (!ConvertJSValueToString(cx, args[0], eStringify, eStringify, arg0)) {
    return false;
  }
  InspectorPropertyType arg1;
  {
    int index;
    if (!binding_detail::FindEnumStringIndex<true>(cx, args[1],
                                                                       binding_detail::EnumStrings<InspectorPropertyType>::Values,
                                                                       "InspectorPropertyType", "argument 2",
                                                                       &index)) {
      return false;
    }
    MOZ_ASSERT(index >= 0);
    arg1 = static_cast<InspectorPropertyType>(index);
  }
  FastErrorResult rv;
  bool result(mozilla::dom::InspectorUtils::CssPropertySupportsType(global, Constify(arg0), arg1, rv));
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "InspectorUtils.cssPropertySupportsType"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setBoolean(result);
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
supports(JSContext* cx_, unsigned argc, JS::Value* vp)
{
  BindingCallContext cx(cx_, "InspectorUtils.supports");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "InspectorUtils", "supports", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  JS::CallArgs args = JS::CallArgsFromVp(argc, vp);
  JS::Rooted<JSObject*> obj(cx, &args.callee());

  if (!args.requireAtLeast(cx, "InspectorUtils.supports", 1)) {
    return false;
  }
  GlobalObject global(cx, xpc::XrayAwareCalleeGlobal(obj));
  if (global.Failed()) {
    return false;
  }

  binding_detail::FakeString<char> arg0;
  if (!ConvertJSValueToString(cx, args[0], eStringify, eStringify, arg0)) {
    return false;
  }
  binding_detail::FastSupportsOptions arg1;
  if (!arg1.Init(cx, (args.hasDefined(1)) ? args[1] : JS::NullHandleValue, "Argument 2", false)) {
    return false;
  }
  bool result(mozilla::dom::InspectorUtils::Supports(global, Constify(arg0), Constify(arg1)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setBoolean(result);
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
isIgnorableWhitespace(JSContext* cx_, unsigned argc, JS::Value* vp)
{
  BindingCallContext cx(cx_, "InspectorUtils.isIgnorableWhitespace");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "InspectorUtils", "isIgnorableWhitespace", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  JS::CallArgs args = JS::CallArgsFromVp(argc, vp);
  JS::Rooted<JSObject*> obj(cx, &args.callee());

  if (!args.requireAtLeast(cx, "InspectorUtils.isIgnorableWhitespace", 1)) {
    return false;
  }
  GlobalObject global(cx, xpc::XrayAwareCalleeGlobal(obj));
  if (global.Failed()) {
    return false;
  }

  NonNull<mozilla::dom::CharacterData> arg0;
  if (args[0].isObject()) {
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::CharacterData, mozilla::dom::CharacterData>(args[0], arg0, cx);
      if (NS_FAILED(rv)) {
        cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Argument 1", "CharacterData");
        return false;
      }
    }
  } else {
    cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 1");
    return false;
  }
  bool result(mozilla::dom::InspectorUtils::IsIgnorableWhitespace(global, MOZ_KnownLive(NonNullHelper(arg0))));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setBoolean(result);
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
getParentForNode(JSContext* cx_, unsigned argc, JS::Value* vp)
{
  BindingCallContext cx(cx_, "InspectorUtils.getParentForNode");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "InspectorUtils", "getParentForNode", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  JS::CallArgs args = JS::CallArgsFromVp(argc, vp);
  JS::Rooted<JSObject*> obj(cx, &args.callee());

  if (!args.requireAtLeast(cx, "InspectorUtils.getParentForNode", 2)) {
    return false;
  }
  GlobalObject global(cx, xpc::XrayAwareCalleeGlobal(obj));
  if (global.Failed()) {
    return false;
  }

  NonNull<nsINode> arg0;
  if (args[0].isObject()) {
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::Node, nsINode>(args[0], arg0, cx);
      if (NS_FAILED(rv)) {
        cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Argument 1", "Node");
        return false;
      }
    }
  } else {
    cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 1");
    return false;
  }
  bool arg1;
  if (!ValueToPrimitive<bool, eDefault>(cx, args[1], "Argument 2", &arg1)) {
    return false;
  }
  auto result(StrongOrRawPtr<nsINode>(mozilla::dom::InspectorUtils::GetParentForNode(global, MOZ_KnownLive(NonNullHelper(arg0)), arg1)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!result) {
    args.rval().setNull();
    return true;
  }
  if (!GetOrCreateDOMReflector(cx, result, args.rval())) {
    MOZ_ASSERT(JS_IsExceptionPending(cx));
    return false;
  }
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
getChildrenForNode(JSContext* cx_, unsigned argc, JS::Value* vp)
{
  BindingCallContext cx(cx_, "InspectorUtils.getChildrenForNode");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "InspectorUtils", "getChildrenForNode", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  JS::CallArgs args = JS::CallArgsFromVp(argc, vp);
  JS::Rooted<JSObject*> obj(cx, &args.callee());

  if (!args.requireAtLeast(cx, "InspectorUtils.getChildrenForNode", 3)) {
    return false;
  }
  GlobalObject global(cx, xpc::XrayAwareCalleeGlobal(obj));
  if (global.Failed()) {
    return false;
  }

  NonNull<nsINode> arg0;
  if (args[0].isObject()) {
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::Node, nsINode>(args[0], arg0, cx);
      if (NS_FAILED(rv)) {
        cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Argument 1", "Node");
        return false;
      }
    }
  } else {
    cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 1");
    return false;
  }
  bool arg1;
  if (!ValueToPrimitive<bool, eDefault>(cx, args[1], "Argument 2", &arg1)) {
    return false;
  }
  bool arg2;
  if (!ValueToPrimitive<bool, eDefault>(cx, args[2], "Argument 3", &arg2)) {
    return false;
  }
  nsTArray<StrongPtrForMember<nsINode>> result;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(mozilla::dom::InspectorUtils::GetChildrenForNode(global, MOZ_KnownLive(NonNullHelper(arg0)), arg1, arg2, result))>, "Should be returning void here");
  mozilla::dom::InspectorUtils::GetChildrenForNode(global, MOZ_KnownLive(NonNullHelper(arg0)), arg1, arg2, result);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));

  uint32_t length = result.Length();
  JS::Rooted<JSObject*> returnArray(cx, JS::NewArrayObject(cx, length));
  if (!returnArray) {
    return false;
  }
  // Scope for 'tmp'
  {
    JS::Rooted<JS::Value> tmp(cx);
    for (uint32_t sequenceIdx0 = 0; sequenceIdx0 < length; ++sequenceIdx0) {
      // Control block to let us common up the JS_DefineElement calls when there
      // are different ways to succeed at wrapping the object.
      do {
        if (!GetOrCreateDOMReflector(cx, result[sequenceIdx0], &tmp)) {
          MOZ_ASSERT(JS_IsExceptionPending(cx));
          return false;
        }
        break;
      } while (false);
      if (!JS_DefineElement(cx, returnArray, sequenceIdx0, tmp,
                            JSPROP_ENUMERATE)) {
        return false;
      }
    }
  }
  args.rval().setObject(*returnArray);
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
setContentState(JSContext* cx_, unsigned argc, JS::Value* vp)
{
  BindingCallContext cx(cx_, "InspectorUtils.setContentState");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "InspectorUtils", "setContentState", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  JS::CallArgs args = JS::CallArgsFromVp(argc, vp);
  JS::Rooted<JSObject*> obj(cx, &args.callee());

  if (!args.requireAtLeast(cx, "InspectorUtils.setContentState", 2)) {
    return false;
  }
  GlobalObject global(cx, xpc::XrayAwareCalleeGlobal(obj));
  if (global.Failed()) {
    return false;
  }

  NonNull<mozilla::dom::Element> arg0;
  if (args[0].isObject()) {
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::Element, mozilla::dom::Element>(args[0], arg0, cx);
      if (NS_FAILED(rv)) {
        cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Argument 1", "Element");
        return false;
      }
    }
  } else {
    cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 1");
    return false;
  }
  uint64_t arg1;
  if (!ValueToPrimitive<uint64_t, eDefault>(cx, args[1], "Argument 2", &arg1)) {
    return false;
  }
  FastErrorResult rv;
  bool result(mozilla::dom::InspectorUtils::SetContentState(global, MOZ_KnownLive(NonNullHelper(arg0)), arg1, rv));
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "InspectorUtils.setContentState"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setBoolean(result);
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
removeContentState(JSContext* cx_, unsigned argc, JS::Value* vp)
{
  BindingCallContext cx(cx_, "InspectorUtils.removeContentState");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "InspectorUtils", "removeContentState", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  JS::CallArgs args = JS::CallArgsFromVp(argc, vp);
  JS::Rooted<JSObject*> obj(cx, &args.callee());

  if (!args.requireAtLeast(cx, "InspectorUtils.removeContentState", 2)) {
    return false;
  }
  GlobalObject global(cx, xpc::XrayAwareCalleeGlobal(obj));
  if (global.Failed()) {
    return false;
  }

  NonNull<mozilla::dom::Element> arg0;
  if (args[0].isObject()) {
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::Element, mozilla::dom::Element>(args[0], arg0, cx);
      if (NS_FAILED(rv)) {
        cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Argument 1", "Element");
        return false;
      }
    }
  } else {
    cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 1");
    return false;
  }
  uint64_t arg1;
  if (!ValueToPrimitive<uint64_t, eDefault>(cx, args[1], "Argument 2", &arg1)) {
    return false;
  }
  bool arg2;
  if (args.hasDefined(2)) {
    if (!ValueToPrimitive<bool, eDefault>(cx, args[2], "Argument 3", &arg2)) {
      return false;
    }
  } else {
    arg2 = false;
  }
  FastErrorResult rv;
  bool result(mozilla::dom::InspectorUtils::RemoveContentState(global, MOZ_KnownLive(NonNullHelper(arg0)), arg1, arg2, rv));
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "InspectorUtils.removeContentState"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setBoolean(result);
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
getContentState(JSContext* cx_, unsigned argc, JS::Value* vp)
{
  BindingCallContext cx(cx_, "InspectorUtils.getContentState");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "InspectorUtils", "getContentState", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  JS::CallArgs args = JS::CallArgsFromVp(argc, vp);
  JS::Rooted<JSObject*> obj(cx, &args.callee());

  if (!args.requireAtLeast(cx, "InspectorUtils.getContentState", 1)) {
    return false;
  }
  GlobalObject global(cx, xpc::XrayAwareCalleeGlobal(obj));
  if (global.Failed()) {
    return false;
  }

  NonNull<mozilla::dom::Element> arg0;
  if (args[0].isObject()) {
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::Element, mozilla::dom::Element>(args[0], arg0, cx);
      if (NS_FAILED(rv)) {
        cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Argument 1", "Element");
        return false;
      }
    }
  } else {
    cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 1");
    return false;
  }
  uint64_t result(mozilla::dom::InspectorUtils::GetContentState(global, MOZ_KnownLive(NonNullHelper(arg0))));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().set(JS_NumberValue(double(result)));
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
getUsedFontFaces(JSContext* cx_, unsigned argc, JS::Value* vp)
{
  BindingCallContext cx(cx_, "InspectorUtils.getUsedFontFaces");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "InspectorUtils", "getUsedFontFaces", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  JS::CallArgs args = JS::CallArgsFromVp(argc, vp);
  JS::Rooted<JSObject*> obj(cx, &args.callee());

  if (!args.requireAtLeast(cx, "InspectorUtils.getUsedFontFaces", 1)) {
    return false;
  }
  GlobalObject global(cx, xpc::XrayAwareCalleeGlobal(obj));
  if (global.Failed()) {
    return false;
  }

  NonNull<nsRange> arg0;
  if (args[0].isObject()) {
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::Range, nsRange>(args[0], arg0, cx);
      if (NS_FAILED(rv)) {
        cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Argument 1", "Range");
        return false;
      }
    }
  } else {
    cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 1");
    return false;
  }
  uint32_t arg1;
  if (args.hasDefined(1)) {
    if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[1], "Argument 2", &arg1)) {
      return false;
    }
  } else {
    arg1 = 0U;
  }
  bool arg2;
  if (args.hasDefined(2)) {
    if (!ValueToPrimitive<bool, eDefault>(cx, args[2], "Argument 3", &arg2)) {
      return false;
    }
  } else {
    arg2 = true;
  }
  FastErrorResult rv;
  nsTArray<StrongPtrForMember<mozilla::dom::InspectorFontFace>> result;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(mozilla::dom::InspectorUtils::GetUsedFontFaces(global, MOZ_KnownLive(NonNullHelper(arg0)), arg1, arg2, result, rv))>, "Should be returning void here");
  mozilla::dom::InspectorUtils::GetUsedFontFaces(global, MOZ_KnownLive(NonNullHelper(arg0)), arg1, arg2, result, rv);
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "InspectorUtils.getUsedFontFaces"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));

  uint32_t length = result.Length();
  JS::Rooted<JSObject*> returnArray(cx, JS::NewArrayObject(cx, length));
  if (!returnArray) {
    return false;
  }
  // Scope for 'tmp'
  {
    JS::Rooted<JS::Value> tmp(cx);
    for (uint32_t sequenceIdx0 = 0; sequenceIdx0 < length; ++sequenceIdx0) {
      // Control block to let us common up the JS_DefineElement calls when there
      // are different ways to succeed at wrapping the object.
      do {
        if (!WrapNewBindingNonWrapperCachedObject(cx, returnArray, result[sequenceIdx0], &tmp)) {
          MOZ_ASSERT(JS_IsExceptionPending(cx));
          return false;
        }
        break;
      } while (false);
      if (!JS_DefineElement(cx, returnArray, sequenceIdx0, tmp,
                            JSPROP_ENUMERATE)) {
        return false;
      }
    }
  }
  args.rval().setObject(*returnArray);
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
getCSSPseudoElementNames(JSContext* cx, unsigned argc, JS::Value* vp)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "InspectorUtils", "getCSSPseudoElementNames", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  JS::CallArgs args = JS::CallArgsFromVp(argc, vp);
  JS::Rooted<JSObject*> obj(cx, &args.callee());

  GlobalObject global(cx, xpc::XrayAwareCalleeGlobal(obj));
  if (global.Failed()) {
    return false;
  }

  nsTArray<nsString> result;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(mozilla::dom::InspectorUtils::GetCSSPseudoElementNames(global, result))>, "Should be returning void here");
  mozilla::dom::InspectorUtils::GetCSSPseudoElementNames(global, result);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));

  uint32_t length = result.Length();
  JS::Rooted<JSObject*> returnArray(cx, JS::NewArrayObject(cx, length));
  if (!returnArray) {
    return false;
  }
  // Scope for 'tmp'
  {
    JS::Rooted<JS::Value> tmp(cx);
    for (uint32_t sequenceIdx0 = 0; sequenceIdx0 < length; ++sequenceIdx0) {
      // Control block to let us common up the JS_DefineElement calls when there
      // are different ways to succeed at wrapping the object.
      do {
        if (!xpc::NonVoidStringToJsval(cx, result[sequenceIdx0], &tmp)) {
          return false;
        }
        break;
      } while (false);
      if (!JS_DefineElement(cx, returnArray, sequenceIdx0, tmp,
                            JSPROP_ENUMERATE)) {
        return false;
      }
    }
  }
  args.rval().setObject(*returnArray);
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
addPseudoClassLock(JSContext* cx_, unsigned argc, JS::Value* vp)
{
  BindingCallContext cx(cx_, "InspectorUtils.addPseudoClassLock");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "InspectorUtils", "addPseudoClassLock", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  JS::CallArgs args = JS::CallArgsFromVp(argc, vp);
  JS::Rooted<JSObject*> obj(cx, &args.callee());

  if (!args.requireAtLeast(cx, "InspectorUtils.addPseudoClassLock", 2)) {
    return false;
  }
  GlobalObject global(cx, xpc::XrayAwareCalleeGlobal(obj));
  if (global.Failed()) {
    return false;
  }

  NonNull<mozilla::dom::Element> arg0;
  if (args[0].isObject()) {
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::Element, mozilla::dom::Element>(args[0], arg0, cx);
      if (NS_FAILED(rv)) {
        cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Argument 1", "Element");
        return false;
      }
    }
  } else {
    cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 1");
    return false;
  }
  binding_detail::FakeString<char16_t> arg1;
  if (!ConvertJSValueToString(cx, args[1], eStringify, eStringify, arg1)) {
    return false;
  }
  bool arg2;
  if (args.hasDefined(2)) {
    if (!ValueToPrimitive<bool, eDefault>(cx, args[2], "Argument 3", &arg2)) {
      return false;
    }
  } else {
    arg2 = true;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(mozilla::dom::InspectorUtils::AddPseudoClassLock(global, MOZ_KnownLive(NonNullHelper(arg0)), NonNullHelper(Constify(arg1)), arg2))>, "Should be returning void here");
  mozilla::dom::InspectorUtils::AddPseudoClassLock(global, MOZ_KnownLive(NonNullHelper(arg0)), NonNullHelper(Constify(arg1)), arg2);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
removePseudoClassLock(JSContext* cx_, unsigned argc, JS::Value* vp)
{
  BindingCallContext cx(cx_, "InspectorUtils.removePseudoClassLock");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "InspectorUtils", "removePseudoClassLock", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  JS::CallArgs args = JS::CallArgsFromVp(argc, vp);
  JS::Rooted<JSObject*> obj(cx, &args.callee());

  if (!args.requireAtLeast(cx, "InspectorUtils.removePseudoClassLock", 2)) {
    return false;
  }
  GlobalObject global(cx, xpc::XrayAwareCalleeGlobal(obj));
  if (global.Failed()) {
    return false;
  }

  NonNull<mozilla::dom::Element> arg0;
  if (args[0].isObject()) {
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::Element, mozilla::dom::Element>(args[0], arg0, cx);
      if (NS_FAILED(rv)) {
        cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Argument 1", "Element");
        return false;
      }
    }
  } else {
    cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 1");
    return false;
  }
  binding_detail::FakeString<char16_t> arg1;
  if (!ConvertJSValueToString(cx, args[1], eStringify, eStringify, arg1)) {
    return false;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(mozilla::dom::InspectorUtils::RemovePseudoClassLock(global, MOZ_KnownLive(NonNullHelper(arg0)), NonNullHelper(Constify(arg1))))>, "Should be returning void here");
  mozilla::dom::InspectorUtils::RemovePseudoClassLock(global, MOZ_KnownLive(NonNullHelper(arg0)), NonNullHelper(Constify(arg1)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
hasPseudoClassLock(JSContext* cx_, unsigned argc, JS::Value* vp)
{
  BindingCallContext cx(cx_, "InspectorUtils.hasPseudoClassLock");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "InspectorUtils", "hasPseudoClassLock", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  JS::CallArgs args = JS::CallArgsFromVp(argc, vp);
  JS::Rooted<JSObject*> obj(cx, &args.callee());

  if (!args.requireAtLeast(cx, "InspectorUtils.hasPseudoClassLock", 2)) {
    return false;
  }
  GlobalObject global(cx, xpc::XrayAwareCalleeGlobal(obj));
  if (global.Failed()) {
    return false;
  }

  NonNull<mozilla::dom::Element> arg0;
  if (args[0].isObject()) {
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::Element, mozilla::dom::Element>(args[0], arg0, cx);
      if (NS_FAILED(rv)) {
        cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Argument 1", "Element");
        return false;
      }
    }
  } else {
    cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 1");
    return false;
  }
  binding_detail::FakeString<char16_t> arg1;
  if (!ConvertJSValueToString(cx, args[1], eStringify, eStringify, arg1)) {
    return false;
  }
  bool result(mozilla::dom::InspectorUtils::HasPseudoClassLock(global, MOZ_KnownLive(NonNullHelper(arg0)), NonNullHelper(Constify(arg1))));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setBoolean(result);
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
clearPseudoClassLocks(JSContext* cx_, unsigned argc, JS::Value* vp)
{
  BindingCallContext cx(cx_, "InspectorUtils.clearPseudoClassLocks");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "InspectorUtils", "clearPseudoClassLocks", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  JS::CallArgs args = JS::CallArgsFromVp(argc, vp);
  JS::Rooted<JSObject*> obj(cx, &args.callee());

  if (!args.requireAtLeast(cx, "InspectorUtils.clearPseudoClassLocks", 1)) {
    return false;
  }
  GlobalObject global(cx, xpc::XrayAwareCalleeGlobal(obj));
  if (global.Failed()) {
    return false;
  }

  NonNull<mozilla::dom::Element> arg0;
  if (args[0].isObject()) {
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::Element, mozilla::dom::Element>(args[0], arg0, cx);
      if (NS_FAILED(rv)) {
        cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Argument 1", "Element");
        return false;
      }
    }
  } else {
    cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 1");
    return false;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(mozilla::dom::InspectorUtils::ClearPseudoClassLocks(global, MOZ_KnownLive(NonNullHelper(arg0))))>, "Should be returning void here");
  mozilla::dom::InspectorUtils::ClearPseudoClassLocks(global, MOZ_KnownLive(NonNullHelper(arg0)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
parseStyleSheet(JSContext* cx_, unsigned argc, JS::Value* vp)
{
  BindingCallContext cx(cx_, "InspectorUtils.parseStyleSheet");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "InspectorUtils", "parseStyleSheet", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  JS::CallArgs args = JS::CallArgsFromVp(argc, vp);
  JS::Rooted<JSObject*> obj(cx, &args.callee());

  if (!args.requireAtLeast(cx, "InspectorUtils.parseStyleSheet", 2)) {
    return false;
  }
  GlobalObject global(cx, xpc::XrayAwareCalleeGlobal(obj));
  if (global.Failed()) {
    return false;
  }

  NonNull<mozilla::StyleSheet> arg0;
  if (args[0].isObject()) {
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::CSSStyleSheet, mozilla::StyleSheet>(args[0], arg0, cx);
      if (NS_FAILED(rv)) {
        cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Argument 1", "CSSStyleSheet");
        return false;
      }
    }
  } else {
    cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 1");
    return false;
  }
  binding_detail::FakeString<char> arg1;
  if (!ConvertJSValueToString(cx, args[1], eStringify, eStringify, arg1)) {
    return false;
  }
  FastErrorResult rv;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(mozilla::dom::InspectorUtils::ParseStyleSheet(global, MOZ_KnownLive(NonNullHelper(arg0)), Constify(arg1), rv))>, "Should be returning void here");
  mozilla::dom::InspectorUtils::ParseStyleSheet(global, MOZ_KnownLive(NonNullHelper(arg0)), Constify(arg1), rv);
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "InspectorUtils.parseStyleSheet"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
isCustomElementName(JSContext* cx, unsigned argc, JS::Value* vp)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "InspectorUtils", "isCustomElementName", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  JS::CallArgs args = JS::CallArgsFromVp(argc, vp);
  JS::Rooted<JSObject*> obj(cx, &args.callee());

  if (!args.requireAtLeast(cx, "InspectorUtils.isCustomElementName", 2)) {
    return false;
  }
  GlobalObject global(cx, xpc::XrayAwareCalleeGlobal(obj));
  if (global.Failed()) {
    return false;
  }

  binding_detail::FakeString<char16_t> arg0;
  if (!ConvertJSValueToString(cx, args[0], eEmpty, eStringify, arg0)) {
    return false;
  }
  binding_detail::FakeString<char16_t> arg1;
  if (!ConvertJSValueToString(cx, args[1], eNull, eNull, arg1)) {
    return false;
  }
  bool result(mozilla::dom::InspectorUtils::IsCustomElementName(global, NonNullHelper(Constify(arg0)), NonNullHelper(Constify(arg1))));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setBoolean(result);
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
isElementThemed(JSContext* cx_, unsigned argc, JS::Value* vp)
{
  BindingCallContext cx(cx_, "InspectorUtils.isElementThemed");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "InspectorUtils", "isElementThemed", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  JS::CallArgs args = JS::CallArgsFromVp(argc, vp);
  JS::Rooted<JSObject*> obj(cx, &args.callee());

  if (!args.requireAtLeast(cx, "InspectorUtils.isElementThemed", 1)) {
    return false;
  }
  GlobalObject global(cx, xpc::XrayAwareCalleeGlobal(obj));
  if (global.Failed()) {
    return false;
  }

  NonNull<mozilla::dom::Element> arg0;
  if (args[0].isObject()) {
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::Element, mozilla::dom::Element>(args[0], arg0, cx);
      if (NS_FAILED(rv)) {
        cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Argument 1", "Element");
        return false;
      }
    }
  } else {
    cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 1");
    return false;
  }
  bool result(mozilla::dom::InspectorUtils::IsElementThemed(global, MOZ_KnownLive(NonNullHelper(arg0))));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setBoolean(result);
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
isUsedColorSchemeDark(JSContext* cx_, unsigned argc, JS::Value* vp)
{
  BindingCallContext cx(cx_, "InspectorUtils.isUsedColorSchemeDark");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "InspectorUtils", "isUsedColorSchemeDark", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  JS::CallArgs args = JS::CallArgsFromVp(argc, vp);
  JS::Rooted<JSObject*> obj(cx, &args.callee());

  if (!args.requireAtLeast(cx, "InspectorUtils.isUsedColorSchemeDark", 1)) {
    return false;
  }
  GlobalObject global(cx, xpc::XrayAwareCalleeGlobal(obj));
  if (global.Failed()) {
    return false;
  }

  NonNull<mozilla::dom::Element> arg0;
  if (args[0].isObject()) {
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::Element, mozilla::dom::Element>(args[0], arg0, cx);
      if (NS_FAILED(rv)) {
        cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Argument 1", "Element");
        return false;
      }
    }
  } else {
    cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 1");
    return false;
  }
  bool result(mozilla::dom::InspectorUtils::IsUsedColorSchemeDark(global, MOZ_KnownLive(NonNullHelper(arg0))));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setBoolean(result);
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
containingBlockOf(JSContext* cx_, unsigned argc, JS::Value* vp)
{
  BindingCallContext cx(cx_, "InspectorUtils.containingBlockOf");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "InspectorUtils", "containingBlockOf", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  JS::CallArgs args = JS::CallArgsFromVp(argc, vp);
  JS::Rooted<JSObject*> obj(cx, &args.callee());

  if (!args.requireAtLeast(cx, "InspectorUtils.containingBlockOf", 1)) {
    return false;
  }
  GlobalObject global(cx, xpc::XrayAwareCalleeGlobal(obj));
  if (global.Failed()) {
    return false;
  }

  NonNull<mozilla::dom::Element> arg0;
  if (args[0].isObject()) {
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::Element, mozilla::dom::Element>(args[0], arg0, cx);
      if (NS_FAILED(rv)) {
        cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Argument 1", "Element");
        return false;
      }
    }
  } else {
    cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 1");
    return false;
  }
  auto result(StrongOrRawPtr<mozilla::dom::Element>(mozilla::dom::InspectorUtils::ContainingBlockOf(global, MOZ_KnownLive(NonNullHelper(arg0)))));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!result) {
    args.rval().setNull();
    return true;
  }
  if (!GetOrCreateDOMReflector(cx, result, args.rval())) {
    MOZ_ASSERT(JS_IsExceptionPending(cx));
    return false;
  }
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
isBlockContainer(JSContext* cx_, unsigned argc, JS::Value* vp)
{
  BindingCallContext cx(cx_, "InspectorUtils.isBlockContainer");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "InspectorUtils", "isBlockContainer", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  JS::CallArgs args = JS::CallArgsFromVp(argc, vp);
  JS::Rooted<JSObject*> obj(cx, &args.callee());

  if (!args.requireAtLeast(cx, "InspectorUtils.isBlockContainer", 1)) {
    return false;
  }
  GlobalObject global(cx, xpc::XrayAwareCalleeGlobal(obj));
  if (global.Failed()) {
    return false;
  }

  NonNull<mozilla::dom::Element> arg0;
  if (args[0].isObject()) {
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::Element, mozilla::dom::Element>(args[0], arg0, cx);
      if (NS_FAILED(rv)) {
        cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Argument 1", "Element");
        return false;
      }
    }
  } else {
    cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 1");
    return false;
  }
  bool result(mozilla::dom::InspectorUtils::IsBlockContainer(global, MOZ_KnownLive(NonNullHelper(arg0))));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setBoolean(result);
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
getBlockLineCounts(JSContext* cx_, unsigned argc, JS::Value* vp)
{
  BindingCallContext cx(cx_, "InspectorUtils.getBlockLineCounts");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "InspectorUtils", "getBlockLineCounts", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  JS::CallArgs args = JS::CallArgsFromVp(argc, vp);
  JS::Rooted<JSObject*> obj(cx, &args.callee());

  if (!args.requireAtLeast(cx, "InspectorUtils.getBlockLineCounts", 1)) {
    return false;
  }
  GlobalObject global(cx, xpc::XrayAwareCalleeGlobal(obj));
  if (global.Failed()) {
    return false;
  }

  NonNull<mozilla::dom::Element> arg0;
  if (args[0].isObject()) {
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::Element, mozilla::dom::Element>(args[0], arg0, cx);
      if (NS_FAILED(rv)) {
        cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Argument 1", "Element");
        return false;
      }
    }
  } else {
    cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 1");
    return false;
  }
  Nullable<nsTArray<uint32_t>> result;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(mozilla::dom::InspectorUtils::GetBlockLineCounts(global, MOZ_KnownLive(NonNullHelper(arg0)), result))>, "Should be returning void here");
  mozilla::dom::InspectorUtils::GetBlockLineCounts(global, MOZ_KnownLive(NonNullHelper(arg0)), result);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));

  if (result.IsNull()) {
    args.rval().setNull();
    return true;
  }

  uint32_t length = result.Value().Length();
  JS::Rooted<JSObject*> returnArray(cx, JS::NewArrayObject(cx, length));
  if (!returnArray) {
    return false;
  }
  // Scope for 'tmp'
  {
    JS::Rooted<JS::Value> tmp(cx);
    for (uint32_t sequenceIdx0 = 0; sequenceIdx0 < length; ++sequenceIdx0) {
      // Control block to let us common up the JS_DefineElement calls when there
      // are different ways to succeed at wrapping the object.
      do {
        tmp.setNumber(result.Value()[sequenceIdx0]);
        break;
      } while (false);
      if (!JS_DefineElement(cx, returnArray, sequenceIdx0, tmp,
                            JSPROP_ENUMERATE)) {
        return false;
      }
    }
  }
  args.rval().setObject(*returnArray);
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
getOverflowingChildrenOfElement(JSContext* cx_, unsigned argc, JS::Value* vp)
{
  BindingCallContext cx(cx_, "InspectorUtils.getOverflowingChildrenOfElement");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "InspectorUtils", "getOverflowingChildrenOfElement", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  JS::CallArgs args = JS::CallArgsFromVp(argc, vp);
  JS::Rooted<JSObject*> obj(cx, &args.callee());

  if (!args.requireAtLeast(cx, "InspectorUtils.getOverflowingChildrenOfElement", 1)) {
    return false;
  }
  GlobalObject global(cx, xpc::XrayAwareCalleeGlobal(obj));
  if (global.Failed()) {
    return false;
  }

  NonNull<mozilla::dom::Element> arg0;
  if (args[0].isObject()) {
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::Element, mozilla::dom::Element>(args[0], arg0, cx);
      if (NS_FAILED(rv)) {
        cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Argument 1", "Element");
        return false;
      }
    }
  } else {
    cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 1");
    return false;
  }
  auto result(StrongOrRawPtr<nsINodeList>(mozilla::dom::InspectorUtils::GetOverflowingChildrenOfElement(global, MOZ_KnownLive(NonNullHelper(arg0)))));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  static_assert(!std::is_pointer_v<decltype(result)>,
                "NewObject implies that we need to keep the object alive with a strong reference.");
  if (!GetOrCreateDOMReflector(cx, result, args.rval())) {
    MOZ_ASSERT(JS_IsExceptionPending(cx));
    return false;
  }
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
getRegisteredCssHighlights(JSContext* cx_, unsigned argc, JS::Value* vp)
{
  BindingCallContext cx(cx_, "InspectorUtils.getRegisteredCssHighlights");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "InspectorUtils", "getRegisteredCssHighlights", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  JS::CallArgs args = JS::CallArgsFromVp(argc, vp);
  JS::Rooted<JSObject*> obj(cx, &args.callee());

  if (!args.requireAtLeast(cx, "InspectorUtils.getRegisteredCssHighlights", 1)) {
    return false;
  }
  GlobalObject global(cx, xpc::XrayAwareCalleeGlobal(obj));
  if (global.Failed()) {
    return false;
  }

  NonNull<mozilla::dom::Document> arg0;
  if (args[0].isObject()) {
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::Document, mozilla::dom::Document>(args[0], arg0, cx);
      if (NS_FAILED(rv)) {
        cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Argument 1", "Document");
        return false;
      }
    }
  } else {
    cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 1");
    return false;
  }
  bool arg1;
  if (args.hasDefined(1)) {
    if (!ValueToPrimitive<bool, eDefault>(cx, args[1], "Argument 2", &arg1)) {
      return false;
    }
  } else {
    arg1 = false;
  }
  nsTArray<nsString> result;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(mozilla::dom::InspectorUtils::GetRegisteredCssHighlights(global, MOZ_KnownLive(NonNullHelper(arg0)), arg1, result))>, "Should be returning void here");
  mozilla::dom::InspectorUtils::GetRegisteredCssHighlights(global, MOZ_KnownLive(NonNullHelper(arg0)), arg1, result);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));

  uint32_t length = result.Length();
  JS::Rooted<JSObject*> returnArray(cx, JS::NewArrayObject(cx, length));
  if (!returnArray) {
    return false;
  }
  // Scope for 'tmp'
  {
    JS::Rooted<JS::Value> tmp(cx);
    for (uint32_t sequenceIdx0 = 0; sequenceIdx0 < length; ++sequenceIdx0) {
      // Control block to let us common up the JS_DefineElement calls when there
      // are different ways to succeed at wrapping the object.
      do {
        if (!xpc::NonVoidStringToJsval(cx, result[sequenceIdx0], &tmp)) {
          return false;
        }
        break;
      } while (false);
      if (!JS_DefineElement(cx, returnArray, sequenceIdx0, tmp,
                            JSPROP_ENUMERATE)) {
        return false;
      }
    }
  }
  args.rval().setObject(*returnArray);
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
getCSSRegisteredProperties(JSContext* cx_, unsigned argc, JS::Value* vp)
{
  BindingCallContext cx(cx_, "InspectorUtils.getCSSRegisteredProperties");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "InspectorUtils", "getCSSRegisteredProperties", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  JS::CallArgs args = JS::CallArgsFromVp(argc, vp);
  JS::Rooted<JSObject*> obj(cx, &args.callee());

  if (!args.requireAtLeast(cx, "InspectorUtils.getCSSRegisteredProperties", 1)) {
    return false;
  }
  GlobalObject global(cx, xpc::XrayAwareCalleeGlobal(obj));
  if (global.Failed()) {
    return false;
  }

  NonNull<mozilla::dom::Document> arg0;
  if (args[0].isObject()) {
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::Document, mozilla::dom::Document>(args[0], arg0, cx);
      if (NS_FAILED(rv)) {
        cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Argument 1", "Document");
        return false;
      }
    }
  } else {
    cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 1");
    return false;
  }
  nsTArray<InspectorCSSPropertyDefinition> result;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(mozilla::dom::InspectorUtils::GetCSSRegisteredProperties(global, MOZ_KnownLive(NonNullHelper(arg0)), result))>, "Should be returning void here");
  mozilla::dom::InspectorUtils::GetCSSRegisteredProperties(global, MOZ_KnownLive(NonNullHelper(arg0)), result);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));

  uint32_t length = result.Length();
  JS::Rooted<JSObject*> returnArray(cx, JS::NewArrayObject(cx, length));
  if (!returnArray) {
    return false;
  }
  // Scope for 'tmp'
  {
    JS::Rooted<JS::Value> tmp(cx);
    for (uint32_t sequenceIdx0 = 0; sequenceIdx0 < length; ++sequenceIdx0) {
      // Control block to let us common up the JS_DefineElement calls when there
      // are different ways to succeed at wrapping the object.
      do {
        if (!result[sequenceIdx0].ToObjectInternal(cx, &tmp)) {
          return false;
        }
        break;
      } while (false);
      if (!JS_DefineElement(cx, returnArray, sequenceIdx0, tmp,
                            JSPROP_ENUMERATE)) {
        return false;
      }
    }
  }
  args.rval().setObject(*returnArray);
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
getCSSRegisteredProperty(JSContext* cx_, unsigned argc, JS::Value* vp)
{
  BindingCallContext cx(cx_, "InspectorUtils.getCSSRegisteredProperty");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "InspectorUtils", "getCSSRegisteredProperty", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  JS::CallArgs args = JS::CallArgsFromVp(argc, vp);
  JS::Rooted<JSObject*> obj(cx, &args.callee());

  if (!args.requireAtLeast(cx, "InspectorUtils.getCSSRegisteredProperty", 2)) {
    return false;
  }
  GlobalObject global(cx, xpc::XrayAwareCalleeGlobal(obj));
  if (global.Failed()) {
    return false;
  }

  NonNull<mozilla::dom::Document> arg0;
  if (args[0].isObject()) {
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::Document, mozilla::dom::Document>(args[0], arg0, cx);
      if (NS_FAILED(rv)) {
        cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Argument 1", "Document");
        return false;
      }
    }
  } else {
    cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 1");
    return false;
  }
  binding_detail::FakeString<char> arg1;
  if (!ConvertJSValueToString(cx, args[1], eStringify, eStringify, arg1)) {
    return false;
  }
  Nullable<InspectorCSSPropertyDefinition> result;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(mozilla::dom::InspectorUtils::GetCSSRegisteredProperty(global, MOZ_KnownLive(NonNullHelper(arg0)), Constify(arg1), result))>, "Should be returning void here");
  mozilla::dom::InspectorUtils::GetCSSRegisteredProperty(global, MOZ_KnownLive(NonNullHelper(arg0)), Constify(arg1), result);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (result.IsNull()) {
    args.rval().setNull();
    return true;
  }
  if (!result.Value().ToObjectInternal(cx, args.rval())) {
    return false;
  }
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
valueMatchesSyntax(JSContext* cx_, unsigned argc, JS::Value* vp)
{
  BindingCallContext cx(cx_, "InspectorUtils.valueMatchesSyntax");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "InspectorUtils", "valueMatchesSyntax", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  JS::CallArgs args = JS::CallArgsFromVp(argc, vp);
  JS::Rooted<JSObject*> obj(cx, &args.callee());

  if (!args.requireAtLeast(cx, "InspectorUtils.valueMatchesSyntax", 3)) {
    return false;
  }
  GlobalObject global(cx, xpc::XrayAwareCalleeGlobal(obj));
  if (global.Failed()) {
    return false;
  }

  NonNull<mozilla::dom::Document> arg0;
  if (args[0].isObject()) {
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::Document, mozilla::dom::Document>(args[0], arg0, cx);
      if (NS_FAILED(rv)) {
        cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Argument 1", "Document");
        return false;
      }
    }
  } else {
    cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 1");
    return false;
  }
  binding_detail::FakeString<char> arg1;
  if (!ConvertJSValueToString(cx, args[1], eStringify, eStringify, arg1)) {
    return false;
  }
  binding_detail::FakeString<char> arg2;
  if (!ConvertJSValueToString(cx, args[2], eStringify, eStringify, arg2)) {
    return false;
  }
  bool result(mozilla::dom::InspectorUtils::ValueMatchesSyntax(global, MOZ_KnownLive(NonNullHelper(arg0)), Constify(arg1), Constify(arg2)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setBoolean(result);
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
getRuleBodyText(JSContext* cx, unsigned argc, JS::Value* vp)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "InspectorUtils", "getRuleBodyText", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  JS::CallArgs args = JS::CallArgsFromVp(argc, vp);
  JS::Rooted<JSObject*> obj(cx, &args.callee());

  if (!args.requireAtLeast(cx, "InspectorUtils.getRuleBodyText", 1)) {
    return false;
  }
  GlobalObject global(cx, xpc::XrayAwareCalleeGlobal(obj));
  if (global.Failed()) {
    return false;
  }

  binding_detail::FakeString<char> arg0;
  if (!ConvertJSValueToString(cx, args[0], eStringify, eStringify, arg0)) {
    return false;
  }
  nsAutoCString result;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(mozilla::dom::InspectorUtils::GetRuleBodyText(global, Constify(arg0), result))>, "Should be returning void here");
  mozilla::dom::InspectorUtils::GetRuleBodyText(global, Constify(arg0), result);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!UTF8StringToJsval(cx, result, args.rval())) {
    return false;
  }
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
replaceBlockRuleBodyTextInStylesheet(JSContext* cx, unsigned argc, JS::Value* vp)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "InspectorUtils", "replaceBlockRuleBodyTextInStylesheet", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  JS::CallArgs args = JS::CallArgsFromVp(argc, vp);
  JS::Rooted<JSObject*> obj(cx, &args.callee());

  if (!args.requireAtLeast(cx, "InspectorUtils.replaceBlockRuleBodyTextInStylesheet", 4)) {
    return false;
  }
  GlobalObject global(cx, xpc::XrayAwareCalleeGlobal(obj));
  if (global.Failed()) {
    return false;
  }

  binding_detail::FakeString<char> arg0;
  if (!ConvertJSValueToString(cx, args[0], eStringify, eStringify, arg0)) {
    return false;
  }
  uint32_t arg1;
  if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[1], "Argument 2", &arg1)) {
    return false;
  }
  uint32_t arg2;
  if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[2], "Argument 3", &arg2)) {
    return false;
  }
  binding_detail::FakeString<char> arg3;
  if (!ConvertJSValueToString(cx, args[3], eStringify, eStringify, arg3)) {
    return false;
  }
  nsAutoCString result;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(mozilla::dom::InspectorUtils::ReplaceBlockRuleBodyTextInStylesheet(global, Constify(arg0), arg1, arg2, Constify(arg3), result))>, "Should be returning void here");
  mozilla::dom::InspectorUtils::ReplaceBlockRuleBodyTextInStylesheet(global, Constify(arg0), arg1, arg2, Constify(arg3), result);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!UTF8StringToJsval(cx, result, args.rval())) {
    return false;
  }
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
setVerticalClipping(JSContext* cx_, unsigned argc, JS::Value* vp)
{
  BindingCallContext cx(cx_, "InspectorUtils.setVerticalClipping");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "InspectorUtils", "setVerticalClipping", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  JS::CallArgs args = JS::CallArgsFromVp(argc, vp);
  JS::Rooted<JSObject*> obj(cx, &args.callee());

  if (!args.requireAtLeast(cx, "InspectorUtils.setVerticalClipping", 2)) {
    return false;
  }
  GlobalObject global(cx, xpc::XrayAwareCalleeGlobal(obj));
  if (global.Failed()) {
    return false;
  }

  mozilla::dom::BrowsingContext* arg0;
  if (args[0].isObject()) {
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::BrowsingContext, mozilla::dom::BrowsingContext>(args[0], arg0, cx);
      if (NS_FAILED(rv)) {
        cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Argument 1", "BrowsingContext");
        return false;
      }
    }
  } else if (args[0].isNullOrUndefined()) {
    arg0 = nullptr;
  } else {
    cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 1");
    return false;
  }
  int32_t arg1;
  if (!ValueToPrimitive<int32_t, eDefault>(cx, args[1], "Argument 2", &arg1)) {
    return false;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(mozilla::dom::InspectorUtils::SetVerticalClipping(global, MOZ_KnownLive(Constify(arg0)), arg1))>, "Should be returning void here");
  mozilla::dom::InspectorUtils::SetVerticalClipping(global, MOZ_KnownLive(Constify(arg0)), arg1);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
setDynamicToolbarMaxHeight(JSContext* cx_, unsigned argc, JS::Value* vp)
{
  BindingCallContext cx(cx_, "InspectorUtils.setDynamicToolbarMaxHeight");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "InspectorUtils", "setDynamicToolbarMaxHeight", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  JS::CallArgs args = JS::CallArgsFromVp(argc, vp);
  JS::Rooted<JSObject*> obj(cx, &args.callee());

  if (!args.requireAtLeast(cx, "InspectorUtils.setDynamicToolbarMaxHeight", 2)) {
    return false;
  }
  GlobalObject global(cx, xpc::XrayAwareCalleeGlobal(obj));
  if (global.Failed()) {
    return false;
  }

  mozilla::dom::BrowsingContext* arg0;
  if (args[0].isObject()) {
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::BrowsingContext, mozilla::dom::BrowsingContext>(args[0], arg0, cx);
      if (NS_FAILED(rv)) {
        cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Argument 1", "BrowsingContext");
        return false;
      }
    }
  } else if (args[0].isNullOrUndefined()) {
    arg0 = nullptr;
  } else {
    cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 1");
    return false;
  }
  int32_t arg1;
  if (!ValueToPrimitive<int32_t, eDefault>(cx, args[1], "Argument 2", &arg1)) {
    return false;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(mozilla::dom::InspectorUtils::SetDynamicToolbarMaxHeight(global, MOZ_KnownLive(Constify(arg0)), arg1))>, "Should be returning void here");
  mozilla::dom::InspectorUtils::SetDynamicToolbarMaxHeight(global, MOZ_KnownLive(Constify(arg0)), arg1);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

MOZ_GLOBINIT static const JSFunctionSpec sStaticMethods_specs[] = {
  JS_FNSPEC("getAllStyleSheets", getAllStyleSheets, nullptr, 1, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("getMatchingCSSRules", getMatchingCSSRules, nullptr, 1, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("getRuleLine", getRuleLine, nullptr, 1, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("getRuleColumn", getRuleColumn, nullptr, 1, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("getRelativeRuleLine", getRelativeRuleLine, nullptr, 1, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("getRuleIndex", getRuleIndex, nullptr, 1, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("hasRulesModifiedByCSSOM", hasRulesModifiedByCSSOM, nullptr, 1, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("getStyleSheetRuleCountAndAtRules", getStyleSheetRuleCountAndAtRules, nullptr, 1, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("isInheritedProperty", isInheritedProperty, nullptr, 2, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("getCSSPropertyNames", getCSSPropertyNames, nullptr, 0, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("getCSSPropertyPrefs", getCSSPropertyPrefs, nullptr, 0, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("getCSSValuesForProperty", getCSSValuesForProperty, nullptr, 1, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("rgbToColorName", rgbToColorName, nullptr, 3, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("rgbToNearestColorName", rgbToNearestColorName, nullptr, 3, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("rgbToHsv", rgbToHsv, nullptr, 3, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("hsvToRgb", hsvToRgb, nullptr, 3, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("relativeLuminance", relativeLuminance, nullptr, 3, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("colorToRGBA", colorToRGBA, nullptr, 1, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("colorTo", colorTo, nullptr, 2, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("isValidCSSColor", isValidCSSColor, nullptr, 1, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("getSubpropertiesForCSSProperty", getSubpropertiesForCSSProperty, nullptr, 1, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("cssPropertyIsShorthand", cssPropertyIsShorthand, nullptr, 1, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("cssPropertySupportsType", cssPropertySupportsType, nullptr, 2, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("supports", supports, nullptr, 1, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("isIgnorableWhitespace", isIgnorableWhitespace, nullptr, 1, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("getParentForNode", getParentForNode, nullptr, 2, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("getChildrenForNode", getChildrenForNode, nullptr, 3, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("setContentState", setContentState, nullptr, 2, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("removeContentState", removeContentState, nullptr, 2, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("getContentState", getContentState, nullptr, 1, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("getUsedFontFaces", getUsedFontFaces, nullptr, 1, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("getCSSPseudoElementNames", getCSSPseudoElementNames, nullptr, 0, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("addPseudoClassLock", addPseudoClassLock, nullptr, 2, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("removePseudoClassLock", removePseudoClassLock, nullptr, 2, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("hasPseudoClassLock", hasPseudoClassLock, nullptr, 2, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("clearPseudoClassLocks", clearPseudoClassLocks, nullptr, 1, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("parseStyleSheet", parseStyleSheet, nullptr, 2, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("isCustomElementName", isCustomElementName, nullptr, 2, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("isElementThemed", isElementThemed, nullptr, 1, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("isUsedColorSchemeDark", isUsedColorSchemeDark, nullptr, 1, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("containingBlockOf", containingBlockOf, nullptr, 1, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("isBlockContainer", isBlockContainer, nullptr, 1, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("getBlockLineCounts", getBlockLineCounts, nullptr, 1, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("getOverflowingChildrenOfElement", getOverflowingChildrenOfElement, nullptr, 1, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("getRegisteredCssHighlights", getRegisteredCssHighlights, nullptr, 1, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("getCSSRegisteredProperties", getCSSRegisteredProperties, nullptr, 1, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("getCSSRegisteredProperty", getCSSRegisteredProperty, nullptr, 2, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("valueMatchesSyntax", valueMatchesSyntax, nullptr, 3, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("getRuleBodyText", getRuleBodyText, nullptr, 1, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("replaceBlockRuleBodyTextInStylesheet", replaceBlockRuleBodyTextInStylesheet, nullptr, 4, JSPROP_ENUMERATE, nullptr),
  JS_FS_END
};


static const Prefable<const JSFunctionSpec> sStaticMethods[] = {
  { nullptr, &sStaticMethods_specs[0] },
  { nullptr, nullptr }
};

static_assert(1 <= 1ull << NUM_BITS_PROPERTY_INFO_PREF_INDEX,
    "We have a prefable index that is >= (1 << NUM_BITS_PROPERTY_INFO_PREF_INDEX)");
static_assert(50 <= 1ull << NUM_BITS_PROPERTY_INFO_SPEC_INDEX,
    "We have a spec index that is >= (1 << NUM_BITS_PROPERTY_INFO_SPEC_INDEX)");

MOZ_GLOBINIT static const JSFunctionSpec sChromeStaticMethods_specs[] = {
  JS_FNSPEC("setVerticalClipping", setVerticalClipping, nullptr, 2, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("setDynamicToolbarMaxHeight", setDynamicToolbarMaxHeight, nullptr, 2, JSPROP_ENUMERATE, nullptr),
  JS_FS_END
};


static const Prefable<const JSFunctionSpec> sChromeStaticMethods[] = {
  { nullptr, &sChromeStaticMethods_specs[0] },
  { nullptr, nullptr }
};

static_assert(1 <= 1ull << NUM_BITS_PROPERTY_INFO_PREF_INDEX,
    "We have a prefable index that is >= (1 << NUM_BITS_PROPERTY_INFO_PREF_INDEX)");
static_assert(2 <= 1ull << NUM_BITS_PROPERTY_INFO_SPEC_INDEX,
    "We have a spec index that is >= (1 << NUM_BITS_PROPERTY_INFO_SPEC_INDEX)");


static uint16_t sNativeProperties_sortedPropertyIndices[50];
static PropertyInfo sNativeProperties_propertyInfos[50];

static const NativePropertiesN<1> sNativeProperties = {
  true,  0 /* sStaticMethods */,
  false, 0,
  false, 0,
  false, 0,
  false, 0,
  false, 0,
  false, 0,
  -1,
  50,
  sNativeProperties_sortedPropertyIndices,
  {
    { sStaticMethods, &sNativeProperties_propertyInfos[0] }
  }
};
static_assert(50 < 1ull << (CHAR_BIT * sizeof(sNativeProperties.propertyInfoCount)),
    "We have a property info count that is oversized");

static uint16_t sChromeOnlyNativeProperties_sortedPropertyIndices[2];
static PropertyInfo sChromeOnlyNativeProperties_propertyInfos[2];

static const NativePropertiesN<1> sChromeOnlyNativeProperties = {
  true,  0 /* sChromeStaticMethods */,
  false, 0,
  false, 0,
  false, 0,
  false, 0,
  false, 0,
  false, 0,
  -1,
  2,
  sChromeOnlyNativeProperties_sortedPropertyIndices,
  {
    { sChromeStaticMethods, &sChromeOnlyNativeProperties_propertyInfos[0] }
  }
};
static_assert(2 < 1ull << (CHAR_BIT * sizeof(sChromeOnlyNativeProperties.propertyInfoCount)),
    "We have a property info count that is oversized");

bool sNativePropertiesInited = false;
const NativePropertyHooks sNativePropertyHooks = {
  nullptr,
  { sNativeProperties.Upcast(), sChromeOnlyNativeProperties.Upcast(), &sNativePropertiesInited },
  prototypes::id::_ID_Count,
  constructors::id::InspectorUtils,
  &DefaultXrayExpandoObjectClass
};

static const DOMIfaceAndProtoJSClass sNamespaceObjectClass = {
  {
    "InspectorUtils",
    JSCLASS_IS_DOMIFACEANDPROTOJSCLASS,
    JS_NULL_CLASS_OPS,
    JS_NULL_CLASS_SPEC,
    JS_NULL_CLASS_EXT,
    JS_NULL_OBJECT_OPS
  },
  eNamespace,
  prototypes::id::_ID_Count,
  0,
  &sNativePropertyHooks,
  // This isn't strictly following the spec (see
  // https://console.spec.whatwg.org/#ref-for-dfn-namespace-object),
  // but should be ok for Xrays.
  JS::GetRealmObjectPrototype
};

bool
ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj)
{
  return nsContentUtils::IsCallerChromeOrFuzzingEnabled(aCx, aObj);
}

void
CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, DefineInterfaceProperty aDefineOnGlobal)
{
  JS::Rooted<JSObject*> constructorProto(aCx, JS::GetRealmObjectPrototype(aCx));
  if (!constructorProto) {
    return;
  }

  JS::Heap<JSObject*>* interfaceCache = &aProtoAndIfaceCache.EntrySlotOrCreate(constructors::id::InspectorUtils);
  dom::CreateNamespaceObject(aCx, aGlobal, constructorProto,
                             sNamespaceObjectClass,
                             interfaceCache,
                             sNativeProperties.Upcast(),
                             sChromeOnlyNativeProperties.Upcast(),
                             "InspectorUtils",
                             ShouldExpose<InspectorUtils_Binding::ConstructorEnabled>(aCx, aGlobal, aDefineOnGlobal));
}

JS::Handle<JSObject*>
GetConstructorObjectHandle(JSContext* aCx)
{
  /* Get the interface object for this class.  This will create the object as
     needed. */

  return GetPerInterfaceObjectHandle(aCx, constructors::id::InspectorUtils,
                                     &CreateInterfaceObjects,
                                     DefineInterfaceProperty::CheckExposure);
}

} // namespace InspectorUtils_Binding



} // namespace dom


} // namespace mozilla
