/* SPDX-License-Identifier: (LGPL-2.1 OR BSD-2-Clause) */

/* THIS FILE IS AUTOGENERATED BY BPFTOOL! */
#ifndef __CPUFREQ_BPF_SKEL_H__
#define __CPUFREQ_BPF_SKEL_H__

#include <errno.h>
#include <stdlib.h>
#include <bpf/libbpf.h>

struct cpufreq_bpf {
	struct bpf_object_skeleton *skeleton;
	struct bpf_object *obj;
	struct {
		struct bpf_map *cgroup_map;
		struct bpf_map *hists;
		struct bpf_map *bss;
	} maps;
	struct {
		struct bpf_program *cpu_frequency;
		struct bpf_program *do_sample;
	} progs;
	struct {
		struct bpf_link *cpu_frequency;
		struct bpf_link *do_sample;
	} links;
	struct cpufreq_bpf__bss {
		__u32 freqs_mhz[128];
		struct hist syswide;
		bool filter_cg;
	} *bss;

#ifdef __cplusplus
	static inline struct cpufreq_bpf *open(const struct bpf_object_open_opts *opts = nullptr);
	static inline struct cpufreq_bpf *open_and_load();
	static inline int load(struct cpufreq_bpf *skel);
	static inline int attach(struct cpufreq_bpf *skel);
	static inline void detach(struct cpufreq_bpf *skel);
	static inline void destroy(struct cpufreq_bpf *skel);
	static inline const void *elf_bytes(size_t *sz);
#endif /* __cplusplus */
};

static void
cpufreq_bpf__destroy(struct cpufreq_bpf *obj)
{
	if (!obj)
		return;
	if (obj->skeleton)
		bpf_object__destroy_skeleton(obj->skeleton);
	free(obj);
}

static inline int
cpufreq_bpf__create_skeleton(struct cpufreq_bpf *obj);

static inline struct cpufreq_bpf *
cpufreq_bpf__open_opts(const struct bpf_object_open_opts *opts)
{
	struct cpufreq_bpf *obj;
	int err;

	obj = (struct cpufreq_bpf *)calloc(1, sizeof(*obj));
	if (!obj) {
		errno = ENOMEM;
		return NULL;
	}

	err = cpufreq_bpf__create_skeleton(obj);
	if (err)
		goto err_out;

	err = bpf_object__open_skeleton(obj->skeleton, opts);
	if (err)
		goto err_out;

	return obj;
err_out:
	cpufreq_bpf__destroy(obj);
	errno = -err;
	return NULL;
}

static inline struct cpufreq_bpf *
cpufreq_bpf__open(void)
{
	return cpufreq_bpf__open_opts(NULL);
}

static inline int
cpufreq_bpf__load(struct cpufreq_bpf *obj)
{
	return bpf_object__load_skeleton(obj->skeleton);
}

static inline struct cpufreq_bpf *
cpufreq_bpf__open_and_load(void)
{
	struct cpufreq_bpf *obj;
	int err;

	obj = cpufreq_bpf__open();
	if (!obj)
		return NULL;
	err = cpufreq_bpf__load(obj);
	if (err) {
		cpufreq_bpf__destroy(obj);
		errno = -err;
		return NULL;
	}
	return obj;
}

static inline int
cpufreq_bpf__attach(struct cpufreq_bpf *obj)
{
	return bpf_object__attach_skeleton(obj->skeleton);
}

static inline void
cpufreq_bpf__detach(struct cpufreq_bpf *obj)
{
	bpf_object__detach_skeleton(obj->skeleton);
}

static inline const void *cpufreq_bpf__elf_bytes(size_t *sz);

static inline int
cpufreq_bpf__create_skeleton(struct cpufreq_bpf *obj)
{
	struct bpf_object_skeleton *s;
	int err;

	s = (struct bpf_object_skeleton *)calloc(1, sizeof(*s));
	if (!s)	{
		err = -ENOMEM;
		goto err;
	}

	s->sz = sizeof(*s);
	s->name = "cpufreq_bpf";
	s->obj = &obj->obj;

	/* maps */
	s->map_cnt = 3;
	s->map_skel_sz = sizeof(*s->maps);
	s->maps = (struct bpf_map_skeleton *)calloc(s->map_cnt, s->map_skel_sz);
	if (!s->maps) {
		err = -ENOMEM;
		goto err;
	}

	s->maps[0].name = "cgroup_map";
	s->maps[0].map = &obj->maps.cgroup_map;

	s->maps[1].name = "hists";
	s->maps[1].map = &obj->maps.hists;

	s->maps[2].name = "cpufreq_.bss";
	s->maps[2].map = &obj->maps.bss;
	s->maps[2].mmaped = (void **)&obj->bss;

	/* programs */
	s->prog_cnt = 2;
	s->prog_skel_sz = sizeof(*s->progs);
	s->progs = (struct bpf_prog_skeleton *)calloc(s->prog_cnt, s->prog_skel_sz);
	if (!s->progs) {
		err = -ENOMEM;
		goto err;
	}

	s->progs[0].name = "cpu_frequency";
	s->progs[0].prog = &obj->progs.cpu_frequency;
	s->progs[0].link = &obj->links.cpu_frequency;

	s->progs[1].name = "do_sample";
	s->progs[1].prog = &obj->progs.do_sample;
	s->progs[1].link = &obj->links.do_sample;

	s->data = (void *)cpufreq_bpf__elf_bytes(&s->data_sz);

	obj->skeleton = s;
	return 0;
err:
	bpf_object__destroy_skeleton(s);
	return err;
}

static inline const void *cpufreq_bpf__elf_bytes(size_t *sz)
{
	*sz = 7048;
	return (const void *)"\
\x7f\x45\x4c\x46\x02\x01\x01\0\0\0\0\0\0\0\0\0\x01\0\xf7\0\x01\0\0\0\0\0\0\0\0\
\0\0\0\0\0\0\0\0\0\0\0\x88\x17\0\0\0\0\0\0\0\0\0\0\x40\0\0\0\0\0\x40\0\x10\0\
\x01\0\x79\x17\x08\0\0\0\0\0\x79\x16\0\0\0\0\0\0\x18\x01\0\0\0\0\0\0\0\0\0\0\0\
\0\0\0\x71\x11\0\0\0\0\0\0\x56\x01\x07\0\x01\0\0\0\x18\x01\0\0\0\0\0\0\0\0\0\0\
\0\0\0\0\xb4\x02\0\0\0\0\0\0\x85\0\0\0\x25\0\0\0\x26\x07\x10\0\x7f\0\0\0\x15\0\
\x0f\0\0\0\0\0\x05\0\x01\0\0\0\0\0\x26\x07\x0d\0\x7f\0\0\0\xbc\x71\0\0\0\0\0\0\
\xb5\x01\x01\0\x7f\0\0\0\xb7\x01\0\0\x7f\0\0\0\x67\x01\0\0\x20\0\0\0\x77\x01\0\
\0\x20\0\0\0\x67\x01\0\0\x02\0\0\0\x18\x02\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x0f\x12\
\0\0\0\0\0\0\xbc\x61\0\0\0\0\0\0\x27\x01\0\0\xd3\x4d\x62\x10\x77\x01\0\0\x26\0\
\0\0\x63\x12\0\0\0\0\0\0\xb4\0\0\0\0\0\0\0\x95\0\0\0\0\0\0\0\x85\0\0\0\x0e\0\0\
\0\xbf\x06\0\0\0\0\0\0\x85\0\0\0\x08\0\0\0\xbc\x07\0\0\0\0\0\0\x18\x01\0\0\0\0\
\0\0\0\0\0\0\0\0\0\0\x71\x11\0\0\0\0\0\0\x56\x01\x07\0\x01\0\0\0\x18\x01\0\0\0\
\0\0\0\0\0\0\0\0\0\0\0\xb4\x02\0\0\0\0\0\0\x85\0\0\0\x25\0\0\0\x15\0\x36\0\0\0\
\0\0\x26\x07\x35\0\x7f\0\0\0\x05\0\x01\0\0\0\0\0\x26\x07\x33\0\x7f\0\0\0\xb5\
\x07\x01\0\x7f\0\0\0\xb7\x07\0\0\x7f\0\0\0\x67\x07\0\0\x02\0\0\0\x18\x01\0\0\0\
\0\0\0\0\0\0\0\0\0\0\0\x0f\x71\0\0\0\0\0\0\x61\x11\0\0\0\0\0\0\x16\x01\x2b\0\0\
\0\0\0\x27\x01\0\0\x1f\x85\xeb\x51\x77\x01\0\0\x26\0\0\0\xa6\x01\x01\0\x19\0\0\
\0\xb4\x01\0\0\x19\0\0\0\xbc\x17\0\0\0\0\0\0\x18\x01\0\0\0\0\0\0\0\0\0\0\0\0\0\
\0\xbf\x72\0\0\0\0\0\0\x67\x02\0\0\x02\0\0\0\x0f\x21\0\0\0\0\0\0\xb4\x02\0\0\
\x01\0\0\0\xc3\x21\0\0\x01\0\0\0\x16\x06\x1e\0\0\0\0\0\xbf\xa6\0\0\0\0\0\0\x07\
\x06\0\0\xf0\xff\xff\xff\xbf\x61\0\0\0\0\0\0\xb4\x02\0\0\x10\0\0\0\x85\0\0\0\
\x10\0\0\0\x18\x01\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xbf\x62\0\0\0\0\0\0\x85\0\0\0\
\x01\0\0\0\x55\0\x10\0\0\0\0\0\xbf\xa2\0\0\0\0\0\0\x07\x02\0\0\xf0\xff\xff\xff\
\x18\x01\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x18\x03\0\0\x6c\x02\0\0\0\0\0\0\0\0\0\0\
\xb7\x04\0\0\x01\0\0\0\x85\0\0\0\x02\0\0\0\x16\0\x01\0\0\0\0\0\x56\0\x0a\0\xef\
\xff\xff\xff\xbf\xa2\0\0\0\0\0\0\x07\x02\0\0\xf0\xff\xff\xff\x18\x01\0\0\0\0\0\
\0\0\0\0\0\0\0\0\0\x85\0\0\0\x01\0\0\0\x15\0\x04\0\0\0\0\0\x67\x07\0\0\x02\0\0\
\0\x0f\x70\0\0\0\0\0\0\xb4\x01\0\0\x01\0\0\0\xc3\x10\0\0\x01\0\0\0\xb4\0\0\0\0\
\0\0\0\x95\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x47\
\x50\x4c\0\x9f\xeb\x01\0\x18\0\0\0\0\0\0\0\x04\x06\0\0\x04\x06\0\0\xbe\x05\0\0\
\0\0\0\0\0\0\0\x02\x03\0\0\0\x01\0\0\0\0\0\0\x01\x04\0\0\0\x20\0\0\x01\0\0\0\0\
\0\0\0\x03\0\0\0\0\x02\0\0\0\x04\0\0\0\x08\0\0\0\x05\0\0\0\0\0\0\x01\x04\0\0\0\
\x20\0\0\0\0\0\0\0\0\0\0\x02\x06\0\0\0\x19\0\0\0\0\0\0\x08\x07\0\0\0\x1d\0\0\0\
\0\0\0\x08\x08\0\0\0\x23\0\0\0\0\0\0\x01\x04\0\0\0\x20\0\0\0\0\0\0\0\0\0\0\x02\
\x0a\0\0\0\0\0\0\0\0\0\0\x03\0\0\0\0\x02\0\0\0\x04\0\0\0\x01\0\0\0\0\0\0\0\x04\
\0\0\x04\x20\0\0\0\x30\0\0\0\x01\0\0\0\0\0\0\0\x35\0\0\0\x05\0\0\0\x40\0\0\0\
\x39\0\0\0\x05\0\0\0\x80\0\0\0\x3f\0\0\0\x09\0\0\0\xc0\0\0\0\x4b\0\0\0\0\0\0\
\x0e\x0b\0\0\0\x01\0\0\0\0\0\0\0\0\0\0\x02\x0e\0\0\0\0\0\0\0\0\0\0\x03\0\0\0\0\
\x02\0\0\0\x04\0\0\0\0\x04\0\0\0\0\0\0\0\0\0\x02\x10\0\0\0\x56\0\0\0\x01\0\0\
\x04\x10\0\0\0\x5b\0\0\0\x12\0\0\0\0\0\0\0\x60\0\0\0\0\0\0\x01\x01\0\0\0\x08\0\
\0\x01\0\0\0\0\0\0\0\x03\0\0\0\0\x11\0\0\0\x04\0\0\0\x10\0\0\0\0\0\0\0\0\0\0\
\x02\x14\0\0\0\x65\0\0\0\x01\0\0\x04\x68\0\0\0\x6a\0\0\0\x15\0\0\0\0\0\0\0\0\0\
\0\0\0\0\0\x03\0\0\0\0\x07\0\0\0\x04\0\0\0\x1a\0\0\0\0\0\0\0\x04\0\0\x04\x20\0\
\0\0\x30\0\0\0\x09\0\0\0\0\0\0\0\x3f\0\0\0\x0d\0\0\0\x40\0\0\0\x35\0\0\0\x0f\0\
\0\0\x80\0\0\0\x39\0\0\0\x13\0\0\0\xc0\0\0\0\x70\0\0\0\0\0\0\x0e\x16\0\0\0\x01\
\0\0\0\0\0\0\0\0\0\0\x02\x19\0\0\0\x76\0\0\0\0\0\0\x01\x08\0\0\0\x40\0\0\0\0\0\
\0\0\x01\0\0\x0d\x02\0\0\0\x89\0\0\0\x18\0\0\0\x8d\0\0\0\x01\0\0\x0c\x1a\0\0\0\
\0\0\0\0\0\0\0\x02\x1d\0\0\0\xc8\x01\0\0\x03\0\0\x04\xb8\0\0\0\xdc\x01\0\0\x1e\
\0\0\0\0\0\0\0\xe1\x01\0\0\x26\0\0\0\x40\x05\0\0\xef\x01\0\0\x26\0\0\0\x80\x05\
\0\0\xf4\x01\0\0\0\0\0\x08\x1f\0\0\0\x07\x02\0\0\x15\0\0\x04\xa8\0\0\0\x0f\x02\
\0\0\x20\0\0\0\0\0\0\0\x13\x02\0\0\x20\0\0\0\x40\0\0\0\x17\x02\0\0\x20\0\0\0\
\x80\0\0\0\x1b\x02\0\0\x20\0\0\0\xc0\0\0\0\x1f\x02\0\0\x20\0\0\0\0\x01\0\0\x22\
\x02\0\0\x20\0\0\0\x40\x01\0\0\x25\x02\0\0\x20\0\0\0\x80\x01\0\0\x29\x02\0\0\
\x20\0\0\0\xc0\x01\0\0\x2d\x02\0\0\x20\0\0\0\0\x02\0\0\x30\x02\0\0\x20\0\0\0\
\x40\x02\0\0\x33\x02\0\0\x20\0\0\0\x80\x02\0\0\x36\x02\0\0\x20\0\0\0\xc0\x02\0\
\0\x39\x02\0\0\x20\0\0\0\0\x03\0\0\x3c\x02\0\0\x20\0\0\0\x40\x03\0\0\x3f\x02\0\
\0\x20\0\0\0\x80\x03\0\0\x42\x02\0\0\x20\0\0\0\xc0\x03\0\0\x4a\x02\0\0\x20\0\0\
\0\0\x04\0\0\0\0\0\0\x21\0\0\0\x40\x04\0\0\x4d\x02\0\0\x20\0\0\0\x80\x04\0\0\
\x53\x02\0\0\x20\0\0\0\xc0\x04\0\0\0\0\0\0\x28\0\0\0\0\x05\0\0\x56\x02\0\0\0\0\
\0\x01\x08\0\0\0\x40\0\0\0\0\0\0\0\x03\0\0\x05\x08\0\0\0\x64\x02\0\0\x22\0\0\0\
\0\0\0\0\x67\x02\0\0\x25\0\0\0\0\0\0\0\x6b\x02\0\0\x27\0\0\0\0\0\0\0\x73\x02\0\
\0\0\0\0\x08\x23\0\0\0\x77\x02\0\0\0\0\0\x08\x24\0\0\0\x7d\x02\0\0\0\0\0\x01\
\x02\0\0\0\x10\0\0\0\x8c\x02\0\0\0\0\0\x08\x26\0\0\0\x90\x02\0\0\0\0\0\x08\x19\
\0\0\0\x6b\x02\0\0\x03\0\0\x84\x08\0\0\0\x64\x02\0\0\x25\0\0\0\0\0\0\x10\x96\
\x02\0\0\x25\0\0\0\x10\0\0\x02\x99\x02\0\0\x25\0\0\0\x12\0\0\x01\0\0\0\0\x03\0\
\0\x05\x08\0\0\0\x9d\x02\0\0\x22\0\0\0\0\0\0\0\xa0\x02\0\0\x25\0\0\0\0\0\0\0\
\xa4\x02\0\0\x29\0\0\0\0\0\0\0\xa4\x02\0\0\x0a\0\0\x84\x08\0\0\0\x9d\x02\0\0\
\x25\0\0\0\0\0\0\x10\xac\x02\0\0\x25\0\0\0\x10\0\0\x01\xb0\x02\0\0\x25\0\0\0\
\x11\0\0\x01\xb8\x02\0\0\x25\0\0\0\x12\0\0\x01\xbc\x02\0\0\x25\0\0\0\x20\0\0\
\x08\x30\0\0\0\x25\0\0\0\x30\0\0\x04\xc3\x02\0\0\x25\0\0\0\x38\0\0\x01\xcb\x02\
\0\0\x25\0\0\0\x39\0\0\x01\xce\x02\0\0\x25\0\0\0\x3a\0\0\x01\xd5\x02\0\0\x25\0\
\0\0\x3c\0\0\x04\0\0\0\0\x01\0\0\x0d\x02\0\0\0\x89\0\0\0\x1c\0\0\0\xdd\x02\0\0\
\x01\0\0\x0c\x2a\0\0\0\0\0\0\0\0\0\0\x03\0\0\0\0\x07\0\0\0\x04\0\0\0\x80\0\0\0\
\x77\x05\0\0\0\0\0\x0e\x2c\0\0\0\x01\0\0\0\x81\x05\0\0\0\0\0\x0e\x14\0\0\0\x01\
\0\0\0\x89\x05\0\0\0\0\0\x08\x30\0\0\0\x8e\x05\0\0\0\0\0\x01\x01\0\0\0\x08\0\0\
\x04\x94\x05\0\0\0\0\0\x0e\x2f\0\0\0\x01\0\0\0\x9e\x05\0\0\0\0\0\x0e\x14\0\0\0\
\0\0\0\0\0\0\0\0\0\0\0\x03\0\0\0\0\x11\0\0\0\x04\0\0\0\x04\0\0\0\xa3\x05\0\0\0\
\0\0\x0e\x33\0\0\0\x01\0\0\0\xab\x05\0\0\x04\0\0\x0f\0\0\0\0\x2d\0\0\0\0\0\0\0\
\0\x02\0\0\x2e\0\0\0\0\0\0\0\x68\0\0\0\x31\0\0\0\0\0\0\0\x01\0\0\0\x32\0\0\0\
\x6c\x02\0\0\x68\0\0\0\xb0\x05\0\0\x02\0\0\x0f\0\0\0\0\x0c\0\0\0\0\0\0\0\x20\0\
\0\0\x17\0\0\0\0\0\0\0\x20\0\0\0\xb6\x05\0\0\x01\0\0\x0f\0\0\0\0\x34\0\0\0\0\0\
\0\0\x04\0\0\0\0\x69\x6e\x74\0\x5f\x5f\x41\x52\x52\x41\x59\x5f\x53\x49\x5a\x45\
\x5f\x54\x59\x50\x45\x5f\x5f\0\x75\x33\x32\0\x5f\x5f\x75\x33\x32\0\x75\x6e\x73\
\x69\x67\x6e\x65\x64\x20\x69\x6e\x74\0\x74\x79\x70\x65\0\x6b\x65\x79\0\x76\x61\
\x6c\x75\x65\0\x6d\x61\x78\x5f\x65\x6e\x74\x72\x69\x65\x73\0\x63\x67\x72\x6f\
\x75\x70\x5f\x6d\x61\x70\0\x68\x6b\x65\x79\0\x63\x6f\x6d\x6d\0\x63\x68\x61\x72\
\0\x68\x69\x73\x74\0\x73\x6c\x6f\x74\x73\0\x68\x69\x73\x74\x73\0\x75\x6e\x73\
\x69\x67\x6e\x65\x64\x20\x6c\x6f\x6e\x67\x20\x6c\x6f\x6e\x67\0\x63\x74\x78\0\
\x63\x70\x75\x5f\x66\x72\x65\x71\x75\x65\x6e\x63\x79\0\x74\x70\x5f\x62\x74\x66\
\x2f\x63\x70\x75\x5f\x66\x72\x65\x71\x75\x65\x6e\x63\x79\0\x2f\x62\x75\x69\x6c\
\x64\x2f\x62\x63\x63\x2f\x73\x72\x63\x2f\x62\x63\x63\x2f\x6c\x69\x62\x62\x70\
\x66\x2d\x74\x6f\x6f\x6c\x73\x2f\x63\x70\x75\x66\x72\x65\x71\x2e\x62\x70\x66\
\x2e\x63\0\x69\x6e\x74\x20\x42\x50\x46\x5f\x50\x52\x4f\x47\x28\x63\x70\x75\x5f\
\x66\x72\x65\x71\x75\x65\x6e\x63\x79\x2c\x20\x75\x6e\x73\x69\x67\x6e\x65\x64\
\x20\x69\x6e\x74\x20\x73\x74\x61\x74\x65\x2c\x20\x75\x6e\x73\x69\x67\x6e\x65\
\x64\x20\x69\x6e\x74\x20\x63\x70\x75\x5f\x69\x64\x29\0\x09\x69\x66\x20\x28\x66\
\x69\x6c\x74\x65\x72\x5f\x63\x67\x20\x26\x26\x20\x21\x62\x70\x66\x5f\x63\x75\
\x72\x72\x65\x6e\x74\x5f\x74\x61\x73\x6b\x5f\x75\x6e\x64\x65\x72\x5f\x63\x67\
\x72\x6f\x75\x70\x28\x26\x63\x67\x72\x6f\x75\x70\x5f\x6d\x61\x70\x2c\x20\x30\
\x29\x29\0\x09\x69\x66\x20\x28\x63\x70\x75\x5f\x69\x64\x20\x3e\x3d\x20\x4d\x41\
\x58\x5f\x43\x50\x55\x5f\x4e\x52\x29\0\x09\x63\x6c\x61\x6d\x70\x5f\x75\x6d\x61\
\x78\x28\x63\x70\x75\x5f\x69\x64\x2c\x20\x4d\x41\x58\x5f\x43\x50\x55\x5f\x4e\
\x52\x20\x2d\x20\x31\x29\x3b\0\x09\x66\x72\x65\x71\x73\x5f\x6d\x68\x7a\x5b\x63\
\x70\x75\x5f\x69\x64\x5d\x20\x3d\x20\x73\x74\x61\x74\x65\x20\x2f\x20\x31\x30\
\x30\x30\x3b\0\x62\x70\x66\x5f\x70\x65\x72\x66\x5f\x65\x76\x65\x6e\x74\x5f\x64\
\x61\x74\x61\0\x72\x65\x67\x73\0\x73\x61\x6d\x70\x6c\x65\x5f\x70\x65\x72\x69\
\x6f\x64\0\x61\x64\x64\x72\0\x62\x70\x66\x5f\x75\x73\x65\x72\x5f\x70\x74\x5f\
\x72\x65\x67\x73\x5f\x74\0\x70\x74\x5f\x72\x65\x67\x73\0\x72\x31\x35\0\x72\x31\
\x34\0\x72\x31\x33\0\x72\x31\x32\0\x62\x70\0\x62\x78\0\x72\x31\x31\0\x72\x31\
\x30\0\x72\x39\0\x72\x38\0\x61\x78\0\x63\x78\0\x64\x78\0\x73\x69\0\x64\x69\0\
\x6f\x72\x69\x67\x5f\x61\x78\0\x69\x70\0\x66\x6c\x61\x67\x73\0\x73\x70\0\x75\
\x6e\x73\x69\x67\x6e\x65\x64\x20\x6c\x6f\x6e\x67\0\x63\x73\0\x63\x73\x78\0\x66\
\x72\x65\x64\x5f\x63\x73\0\x75\x31\x36\0\x5f\x5f\x75\x31\x36\0\x75\x6e\x73\x69\
\x67\x6e\x65\x64\x20\x73\x68\x6f\x72\x74\0\x75\x36\x34\0\x5f\x5f\x75\x36\x34\0\
\x73\x6c\0\x77\x66\x65\0\x73\x73\0\x73\x73\x78\0\x66\x72\x65\x64\x5f\x73\x73\0\
\x73\x74\x69\0\x73\x77\x65\x76\x65\x6e\x74\0\x6e\x6d\x69\0\x76\x65\x63\x74\x6f\
\x72\0\x65\x6e\x63\x6c\x61\x76\x65\0\x6c\x6d\0\x6e\x65\x73\x74\x65\x64\0\x69\
\x6e\x73\x6e\x6c\x65\x6e\0\x64\x6f\x5f\x73\x61\x6d\x70\x6c\x65\0\x70\x65\x72\
\x66\x5f\x65\x76\x65\x6e\x74\0\x09\x75\x33\x32\x20\x66\x72\x65\x71\x5f\x6d\x68\
\x7a\x2c\x20\x70\x69\x64\x20\x3d\x20\x62\x70\x66\x5f\x67\x65\x74\x5f\x63\x75\
\x72\x72\x65\x6e\x74\x5f\x70\x69\x64\x5f\x74\x67\x69\x64\x28\x29\x3b\0\x09\x75\
\x36\x34\x20\x73\x6c\x6f\x74\x2c\x20\x63\x70\x75\x20\x3d\x20\x62\x70\x66\x5f\
\x67\x65\x74\x5f\x73\x6d\x70\x5f\x70\x72\x6f\x63\x65\x73\x73\x6f\x72\x5f\x69\
\x64\x28\x29\x3b\0\x09\x69\x66\x20\x28\x63\x70\x75\x20\x3e\x3d\x20\x4d\x41\x58\
\x5f\x43\x50\x55\x5f\x4e\x52\x29\0\x09\x63\x6c\x61\x6d\x70\x5f\x75\x6d\x61\x78\
\x28\x63\x70\x75\x2c\x20\x4d\x41\x58\x5f\x43\x50\x55\x5f\x4e\x52\x20\x2d\x20\
\x31\x29\x3b\0\x09\x66\x72\x65\x71\x5f\x6d\x68\x7a\x20\x3d\x20\x66\x72\x65\x71\
\x73\x5f\x6d\x68\x7a\x5b\x63\x70\x75\x5d\x3b\0\x09\x69\x66\x20\x28\x21\x66\x72\
\x65\x71\x5f\x6d\x68\x7a\x29\0\x09\x73\x6c\x6f\x74\x20\x3d\x20\x66\x72\x65\x71\
\x5f\x6d\x68\x7a\x20\x2f\x20\x48\x49\x53\x54\x5f\x53\x54\x45\x50\x5f\x53\x49\
\x5a\x45\x3b\0\x09\x69\x66\x20\x28\x73\x6c\x6f\x74\x20\x3e\x3d\x20\x4d\x41\x58\
\x5f\x53\x4c\x4f\x54\x53\x29\0\x09\x5f\x5f\x73\x79\x6e\x63\x5f\x66\x65\x74\x63\
\x68\x5f\x61\x6e\x64\x5f\x61\x64\x64\x28\x26\x73\x79\x73\x77\x69\x64\x65\x2e\
\x73\x6c\x6f\x74\x73\x5b\x73\x6c\x6f\x74\x5d\x2c\x20\x31\x29\x3b\0\x09\x69\x66\
\x20\x28\x21\x70\x69\x64\x29\0\x09\x62\x70\x66\x5f\x67\x65\x74\x5f\x63\x75\x72\
\x72\x65\x6e\x74\x5f\x63\x6f\x6d\x6d\x28\x26\x68\x6b\x65\x79\x2e\x63\x6f\x6d\
\x6d\x2c\x20\x73\x69\x7a\x65\x6f\x66\x28\x68\x6b\x65\x79\x2e\x63\x6f\x6d\x6d\
\x29\x29\x3b\0\x2f\x62\x75\x69\x6c\x64\x2f\x62\x63\x63\x2f\x73\x72\x63\x2f\x62\
\x63\x63\x2f\x6c\x69\x62\x62\x70\x66\x2d\x74\x6f\x6f\x6c\x73\x2f\x2e\x2f\x6d\
\x61\x70\x73\x2e\x62\x70\x66\x2e\x68\0\x09\x76\x61\x6c\x20\x3d\x20\x62\x70\x66\
\x5f\x6d\x61\x70\x5f\x6c\x6f\x6f\x6b\x75\x70\x5f\x65\x6c\x65\x6d\x28\x6d\x61\
\x70\x2c\x20\x6b\x65\x79\x29\x3b\0\x09\x69\x66\x20\x28\x76\x61\x6c\x29\0\x09\
\x65\x72\x72\x20\x3d\x20\x62\x70\x66\x5f\x6d\x61\x70\x5f\x75\x70\x64\x61\x74\
\x65\x5f\x65\x6c\x65\x6d\x28\x6d\x61\x70\x2c\x20\x6b\x65\x79\x2c\x20\x69\x6e\
\x69\x74\x2c\x20\x42\x50\x46\x5f\x4e\x4f\x45\x58\x49\x53\x54\x29\x3b\0\x09\x69\
\x66\x20\x28\x65\x72\x72\x20\x26\x26\x20\x65\x72\x72\x20\x21\x3d\x20\x2d\x45\
\x45\x58\x49\x53\x54\x29\0\x09\x72\x65\x74\x75\x72\x6e\x20\x62\x70\x66\x5f\x6d\
\x61\x70\x5f\x6c\x6f\x6f\x6b\x75\x70\x5f\x65\x6c\x65\x6d\x28\x6d\x61\x70\x2c\
\x20\x6b\x65\x79\x29\x3b\0\x09\x69\x66\x20\x28\x21\x68\x69\x73\x74\x29\0\x09\
\x5f\x5f\x73\x79\x6e\x63\x5f\x66\x65\x74\x63\x68\x5f\x61\x6e\x64\x5f\x61\x64\
\x64\x28\x26\x68\x69\x73\x74\x2d\x3e\x73\x6c\x6f\x74\x73\x5b\x73\x6c\x6f\x74\
\x5d\x2c\x20\x31\x29\x3b\0\x7d\0\x66\x72\x65\x71\x73\x5f\x6d\x68\x7a\0\x73\x79\
\x73\x77\x69\x64\x65\0\x62\x6f\x6f\x6c\0\x5f\x42\x6f\x6f\x6c\0\x66\x69\x6c\x74\
\x65\x72\x5f\x63\x67\0\x7a\x65\x72\x6f\0\x4c\x49\x43\x45\x4e\x53\x45\0\x2e\x62\
\x73\x73\0\x2e\x6d\x61\x70\x73\0\x6c\x69\x63\x65\x6e\x73\x65\0\0\0\x9f\xeb\x01\
\0\x20\0\0\0\0\0\0\0\x24\0\0\0\x24\0\0\0\x54\x02\0\0\x78\x02\0\0\0\0\0\0\x08\0\
\0\0\x9b\0\0\0\x01\0\0\0\0\0\0\0\x1b\0\0\0\xe7\x02\0\0\x01\0\0\0\0\0\0\0\x2b\0\
\0\0\x10\0\0\0\x9b\0\0\0\x0b\0\0\0\0\0\0\0\xb0\0\0\0\xde\0\0\0\x05\x94\0\0\x10\
\0\0\0\xb0\0\0\0\x23\x01\0\0\x06\x9c\0\0\x28\0\0\0\xb0\0\0\0\x23\x01\0\0\x10\
\x9c\0\0\x30\0\0\0\xb0\0\0\0\x23\x01\0\0\x14\x9c\0\0\x50\0\0\0\xb0\0\0\0\x23\
\x01\0\0\x10\x9c\0\0\x68\0\0\0\xb0\0\0\0\x65\x01\0\0\x0d\xa8\0\0\x70\0\0\0\xb0\
\0\0\0\x80\x01\0\0\x02\xb4\0\0\x88\0\0\0\xb0\0\0\0\xa5\x01\0\0\x02\xb8\0\0\xb8\
\0\0\0\xb0\0\0\0\xa5\x01\0\0\x1c\xb8\0\0\xd0\0\0\0\xb0\0\0\0\xa5\x01\0\0\x14\
\xb8\0\0\xd8\0\0\0\xb0\0\0\0\xde\0\0\0\x05\x94\0\0\xe7\x02\0\0\x19\0\0\0\0\0\0\
\0\xb0\0\0\0\xf2\x02\0\0\x16\xd4\0\0\x10\0\0\0\xb0\0\0\0\x23\x03\0\0\x12\xd8\0\
\0\x20\0\0\0\xb0\0\0\0\x23\x01\0\0\x06\xe8\0\0\x38\0\0\0\xb0\0\0\0\x23\x01\0\0\
\x10\xe8\0\0\x40\0\0\0\xb0\0\0\0\x23\x01\0\0\x14\xe8\0\0\x60\0\0\0\xb0\0\0\0\
\x23\x01\0\0\x10\xe8\0\0\x78\0\0\0\xb0\0\0\0\x50\x03\0\0\x0a\xf4\0\0\x80\0\0\0\
\xb0\0\0\0\x68\x03\0\0\x02\xfc\0\0\x90\0\0\0\xb0\0\0\0\x8a\x03\0\0\x0d\0\x01\0\
\xb8\0\0\0\xb0\0\0\0\xa6\x03\0\0\x06\x04\x01\0\xc0\0\0\0\xb0\0\0\0\xb6\x03\0\0\
\x12\x1c\x01\0\xd0\0\0\0\xb0\0\0\0\xd9\x03\0\0\x0b\x20\x01\0\xe8\0\0\0\xb0\0\0\
\0\xf1\x03\0\0\x18\x28\x01\0\x18\x01\0\0\xb0\0\0\0\xf1\x03\0\0\x02\x28\x01\0\
\x20\x01\0\0\xb0\0\0\0\x21\x04\0\0\x06\x2c\x01\0\x38\x01\0\0\xb0\0\0\0\x2c\x04\
\0\0\x02\x34\x01\0\x50\x01\0\0\x62\x04\0\0\x8f\x04\0\0\x08\x7c\0\0\x70\x01\0\0\
\x62\x04\0\0\xb5\x04\0\0\x06\x80\0\0\x88\x01\0\0\x62\x04\0\0\xbf\x04\0\0\x08\
\x8c\0\0\xb8\x01\0\0\x62\x04\0\0\xf8\x04\0\0\x0a\x90\0\0\xd8\x01\0\0\x62\x04\0\
\0\x14\x05\0\0\x09\x9c\0\0\xf0\x01\0\0\xb0\0\0\0\x3b\x05\0\0\x06\x3c\x01\0\xf8\
\x01\0\0\xb0\0\0\0\x47\x05\0\0\x18\x44\x01\0\x10\x02\0\0\xb0\0\0\0\x47\x05\0\0\
\x02\x44\x01\0\x18\x02\0\0\xb0\0\0\0\x75\x05\0\0\x01\x4c\x01\0\0\0\0\0\0\0\0\0\
\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x03\0\x03\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
\0\0\0\0\0\0\0\x03\0\x05\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x62\0\0\0\x01\0\x07\
\0\x6c\x02\0\0\0\0\0\0\x68\0\0\0\0\0\0\0\0\0\0\0\x03\0\x07\0\0\0\0\0\0\0\0\0\0\
\0\0\0\0\0\0\0\x16\0\0\0\x12\0\x03\0\0\0\0\0\0\0\0\0\xe8\0\0\0\0\0\0\0\x75\0\0\
\0\x11\0\x07\0\x68\x02\0\0\0\0\0\0\x01\0\0\0\0\0\0\0\x57\0\0\0\x11\0\x08\0\0\0\
\0\0\0\0\0\0\x20\0\0\0\0\0\0\0\x01\0\0\0\x11\0\x07\0\0\0\0\0\0\0\0\0\0\x02\0\0\
\0\0\0\0\x87\0\0\0\x12\0\x05\0\0\0\0\0\0\0\0\0\x28\x02\0\0\0\0\0\0\x91\0\0\0\
\x11\0\x07\0\0\x02\0\0\0\0\0\0\x68\0\0\0\0\0\0\0\x46\0\0\0\x11\0\x08\0\x20\0\0\
\0\0\0\0\0\x20\0\0\0\0\0\0\0\xb2\0\0\0\x11\0\x09\0\0\0\0\0\0\0\0\0\x04\0\0\0\0\
\0\0\0\x10\0\0\0\0\0\0\0\x01\0\0\0\x06\0\0\0\x30\0\0\0\0\0\0\0\x01\0\0\0\x07\0\
\0\0\xa0\0\0\0\0\0\0\0\x01\0\0\0\x08\0\0\0\x20\0\0\0\0\0\0\0\x01\0\0\0\x06\0\0\
\0\x40\0\0\0\0\0\0\0\x01\0\0\0\x07\0\0\0\x98\0\0\0\0\0\0\0\x01\0\0\0\x08\0\0\0\
\xe8\0\0\0\0\0\0\0\x01\0\0\0\x0a\0\0\0\x50\x01\0\0\0\0\0\0\x01\0\0\0\x0b\0\0\0\
\x88\x01\0\0\0\0\0\0\x01\0\0\0\x0b\0\0\0\x98\x01\0\0\0\0\0\0\x01\0\0\0\x04\0\0\
\0\xd8\x01\0\0\0\0\0\0\x01\0\0\0\x0b\0\0\0\xb4\x05\0\0\0\0\0\0\x04\0\0\0\x08\0\
\0\0\xc0\x05\0\0\0\0\0\0\x04\0\0\0\x0a\0\0\0\xcc\x05\0\0\0\0\0\0\x04\0\0\0\x06\
\0\0\0\xd8\x05\0\0\0\0\0\0\x04\0\0\0\x04\0\0\0\xf0\x05\0\0\0\0\0\0\x04\0\0\0\
\x07\0\0\0\xfc\x05\0\0\0\0\0\0\x04\0\0\0\x0b\0\0\0\x14\x06\0\0\0\0\0\0\x04\0\0\
\0\x0c\0\0\0\x2c\0\0\0\0\0\0\0\x04\0\0\0\x01\0\0\0\x3c\0\0\0\0\0\0\0\x04\0\0\0\
\x02\0\0\0\x50\0\0\0\0\0\0\0\x04\0\0\0\x01\0\0\0\x60\0\0\0\0\0\0\0\x04\0\0\0\
\x01\0\0\0\x70\0\0\0\0\0\0\0\x04\0\0\0\x01\0\0\0\x80\0\0\0\0\0\0\0\x04\0\0\0\
\x01\0\0\0\x90\0\0\0\0\0\0\0\x04\0\0\0\x01\0\0\0\xa0\0\0\0\0\0\0\0\x04\0\0\0\
\x01\0\0\0\xb0\0\0\0\0\0\0\0\x04\0\0\0\x01\0\0\0\xc0\0\0\0\0\0\0\0\x04\0\0\0\
\x01\0\0\0\xd0\0\0\0\0\0\0\0\x04\0\0\0\x01\0\0\0\xe0\0\0\0\0\0\0\0\x04\0\0\0\
\x01\0\0\0\xf0\0\0\0\0\0\0\0\x04\0\0\0\x01\0\0\0\x08\x01\0\0\0\0\0\0\x04\0\0\0\
\x02\0\0\0\x18\x01\0\0\0\0\0\0\x04\0\0\0\x02\0\0\0\x28\x01\0\0\0\0\0\0\x04\0\0\
\0\x02\0\0\0\x38\x01\0\0\0\0\0\0\x04\0\0\0\x02\0\0\0\x48\x01\0\0\0\0\0\0\x04\0\
\0\0\x02\0\0\0\x58\x01\0\0\0\0\0\0\x04\0\0\0\x02\0\0\0\x68\x01\0\0\0\0\0\0\x04\
\0\0\0\x02\0\0\0\x78\x01\0\0\0\0\0\0\x04\0\0\0\x02\0\0\0\x88\x01\0\0\0\0\0\0\
\x04\0\0\0\x02\0\0\0\x98\x01\0\0\0\0\0\0\x04\0\0\0\x02\0\0\0\xa8\x01\0\0\0\0\0\
\0\x04\0\0\0\x02\0\0\0\xb8\x01\0\0\0\0\0\0\x04\0\0\0\x02\0\0\0\xc8\x01\0\0\0\0\
\0\0\x04\0\0\0\x02\0\0\0\xd8\x01\0\0\0\0\0\0\x04\0\0\0\x02\0\0\0\xe8\x01\0\0\0\
\0\0\0\x04\0\0\0\x02\0\0\0\xf8\x01\0\0\0\0\0\0\x04\0\0\0\x02\0\0\0\x08\x02\0\0\
\0\0\0\0\x04\0\0\0\x02\0\0\0\x18\x02\0\0\0\0\0\0\x04\0\0\0\x02\0\0\0\x28\x02\0\
\0\0\0\0\0\x04\0\0\0\x02\0\0\0\x38\x02\0\0\0\0\0\0\x04\0\0\0\x02\0\0\0\x48\x02\
\0\0\0\0\0\0\x04\0\0\0\x02\0\0\0\x58\x02\0\0\0\0\0\0\x04\0\0\0\x02\0\0\0\x68\
\x02\0\0\0\0\0\0\x04\0\0\0\x02\0\0\0\x78\x02\0\0\0\0\0\0\x04\0\0\0\x02\0\0\0\
\x88\x02\0\0\0\0\0\0\x04\0\0\0\x02\0\0\0\x0f\x13\x14\x11\x15\x04\x16\0\x66\x72\
\x65\x71\x73\x5f\x6d\x68\x7a\0\x2e\x72\x65\x6c\x74\x70\x5f\x62\x74\x66\x2f\x63\
\x70\x75\x5f\x66\x72\x65\x71\x75\x65\x6e\x63\x79\0\x2e\x74\x65\x78\x74\0\x2e\
\x72\x65\x6c\x2e\x42\x54\x46\x2e\x65\x78\x74\0\x2e\x72\x65\x6c\x70\x65\x72\x66\
\x5f\x65\x76\x65\x6e\x74\0\x68\x69\x73\x74\x73\0\x2e\x62\x73\x73\0\x2e\x6d\x61\
\x70\x73\0\x63\x67\x72\x6f\x75\x70\x5f\x6d\x61\x70\0\x7a\x65\x72\x6f\0\x2e\x6c\
\x6c\x76\x6d\x5f\x61\x64\x64\x72\x73\x69\x67\0\x66\x69\x6c\x74\x65\x72\x5f\x63\
\x67\0\x6c\x69\x63\x65\x6e\x73\x65\0\x64\x6f\x5f\x73\x61\x6d\x70\x6c\x65\0\x73\
\x79\x73\x77\x69\x64\x65\0\x2e\x73\x74\x72\x74\x61\x62\0\x2e\x73\x79\x6d\x74\
\x61\x62\0\x2e\x72\x65\x6c\x2e\x42\x54\x46\0\x4c\x49\x43\x45\x4e\x53\x45\0\0\0\
\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x99\0\0\0\x03\0\0\
\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xc7\x16\0\0\0\0\0\0\xba\0\0\0\0\0\0\0\0\0\0\
\0\0\0\0\0\x01\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x24\0\0\0\x01\0\0\0\x06\0\0\0\0\0\
\0\0\0\0\0\0\0\0\0\0\x40\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x04\0\0\
\0\0\0\0\0\0\0\0\0\0\0\0\0\x0f\0\0\0\x01\0\0\0\x06\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
\0\x40\0\0\0\0\0\0\0\xe8\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x08\0\0\0\0\0\0\0\0\0\0\
\0\0\0\0\0\x0b\0\0\0\x09\0\0\0\x40\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x40\x13\0\0\0\
\0\0\0\x30\0\0\0\0\0\0\0\x0f\0\0\0\x03\0\0\0\x08\0\0\0\0\0\0\0\x10\0\0\0\0\0\0\
\0\x3b\0\0\0\x01\0\0\0\x06\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x28\x01\0\0\0\0\0\0\
\x28\x02\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x08\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x37\0\0\
\0\x09\0\0\0\x40\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x70\x13\0\0\0\0\0\0\x80\0\0\0\0\
\0\0\0\x0f\0\0\0\x05\0\0\0\x08\0\0\0\0\0\0\0\x10\0\0\0\0\0\0\0\x4c\0\0\0\x08\0\
\0\0\x03\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x50\x03\0\0\0\0\0\0\xd4\x02\0\0\0\0\0\0\
\0\0\0\0\0\0\0\0\x04\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x51\0\0\0\x01\0\0\0\x03\0\0\
\0\0\0\0\0\0\0\0\0\0\0\0\0\x50\x03\0\0\0\0\0\0\x40\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
\0\x08\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x7f\0\0\0\x01\0\0\0\x03\0\0\0\0\0\0\0\0\0\
\0\0\0\0\0\0\x90\x03\0\0\0\0\0\0\x04\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x01\0\0\0\0\
\0\0\0\0\0\0\0\0\0\0\0\xad\0\0\0\x01\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x94\
\x03\0\0\0\0\0\0\xda\x0b\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x04\0\0\0\0\0\0\0\0\0\0\0\
\0\0\0\0\xa9\0\0\0\x09\0\0\0\x40\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xf0\x13\0\0\0\0\
\0\0\x70\0\0\0\0\0\0\0\x0f\0\0\0\x0a\0\0\0\x08\0\0\0\0\0\0\0\x10\0\0\0\0\0\0\0\
\x2e\0\0\0\x01\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x70\x0f\0\0\0\0\0\0\x98\
\x02\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x04\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x2a\0\0\0\
\x09\0\0\0\x40\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x60\x14\0\0\0\0\0\0\x60\x02\0\0\0\
\0\0\0\x0f\0\0\0\x0c\0\0\0\x08\0\0\0\0\0\0\0\x10\0\0\0\0\0\0\0\x67\0\0\0\x03\
\x4c\xff\x6f\0\0\0\x80\0\0\0\0\0\0\0\0\0\0\0\0\xc0\x16\0\0\0\0\0\0\x07\0\0\0\0\
\0\0\0\0\0\0\0\0\0\0\0\x01\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xa1\0\0\0\x02\0\0\0\0\
\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x08\x12\0\0\0\0\0\0\x38\x01\0\0\0\0\0\0\x01\0\0\
\0\x05\0\0\0\x08\0\0\0\0\0\0\0\x18\0\0\0\0\0\0\0";
}

#ifdef __cplusplus
struct cpufreq_bpf *cpufreq_bpf::open(const struct bpf_object_open_opts *opts) { return cpufreq_bpf__open_opts(opts); }
struct cpufreq_bpf *cpufreq_bpf::open_and_load() { return cpufreq_bpf__open_and_load(); }
int cpufreq_bpf::load(struct cpufreq_bpf *skel) { return cpufreq_bpf__load(skel); }
int cpufreq_bpf::attach(struct cpufreq_bpf *skel) { return cpufreq_bpf__attach(skel); }
void cpufreq_bpf::detach(struct cpufreq_bpf *skel) { cpufreq_bpf__detach(skel); }
void cpufreq_bpf::destroy(struct cpufreq_bpf *skel) { cpufreq_bpf__destroy(skel); }
const void *cpufreq_bpf::elf_bytes(size_t *sz) { return cpufreq_bpf__elf_bytes(sz); }
#endif /* __cplusplus */

__attribute__((unused)) static void
cpufreq_bpf__assert(struct cpufreq_bpf *s __attribute__((unused)))
{
#ifdef __cplusplus
#define _Static_assert static_assert
#endif
	_Static_assert(sizeof(s->bss->freqs_mhz) == 512, "unexpected size of 'freqs_mhz'");
	_Static_assert(sizeof(s->bss->syswide) == 104, "unexpected size of 'syswide'");
	_Static_assert(sizeof(s->bss->filter_cg) == 1, "unexpected size of 'filter_cg'");
#ifdef __cplusplus
#undef _Static_assert
#endif
}

#endif /* __CPUFREQ_BPF_SKEL_H__ */
